 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: BSEERR.CPY                                   */
 /*                                                                  */
 /*  NAME - BSEERR.CPY                                               */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    OS/2 base PL/I include file.                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The following symbols are used for conditional includes          */
 /*                                                                  */
 /*   INCL_DOSERRORS -  OS/2 Errors       - only included if needed  */
 /*                                                                  */
 /*==================================================================*/
 %if INCL_ERRORS='Y' %then %do;
   %INCL_DOSERRORS='Y';
   %INCL_ERROR_H='Y';
   %INCL_ERROR2_H='Y';
 %end;
 %if INCL_DOSERRORS='Y' | INCL_ERROR_H='Y' %then %do;
   %dcl NO_ERROR char;
   %NO_ERROR=0;
   %dcl ERROR_INVALID_FUNCTION char;
   %ERROR_INVALID_FUNCTION=1;
   %dcl ERROR_FILE_NOT_FOUND char;
   %ERROR_FILE_NOT_FOUND=2;
   %dcl ERROR_PATH_NOT_FOUND char;
   %ERROR_PATH_NOT_FOUND=3;
   %dcl ERROR_TOO_MANY_OPEN_FILES char;
   %ERROR_TOO_MANY_OPEN_FILES=4;
   %dcl ERROR_ACCESS_DENIED char;
   %ERROR_ACCESS_DENIED=5;
   %dcl ERROR_INVALID_HANDLE char;
   %ERROR_INVALID_HANDLE=6;
   %dcl ERROR_ARENA_TRASHED char;
   %ERROR_ARENA_TRASHED=7;
   %dcl ERROR_NOT_ENOUGH_MEMORY char;
   %ERROR_NOT_ENOUGH_MEMORY=8;
   %dcl ERROR_INVALID_BLOCK char;
   %ERROR_INVALID_BLOCK=9;
   %dcl ERROR_BAD_ENVIRONMENT char;
   %ERROR_BAD_ENVIRONMENT=10;
   %dcl ERROR_BAD_FORMAT char;
   %ERROR_BAD_FORMAT=11;
   %dcl ERROR_INVALID_ACCESS char;
   %ERROR_INVALID_ACCESS=12;
   %dcl ERROR_INVALID_DATA char;
   %ERROR_INVALID_DATA=13;
   %dcl ERROR_INVALID_DRIVE char;
   %ERROR_INVALID_DRIVE=15;
   %dcl ERROR_CURRENT_DIRECTORY char;
   %ERROR_CURRENT_DIRECTORY=16;
   %dcl ERROR_NOT_SAME_DEVICE char;
   %ERROR_NOT_SAME_DEVICE=17;
   %dcl ERROR_NO_MORE_FILES char;
   %ERROR_NO_MORE_FILES=18;
   %dcl ERROR_WRITE_PROTECT char;
   %ERROR_WRITE_PROTECT=19;
   %dcl ERROR_BAD_UNIT char;
   %ERROR_BAD_UNIT=20;
   %dcl ERROR_NOT_READY char;
   %ERROR_NOT_READY=21;
   %dcl ERROR_BAD_COMMAND char;
   %ERROR_BAD_COMMAND=22;
   %dcl ERROR_CRC char;
   %ERROR_CRC=23;
   %dcl ERROR_BAD_LENGTH char;
   %ERROR_BAD_LENGTH=24;
   %dcl ERROR_SEEK char;
   %ERROR_SEEK=25;
   %dcl ERROR_NOT_DOS_DISK char;
   %ERROR_NOT_DOS_DISK=26;
   %dcl ERROR_SECTOR_NOT_FOUND char;
   %ERROR_SECTOR_NOT_FOUND=27;
   %dcl ERROR_OUT_OF_PAPER char;
   %ERROR_OUT_OF_PAPER=28;
   %dcl ERROR_WRITE_FAULT char;
   %ERROR_WRITE_FAULT=29;
   %dcl ERROR_READ_FAULT char;
   %ERROR_READ_FAULT=30;
   %dcl ERROR_GEN_FAILURE char;
   %ERROR_GEN_FAILURE=31;
   %dcl ERROR_SHARING_VIOLATION char;
   %ERROR_SHARING_VIOLATION=32;
   %dcl ERROR_LOCK_VIOLATION char;
   %ERROR_LOCK_VIOLATION=33;
   %dcl ERROR_WRONG_DISK char;
   %ERROR_WRONG_DISK=34;
   %dcl ERROR_FCB_UNAVAILABLE char;
   %ERROR_FCB_UNAVAILABLE=35;
   %dcl ERROR_SHARING_BUFFER_EXCEEDED char;
   %ERROR_SHARING_BUFFER_EXCEEDED=36;
   %dcl ERROR_CODE_PAGE_MISMATCHED char;
   %ERROR_CODE_PAGE_MISMATCHED=37;
   %dcl ERROR_HANDLE_EOF char;
   %ERROR_HANDLE_EOF=38;
   %dcl ERROR_HANDLE_DISK_FULL char;
   %ERROR_HANDLE_DISK_FULL=39;
   %dcl ERROR_NOT_SUPPORTED char;
   %ERROR_NOT_SUPPORTED=50;
   %dcl ERROR_REM_NOT_LIST char;
   %ERROR_REM_NOT_LIST=51;
   %dcl ERROR_DUP_NAME char;
   %ERROR_DUP_NAME=52;
   %dcl ERROR_BAD_NETPATH char;
   %ERROR_BAD_NETPATH=53;
   %dcl ERROR_NETWORK_BUSY char;
   %ERROR_NETWORK_BUSY=54;
   %dcl ERROR_DEV_NOT_EXIST char;
   %ERROR_DEV_NOT_EXIST=55;
   %dcl ERROR_TOO_MANY_CMDS char;
   %ERROR_TOO_MANY_CMDS=56;
   %dcl ERROR_ADAP_HDW_ERR char;
   %ERROR_ADAP_HDW_ERR=57;
   %dcl ERROR_BAD_NET_RESP char;
   %ERROR_BAD_NET_RESP=58;
   %dcl ERROR_UNEXP_NET_ERR char;
   %ERROR_UNEXP_NET_ERR=59;
   %dcl ERROR_BAD_REM_ADAP char;
   %ERROR_BAD_REM_ADAP=60;
   %dcl ERROR_PRINTQ_FULL char;
   %ERROR_PRINTQ_FULL=61;
   %dcl ERROR_NO_SPOOL_SPACE char;
   %ERROR_NO_SPOOL_SPACE=62;
   %dcl ERROR_PRINT_CANCELLED char;
   %ERROR_PRINT_CANCELLED=63;
   %dcl ERROR_NETNAME_DELETED char;
   %ERROR_NETNAME_DELETED=64;
   %dcl ERROR_NETWORK_ACCESS_DENIED char;
   %ERROR_NETWORK_ACCESS_DENIED=65;
   %dcl ERROR_BAD_DEV_TYPE char;
   %ERROR_BAD_DEV_TYPE=66;
   %dcl ERROR_BAD_NET_NAME char;
   %ERROR_BAD_NET_NAME=67;
   %dcl ERROR_TOO_MANY_NAMES char;
   %ERROR_TOO_MANY_NAMES=68;
   %dcl ERROR_TOO_MANY_SESS char;
   %ERROR_TOO_MANY_SESS=69;
   %dcl ERROR_SHARING_PAUSED char;
   %ERROR_SHARING_PAUSED=70;
   %dcl ERROR_REQ_NOT_ACCEP char;
   %ERROR_REQ_NOT_ACCEP=71;
   %dcl ERROR_REDIR_PAUSED char;
   %ERROR_REDIR_PAUSED=72;
   %dcl ERROR_SBCS_ATT_WRITE_PROT char;
   %ERROR_SBCS_ATT_WRITE_PROT=73;
   %dcl ERROR_SBCS_GENERAL_FAILURE char;
   %ERROR_SBCS_GENERAL_FAILURE=74;
   %dcl ERROR_XGA_OUT_MEMORY char;
   %ERROR_XGA_OUT_MEMORY=75;
   %dcl ERROR_FILE_EXISTS char;
   %ERROR_FILE_EXISTS=80;
   %dcl ERROR_DUP_FCB char;
   %ERROR_DUP_FCB=81;
   %dcl ERROR_CANNOT_MAKE char;
   %ERROR_CANNOT_MAKE=82;
   %dcl ERROR_FAIL_I24 char;
   %ERROR_FAIL_I24=83;
   %dcl ERROR_OUT_OF_STRUCTURES char;
   %ERROR_OUT_OF_STRUCTURES=84;
   %dcl ERROR_ALREADY_ASSIGNED char;
   %ERROR_ALREADY_ASSIGNED=85;
   %dcl ERROR_INVALID_PASSWORD char;
   %ERROR_INVALID_PASSWORD=86;
   %dcl ERROR_INVALID_PARAMETER char;
   %ERROR_INVALID_PARAMETER=87;
   %dcl ERROR_NET_WRITE_FAULT char;
   %ERROR_NET_WRITE_FAULT=88;
   %dcl ERROR_NO_PROC_SLOTS char;
   %ERROR_NO_PROC_SLOTS=89;
   %dcl ERROR_NOT_FROZEN char;
   %ERROR_NOT_FROZEN=90;
   %dcl ERROR_SYS_COMP_NOT_LOADED char;
   %ERROR_SYS_COMP_NOT_LOADED=ERROR_NOT_FROZEN;
   %dcl ERR_TSTOVFL char;
   %ERR_TSTOVFL=91;
   %dcl ERR_TSTDUP char;
   %ERR_TSTDUP=92;
   %dcl ERROR_NO_ITEMS char;
   %ERROR_NO_ITEMS=93;
   %dcl ERROR_INTERRUPT char;
   %ERROR_INTERRUPT=95;
   %dcl ERROR_DEVICE_IN_USE char;
   %ERROR_DEVICE_IN_USE=99;
   %dcl ERROR_TOO_MANY_SEMAPHORES char;
   %ERROR_TOO_MANY_SEMAPHORES=100;
   %dcl ERROR_EXCL_SEM_ALREADY_OWNED char;
   %ERROR_EXCL_SEM_ALREADY_OWNED=101;
   %dcl ERROR_SEM_IS_SET char;
   %ERROR_SEM_IS_SET=102;
   %dcl ERROR_TOO_MANY_SEM_REQUESTS char;
   %ERROR_TOO_MANY_SEM_REQUESTS=103;
   %dcl ERROR_INVALID_AT_INTERRUPT_TIME char;
   %ERROR_INVALID_AT_INTERRUPT_TIME=104;
   %dcl ERROR_SEM_OWNER_DIED char;
   %ERROR_SEM_OWNER_DIED=105;
   %dcl ERROR_SEM_USER_LIMIT char;
   %ERROR_SEM_USER_LIMIT=106;
   %dcl ERROR_DISK_CHANGE char;
   %ERROR_DISK_CHANGE=107;
   %dcl ERROR_DRIVE_LOCKED char;
   %ERROR_DRIVE_LOCKED=108;
   %dcl ERROR_BROKEN_PIPE char;
   %ERROR_BROKEN_PIPE=109;
   %dcl ERROR_OPEN_FAILED char;
   %ERROR_OPEN_FAILED=110;
   %dcl ERROR_BUFFER_OVERFLOW char;
   %ERROR_BUFFER_OVERFLOW=111;
   %dcl ERROR_DISK_FULL char;
   %ERROR_DISK_FULL=112;
   %dcl ERROR_NO_MORE_SEARCH_HANDLES char;
   %ERROR_NO_MORE_SEARCH_HANDLES=113;
   %dcl ERROR_INVALID_TARGET_HANDLE char;
   %ERROR_INVALID_TARGET_HANDLE=114;
   %dcl ERROR_PROTECTION_VIOLATION char;
   %ERROR_PROTECTION_VIOLATION=115;
   %dcl ERROR_VIOKBD_REQUEST char;
   %ERROR_VIOKBD_REQUEST=116;
   %dcl ERROR_INVALID_CATEGORY char;
   %ERROR_INVALID_CATEGORY=117;
   %dcl ERROR_INVALID_VERIFY_SWITCH char;
   %ERROR_INVALID_VERIFY_SWITCH=118;
   %dcl ERROR_BAD_DRIVER_LEVEL char;
   %ERROR_BAD_DRIVER_LEVEL=119;
   %dcl ERROR_CALL_NOT_IMPLEMENTED char;
   %ERROR_CALL_NOT_IMPLEMENTED=120;
   %dcl ERROR_SEM_TIMEOUT char;
   %ERROR_SEM_TIMEOUT=121;
   %dcl ERROR_INSUFFICIENT_BUFFER char;
   %ERROR_INSUFFICIENT_BUFFER=122;
   %dcl ERROR_INVALID_NAME char;
   %ERROR_INVALID_NAME=123;
   %dcl ERROR_INVALID_LEVEL char;
   %ERROR_INVALID_LEVEL=124;
   %dcl ERROR_NO_VOLUME_LABEL char;
   %ERROR_NO_VOLUME_LABEL=125;
   %dcl ERROR_MOD_NOT_FOUND char;
   %ERROR_MOD_NOT_FOUND=126;
   %dcl ERROR_PROC_NOT_FOUND char;
   %ERROR_PROC_NOT_FOUND=127;
   %dcl ERROR_WAIT_NO_CHILDREN char;
   %ERROR_WAIT_NO_CHILDREN=128;
   %dcl ERROR_CHILD_NOT_COMPLETE char;
   %ERROR_CHILD_NOT_COMPLETE=129;
   %dcl ERROR_DIRECT_ACCESS_HANDLE char;
   %ERROR_DIRECT_ACCESS_HANDLE=130;
   %dcl ERROR_NEGATIVE_SEEK char;
   %ERROR_NEGATIVE_SEEK=131;
   %dcl ERROR_SEEK_ON_DEVICE char;
   %ERROR_SEEK_ON_DEVICE=132;
   %dcl ERROR_IS_JOIN_TARGET char;
   %ERROR_IS_JOIN_TARGET=133;
   %dcl ERROR_IS_JOINED char;
   %ERROR_IS_JOINED=134;
   %dcl ERROR_IS_SUBSTED char;
   %ERROR_IS_SUBSTED=135;
   %dcl ERROR_NOT_JOINED char;
   %ERROR_NOT_JOINED=136;
   %dcl ERROR_NOT_SUBSTED char;
   %ERROR_NOT_SUBSTED=137;
   %dcl ERROR_JOIN_TO_JOIN char;
   %ERROR_JOIN_TO_JOIN=138;
   %dcl ERROR_SUBST_TO_SUBST char;
   %ERROR_SUBST_TO_SUBST=139;
   %dcl ERROR_JOIN_TO_SUBST char;
   %ERROR_JOIN_TO_SUBST=140;
   %dcl ERROR_SUBST_TO_JOIN char;
   %ERROR_SUBST_TO_JOIN=141;
   %dcl ERROR_BUSY_DRIVE char;
   %ERROR_BUSY_DRIVE=142;
   %dcl ERROR_SAME_DRIVE char;
   %ERROR_SAME_DRIVE=143;
   %dcl ERROR_DIR_NOT_ROOT char;
   %ERROR_DIR_NOT_ROOT=144;
   %dcl ERROR_DIR_NOT_EMPTY char;
   %ERROR_DIR_NOT_EMPTY=145;
   %dcl ERROR_IS_SUBST_PATH char;
   %ERROR_IS_SUBST_PATH=146;
   %dcl ERROR_IS_JOIN_PATH char;
   %ERROR_IS_JOIN_PATH=147;
   %dcl ERROR_PATH_BUSY char;
   %ERROR_PATH_BUSY=148;
   %dcl ERROR_IS_SUBST_TARGET char;
   %ERROR_IS_SUBST_TARGET=149;
   %dcl ERROR_SYSTEM_TRACE char;
   %ERROR_SYSTEM_TRACE=150;
   %dcl ERROR_INVALID_EVENT_COUNT char;
   %ERROR_INVALID_EVENT_COUNT=151;
   %dcl ERROR_TOO_MANY_MUXWAITERS char;
   %ERROR_TOO_MANY_MUXWAITERS=152;
   %dcl ERROR_INVALID_LIST_FORMAT char;
   %ERROR_INVALID_LIST_FORMAT=153;
   %dcl ERROR_LABEL_TOO_LONG char;
   %ERROR_LABEL_TOO_LONG=154;
   %dcl ERROR_TOO_MANY_TCBS char;
   %ERROR_TOO_MANY_TCBS=155;
   %dcl ERROR_SIGNAL_REFUSED char;
   %ERROR_SIGNAL_REFUSED=156;
   %dcl ERROR_DISCARDED char;
   %ERROR_DISCARDED=157;
   %dcl ERROR_NOT_LOCKED char;
   %ERROR_NOT_LOCKED=158;
   %dcl ERROR_BAD_THREADID_ADDR char;
   %ERROR_BAD_THREADID_ADDR=159;
   %dcl ERROR_BAD_ARGUMENTS char;
   %ERROR_BAD_ARGUMENTS=160;
   %dcl ERROR_BAD_PATHNAME char;
   %ERROR_BAD_PATHNAME=161;
   %dcl ERROR_SIGNAL_PENDING char;
   %ERROR_SIGNAL_PENDING=162;
   %dcl ERROR_UNCERTAIN_MEDIA char;
   %ERROR_UNCERTAIN_MEDIA=163;
   %dcl ERROR_MAX_THRDS_REACHED char;
   %ERROR_MAX_THRDS_REACHED=164;
   %dcl ERROR_MONITORS_NOT_SUPPORTED char;
   %ERROR_MONITORS_NOT_SUPPORTED=165;
   %dcl ERROR_UNC_DRIVER_NOT_INSTALLED char;
   %ERROR_UNC_DRIVER_NOT_INSTALLED=166;
   %dcl ERROR_LOCK_FAILED char;
   %ERROR_LOCK_FAILED=167;
   %dcl ERROR_SWAPIO_FAILED char;
   %ERROR_SWAPIO_FAILED=168;
   %dcl ERROR_SWAPIN_FAILED char;
   %ERROR_SWAPIN_FAILED=169;
   %dcl ERROR_BUSY char;
   %ERROR_BUSY=170;
   %dcl ERROR_CANCEL_VIOLATION char;
   %ERROR_CANCEL_VIOLATION=173;
   %dcl ERROR_ATOMIC_LOCK_NOT_SUPPORTED char;
   %ERROR_ATOMIC_LOCK_NOT_SUPPORTED=174;
   %dcl ERROR_READ_LOCKS_NOT_SUPPORTED char;
   %ERROR_READ_LOCKS_NOT_SUPPORTED=175;
   %dcl ERROR_INVALID_SEGMENT_NUMBER char;
   %ERROR_INVALID_SEGMENT_NUMBER=180;
   %dcl ERROR_INVALID_CALLGATE char;
   %ERROR_INVALID_CALLGATE=181;
   %dcl ERROR_INVALID_ORDINAL char;
   %ERROR_INVALID_ORDINAL=182;
   %dcl ERROR_ALREADY_EXISTS char;
   %ERROR_ALREADY_EXISTS=183;
   %dcl ERROR_NO_CHILD_PROCESS char;
   %ERROR_NO_CHILD_PROCESS=184;
   %dcl ERROR_CHILD_ALIVE_NOWAIT char;
   %ERROR_CHILD_ALIVE_NOWAIT=185;
   %dcl ERROR_INVALID_FLAG_NUMBER char;
   %ERROR_INVALID_FLAG_NUMBER=186;
   %dcl ERROR_SEM_NOT_FOUND char;
   %ERROR_SEM_NOT_FOUND=187;
   %dcl ERROR_INVALID_STARTING_CODESEG char;
   %ERROR_INVALID_STARTING_CODESEG=188;
   %dcl ERROR_INVALID_STACKSEG char;
   %ERROR_INVALID_STACKSEG=189;
   %dcl ERROR_INVALID_MODULETYPE char;
   %ERROR_INVALID_MODULETYPE=190;
   %dcl ERROR_INVALID_EXE_SIGNATURE char;
   %ERROR_INVALID_EXE_SIGNATURE=191;
   %dcl ERROR_EXE_MARKED_INVALID char;
   %ERROR_EXE_MARKED_INVALID=192;
   %dcl ERROR_BAD_EXE_FORMAT char;
   %ERROR_BAD_EXE_FORMAT=193;
   %dcl ERROR_ITERATED_DATA_EXCEEDS_64k char;
   %ERROR_ITERATED_DATA_EXCEEDS_64k=194;
   %dcl ERROR_INVALID_MINALLOCSIZE char;
   %ERROR_INVALID_MINALLOCSIZE=195;
   %dcl ERROR_DYNLINK_FROM_INVALID_RING char;
   %ERROR_DYNLINK_FROM_INVALID_RING=196;
   %dcl ERROR_IOPL_NOT_ENABLED char;
   %ERROR_IOPL_NOT_ENABLED=197;
   %dcl ERROR_INVALID_SEGDPL char;
   %ERROR_INVALID_SEGDPL=198;
   %dcl ERROR_AUTODATASEG_EXCEEDS_64k char;
   %ERROR_AUTODATASEG_EXCEEDS_64k=199;
   %dcl ERROR_RING2SEG_MUST_BE_MOVABLE char;
   %ERROR_RING2SEG_MUST_BE_MOVABLE=200;
   %dcl ERROR_RELOC_CHAIN_XEEDS_SEGLIM char;
   %ERROR_RELOC_CHAIN_XEEDS_SEGLIM=201;
   %dcl ERROR_INFLOOP_IN_RELOC_CHAIN char;
   %ERROR_INFLOOP_IN_RELOC_CHAIN=202;
   %dcl ERROR_ENVVAR_NOT_FOUND char;
   %ERROR_ENVVAR_NOT_FOUND=203;
   %dcl ERROR_NOT_CURRENT_CTRY char;
   %ERROR_NOT_CURRENT_CTRY=204;
   %dcl ERROR_NO_SIGNAL_SENT char;
   %ERROR_NO_SIGNAL_SENT=205;
   %dcl ERROR_FILENAME_EXCED_RANGE char;
   %ERROR_FILENAME_EXCED_RANGE=206;
   %dcl ERROR_RING2_STACK_IN_USE char;
   %ERROR_RING2_STACK_IN_USE=207;
   %dcl ERROR_META_EXPANSION_TOO_LONG char;
   %ERROR_META_EXPANSION_TOO_LONG=208;
   %dcl ERROR_INVALID_SIGNAL_NUMBER char;
   %ERROR_INVALID_SIGNAL_NUMBER=209;
   %dcl ERROR_THREAD_1_INACTIVE char;
   %ERROR_THREAD_1_INACTIVE=210;
   %dcl ERROR_INFO_NOT_AVAIL char;
   %ERROR_INFO_NOT_AVAIL=211;
   %dcl ERROR_LOCKED char;
   %ERROR_LOCKED=212;
   %dcl ERROR_BAD_DYNALINK char;
   %ERROR_BAD_DYNALINK=213;
   %dcl ERROR_TOO_MANY_MODULES char;
   %ERROR_TOO_MANY_MODULES=214;
   %dcl ERROR_NESTING_NOT_ALLOWED char;
   %ERROR_NESTING_NOT_ALLOWED=215;
   %dcl ERROR_CANNOT_SHRINK char;
   %ERROR_CANNOT_SHRINK=216;
   %dcl ERROR_ZOMBIE_PROCESS char;
   %ERROR_ZOMBIE_PROCESS=217;
   %dcl ERROR_STACK_IN_HIGH_MEMORY char;
   %ERROR_STACK_IN_HIGH_MEMORY=218;
   %dcl ERROR_INVALID_EXITROUTINE_RING char;
   %ERROR_INVALID_EXITROUTINE_RING=219;
   %dcl ERROR_GETBUF_FAILED char;
   %ERROR_GETBUF_FAILED=220;
   %dcl ERROR_FLUSHBUF_FAILED char;
   %ERROR_FLUSHBUF_FAILED=221;
   %dcl ERROR_TRANSFER_TOO_LONG char;
   %ERROR_TRANSFER_TOO_LONG=222;
   %dcl ERROR_FORCENOSWAP_FAILED char;
   %ERROR_FORCENOSWAP_FAILED=223;
   %dcl ERROR_SMG_NO_TARGET_WINDOW char;
   %ERROR_SMG_NO_TARGET_WINDOW=224;
   %dcl ERROR_NO_CHILDREN char;
   %ERROR_NO_CHILDREN=228;
   %dcl ERROR_INVALID_SCREEN_GROUP char;
   %ERROR_INVALID_SCREEN_GROUP=229;
   %dcl ERROR_BAD_PIPE char;
   %ERROR_BAD_PIPE=230;
   %dcl ERROR_PIPE_BUSY char;
   %ERROR_PIPE_BUSY=231;
   %dcl ERROR_NO_DATA char;
   %ERROR_NO_DATA=232;
   %dcl ERROR_PIPE_NOT_CONNECTED char;
   %ERROR_PIPE_NOT_CONNECTED=233;
   %dcl ERROR_MORE_DATA char;
   %ERROR_MORE_DATA=234;
   %dcl ERROR_VC_DISCONNECTED char;
   %ERROR_VC_DISCONNECTED=240;
   %dcl ERROR_CIRCULARITY_REQUESTED char;
   %ERROR_CIRCULARITY_REQUESTED=250;
   %dcl ERROR_DIRECTORY_IN_CDS char;
   %ERROR_DIRECTORY_IN_CDS=251;
   %dcl ERROR_INVALID_FSD_NAME char;
   %ERROR_INVALID_FSD_NAME=252;
   %dcl ERROR_INVALID_PATH char;
   %ERROR_INVALID_PATH=253;
   %dcl ERROR_INVALID_EA_NAME char;
   %ERROR_INVALID_EA_NAME=254;
   %dcl ERROR_EA_LIST_INCONSISTENT char;
   %ERROR_EA_LIST_INCONSISTENT=255;
   %dcl ERROR_EA_LIST_TOO_LONG char;
   %ERROR_EA_LIST_TOO_LONG=256;
   %dcl ERROR_NO_META_MATCH char;
   %ERROR_NO_META_MATCH=257;
   %dcl ERROR_FINDNOTIFY_TIMEOUT char;
   %ERROR_FINDNOTIFY_TIMEOUT=258;
   %dcl ERROR_NO_MORE_ITEMS char;
   %ERROR_NO_MORE_ITEMS=259;
   %dcl ERROR_SEARCH_STRUC_REUSED char;
   %ERROR_SEARCH_STRUC_REUSED=260;
   %dcl ERROR_CHAR_NOT_FOUND char;
   %ERROR_CHAR_NOT_FOUND=261;
   %dcl ERROR_TOO_MUCH_STACK char;
   %ERROR_TOO_MUCH_STACK=262;
   %dcl ERROR_INVALID_ATTR char;
   %ERROR_INVALID_ATTR=263;
   %dcl ERROR_INVALID_STARTING_RING char;
   %ERROR_INVALID_STARTING_RING=264;
   %dcl ERROR_INVALID_DLL_INIT_RING char;
   %ERROR_INVALID_DLL_INIT_RING=265;
   %dcl ERROR_CANNOT_COPY char;
   %ERROR_CANNOT_COPY=266;
   %dcl ERROR_DIRECTORY char;
   %ERROR_DIRECTORY=267;
   %dcl ERROR_OPLOCKED_FILE char;
   %ERROR_OPLOCKED_FILE=268;
   %dcl ERROR_OPLOCK_THREAD_EXISTS char;
   %ERROR_OPLOCK_THREAD_EXISTS=269;
   %dcl ERROR_VOLUME_CHANGED char;
   %ERROR_VOLUME_CHANGED=270;
   %dcl ERROR_FINDNOTIFY_HANDLE_IN_USE char;
   %ERROR_FINDNOTIFY_HANDLE_IN_USE=271;
   %dcl ERROR_FINDNOTIFY_HANDLE_CLOSED char;
   %ERROR_FINDNOTIFY_HANDLE_CLOSED=272;
   %dcl ERROR_NOTIFY_OBJECT_REMOVED char;
   %ERROR_NOTIFY_OBJECT_REMOVED=273;
   %dcl ERROR_ALREADY_SHUTDOWN char;
   %ERROR_ALREADY_SHUTDOWN=274;
   %dcl ERROR_EAS_DIDNT_FIT char;
   %ERROR_EAS_DIDNT_FIT=275;
   %dcl ERROR_EA_FILE_CORRUPT char;
   %ERROR_EA_FILE_CORRUPT=276;
   %dcl ERROR_EA_TABLE_FULL char;
   %ERROR_EA_TABLE_FULL=277;
   %dcl ERROR_INVALID_EA_HANDLE char;
   %ERROR_INVALID_EA_HANDLE=278;
   %dcl ERROR_NO_CLUSTER char;
   %ERROR_NO_CLUSTER=279;
   %dcl ERROR_CREATE_EA_FILE char;
   %ERROR_CREATE_EA_FILE=280;
   %dcl ERROR_CANNOT_OPEN_EA_FILE char;
   %ERROR_CANNOT_OPEN_EA_FILE=281;
   %dcl ERROR_EAS_NOT_SUPPORTED char;
   %ERROR_EAS_NOT_SUPPORTED=282;
   %dcl ERROR_NEED_EAS_FOUND char;
   %ERROR_NEED_EAS_FOUND=283;
   %dcl ERROR_DUPLICATE_HANDLE char;
   %ERROR_DUPLICATE_HANDLE=284;
   %dcl ERROR_DUPLICATE_NAME char;
   %ERROR_DUPLICATE_NAME=285;
   %dcl ERROR_EMPTY_MUXWAIT char;
   %ERROR_EMPTY_MUXWAIT=286;
   %dcl ERROR_MUTEX_OWNED char;
   %ERROR_MUTEX_OWNED=287;
   %dcl ERROR_NOT_OWNER char;
   %ERROR_NOT_OWNER=288;
   %dcl ERROR_PARAM_TOO_SMALL char;
   %ERROR_PARAM_TOO_SMALL=289;
   %dcl ERROR_TOO_MANY_HANDLES char;
   %ERROR_TOO_MANY_HANDLES=290;
   %dcl ERROR_TOO_MANY_OPENS char;
   %ERROR_TOO_MANY_OPENS=291;
   %dcl ERROR_WRONG_TYPE char;
   %ERROR_WRONG_TYPE=292;
   %dcl ERROR_UNUSED_CODE char;
   %ERROR_UNUSED_CODE=293;
   %dcl ERROR_THREAD_NOT_TERMINATED char;
   %ERROR_THREAD_NOT_TERMINATED=294;
   %dcl ERROR_INIT_ROUTINE_FAILED char;
   %ERROR_INIT_ROUTINE_FAILED=295;
   %dcl ERROR_MODULE_IN_USE char;
   %ERROR_MODULE_IN_USE=296;
   %dcl ERROR_NOT_ENOUGH_WATCHPOINTS char;
   %ERROR_NOT_ENOUGH_WATCHPOINTS=297;
   %dcl ERROR_TOO_MANY_POSTS char;
   %ERROR_TOO_MANY_POSTS=298;
   %dcl ERROR_ALREADY_POSTED char;
   %ERROR_ALREADY_POSTED=299;
   %dcl ERROR_ALREADY_RESET char;
   %ERROR_ALREADY_RESET=300;
   %dcl ERROR_SEM_BUSY char;
   %ERROR_SEM_BUSY=301;
   dcl ERROR_USER_DEFINED_BASE fixed bin(16) value('FF_00'xn);
   %dcl ERROR_I24_WRITE_PROTECT char;
   %ERROR_I24_WRITE_PROTECT=0;
   %dcl ERROR_I24_BAD_UNIT char;
   %ERROR_I24_BAD_UNIT=1;
   %dcl ERROR_I24_NOT_READY char;
   %ERROR_I24_NOT_READY=2;
   %dcl ERROR_I24_BAD_COMMAND char;
   %ERROR_I24_BAD_COMMAND=3;
   %dcl ERROR_I24_CRC char;
   %ERROR_I24_CRC=4;
   %dcl ERROR_I24_BAD_LENGTH char;
   %ERROR_I24_BAD_LENGTH=5;
   %dcl ERROR_I24_SEEK char;
   %ERROR_I24_SEEK=6;
   %dcl ERROR_I24_NOT_DOS_DISK char;
   %ERROR_I24_NOT_DOS_DISK=7;
   %dcl ERROR_I24_SECTOR_NOT_FOUND char;
   %ERROR_I24_SECTOR_NOT_FOUND=8;
   %dcl ERROR_I24_OUT_OF_PAPER char;
   %ERROR_I24_OUT_OF_PAPER=9;
   %dcl ERROR_I24_WRITE_FAULT char;
   %ERROR_I24_WRITE_FAULT=10;
   %dcl ERROR_I24_READ_FAULT char;
   %ERROR_I24_READ_FAULT=11;
   %dcl ERROR_I24_GEN_FAILURE char;
   %ERROR_I24_GEN_FAILURE=12;
   %dcl ERROR_I24_DISK_CHANGE char;
   %ERROR_I24_DISK_CHANGE=13;
   %dcl ERROR_I24_WRONG_DISK char;
   %ERROR_I24_WRONG_DISK=15;
   %dcl ERROR_I24_UNCERTAIN_MEDIA char;
   %ERROR_I24_UNCERTAIN_MEDIA=16;
   %dcl ERROR_I24_CHAR_CALL_INTERRUPTED char;
   %ERROR_I24_CHAR_CALL_INTERRUPTED=17;
   %dcl ERROR_I24_NO_MONITOR_SUPPORT char;
   %ERROR_I24_NO_MONITOR_SUPPORT=18;
   %dcl ERROR_I24_INVALID_PARAMETER char;
   %ERROR_I24_INVALID_PARAMETER=19;
   %dcl ERROR_I24_DEVICE_IN_USE char;
   %ERROR_I24_DEVICE_IN_USE=20;
   %dcl ERROR_I24_QUIET_INIT_FAIL char;
   %ERROR_I24_QUIET_INIT_FAIL=21;

   dcl ALLOWED_FAIL fixed bin(16) value('00_01'xn);
   dcl ALLOWED_ABORT  fixed bin(16) value('00_02'xn);
   dcl ALLOWED_RETRY  fixed bin(16) value('00_04'xn);
   dcl ALLOWED_IGNORE  fixed bin(16) value('00_08'xn);
   dcl ALLOWED_ACKNOWLEDGE  fixed bin(16) value('00_10'xn);
   dcl ALLOWED_DISPATCH  fixed bin(16) value('80_00'xn);
   dcl ALLOWED_REGDUMP  fixed bin(16) value('00_20'xn);
   dcl ALLOWED_DETACHED  fixed bin(16) value('80_00'xn);
   dcl I24_OPERATION  bit(8) value('00_00_00_01'b);
   dcl I24_AREA bit(8) value('00_00_01_10'b);
   dcl I24_CLASS bit(8) value('10_00_00_00'b);

   %dcl ERRCLASS_OUTRES char;
   %ERRCLASS_OUTRES=1;
   %dcl ERRCLASS_TEMPSIT char;
   %ERRCLASS_TEMPSIT=2;
   %dcl ERRCLASS_AUTH char;
   %ERRCLASS_AUTH=3;
   %dcl ERRCLASS_INTRN char;
   %ERRCLASS_INTRN=4;
   %dcl ERRCLASS_HRDFAIL char;
   %ERRCLASS_HRDFAIL=5;
   %dcl ERRCLASS_SYSFAIL char;
   %ERRCLASS_SYSFAIL=6;
   %dcl ERRCLASS_APPERR char;
   %ERRCLASS_APPERR=7;
   %dcl ERRCLASS_NOTFND char;
   %ERRCLASS_NOTFND=8;
   %dcl ERRCLASS_BADFMT char;
   %ERRCLASS_BADFMT=9;
   %dcl ERRCLASS_LOCKED char;
   %ERRCLASS_LOCKED=10;
   %dcl ERRCLASS_MEDIA char;
   %ERRCLASS_MEDIA=11;
   %dcl ERRCLASS_ALREADY char;
   %ERRCLASS_ALREADY=12;
   %dcl ERRCLASS_UNK char;
   %ERRCLASS_UNK=13;
   %dcl ERRCLASS_CANT char;
   %ERRCLASS_CANT=14;
   %dcl ERRCLASS_TIME char;
   %ERRCLASS_TIME=15;
   %dcl ERRACT_RETRY char;
   %ERRACT_RETRY=1;
   %dcl ERRACT_DLYRET char;
   %ERRACT_DLYRET=2;
   %dcl ERRACT_USER char;
   %ERRACT_USER=3;
   %dcl ERRACT_ABORT char;
   %ERRACT_ABORT=4;
   %dcl ERRACT_PANIC char;
   %ERRACT_PANIC=5;
   %dcl ERRACT_IGNORE char;
   %ERRACT_IGNORE=6;
   %dcl ERRACT_INTRET char;
   %ERRACT_INTRET=7;
   %dcl ERRLOC_UNK char;
   %ERRLOC_UNK=1;
   %dcl ERRLOC_DISK char;
   %ERRLOC_DISK=2;
   %dcl ERRLOC_NET char;
   %ERRLOC_NET=3;
   %dcl ERRLOC_SERDEV char;
   %ERRLOC_SERDEV=4;
   %dcl ERRLOC_MEM char;
   %ERRLOC_MEM=5;
   %dcl TC_NORMAL char;
   %TC_NORMAL=0;
   %dcl TC_HARDERR char;
   %TC_HARDERR=1;
   %dcl TC_GP_TRAP char;
   %TC_GP_TRAP=2;
   %dcl TC_SIGNAL char;
   %TC_SIGNAL=3;
   %dcl TC_XCPT char;
   %TC_XCPT=4;
 %end;
 %if INCL_DOSERRORS='Y' | INCL_ERROR2_H='Y' %then %do;
   %dcl ERROR_INVALID_PROCID char;
   %ERROR_INVALID_PROCID=303;
   %dcl ERROR_INVALID_PDELTA char;
   %ERROR_INVALID_PDELTA=304;
   %dcl ERROR_NOT_DESCENDANT char;
   %ERROR_NOT_DESCENDANT=305;
   %dcl ERROR_NOT_SESSION_MANAGER char;
   %ERROR_NOT_SESSION_MANAGER=306;
   %dcl ERROR_INVALID_PCLASS char;
   %ERROR_INVALID_PCLASS=307;
   %dcl ERROR_INVALID_SCOPE char;
   %ERROR_INVALID_SCOPE=308;
   %dcl ERROR_INVALID_THREADID char;
   %ERROR_INVALID_THREADID=309;
   %dcl ERROR_DOSSUB_SHRINK char;
   %ERROR_DOSSUB_SHRINK=310;
   %dcl ERROR_DOSSUB_NOMEM char;
   %ERROR_DOSSUB_NOMEM=311;
   %dcl ERROR_DOSSUB_OVERLAP char;
   %ERROR_DOSSUB_OVERLAP=312;
   %dcl ERROR_DOSSUB_BADSIZE char;
   %ERROR_DOSSUB_BADSIZE=313;
   %dcl ERROR_DOSSUB_BADFLAG char;
   %ERROR_DOSSUB_BADFLAG=314;
   %dcl ERROR_DOSSUB_BADSELECTOR char;
   %ERROR_DOSSUB_BADSELECTOR=315;
   %dcl ERROR_MR_MSG_TOO_LONG char;
   %ERROR_MR_MSG_TOO_LONG=316;
   %dcl MGS_MR_MSG_TOO_LONG char;
   %MGS_MR_MSG_TOO_LONG=316;
   %dcl ERROR_MR_MID_NOT_FOUND char;
   %ERROR_MR_MID_NOT_FOUND=317;
   %dcl ERROR_MR_UN_ACC_MSGF char;
   %ERROR_MR_UN_ACC_MSGF=318;
   %dcl ERROR_MR_INV_MSGF_FORMAT char;
   %ERROR_MR_INV_MSGF_FORMAT=319;
   %dcl ERROR_MR_INV_IVCOUNT char;
   %ERROR_MR_INV_IVCOUNT=320;
   %dcl ERROR_MR_UN_PERFORM char;
   %ERROR_MR_UN_PERFORM=321;
   %dcl ERROR_TS_WAKEUP char;
   %ERROR_TS_WAKEUP=322;
   %dcl ERROR_TS_SEMHANDLE char;
   %ERROR_TS_SEMHANDLE=323;
   %dcl ERROR_TS_NOTIMER char;
   %ERROR_TS_NOTIMER=324;
   %dcl ERROR_TS_HANDLE char;
   %ERROR_TS_HANDLE=326;
   %dcl ERROR_TS_DATETIME char;
   %ERROR_TS_DATETIME=327;
   %dcl ERROR_SYS_INTERNAL char;
   %ERROR_SYS_INTERNAL=328;
   %dcl ERROR_QUE_CURRENT_NAME char;
   %ERROR_QUE_CURRENT_NAME=329;
   %dcl ERROR_QUE_PROC_NOT_OWNED char;
   %ERROR_QUE_PROC_NOT_OWNED=330;
   %dcl ERROR_QUE_PROC_OWNED char;
   %ERROR_QUE_PROC_OWNED=331;
   %dcl ERROR_QUE_DUPLICATE char;
   %ERROR_QUE_DUPLICATE=332;
   %dcl ERROR_QUE_ELEMENT_NOT_EXIST char;
   %ERROR_QUE_ELEMENT_NOT_EXIST=333;
   %dcl ERROR_QUE_NO_MEMORY char;
   %ERROR_QUE_NO_MEMORY=334;
   %dcl ERROR_QUE_INVALID_NAME char;
   %ERROR_QUE_INVALID_NAME=335;
   %dcl ERROR_QUE_INVALID_PRIORITY char;
   %ERROR_QUE_INVALID_PRIORITY=336;
   %dcl ERROR_QUE_INVALID_HANDLE char;
   %ERROR_QUE_INVALID_HANDLE=337;
   %dcl ERROR_QUE_LINK_NOT_FOUND char;
   %ERROR_QUE_LINK_NOT_FOUND=338;
   %dcl ERROR_QUE_MEMORY_ERROR char;
   %ERROR_QUE_MEMORY_ERROR=339;
   %dcl ERROR_QUE_PREV_AT_END char;
   %ERROR_QUE_PREV_AT_END=340;
   %dcl ERROR_QUE_PROC_NO_ACCESS char;
   %ERROR_QUE_PROC_NO_ACCESS=341;
   %dcl ERROR_QUE_EMPTY char;
   %ERROR_QUE_EMPTY=342;
   %dcl ERROR_QUE_NAME_NOT_EXIST char;
   %ERROR_QUE_NAME_NOT_EXIST=343;
   %dcl ERROR_QUE_NOT_INITIALIZED char;
   %ERROR_QUE_NOT_INITIALIZED=344;
   %dcl ERROR_QUE_UNABLE_TO_ACCESS char;
   %ERROR_QUE_UNABLE_TO_ACCESS=345;
   %dcl ERROR_QUE_UNABLE_TO_ADD char;
   %ERROR_QUE_UNABLE_TO_ADD=346;
   %dcl ERROR_QUE_UNABLE_TO_INIT char;
   %ERROR_QUE_UNABLE_TO_INIT=347;
   %dcl ERROR_VIO_INVALID_MASK char;
   %ERROR_VIO_INVALID_MASK=349;
   %dcl ERROR_VIO_PTR char;
   %ERROR_VIO_PTR=350;
   %dcl ERROR_VIO_APTR char;
   %ERROR_VIO_APTR=351;
   %dcl ERROR_VIO_RPTR char;
   %ERROR_VIO_RPTR=352;
   %dcl ERROR_VIO_CPTR char;
   %ERROR_VIO_CPTR=353;
   %dcl ERROR_VIO_LPTR char;
   %ERROR_VIO_LPTR=354;
   %dcl ERROR_VIO_MODE char;
   %ERROR_VIO_MODE=355;
   %dcl ERROR_VIO_WIDTH char;
   %ERROR_VIO_WIDTH=356;
   %dcl ERROR_VIO_ATTR char;
   %ERROR_VIO_ATTR=357;
   %dcl ERROR_VIO_ROW char;
   %ERROR_VIO_ROW=358;
   %dcl ERROR_VIO_COL char;
   %ERROR_VIO_COL=359;
   %dcl ERROR_VIO_TOPROW char;
   %ERROR_VIO_TOPROW=360;
   %dcl ERROR_VIO_BOTROW char;
   %ERROR_VIO_BOTROW=361;
   %dcl ERROR_VIO_RIGHTCOL char;
   %ERROR_VIO_RIGHTCOL=362;
   %dcl ERROR_VIO_LEFTCOL char;
   %ERROR_VIO_LEFTCOL=363;
   %dcl ERROR_SCS_CALL char;
   %ERROR_SCS_CALL=364;
   %dcl ERROR_SCS_VALUE char;
   %ERROR_SCS_VALUE=365;
   %dcl ERROR_VIO_WAIT_FLAG char;
   %ERROR_VIO_WAIT_FLAG=366;
   %dcl ERROR_VIO_UNLOCK char;
   %ERROR_VIO_UNLOCK=367;
   %dcl ERROR_SGS_NOT_SESSION_MGR char;
   %ERROR_SGS_NOT_SESSION_MGR=368;
   %dcl ERROR_SMG_INVALID_SGID char;
   %ERROR_SMG_INVALID_SGID=369;
   %dcl ERROR_SMG_INVALID_SESSION_ID char;
   %ERROR_SMG_INVALID_SESSION_ID=ERROR_SMG_INVALID_SGID;
   %dcl ERROR_SMG_NOSG char;
   %ERROR_SMG_NOSG=370;
   %dcl ERROR_SMG_NO_SESSIONS char;
   %ERROR_SMG_NO_SESSIONS=370;
   %dcl ERROR_SMG_GRP_NOT_FOUND char;
   %ERROR_SMG_GRP_NOT_FOUND=371;
   %dcl ERROR_SMG_SESSION_NOT_FOUND char;
   %ERROR_SMG_SESSION_NOT_FOUND=ERROR_SMG_GRP_NOT_FOUND;
   %dcl ERROR_SMG_SET_TITLE char;
   %ERROR_SMG_SET_TITLE=372;
   %dcl ERROR_KBD_PARAMETER char;
   %ERROR_KBD_PARAMETER=373;
   %dcl ERROR_KBD_NO_DEVICE char;
   %ERROR_KBD_NO_DEVICE=374;
   %dcl ERROR_KBD_INVALID_IOWAIT char;
   %ERROR_KBD_INVALID_IOWAIT=375;
   %dcl ERROR_KBD_INVALID_LENGTH char;
   %ERROR_KBD_INVALID_LENGTH=376;
   %dcl ERROR_KBD_INVALID_ECHO_MASK char;
   %ERROR_KBD_INVALID_ECHO_MASK=377;
   %dcl ERROR_KBD_INVALID_INPUT_MASK char;
   %ERROR_KBD_INVALID_INPUT_MASK=378;
   %dcl ERROR_MON_INVALID_PARMS char;
   %ERROR_MON_INVALID_PARMS=379;
   %dcl ERROR_MON_INVALID_DEVNAME char;
   %ERROR_MON_INVALID_DEVNAME=380;
   %dcl ERROR_MON_INVALID_HANDLE char;
   %ERROR_MON_INVALID_HANDLE=381;
   %dcl ERROR_MON_BUFFER_TOO_SMALL char;
   %ERROR_MON_BUFFER_TOO_SMALL=382;
   %dcl ERROR_MON_BUFFER_EMPTY char;
   %ERROR_MON_BUFFER_EMPTY=383;
   %dcl ERROR_MON_DATA_TOO_LARGE char;
   %ERROR_MON_DATA_TOO_LARGE=384;
   %dcl ERROR_MOUSE_NO_DEVICE char;
   %ERROR_MOUSE_NO_DEVICE=385;
   %dcl ERROR_MOUSE_INV_HANDLE char;
   %ERROR_MOUSE_INV_HANDLE=386;
   %dcl ERROR_MOUSE_INV_PARMS char;
   %ERROR_MOUSE_INV_PARMS=387;
   %dcl ERROR_MOUSE_CANT_RESET char;
   %ERROR_MOUSE_CANT_RESET=388;
   %dcl ERROR_MOUSE_DISPLAY_PARMS char;
   %ERROR_MOUSE_DISPLAY_PARMS=389;
   %dcl ERROR_MOUSE_INV_MODULE char;
   %ERROR_MOUSE_INV_MODULE=390;
   %dcl ERROR_MOUSE_INV_ENTRY_PT char;
   %ERROR_MOUSE_INV_ENTRY_PT=391;
   %dcl ERROR_MOUSE_INV_MASK char;
   %ERROR_MOUSE_INV_MASK=392;
   %dcl NO_ERROR_MOUSE_NO_DATA char;
   %NO_ERROR_MOUSE_NO_DATA=393;
   %dcl NO_ERROR_MOUSE_PTR_DRAWN char;
   %NO_ERROR_MOUSE_PTR_DRAWN=394;
   %dcl ERROR_INVALID_FREQUENCY char;
   %ERROR_INVALID_FREQUENCY=395;
   %dcl ERROR_NLS_NO_COUNTRY_FILE char;
   %ERROR_NLS_NO_COUNTRY_FILE=396;
   %dcl ERROR_NLS_OPEN_FAILED char;
   %ERROR_NLS_OPEN_FAILED=397;
   %dcl ERROR_NLS_NO_CTRY_CODE char;
   %ERROR_NLS_NO_CTRY_CODE=398;
   %dcl ERROR_NO_COUNTRY_OR_CODEPAGE char;
   %ERROR_NO_COUNTRY_OR_CODEPAGE=398;
   %dcl ERROR_NLS_TABLE_TRUNCATED char;
   %ERROR_NLS_TABLE_TRUNCATED=399;
   %dcl ERROR_NLS_BAD_TYPE char;
   %ERROR_NLS_BAD_TYPE=400;
   %dcl ERROR_NLS_TYPE_NOT_FOUND char;
   %ERROR_NLS_TYPE_NOT_FOUND=401;
   %dcl ERROR_VIO_SMG_ONLY char;
   %ERROR_VIO_SMG_ONLY=402;
   %dcl ERROR_VIO_INVALID_ASCIIZ char;
   %ERROR_VIO_INVALID_ASCIIZ=403;
   %dcl ERROR_VIO_DEREGISTER char;
   %ERROR_VIO_DEREGISTER=404;
   %dcl ERROR_VIO_NO_POPUP char;
   %ERROR_VIO_NO_POPUP=405;
   %dcl ERROR_VIO_EXISTING_POPUP char;
   %ERROR_VIO_EXISTING_POPUP=406;
   %dcl ERROR_KBD_SMG_ONLY char;
   %ERROR_KBD_SMG_ONLY=407;
   %dcl ERROR_KBD_INVALID_ASCIIZ char;
   %ERROR_KBD_INVALID_ASCIIZ=408;
   %dcl ERROR_KBD_INVALID_MASK char;
   %ERROR_KBD_INVALID_MASK=409;
   %dcl ERROR_KBD_REGISTER char;
   %ERROR_KBD_REGISTER=410;
   %dcl ERROR_KBD_DEREGISTER char;
   %ERROR_KBD_DEREGISTER=411;
   %dcl ERROR_MOUSE_SMG_ONLY char;
   %ERROR_MOUSE_SMG_ONLY=412;
   %dcl ERROR_MOUSE_INVALID_ASCIIZ char;
   %ERROR_MOUSE_INVALID_ASCIIZ=413;
   %dcl ERROR_MOUSE_INVALID_MASK char;
   %ERROR_MOUSE_INVALID_MASK=414;
   %dcl ERROR_MOUSE_REGISTER char;
   %ERROR_MOUSE_REGISTER=415;
   %dcl ERROR_MOUSE_DEREGISTER char;
   %ERROR_MOUSE_DEREGISTER=416;
   %dcl ERROR_SMG_BAD_ACTION char;
   %ERROR_SMG_BAD_ACTION=417;
   %dcl ERROR_SMG_INVALID_CALL char;
   %ERROR_SMG_INVALID_CALL=418;
   %dcl ERROR_SCS_SG_NOTFOUND char;
   %ERROR_SCS_SG_NOTFOUND=419;
   %dcl ERROR_SCS_NOT_SHELL char;
   %ERROR_SCS_NOT_SHELL=420;
   %dcl ERROR_VIO_INVALID_PARMS char;
   %ERROR_VIO_INVALID_PARMS=421;
   %dcl ERROR_VIO_FUNCTION_OWNED char;
   %ERROR_VIO_FUNCTION_OWNED=422;
   %dcl ERROR_VIO_RETURN char;
   %ERROR_VIO_RETURN=423;
   %dcl ERROR_SCS_INVALID_FUNCTION char;
   %ERROR_SCS_INVALID_FUNCTION=424;
   %dcl ERROR_SCS_NOT_SESSION_MGR char;
   %ERROR_SCS_NOT_SESSION_MGR=425;
   %dcl ERROR_VIO_REGISTER char;
   %ERROR_VIO_REGISTER=426;
   %dcl ERROR_VIO_NO_MODE_THREAD char;
   %ERROR_VIO_NO_MODE_THREAD=427;
   %dcl ERROR_VIO_NO_SAVE_RESTORE_THD char;
   %ERROR_VIO_NO_SAVE_RESTORE_THD=428;
   %dcl ERROR_VIO_IN_BG char;
   %ERROR_VIO_IN_BG=429;
   %dcl ERROR_VIO_ILLEGAL_DURING_POPUP char;
   %ERROR_VIO_ILLEGAL_DURING_POPUP=430;
   %dcl ERROR_SMG_NOT_BASESHELL char;
   %ERROR_SMG_NOT_BASESHELL=431;
   %dcl ERROR_SMG_BAD_STATUSREQ char;
   %ERROR_SMG_BAD_STATUSREQ=432;
   %dcl ERROR_QUE_INVALID_WAIT char;
   %ERROR_QUE_INVALID_WAIT=433;
   %dcl ERROR_VIO_LOCK char;
   %ERROR_VIO_LOCK=434;
   %dcl ERROR_MOUSE_INVALID_IOWAIT char;
   %ERROR_MOUSE_INVALID_IOWAIT=435;
   %dcl ERROR_VIO_INVALID_HANDLE char;
   %ERROR_VIO_INVALID_HANDLE=436;
   %dcl ERROR_VIO_ILLEGAL_DURING_LOCK char;
   %ERROR_VIO_ILLEGAL_DURING_LOCK=437;
   %dcl ERROR_VIO_INVALID_LENGTH char;
   %ERROR_VIO_INVALID_LENGTH=438;
   %dcl ERROR_KBD_INVALID_HANDLE char;
   %ERROR_KBD_INVALID_HANDLE=439;
   %dcl ERROR_KBD_NO_MORE_HANDLE char;
   %ERROR_KBD_NO_MORE_HANDLE=440;
   %dcl ERROR_KBD_CANNOT_CREATE_KCB char;
   %ERROR_KBD_CANNOT_CREATE_KCB=441;
   %dcl ERROR_KBD_CODEPAGE_LOAD_INCOMPL char;
   %ERROR_KBD_CODEPAGE_LOAD_INCOMPL=442;
   %dcl ERROR_KBD_INVALID_CODEPAGE_ID char;
   %ERROR_KBD_INVALID_CODEPAGE_ID=443;
   %dcl ERROR_KBD_NO_CODEPAGE_SUPPORT char;
   %ERROR_KBD_NO_CODEPAGE_SUPPORT=444;
   %dcl ERROR_KBD_FOCUS_REQUIRED char;
   %ERROR_KBD_FOCUS_REQUIRED=445;
   %dcl ERROR_KBD_FOCUS_ALREADY_ACTIVE char;
   %ERROR_KBD_FOCUS_ALREADY_ACTIVE=446;
   %dcl ERROR_KBD_KEYBOARD_BUSY char;
   %ERROR_KBD_KEYBOARD_BUSY=447;
   %dcl ERROR_KBD_INVALID_CODEPAGE char;
   %ERROR_KBD_INVALID_CODEPAGE=448;
   %dcl ERROR_KBD_UNABLE_TO_FOCUS char;
   %ERROR_KBD_UNABLE_TO_FOCUS=449;
   %dcl ERROR_SMG_SESSION_NON_SELECT char;
   %ERROR_SMG_SESSION_NON_SELECT=450;
   %dcl ERROR_SMG_SESSION_NOT_FOREGRND char;
   %ERROR_SMG_SESSION_NOT_FOREGRND=451;
   %dcl ERROR_SMG_SESSION_NOT_PARENT char;
   %ERROR_SMG_SESSION_NOT_PARENT=452;
   %dcl ERROR_SMG_INVALID_START_MODE char;
   %ERROR_SMG_INVALID_START_MODE=453;
   %dcl ERROR_SMG_INVALID_RELATED_OPT char;
   %ERROR_SMG_INVALID_RELATED_OPT=454;
   %dcl ERROR_SMG_INVALID_BOND_OPTION char;
   %ERROR_SMG_INVALID_BOND_OPTION=455;
   %dcl ERROR_SMG_INVALID_SELECT_OPT char;
   %ERROR_SMG_INVALID_SELECT_OPT=456;
   %dcl ERROR_SMG_START_IN_BACKGROUND char;
   %ERROR_SMG_START_IN_BACKGROUND=457;
   %dcl ERROR_SMG_INVALID_STOP_OPTION char;
   %ERROR_SMG_INVALID_STOP_OPTION=458;
   %dcl ERROR_SMG_BAD_RESERVE char;
   %ERROR_SMG_BAD_RESERVE=459;
   %dcl ERROR_SMG_PROCESS_NOT_PARENT char;
   %ERROR_SMG_PROCESS_NOT_PARENT=460;
   %dcl ERROR_SMG_INVALID_DATA_LENGTH char;
   %ERROR_SMG_INVALID_DATA_LENGTH=461;
   %dcl ERROR_SMG_NOT_BOUND char;
   %ERROR_SMG_NOT_BOUND=462;
   %dcl ERROR_SMG_RETRY_SUB_ALLOC char;
   %ERROR_SMG_RETRY_SUB_ALLOC=463;
   %dcl ERROR_KBD_DETACHED char;
   %ERROR_KBD_DETACHED=464;
   %dcl ERROR_VIO_DETACHED char;
   %ERROR_VIO_DETACHED=465;
   %dcl ERROR_MOU_DETACHED char;
   %ERROR_MOU_DETACHED=466;
   %dcl ERROR_VIO_FONT char;
   %ERROR_VIO_FONT=467;
   %dcl ERROR_VIO_USER_FONT char;
   %ERROR_VIO_USER_FONT=468;
   %dcl ERROR_VIO_BAD_CP char;
   %ERROR_VIO_BAD_CP=469;
   %dcl ERROR_VIO_NO_CP char;
   %ERROR_VIO_NO_CP=470;
   %dcl ERROR_VIO_NA_CP char;
   %ERROR_VIO_NA_CP=471;
   %dcl ERROR_INVALID_CODE_PAGE char;
   %ERROR_INVALID_CODE_PAGE=472;
   %dcl ERROR_CPLIST_TOO_SMALL char;
   %ERROR_CPLIST_TOO_SMALL=473;
   %dcl ERROR_CP_NOT_MOVED char;
   %ERROR_CP_NOT_MOVED=474;
   %dcl ERROR_MODE_SWITCH_INIT char;
   %ERROR_MODE_SWITCH_INIT=475;
   %dcl ERROR_CODE_PAGE_NOT_FOUND char;
   %ERROR_CODE_PAGE_NOT_FOUND=476;
   %dcl ERROR_UNEXPECTED_SLOT_RETURNED char;
   %ERROR_UNEXPECTED_SLOT_RETURNED=477;
   %dcl ERROR_SMG_INVALID_TRACE_OPTION char;
   %ERROR_SMG_INVALID_TRACE_OPTION=478;
   %dcl ERROR_VIO_INTERNAL_RESOURCE char;
   %ERROR_VIO_INTERNAL_RESOURCE=479;
   %dcl ERROR_VIO_SHELL_INIT char;
   %ERROR_VIO_SHELL_INIT=480;
   %dcl ERROR_SMG_NO_HARD_ERRORS char;
   %ERROR_SMG_NO_HARD_ERRORS=481;
   %dcl ERROR_CP_SWITCH_INCOMPLETE char;
   %ERROR_CP_SWITCH_INCOMPLETE=482;
   %dcl ERROR_VIO_TRANSPARENT_POPUP char;
   %ERROR_VIO_TRANSPARENT_POPUP=483;
   %dcl ERROR_CRITSEC_OVERFLOW char;
   %ERROR_CRITSEC_OVERFLOW=484;
   %dcl ERROR_CRITSEC_UNDERFLOW char;
   %ERROR_CRITSEC_UNDERFLOW=485;
   %dcl ERROR_VIO_BAD_RESERVE char;
   %ERROR_VIO_BAD_RESERVE=486;
   %dcl ERROR_INVALID_ADDRESS char;
   %ERROR_INVALID_ADDRESS=487;
   %dcl ERROR_ZERO_SELECTORS_REQUESTED char;
   %ERROR_ZERO_SELECTORS_REQUESTED=488;
   %dcl ERROR_NOT_ENOUGH_SELECTORS_AVA char;
   %ERROR_NOT_ENOUGH_SELECTORS_AVA=489;
   %dcl ERROR_INVALID_SELECTOR char;
   %ERROR_INVALID_SELECTOR=490;
   %dcl ERROR_SMG_INVALID_PROGRAM_TYPE char;
   %ERROR_SMG_INVALID_PROGRAM_TYPE=491;
   %dcl ERROR_SMG_INVALID_PGM_CONTROL char;
   %ERROR_SMG_INVALID_PGM_CONTROL=492;
   %dcl ERROR_SMG_INVALID_INHERIT_OPT char;
   %ERROR_SMG_INVALID_INHERIT_OPT=493;
   %dcl ERROR_VIO_EXTENDED_SG char;
   %ERROR_VIO_EXTENDED_SG=494;
   %dcl ERROR_VIO_NOT_PRES_MGR_SG char;
   %ERROR_VIO_NOT_PRES_MGR_SG=495;
   %dcl ERROR_VIO_SHIELD_OWNED char;
   %ERROR_VIO_SHIELD_OWNED=496;
   %dcl ERROR_VIO_NO_MORE_HANDLES char;
   %ERROR_VIO_NO_MORE_HANDLES=497;
   %dcl ERROR_VIO_SEE_ERROR_LOG char;
   %ERROR_VIO_SEE_ERROR_LOG=498;
   %dcl ERROR_VIO_ASSOCIATED_DC char;
   %ERROR_VIO_ASSOCIATED_DC=499;
   %dcl ERROR_KBD_NO_CONSOLE char;
   %ERROR_KBD_NO_CONSOLE=500;
   %dcl ERROR_MOUSE_NO_CONSOLE char;
   %ERROR_MOUSE_NO_CONSOLE=501;
   %dcl ERROR_MOUSE_INVALID_HANDLE char;
   %ERROR_MOUSE_INVALID_HANDLE=502;
   %dcl ERROR_SMG_INVALID_DEBUG_PARMS char;
   %ERROR_SMG_INVALID_DEBUG_PARMS=503;
   %dcl ERROR_KBD_EXTENDED_SG char;
   %ERROR_KBD_EXTENDED_SG=504;
   %dcl ERROR_MOU_EXTENDED_SG char;
   %ERROR_MOU_EXTENDED_SG=505;
   %dcl ERROR_SMG_INVALID_ICON_FILE char;
   %ERROR_SMG_INVALID_ICON_FILE=506;
   %dcl ERROR_TRC_PID_NON_EXISTENT char;
   %ERROR_TRC_PID_NON_EXISTENT=507;
   %dcl ERROR_TRC_COUNT_ACTIVE char;
   %ERROR_TRC_COUNT_ACTIVE=508;
   %dcl ERROR_TRC_SUSPENDED_BY_COUNT char;
   %ERROR_TRC_SUSPENDED_BY_COUNT=509;
   %dcl ERROR_TRC_COUNT_INACTIVE char;
   %ERROR_TRC_COUNT_INACTIVE=510;
   %dcl ERROR_TRC_COUNT_REACHED char;
   %ERROR_TRC_COUNT_REACHED=511;
   %dcl ERROR_NO_MC_TRACE char;
   %ERROR_NO_MC_TRACE=512;
   %dcl ERROR_MC_TRACE char;
   %ERROR_MC_TRACE=513;
   %dcl ERROR_TRC_COUNT_ZERO char;
   %ERROR_TRC_COUNT_ZERO=514;
   %dcl ERROR_SMG_TOO_MANY_DDS char;
   %ERROR_SMG_TOO_MANY_DDS=515;
   %dcl ERROR_SMG_INVALID_NOTIFICATION char;
   %ERROR_SMG_INVALID_NOTIFICATION=516;
   %dcl ERROR_LF_INVALID_FUNCTION char;
   %ERROR_LF_INVALID_FUNCTION=517;
   %dcl ERROR_LF_NOT_AVAIL char;
   %ERROR_LF_NOT_AVAIL=518;
   %dcl ERROR_LF_SUSPENDED char;
   %ERROR_LF_SUSPENDED=519;
   %dcl ERROR_LF_BUF_TOO_SMALL char;
   %ERROR_LF_BUF_TOO_SMALL=520;
   %dcl ERROR_LF_BUFFER_CORRUPTED char;
   %ERROR_LF_BUFFER_CORRUPTED=521;
   %dcl ERROR_LF_BUFFER_FULL char;
   %ERROR_LF_BUFFER_FULL=521;
   %dcl ERROR_LF_INVALID_DAEMON char;
   %ERROR_LF_INVALID_DAEMON=522;
   %dcl ERROR_LF_INVALID_RECORD char;
   %ERROR_LF_INVALID_RECORD=522;
   %dcl ERROR_LF_INVALID_TEMPL char;
   %ERROR_LF_INVALID_TEMPL=523;
   %dcl ERROR_LF_INVALID_SERVICE char;
   %ERROR_LF_INVALID_SERVICE=523;
   %dcl ERROR_LF_GENERAL_FAILURE char;
   %ERROR_LF_GENERAL_FAILURE=524;
   %dcl ERROR_LF_INVALID_ID char;
   %ERROR_LF_INVALID_ID=525;
   %dcl ERROR_LF_INVALID_HANDLE char;
   %ERROR_LF_INVALID_HANDLE=526;
   %dcl ERROR_LF_NO_ID_AVAIL char;
   %ERROR_LF_NO_ID_AVAIL=527;
   %dcl ERROR_LF_TEMPLATE_AREA_FULL char;
   %ERROR_LF_TEMPLATE_AREA_FULL=528;
   %dcl ERROR_LF_ID_IN_USE char;
   %ERROR_LF_ID_IN_USE=529;
   %dcl ERROR_MOU_NOT_INITIALIZED char;
   %ERROR_MOU_NOT_INITIALIZED=530;
   %dcl ERROR_MOUINITREAL_DONE char;
   %ERROR_MOUINITREAL_DONE=531;
   %dcl ERROR_DOSSUB_CORRUPTED char;
   %ERROR_DOSSUB_CORRUPTED=532;
   %dcl ERROR_MOUSE_CALLER_NOT_SUBSYS char;
   %ERROR_MOUSE_CALLER_NOT_SUBSYS=533;
   %dcl ERROR_ARITHMETIC_OVERFLOW char;
   %ERROR_ARITHMETIC_OVERFLOW=534;
   %dcl ERROR_TMR_NO_DEVICE char;
   %ERROR_TMR_NO_DEVICE=535;
   %dcl ERROR_TMR_INVALID_TIME char;
   %ERROR_TMR_INVALID_TIME=536;
   %dcl ERROR_PVW_INVALID_ENTITY char;
   %ERROR_PVW_INVALID_ENTITY=537;
   %dcl ERROR_PVW_INVALID_ENTITY_TYPE char;
   %ERROR_PVW_INVALID_ENTITY_TYPE=538;
   %dcl ERROR_PVW_INVALID_SPEC char;
   %ERROR_PVW_INVALID_SPEC=539;
   %dcl ERROR_PVW_INVALID_RANGE_TYPE char;
   %ERROR_PVW_INVALID_RANGE_TYPE=540;
   %dcl ERROR_PVW_INVALID_COUNTER_BLK char;
   %ERROR_PVW_INVALID_COUNTER_BLK=541;
   %dcl ERROR_PVW_INVALID_TEXT_BLK char;
   %ERROR_PVW_INVALID_TEXT_BLK=542;
   %dcl ERROR_PRF_NOT_INITIALIZED char;
   %ERROR_PRF_NOT_INITIALIZED=543;
   %dcl ERROR_PRF_ALREADY_INITIALIZED char;
   %ERROR_PRF_ALREADY_INITIALIZED=544;
   %dcl ERROR_PRF_NOT_STARTED char;
   %ERROR_PRF_NOT_STARTED=545;
   %dcl ERROR_PRF_ALREADY_STARTED char;
   %ERROR_PRF_ALREADY_STARTED=546;
   %dcl ERROR_PRF_TIMER_OUT_OF_RANGE char;
   %ERROR_PRF_TIMER_OUT_OF_RANGE=547;
   %dcl ERROR_PRF_TIMER_RESET char;
   %ERROR_PRF_TIMER_RESET=548;
   %dcl ERROR_VDD_LOCK_USEAGE_DENIED char;
   %ERROR_VDD_LOCK_USEAGE_DENIED=639;
   %dcl ERROR_TIMEOUT char;
   %ERROR_TIMEOUT=640;
   %dcl ERROR_VDM_DOWN char;
   %ERROR_VDM_DOWN=641;
   %dcl ERROR_VDM_LIMIT char;
   %ERROR_VDM_LIMIT=642;
   %dcl ERROR_VDD_NOT_FOUND char;
   %ERROR_VDD_NOT_FOUND=643;
   %dcl ERROR_INVALID_CALLER char;
   %ERROR_INVALID_CALLER=644;
   %dcl ERROR_PID_MISMATCH char;
   %ERROR_PID_MISMATCH=645;
   %dcl ERROR_INVALID_VDD_HANDLE char;
   %ERROR_INVALID_VDD_HANDLE=646;
   %dcl ERROR_VLPT_NO_SPOOLER char;
   %ERROR_VLPT_NO_SPOOLER=647;
   %dcl ERROR_VCOM_DEVICE_BUSY char;
   %ERROR_VCOM_DEVICE_BUSY=648;
   %dcl ERROR_VLPT_DEVICE_BUSY char;
   %ERROR_VLPT_DEVICE_BUSY=649;
   %dcl ERROR_NESTING_TOO_DEEP char;
   %ERROR_NESTING_TOO_DEEP=650;
   %dcl ERROR_VDD_MISSING char;
   %ERROR_VDD_MISSING=651;
   %dcl ERROR_BIDI_INVALID_LENGTH char;
   %ERROR_BIDI_INVALID_LENGTH=671;
   %dcl ERROR_BIDI_INVALID_INCREMENT char;
   %ERROR_BIDI_INVALID_INCREMENT=672;
   %dcl ERROR_BIDI_INVALID_COMBINATION char;
   %ERROR_BIDI_INVALID_COMBINATION=673;
   %dcl ERROR_BIDI_INVALID_RESERVED char;
   %ERROR_BIDI_INVALID_RESERVED=674;
   %dcl ERROR_BIDI_INVALID_EFFECT char;
   %ERROR_BIDI_INVALID_EFFECT=675;
   %dcl ERROR_BIDI_INVALID_CSDREC char;
   %ERROR_BIDI_INVALID_CSDREC=676;
   %dcl ERROR_BIDI_INVALID_CSDSTATE char;
   %ERROR_BIDI_INVALID_CSDSTATE=677;
   %dcl ERROR_BIDI_INVALID_LEVEL char;
   %ERROR_BIDI_INVALID_LEVEL=678;
   %dcl ERROR_BIDI_INVALID_TYPE_SUPPORT char;
   %ERROR_BIDI_INVALID_TYPE_SUPPORT=679;
   %dcl ERROR_BIDI_INVALID_ORIENTATION char;
   %ERROR_BIDI_INVALID_ORIENTATION=680;
   %dcl ERROR_BIDI_INVALID_NUM_SHAPE char;
   %ERROR_BIDI_INVALID_NUM_SHAPE=681;
   %dcl ERROR_BIDI_INVALID_CSD char;
   %ERROR_BIDI_INVALID_CSD=682;
   %dcl ERROR_BIDI_NO_SUPPORT char;
   %ERROR_BIDI_NO_SUPPORT=683;
   %dcl NO_ERROR_BIDI_RW_INCOMPLETE char;
   %NO_ERROR_BIDI_RW_INCOMPLETE=684;
   %dcl ERROR_IMP_INVALID_PARM char;
   %ERROR_IMP_INVALID_PARM=691;
   %dcl ERROR_IMP_INVALID_LENGTH char;
   %ERROR_IMP_INVALID_LENGTH=692;
   %dcl MSG_HPFS_DISK_ERROR_WARN char;
   %MSG_HPFS_DISK_ERROR_WARN=693;
   %dcl ERROR_MON_BAD_BUFFER char;
   %ERROR_MON_BAD_BUFFER=730;
   %dcl ERROR_MODULE_CORRUPTED char;
   %ERROR_MODULE_CORRUPTED=731;
   %dcl ERROR_SM_OUTOF_SWAPFILE char;
   %ERROR_SM_OUTOF_SWAPFILE=1477;
   %dcl ERROR_LF_TIMEOUT char;
   %ERROR_LF_TIMEOUT=2055;
   %dcl ERROR_LF_SUSPEND_SUCCESS char;
   %ERROR_LF_SUSPEND_SUCCESS=2057;
   %dcl ERROR_LF_RESUME_SUCCESS char;
   %ERROR_LF_RESUME_SUCCESS=2058;
   %dcl ERROR_LF_REDIRECT_SUCCESS char;
   %ERROR_LF_REDIRECT_SUCCESS=2059;
   %dcl ERROR_LF_REDIRECT_FAILURE char;
   %ERROR_LF_REDIRECT_FAILURE=2060;
   %dcl ERROR_SWAPPER_NOT_ACTIVE char;
   %ERROR_SWAPPER_NOT_ACTIVE=32768;
   %dcl ERROR_INVALID_SWAPID char;
   %ERROR_INVALID_SWAPID=32769;
   %dcl ERROR_IOERR_SWAP_FILE char;
   %ERROR_IOERR_SWAP_FILE=32770;
   %dcl ERROR_SWAP_TABLE_FULL char;
   %ERROR_SWAP_TABLE_FULL=32771;
   %dcl ERROR_SWAP_FILE_FULL char;
   %ERROR_SWAP_FILE_FULL=32772;
   %dcl ERROR_CANT_INIT_SWAPPER char;
   %ERROR_CANT_INIT_SWAPPER=32773;
   %dcl ERROR_SWAPPER_ALREADY_INIT char;
   %ERROR_SWAPPER_ALREADY_INIT=32774;
   %dcl ERROR_PMM_INSUFFICIENT_MEMORY char;
   %ERROR_PMM_INSUFFICIENT_MEMORY=32775;
   %dcl ERROR_PMM_INVALID_FLAGS char;
   %ERROR_PMM_INVALID_FLAGS=32776;
   %dcl ERROR_PMM_INVALID_ADDRESS char;
   %ERROR_PMM_INVALID_ADDRESS=32777;
   %dcl ERROR_PMM_LOCK_FAILED char;
   %ERROR_PMM_LOCK_FAILED=32778;
   %dcl ERROR_PMM_UNLOCK_FAILED char;
   %ERROR_PMM_UNLOCK_FAILED=32779;
   %dcl ERROR_PMM_MOVE_INCOMPLETE char;
   %ERROR_PMM_MOVE_INCOMPLETE=32780;
   %dcl ERROR_UCOM_DRIVE_RENAMED char;
   %ERROR_UCOM_DRIVE_RENAMED=32781;
   %dcl ERROR_UCOM_FILENAME_TRUNCATED char;
   %ERROR_UCOM_FILENAME_TRUNCATED=32782;
   %dcl ERROR_UCOM_BUFFER_LENGTH char;
   %ERROR_UCOM_BUFFER_LENGTH=32783;
   %dcl ERROR_MON_CHAIN_HANDLE char;
   %ERROR_MON_CHAIN_HANDLE=32784;
   %dcl ERROR_MON_NOT_REGISTERED char;
   %ERROR_MON_NOT_REGISTERED=32785;
   %dcl ERROR_SMG_ALREADY_TOP char;
   %ERROR_SMG_ALREADY_TOP=32786;
   %dcl ERROR_PMM_ARENA_MODIFIED char;
   %ERROR_PMM_ARENA_MODIFIED=32787;
   %dcl ERROR_SMG_PRINTER_OPEN char;
   %ERROR_SMG_PRINTER_OPEN=32788;
   %dcl ERROR_PMM_SET_FLAGS_FAILED char;
   %ERROR_PMM_SET_FLAGS_FAILED=32789;
   %dcl ERROR_INVALID_DOS_DD char;
   %ERROR_INVALID_DOS_DD=32790;
   %dcl ERROR_BLOCKED char;
   %ERROR_BLOCKED=32791;
   %dcl ERROR_NOBLOCK char;
   %ERROR_NOBLOCK=32792;
   %dcl ERROR_INSTANCE_SHARED char;
   %ERROR_INSTANCE_SHARED=32793;
   %dcl ERROR_NO_OBJECT char;
   %ERROR_NO_OBJECT=32794;
   %dcl ERROR_PARTIAL_ATTACH char;
   %ERROR_PARTIAL_ATTACH=32795;
   %dcl ERROR_INCACHE char;
   %ERROR_INCACHE=32796;
   %dcl ERROR_SWAP_IO_PROBLEMS char;
   %ERROR_SWAP_IO_PROBLEMS=32797;
   %dcl ERROR_CROSSES_OBJECT_BOUNDARY char;
   %ERROR_CROSSES_OBJECT_BOUNDARY=32798;
   %dcl ERROR_LONGLOCK char;
   %ERROR_LONGLOCK=32799;
   %dcl ERROR_SHORTLOCK char;
   %ERROR_SHORTLOCK=32800;
   %dcl ERROR_UVIRTLOCK char;
   %ERROR_UVIRTLOCK=32801;
   %dcl ERROR_ALIASLOCK char;
   %ERROR_ALIASLOCK=32802;
   %dcl ERROR_ALIAS char;
   %ERROR_ALIAS=32803;
   %dcl ERROR_NO_MORE_HANDLES char;
   %ERROR_NO_MORE_HANDLES=32804;
   %dcl ERROR_SCAN_TERMINATED char;
   %ERROR_SCAN_TERMINATED=32805;
   %dcl ERROR_TERMINATOR_NOT_FOUND char;
   %ERROR_TERMINATOR_NOT_FOUND=32806;
   %dcl ERROR_NOT_DIRECT_CHILD char;
   %ERROR_NOT_DIRECT_CHILD=32807;
   %dcl ERROR_DELAY_FREE char;
   %ERROR_DELAY_FREE=32808;
   %dcl ERROR_GUARDPAGE char;
   %ERROR_GUARDPAGE=32809;
   %dcl ERROR_SWAPERROR char;
   %ERROR_SWAPERROR=32900;
   %dcl ERROR_LDRERROR char;
   %ERROR_LDRERROR=32901;
   %dcl ERROR_NOMEMORY char;
   %ERROR_NOMEMORY=32902;
   %dcl ERROR_NOACCESS char;
   %ERROR_NOACCESS=32903;
   %dcl ERROR_NO_DLL_TERM char;
   %ERROR_NO_DLL_TERM=32904;
   %dcl ERROR_CPSIO_CODE_PAGE_INVALID char;
   %ERROR_CPSIO_CODE_PAGE_INVALID=65026;
   %dcl ERROR_CPSIO_NO_SPOOLER char;
   %ERROR_CPSIO_NO_SPOOLER=65027;
   %dcl ERROR_CPSIO_FONT_ID_INVALID char;
   %ERROR_CPSIO_FONT_ID_INVALID=65028;
   %dcl ERROR_CPSIO_INTERNAL_ERROR char;
   %ERROR_CPSIO_INTERNAL_ERROR=65033;
   %dcl ERROR_CPSIO_INVALID_PTR_NAME char;
   %ERROR_CPSIO_INVALID_PTR_NAME=65034;
   %dcl ERROR_CPSIO_NOT_ACTIVE char;
   %ERROR_CPSIO_NOT_ACTIVE=65037;
   %dcl ERROR_CPSIO_PID_FULL char;
   %ERROR_CPSIO_PID_FULL=65039;
   %dcl ERROR_CPSIO_PID_NOT_FOUND char;
   %ERROR_CPSIO_PID_NOT_FOUND=65040;
   %dcl ERROR_CPSIO_READ_CTL_SEQ char;
   %ERROR_CPSIO_READ_CTL_SEQ=65043;
   %dcl ERROR_CPSIO_READ_FNT_DEF char;
   %ERROR_CPSIO_READ_FNT_DEF=65045;
   %dcl ERROR_CPSIO_WRITE_ERROR char;
   %ERROR_CPSIO_WRITE_ERROR=65047;
   %dcl ERROR_CPSIO_WRITE_FULL_ERROR char;
   %ERROR_CPSIO_WRITE_FULL_ERROR=65048;
   %dcl ERROR_CPSIO_WRITE_HANDLE_BAD char;
   %ERROR_CPSIO_WRITE_HANDLE_BAD=65049;
   %dcl ERROR_CPSIO_SWIT_LOAD char;
   %ERROR_CPSIO_SWIT_LOAD=65074;
   %dcl ERROR_CPSIO_INV_COMMAND char;
   %ERROR_CPSIO_INV_COMMAND=65077;
   %dcl ERROR_CPSIO_NO_FONT_SWIT char;
   %ERROR_CPSIO_NO_FONT_SWIT=65078;
   %dcl ERROR_ENTRY_IS_CALLGATE char;
   %ERROR_ENTRY_IS_CALLGATE=65079;
 %end;
