 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: OS2DEF.CPY                                   */
 /*                                                                  */
 /*  NAME - OS2DEF.CPY                                               */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    OS/2 base PL/I include file.                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %if OS2DEF__='Y' %then %do;
   %OS2DEF__='Y';
   %OS2DEF_INCLUDED='Y';
   %FAR='Y';
   %NEAR='Y';
   %declare APIENTRY char;
   %APIENTRY
     ='options(byvalue nodescriptor linkage(system)) external';
   %declare EXPENTRY char;
   %EXPENTRY
     ='options(byvalue nodescriptor linkage(system)) external';
   %declare APIENTRY16 char;
   %APIENTRY16
     ='options(byvalue nodescriptor linkage(pascal16)) external';
   %declare VOID char;
   %VOID='null()';
   %declare APIRET char;
   %APIRET='fixed bin(31) signed';
   %declare APIRET32 char;
   %APIRET32='fixed bin(31) signed';
   %declare APIRET16 char;
   %APIRET16='fixed bin(16) unsigned';
   %if FALSE='Y' %then %do;
     %declare FALSE char;
     %FALSE=0;
   %end;
   %if TRUE='Y' %then %do;
     %declare TRUE char;
     %TRUE=1;
   %end;
   %if NULL_PLI='Y' %then %do;
       %declare NULL_PLI char;
       %NULL_PLI=0;
   %end;
   %declare SHANDLE char;
   %SHANDLE='fixed bin(16) unsigned';
   %declare LHANDLE char;
   %LHANDLE='fixed bin(31) signed';
   declare NULLHANDLE fixed bin(31) unsigned value('00_00_00_00'xn);
   declare NULLSHANDLE fixed bin(16) unsigned value('00_00'xn);
   %declare SHORT char;
   %SHORT='fixed bin(15)';
   %declare LONG char;
   %LONG='fixed bin(31)';
   %if INCL_SAADEFS='Y' %then %do;
     %declare INT char;
     %INT='fixed bin(31)';
   %end;
   %declare UCHAR char;
   %UCHAR='char';
   %declare USHORT char;
   %USHORT='fixed bin(16) unsigned';
   /* ULONG must be signed so that 32 bits are available */
   %declare ULONG char;
   %ULONG='fixed bin(31) signed';
   %if INCL_SAADEFS='Y' %then %do;
     %declare UINT char;
     %UINT='fixed bin(31) unsigned';
   %end;
   %declare PUCHAR16 char;
   %PUCHAR16='pointer segmented';
   %declare PCHAR16 char;
   %PCHAR16='pointer segmented';
   %declare BYTE char;
   %BYTE='fixed bin(8) unsigned';
   %declare PSZ char;
   %PSZ='pointer';
   %declare NPSZ char;
   %NPSZ='pointer';
   %declare PCH char;
   %PCH='pointer';
   %declare NPCH char;
   %NPCH='pointer';
   %declare PFN char;
   %PFN='pointer';
   %declare NPFN char;
   %NPFN='pointer';
   %declare PBYTE char;
   %PBYTE='pointer';
   %declare NPBYTE char;
   %NPBYTE='pointer';
   %declare PCHAR char;
   %PCHAR='pointer';
   %declare PSHORT char;
   %PSHORT='pointer';
   %declare PLONG char;
   %PLONG='fixed bin(31) byaddr';
   %if INCL_SAADEFS='Y' %then %do;
     %declare PINT char;
     %PINT='pointer';
   %end;
   %declare PUCHAR char;
   %PUCHAR='pointer';
   %declare PUSHORT char;
   %PUSHORT='pointer';
   %declare PULONG char;
   %PULONG='ULONG byaddr';
   %if INCL_SAADEFS='Y' %then %do;
     %declare PUINT char;
     %PUINT='pointer';
   %end;
   %declare PVOID char;
   %PVOID='pointer';
   %declare PPVOID char;
   %PPVOID='pointer';
   %declare PVOID16 char;
   %PVOID16='pointer segmented';
   %declare BOOL char;
   %BOOL='fixed bin(31) signed';
   %declare PBOOL char;
   %PBOOL='pointer';
   %declare BOOL16 char;
   %BOOL16='fixed bin(16) unsigned';
   %declare PBOOL16 char;
   %PBOOL16='pointer';
   %declare BOOL32 char;
   %BOOL32=BOOL;
   %declare PBOOL32 char;
   %PBOOL32=PBOOL;
   %declare QWORD char;
   %QWORD='char(stg(#QWORD))';
   dcl 1 #QWORD based(null()) unaligned,
         2 ulLo ULONG,
         2 ulHi ULONG;
   %declare PQWORD char;
   %PQWORD='pointer';
   %if INCL_SAADEFS='Y' %then %do;
     %declare SEL char;
     %SEL='fixed bin(16) unsigned';
     %declare PSEL char;
     %PSEL='pointer';
   %end;
   %declare ERRORID char;
   %ERRORID=ULONG;
   %declare PERRORID char;
   %PERRORID='pointer';
   declare SEVERITY_NOERROR fixed bin(15) value('00_00'xn);
   declare SEVERITY_WARNING fixed bin(15) value('00_04'xn);
   declare SEVERITY_ERROR fixed bin(15) value('00_08'xn);
   declare SEVERITY_SEVERE fixed bin(15) value('00_0C'xn);
   declare SEVERITY_UNRECOVERABLE fixed bin(15) value('00_10'xn);
   declare WINERR_BASE fixed bin(15) value('10_00'xn);
   declare GPIERR_BASE fixed bin(15) value('20_00'xn);
   declare DEVERR_BASE fixed bin(15) value('30_00'xn);
   declare SPLERR_BASE fixed bin(15) value('40_00'xn);
   %declare HMODULE char;
   %HMODULE='pointer';
   %declare PID char;
   %PID=LHANDLE;
   %declare TID char;
   %TID=LHANDLE;
   %if INCL_SAADEFS='Y' %then %do;
     %declare SGID char;
     %SGID=USHORT;
   %end;
   %declare PHMODULE char;
   %PHMODULE='pointer';
   %declare PPID char;
   %PPID='pointer';
   %declare PTID char;
   %PTID='pointer';
   %if INCL_SAADEFS='Y' %then %do;
     %if HSEM__='Y' %then %do;
       %HSEM__='Y';
       %declare HSEM char;
       %HSEM='pointer';
       %declare PHSEM char;
       %PHSEM='pointer';
     %end;
   %end;
   %declare HAB char;
   %HAB=LHANDLE;
   %declare PHAB char;
   %PHAB='pointer';
   %declare HPS char;
   %HPS='pointer';
   %declare PHPS char;
   %PHPS='pointer';
   %declare HDC char;
   %HDC='pointer';
   %declare PHDC char;
   %PHDC='pointer';
   %declare HRGN char;
   %HRGN='pointer';
   %declare PHRGN char;
   %PHRGN='pointer';
   %declare HBITMAP char;
   %HBITMAP=LHANDLE;
   %declare PHBITMAP char;
   %PHBITMAP='pointer';
   %declare HMF char;
   %HMF=LHANDLE;
   %declare PHMF char;
   %PHMF='pointer';
   %declare HPAL char;
   %HPAL=LHANDLE;
   %declare PHPAL char;
   %PHPAL='pointer';
   %declare COLOR char;
   %COLOR=LONG;
   %declare PCOLOR char;
   %PCOLOR='pointer';
   %declare POINTL char;
   %POINTL='char(stg(#POINTL))';
   dcl 1 #POINTL based(null()) unaligned,
         2 x LONG,
         2 y LONG;
   %declare PPOINTL char;
   %PPOINTL='pointer';
   %declare NPPOINTL char;
   %NPPOINTL='pointer';
   %declare POINTS char;
   %POINTS='char(stg(#POINTS))';
   dcl 1 #POINTS based(null()) unaligned,
         2 x SHORT,
         2 y SHORT;
   %declare PPOINTS char;
   %PPOINTS='pointer';
   %declare RECTL char;
   %RECTL='char(stg(#RECTL))';
   dcl 1 #RECTL based(null()) unaligned,
         2 xLeft LONG,
         2 yBottom LONG,
         2 xRight LONG,
         2 yTop LONG;
   %declare PRECTL char;
   %PRECTL='pointer';
   %declare NPRECTL char;
   %NPRECTL='pointer';
   %declare STR8 char;
   %STR8='char(8)';
   %declare PSTR8 char;
   %PSTR8='pointer';
   %declare DRIVDATA char;
   %DRIVDATA='char(stg(#DRIVDATA))';
   dcl 1 #DRIVDATA based(null()) unaligned,
         2 cb LONG,
         2 lVersion LONG,
         2 szDeviceName char(32-1) varz,
         2 abGeneralData(1) CHAR;
   %declare PDRIVDATA char;
   %PDRIVDATA='pointer';
   %declare PDEVOPENDATA char;
   %PDEVOPENDATA='pointer';
   %declare ADDRESS char;
   %ADDRESS=0;
   %if INCL_SAADEFS='Y' %then %do;
     %declare DRIVER_NAME char;
     %DRIVER_NAME=1;
     %declare DRIVER_DATA char;
     %DRIVER_DATA=2;
     %declare DATA_TYPE char;
     %DATA_TYPE=3;
     %declare COMMENT char;
     %COMMENT=4;
     %declare PROC_NAME char;
     %PROC_NAME=5;
     %declare PROC_PARAMS char;
     %PROC_PARAMS=6;
     %declare SPL_PARAMS char;
     %SPL_PARAMS=7;
     %declare NETWORK_PARAMS char;
     %NETWORK_PARAMS=8;
     %declare DEVOPENSTRUC char;
     %DEVOPENSTRUC='char(stg(#DEVOPENSTRUC))';
     dcl 1 #DEVOPENSTRUC based(null()) unaligned,
           2 pszLogAddress PSZ,
           2 pszDriverName PSZ,
           2 pdriv PDRIVDATA,
           2 pszDataType PSZ,
           2 pszComment PSZ,
           2 pszQueueProcName PSZ,
           2 pszQueueProcParams PSZ,
           2 pszSpoolerParams PSZ,
           2 pszNetworkParams PSZ;
     %declare PDEVOPENSTRUC char;
     %PDEVOPENSTRUC='pointer';
   %end;
   %declare PRINTDEST char;
   %PRINTDEST='char(stg(#PRINTDEST))';
   dcl 1 #PRINTDEST based(null()) unaligned,
         2 cb ULONG,
         2 lType LONG,
         2 pszToken PSZ,
         2 lCount LONG,
         2 pdopData PDEVOPENDATA,
         2 fl ULONG,
         2 pszPrinter PSZ;
   %declare PPRINTDEST char;
   %PPRINTDEST='pointer';
   declare PD_JOB_PROPERTY fixed bin(15) value('00_01'xn);
   declare FATTR_SEL_ITALIC fixed bin(15) value('00_01'xn);
   declare FATTR_SEL_UNDERSCORE fixed bin(15) value('00_02'xn);
   declare FATTR_SEL_OUTLINE fixed bin(15) value('00_08'xn);
   declare FATTR_SEL_STRIKEOUT fixed bin(15) value('00_10'xn);
   declare FATTR_SEL_BOLD fixed bin(15) value('00_20'xn);
   declare FATTR_TYPE_KERNING fixed bin(15) value('00_04'xn);
   declare FATTR_TYPE_MBCS fixed bin(15) value('00_08'xn);
   declare FATTR_TYPE_DBCS fixed bin(15) value('00_10'xn);
   declare FATTR_TYPE_ANTIALIASED fixed bin(15) value('00_20'xn);
   declare FATTR_FONTUSE_NOMIX fixed bin(15) value('00_02'xn);
   declare FATTR_FONTUSE_OUTLINE fixed bin(15) value('00_04'xn);
   declare FATTR_FONTUSE_TRANSFORMABLE fixed bin(15) value('00_08'xn);
   %declare FACESIZE char;
   %FACESIZE=32;
   %declare FATTRIBS char;
   %FATTRIBS='char(stg(#FATTRS))';
   dcl 1 #FATTRS based(null()) unaligned,
         2 usRecordLength USHORT,
         2 fsSelection USHORT,
         2 lMatch LONG,
         2 szFacename CHAR(FACESIZE-1) varz,
         2 idRegistry USHORT,
         2 usCodePage USHORT,
         2 lMaxBaselineExt LONG,
         2 lAveCharWidth LONG,
         2 fsType USHORT,
         2 fsFontUse USHORT;
   %declare PFATTRS char;
   %PFATTRS='pointer';
   declare FM_TYPE_FIXED     fixed bin(15) value('00_01'xn);
   declare FM_TYPE_LICENSED  fixed bin(15) value('00_02'xn);
   declare FM_TYPE_KERNING   fixed bin(15) value('00_04'xn);
   declare FM_TYPE_DBCS      fixed bin(15) value('00_10'xn);
   declare FM_TYPE_MBCS      fixed bin(15) value('00_18'xn);
   declare FM_TYPE_64K       fixed bin(16) value('80_00'xn);
   declare FM_TYPE_ATOMS     fixed bin(15) value('40_00'xn);
   declare FM_TYPE_FAMTRUNC  fixed bin(15) value('20_00'xn);
   declare FM_TYPE_FACETRUNC fixed bin(15) value('10_00'xn);
   declare FM_DEFN_OUTLINE   fixed bin(15) value('00_01'xn);
   declare FM_DEFN_IFI       fixed bin(15) value('00_02'xn);
   declare FM_DEFN_WIN       fixed bin(15) value('00_04'xn);
   declare FM_DEFN_GENERIC   fixed bin(16) value('80_00'xn);
   declare FM_SEL_ITALIC     fixed bin(15) value('00_01'xn);
   declare FM_SEL_UNDERSCORE fixed bin(15) value('00_02'xn);
   declare FM_SEL_NEGATIVE   fixed bin(15) value('00_04'xn);
   declare FM_SEL_OUTLINE    fixed bin(15) value('00_08'xn);
   declare FM_SEL_STRIKEOUT  fixed bin(15) value('00_10'xn);
   declare FM_SEL_BOLD       fixed bin(15) value('00_20'xn);
   declare FM_SEL_ISO9241_TESTED fixed bin(15) value('00_40'xn);
   declare FM_ISO_9518_640   fixed bin(8) unsigned value('01'xn);
   declare FM_ISO_9515_640   fixed bin(8) unsigned value('02'xn);
   declare FM_ISO_9515_1024  fixed bin(8) unsigned value('04'xn);
   declare FM_ISO_9517_640   fixed bin(8) unsigned value('08'xn);
   declare FM_ISO_9517_1024  fixed bin(8) unsigned value('10'xn);
   declare FM_CAP_NOMIX      fixed bin(15) value('00_01'xn);
   %declare PANOSE char;
   %PANOSE='char(stg(#PANOSE))';
   dcl 1 #PANOSE based(null()) unaligned,
         2 bFamilyType BYTE,
         2 bSerifStyle BYTE,
         2 bWeight BYTE,
         2 bProportion BYTE,
         2 bContrast BYTE,
         2 bStrokeVariation BYTE,
         2 bArmStyle BYTE,
         2 bLetterform BYTE,
         2 bMidline BYTE,
         2 bXHeight BYTE,
         2 fbPassedISO BYTE,
         2 fbFailedISO BYTE;
   %declare FONTMETRICS char;
   %FONTMETRICS='char(stg(#FONTMETRICS))';
   dcl 1 #FONTMETRICS based(null()) unaligned,
         2 szFamilyname CHAR(FACESIZE-1) varz,
         2 szFacename CHAR(FACESIZE-1) varz,
         2 idRegistry USHORT,
         2 usCodePage USHORT,
         2 lEmHeight LONG,
         2 lXHeight LONG,
         2 lMaxAscender LONG,
         2 lMaxDescender LONG,
         2 lLowerCaseAscent LONG,
         2 lLowerCaseDescent LONG,
         2 lInternalLeading LONG,
         2 lExternalLeading LONG,
         2 lAveCharWidth LONG,
         2 lMaxCharInc LONG,
         2 lEmInc LONG,
         2 lMaxBaselineExt LONG,
         2 sCharSlope SHORT,
         2 sInlineDir SHORT,
         2 sCharRot SHORT,
         2 usWeightClass USHORT,
         2 usWidthClass USHORT,
         2 sXDeviceRes SHORT,
         2 sYDeviceRes SHORT,
         2 sFirstChar SHORT,
         2 sLastChar SHORT,
         2 sDefaultChar SHORT,
         2 sBreakChar SHORT,
         2 sNominalPointSize SHORT,
         2 sMinimumPointSize SHORT,
         2 sMaximumPointSize SHORT,
         2 fsType USHORT,
         2 fsDefn USHORT,
         2 fsSelection USHORT,
         2 fsCapabilities USHORT,
         2 lSubscriptXSize LONG,
         2 lSubscriptYSize LONG,
         2 lSubscriptXOffset LONG,
         2 lSubscriptYOffset LONG,
         2 lSuperscriptXSize LONG,
         2 lSuperscriptYSize LONG,
         2 lSuperscriptXOffset LONG,
         2 lSuperscriptYOffset LONG,
         2 lUnderscoreSize LONG,
         2 lUnderscorePosition LONG,
         2 lStrikeoutSize LONG,
         2 lStrikeoutPosition LONG,
         2 sKerningPairs SHORT,
         2 sFamilyClass SHORT,
         2 lMatch LONG,
         2 FamilyNameAtom LONG,
         2 FaceNameAtom LONG,
         2 panPanose PANOSE;
   %declare PFONTMETRICS char;
   %PFONTMETRICS='pointer';
   %declare HWND char;
   %HWND='pointer';
   %declare PHWND char;
   %PHWND='pointer';
   %declare HMQ char;
   %HMQ=LHANDLE;
   %declare PHMQ char;
   %PHMQ='pointer';
   %declare WRECT char;
   %WRECT=RECTL;
   %declare PWRECT char;
   %PWRECT=PRECTL;
   %declare NPWRECT char;
   %NPWRECT=NPRECTL;
   %declare WPOINT char;
   %WPOINT=POINTL;
   %declare PWPOINT char;
   %PWPOINT=PPOINTL;
   %declare NPWPOINT char;
   %NPWPOINT=NPPOINTL;
   %declare ICONINFO char;
   %ICONINFO='char(stg(#ICONINFO))';
   dcl 1 #ICONINFO based(null()) unaligned,
         2 cb ULONG,
         2 fFormat ULONG,
         2 pszFileName PSZ,
         2 hmod HMODULE,
         2 resid ULONG,
         2 cbIconData ULONG,
         2 pIconData PVOID;
   %declare PICONINFO char;
   %PICONINFO='pointer';
   %declare ICON_FILE char;
   %ICON_FILE=1;
   %declare ICON_RESOURCE char;
   %ICON_RESOURCE=2;
   %declare ICON_DATA char;
   %ICON_DATA=3;
   %declare ICON_CLEAR char;
   %ICON_CLEAR=4;
 dcl DT                 ULONG  init (     '0540'XN );
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;

 MakeULong:
   proc( l, h )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(31) );
   dcl (l, h ) unsigned fixed bin(16);
   return( ior( l, isll( h, 16 ) ) );
 end;

 MakeLong:
   proc( l, h )
   options( byvalue inline )
   returns( byvalue signed fixed bin(31) );
   dcl (l, h ) unsigned fixed bin(16);
   return( ior( l, isll( h, 16 ) ) );
 end;

 MakeUShort:
   proc( l, h )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl (l, h ) unsigned fixed bin(8);
   return( ior( l, isll( h, 8 ) ) );
 end;

 MakeShort:
   proc( l, h )
   options( byvalue inline )
   returns( byvalue signed fixed bin(15) );
   dcl (l, h ) unsigned fixed bin(8);
   return( ior( l, isll( h, 8 ) ) );
 end;

 LoByte:
   proc( w )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(8) );
   dcl w fixed bin(31);
   return( LoUChar(w) );
 end;

 HiByte:
   proc( w )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(8) );
   dcl w fixed bin(31);
   return( HiUChar(w) );
 end;

 LoUChar:
   proc( w )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(8) );
   dcl w fixed bin(31);
   return( w );
 end;

 HiUChar:
   proc( w )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(8) );
   dcl w fixed bin(31);
   return( lower2(w,8) );
 end;

 LoUShort:
   proc( w )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl w fixed bin(31);
   return( w );
 end;

 HiUShort:
   proc( w )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl w fixed bin(31);
   return( lower2(w,16) );
 end;

 ErrorIdError:
   proc( errid )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl errid fixed bin(31);
   return( LoUShort(errid) );
 end;

 ErrorIdSec:
   proc( errid )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl errid fixed bin(31);
   return( HiUShort(errid) );
 end;
