 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMORD.CPY                                    */
 /*                                                                  */
 /*  NAME - PMORD.CPY                                                */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The orders fall into 4 categories :-                             */
 /*                                                                  */
 /* 1) 1-byte orders                                                 */
 /*                                                                  */
 /* 2) 2-byte orders    - second byte contains the value             */
 /*                                                                  */
 /* 3) Long orders      - second byte gives the order length,        */
 /*                       subsequent bytes                           */
 /*                       contain the values (up to 256 bytes long)  */
 /*                                                                  */
 /* 4) Very long orders - third and fourth bytes gives the order     */
 /*                       length, subsequent bytes contain the       */
 /*                       values (up to 64K long)                    */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %ORD_INCLUDED='Y';
 /********************************************************************/
 /*                                                             ******/
 /*  Miscellaneous structures used in this file                 ******/
 /*                                                             ******/
 /********************************************************************/
 %declare RECT1S char;
 %RECT1S='char(stg(#RECT1S))';
 dcl 1 #RECT1S based(null()) unaligned,
       2 xLeft SHORT,
       2 yBottom SHORT,
       2 xRight SHORT,
       2 yTop SHORT;
 %declare ODPOINT char;
 %ODPOINT='char(stg(#ODPOINT))';
 dcl 1 #ODPOINT based(null()) unaligned,
       2 dx CHAR,
       2 dy CHAR;
 %declare SIZES char;
 %SIZES='char(stg(#SIZES))';
 dcl 1 #SIZES based(null()) unaligned,
       2 cx SHORT,
       2 cy SHORT;
 %declare SWPUSHORT char;
 %SWPUSHORT='char(stg(#SWPUSHORT))';
 dcl 1 #SWPUSHORT based(null()) unaligned,
       2 HiByte UCHAR,
       2 LoByte UCHAR;

  declare OCODE_GNOP1 bit(8) value('00_00_00_00'b);
  declare OCODE_GESD bit(8) value('11_11_11_11'b);
  declare OCODE2_1 bit(8) value('10_00_00_00'b);
  declare OCODE2_2 bit(8) value('10_00_10_00'b);

 %declare ORDER char;
 %ORDER='char(stg(#ORDER))';
 dcl 1 #ORDER based(null()) unaligned,
       2 idCode UCHAR,
       2 uchData UCHAR;

  declare OCODE_GBAR bit(8) value('01_10_10_00'b);
  declare OCODE_GCFIG bit(8) value('01_11_11_01'b);
  declare OCODE_GEEL bit(8) value('01_00_10_01'b);
  declare OCODE_GEPTH bit(8) value('01_11_11_11'b);
  declare OCODE_GEPROL bit(8) value('00_11_11_10'b);
  declare OCODE_GPOP bit(8) value('00_11_11_11'b);
  declare OCODE_GSBMX bit(8) value('00_00_11_01'b);
  declare OCODE_GPSBMX bit(8) value('01_00_11_01'b);
  declare OCODE_GSCD bit(8) value('00_11_10_10'b);
  declare OCODE_GPSCD bit(8) value('01_11_10_10'b);
  declare OCODE_GSCR bit(8) value('00_11_10_01'b);
  declare OCODE_GPSCR bit(8) value('01_11_10_01'b);
  declare OCODE_GSCS bit(8) value('00_11_10_00'b);
  declare OCODE_GPSCS bit(8) value('01_11_10_00'b);
  declare OCODE_GSCOL bit(8) value('00_00_10_10'b);
  declare OCODE_GPSCOL bit(8) value('01_00_10_10'b);
  declare OCODE_GSLE bit(8) value('00_01_10_10'b);
  declare OCODE_GPSLE bit(8) value('01_01_10_10'b);
  declare OCODE_GSLJ bit(8) value('00_01_10_11'b);
  declare OCODE_GPSLJ bit(8) value('01_01_10_11'b);
  declare OCODE_GSLT bit(8) value('00_01_10_00'b);
  declare OCODE_GPSLT bit(8) value('01_01_10_00'b);
  declare OCODE_GSLW bit(8) value('00_01_10_01'b);
  declare OCODE_GPSLW bit(8) value('01_01_10_01'b);
  declare OCODE_GSMP bit(8) value('00_11_10_11'b);
  declare OCODE_GPSMP bit(8) value('01_11_10_11'b);
  declare OCODE_GSMS bit(8) value('00_11_11_00'b);
  declare OCODE_GPSMS bit(8) value('01_11_11_00'b);
  declare OCODE_GSMT bit(8) value('00_10_10_01'b);
  declare OCODE_GPSMT bit(8) value('01_10_10_01'b);
  declare OCODE_GSMX bit(8) value('00_00_11_00'b);
  declare OCODE_GPSMX bit(8) value('01_00_11_00'b);
  declare OCODE_GSPS bit(8) value('00_00_10_00'b);
  declare OCODE_GPSPS bit(8) value('01_00_10_00'b);
  declare OCODE_GSPT bit(8) value('00_10_10_00'b);
  declare OCODE_GPSPT bit(8) value('00_00_10_01'b);

  declare GBAR_RESERVED bit(8) value('10_00_00_00'b);
  declare GBAR_BOUNDARY bit(8) value('11_00_00_00'b);
  declare GBAR_NOBOUNDARY bit(8) value('10_00_00_00'b);
  declare GBAR_WINDING bit(8) value('10_10_00_00'b);
  declare GBAR_ALTERNATE bit(8) value('10_00_00_00'b);
  declare GSCR_PRECISION bit(8) value('00_00_11_11'b);
  declare OCODE_VLONG bit(8) value('11_11_11_10'b);
 %declare LORDER_ML char;
 %LORDER_ML=253;
 %declare LORDER char;
 %LORDER='char(stg(#LORDER))';
 dcl 1 #LORDER based(null()) unaligned,
       2 idCode UCHAR,
       2 uchLength UCHAR,
       2 uchData(LORDER_ML) UCHAR;
  declare OCODE_GEAR bit(8) value('01_10_00_00'b);
  declare OCODE_GEIMG bit(8) value('10_01_00_11'b);
  declare OCODE_GCCHST bit(8) value('10_00_00_11'b);
 %declare GCCHST_MC char;
 %GCCHST_MC=255;
  declare OCODE_GCHST bit(8) value('11_00_00_11'b);
 %declare GCHST_SMC char;
 %GCHST_SMC=251;
 %declare GCHST_LMC char;
 %GCHST_LMC=247;
  declare OCODE_GCCHSTM bit(8) value('10_11_00_01'b);
 %declare GCCHSTM_MC char;
 %GCCHSTM_MC=255;
  declare OCODE_GCHSTM bit(8) value('11_11_00_01'b);
 %declare GCHSTM_SMC char;
 %GCHSTM_SMC=251;
 %declare GCHSTM_LMC char;
 %GCHSTM_LMC=247;
  declare OCODE_GCOMT bit(8) value('00_00_00_01'b);
 %declare GCOMT_ML char;
 %GCOMT_ML=255;
  declare OCODE_GIMD bit(8) value('10_01_00_10'b);
 %declare GIMD_ML char;
 %GIMD_ML=255;
  declare OCODE_GCFARC bit(8) value('10_00_01_11'b);
  declare OCODE_GFARC bit(8) value('10_00_01_11'b);
  declare OCODE_GLABL bit(8) value('11_01_00_11'b);
  declare OCODE_GSCP bit(8) value('00_10_00_01'b);
  declare OCODE_GPSCP bit(8) value('01_10_00_01'b);
  declare OCODE_GCBEZ bit(8) value('10_10_01_01'b);
 %declare GCBEZ_SMB char;
 %GCBEZ_SMB=21;
 %declare GCBEZ_LMB char;
 %GCBEZ_LMB=10;
  declare OCODE_GBEZ bit(8) value('11_10_01_01'b);
 %declare GBEZ_SMB char;
 %GBEZ_SMB=20;
 %declare GBEZ_LMB char;
 %GBEZ_LMB=10;
  declare OCODE_GCFLT bit(8) value('10_00_01_01'b);
 %declare GCFLT_SMP char;
 %GCFLT_SMP=63;
 %declare GCFLT_LMP char;
 %GCFLT_LMP=31;
  declare OCODE_GFLT bit(8) value('11_00_01_01'b);
 %declare GFLT_SMP char;
 %GFLT_SMP=62;
 %declare GFLT_LMP char;
 %GFLT_LMP=30;
  declare OCODE_GCLINE bit(8) value('10_00_00_01'b);
 %declare GCLINE_SMP char;
 %GCLINE_SMP=63;
 %declare GCLINE_LMP char;
 %GCLINE_LMP=31;
  declare OCODE_GLINE bit(8) value('11_00_00_01'b);
 %declare GLINE_SMP char;
 %GLINE_SMP=62;
 %declare GLINE_LMP char;
 %GLINE_LMP=30;
  declare OCODE_GCMRK bit(8) value('10_00_00_10'b);
 %declare GCMRK_SMP char;
 %GCMRK_SMP=63;
 %declare GCMRK_LMP char;
 %GCMRK_LMP=31;
  declare OCODE_GMRK bit(8) value('11_00_00_10'b);
 %declare GMRK_SMP char;
 %GMRK_SMP=62;
 %declare GMRK_LMP char;
 %GMRK_LMP=30;
  declare OCODE_GCRLINE bit(8) value('10_10_00_01'b);
 %declare GCRLINE_MP char;
 %GCRLINE_MP=127;
  declare OCODE_GRLINE bit(8) value('11_10_00_01'b);
 %declare GRLINE_SMP char;
 %GRLINE_SMP=125;
 %declare GRLINE_LMP char;
 %GRLINE_LMP=123;
  declare OCODE_GSBCOL bit(8) value('00_10_01_01'b);
  declare OCODE_GPSBCOL bit(8) value('01_10_01_01'b);
  declare OCODE_GSECOL bit(8) value('00_10_01_10'b);
  declare OCODE_GPSECOL bit(8) value('01_10_01_10'b);
  declare SECOL_DEFAULT0 fixed bin(16) value('00_00'xn);
  declare SECOL_DEFAULT1 fixed bin(16) value('FF_00'xn);
  declare SECOL_NEUTRAL fixed bin(16) value('FF_07'xn);
  declare SECOL_RESET fixed bin(16) value('FF_08'xn);
  declare OCODE_GSCA bit(8) value('00_11_01_00'b);
  declare OCODE_GPSCA bit(8) value('01_11_01_00'b);
  declare OCODE_GSCH bit(8) value('00_11_01_01'b);
  declare OCODE_GPSCH bit(8) value('01_11_01_01'b);
  declare OCODE_GSFLW bit(8) value('00_01_00_01'b);
  declare OCODE_GPSFLW bit(8) value('01_01_00_01'b);
  declare OCODE_GSPIK bit(8) value('01_00_00_11'b);
  declare OCODE_GPSPIK bit(8) value('00_10_00_11'b);
  declare OCODE_GCARC bit(8) value('10_00_01_10'b);
  declare OCODE_GARC bit(8) value('11_00_01_10'b);

 %declare ORDERS_GCARC char;
 %ORDERS_GCARC='char(stg(#ORDERS_GCARC))';
 dcl 1 #ORDERS_GCARC based(null()) unaligned,
       2 ptInter POINTS,
       2 ptEnd POINTS;
 %declare ORDERL_GCARC char;
 %ORDERL_GCARC='char(stg(#ORDERL_GCARC))';
 dcl 1 #ORDERL_GCARC based(null()) unaligned,
       2 ptInter POINTL,
       2 ptEnd POINTL;

  declare OCODE_GBEL bit(8) value('11_01_00_10'b);

 %declare GBEL_DL char;
 %GBEL_DL=251;
 %declare ORDER_GBEL char;
 %ORDER_GBEL='char(stg(#ORDER_GBEL))';
 dcl 1 #ORDER_GBEL based(null()) unaligned,
       2 lElementType LONG,
       2 achDesc(GBEL_DL) CHAR;

  declare OCODE_GCBIMG bit(8) value('10_01_00_01'b);
  declare OCODE_GBIMG bit(8) value('11_01_00_01'b);

 %declare ORDER_GCBIMG char;
 %ORDER_GCBIMG='char(stg(#ORDER_GCBIMG))';
 dcl 1 #ORDER_GCBIMG based(null()) unaligned,
       2 uchFormat UCHAR,
       2 uchReserved UCHAR,
       2 cx SWPUSHORT,
       2 cy SWPUSHORT;

  declare OCODE_GBPTH bit(8) value('11_01_00_00'b);

 %declare ORDER_GBPTH char;
 %ORDER_GBPTH='char(stg(#ORDER_GBPTH))';
 dcl 1 #ORDER_GBPTH based(null()) unaligned,
       2 usReserved USHORT,
       2 idPath LONG;
  declare OCODE_GCBOX bit(8) value('10_00_00_00'b);
  declare OCODE_GBOX bit(8) value('11_00_00_00'b);

 %declare ORDERS_GCBOX char;
 %ORDERS_GCBOX='char(stg(#ORDERS_GCBOX))';
 dcl 1 #ORDERS_GCBOX based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 ptCorner POINTS,
       2 hAxis SHORT,
       2 vAxis SHORT;
 %declare ORDERL_GCBOX char;
 %ORDERL_GCBOX='char(stg(#ORDERL_GCBOX))';
 dcl 1 #ORDERL_GCBOX based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 ptCorner POINTL,
       2 hAxis LONG,
       2 vAxis LONG;
  declare GCBOX_FILL bit(8) value('01_00_00_00'b);
  declare GCBOX_BOUNDARY bit(8) value('00_10_00_00'b);
  declare OCODE_GCALLS bit(8) value('00_00_01_11'b);

 %declare ORDER_GCALLS char;
 %ORDER_GCALLS='char(stg(#ORDER_GCALLS))';
 dcl 1 #ORDER_GCALLS based(null()) unaligned,
       2 sReserved USHORT,
       2 idSegment LONG;

  declare OCODE_GFPTH bit(8) value('11_01_01_11'b);

 %declare ORDER_GFPTH char;
 %ORDER_GFPTH='char(stg(#ORDER_GFPTH))';
 dcl 1 #ORDER_GFPTH based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 idPath LONG;

  declare GFPTH_ALTERNATE bit(8) value('00_00_00_00'b);
  declare GFPTH_WINDING bit(8) value('01_00_00_00'b);
  declare GFPTH_MODIFY bit(8) value('00_10_00_00'b);
  declare OCODE_GOPTH bit(8) value('11_01_01_00'b);

 %declare ORDER_GOPTH char;
 %ORDER_GOPTH='char(stg(#ORDER_GOPTH))';
 dcl 1 #ORDER_GOPTH based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 idPath LONG;

  declare OCODE_GMPTH bit(8) value('11_01_10_00'b);

 %declare ORDER_GMPTH char;
 %ORDER_GMPTH='char(stg(#ORDER_GMPTH))';
 dcl 1 #ORDER_GMPTH based(null()) unaligned,
       2 uchMode UCHAR,
       2 uchReserved UCHAR,
       2 idPath LONG;

  declare GMPTH_STROKE bit(8) value('00_00_01_10'b);
  declare OCODE_GCPARC bit(8) value('10_10_00_11'b);
  declare OCODE_GPARC bit(8) value('11_10_00_11'b);

 %declare ORDERS_GCPARC char;
 %ORDERS_GCPARC='char(stg(#ORDERS_GCPARC))';
 dcl 1 #ORDERS_GCPARC based(null()) unaligned,
       2 ptCenter POINTS,
       2 ufx88Multiplier FIXED88,
       2 usStartAngle LONG,
       2 usSweepAngle LONG;
 %declare ORDERL_GCPARC char;
 %ORDERL_GCPARC='char(stg(#ORDERL_GCPARC))';
 dcl 1 #ORDERL_GCPARC based(null()) unaligned,
       2 ptCenter POINTL,
       2 ufxMultiplier FIXED bin(31,16),
       2 usStartAngle LONG,
       2 usSweepAngle LONG;

  declare OCODE_GSCPTH bit(8) value('10_11_01_00'b);

 %declare ORDER_GSCPTH char;
 %ORDER_GSCPTH='char(stg(#ORDER_GSCPTH))';
 dcl 1 #ORDER_GSCPTH based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 idPath LONG;

  declare GSCPTH_ALTERNATE bit(8) value('00_00_00_00'b);
  declare GSCPTH_WINDING bit(8) value('01_00_00_00'b);
  declare GSCPTH_RESET bit(8) value('00_00_00_00'b);
  declare GSCPTH_INTERSECT bit(8) value('00_10_00_00'b);
  declare OCODE_GSAP bit(8) value('00_10_00_10'b);
  declare OCODE_GPSAP bit(8) value('01_10_00_10'b);

 %declare ORDERS_GSAP char;
 %ORDERS_GSAP='char(stg(#ORDERS_GSAP))';
 dcl 1 #ORDERS_GSAP based(null()) unaligned,
       2 p SHORT,
       2 q SHORT,
       2 r SHORT,
       2 s SHORT;
 %declare ORDERL_GSAP char;
 %ORDERL_GSAP='char(stg(#ORDERL_GSAP))';
 dcl 1 #ORDERL_GSAP based(null()) unaligned,
       2 p LONG,
       2 q LONG,
       2 r LONG,
       2 s LONG;
  declare OCODE_GSBICOL bit(8) value('10_10_01_11'b);
  declare OCODE_GPSBICOL bit(8) value('11_10_01_11'b);
  declare OCODE_GSICOL bit(8) value('10_10_01_10'b);
  declare OCODE_GPSICOL bit(8) value('11_10_01_10'b);
 %declare ORDER_GSBICOL char;
 %ORDER_GSBICOL='char(stg(#ORDER_GSBICOL))';
 dcl 1 #ORDER_GSBICOL based(null()) unaligned,
       2 fbFlags UCHAR,
       2 auchColor(3) UCHAR;

  declare SICOL_SPECIFY bit(8) value('00_00_00_00'b);
  declare SICOL_SPECIAL bit(8) value('01_00_00_00'b);
  declare SICOL_DEFAULT bit(8) value('10_00_00_00'b);

 %declare SICOL_BLACK char;
 %SICOL_BLACK=1;
 %declare SICOL_WHITE char;
 %SICOL_WHITE=2;
 %declare SICOL_ONES char;
 %SICOL_ONES=4;
 %declare SICOL_ZEROES char;
 %SICOL_ZEROES=5;

  declare OCODE_GSCC bit(8) value('00_11_00_11'b);
  declare OCODE_GPSCC bit(8) value('00_11_00_11'b);

 %declare ORDERS_GSCC char;
 %ORDERS_GSCC='char(stg(#ORDERS_GSCC))';
 dcl 1 #ORDERS_GSCC based(null()) unaligned,
       2 cxInt SHORT,
       2 cyInt SHORT,
       2 cxFract USHORT,
       2 cyFract USHORT,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR;
 %declare ORDERL_GSCC char;
 %ORDERL_GSCC='char(stg(#ORDERL_GSCC))';
 dcl 1 #ORDERL_GSCC based(null()) unaligned,
       2 cxInt LONG,
       2 cyInt LONG,
       2 cxFract USHORT,
       2 cyFract USHORT,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR;

  declare GSCC_ZERODEF bit(8) value('00_00_00_00'b);
  declare GSCC_ZEROZERO bit(8) value('10_00_00_00'b);
  declare OCODE_GSMC bit(8) value('00_11_01_11'b);
  declare OCODE_GPSMC bit(8) value('01_11_01_11'b);

 %declare ORDERS_GSMC char;
 %ORDERS_GSMC='char(stg(#ORDERS_GSMC))';
 dcl 1 #ORDERS_GSMC based(null()) unaligned,
       2 cx SHORT,
       2 cy SHORT,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR;
 %declare ORDERL_GSMC char;
 %ORDERL_GSMC='char(stg(#ORDERL_GSMC))';
 dcl 1 #ORDERL_GSMC based(null()) unaligned,
       2 cx LONG,
       2 cy LONG,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR;

  declare GSMC_ZERODEF bit(8) value('00_00_00_00'b);
  declare GSMC_ZEROZERO bit(8) value('10_00_00_00'b);
  declare OCODE_GSPRP bit(8) value('10_10_00_00'b);
  declare OCODE_GPSPRP bit(8) value('11_10_00_00'b);

 %declare ORDERS_GSPRP char;
 %ORDERS_GSPRP='char(stg(#ORDERS_GSPRP))';
 dcl 1 #ORDERS_GSPRP based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 ptPos POINTS;
 %declare ORDERL_GSPRP char;
 %ORDERL_GSPRP='char(stg(#ORDERL_GSPRP))';
 dcl 1 #ORDERL_GSPRP based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 ptPos POINTL;

  declare GSPRP_DEFAULT bit(8) value('10_00_00_00'b);
  declare GSPRP_SPECIFY bit(8) value('00_00_00_00'b);
  declare OCODE_GSIA bit(8) value('00_01_01_00'b);
  declare OCODE_GPSIA bit(8) value('01_01_01_00'b);

 %declare GSIA_VL char;
 %GSIA_VL=3;
 %declare ORDER_GSIA char;
 %ORDER_GSIA='char(stg(#ORDER_GSIA))';
 dcl 1 #ORDER_GSIA based(null()) unaligned,
       2 uchAttrType UCHAR,
       2 uchPrimType UCHAR,
       2 fbFlags UCHAR,
       2 auchValue(GSIA_VL) UCHAR;

  declare GSIA_COLOR bit(8) value('00_00_00_01'b);
  declare GSIA_BCOLOR bit(8) value('00_00_00_10'b);
  declare GSIA_MIX bit(8) value('00_00_00_11'b);
  declare GSIA_BMIX bit(8) value('00_00_01_00'b);
  declare GSIA_LINE bit(8) value('00_00_00_01'b);
  declare GSIA_CHAR bit(8) value('00_00_00_10'b);
  declare GSIA_MARKER bit(8) value('00_00_00_11'b);
  declare GSIA_PATTERN bit(8) value('00_00_01_00'b);
  declare GSIA_IMAGE bit(8) value('00_00_01_01'b);
  declare GSIA_SPECIFY bit(8) value('00_00_00_00'b);
  declare GSIA_SPECIAL bit(8) value('01_00_00_00'b);
  declare GSIA_DEFAULT bit(8) value('10_00_00_00'b);

 %declare GSIA_BLACK char;
 %GSIA_BLACK=1;
 %declare GSIA_WHITE char;
 %GSIA_WHITE=2;
 %declare GSIA_ONES char;
 %GSIA_ONES=4;
 %declare GSIA_ZEROES char;
 %GSIA_ZEROES=5;

  declare OCODE_GSTM bit(8) value('00_10_01_00'b);
  declare OCODE_GPSTM bit(8) value('01_10_01_00'b);
  declare OCODE_GSTV bit(8) value('00_11_00_01'b);

 %declare GSTM_ML char;
 %GSTM_ML=16;
 %declare ORDERS_GSTM char;
 %ORDERS_GSTM='char(stg(#ORDERS_GSTM))';
 dcl 1 #ORDERS_GSTM based(null()) unaligned,
       2 uchReserved UCHAR,
       2 fbFlags UCHAR,
       2 fsMask USHORT,
       2 asMatrix(GSTM_ML) SHORT;
 %declare ORDERL_GSTM char;
 %ORDERL_GSTM='char(stg(#ORDERL_GSTM))';
 dcl 1 #ORDERL_GSTM based(null()) unaligned,
       2 uchReserved UCHAR,
       2 fbFlags UCHAR,
       2 fsMask USHORT,
       2 alMatrix(GSTM_ML) LONG;

  declare GSTM_M11 fixed bin(16) value('80_00'xn);
  declare GSTM_M12 fixed bin(16) value('40_00'xn);
  declare GSTM_M13 fixed bin(16) value('20_00'xn);
  declare GSTM_M14 fixed bin(16) value('10_00'xn);
  declare GSTM_M21 fixed bin(16) value('08_00'xn);
  declare GSTM_M22 fixed bin(16) value('04_00'xn);
  declare GSTM_M23 fixed bin(16) value('02_00'xn);
  declare GSTM_M24 fixed bin(16) value('01_00'xn);
  declare GSTM_M31 fixed bin(16) value('00_80'xn);
  declare GSTM_M32 fixed bin(16) value('00_40'xn);
  declare GSTM_M33 fixed bin(16) value('00_20'xn);
  declare GSTM_M34 fixed bin(16) value('00_10'xn);
  declare GSTM_M41 fixed bin(16) value('00_08'xn);
  declare GSTM_M42 fixed bin(16) value('00_04'xn);
  declare GSTM_M43 fixed bin(16) value('00_02'xn);
  declare GSTM_M44 fixed bin(16) value('00_01'xn);

  declare GSTM_UNITY bit(8) value('00_00_00_00'b);
  declare GSTM_AFTER bit(8) value('00_00_00_01'b);
  declare GSTM_BEFORE bit(8) value('00_00_00_10'b);
  declare GSTM_OVERWRITE bit(8) value('00_00_00_11'b);
  declare GSTV_OVERWRITE bit(8) value('00_00_00_00'b);
  declare GSTV_AFTER bit(8) value('00_00_01_00'b);
  declare OCODE_GSSB bit(8) value('00_11_00_10'b);
  declare OCODE_GSVW bit(8) value('00_10_01_11'b);
  declare OCODE_GPSVW bit(8) value('01_10_01_11'b);

 %declare GSSB_ML char;
 %GSSB_ML=4;
 %declare ORDERS_GSSB char;
 %ORDERS_GSSB='char(stg(#ORDERS_GSSB))';
 dcl 1 #ORDERS_GSSB based(null()) unaligned,
       2 fbFlags UCHAR,
       2 fbMask UCHAR,
       2 alMatrix(GSSB_ML) SHORT;
 %declare ORDERL_GSSB char;
 %ORDERL_GSSB='char(stg(#ORDERL_GSSB))';
 dcl 1 #ORDERL_GSSB based(null()) unaligned,
       2 fbFLags UCHAR,
       2 fbMask UCHAR,
       2 alMatrix(GSSB_ML) LONG;

  declare GSSB_XLEFT bit(8) value('00_10_00_00'b);
  declare GSSB_XRIGHT bit(8) value('00_01_00_00'b);
  declare GSSB_YBOTTOM bit(8) value('00_00_10_00'b);
  declare GSSB_YTOP bit(8) value('00_00_01_00'b);
  declare GSVW_INTERSECT bit(8) value('00_00_00_00'b);
  declare GSVW_REPLACE bit(8) value('10_00_00_00'b);
  declare OCODE_GSGCH bit(8) value('00_00_01_00'b);

 %declare GSGCH_ML char;
 %GSGCH_ML=254;
 %declare ORDER_GSGCH char;
 %ORDER_GSGCH='char(stg(#ORDER_GSGCH))';
 dcl 1 #ORDER_GSGCH based(null()) unaligned,
       2 uchIdent UCHAR,
       2 auchData(GSGCH_ML) UCHAR;

  declare OCODE_GSSLW bit(8) value('00_01_01_01'b);
  declare OCODE_GPSSLW bit(8) value('01_01_01_01'b);

 %declare ORDERS_GSSLW char;
 %ORDERS_GSSLW='char(stg(#ORDERS_GSSLW))';
 dcl 1 #ORDERS_GSSLW based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 LineWidth SHORT;
 %declare ORDERL_GSSLW char;
 %ORDERL_GSSLW='char(stg(#ORDERL_GSSLW))';
 dcl 1 #ORDERL_GSSLW based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 LineWidth LONG;

  declare GSSLW_DEFAULT bit(8) value('10_00_00_00'b);
  declare GSSLW_SPECIFY bit(8) value('00_00_00_00'b);
  declare OCODE_GCSFLT bit(8) value('10_10_01_00'b);
  declare OCODE_GSFLT bit(8) value('11_10_01_00'b);

 %declare GCSFLT_SMF char;
 %GCSFLT_SMF=21;
 %declare GSFLT_SMF char;
 %GSFLT_SMF=20;
 %declare ORDERS_GCSFLT char;
 %ORDERS_GCSFLT='char(stg(#ORDERS_GCSFLT))';
 dcl 1 #ORDERS_GCSFLT based(null()) unaligned,
       2 apt(2*GCSFLT_SMF) POINTS,
       2 afxSharpness(GCSFLT_SMF) FIXED bin(31,16);
 %declare GCSFLT_LMF char;
 %GCSFLT_LMF=12;
 %declare GSFLT_LMF char;
 %GSFLT_LMF=12;
 %declare ORDERL_GCSFLT char;
 %ORDERL_GCSFLT='char(stg(#ORDERL_GCSFLT))';
 dcl 1 #ORDERL_GCSFLT based(null()) unaligned,
       2 apt(2*GCSFLT_SMF) POINTL,
       2 afxSharpness(GCSFLT_SMF) FIXED bin(31,16);

  declare OCODE_GBBLT bit(8) value('11_01_01_10'b);

 %declare ORDERS_GBBLT char;
 %ORDERS_GBBLT='char(stg(#ORDERS_GBBLT))';
 dcl 1 #ORDERS_GBBLT based(null()) unaligned,
       2 fsFlags USHORT,
       2 usMix USHORT,
       2 hbmSrc HBITMAP,
       2 lOptions LONG,
       2 rcsTargetRect RECT1S,
       2 rclSourceRect RECTL;
 %declare ORDERL_GBBLT char;
 %ORDERL_GBBLT='char(stg(#ORDERL_GBBLT))';
 dcl 1 #ORDERL_GBBLT based(null()) unaligned,
       2 fsFlags USHORT,
       2 usMix USHORT,
       2 hbmSrc HBITMAP,
       2 lOptions LONG,
       2 rclTargetRect RECTL,
       2 rclSourceRect RECTL;

  declare OCODE_GSCE bit(8) value('00_01_01_11'b);
  declare OCODE_GPSCE bit(8) value('01_01_01_11'b);
  declare OCODE_GSCBE bit(8) value('00_00_01_01'b);
  declare OCODE_GPSCBE bit(8) value('01_00_01_01'b);

 %declare ORDER_GSCBE char;
 %ORDER_GSCBE='char(stg(#ORDER_GSCBE))';
 dcl 1 #ORDER_GSCBE based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 ufxextra FIXED bin(31,16);

  declare OCODE_GESCP bit(8) value('11_01_01_01'b);

 %declare GESCP_ML char;
 %GESCP_ML=253;
 %declare ORDER_GESCP char;
 %ORDER_GESCP='char(stg(#ORDER_GESCP))';
 dcl 1 #ORDER_GESCP based(null()) unaligned,
       2 uchType UCHAR,
       2 uchIdent UCHAR,
       2 auchData(GESCP_ML) UCHAR;

  declare GESCP_REG bit(8) value('10_00_00_00'b);
  declare GEBB_REGID bit(8) value('00_00_00_10'b);
  declare ETYPE_GEBB fixed bin(31) value('80_02_00_D5'xn);

 %declare GEBB_LMP char;
 %GEBB_LMP=29;
 %declare ORDERL_GEBB char;
 %ORDERL_GEBB='char(stg(#ORDERL_GEBB))';
 dcl 1 #ORDERL_GEBB based(null()) unaligned,
       2 fbFlags UCHAR,
       2 usMix USHORT,
       2 cPoints UCHAR,
       2 hbmSrc HBITMAP,
       2 lReserved LONG,
       2 lOptions LONG,
       2 aptPoints(GEBB_LMP) POINTL;
  declare GEPEL_REGID bit(8) value('00_00_00_01'b);
  declare ETYPE_GEPEL fixed bin(31) value('80_01_00_D5'xn);
  declare GEDB_REGID bit(8) value('00_00_01_00'b);
  declare ETYPE_GEDB fixed bin(31) value('80_04_00_D5'xn);

 %declare ORDERL_GEDB char;
 %ORDERL_GEDB='char(stg(#ORDERL_GEDB))';
 dcl 1 #ORDERL_GEDB based(null()) unaligned,
       2 fsFlags USHORT,
       2 usMix USHORT,
       2 pBits PVOID,
       2 pbmi PBITMAPINFO2,
       2 lOptions LONG,
       2 rclTargetRect RECTL,
       2 rclSourceRect RECTL;

  declare GEFF_REGID bit(8) value('00_00_00_11'b);
  declare ETYPE_GEFF fixed bin(31) value('80_03_00_D5'xn);

 %declare ORDERL_GEFF char;
 %ORDERL_GEFF='char(stg(#ORDERL_GEFF))';
 dcl 1 #ORDERL_GEFF based(null()) unaligned,
       2 fsFlags UCHAR,
       2 auchColor(3) UCHAR;

 declare ETYPE_LINEBUNDLE fixed bin(31) value('00_00_FD_01'xn);
 declare ETYPE_CHARBUNDLE fixed bin(31) value('00_00_FD_02'xn);
 declare ETYPE_MARKERBUNDLE fixed bin(31) value('00_00_FD_03'xn);
 declare ETYPE_AREABUNDLE fixed bin(31) value('00_00_FD_04'xn);
 declare ETYPE_IMAGEBUNDLE fixed bin(31) value('00_00_FD_05'xn);

 %declare VORDER_ML char;
 %VORDER_ML=65531;
 %declare VORDER char;
 %VORDER='char(stg(#VORDER))';
 dcl 1 #VORDER based(null()) unaligned,
       2 idCode UCHAR,
       2 uchQualifier UCHAR,
       2 uchLength SWPUSHORT,
       2 uchData(VORDER_ML) UCHAR;

 declare OCODEQ_GCCHSTE bit(8) value('10_11_00_00'b);
 declare OCODEQ_GCHSTE bit(8) value('11_11_00_00'b);
 declare ETYPE_GCCHSTE fixed bin(31) value('00_00_FE_B0'xn);
 declare ETYPE_GCHSTE fixed bin(31) value('00_00_FE_F0'xn);

 %declare ORDERS_GCCHSTE char;
 %ORDERS_GCCHSTE='char(stg(#ORDERS_GCCHSTE))';
 dcl 1 #ORDERS_GCCHSTE based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 ptRect(2) POINTS,
       2 cchString SWPUSHORT,
       2 achString(1) CHAR,
       2 adx(1) SHORT;
 %declare ORDERL_GCCHSTE char;
 %ORDERL_GCCHSTE='char(stg(#ORDERL_GCCHSTE))';
 dcl 1 #ORDERL_GCCHSTE based(null()) unaligned,
       2 fbFlags UCHAR,
       2 uchReserved UCHAR,
       2 ptRect(2) POINTL,
       2 cchString SWPUSHORT,
       2 achString(1) CHAR,
       2 adx(1) LONG;

 declare GCCHSTE_DRAWRECT bit(8) value('00_00_00_00'b);
 declare GCCHSTE_NORECT bit(8) value('00_00_00_00'b);
 declare GCCHSTE_CLIP bit(8) value('01_00_00_00'b);
 declare GCCHSTE_NOCLIP bit(8) value('00_00_00_00'b);
 declare GCCHSTE_DEEMPHASIZE bit(8) value('00_10_00_00'b);
 declare GCCHSTE_NODEEMPHASIZE bit(8) value('00_00_00_00'b);
 declare GCCHSTE_LEAVEPOS bit(8) value('00_01_00_00'b);
 declare GCCHSTE_MOVEPOS bit(8) value('00_00_00_00'b);
 declare GCCHSTE_UNDERSCORE bit(8) value('00_00_10_00'b);
 declare GCCHSTE_NOUNDERSCORE bit(8) value('00_00_00_00'b);
 declare GCCHSTE_STRIKEOUT bit(8) value('00_00_01_00'b);
 declare GCCHSTE_NOSTRIKEOUT bit(8) value('00_00_00_00'b);
 declare OCODEQ_GEESCP bit(8) value('11_01_01_01'b);
 %declare GEESCP_ML char;
 %GEESCP_ML=65533;
 %declare ORDER_GEESCP char;
 %ORDER_GEESCP='char(stg(#ORDER_GEESCP))';
 dcl 1 #ORDER_GEESCP based(null()) unaligned,
       2 uchType UCHAR,
       2 uchIdent UCHAR,
       2 auchData(GEESCP_ML) UCHAR;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
