 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: PMWIN.CPY                                    */
 /*                                                                  */
 /*  NAME - PMWIN.CPY                                                */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*    Presentation Manager PL/I include file.                       */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1992. All Rights Reserved.            */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 /*==================================================================*/
 /*                                                                  */
 /* The folowing symbols are used in this file for conditional       */
 /* sections.                                                        */
 /*                                                                  */
 /* If INCL_WIN is defined, all subcomponents are included.          */
 /*                                                                  */
 /* Subcomponents marked with "+" are partially included by default: */
 /*                                                                  */
 /*   #define:                To include:                            */
 /*                                                                  */
 /* + INCL_WINWINDOWMGR       General window management              */
 /* + INCL_WINMESSAGEMGR      Message management                     */
 /* + INCL_WININPUT           Mouse and keyboard input               */
 /* + INCL_WINDIALOGS         Dialog boxes                           */
 /* + INCL_WINSTATICS         Static controls                        */
 /* + INCL_WINBUTTONS         Button controls                        */
 /* + INCL_WINENTRYFIELDS     Entry Fields                           */
 /*   INCL_WINMLE             Multiple Line Entry Fields             */
 /* + INCL_WINLISTBOXES       List box controls                      */
 /* + INCL_WINMENUS           Menu controls                          */
 /* + INCL_WINSCROLLBARS      Scroll bar controls                    */
 /* + INCL_WINFRAMEMGR        Frame manager                          */
 /*   INCL_WINFRAMECTLS       Frame controls (title bars & size      */
 /*                           border)                                */
 /*   INCL_WINRECTANGLES      Rectangle routines                     */
 /*   INCL_WINSYS             System values (and colors)             */
 /*   INCL_WINTIMER           Timer routines                         */
 /* + INCL_WINACCELERATORS    Keyboard accelerators                  */
 /*   INCL_WINTRACKRECT       WinTrackRect() function                */
 /*   INCL_WINCLIPBOARD       Clipboard manager                      */
 /* + INCL_WINCURSORS         Text cursors                           */
 /* + INCL_WINPOINTERS        Mouse pointers                         */
 /*   INCL_WINHOOKS           Hook manager                           */
 /* + INCL_WINSWITCHLIST      Shell Switch List API                  */
 /*   INCL_WINPROGRAMLIST     Shell Program List API                 */
 /*   INCL_WINSHELLDATA       Shell Data (?)                         */
 /*   INCL_WINCOUNTRY         Country support                        */
 /*   INCL_WINHEAP            Heap Manager                           */
 /*   INCL_WINATOM            Atom Manager                           */
 /*   INCL_WINERRORS          Error code definitions                 */
 /*   INCL_NLS                DBCS window manager definition         */
 /* + INCL_WINHELP            Help Manager definitions               */
 /*   INCL_WINSEI             Set Error Info API                     */
 /*   INCL_WINLOAD            Load/Delete Library/Procedure          */
 /*   INCL_WINTYPES           Definitions for Datatypes              */
 /*   INCL_WINTHUNKAPI        Thunk Procedure API                    */
 /*   INCL_WINDESKTOP         Desktop API                            */
 /*                                                                  */
 /*==================================================================*/
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;
 %PMWIN_INCLUDED = 'Y';
 %if INCL_WIN='Y' %then %do;
   %INCL_WINWINDOWMGR='Y';
   %INCL_WINMESSAGEMGR='Y';
   %INCL_WININPUT='Y';
   %INCL_WINDIALOGS='Y';
   %INCL_WINSTATICS='Y';
   %INCL_WINBUTTONS='Y';
   %INCL_WINENTRYFIELDS='Y';
   %INCL_WINMLE='Y';
   %INCL_WINLISTBOXES='Y';
   %INCL_WINMENUS='Y';
   %INCL_WINSCROLLBARS='Y';
   %INCL_WINFRAMEMGR='Y';
   %INCL_WINFRAMECTLS='Y';
   %INCL_WINRECTANGLES='Y';
   %INCL_WINSYS='Y';
   %INCL_WINTIMER='Y';
   %INCL_WINACCELERATORS='Y';
   %INCL_WINTRACKRECT='Y';
   %INCL_WINCLIPBOARD='Y';
   %INCL_WINCURSORS='Y';
   %INCL_WINPOINTERS='Y';
   %INCL_WINHOOKS='Y';
   %INCL_WINSWITCHLIST='Y';
   %INCL_WINPROGRAMLIST='Y';
   %INCL_WINSHELLDATA='Y';
   %INCL_WINCOUNTRY='Y';
   %INCL_WINHEAP='Y';
   %INCL_WINATOM='Y';
   %INCL_WINERRORS='Y';
   %INCL_WINDDE='Y';
   %INCL_WINHELP='Y';
   %INCL_WINSEI='Y';
   %INCL_WINLOAD='Y';
   %INCL_WINTYPES='Y';
   %INCL_WINDESKTOP='Y';
   %INCL_WINPALETTE='Y';
   %INCL_WINTHUNKAPI='Y';
   %INCL_WINSTDDLGS='Y';
 %end;
 %else %do;
   %if RC_INVOKED='Y' %then %do;
     %INCL_WININPUT='Y';
     %INCL_WINDIALOGS='Y';
     %INCL_WINSTATICS='Y';
     %INCL_WINBUTTONS='Y';
     %INCL_WINENTRYFIELDS='Y';
     %INCL_WINLISTBOXES='Y';
     %INCL_WINMENUS='Y';
     %INCL_WINSCROLLBARS='Y';
     %INCL_WINFRAMEMGR='Y';
     %INCL_WINFRAMECTLS='Y';
     %INCL_WINACCELERATORS='Y';
     %INCL_WINPOINTERS='Y';
     %INCL_WINMESSAGEMGR='Y';
     %INCL_WINMLE='Y';
     %INCL_WINHELP='Y';
     %INCL_WINSTDDLGS='Y';
     %INCL_WINSYS='Y';
   %end;
 %end;
 %if INCL_WINMLE='Y' %then %do;
   %if INCL_WINENTRYFIELDS='Y' %then %do;
     %INCL_WINENTRYFIELDS='Y';
   %end;
 %end;
 %if INCL_WINCOMMON='Y' %then %do;
   %INCL_WINWINDOWMGR='Y';
 %end;
 %if INCL_ERRORS='Y' %then %do;
   %INCL_WINERRORS='Y';
 %end;
 %declare MPARAM char;
 %MPARAM='pointer';
 %declare PMPARAM char;
 %PMPARAM='pointer';
 %declare MRESULT char;
 %MRESULT = 'pointer';
 %declare PMRESULT char;
 %PMRESULT='pointer';
  dcl
   1 #RCL based( null() ) unaligned,
     2 RCL_xLeft   LONG,
     2 RCL_yBottom LONG,
     2 RCL_xRight  LONG,
     2 RCL_yTop    LONG;
 %declare RCL char;
 %RCL     = 'char ( stg( #RCL ))';      /* Rectangle Structure       */
 declare MPVOID pointer value(ptrvalue(0));
 %declare PFNWP char;
 %PFNWP='entry(HWND, ULONG, MPARAM, MPARAM) limited
         returns( optional byvalue MRESULT )
         options( byvalue nodescriptor linkage( system ) )';
   declare
     HWND_DESKTOP        pointer value(ptrvalue(1)),
     HWND_OBJECT         pointer value(ptrvalue(2)),
     HWND_TOP            pointer value(ptrvalue(3)),
     HWND_BOTTOM         pointer value(ptrvalue(4)),
     HWND_THREADCAPTURE  pointer value(ptrvalue(5));

 declare WC_FRAME      pointer value(ptrvalue('FF_FF_00_01'xn));
 declare WC_COMBOBOX   pointer value(ptrvalue('FF_FF_00_02'xn));
 declare WC_BUTTON     pointer value(ptrvalue('FF_FF_00_03'xn));
 declare WC_MENU       pointer value(ptrvalue('FF_FF_00_04'xn));
 declare WC_STATIC     pointer value(ptrvalue('FF_FF_00_05'xn));
 declare WC_ENTRYFIELD pointer value(ptrvalue('FF_FF_00_06'xn));
 declare WC_LISTBOX    pointer value(ptrvalue('FF_FF_00_07'xn));
 declare WC_SCROLLBAR  pointer value(ptrvalue('FF_FF_00_08'xn));
 declare WC_TITLEBAR   pointer value(ptrvalue('FF_FF_00_09'xn));
 declare WC_MLE        pointer value(ptrvalue('FF_FF_00_0A'xn));

 /* 000B to 000F reserved */

 declare WC_APPSTAT    pointer value(ptrvalue('FF_FF_00_10'xn));
 declare WC_KBDSTAT    pointer value(ptrvalue('FF_FF_00_11'xn));
 declare WC_PECIC      pointer value(ptrvalue('FF_FF_00_12'xn));
 declare WC_DBE_KKPOPUP pointer value(ptrvalue('FF_FF_00_13'xn));

 /* 0014 to 001F reserved */

 declare WC_SPINBUTTON pointer value(ptrvalue('FF_FF_00_20'xn));

 /* 0021 to 0024 reserved */

 declare WC_CONTAINER  pointer value(ptrvalue('FF_FF_00_25'xn));
 declare WC_SLIDER     pointer value(ptrvalue('FF_FF_00_26'xn));
 declare WC_VALUESET   pointer value(ptrvalue('FF_FF_00_27'xn));
 declare WC_NOTEBOOK   pointer value(ptrvalue('FF_FF_00_28'xn));
 declare WC_PENFIRST   pointer value(ptrvalue('FF_FF_00_29'xn));
 declare WC_PENLAST    pointer value(ptrvalue('FF_FF_00_2C'xn));
 declare WC_MMPMFIRST  pointer value(ptrvalue('FF_FF_00_40'xn));
 declare WC_MMPMLAST   pointer value(ptrvalue('FF_FF_00_4F'xn));

 /*** Standard Window Styles ***************************************/

 declare WS_VISIBLE      fixed bin(31) value('80_00_00_00'xn);
 declare WS_DISABLED     fixed bin(31) value('40_00_00_00'xn);
 declare WS_CLIPCHILDREN fixed bin(31) value('20_00_00_00'xn);
 declare WS_CLIPSIBLINGS fixed bin(31) value('10_00_00_00'xn);
 declare WS_PARENTCLIP   fixed bin(31) value('08_00_00_00'xn);
 declare WS_SAVEBITS     fixed bin(31) value('04_00_00_00'xn);
 declare WS_SYNCPAINT    fixed bin(31) value('02_00_00_00'xn);
 declare WS_MINIMIZED    fixed bin(31) value('01_00_00_00'xn);
 declare WS_MAXIMIZED    fixed bin(31) value('00_80_00_00'xn);
 declare WS_ANIMATE      fixed bin(31) value('00_04_00_00'xn);

 /*** Dialog manager styles *****************************************/

 declare WS_GROUP        fixed bin(31) value('00_01_00_00'xn);
 declare WS_TABSTOP      fixed bin(31) value('00_02_00_00'xn);
 declare WS_MULTISELECT  fixed bin(31) value('00_04_00_00'xn);
 declare CS_MOVENOTIFY   fixed bin(31) value('00_00_00_01'xn);
 declare CS_SIZEREDRAW   fixed bin(31) value('00_00_00_04'xn);
 declare CS_HITTEST      fixed bin(31) value('00_00_00_08'xn);
 declare CS_PUBLIC       fixed bin(31) value('00_00_00_10'xn);
 declare CS_FRAME        fixed bin(31) value('00_00_00_20'xn);
 declare CS_CLIPCHILDREN fixed bin(31) value('20_00_00_00'xn);
 declare CS_CLIPSIBLINGS fixed bin(31) value('10_00_00_00'xn);
 declare CS_PARENTCLIP   fixed bin(31) value('08_00_00_00'xn);
 declare CS_SAVEBITS     fixed bin(31) value('04_00_00_00'xn);
 declare CS_SYNCPAINT    fixed bin(31) value('02_00_00_00'xn);

 /*******************************************************************/
 /*** Window Manager Subsection part 1 ******************************/
 /*******************************************************************/

 %if INCL_WINWINDOWMGR='Y' | INCL_NOCOMMON='Y' %then %do;
   dcl WinRegisterClass entry (
          HAB,
          char(*) varyingz byaddr,
          PFNWP,
          ULONG,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinDefWindowProc entry (
          HWND,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue MRESULT)
          APIENTRY;
   dcl WinDestroyWindow entry (
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinShowWindow entry (
          HWND,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryWindowRect entry (
          HWND,
          PRECTL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinGetPS entry (
          HWND)
          returns(optional byvalue HPS)
          APIENTRY;
   dcl WinReleasePS entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinEndPaint entry (
          HPS)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinGetClipPS entry (
            HWND,
            HWND,
            ULONG)
            returns(optional byvalue HPS)
            APIENTRY;
     dcl WinIsWindowShowing entry (
            HWND)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl WinBeginPaint entry (
          HWND,
          HWND, /*HPS,*/
          PRECTL)
          returns(optional byvalue HPS)
          APIENTRY;
   dcl WinOpenWindowDC entry (
          HWND)
          returns(optional byvalue HDC)
          APIENTRY;
   dcl WinScrollWindow entry (
          HWND,
          LONG,
          LONG,
          PRECTL,
          PRECTL,
          HRGN,
          PRECTL,
          ULONG)
          returns(optional byvalue LONG)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     declare PSF_LOCKWINDOWUPDATE fixed bin(16) value('00_01'xn);
     declare PSF_CLIPUPWARDS     fixed bin(16) value('00_02'xn);
     declare PSF_CLIPDOWNWARDS   fixed bin(16) value('00_04'xn);
     declare PSF_CLIPSIBLINGS    fixed bin(16) value('00_08'xn);
     declare PSF_CLIPCHILDREN    fixed bin(16) value('00_10'xn);
     declare PSF_PARENTCLIP      fixed bin(16) value('00_20'xn);
   %end;
   declare SW_SCROLLCHILDREN     fixed bin(16) value('00_01'xn);
   declare SW_INVALIDATERGN      fixed bin(16) value('00_02'xn);
   dcl WinFillRect entry (
          HPS,
          PRECTL,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %declare QVERSDATA char;
   %QVERSDATA='char(stg(#QVERSDATA))';
   dcl 1 #QVERSDATA based(null()) unaligned,
         2 environment USHORT,
         2 version USHORT;
   %declare PQVERSDATA char;
   %PQVERSDATA='pointer';
   declare QV_OS2      fixed bin(16) value('00_00'xn);
   declare QV_CMS      fixed bin(16) value('00_01'xn);
   declare QV_TSO      fixed bin(16) value('00_02'xn);
   declare QV_TSOBATCH fixed bin(16) value('00_03'xn);
   declare QV_OS400    fixed bin(16) value('00_04'xn);
   dcl WinQueryVersion entry (
          HAB)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl WinInitialize entry (
          ULONG)
          returns(optional byvalue HAB)
          APIENTRY;
   dcl WinTerminate entry (
          HAB)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryAnchorBlock entry (
          HWND)
          returns(optional byvalue HAB)
          APIENTRY;
 %end;
 dcl WinCreateWindow entry (
        HWND,
        char(*) varyingz byaddr,
        char(*) varyingz byaddr,
        ULONG,
        LONG,
        LONG,
        LONG,
        LONG,
        HWND,
        HWND,
        ULONG,
        PVOID,
        PVOID)
        returns(optional byvalue HWND)
        APIENTRY;
 dcl WinEnableWindow entry (
        HWND,
        BOOL)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinIsWindowEnabled entry (
        HWND)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinEnableWindowUpdate entry (
        HWND,
        BOOL)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinIsWindowVisible entry (
        HWND)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinQueryWindowText entry (
        HWND,
        LONG,
        PCH)
        returns(optional byvalue LONG)
        APIENTRY;
 dcl WinSetWindowText entry (
        HWND,
        char(*) varyingz byaddr )
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinQueryWindowTextLength entry (
        HWND)
        returns(optional byvalue LONG)
        APIENTRY;
 dcl WinWindowFromID entry (
        HWND,
        ULONG)
        returns(optional byvalue HWND)
        APIENTRY;
 dcl WinIsWindow entry (
        HAB,
        HWND)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinQueryWindow entry (
        HWND,
        LONG)
        returns(optional byvalue HWND)
        APIENTRY;
 dcl WinMultWindowFromIDs entry (
        HWND,
        PHWND,
        ULONG,
        ULONG)
        returns(optional byvalue LONG)
        APIENTRY;
 %declare QW_NEXT char;
 %QW_NEXT=0;
 %declare QW_PREV char;
 %QW_PREV=1;
 %declare QW_TOP char;
 %QW_TOP=2;
 %declare QW_BOTTOM char;
 %QW_BOTTOM=3;
 %declare QW_OWNER char;
 %QW_OWNER=4;
 %declare QW_PARENT char;
 %QW_PARENT=5;
 %declare QW_NEXTTOP char;
 %QW_NEXTTOP=6;
 %declare QW_PREVTOP char;
 %QW_PREVTOP=7;
 %declare QW_FRAMEOWNER char;
 %QW_FRAMEOWNER=8;
 dcl WinSetParent entry (
        HWND,
        HWND,
        BOOL)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinIsChild entry (
        HWND,
        HWND)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinSetOwner entry (
        HWND,
        HWND)
        returns(optional byvalue BOOL)
        APIENTRY;
 %if INCL_SAADEFS='Y' %then %do;
   dcl WinQueryWindowProcess entry (
          HWND,
          PPID,
          PTID)
          returns(optional byvalue BOOL)
          APIENTRY;
 %end;
 dcl WinQueryObjectWindow entry (
        HWND)
        returns(optional byvalue HWND)
        APIENTRY;
 dcl WinQueryDesktopWindow entry (
        HAB,
        HDC)
        returns(optional byvalue HWND)
        APIENTRY;
 %declare SWP char;
 %SWP='char(stg(#SWP))';
 dcl 1 #SWP based(null()) unaligned,
       2 fl ULONG,
       2 cy LONG,
       2 cx LONG,
       2 y LONG,
       2 x LONG,
       2 hwndInsertBehind HWND,
       2 SWP_hwnd HWND,
       2 ulReserved1 ULONG,
       2 ulReserved2 ULONG;
 %declare PSWP char;
 %PSWP='pointer';
 dcl WinSetWindowPos entry (
        HWND,
        HWND,
        LONG,
        LONG,
        LONG,
        LONG,
        ULONG)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinSetMultWindowPos entry (
        HAB,
        PSWP,
        ULONG)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinQueryWindowPos entry (
        HWND,
        PSWP)
        returns(optional byvalue BOOL)
        APIENTRY;
 declare AWP_MINIMIZED fixed bin(31) value('00_01_00_00'xn);
 declare AWP_MAXIMIZED fixed bin(31) value('00_02_00_00'xn);
 declare AWP_RESTORED  fixed bin(31) value('00_04_00_00'xn);
 declare AWP_ACTIVATE  fixed bin(31) value('00_08_00_00'xn);
 declare AWP_DEACTIVATE fixed bin(31) value('00_10_00_00'xn);
 declare SWP_SIZE      fixed bin(16) value('00_01'xn);
 declare SWP_MOVE      fixed bin(16) value('00_02'xn);
 declare SWP_ZORDER    fixed bin(16) value('00_04'xn);
 declare SWP_SHOW      fixed bin(16) value('00_08'xn);
 declare SWP_HIDE      fixed bin(16) value('00_10'xn);
 declare SWP_NOREDRAW  fixed bin(16) value('00_20'xn);
 declare SWP_NOADJUST  fixed bin(16) value('00_40'xn);
 declare SWP_ACTIVATE  fixed bin(16) value('00_80'xn);
 declare SWP_DEACTIVATE     fixed bin(16) value('01_00'xn);
 declare SWP_EXTSTATECHANGE fixed bin(16) value('02_00'xn);
 declare SWP_MINIMIZE       fixed bin(16) value('04_00'xn);
 declare SWP_MAXIMIZE       fixed bin(16) value('08_00'xn);
 declare SWP_RESTORE        fixed bin(16) value('10_00'xn);
 declare SWP_FOCUSACTIVATE  fixed bin(16) value('20_00'xn);
 declare SWP_FOCUSDEACTIVATE fixed bin(16) value('40_00'xn);
 declare SWP_NOAUTOCLOSE    fixed bin(16) value('80_00'xn);
 dcl WinUpdateWindow entry (
        HWND)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinInvalidateRect entry (
        HWND,
        PRECTL,
        BOOL)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinInvalidateRegion entry (
        HWND,
        HRGN,
        BOOL)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinInvertRect entry (
        HPS,
        PRECTL)
        returns(optional byvalue BOOL)
        APIENTRY;
 dcl WinDrawBitmap entry (
        HPS,
        HBITMAP,
        PRECTL,
        PPOINTL,
        LONG,
        LONG,
        ULONG)
        returns(optional byvalue BOOL)
        APIENTRY;
 declare DBM_NORMAL     fixed bin(16) value('00_00'xn);
 declare DBM_INVERT     fixed bin(16) value('00_01'xn);
 declare DBM_HALFTONE   fixed bin(16) value('00_02'xn);
 declare DBM_STRETCH    fixed bin(16) value('00_04'xn);
 declare DBM_IMAGEATTRS fixed bin(16) value('00_08'xn);
 dcl WinDrawText entry (
        HPS,
        LONG,
        PCH,
        PRECTL,
        LONG,
        LONG,
        ULONG)
        returns(optional byvalue LONG)
        APIENTRY;
 declare DT_LEFT            fixed bin(16) value('00_00'xn);
 declare DT_QUERYEXTENT     fixed bin(16) value('00_02'xn);
 declare DT_UNDERSCORE      fixed bin(16) value('00_10'xn);
 declare DT_STRIKEOUT       fixed bin(16) value('00_20'xn);
 declare DT_TEXTATTRS       fixed bin(16) value('00_40'xn);
 declare DT_EXTERNALLEADING fixed bin(16) value('00_80'xn);
 declare DT_CENTER          fixed bin(16) value('01_00'xn);
 declare DT_RIGHT           fixed bin(16) value('02_00'xn);
 declare DT_TOP             fixed bin(16) value('00_00'xn);
 declare DT_VCENTER         fixed bin(16) value('04_00'xn);
 declare DT_BOTTOM          fixed bin(16) value('08_00'xn);
 declare DT_HALFTONE        fixed bin(16) value('10_00'xn);
 declare DT_MNEMONIC        fixed bin(16) value('20_00'xn);
 declare DT_WORDBREAK       fixed bin(16) value('40_00'xn);
 declare DT_ERASERECT       fixed bin(16) value('80_00'xn);
 dcl WinDrawBorder entry (
        HPS,
        PRECTL,
        LONG,
        LONG,
        LONG,
        LONG,
        ULONG)
        returns(optional byvalue BOOL)
        APIENTRY;
 declare DB_PATCOPY    fixed bin(16) value('00_00'xn);
 declare DB_PATINVERT  fixed bin(16) value('00_01'xn);
 declare DB_DESTINVERT fixed bin(16) value('00_02'xn);
 declare DB_AREAMIXMODE fixed bin(16) value('00_03'xn);
 declare DB_ROP        fixed bin(16) value('00_07'xn);
 declare DB_INTERIOR   fixed bin(16) value('00_08'xn);
 declare DB_AREAATTRS  fixed bin(16) value('00_10'xn);
 declare DB_STANDARD   fixed bin(16) value('01_00'xn);
 declare DB_DLGBORDER  fixed bin(16) value('02_00'xn);
 dcl WinLoadString entry (
        HAB,
        HMODULE,
        ULONG,
        LONG,
        PSZ)
        returns(optional byvalue LONG)
        APIENTRY;
 %if INCL_SAADEFS='Y' %then %do;
   dcl WinLoadMessage entry (
          HAB,
          HMODULE,
          ULONG,
          LONG,
          PSZ)
          returns(optional byvalue LONG)
          APIENTRY;
 %end;
 %if INCL_WINWINDOWMGR='Y' | INCL_NOCOMMON='Y' %then %do;
   dcl WinSetActiveWindow entry (
          HWND,
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
 %end;
 %if INCL_WINWINDOWMGR='Y' %then %do;
   %declare CREATESTRUCT char;
   %CREATESTRUCT='char(stg(#CREATESTRUCT))';
   dcl 1 #CREATESTRUCT based(null()) unaligned,
         2 pbPresParams PVOID,
         2 pCtlData PVOID,
         2 id ULONG,
         2 hwndInsertBehind HWND,
         2 hwndOwner HWND,
         2 cy LONG,
         2 cx LONG,
         2 y LONG,
         2 x LONG,
         2 flStyle ULONG,
         2 pszText PSZ,
         2 pszClass PSZ,
         2 hwndParent HWND;
   %declare PCREATESTRUCT char;
   %PCREATESTRUCT='pointer';
   %declare CLASSINFO char;
   %CLASSINFO='char(stg(#CLASSINFO))';
   dcl 1 #CLASSINFO based(null()) unaligned,
         2 flClassStyle ULONG,
         2 pfnWindowProc PFNWP,
         2 cbWindowData ULONG;
   %declare PCLASSINFO char;
   %PCLASSINFO='pointer';
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinSubclassWindow entry (
            HWND,
            PFNWP)
            returns(optional byvalue PFNWP)
            APIENTRY;
   %end;
   dcl WinQueryClassName entry (
          HWND,
          LONG,
          PCH)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl WinQueryClassInfo entry (
          HAB,
          PSZ,
          PCLASSINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryActiveWindow entry (
          HWND)
          returns(optional byvalue HWND)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinIsThreadActive entry (
            HAB)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl WinQuerySysModalWindow entry (
          HWND)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinSetSysModalWindow entry (
          HWND,
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinQueryWindowUShort entry (
            HWND,
            LONG)
            returns(optional byvalue USHORT)
            APIENTRY;
     dcl WinSetWindowUShort entry (
            HWND,
            LONG,
            USHORT)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinQueryWindowULong entry (
            HWND,
            LONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinSetWindowULong entry (
            HWND,
            LONG,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinQueryWindowPtr entry (
            HWND,
            LONG)
            returns(optional byvalue PVOID)
            APIENTRY;
     dcl WinSetWindowPtr entry (
            HWND,
            LONG,
            PVOID)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinSetWindowBits entry (
            HWND,
            LONG,
            ULONG,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     %declare QWS_USER char;
     %QWS_USER=0;
     %declare QWS_ID char;
     %QWS_ID=-1;
     %declare QWS_MIN char;
     %QWS_MIN=-1;
     %declare QWL_USER char;
     %QWL_USER=0;
     %declare QWL_STYLE char;
     %QWL_STYLE=-2;
     %declare QWP_PFNWP char;
     %QWP_PFNWP=-3;
     %declare QWL_HMQ char;
     %QWL_HMQ=-4;
     %declare QWL_RESERVED char;
     %QWL_RESERVED=-5;
     %declare QWL_PENDATA char;
     %QWL_PENDATA=-7;
     %declare QWL_MIN char;
     %QWL_MIN=-7;

 /*** WC_FRAME WinQueryWindowUShort/ULong() indices *******************/

     declare QWL_HHEAP         fixed bin(16) value('00_04'xn);
     declare QWL_HWNDFOCUSSAVE fixed bin(16) value('00_18'xn);
     declare QWL_DEFBUTTON     fixed bin(16) value('00_40'xn);
     declare QWL_PSSCBLK       fixed bin(16) value('00_48'xn);
     declare QWL_PFEPBLK       fixed bin(16) value('00_4C'xn);
     declare QWL_PSTATBLK      fixed bin(16) value('00_50'xn);
     declare QWS_FLAGS         fixed bin(16) value('00_08'xn);
     declare QWS_RESULT        fixed bin(16) value('00_0A'xn);
     declare QWS_XRESTORE      fixed bin(16) value('00_0C'xn);
     declare QWS_YRESTORE      fixed bin(16) value('00_0E'xn);
     declare QWS_CXRESTORE     fixed bin(16) value('00_10'xn);
     declare QWS_CYRESTORE     fixed bin(16) value('00_12'xn);
     declare QWS_XMINIMIZE     fixed bin(16) value('00_14'xn);
     declare QWS_YMINIMIZE     fixed bin(16) value('00_16'xn);
     %declare HENUM char;
     %HENUM=LHANDLE;
     dcl WinBeginEnumWindows entry (
            HWND)
            returns(optional byvalue HENUM)
            APIENTRY;
     dcl WinGetNextWindow entry (
            HENUM)
            returns(optional byvalue HWND)
            APIENTRY;
     dcl WinEndEnumWindows entry (
            HENUM)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl WinWindowFromPoint entry (
          HWND,
          PPOINTL,
          BOOL)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinMapWindowPoints entry (
          HWND,
          HWND,
          PPOINTL,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinValidateRect entry (
          HWND,
          PRECTL,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinValidateRegion entry (
          HWND,
          HRGN,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinWindowFromDC entry (
            HDC)
            returns(optional byvalue HWND)
            APIENTRY;
     dcl WinQueryWindowDC entry (
            HWND)
            returns(optional byvalue HDC)
            APIENTRY;
     dcl WinGetScreenPS entry (
            HWND)
            returns(optional byvalue HPS)
            APIENTRY;
     dcl WinLockWindowUpdate entry (
            HWND,
            HWND)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinLockVisRegions entry (
            HWND,
            BOOL)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl WinQueryUpdateRect entry (
          HWND,
          PRECTL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryUpdateRegion entry (
          HWND,
          HRGN)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl WinExcludeUpdateRegion entry (
          HPS,
          HWND)
          returns(optional byvalue LONG)
          APIENTRY;
 %end;
 %if INCL_WINMESSAGEMGR='Y' | INCL_NOCOMMON='Y' %then %do;
   %declare QMSG char;
   %QMSG='char(stg(#QMSG))';
   dcl 1 #QMSG based(null()) unaligned,
         2 QMSG_hwnd HWND,
         2 msg ULONG,
         2 mp1 MPARAM,
         2 mp2 MPARAM,
         2 time ULONG,
         2 ptl POINTL,
         2 reserved ULONG;
   %declare PQMSG char;
   %PQMSG='pointer';

 /*** Standard Window Messages ***************************************/

   declare WM_NULL                fixed bin(16) value('00_00'xn);
   declare WM_CREATE              fixed bin(16) value('00_01'xn);
   declare WM_DESTROY             fixed bin(16) value('00_02'xn);
   %if INCL_SAADEFS='Y' %then %do;
   %end;
   declare WM_ENABLE              fixed bin(16) value('00_04'xn);
   declare WM_SHOW                fixed bin(16) value('00_05'xn);
   declare WM_MOVE                fixed bin(16) value('00_06'xn);
   declare WM_SIZE                fixed bin(16) value('00_07'xn);
   declare WM_ADJUSTWINDOWPOS     fixed bin(16) value('00_08'xn);
   declare WM_CALCVALIDRECTS      fixed bin(16) value('00_09'xn);
   declare WM_SETWINDOWPARAMS     fixed bin(16) value('00_0A'xn);
   declare WM_QUERYWINDOWPARAMS   fixed bin(16) value('00_0B'xn);
   declare WM_HITTEST             fixed bin(16) value('00_0C'xn);
   declare WM_ACTIVATE            fixed bin(16) value('00_0D'xn);
   declare WM_SETFOCUS            fixed bin(16) value('00_0F'xn);
   declare WM_SETSELECTION        fixed bin(16) value('00_10'xn);
   declare WM_PPAINT              fixed bin(16) value('00_11'xn);
   declare WM_PSETFOCUS           fixed bin(16) value('00_12'xn);
   declare WM_PSYSCOLORCHANGE     fixed bin(16) value('00_13'xn);
   declare WM_PSIZE               fixed bin(16) value('00_14'xn);
   declare WM_PACTIVATE           fixed bin(16) value('00_15'xn);
   declare WM_PCONTROL            fixed bin(16) value('00_16'xn);
   declare WM_COMMAND             fixed bin(16) value('00_20'xn);
   declare WM_SYSCOMMAND          fixed bin(16) value('00_21'xn);
   declare WM_HELP                fixed bin(16) value('00_22'xn);
   declare WM_PAINT               fixed bin(16) value('00_23'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare WM_TIMER   fixed bin(16) value('00_24'xn);
     declare WM_SEM1    fixed bin(16) value('00_25'xn);
     declare WM_SEM2    fixed bin(16) value('00_26'xn);
     declare WM_SEM3    fixed bin(16) value('00_27'xn);
     declare WM_SEM4    fixed bin(16) value('00_28'xn);
   %end;
   declare WM_CLOSE              fixed bin(16) value('00_29'xn);
   declare WM_QUIT               fixed bin(16) value('00_2A'xn);
   declare WM_SYSCOLORCHANGE     fixed bin(16) value('00_2B'xn);
   declare WM_SYSVALUECHANGED    fixed bin(16) value('00_2D'xn);
   declare WM_APPTERMINATENOTIFY fixed bin(16) value('00_2E'xn);
   declare WM_PRESPARAMCHANGED   fixed bin(16) value('00_2F'xn);

   /* Control notification messages */

   declare WM_CONTROL          fixed bin(16) value('00_30'xn);
   declare WM_VSCROLL          fixed bin(16) value('00_31'xn);
   declare WM_HSCROLL          fixed bin(16) value('00_32'xn);
   declare WM_INITMENU         fixed bin(16) value('00_33'xn);
   declare WM_MENUSELECT       fixed bin(16) value('00_34'xn);
   declare WM_MENUEND          fixed bin(16) value('00_35'xn);
   declare WM_DRAWITEM         fixed bin(16) value('00_36'xn);
   declare WM_MEASUREITEM      fixed bin(16) value('00_37'xn);
   declare WM_CONTROLPOINTER   fixed bin(16) value('00_38'xn);
   declare WM_QUERYDLGCODE     fixed bin(16) value('00_3A'xn);
   declare WM_INITDLG          fixed bin(16) value('00_3B'xn);
   declare WM_SUBSTITUTESTRING fixed bin(16) value('00_3C'xn);
   declare WM_MATCHMNEMONIC    fixed bin(16) value('00_3D'xn);
   declare WM_SAVEAPPLICATION  fixed bin(16) value('00_3E'xn);

   /*******************************************************************/
   /* Reserve a range of messages for help manager.  This range       */
   /* includes public messages, defined below, and private ones,      */
   /* which need to be reserved here to prevent clashing              */
   /* with application messages.                                      */
   /*******************************************************************/

   declare WM_HELPBASE         fixed bin(16) value('0F_00'xn);
   declare WM_HELPTOP          fixed bin(16) value('0F_FF'xn);
   %declare WM_USER char;
   %WM_USER="'10_00'xn";

   /*** WM_COMMAND msg source codes ********************************/

   %declare CMDSRC_PUSHBUTTON char;
   %CMDSRC_PUSHBUTTON=1;
   %declare CMDSRC_MENU char;
   %CMDSRC_MENU=2;
   %declare CMDSRC_ACCELERATOR char;
   %CMDSRC_ACCELERATOR=3;
   %declare CMDSRC_FONTDLG char;
   %CMDSRC_FONTDLG=4;
   %declare CMDSRC_FILEDLG char;
   %CMDSRC_FILEDLG=5;
   %declare CMDSRC_PRINTDLG char;
   %CMDSRC_PRINTDLG=6;
   %declare CMDSRC_COLORDLG char;
   %CMDSRC_COLORDLG=7;
   %declare CMDSRC_OTHER char;
   %CMDSRC_OTHER=0;
   %declare COMMANDMSG char;
   %COMMANDMSG='char(stg(#COMMANDMSG))';
   dcl 1 #COMMANDMSG based(null()) unaligned,
         2 cmd USHORT,
         2 unused USHORT,
         2 source USHORT,
         2 fMouse USHORT;
   %declare PCMDMSG char;
   %PCMDMSG='pointer';
   %declare MQINFO char;
   %MQINFO='char(stg(#MQINFO))';
   dcl 1 #MQINFO based(null()) unaligned,
         2 cb ULONG,
         2 MQINFO_pid PID,
         2 MQINFO_tid TID,
         2 cmsgs ULONG,
         2 pReserved PVOID;
   %declare PMQINFO char;
   %PMQINFO='pointer';
   dcl WinSendMsg entry (
          HWND,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue MRESULT)
          APIENTRY;
   dcl WinCreateMsgQueue entry (
          HAB,
          LONG)
          returns(optional byvalue HMQ)
          APIENTRY;
   dcl WinDestroyMsgQueue entry (
          HMQ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryQueueInfo entry (
          HMQ,
          PMQINFO,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinCancelShutdown entry (
            HMQ,
            BOOL)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl WinGetMsg entry (
          HAB,
          PQMSG,
          HWND,
          ULONG,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinPeekMsg entry (
          HAB,
          PQMSG,
          HWND,
          ULONG,
          ULONG,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinDispatchMsg entry (
          HAB,
          PQMSG)
          returns(optional byvalue MRESULT)
          APIENTRY;
   dcl WinPostMsg entry (
          HWND,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinRegisterUserMsg entry (
          HAB,
          ULONG,
          LONG,
          LONG,
          LONG,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinRegisterUserDatatype entry (
          HAB,
          LONG,
          LONG,
          PLONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinSetMsgMode entry (
          HAB,
          PSZ,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinSetSynchroMode entry (
          HAB,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;

   /*** WinPeekMsg() constants ************************************/

   declare PM_REMOVE   fixed bin(16) value('00_01'xn);
   declare PM_NOREMOVE fixed bin(16) value('00_00'xn);

   /*** WinRegisterUserDatatype datatypes defined in separate file ***/

   %if INCL_WINTYPES='Y' %then %do;
     %include pmtypes;
   %end;

   /*** WinRegisterUserMsg direction codes ***************************/

   %declare RUM_IN char;
   %RUM_IN=1;
   %declare RUM_OUT char;
   %RUM_OUT=2;
   %declare RUM_INOUT char;
   %RUM_INOUT=3;

   /*** WinSetMsgMode constants *************************************/

   declare SMD_DELAYED      fixed bin(16) value('00_01'xn);
   declare SMD_IMMEDIATE    fixed bin(16) value('00_02'xn);

   /*** WinSetSynchroMode constants *********************************/

   declare SSM_SYNCHRONOUS  fixed bin(16) value('00_01'xn);
   declare SSM_ASYNCHRONOUS fixed bin(16) value('00_02'xn);
   declare SSM_MIXED        fixed bin(16) value('00_03'xn);
 %end;
 %if INCL_WINMESSAGEMGR='Y' %then %do;

   /*** WM_CALCVALIDRECTS return flags ******************************/

   declare CVR_ALIGNLEFT   fixed bin(16) value('00_01'xn);
   declare CVR_ALIGNBOTTOM fixed bin(16) value('00_02'xn);
   declare CVR_ALIGNRIGHT  fixed bin(16) value('00_04'xn);
   declare CVR_ALIGNTOP    fixed bin(16) value('00_08'xn);
   declare CVR_REDRAW      fixed bin(16) value('00_10'xn);

   /*** WM_HITTEST return codes *************************************/

   %declare HT_NORMAL char;
   %HT_NORMAL=0;
   %declare HT_TRANSPARENT char;
   %HT_TRANSPARENT=-1;
   %declare HT_DISCARD char;
   %HT_DISCARD=-2;
   %declare HT_ERROR char;
   %HT_ERROR=-3;
   %declare WNDPARAMS char;
   %WNDPARAMS='char(stg(#WNDPARAMS))';
   dcl 1 #WNDPARAMS based(null()) unaligned,
         2 fsStatus ULONG,
         2 cchText ULONG,
         2 pszText PSZ,
         2 cbPresParams ULONG,
         2 pbPresParams PVOID,
         2 cbCtlData ULONG,
         2 pCtlData PVOID;
   %declare PWNDPARAMS char;
   %PWNDPARAMS='pointer';
   declare WPM_TEXT         fixed bin(16) value('00_01'xn);
   declare WPM_CTLDATA      fixed bin(16) value('00_02'xn);
   declare WPM_PRESPARAMS   fixed bin(16) value('00_04'xn);
   declare WPM_CCHTEXT      fixed bin(16) value('00_08'xn);
   declare WPM_CBCTLDATA    fixed bin(16) value('00_10'xn);
   declare WPM_CBPRESPARAMS fixed bin(16) value('00_20'xn);
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinInSendMsg entry (
            HAB)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl WinBroadcastMsg entry (
          HWND,
          ULONG,
          MPARAM,
          MPARAM,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;

   /*** WinBroadcastMsg codes ***************************************/

   declare BMSG_POST        fixed bin(16) value('00_00'xn);
   declare BMSG_SEND        fixed bin(16) value('00_01'xn);
   declare BMSG_POSTQUEUE   fixed bin(16) value('00_02'xn);
   declare BMSG_DESCENDANTS fixed bin(16) value('00_04'xn);
   declare BMSG_FRAMEONLY   fixed bin(16) value('00_08'xn);
   dcl WinWaitMsg entry (
          HAB,
          ULONG,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinQueryQueueStatus entry (
            HWND)
            returns(optional byvalue ULONG)
            APIENTRY;

      /*** WinQueryQueueStatus() constants **************************/

     declare QS_KEY         fixed bin(16) value('00_01'xn);
     declare QS_MOUSEBUTTON fixed bin(16) value('00_02'xn);
     declare QS_MOUSEMOVE   fixed bin(16) value('00_04'xn);
     declare QS_MOUSE       fixed bin(16) value('00_06'xn);
     declare QS_TIMER       fixed bin(16) value('00_08'xn);
     declare QS_PAINT       fixed bin(16) value('00_10'xn);
     declare QS_POSTMSG     fixed bin(16) value('00_20'xn);
     declare QS_SEM1        fixed bin(16) value('00_40'xn);
     declare QS_SEM2        fixed bin(16) value('00_80'xn);
     declare QS_SEM3        fixed bin(16) value('01_00'xn);
     declare QS_SEM4        fixed bin(16) value('02_00'xn);
     declare QS_SENDMSG     fixed bin(16) value('04_00'xn);
     declare QS_MSGINPUT    fixed bin(16) value('08_00'xn);
     dcl WinQueryMsgPos entry (
            HAB,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinQueryMsgTime entry (
            HAB)
            returns(optional byvalue ULONG)
            APIENTRY;
     %if INCL_DOSSEMAPHORES='Y' %then %do;
       %if HEV__='Y' %then %do;
         %HEV__='Y';
         %declare HEV char;
         %HEV=ULONG;
       %end;
       %declare HMTX char;
       %HMTX=ULONG;
       %declare HMUX char;
       %HMUX=ULONG;
     %end;
     dcl WinWaitEventSem entry (
            HEV,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl WinRequestMutexSem entry (
            HMTX,
            ULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
     dcl WinWaitMuxWaitSem entry (
            HMUX,
            ULONG,
            PULONG)
            returns(optional byvalue APIRET)
            APIENTRY;
   %end;
   dcl WinPostQueueMsg entry (
          HMQ,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue BOOL)
          APIENTRY;

   /*** WinSetMsgInterest()/WinSetClassMsgInterest() constants ******/

   declare SMIM_ALL            fixed bin(16) value('0E_FF'xn);
   declare SMI_NOINTEREST      fixed bin(16) value('00_01'xn);
   declare SMI_INTEREST        fixed bin(16) value('00_02'xn);
   declare SMI_RESET           fixed bin(16) value('00_04'xn);
   declare SMI_AUTODISPATCH    fixed bin(16) value('00_08'xn);
   dcl WinSetMsgInterest entry (
          HWND,
          ULONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinSetClassMsgInterest entry (
          HAB,
          PSZ,
          ULONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
 %end;
 %if INCL_WININPUT='Y' | INCL_NOCOMMON='Y' %then %do;
   dcl WinSetFocus entry (
          HWND,
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinFocusChange entry (
          HWND,
          HWND,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinLockupSystem entry (
          HAB)
          returns(optional byvalue BOOL)
          EXPENTRY;
   dcl WinUnlockSystem entry (
          HAB,PSZ)
          returns(optional byvalue BOOL)
          EXPENTRY;
   declare FC_NOSETFOCUS fixed bin(16) value('00_01'xn);
   declare FC_NOBRINGTOTOP fixed bin(16) value('00_01'xn);
   declare FC_NOLOSEFOCUS fixed bin(16) value('00_02'xn);
   declare FC_NOBRINGTOPFIRSTWINDOW fixed bin(16) value('00_02'xn);
   declare FC_NOSETACTIVE fixed bin(16) value('00_04'xn);
   declare FC_NOLOSEACTIVE fixed bin(16) value('00_08'xn);
   declare FC_NOSETSELECTION fixed bin(16) value('00_10'xn);
   declare FC_NOLOSESELECTION fixed bin(16) value('00_20'xn);
   declare QFC_NEXTINCHAIN fixed bin(16) value('00_01'xn);
   declare QFC_ACTIVE fixed bin(16) value('00_02'xn);
   declare QFC_FRAME fixed bin(16) value('00_03'xn);
   declare QFC_SELECTACTIVE fixed bin(16) value('00_04'xn);
   declare QFC_PARTOFCHAIN fixed bin(16) value('00_05'xn);
 %end;
 %if INCL_WININPUT='Y' %then %do;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinSetCapture entry (
            HWND,
            HWND)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   dcl WinQueryCapture entry (
          HWND)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinCheckInput entry (
          HAB)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;

 /*** Mouse input messages ******************************************/

     declare WM_MOUSEFIRST fixed bin(16) value('00_70'xn);
     declare WM_MOUSELAST fixed bin(16) value('00_79'xn);
     declare WM_BUTTONCLICKFIRST fixed bin(16) value('00_71'xn);
     declare WM_BUTTONCLICKLAST fixed bin(16) value('00_79'xn);
   %end;
   declare WM_MOUSEMOVE fixed bin(16) value('00_70'xn);
   declare WM_BUTTON1DOWN fixed bin(16) value('00_71'xn);
   declare WM_BUTTON1UP fixed bin(16) value('00_72'xn);
   declare WM_BUTTON1DBLCLK fixed bin(16) value('00_73'xn);
   declare WM_BUTTON2DOWN fixed bin(16) value('00_74'xn);
   declare WM_BUTTON2UP fixed bin(16) value('00_75'xn);
   declare WM_BUTTON2DBLCLK fixed bin(16) value('00_76'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare WM_BUTTON3DOWN fixed bin(16) value('00_77'xn);
     declare WM_BUTTON3UP fixed bin(16) value('00_78'xn);
     declare WM_BUTTON3DBLCLK fixed bin(16) value('00_79'xn);
     declare WM_MOUSEMAP fixed bin(16) value('00_7D'xn);
     declare WM_EXTMOUSEFIRST fixed bin(16) value('04_10'xn);
     declare WM_EXTMOUSELAST fixed bin(16) value('04_19'xn);
     declare WM_CHORD fixed bin(16) value('04_10'xn);
     declare WM_BUTTON1MOTIONSTART fixed bin(16) value('04_11'xn);
     declare WM_BUTTON1MOTIONEND fixed bin(16) value('04_12'xn);
     declare WM_BUTTON1CLICK fixed bin(16) value('04_13'xn);
     declare WM_BUTTON2MOTIONSTART fixed bin(16) value('04_14'xn);
     declare WM_BUTTON2MOTIONEND fixed bin(16) value('04_15'xn);
     declare WM_BUTTON2CLICK fixed bin(16) value('04_16'xn);
     declare WM_BUTTON3MOTIONSTART fixed bin(16) value('04_17'xn);
     declare WM_BUTTON3MOTIONEND fixed bin(16) value('04_18'xn);
     declare WM_BUTTON3CLICK fixed bin(16) value('04_19'xn);
     declare WM_MOUSETRANSLATEFIRST fixed bin(16) value('04_20'xn);
     declare WM_MOUSETRANSLATELAST fixed bin(16) value('04_28'xn);
     declare WM_BEGINDRAG fixed bin(16) value('04_20'xn);
     declare WM_ENDDRAG fixed bin(16) value('04_21'xn);
     declare WM_SINGLESELECT fixed bin(16) value('04_22'xn);
     declare WM_OPEN fixed bin(16) value('04_23'xn);
     declare WM_CONTEXTMENU fixed bin(16) value('04_24'xn);
     declare WM_CONTEXTHELP fixed bin(16) value('04_25'xn);
     declare WM_TEXTEDIT fixed bin(16) value('04_26'xn);
     declare WM_BEGINSELECT fixed bin(16) value('04_27'xn);
     declare WM_ENDSELECT fixed bin(16) value('04_28'xn);
     declare WM_PENFIRST fixed bin(16) value('04_C0'xn);
     declare WM_PENLAST fixed bin(16) value('04_FF'xn);
     declare WM_MMPMFIRST fixed bin(16) value('05_00'xn);
     declare WM_MMPMLAST fixed bin(16) value('05_FF'xn);
   %end;
   dcl WinQueryFocus entry (
          HWND)
          returns(optional byvalue HWND)
          APIENTRY;
   declare WM_CHAR fixed bin(16) value('00_7A'xn);
   declare WM_VIOCHAR fixed bin(16) value('00_7B'xn);
   declare KC_NONE fixed bin(16) value('00_00'xn);
   declare KC_CHAR fixed bin(16) value('00_01'xn);
   declare KC_VIRTUALKEY fixed bin(16) value('00_02'xn);
   declare KC_SCANCODE fixed bin(16) value('00_04'xn);
   declare KC_SHIFT fixed bin(16) value('00_08'xn);
   declare KC_CTRL fixed bin(16) value('00_10'xn);
   declare KC_ALT fixed bin(16) value('00_20'xn);
   declare KC_KEYUP fixed bin(16) value('00_40'xn);
   declare KC_PREVDOWN fixed bin(16) value('00_80'xn);
   declare KC_LONEKEY fixed bin(16) value('01_00'xn);
   declare KC_DEADKEY fixed bin(16) value('02_00'xn);
   declare KC_COMPOSITE fixed bin(16) value('04_00'xn);
   declare KC_INVALIDCOMP fixed bin(16) value('08_00'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare KC_TOGGLE fixed bin(16) value('10_00'xn);
     declare KC_INVALIDCHAR fixed bin(16) value('20_00'xn);
     declare KC_DBCSRSRVD1 fixed bin(16) value('40_00'xn);
     declare KC_DBCSRSRVD2 fixed bin(16) value('80_00'xn);
   %end;
   %declare MOUSEMSG char;
   %MOUSEMSG='char(stg(#MOUSEMSG))';
   dcl 1 #MOUSEMSG based(null()) unaligned,
         2 x SHORT,
         2 y SHORT,
         2 codeHitTest USHORT,
         2 fsInp USHORT;
   %declare PMSEMSG char;
   %PMSEMSG='pointer';
   %declare CHARMSG char;
   %CHARMSG='char(stg(#CHARMSG))';
   dcl 1 #CHARMSG based(null()) unaligned,
         2 fs USHORT,
         2 cRepeat UCHAR,
         2 scancode UCHAR,
         2 chr USHORT,
         2 vkey USHORT;
   %declare PCHRMSG char;
   %PCHRMSG='pointer';
   declare INP_NONE fixed bin(16) value('00_00'xn);
   declare INP_KBD fixed bin(16) value('00_01'xn);
   declare INP_MULT fixed bin(16) value('00_02'xn);
   declare INP_RES2 fixed bin(16) value('00_04'xn);
   declare INP_SHIFT fixed bin(16) value('00_08'xn);
   declare INP_CTRL fixed bin(16) value('00_10'xn);
   declare INP_ALT fixed bin(16) value('00_20'xn);
   declare INP_RES3 fixed bin(16) value('00_40'xn);
   declare INP_RES4 fixed bin(16) value('00_80'xn);
   declare INP_IGNORE fixed bin(16) value('FF_FF'xn);
   declare VK_BUTTON1 bit(8) value('00_00_00_01'b);
   declare VK_BUTTON2 bit(8) value('00_00_00_10'b);
   declare VK_BUTTON3 bit(8) value('00_00_00_11'b);
   declare VK_BREAK bit(8) value('00_00_01_00'b);
   declare VK_BACKSPACE bit(8) value('00_00_01_01'b);
   declare VK_TAB bit(8) value('00_00_01_10'b);
   declare VK_BACKTAB bit(8) value('00_00_01_11'b);
   declare VK_NEWLINE bit(8) value('00_00_10_00'b);
   declare VK_SHIFT bit(8) value('00_00_10_01'b);
   declare VK_CTRL bit(8) value('00_00_10_10'b);
   declare VK_ALT bit(8) value('00_00_10_11'b);
   declare VK_ALTGRAF bit(8) value('00_00_11_00'b);
   declare VK_PAUSE bit(8) value('00_00_11_01'b);
   declare VK_CAPSLOCK bit(8) value('00_00_11_10'b);
   declare VK_ESC bit(8) value('00_00_11_11'b);
   declare VK_SPACE bit(8) value('00_01_00_00'b);
   declare VK_PAGEUP bit(8) value('00_01_00_01'b);
   declare VK_PAGEDOWN bit(8) value('00_01_00_10'b);
   declare VK_END bit(8) value('00_01_00_11'b);
   declare VK_HOME bit(8) value('00_01_01_00'b);
   declare VK_LEFT bit(8) value('00_01_01_01'b);
   declare VK_UP bit(8) value('00_01_01_10'b);
   declare VK_RIGHT bit(8) value('00_01_01_11'b);
   declare VK_DOWN bit(8) value('00_01_10_00'b);
   declare VK_PRINTSCRN bit(8) value('00_01_10_01'b);
   declare VK_INSERT bit(8) value('00_01_10_10'b);
   declare VK_DELETE bit(8) value('00_01_10_11'b);
   declare VK_SCRLLOCK bit(8) value('00_01_11_00'b);
   declare VK_NUMLOCK bit(8) value('00_01_11_01'b);
   declare VK_ENTER bit(8) value('00_01_11_10'b);
   declare VK_SYSRQ bit(8) value('00_01_11_11'b);
   declare VK_F1 bit(8) value('00_10_00_00'b);
   declare VK_F2 bit(8) value('00_10_00_01'b);
   declare VK_F3 bit(8) value('00_10_00_10'b);
   declare VK_F4 bit(8) value('00_10_00_11'b);
   declare VK_F5 bit(8) value('00_10_01_00'b);
   declare VK_F6 bit(8) value('00_10_01_01'b);
   declare VK_F7 bit(8) value('00_10_01_10'b);
   declare VK_F8 bit(8) value('00_10_01_11'b);
   declare VK_F9 bit(8) value('00_10_10_00'b);
   declare VK_F10 bit(8) value('00_10_10_01'b);
   declare VK_F11 bit(8) value('00_10_10_10'b);
   declare VK_F12 bit(8) value('00_10_10_11'b);
   declare VK_F13 bit(8) value('00_10_11_00'b);
   declare VK_F14 bit(8) value('00_10_11_01'b);
   declare VK_F15 bit(8) value('00_10_11_10'b);
   declare VK_F16 bit(8) value('00_10_11_11'b);
   declare VK_F17 bit(8) value('00_11_00_00'b);
   declare VK_F18 bit(8) value('00_11_00_01'b);
   declare VK_F19 bit(8) value('00_11_00_10'b);
   declare VK_F20 bit(8) value('00_11_00_11'b);
   declare VK_F21 bit(8) value('00_11_01_00'b);
   declare VK_F22 bit(8) value('00_11_01_01'b);
   declare VK_F23 bit(8) value('00_11_01_10'b);
   declare VK_F24 bit(8) value('00_11_01_11'b);
   declare VK_ENDDRAG bit(8) value('00_11_10_00'b);
   declare VK_CLEAR bit(8) value('00_11_10_01'b);
   declare VK_EREOF bit(8) value('00_11_10_10'b);
   declare VK_PA1 bit(8) value('00_11_10_11'b);
   declare VK_MENU bit(8) value('00_10_10_01'b);
   %if INCL_NLS='Y' %then %do;
     declare VK_DBCSFIRST fixed bin(16) value('00_80'xn);
     declare VK_DBCSLAST fixed bin(16) value('00_FF'xn);
   %end;
   declare VK_USERFIRST fixed bin(16) value('01_00'xn);
   declare VK_USERLAST fixed bin(16) value('01_FF'xn);
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinGetKeyState entry (
            HWND,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl WinGetPhysKeyState entry (
            HWND,
            LONG)
            returns(optional byvalue LONG)
            APIENTRY;
     dcl WinEnablePhysInput entry (
            HWND,
            BOOL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinIsPhysInputEnabled entry (
            HWND)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinSetKeyboardStateTable entry (
            HWND,
            PBYTE,
            BOOL)
            returns(optional byvalue BOOL)
            APIENTRY;
     declare WM_JOURNALNOTIFY fixed bin(16) value('00_7C'xn);
     declare JRN_QUEUESTATUS fixed bin(31) value('00_00_00_01'xn);
     declare JRN_PHYSKEYSTATE fixed bin(16) value('00_00_00_02'xn);
   %end;
 %end;
 %if INCL_WINDIALOGS='Y' | INCL_NOCOMMON='Y' %then %do;
   dcl WinGetDlgMsg entry (
          HWND,
          PQMSG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinLoadDlg entry (
          HWND,
          HWND,
          PFNWP,
          HMODULE,
          ULONG,
          PVOID)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinDlgBox entry (
          HWND,
          HWND,
          entry limited returns( optional byvalue MRESULT )
          options( nodescriptor linkage( system )),
          HMODULE,
          ULONG,
          PVOID)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl WinDismissDlg entry (
          HWND,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryDlgItemShort entry (
          HWND,
          ULONG,
          PSHORT,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinSetDlgItemShort entry (
          HWND,
          ULONG,
          USHORT,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinSetDlgItemText entry (
          HWND,
          ULONG,
          char(*) varyingz byaddr )
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryDlgItemText entry (
          HWND,
          ULONG,
          LONG,
          char(*) varyingz byaddr )
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl WinQueryDlgItemTextLength entry (
          HWND,
          ULONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl WinDefDlgProc entry (
          HWND,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue MRESULT)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     %declare DID_OK char;
     %DID_OK=1;
     %declare DID_CANCEL char;
     %DID_CANCEL=2;
     declare DID_ERROR fixed bin(16) value('FF_FF'xn);
   %end;
   dcl WinAlarm entry (
          HWND,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %declare WA_WARNING char;
   %WA_WARNING=0;
   %declare WA_NOTE char;
   %WA_NOTE=1;
   %declare WA_ERROR char;
   %WA_ERROR=2;
   %declare WA_CWINALARMS char;
   %WA_CWINALARMS=13;
   dcl WinMessageBox entry (
          HWND,
          HWND,
          char(*) varz byaddr,
          char(*) varz byaddr optional,
          ULONG,
          ULONG)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl WinMessageBox2 entry (
          HWND,
          HWND,
          char(*) varz byaddr,
          char(*) varz byaddr optional,
          ULONG,
          pointer byvalue )
          returns(optional byvalue ULONG)
          APIENTRY;
   declare MB_OK fixed bin(16) value('00_00'xn);
   declare MB_OKCANCEL fixed bin(16) value('00_01'xn);
   declare MB_RETRYCANCEL fixed bin(16) value('00_02'xn);
   declare MB_ABORTRETRYIGNORE fixed bin(16) value('00_03'xn);
   declare MB_YESNO fixed bin(16) value('00_04'xn);
   declare MB_YESNOCANCEL fixed bin(16) value('00_05'xn);
   declare MB_CANCEL fixed bin(16) value('00_06'xn);
   declare MB_ENTER fixed bin(16) value('00_07'xn);
   declare MB_ENTERCANCEL fixed bin(16) value('00_08'xn);
   declare MB_NOICON fixed bin(16) value('00_00'xn);
   declare MB_CUANOTIFICATION fixed bin(16) value('00_00'xn);
   declare MB_ICONQUESTION fixed bin(16) value('00_10'xn);
   declare MB_ICONEXCLAMATION fixed bin(16) value('00_20'xn);
   declare MB_CUAWARNING fixed bin(16) value('00_20'xn);
   declare MB_ICONASTERISK fixed bin(16) value('00_30'xn);
   declare MB_ICONHAND fixed bin(16) value('00_40'xn);
   declare MB_CUACRITICAL fixed bin(16) value('00_40'xn);
   declare MB_QUERY fixed bin(16) value('00_10'xn);
   declare MB_WARNING fixed bin(16) value('00_20'xn);
   declare MB_INFORMATION fixed bin(16) value('00_30'xn);
   declare MB_CRITICAL fixed bin(16) value('00_40'xn);
   declare MB_ERROR fixed bin(16) value('00_40'xn);
   declare MB_DEFBUTTON1 fixed bin(16) value('00_00'xn);
   declare MB_DEFBUTTON2 fixed bin(16) value('01_00'xn);
   declare MB_DEFBUTTON3 fixed bin(16) value('02_00'xn);
   declare MB_APPLMODAL fixed bin(16) value('00_00'xn);
   declare MB_SYSTEMMODAL fixed bin(16) value('10_00'xn);
   declare MB_HELP fixed bin(16) value('20_00'xn);
   declare MB_MOVEABLE fixed bin(16) value('40_00'xn);

   %declare MBID_OK char;
   %MBID_OK=1;
   %declare MBID_CANCEL char;
   %MBID_CANCEL=2;
   %declare MBID_ABORT char;
   %MBID_ABORT=3;
   %declare MBID_RETRY char;
   %MBID_RETRY=4;
   %declare MBID_IGNORE char;
   %MBID_IGNORE=5;
   %declare MBID_YES char;
   %MBID_YES=6;
   %declare MBID_NO char;
   %MBID_NO=7;
   %declare MBID_HELP char;
   %MBID_HELP=8;
   %declare MBID_ENTER char;
   %MBID_ENTER=9;
   declare MBID_ERROR fixed bin(16) value('FF_FF'xn);

   /****************************************************/
   /*        Useful macros                             */
   /****************************************************/
   %dcl WinCheckButton entry;
   %WinCheckButton : Proc(hwndDlg, id, usCheckState);
     dcl (hwndDlg, id, usCheckState) char;
     dcl (outstr) char;
     outstr = ' WinSendDlgItemMsg(';
     outstr = outstr||hwndDlg||','||id||','||'BM_SETCHECK'||',';
     outstr = outstr||' MPFROMSHORT('||usCheckState||')'||',';
     outstr = outstr||'sysnull)';
     ans (outstr);
    %end;

   %dcl WinQueryButtonCheckstate entry;
   %WinQueryButtonCheckstate : Proc(hwndDlg, id);
     dcl (hwndDlg, id) char;
     dcl (outstr) char;
     outstr = '(WinSendDlgItemMsg(';
     outstr = outstr||hwndDlg||','||id||','||'BM_QUERYCHECK'||',';
     outstr = outstr||' sysnull'||',';
     outstr = outstr||' sysnull))';
     ans (outstr);
    %end;

   %dcl WinEnableControl entry;
   %WinEnableControl : Proc(hwndDlg, id, fEnable);
     dcl (hwndDlg, id, fEnable) char;
     dcl (outstr) char;
     outstr = 'WinEnableWindow( WinWindowFromID(';
     outstr = outstr ||hwndDlg||','||id||'), '||fEnable||')';
     ans (outstr);
    %end;

   %dcl WinIsControlEnabled entry;
   %WinIsControlEnabled : Proc(hwndDlg, id);
     dcl (hwndDlg, id) char;
     dcl (outstr) char;
     outstr = '(WinIsWindowEnabled( WinWindowFromID(';
     outstr = outstr ||hwndDlg||','||id||')))';
     ans (outstr);
    %end;


 %end;

 %if INCL_WINDIALOGS='Y' %then %do;
   declare DLGC_ENTRYFIELD  fixed bin(16) value('00_01'xn);
   declare DLGC_BUTTON      fixed bin(16) value('00_02'xn);
   declare DLGC_RADIOBUTTON fixed bin(16) value('00_04'xn);
   declare DLGC_STATIC      fixed bin(16) value('00_08'xn);
   declare DLGC_DEFAULT     fixed bin(16) value('00_10'xn);
   declare DLGC_PUSHBUTTON  fixed bin(16) value('00_20'xn);
   declare DLGC_CHECKBOX    fixed bin(16) value('00_40'xn);
   declare DLGC_SCROLLBAR   fixed bin(16) value('00_80'xn);
   declare DLGC_MENU        fixed bin(16) value('01_00'xn);
   declare DLGC_TABONCLICK  fixed bin(16) value('02_00'xn);
   declare DLGC_MLE         fixed bin(16) value('04_00'xn);
   dcl WinProcessDlg entry (
          HWND)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl WinSendDlgItemMsg entry (
          HWND,
          ULONG,
          ULONG,
          MPARAM,
          MPARAM)
          returns(optional byvalue MRESULT)
          APIENTRY;
   dcl WinMapDlgPoints entry (
          HWND,
          PPOINTL,
          ULONG,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinEnumDlgItem entry (
          HWND,
          HWND,
          ULONG)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinSubstituteStrings entry (
          HWND,
          PSZ,
          LONG,
          PSZ)
          returns(optional byvalue LONG)
          APIENTRY;
   %declare EDI_FIRSTTABITEM char;
   %EDI_FIRSTTABITEM=0;
   %declare EDI_LASTTABITEM char;
   %EDI_LASTTABITEM=1;
   %declare EDI_NEXTTABITEM char;
   %EDI_NEXTTABITEM=2;
   %declare EDI_PREVTABITEM char;
   %EDI_PREVTABITEM=3;
   %declare EDI_FIRSTGROUPITEM char;
   %EDI_FIRSTGROUPITEM=4;
   %declare EDI_LASTGROUPITEM char;
   %EDI_LASTGROUPITEM=5;
   %declare EDI_NEXTGROUPITEM char;
   %EDI_NEXTGROUPITEM=6;
   %declare EDI_PREVGROUPITEM char;
   %EDI_PREVGROUPITEM=7;
   %declare DLGTITEM char;
   %DLGTITEM='char(stg(#DLGTITEM))';
   dcl 1 #DLGTITEM based(null()) unaligned,
         2 fsItemStatus USHORT,
         2 cChildren USHORT,
         2 cchClassName USHORT,
         2 offClassName USHORT,
         2 cchText USHORT,
         2 offText USHORT,
         2 flStyle ULONG,
         2 x SHORT,
         2 y SHORT,
         2 cx SHORT,
         2 cy SHORT,
         2 id USHORT,
         2 offPresParams USHORT,
         2 offCtlData USHORT;
   %declare PDLGTITEM char;
   %PDLGTITEM='pointer';
   %declare DLGTEMPLATE char;
   %DLGTEMPLATE='char(stg(#DLGTEMPLATE))';
   dcl 1 #DLGTEMPLATE based(null()) unaligned,
         2 cbTemplate USHORT,
         2 type USHORT,
         2 codepage USHORT,
         2 offadlgti USHORT,
         2 fsTemplateStatus USHORT,
         2 iItemFocus USHORT,
         2 coffPresParams USHORT,
         2 adlgti(1) DLGTITEM;
   %declare PDLGTEMPLATE char;
   %PDLGTEMPLATE='pointer';
   dcl WinCreateDlg entry (
          HWND,
          HWND,
          PFNWP,
          PDLGTEMPLATE,
          PVOID)
          returns(optional byvalue HWND)
          APIENTRY;
 %end;
 %if INCL_WINSTATICS='Y' %then %do;
   declare SS_TEXT           fixed bin(16) value('00_01'xn);
   declare SS_GROUPBOX       fixed bin(16) value('00_02'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare SS_ICON         fixed bin(16) value('00_03'xn);
     declare SS_BITMAP       fixed bin(16) value('00_04'xn);
   %end;
   declare SS_FGNDRECT       fixed bin(16) value('00_05'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare SS_HALFTONERECT fixed bin(16) value('00_06'xn);
   %end;
   declare SS_BKGNDRECT      fixed bin(16) value('00_07'xn);
   declare SS_FGNDFRAME      fixed bin(16) value('00_08'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare SS_HALFTONEFRAME fixed bin(16) value('00_09'xn);
   %end;
   declare SS_BKGNDFRAME     fixed bin(16) value('00_0A'xn);
   declare SS_SYSICON        fixed bin(16) value('00_0B'xn);
   declare SS_AUTOSIZE       fixed bin(16) value('00_40'xn);
   declare SM_SETHANDLE      fixed bin(16) value('01_00'xn);
   declare SM_QUERYHANDLE    fixed bin(16) value('01_01'xn);
 %end;
 %if INCL_WINBUTTONS='Y' %then %do;
   %declare BS_PUSHBUTTON char;
   %BS_PUSHBUTTON=0;
   %declare BS_CHECKBOX char;
   %BS_CHECKBOX=1;
   %declare BS_AUTOCHECKBOX char;
   %BS_AUTOCHECKBOX=2;
   %declare BS_RADIOBUTTON char;
   %BS_RADIOBUTTON=3;
   %declare BS_AUTORADIOBUTTON char;
   %BS_AUTORADIOBUTTON=4;
   %declare BS_3STATE char;
   %BS_3STATE=5;
   %declare BS_AUTO3STATE char;
   %BS_AUTO3STATE=6;
   %if INCL_SAADEFS='Y' %then %do;
     %declare BS_USERBUTTON char;
     %BS_USERBUTTON=7;
   %end;
   declare BS_PRIMARYSTYLES fixed bin(31) value('00_00_00_0F'xn);
   declare BS_BITMAP        fixed bin(31) value('00_00_00_40'xn);
   declare BS_ICON          fixed bin(31) value('00_00_00_80'xn);
   declare BS_HELP          fixed bin(31) value('00_00_01_00'xn);
   declare BS_SYSCOMMAND     fixed bin(31) value('00_00_02_00'xn);
   declare BS_DEFAULT        fixed bin(31) value('00_00_04_00'xn);
   declare BS_NOPOINTERFOCUS fixed bin(31) value('00_00_08_00'xn);
   declare BS_NOBORDER       fixed bin(31) value('00_00_10_00'xn);
   declare BS_NOCURSORSELECT fixed bin(31) value('00_00_20_00'xn);
   declare BS_AUTOSIZE       fixed bin(31) value('00_00_40_00'xn);
   %if INCL_SAADEFS='Y' %then %do;
     %declare BTNCDATA char;
     %BTNCDATA='char(stg(#BTNCDATA))';
     dcl 1 #BTNCDATA based(null()) unaligned,
           2 cb USHORT,
           2 fsCheckState USHORT,
           2 fsHiliteState USHORT,
           2 hImage LHANDLE;
     %declare PBTNCDATA char;
     %PBTNCDATA='pointer';
   %end;
   %if INCL_SAADEFS='Y' %then %do;
     %declare USERBUTTON char;
     %USERBUTTON='char(stg(#USERBUTTON))';
     dcl 1 #USERBUTTON based(null()) unaligned,
           2 USERBUTTON_hwnd HWND,
           2 USERBUTTON_hps HPS,
           2 fsState ULONG,
           2 fsStateOld ULONG;
     %declare PUSERBUTTON char;
     %PUSERBUTTON='pointer';
   %end;
   declare BM_CLICK           fixed bin(16) value('01_20'xn);
   declare BM_QUERYCHECKINDEX fixed bin(16) value('01_21'xn);
   declare BM_QUERYHILITE    fixed bin(16) value('01_22'xn);
   declare BM_SETHILITE      fixed bin(16) value('01_23'xn);
   declare BM_QUERYCHECK     fixed bin(16) value('01_24'xn);
   declare BM_SETCHECK       fixed bin(16) value('01_25'xn);
   declare BM_SETDEFAULT     fixed bin(16) value('01_26'xn);
   %declare BN_CLICKED char;
   %BN_CLICKED=1;
   %declare BN_DBLCLICKED char;
   %BN_DBLCLICKED=2;
   %declare BN_PAINT char;
   %BN_PAINT=3;
   %if INCL_SAADEFS='Y' %then %do;
     declare BDS_HILITED  fixed bin(16) value('01_00'xn);
     declare BDS_DISABLED fixed bin(16) value('02_00'xn);
     declare BDS_DEFAULT  fixed bin(16) value('04_00'xn);
   %end;
 %end;
 %if INCL_WINENTRYFIELDS='Y' %then %do;
   declare ES_LEFT            fixed bin(31) value('00_00_00_00'xn);
   declare ES_CENTER          fixed bin(31) value('00_00_00_01'xn);
   declare ES_RIGHT           fixed bin(31) value('00_00_00_02'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare ES_AUTOSCROLL    fixed bin(31) value('00_00_00_04'xn);
   %end;
   declare ES_MARGIN     fixed bin(31) value('00_00_00_08'xn);
   declare ES_AUTOTAB    fixed bin(31) value('00_00_00_10'xn);
   declare ES_READONLY   fixed bin(31) value('00_00_00_20'xn);
   declare ES_COMMAND    fixed bin(31) value('00_00_00_40'xn);
   declare ES_UNREADABLE fixed bin(31) value('00_00_00_80'xn);
   declare ES_AUTOSIZE   fixed bin(31) value('00_00_02_00'xn);
   %if INCL_NLS='Y' %then %do;
     declare ES_ANY      fixed bin(31) value('00_00_00_00'xn);
     declare ES_SBCS     fixed bin(31) value('00_00_10_00'xn);
     declare ES_DBCS     fixed bin(31) value('00_00_20_00'xn);
     declare ES_MIXED    fixed bin(31) value('00_00_30_00'xn);
   %end;
   declare CBS_SIMPLE       fixed bin(16) value('00_01'xn);
   declare CBS_DROPDOWN     fixed bin(16) value('00_02'xn);
   declare CBS_DROPDOWNLIST fixed bin(16) value('00_04'xn);
   declare CBS_COMPATIBLE   fixed bin(16) value('00_08'xn);
   declare CBID_LIST         fixed bin(16) value('02_9A'xn);
   declare CBID_EDIT         fixed bin(16) value('02_9B'xn);
   declare CBM_SHOWLIST      fixed bin(16) value('01_70'xn);
   declare CBM_HILITE        fixed bin(16) value('01_71'xn);
   declare CBM_ISLISTSHOWING fixed bin(16) value('01_72'xn);
   %declare CBN_EFCHANGE char;
   %CBN_EFCHANGE=1;
   %declare CBN_EFSCROLL char;
   %CBN_EFSCROLL=2;
   %declare CBN_MEMERROR char;
   %CBN_MEMERROR=3;
   %declare CBN_LBSELECT char;
   %CBN_LBSELECT=4;
   %declare CBN_LBSCROLL char;
   %CBN_LBSCROLL=5;
   %declare CBN_SHOWLIST char;
   %CBN_SHOWLIST=6;
   %declare CBN_ENTER char;
   %CBN_ENTER=7;
   %if INCL_SAADEFS='Y' %then %do;
     %declare ENTRYFDATA char;
     %ENTRYFDATA='char(stg(#ENTRYFDATA))';
     dcl 1 #ENTRYFDATA based(null()) unaligned,
           2 cb USHORT,
           2 cchEditLimit USHORT,
           2 ichMinSel USHORT,
           2 ichMaxSel USHORT;
     %declare PENTRYFDATA char;
     %PENTRYFDATA='pointer';
   %end;
   declare EM_QUERYCHANGED fixed bin(16) value('01_40'xn);
   declare EM_QUERYSEL     fixed bin(16) value('01_41'xn);
   declare EM_SETSEL       fixed bin(16) value('01_42'xn);
   declare EM_SETTEXTLIMIT fixed bin(16) value('01_43'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare EM_CUT       fixed bin(16) value('01_44'xn);
     declare EM_COPY      fixed bin(16) value('01_45'xn);
   %end;
   declare EM_CLEAR       fixed bin(16) value('01_46'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare EM_PASTE fixed bin(16) value('01_47'xn);
   %end;
   declare EM_QUERYFIRSTCHAR fixed bin(16) value('01_48'xn);
   declare EM_SETFIRSTCHAR  fixed bin(16) value('01_49'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare EM_QUERYREADONLY fixed bin(16) value('01_4A'xn);
     declare EM_SETREADONLY fixed bin(16) value('01_4B'xn);
     declare EM_SETINSERTMODE fixed bin(16) value('01_4C'xn);
   %end;
   declare EN_SETFOCUS  fixed bin(16) value('00_01'xn);
   declare EN_KILLFOCUS fixed bin(16) value('00_02'xn);
   declare EN_CHANGE    fixed bin(16) value('00_04'xn);
   declare EN_SCROLL    fixed bin(16) value('00_08'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare EN_MEMERROR fixed bin(16) value('00_10'xn);
     declare EN_OVERFLOW fixed bin(16) value('00_20'xn);
     declare EN_INSERTMODETOGGLE fixed bin(16) value('00_40'xn);
   %end;
 %end;
 %if INCL_WINMLE='Y' %then %do;
   %include pmmle;
 %end;
 %if INCL_WINLISTBOXES='Y' %then %do;
   declare LS_MULTIPLESEL fixed bin(31) value('00_00_00_01'xn);

   %if INCL_SAADEFS='Y' %then %do;
     declare LS_OWNERDRAW fixed bin(31) value('00_00_00_02'xn);
   %end;
   declare LS_NOADJUSTPOS fixed bin(31) value('00_00_00_04'xn);
   declare LS_HORZSCROLL fixed bin(31) value('00_00_00_08'xn);
   declare LS_EXTENDEDSEL fixed bin(31) value('00_00_00_10'xn);
   %declare LN_SELECT char;
   %LN_SELECT=1;
   %declare LN_SETFOCUS char;
   %LN_SETFOCUS=2;
   %declare LN_KILLFOCUS char;
   %LN_KILLFOCUS=3;
   %declare LN_SCROLL char;
   %LN_SCROLL=4;
   %declare LN_ENTER char;
   %LN_ENTER=5;
   declare LM_QUERYITEMCOUNT fixed bin(16) value('01_60'xn);
   declare LM_INSERTITEM fixed bin(16) value('01_61'xn);
   declare LM_SETTOPINDEX fixed bin(16) value('01_62'xn);
   declare LM_DELETEITEM fixed bin(16) value('01_63'xn);
   declare LM_SELECTITEM fixed bin(16) value('01_64'xn);
   declare LM_QUERYSELECTION fixed bin(16) value('01_65'xn);
   declare LM_SETITEMTEXT fixed bin(16) value('01_66'xn);
   declare LM_QUERYITEMTEXTLENGTH fixed bin(16) value('01_67'xn);
   declare LM_QUERYITEMTEXT fixed bin(16) value('01_68'xn);
   declare LM_SETITEMHANDLE fixed bin(16) value('01_69'xn);
   declare LM_QUERYITEMHANDLE fixed bin(16) value('01_6A'xn);
   declare LM_SEARCHSTRING fixed bin(16) value('01_6B'xn);
   declare LM_SETITEMHEIGHT fixed bin(16) value('01_6C'xn);
   declare LM_QUERYTOPINDEX fixed bin(16) value('01_6D'xn);
   declare LM_DELETEALL fixed bin(16) value('01_6E'xn);
   %declare LIT_CURSOR char;
   %LIT_CURSOR=-4;
   %declare LIT_ERROR char;
   %LIT_ERROR=-3;
   %declare LIT_MEMERROR char;
   %LIT_MEMERROR=-2;
   %declare LIT_NONE char;
   %LIT_NONE=-1;
   %declare LIT_FIRST char;
   %LIT_FIRST=-1;
   %declare LIT_END char;
   %LIT_END=-1;
   %declare LIT_SORTASCENDING char;
   %LIT_SORTASCENDING=-2;
   %declare LIT_SORTDESCENDING char;
   %LIT_SORTDESCENDING=-3;
   declare LSS_SUBSTRING fixed bin(16) value('00_01'xn);
   declare LSS_PREFIX fixed bin(16) value('00_02'xn);
   declare LSS_CASESENSITIVE fixed bin(16) value('00_04'xn);
 %end;

 %if INCL_WINLISTBOXES = 'Y' %then
 %do;
   %dcl WinDeleteLboxItem entry;
   %WinDeleteLboxItem: proc(hwndLbox, index);
    dcl (hwndLbox, index) char;
    dcl outstr char;
    outstr = 'WinSendMsg('|| hwndLbox||',';
    outstr = outstr || ' LM_DELETEITEM,';
    outstr = outstr || ' MPFROMLONG('||index||'), sysnull)';
    ans (outstr);
   %end;

   %dcl WinInsertLboxItem entry;
   %WinInsertLboxItem: proc(hwndLbox, index, psz);
    dcl (hwndLbox, index, psz) char;
    dcl outstr char;
    outstr = 'WinSendMsg('|| hwndLbox||',';
    outstr = outstr || ' LM_INSERTITEM,';
    outstr = outstr || ' MPFROMLONG('||index||'), MPFROMP('||psz||'))';
    ans (outstr);
   %end;


   %dcl WinQueryLboxCount entry;
   %WinQueryLboxCount: proc(hwndLbox);
    dcl (hwndLbox) char;
    dcl outstr char;
    outstr = 'WinSendMsg('|| hwndLbox||',';
    outstr = outstr || 'LM_QUERYITEMCOUNT,';
    outstr = outstr || 'sysnull, sysnull)';
    ans (outstr);
   %end;



   %dcl WinQueryLboxItemText entry;
   %WinQueryLboxItemText: proc(hwndLbox, index, psz, cchMax);
    dcl (hwndLbox, index, psz, cchMax) char;
    dcl outstr char;
    outstr = 'WinSendMsg('|| hwndLbox||',';
    outstr = outstr || ' LM_QUERYITEMTEXT,';
    outstr = outstr || ' MPFROM2SHORT(('||index||'),('||cchMax||')),';
    outstr = outstr || ' MPFROMP('||psz||'))';
    ans (outstr);
   %end;

   %dcl WinQueryLboxItemTextLength entry;
   %WinQueryLboxItemTextLength: proc(hwndLbox, index);
    dcl (hwndLbox, index) char;
    dcl outstr char;
    outstr = 'WinSendMsg('|| hwndLbox||',';
    outstr = outstr || ' LM_QUERYITEMTEXTLENGTH,';
    outstr = outstr || ' MPFROMSHORT('||index||'),sysnull)';
    ans (outstr);
   %end;

   %dcl WinSetLboxItemText entry;
   %WinSetLboxItemText: proc(hwndLbox, index, psz);
    dcl (hwndLbox, index, psz) char;
    dcl outstr char;
    outstr = 'WinSendMsg('|| hwndLbox||',';
    outstr = outstr || ' LM_SETITEMTEXT,';
    outstr = outstr || ' MPFROMLONG('||index||'),';
    outstr = outstr || ' MPFROMP('||psz||'))';
    ans (outstr);
   %end;

   %dcl WinQueryLboxSelectedItem entry;
   %WinQueryLboxSelectedItem: proc(hwndLbox);
    dcl (hwndLbox) char;
    dcl outstr char;
    outstr = 'WinSendMsg('|| hwndLbox||',';
    outstr = outstr || ' LM_QUERYSELECTION,';
    outstr = outstr || ' MPFROMLONG(LIT_FIRST ),';
    outstr = outstr || ' sysnull )';
    ans (outstr);
   %end;
 %end;    /*INCL_WINLISTBOXES*/

 %if INCL_WINMENUS='Y' %then %do;
   declare MS_ACTIONBAR fixed bin(31) value('00_00_00_01'xn);
   declare MS_TITLEBUTTON fixed bin(31) value('00_00_00_02'xn);
   declare MS_VERTICALFLIP fixed bin(31) value('00_00_00_04'xn);
   declare MS_CONDITIONALCASCADE fixed bin(31) value('00_00_00_40'xn);
   dcl WinLoadMenu entry (
          HWND,
          HMODULE,
          ULONG)
          returns(optional byvalue HWND)
          APIENTRY;
   declare MM_INSERTITEM fixed bin(16) value('01_80'xn);
   declare MM_DELETEITEM fixed bin(16) value('01_81'xn);
   declare MM_QUERYITEM fixed bin(16) value('01_82'xn);
   declare MM_SETITEM   fixed bin(16) value('01_83'xn);
   declare MM_QUERYITEMCOUNT fixed bin(16) value('01_84'xn);
   declare MM_STARTMENUMODE  fixed bin(16) value('01_85'xn);
   declare MM_ENDMENUMODE    fixed bin(16) value('01_86'xn);
   declare MM_REMOVEITEM fixed bin(16) value('01_88'xn);
   declare MM_SELECTITEM fixed bin(16) value('01_89'xn);
   declare MM_QUERYSELITEMID fixed bin(16) value('01_8A'xn);
   declare MM_QUERYITEMTEXT fixed bin(16) value('01_8B'xn);
   declare MM_QUERYITEMTEXTLENGTH fixed bin(16) value('01_8C'xn);
   declare MM_SETITEMHANDLE fixed bin(16) value('01_8D'xn);
   declare MM_SETITEMTEXT fixed bin(16) value('01_8E'xn);
   declare MM_ITEMPOSITIONFROMID fixed bin(16) value('01_8F'xn);
   declare MM_ITEMIDFROMPOSITION fixed bin(16) value('01_90'xn);
   declare MM_QUERYITEMATTR fixed bin(16) value('01_91'xn);
   declare MM_SETITEMATTR fixed bin(16) value('01_92'xn);
   declare MM_ISITEMVALID fixed bin(16) value('01_93'xn);
   declare MM_QUERYITEMRECT fixed bin(16) value('01_94'xn);
   declare MM_QUERYDEFAULTITEMID fixed bin(16) value('04_31'xn);
   declare MM_SETDEFAULTITEMID fixed bin(16) value('04_32'xn);
   %if MTI_INCLUDED='Y' %then %do;
     %MTI_INCLUDED='Y';
     %declare mti char;
     %mti='char(stg(#mti))';
     dcl 1 #mti based(null()) unaligned,
           2 afStyle USHORT,
           2 pad USHORT,
           2 idItem USHORT,
           2 c(2) CHAR;
     %declare mt char;
     %mt='char(stg(#mt))';
     dcl 1 #mt based(null()) unaligned,
           2 len ULONG,
           2 codepage USHORT,
           2 reserved USHORT,
           2 cMti USHORT,
           2 rgMti(1) MTI;
     %declare LPMT char;
     %LPMT='pointer';
   %end;
   dcl WinCreateMenu entry (
          HWND,
          PVOID)
          returns(optional byvalue HWND)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     %declare OWNERITEM char;
     %OWNERITEM='char(stg(#OWNERITEM))';
     dcl 1 #OWNERITEM based(null()) unaligned,
           2 OWNERITEM_hwnd HWND,
           2 OWNERITEM_hps HPS,
           2 fsState ULONG,
           2 fsAttribute ULONG,
           2 fsStateOld ULONG,
           2 fsAttributeOld ULONG,
           2 rclItem RECTL,
           2 idItem LONG,
           2 hItem ULONG;
     %declare POWNERITEM char;
     %POWNERITEM='pointer';
   %end;
   %declare MENUITEM char;
   %MENUITEM='char(stg(#MENUITEM))';
   dcl 1 #MENUITEM based(null()) unaligned,
         2 iPosition SHORT,
         2 afStyle USHORT,
         2 afAttribute USHORT,
         2 id USHORT,
         2 hwndSubMenu HWND,
         2 hItem ULONG;
   %declare PMENUITEM char;
   %PMENUITEM='pointer';
   %declare MIT_END char;
   %MIT_END=-1;
   %declare MIT_NONE char;
   %MIT_NONE=-1;
   %declare MIT_MEMERROR char;
   %MIT_MEMERROR=-1;
   %declare MIT_ERROR char;
   %MIT_ERROR=-1;
   %declare MIT_FIRST char;
   %MIT_FIRST=-2;
   %declare MIT_LAST char;
   %MIT_LAST=-3;
   %declare MID_NONE char;
   %MID_NONE=MIT_NONE;
   %declare MID_ERROR char;
   %MID_ERROR=-1;
   declare MIS_TEXT fixed bin(16) value('00_01'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare MIS_BITMAP fixed bin(16) value('00_02'xn);
   %end;
   declare MIS_SEPARATOR fixed bin(16) value('00_04'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare MIS_OWNERDRAW fixed bin(16) value('00_08'xn);
   %end;
   declare MIS_SUBMENU fixed bin(16) value('00_10'xn);
   declare MIS_MULTMENU fixed bin(16) value('00_20'xn);
   declare MIS_SYSCOMMAND fixed bin(16) value('00_40'xn);
   declare MIS_HELP fixed bin(16) value('00_80'xn);
   declare MIS_STATIC fixed bin(16) value('01_00'xn);
   declare MIS_BUTTONSEPARATOR fixed bin(16) value('02_00'xn);
   declare MIS_BREAK fixed bin(16) value('04_00'xn);
   declare MIS_BREAKSEPARATOR fixed bin(16) value('08_00'xn);
   declare MIS_GROUP fixed bin(16) value('10_00'xn);
   declare MIS_SINGLE fixed bin(16) value('20_00'xn);
   declare MIA_NODISMISS fixed bin(16) value('00_20'xn);
   declare MIA_FRAMED fixed bin(16) value('10_00'xn);
   declare MIA_CHECKED fixed bin(16) value('20_00'xn);
   declare MIA_DISABLED fixed bin(16) value('40_00'xn);
   declare MIA_HILITED fixed bin(16) value('80_00'xn);
   dcl WinPopupMenu entry (
          HWND,
          HWND,
          HWND,
          LONG,
          LONG,
          LONG,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   declare PU_POSITIONONITEM fixed bin(16) value('00_01'xn);
   declare PU_HCONSTRAIN fixed bin(16) value('00_02'xn);
   declare PU_VCONSTRAIN fixed bin(16) value('00_04'xn);
   declare PU_NONE fixed bin(16) value('00_00'xn);
   declare PU_MOUSEBUTTON1DOWN fixed bin(16) value('00_08'xn);
   declare PU_MOUSEBUTTON2DOWN fixed bin(16) value('00_10'xn);
   declare PU_MOUSEBUTTON3DOWN fixed bin(16) value('00_18'xn);
   declare PU_SELECTITEM fixed bin(16) value('00_20'xn);
   declare PU_MOUSEBUTTON1 fixed bin(16) value('00_40'xn);
   declare PU_MOUSEBUTTON2 fixed bin(16) value('00_80'xn);
   declare PU_MOUSEBUTTON3 fixed bin(16) value('01_00'xn);
   declare PU_KEYBOARD fixed bin(16) value('02_00'xn);
 %end;


 %if INCL_WINSCROLLBARS='Y' %then %do;
   %declare SBS_HORZ char;
   %SBS_HORZ=0;
   %declare SBS_VERT char;
   %SBS_VERT=1;
   %declare SBS_THUMBSIZE char;
   %SBS_THUMBSIZE=2;
   %declare SBS_AUTOTRACK char;
   %SBS_AUTOTRACK=4;
   declare SBS_AUTOSIZE fixed bin(31) value('00_00_20_00'xn);
   declare SBM_SETSCROLLBAR fixed bin(16) value('01_A0'xn);
   declare SBM_SETPOS fixed bin(16) value('01_A1'xn);
   declare SBM_QUERYPOS fixed bin(16) value('01_A2'xn);
   declare SBM_QUERYRANGE fixed bin(16) value('01_A3'xn);
   declare SBM_SETTHUMBSIZE fixed bin(16) value('01_A6'xn);
   %declare SB_LINEUP char;
   %SB_LINEUP=1;
   %declare SB_LINEDOWN char;
   %SB_LINEDOWN=2;
   %declare SB_LINELEFT char;
   %SB_LINELEFT=1;
   %declare SB_LINERIGHT char;
   %SB_LINERIGHT=2;
   %declare SB_PAGEUP char;
   %SB_PAGEUP=3;
   %declare SB_PAGEDOWN char;
   %SB_PAGEDOWN=4;
   %declare SB_PAGELEFT char;
   %SB_PAGELEFT=3;
   %declare SB_PAGERIGHT char;
   %SB_PAGERIGHT=4;
   %declare SB_SLIDERTRACK char;
   %SB_SLIDERTRACK=5;
   %declare SB_SLIDERPOSITION char;
   %SB_SLIDERPOSITION=6;
   %declare SB_ENDSCROLL char;
   %SB_ENDSCROLL=7;
   %if INCL_SAADEFS='Y' %then %do;
     %declare SBCDATA char;
     %SBCDATA='char(stg(#SBCDATA))';
     dcl 1 #SBCDATA based(null()) unaligned,
           2 cb USHORT,
           2 sHilite USHORT,
           2 posFirst SHORT,
           2 posLast SHORT,
           2 posThumb SHORT,
           2 cVisible SHORT,
           2 cTotal SHORT;
     %declare PSBCDATA char;
     %PSBCDATA='pointer';
   %end;
 %end;
 %if INCL_WINFRAMEMGR='Y' | INCL_NOCOMMON='Y' %then %do;
   %declare FRAMECDATA char;
   %FRAMECDATA='char(stg(#FRAMECDATA))';
   dcl 1 #FRAMECDATA based(null()) unaligned,
         2 cb USHORT,
         2 flCreateFlags ULONG,
         2 hmodResources USHORT,
         2 idResources USHORT;
   %declare PFRAMECDATA char;
   %PFRAMECDATA='pointer';
   declare FCF_TITLEBAR fixed bin(31) value('00_00_00_01'xn);
   declare FCF_SYSMENU fixed bin(31) value('00_00_00_02'xn);
   declare FCF_MENU fixed bin(31) value('00_00_00_04'xn);
   declare FCF_SIZEBORDER fixed bin(31) value('00_00_00_08'xn);
   declare FCF_MINBUTTON fixed bin(31) value('00_00_00_10'xn);
   declare FCF_MAXBUTTON fixed bin(31) value('00_00_00_20'xn);
   declare FCF_MINMAX fixed bin(31) value('00_00_00_30'xn);
   declare FCF_VERTSCROLL fixed bin(31) value('00_00_00_40'xn);
   declare FCF_HORZSCROLL fixed bin(31) value('00_00_00_80'xn);
   declare FCF_DLGBORDER  fixed bin(31) value('00_00_01_00'xn);
   declare FCF_BORDER     fixed bin(31) value('00_00_02_00'xn);
   declare FCF_SHELLPOSITION fixed bin(31) value('00_00_04_00'xn);
   declare FCF_TASKLIST   fixed bin(31) value('00_00_08_00'xn);
   declare FCF_NOBYTEALIGN fixed bin(31) value('00_00_10_00'xn);
   declare FCF_NOMOVEWITHOWNER fixed bin(31) value('00_00_20_00'xn);
   declare FCF_ICON fixed bin(31) value('00_00_40_00'xn);
   declare FCF_ACCELTABLE fixed bin(31) value('00_00_80_00'xn);
   declare FCF_SYSMODAL fixed bin(31) value('00_01_00_00'xn);
   declare FCF_SCREENALIGN fixed bin(31) value('00_02_00_00'xn);
   declare FCF_MOUSEALIGN fixed bin(31) value('00_04_00_00'xn);
   declare FCF_HIDEBUTTON fixed bin(31) value('01_00_00_00'xn);
   declare FCF_HIDEMAX fixed bin(31) value('01_00_00_20'xn);
   %if INCL_NLS='Y' %then %do;
     declare FCF_DBE_APPSTAT fixed bin(31) value('80_00_00_00'xn);
   %end;
   declare FCF_AUTOICON fixed bin(31) value('40_00_00_00'xn);
   declare FCF_STANDARD fixed bin(31) value('00_00_CC_3F'xn);
   declare FS_ICON fixed bin(31) value('00_00_00_01'xn);
   declare FS_ACCELTABLE fixed bin(31) value('00_00_00_02'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare FS_SHELLPOSITION fixed bin(31) value('00_00_00_04'xn);
   %end;
   declare FS_TASKLIST fixed bin(31) value('00_00_00_08'xn);
   declare FS_NOBYTEALIGN fixed bin(31) value('00_00_00_10'xn);
   declare FS_NOMOVEWITHOWNER fixed bin(31) value('00_00_00_20'xn);
   declare FS_SYSMODAL fixed bin(31) value('00_00_00_40'xn);
   declare FS_DLGBORDER fixed bin(31) value('00_00_00_80'xn);
   declare FS_BORDER fixed bin(31) value('00_00_01_00'xn);
   declare FS_SCREENALIGN fixed bin(31) value('00_00_02_00'xn);
   declare FS_MOUSEALIGN fixed bin(31) value('00_00_04_00'xn);
   declare FS_SIZEBORDER fixed bin(31) value('00_00_08_00'xn);
   declare FS_AUTOICON fixed bin(31) value('00_00_10_00'xn);
   %if INCL_NLS='Y' %then %do;
     declare FS_DBE_APPSTAT fixed bin(31) value('00_00_80_00'xn);
   %end;
   declare FS_STANDARD fixed bin(31) value('00_00_00_0F'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare FF_FLASHWINDOW fixed bin(16) value('00_01'xn);
     declare FF_ACTIVE fixed bin(16) value('00_02'xn);
     declare FF_FLASHHILITE fixed bin(16) value('00_04'xn);
     declare FF_OWNERHIDDEN fixed bin(16) value('00_08'xn);
     declare FF_DLGDISMISSED fixed bin(16) value('00_10'xn);
     declare FF_OWNERDISABLED fixed bin(16) value('00_20'xn);
     declare FF_SELECTED fixed bin(16) value('00_40'xn);
     declare FF_NOACTIVATESWP fixed bin(16) value('00_80'xn);
   %end;
   dcl WinCreateStdWindow entry (
          HWND,
          ULONG,
          PULONG,
          char(*) varyingz byaddr,
          char(*) varyingz byaddr,
          ULONG,
          HMODULE,
          ULONG,
          PHWND)
          returns( optional byvalue HWND )
          APIENTRY;
 %end;
 %if INCL_WINFRAMEMGR='Y' %then %do;
   dcl WinFlashWindow entry (
          HWND,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   declare WM_FLASHWINDOW fixed bin(16) value('00_40'xn);
   declare WM_FORMATFRAME fixed bin(16) value('00_41'xn);
   declare WM_UPDATEFRAME fixed bin(16) value('00_42'xn);
   declare WM_FOCUSCHANGE fixed bin(16) value('00_43'xn);
   declare WM_SETBORDERSIZE fixed bin(16) value('00_44'xn);
   declare WM_TRACKFRAME fixed bin(16) value('00_45'xn);
   declare WM_MINMAXFRAME fixed bin(16) value('00_46'xn);
   declare WM_SETICON fixed bin(16) value('00_47'xn);
   declare WM_QUERYICON fixed bin(16) value('00_48'xn);
   declare WM_SETACCELTABLE fixed bin(16) value('00_49'xn);
   declare WM_QUERYACCELTABLE fixed bin(16) value('00_4A'xn);
   declare WM_TRANSLATEACCEL fixed bin(16) value('00_4B'xn);
   declare WM_QUERYTRACKINFO fixed bin(16) value('00_4C'xn);
   declare WM_QUERYBORDERSIZE fixed bin(16) value('00_4D'xn);
   declare WM_NEXTMENU fixed bin(16) value('00_4E'xn);
   declare WM_ERASEBACKGROUND fixed bin(16) value('00_4F'xn);
   declare WM_QUERYFRAMEINFO fixed bin(16) value('00_50'xn);
   declare WM_QUERYFOCUSCHAIN fixed bin(16) value('00_51'xn);
   declare WM_OWNERPOSCHANGE fixed bin(16) value('00_52'xn);
   declare WM_CALCFRAMERECT fixed bin(16) value('00_53'xn);
   declare WM_WINDOWPOSCHANGED fixed bin(16) value('00_55'xn);
   declare WM_ADJUSTFRAMEPOS fixed bin(16) value('00_56'xn);
   declare WM_QUERYFRAMECTLCOUNT fixed bin(16) value('00_59'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare WM_QUERYHELPINFO fixed bin(16) value('00_5B'xn);
     declare WM_SETHELPINFO fixed bin(16) value('00_5C'xn);
     declare WM_ERROR fixed bin(16) value('00_5D'xn);
     declare WM_REALIZEPALETTE fixed bin(16) value('00_5E'xn);
     declare FI_FRAME fixed bin(31) value('00_00_00_01'xn);
     declare FI_OWNERHIDE fixed bin(31) value('00_00_00_02'xn);
     declare FI_ACTIVATEOK fixed bin(31) value('00_00_00_04'xn);
     declare FI_NOMOVEWITHOWNER fixed bin(31) value('00_00_00_08'xn);
   %end;
   dcl WinCreateFrameControls entry (
          HWND,
          PFRAMECDATA,
          PSZ)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinCalcFrameRect entry (
          HWND,
          PRECTL,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinGetMinPosition entry (
          HWND,
          PSWP,
          PPOINTL)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinGetMaxPosition entry (
            HWND,
            PSWP)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
   %declare HSAVEWP char;
   %HSAVEWP=LHANDLE;
   dcl WinSaveWindowPos entry (
          HSAVEWP,
          PSWP,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   declare FID_SYSMENU fixed bin(16) unsigned value('80_02'xn);
   declare FID_TITLEBAR fixed bin(16) unsigned value('80_03'xn);
   declare FID_MINMAX fixed bin(16) unsigned value('80_04'xn);
   declare FID_MENU fixed bin(16) unsigned value('80_05'xn);
   declare FID_VERTSCROLL fixed bin(16) unsigned value('80_06'xn);
   declare FID_HORZSCROLL fixed bin(16) unsigned value('80_07'xn);
   declare FID_CLIENT fixed bin(16) unsigned value('80_08'xn);
   declare FID_DBE_APPSTAT fixed bin(16) unsigned value('80_10'xn);
   declare FID_DBE_KBDSTAT fixed bin(16) unsigned value('80_11'xn);
   declare FID_DBE_PECIC fixed bin(16) unsigned value('80_12'xn);
   declare FID_DBE_KKPOPUP fixed bin(16) unsigned value('80_13'xn);
   declare SC_SIZE fixed bin(16) unsigned value('80_00'xn);
   declare SC_MOVE fixed bin(16) unsigned value('80_01'xn);
   declare SC_MINIMIZE fixed bin(16) unsigned value('80_02'xn);
   declare SC_MAXIMIZE fixed bin(16) unsigned value('80_03'xn);
   declare SC_CLOSE fixed bin(16) unsigned value('80_04'xn);
   declare SC_NEXT fixed bin(16) unsigned value('80_05'xn);
   declare SC_APPMENU fixed bin(16) unsigned value('80_06'xn);
   declare SC_SYSMENU fixed bin(16) unsigned value('80_07'xn);
   declare SC_RESTORE fixed bin(16) unsigned value('80_08'xn);
   declare SC_NEXTFRAME fixed bin(16) unsigned value('80_09'xn);
   declare SC_NEXTWINDOW fixed bin(16) unsigned value('80_10'xn);
   %if INCL_SAADEFS='Y' %then %do;
     declare SC_TASKMANAGER fixed bin(16) unsigned value('80_11'xn);
     declare SC_HELPKEYS fixed bin(16) unsigned value('80_12'xn);
     declare SC_HELPINDEX fixed bin(16) unsigned value('80_13'xn);
     declare SC_HELPEXTENDED fixed bin(16) unsigned value('80_14'xn);
     declare SC_SWITCHPANELIDS fixed bin(16) unsigned value('80_15'xn);
     declare SC_DBE_FIRST fixed bin(16) unsigned value('80_18'xn);
     declare SC_DBE_LAST fixed bin(16) unsigned value('80_1F'xn);
     declare SC_BEGINDRAG fixed bin(16) unsigned value('80_20'xn);
     declare SC_ENDDRAG fixed bin(16) unsigned value('80_21'xn);
     declare SC_SELECT fixed bin(16) unsigned value('80_22'xn);
     declare SC_OPEN fixed bin(16) unsigned value('80_23'xn);
     declare SC_CONTEXTMENU fixed bin(16) unsigned value('80_24'xn);
     declare SC_CONTEXTHELP fixed bin(16) unsigned value('80_25'xn);
     declare SC_TEXTEDIT fixed bin(16) unsigned value('80_26'xn);
     declare SC_BEGINSELECT fixed bin(16) unsigned value('80_27'xn);
     declare SC_ENDSELECT fixed bin(16) unsigned value('80_28'xn);
     declare SC_WINDOW fixed bin(16) unsigned value('80_29'xn);
     declare SC_HIDE fixed bin(16) unsigned value('80_2A'xn);
   %end;
 %end;
 %if INCL_WINFRAMECTLS='Y' %then %do;
   declare TBM_SETHILITE fixed bin(16) value('01_E3'xn);
   declare TBM_QUERYHILITE fixed bin(16) value('01_E4'xn);
 %end;
 %if INCL_WINRECTANGLES='Y' %then %do;
   dcl WinCopyRect entry (
          HAB,
          PRECTL,
          PRECTL)
          returns(optional byvalue BOOL)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinSetRect entry (
            HAB,
            PRECTL,
            LONG,
            LONG,
            LONG,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinIsRectEmpty entry (
            HAB,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinEqualRect entry (
            HAB,
            PRECTL,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinSetRectEmpty entry (
            HAB,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinOffsetRect entry (
            HAB,
            PRECTL,
            LONG,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinInflateRect entry (
            HAB,
            PRECTL,
            LONG,
            LONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinPtInRect entry (
            HAB,
            PRECTL,
            PPOINTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinIntersectRect entry (
            HAB,
            PRECTL,
            PRECTL,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinUnionRect entry (
            HAB,
            PRECTL,
            PRECTL,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinSubtractRect entry (
            HAB,
            PRECTL,
            PRECTL,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinMakeRect entry (
            HAB,
            PRECTL)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinMakePoints entry (
            HAB,
            PPOINTL,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
   %end;
 %end;
 %if INCL_WINSYS='Y' %then %do;
   dcl WinQuerySysValue entry (
          HWND,
          LONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl WinSetSysValue entry (
          HWND,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %declare SV_SWAPBUTTON char;
   %SV_SWAPBUTTON=0;
   %declare SV_DBLCLKTIME char;
   %SV_DBLCLKTIME=1;
   %declare SV_CXDBLCLK char;
   %SV_CXDBLCLK=2;
   %declare SV_CYDBLCLK char;
   %SV_CYDBLCLK=3;
   %declare SV_CXSIZEBORDER char;
   %SV_CXSIZEBORDER=4;
   %declare SV_CYSIZEBORDER char;
   %SV_CYSIZEBORDER=5;
   %declare SV_ALARM char;
   %SV_ALARM=6;
   %if INCL_SAADEFS='Y' %then %do;
     %declare SV_RESERVEDFIRST1 char;
     %SV_RESERVEDFIRST1=7;
     %declare SV_RESERVEDLAST1 char;
     %SV_RESERVEDLAST1=8;
   %end;
   %declare SV_CURSORRATE char;
   %SV_CURSORRATE=9;
   %declare SV_FIRSTSCROLLRATE char;
   %SV_FIRSTSCROLLRATE=10;
   %declare SV_SCROLLRATE char;
   %SV_SCROLLRATE=11;
   %declare SV_NUMBEREDLISTS char;
   %SV_NUMBEREDLISTS=12;
   %declare SV_WARNINGFREQ char;
   %SV_WARNINGFREQ=13;
   %declare SV_NOTEFREQ char;
   %SV_NOTEFREQ=14;
   %declare SV_ERRORFREQ char;
   %SV_ERRORFREQ=15;
   %declare SV_WARNINGDURATION char;
   %SV_WARNINGDURATION=16;
   %declare SV_NOTEDURATION char;
   %SV_NOTEDURATION=17;
   %declare SV_ERRORDURATION char;
   %SV_ERRORDURATION=18;
   %if INCL_SAADEFS='Y' %then %do;
     %declare SV_RESERVEDFIRST char;
     %SV_RESERVEDFIRST=19;
     %declare SV_RESERVEDLAST char;
     %SV_RESERVEDLAST=19;
   %end;
   %declare SV_CXSCREEN char;
   %SV_CXSCREEN=20;
   %declare SV_CYSCREEN char;
   %SV_CYSCREEN=21;
   %declare SV_CXVSCROLL char;
   %SV_CXVSCROLL=22;
   %declare SV_CYHSCROLL char;
   %SV_CYHSCROLL=23;
   %declare SV_CYVSCROLLARROW char;
   %SV_CYVSCROLLARROW=24;
   %declare SV_CXHSCROLLARROW char;
   %SV_CXHSCROLLARROW=25;
   %declare SV_CXBORDER char;
   %SV_CXBORDER=26;
   %declare SV_CYBORDER char;
   %SV_CYBORDER=27;
   %declare SV_CXDLGFRAME char;
   %SV_CXDLGFRAME=28;
   %declare SV_CYDLGFRAME char;
   %SV_CYDLGFRAME=29;
   %declare SV_CYTITLEBAR char;
   %SV_CYTITLEBAR=30;
   %declare SV_CYVSLIDER char;
   %SV_CYVSLIDER=31;
   %declare SV_CXHSLIDER char;
   %SV_CXHSLIDER=32;
   %declare SV_CXMINMAXBUTTON char;
   %SV_CXMINMAXBUTTON=33;
   %declare SV_CYMINMAXBUTTON char;
   %SV_CYMINMAXBUTTON=34;
   %declare SV_CYMENU char;
   %SV_CYMENU=35;
   %declare SV_CXFULLSCREEN char;
   %SV_CXFULLSCREEN=36;
   %declare SV_CYFULLSCREEN char;
   %SV_CYFULLSCREEN=37;
   %declare SV_CXICON char;
   %SV_CXICON=38;
   %declare SV_CYICON char;
   %SV_CYICON=39;
   %declare SV_CXPOINTER char;
   %SV_CXPOINTER=40;
   %declare SV_CYPOINTER char;
   %SV_CYPOINTER=41;
   %declare SV_DEBUG char;
   %SV_DEBUG=42;
   %declare SV_CMOUSEBUTTONS char;
   %SV_CMOUSEBUTTONS=43;
   %declare SV_CPOINTERBUTTONS char;
   %SV_CPOINTERBUTTONS=43;
   %declare SV_POINTERLEVEL char;
   %SV_POINTERLEVEL=44;
   %declare SV_CURSORLEVEL char;
   %SV_CURSORLEVEL=45;
   %declare SV_TRACKRECTLEVEL char;
   %SV_TRACKRECTLEVEL=46;
   %if INCL_SAADEFS='Y' %then %do;
     %declare SV_CTIMERS char;
     %SV_CTIMERS=47;
   %end;
   %declare SV_MOUSEPRESENT char;
   %SV_MOUSEPRESENT=48;
   %declare SV_CXBYTEALIGN char;
   %SV_CXBYTEALIGN=49;
   %declare SV_CXALIGN char;
   %SV_CXALIGN=49;
   %declare SV_CYBYTEALIGN char;
   %SV_CYBYTEALIGN=50;
   %declare SV_CYALIGN char;
   %SV_CYALIGN=50;
   %declare SV_NOTRESERVED char;
   %SV_NOTRESERVED=56;
   %declare SV_EXTRAKEYBEEP char;
   %SV_EXTRAKEYBEEP=57;
   %declare SV_SETLIGHTS char;
   %SV_SETLIGHTS=58;
   %declare SV_INSERTMODE char;
   %SV_INSERTMODE=59;
   %declare SV_MENUROLLDOWNDELAY char;
   %SV_MENUROLLDOWNDELAY=64;
   %declare SV_MENUROLLUPDELAY char;
   %SV_MENUROLLUPDELAY=65;
   %declare SV_ALTMNEMONIC char;
   %SV_ALTMNEMONIC=66;
   %declare SV_TASKLISTMOUSEACCESS char;
   %SV_TASKLISTMOUSEACCESS=67;
   %declare SV_CXICONTEXTWIDTH char;
   %SV_CXICONTEXTWIDTH=68;
   %declare SV_CICONTEXTLINES char;
   %SV_CICONTEXTLINES=69;
   %declare SV_CHORDTIME char;
   %SV_CHORDTIME=70;
   %declare SV_CXCHORD char;
   %SV_CXCHORD=71;
   %declare SV_CYCHORD char;
   %SV_CYCHORD=72;
   %declare SV_CXMOTIONSTART char;
   %SV_CXMOTIONSTART=73;
   %declare SV_CYMOTIONSTART char;
   %SV_CYMOTIONSTART=74;
   %declare SV_BEGINDRAG char;
   %SV_BEGINDRAG=75;
   %declare SV_ENDDRAG char;
   %SV_ENDDRAG=76;
   %declare SV_SINGLESELECT char;
   %SV_SINGLESELECT=77;
   %declare SV_OPEN char;
   %SV_OPEN=78;
   %declare SV_CONTEXTMENU char;
   %SV_CONTEXTMENU=79;
   %declare SV_CONTEXTHELP char;
   %SV_CONTEXTHELP=80;
   %declare SV_TEXTEDIT char;
   %SV_TEXTEDIT=81;
   %declare SV_BEGINSELECT char;
   %SV_BEGINSELECT=82;
   %declare SV_ENDSELECT char;
   %SV_ENDSELECT=83;
   %declare SV_BEGINDRAGKB char;
   %SV_BEGINDRAGKB=84;
   %declare SV_ENDDRAGKB char;
   %SV_ENDDRAGKB=85;
   %declare SV_SELECTKB char;
   %SV_SELECTKB=86;
   %declare SV_OPENKB char;
   %SV_OPENKB=87;
   %declare SV_CONTEXTMENUKB char;
   %SV_CONTEXTMENUKB=88;
   %declare SV_CONTEXTHELPKB char;
   %SV_CONTEXTHELPKB=89;
   %declare SV_TEXTEDITKB char;
   %SV_TEXTEDITKB=90;
   %declare SV_BEGINSELECTKB char;
   %SV_BEGINSELECTKB=91;
   %declare SV_ENDSELECTKB char;
   %SV_ENDSELECTKB=92;
   %declare SV_ANIMATION char;
   %SV_ANIMATION=93;
   %declare SV_ANIMATIONSPEED char;
   %SV_ANIMATIONSPEED=94;
   %declare SV_MONOICONS char;
   %SV_MONOICONS=95;
   %declare SV_KBDALTERED char;
   %SV_KBDALTERED=96;
   %declare SV_PRINTSCREEN char;
   %SV_PRINTSCREEN=97;
   %declare SV_CSYSVALUES char;
   %SV_CSYSVALUES=98;
   %declare PARAM char;
   %PARAM='char(stg(#PARAM))';
   dcl 1 #PARAM based(null()) unaligned,
         2 id ULONG,
         2 cb ULONG,
         2 ab(1) BYTE;
   %declare NPPARAM char;
   %NPPARAM='pointer';
   %declare PPARAM char;
   %PPARAM='pointer';
   %declare PRESPARAMS char;
   %PRESPARAMS='char(stg(#PRESPARAMS))';
   dcl 1 #PRESPARAMS based(null()) unaligned,
         2 cb ULONG,
         2 aparam(1) PARAM;
   %declare NPPRESPARAMS char;
   %NPPRESPARAMS='pointer';
   %declare PPRESPARAMS char;
   %PPRESPARAMS='pointer';
   dcl WinSetPresParam entry (
          HWND,
          ULONG,
          ULONG,
          * byaddr )
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryPresParam entry (
          HWND,
          ULONG,
          ULONG,
          PULONG optional,
          ULONG,
          PVOID,
          ULONG)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl WinRemovePresParam entry (
          HWND,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %declare PP_FOREGROUNDCOLOR char;
   %PP_FOREGROUNDCOLOR=1;
   %declare PP_FOREGROUNDCOLORINDEX char;
   %PP_FOREGROUNDCOLORINDEX=2;
   %declare PP_BACKGROUNDCOLOR char;
   %PP_BACKGROUNDCOLOR=3;
   %declare PP_BACKGROUNDCOLORINDEX char;
   %PP_BACKGROUNDCOLORINDEX=4;
   %declare PP_HILITEFOREGROUNDCOLOR char;
   %PP_HILITEFOREGROUNDCOLOR=5;
   %declare PP_HILITEFOREGROUNDCOLORINDEX char;
   %PP_HILITEFOREGROUNDCOLORINDEX=6;
   %declare PP_HILITEBACKGROUNDCOLOR char;
   %PP_HILITEBACKGROUNDCOLOR=7;
   %declare PP_HILITEBACKGROUNDCOLORINDEX char;
   %PP_HILITEBACKGROUNDCOLORINDEX=8;
   %declare PP_DISABLEDFOREGROUNDCOLOR char;
   %PP_DISABLEDFOREGROUNDCOLOR=9;
   %declare PP_DISABLEDFOREGROUNDCOLORINDEX char;
   %PP_DISABLEDFOREGROUNDCOLORINDEX=10;
   %declare PP_DISABLEDBACKGROUNDCOLOR char;
   %PP_DISABLEDBACKGROUNDCOLOR=11;
   %declare PP_DISABLEDBACKGROUNDCOLORINDEX char;
   %PP_DISABLEDBACKGROUNDCOLORINDEX=12;
   %declare PP_BORDERCOLOR char;
   %PP_BORDERCOLOR=13;
   %declare PP_BORDERCOLORINDEX char;
   %PP_BORDERCOLORINDEX=14;
   %declare PP_FONTNAMESIZE char;
   %PP_FONTNAMESIZE=15;
   %declare PP_FONTHANDLE char;
   %PP_FONTHANDLE=16;
   %declare PP_RESERVED char;
   %PP_RESERVED=17;
   %declare PP_ACTIVECOLOR char;
   %PP_ACTIVECOLOR=18;
   %declare PP_ACTIVECOLORINDEX char;
   %PP_ACTIVECOLORINDEX=19;
   %declare PP_INACTIVECOLOR char;
   %PP_INACTIVECOLOR=20;
   %declare PP_INACTIVECOLORINDEX char;
   %PP_INACTIVECOLORINDEX=21;
   %declare PP_ACTIVETEXTFGNDCOLOR char;
   %PP_ACTIVETEXTFGNDCOLOR=22;
   %declare PP_ACTIVETEXTFGNDCOLORINDEX char;
   %PP_ACTIVETEXTFGNDCOLORINDEX=23;
   %declare PP_ACTIVETEXTBGNDCOLOR char;
   %PP_ACTIVETEXTBGNDCOLOR=24;
   %declare PP_ACTIVETEXTBGNDCOLORINDEX char;
   %PP_ACTIVETEXTBGNDCOLORINDEX=25;
   %declare PP_INACTIVETEXTFGNDCOLOR char;
   %PP_INACTIVETEXTFGNDCOLOR=26;
   %declare PP_INACTIVETEXTFGNDCOLORINDEX char;
   %PP_INACTIVETEXTFGNDCOLORINDEX=27;
   %declare PP_INACTIVETEXTBGNDCOLOR char;
   %PP_INACTIVETEXTBGNDCOLOR=28;
   %declare PP_INACTIVETEXTBGNDCOLORINDEX char;
   %PP_INACTIVETEXTBGNDCOLORINDEX=29;
   %declare PP_SHADOW char;
   %PP_SHADOW=30;
   %declare PP_MENUFOREGROUNDCOLOR char;
   %PP_MENUFOREGROUNDCOLOR=31;
   %declare PP_MENUFOREGROUNDCOLORINDEX char;
   %PP_MENUFOREGROUNDCOLORINDEX=32;
   %declare PP_MENUBACKGROUNDCOLOR char;
   %PP_MENUBACKGROUNDCOLOR=33;
   %declare PP_MENUBACKGROUNDCOLORINDEX char;
   %PP_MENUBACKGROUNDCOLORINDEX=34;
   %declare PP_MENUHILITEFGNDCOLOR char;
   %PP_MENUHILITEFGNDCOLOR=35;
   %declare PP_MENUHILITEFGNDCOLORINDEX char;
   %PP_MENUHILITEFGNDCOLORINDEX=36;
   %declare PP_MENUHILITEBGNDCOLOR char;
   %PP_MENUHILITEBGNDCOLOR=37;
   %declare PP_MENUHILITEBGNDCOLORINDEX char;
   %PP_MENUHILITEBGNDCOLORINDEX=38;
   %declare PP_MENUDISABLEDFGNDCOLOR char;
   %PP_MENUDISABLEDFGNDCOLOR=39;
   %declare PP_MENUDISABLEDFGNDCOLORINDEX char;
   %PP_MENUDISABLEDFGNDCOLORINDEX=40;
   %declare PP_MENUDISABLEDBGNDCOLOR char;
   %PP_MENUDISABLEDBGNDCOLOR=41;
   %declare PP_MENUDISABLEDBGNDCOLORINDEX char;
   %PP_MENUDISABLEDBGNDCOLORINDEX=42;
   declare PP_USER fixed bin(31) value('00_00_80_00'xn);
   declare QPF_NOINHERIT fixed bin(16) value('00_01'xn);
   declare QPF_ID1COLORINDEX fixed bin(16) value('00_02'xn);
   declare QPF_ID2COLORINDEX fixed bin(16) value('00_04'xn);
   declare QPF_PURERGBCOLOR fixed bin(16) value('00_08'xn);
   declare QPF_VALIDFLAGS fixed bin(16) value('00_0f'xn);
   dcl WinQuerySysColor entry (
          HWND,
          LONG,
          LONG)
          returns(optional byvalue LONG)
          APIENTRY;
   dcl WinSetSysColors entry (
          HWND,
          ULONG,
          ULONG,
          LONG,
          ULONG,
          PLONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   %declare SYSCLR_SHADOWHILITEBGND char;
   %SYSCLR_SHADOWHILITEBGND=-50;
   %declare SYSCLR_SHADOWHILITEFGND char;
   %SYSCLR_SHADOWHILITEFGND=-49;
   %declare SYSCLR_SHADOWTEXT char;
   %SYSCLR_SHADOWTEXT=-48;
   %declare SYSCLR_ENTRYFIELD char;
   %SYSCLR_ENTRYFIELD=-47;
   %declare SYSCLR_MENUDISABLEDTEXT char;
   %SYSCLR_MENUDISABLEDTEXT=-46;
   %declare SYSCLR_MENUHILITE char;
   %SYSCLR_MENUHILITE=-45;
   %declare SYSCLR_MENUHILITEBGND char;
   %SYSCLR_MENUHILITEBGND=-44;
   %declare SYSCLR_PAGEBACKGROUND char;
   %SYSCLR_PAGEBACKGROUND=-43;
   %declare SYSCLR_FIELDBACKGROUND char;
   %SYSCLR_FIELDBACKGROUND=-42;
   %declare SYSCLR_BUTTONLIGHT char;
   %SYSCLR_BUTTONLIGHT=-41;
   %declare SYSCLR_BUTTONMIDDLE char;
   %SYSCLR_BUTTONMIDDLE=-40;
   %declare SYSCLR_BUTTONDARK char;
   %SYSCLR_BUTTONDARK=-39;
   %declare SYSCLR_BUTTONDEFAULT char;
   %SYSCLR_BUTTONDEFAULT=-38;
   %declare SYSCLR_TITLEBOTTOM char;
   %SYSCLR_TITLEBOTTOM=-37;
   %declare SYSCLR_SHADOW char;
   %SYSCLR_SHADOW=-36;
   %declare SYSCLR_ICONTEXT char;
   %SYSCLR_ICONTEXT=-35;
   %declare SYSCLR_DIALOGBACKGROUND char;
   %SYSCLR_DIALOGBACKGROUND=-34;
   %declare SYSCLR_HILITEFOREGROUND char;
   %SYSCLR_HILITEFOREGROUND=-33;
   %declare SYSCLR_HILITEBACKGROUND char;
   %SYSCLR_HILITEBACKGROUND=-32;
   %declare SYSCLR_INACTIVETITLETEXTBGND char;
   %SYSCLR_INACTIVETITLETEXTBGND=-31;
   %declare SYSCLR_ACTIVETITLETEXTBGND char;
   %SYSCLR_ACTIVETITLETEXTBGND=-30;
   %declare SYSCLR_INACTIVETITLETEXT char;
   %SYSCLR_INACTIVETITLETEXT=-29;
   %declare SYSCLR_ACTIVETITLETEXT char;
   %SYSCLR_ACTIVETITLETEXT=-28;
   %declare SYSCLR_OUTPUTTEXT char;
   %SYSCLR_OUTPUTTEXT=-27;
   %declare SYSCLR_WINDOWSTATICTEXT char;
   %SYSCLR_WINDOWSTATICTEXT=-26;
   %declare SYSCLR_SCROLLBAR char;
   %SYSCLR_SCROLLBAR=-25;
   %declare SYSCLR_BACKGROUND char;
   %SYSCLR_BACKGROUND=-24;
   %declare SYSCLR_ACTIVETITLE char;
   %SYSCLR_ACTIVETITLE=-23;
   %declare SYSCLR_INACTIVETITLE char;
   %SYSCLR_INACTIVETITLE=-22;
   %declare SYSCLR_MENU char;
   %SYSCLR_MENU=-21;
   %declare SYSCLR_WINDOW char;
   %SYSCLR_WINDOW=-20;
   %declare SYSCLR_WINDOWFRAME char;
   %SYSCLR_WINDOWFRAME=-19;
   %declare SYSCLR_MENUTEXT char;
   %SYSCLR_MENUTEXT=-18;
   %declare SYSCLR_WINDOWTEXT char;
   %SYSCLR_WINDOWTEXT=-17;
   %declare SYSCLR_TITLETEXT char;
   %SYSCLR_TITLETEXT=-16;
   %declare SYSCLR_ACTIVEBORDER char;
   %SYSCLR_ACTIVEBORDER=-15;
   %declare SYSCLR_INACTIVEBORDER char;
   %SYSCLR_INACTIVEBORDER=-14;
   %declare SYSCLR_APPWORKSPACE char;
   %SYSCLR_APPWORKSPACE=-13;
   %declare SYSCLR_HELPBACKGROUND char;
   %SYSCLR_HELPBACKGROUND=-12;
   %declare SYSCLR_HELPTEXT char;
   %SYSCLR_HELPTEXT=-11;
   %declare SYSCLR_HELPHILITE char;
   %SYSCLR_HELPHILITE=-10;
   %declare SYSCLR_CSYSCOLORS char;
   %SYSCLR_CSYSCOLORS=41;
 %end;
 %if INCL_WINTIMER='Y' %then %do;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinStartTimer entry (
            HAB,
            HWND,
            ULONG,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinStopTimer entry (
            HAB,
            HWND,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinGetCurrentTime entry (
            HAB)
            returns(optional byvalue ULONG)
            APIENTRY;
     declare TID_CURSOR fixed bin(16) value('FF_FF'xn);
     declare TID_SCROLL fixed bin(16) value('FF_FE'xn);
     declare TID_FLASHWINDOW fixed bin(16) value('FF_FD'xn);
     declare TID_USERMAX fixed bin(16) value('7F_FF'xn);
   %end;
 %end;
 %declare HACCEL char;
 %HACCEL=LHANDLE;
 %if INCL_WINACCELERATORS='Y' %then %do;
   %if INCL_SAADEFS='Y' %then %do;
     declare AF_CHAR fixed bin(16) value('00_01'xn);
     declare AF_VIRTUALKEY fixed bin(16) value('00_02'xn);
     declare AF_SCANCODE fixed bin(16) value('00_04'xn);
     declare AF_SHIFT fixed bin(16) value('00_08'xn);
     declare AF_CONTROL fixed bin(16) value('00_10'xn);
     declare AF_ALT fixed bin(16) value('00_20'xn);
     declare AF_LONEKEY fixed bin(16) value('00_40'xn);
     declare AF_SYSCOMMAND fixed bin(16) value('01_00'xn);
     declare AF_HELP fixed bin(16) value('02_00'xn);
   %end;
   %declare ACCEL char;
   %ACCEL='char(stg(#ACCEL))';
   dcl 1 #ACCEL based(null()) unaligned,
         2 fs USHORT,
         2 key USHORT,
         2 cmd USHORT;
   %declare PACCEL char;
   %PACCEL='pointer';
   %declare ACCELTABLE char;
   %ACCELTABLE='char(stg(#ACCELTABLE))';
   dcl 1 #ACCELTABLE based(null()) unaligned,
         2 cAccel USHORT,
         2 codepage USHORT,
         2 aaccel(1) ACCEL;
   %declare PACCELTABLE char;
   %PACCELTABLE='pointer';
   dcl WinLoadAccelTable entry (
          HAB,
          HMODULE,
          ULONG)
          returns(optional byvalue HACCEL)
          APIENTRY;
   dcl WinCopyAccelTable entry (
          HACCEL,
          PACCELTABLE,
          ULONG)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl WinCreateAccelTable entry (
          HAB,
          PACCELTABLE)
          returns(optional byvalue HACCEL)
          APIENTRY;
   dcl WinDestroyAccelTable entry (
          HACCEL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinTranslateAccel entry (
          HAB,
          HWND,
          HACCEL,
          PQMSG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinSetAccelTable entry (
          HAB,
          HACCEL,
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryAccelTable entry (
          HAB,
          HWND)
          returns(optional byvalue HACCEL)
          APIENTRY;
 %end;
 declare EAF_DEFAULTOWNER fixed bin(16) value('00_01'xn);
 declare EAF_UNCHANGEABLE fixed bin(16) value('00_02'xn);
 declare EAF_REUSEICON fixed bin(16) value('00_04'xn);
 %if INCL_WINTRACKRECT='Y' %then %do;
   %declare TRACKINFO char;
   %TRACKINFO='char(stg(#TRACKINFO))';
   dcl 1 #TRACKINFO based(null()) unaligned,
         2 cxBorder LONG,
         2 cyBorder LONG,
         2 cxGrid LONG,
         2 cyGrid LONG,
         2 cxKeyboard LONG,
         2 cyKeyboard LONG,
         2 rclTrack RECTL,
         2 rclBoundary RECTL,
         2 ptlMinTrackSize POINTL,
         2 ptlMaxTrackSize POINTL,
         2 fs ULONG;
   %declare PTRACKINFO char;
   %PTRACKINFO='pointer';
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinTrackRect entry (
            HWND,
            HPS,
            PTRACKINFO)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinShowTrackRect entry (
            HWND,
            BOOL)
            returns(optional byvalue BOOL)
            APIENTRY;
     declare TF_LEFT fixed bin(16) value('00_01'xn);
     declare TF_TOP fixed bin(16) value('00_02'xn);
     declare TF_RIGHT fixed bin(16) value('00_04'xn);
     declare TF_BOTTOM fixed bin(16) value('00_08'xn);
     declare TF_MOVE fixed bin(16) value('00_0F'xn);
     declare TF_SETPOINTERPOS fixed bin(16) value('00_10'xn);
     declare TF_GRID fixed bin(16) value('00_20'xn);
     declare TF_STANDARD fixed bin(16) value('00_40'xn);
     declare TF_ALLINBOUNDARY fixed bin(16) value('00_80'xn);
     declare TF_VALIDATETRACKRECT fixed bin(16) value('01_00'xn);
     declare TF_PARTINBOUNDARY fixed bin(16) value('02_00'xn);
   %end;
 %end;
 %if INCL_WINCLIPBOARD='Y' | INCL_WINDDE='Y' %then %do;
   %if INCL_SAADEFS='Y' %then %do;
     declare WM_RENDERFMT fixed bin(16) value('00_60'xn);
     declare WM_RENDERALLFMTS fixed bin(16) value('00_61'xn);
     declare WM_DESTROYCLIPBOARD fixed bin(16) value('00_62'xn);
     declare WM_PAINTCLIPBOARD fixed bin(16) value('00_63'xn);
     declare WM_SIZECLIPBOARD fixed bin(16) value('00_64'xn);
     declare WM_HSCROLLCLIPBOARD fixed bin(16) value('00_65'xn);
     declare WM_VSCROLLCLIPBOARD fixed bin(16) value('00_66'xn);
     declare WM_DRAWCLIPBOARD fixed bin(16) value('00_67'xn);
     %declare CF_TEXT char;
     %CF_TEXT=1;
     %declare CF_BITMAP char;
     %CF_BITMAP=2;
     %declare CF_DSPTEXT char;
     %CF_DSPTEXT=3;
     %declare CF_DSPBITMAP char;
     %CF_DSPBITMAP=4;
     %declare CF_METAFILE char;
     %CF_METAFILE=5;
     %declare CF_DSPMETAFILE char;
     %CF_DSPMETAFILE=6;
     %declare CF_PALETTE char;
     %CF_PALETTE=9;
     %declare CF_MMPMFIRST char;
     %CF_MMPMFIRST=10;
     %declare CF_MMPMLAST char;
     %CF_MMPMLAST=19;
     %declare SZFMT_TEXT char;
     %SZFMT_TEXT='''#1''';
     %declare SZFMT_BITMAP char;
     %SZFMT_BITMAP='''#2''';
     %declare SZFMT_DSPTEXT char;
     %SZFMT_DSPTEXT='''#3''';
     %declare SZFMT_DSPBITMAP char;
     %SZFMT_DSPBITMAP='''#4''';
     %declare SZFMT_METAFILE char;
     %SZFMT_METAFILE='''#5''';
     %declare SZFMT_DSPMETAFILE char;
     %SZFMT_DSPMETAFILE='''#6''';
     %declare SZFMT_PALETTE char;
     %SZFMT_PALETTE='''#9''';
     %declare SZFMT_SYLK char;
     %SZFMT_SYLK='''Sylk''';
     %declare SZFMT_DIF char;
     %SZFMT_DIF='''Dif''';
     %declare SZFMT_TIFF char;
     %SZFMT_TIFF='''Tiff''';
     %declare SZFMT_OEMTEXT char;
     %SZFMT_OEMTEXT='''OemText''';
     %declare SZFMT_DIB char;
     %SZFMT_DIB='''Dib''';
     %declare SZFMT_OWNERDISPLAY char;
     %SZFMT_OWNERDISPLAY='''OwnerDisplay''';
     %declare SZFMT_LINK char;
     %SZFMT_LINK='''Link''';
     %declare SZFMT_METAFILEPICT char;
     %SZFMT_METAFILEPICT='''MetaFilePict''';
     %declare SZFMT_DSPMETAFILEPICT char;
     %SZFMT_DSPMETAFILEPICT='''DspMetaFilePict''';
     %declare SZFMT_CPTEXT char;
     %SZFMT_CPTEXT='''Codepage Text''';
     %declare SZDDEFMT_RTF char;
     %SZDDEFMT_RTF='''Rich Text Format''';
     %declare SZDDEFMT_PTRPICT char;
     %SZDDEFMT_PTRPICT='''Printer_Picture''';
     %declare MFP char;
     %MFP='char(stg(#MFP))';
     dcl 1 #MFP based(null()) unaligned,
           2 sizeBounds POINTL,
           2 sizeMM POINTL,
           2 cbLength ULONG,
           2 mapMode USHORT,
           2 reserved USHORT,
           2 abData(1) BYTE;
     %declare PMFP char;
     %PMFP='pointer';
     %declare CPTEXT char;
     %CPTEXT='char(stg(#CPTEXT))';
     dcl 1 #CPTEXT based(null()) unaligned,
           2 idCountry USHORT,
           2 usCodepage USHORT,
           2 usLangID USHORT,
           2 usSubLangID USHORT,
           2 abText(1) BYTE;
     %declare PCPTEXT char;
     %PCPTEXT='pointer';
   %end;
 %end;
 %if INCL_WINCLIPBOARD='Y' %then %do;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinSetClipbrdOwner entry (
            HAB,
            HWND)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinSetClipbrdData entry (
            HAB,
            ULONG,
            ULONG,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinQueryClipbrdData entry (
            HAB,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinQueryClipbrdFmtInfo entry (
            HAB,
            ULONG,
            PULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinSetClipbrdViewer entry (
            HAB,
            HWND)
            returns(optional byvalue BOOL)
            APIENTRY;
     declare CFI_OWNERFREE fixed bin(16) value('00_01'xn);
     declare CFI_OWNERDISPLAY fixed bin(16) value('00_02'xn);
     declare CFI_POINTER fixed bin(16) value('04_00'xn);
     declare CFI_HANDLE fixed bin(16) value('02_00'xn);
   %end;
   dcl WinEnumClipbrdFmts entry (
          HAB,
          ULONG)
          returns(optional byvalue ULONG)
          APIENTRY;
   dcl WinEmptyClipbrd entry (
          HAB)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinOpenClipbrd entry (
          HAB)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinCloseClipbrd entry (
          HAB)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryClipbrdOwner entry (
          HAB)
          returns(optional byvalue HWND)
          APIENTRY;
   dcl WinQueryClipbrdViewer entry (
          HAB)
          returns(optional byvalue HWND)
          APIENTRY;
 %end;
 %if INCL_WINCURSORS='Y' | INCL_NOCOMMON='Y' %then %do;
   dcl WinDestroyCursor entry (
          HWND)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinShowCursor entry (
          HWND,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinCreateCursor entry (
          HWND,
          LONG,
          LONG,
          LONG,
          LONG,
          ULONG,
          PRECTL)
          returns(optional byvalue BOOL)
          APIENTRY;
   declare CURSOR_SOLID fixed bin(16) value('00_00'xn);
   declare CURSOR_HALFTONE fixed bin(16) value('00_01'xn);
   declare CURSOR_FRAME fixed bin(16) value('00_02'xn);
   declare CURSOR_FLASH fixed bin(16) value('00_04'xn);
   declare CURSOR_SETPOS fixed bin(16) value('80_00'xn);
 %end;
 %if INCL_WINCURSORS='Y' %then %do;
   %declare CURSORINFO char;
   %CURSORINFO='char(stg(#CURSORINFO))';
   dcl 1 #CURSORINFO based(null()) unaligned,
         2 CURSORINFO_hwnd HWND,
         2 x LONG,
         2 y LONG,
         2 cx LONG,
         2 cy LONG,
         2 fs ULONG,
         2 rclClip RECTL;
   %declare PCURSORINFO char;
   %PCURSORINFO='pointer';
   dcl WinQueryCursorInfo entry (
          HWND,
          PCURSORINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
 %end;
 %declare HPOINTER char;
 %HPOINTER=LHANDLE;
 %if INCL_WINPOINTERS='Y' %then %do;
   dcl WinSetPointer entry (
          HWND,
          HPOINTER)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinSetPointerOwner entry (
          HPOINTER,
          PID,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinShowPointer entry (
          HWND,
          BOOL)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinLockPointerUpdate entry (
          HWND,
          HPOINTER,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQuerySysPointer entry (
          HWND,
          LONG,
          BOOL)
          returns(optional byvalue HPOINTER)
          APIENTRY;
   dcl WinQuerySysPointerData entry (
          HWND,
          ULONG,
          PICONINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinSetSysPointerData entry (
          HWND,
          ULONG,
          PICONINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
   %declare SPTR_ARROW char;
   %SPTR_ARROW=1;
   %declare SPTR_TEXT char;
   %SPTR_TEXT=2;
   %declare SPTR_WAIT char;
   %SPTR_WAIT=3;
   %declare SPTR_SIZE char;
   %SPTR_SIZE=4;
   %declare SPTR_MOVE char;
   %SPTR_MOVE=5;
   %declare SPTR_SIZENWSE char;
   %SPTR_SIZENWSE=6;
   %declare SPTR_SIZENESW char;
   %SPTR_SIZENESW=7;
   %declare SPTR_SIZEWE char;
   %SPTR_SIZEWE=8;
   %declare SPTR_SIZENS char;
   %SPTR_SIZENS=9;
   %declare SPTR_APPICON char;
   %SPTR_APPICON=10;
   %declare SPTR_ICONINFORMATION char;
   %SPTR_ICONINFORMATION=11;
   %declare SPTR_ICONQUESTION char;
   %SPTR_ICONQUESTION=12;
   %declare SPTR_ICONERROR char;
   %SPTR_ICONERROR=13;
   %declare SPTR_ICONWARNING char;
   %SPTR_ICONWARNING=14;
   %declare SPTR_ILLEGAL char;
   %SPTR_ILLEGAL=18;
   %declare SPTR_FILE char;
   %SPTR_FILE=19;
   %declare SPTR_FOLDER char;
   %SPTR_FOLDER=20;
   %declare SPTR_MULTFILE char;
   %SPTR_MULTFILE=21;
   %declare SPTR_PROGRAM char;
   %SPTR_PROGRAM=22;
   %declare SPTR_DISPLAY_PTRS char;
   %SPTR_DISPLAY_PTRS=22;
   %declare SPTR_PENFIRST char;
   %SPTR_PENFIRST=23;
   %declare SPTR_PENLAST char;
   %SPTR_PENLAST=39;
   %declare SPTR_CPTR char;
   %SPTR_CPTR=39;
   %declare SPTR_HANDICON char;
   %SPTR_HANDICON=SPTR_ICONERROR;
   %declare SPTR_QUESICON char;
   %SPTR_QUESICON=SPTR_ICONQUESTION;
   %declare SPTR_BANGICON char;
   %SPTR_BANGICON=SPTR_ICONWARNING;
   %declare SPTR_NOTEICON char;
   %SPTR_NOTEICON=SPTR_ICONINFORMATION;
   dcl WinLoadPointer entry (
          HWND,
          HMODULE,
          ULONG)
          returns(optional byvalue HPOINTER)
          APIENTRY;
   dcl WinCreatePointer entry (
          HWND,
          HBITMAP,
          BOOL,
          LONG,
          LONG)
          returns(optional byvalue HPOINTER)
          APIENTRY;
   dcl WinSetPointerPos entry (
          HWND,
          LONG,
          LONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinDestroyPointer entry (
          HPOINTER)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryPointer entry (
          HWND)
          returns(optional byvalue HPOINTER)
          APIENTRY;
   dcl WinQueryPointerPos entry (
          HWND,
          PPOINTL)
          returns(optional byvalue BOOL)
          APIENTRY;
   %declare POINTERINFO char;
   %POINTERINFO='char(stg(#POINTERINFO))';
   dcl 1 #POINTERINFO based(null()) unaligned,
         2 fPointer ULONG,
         2 xHotspot LONG,
         2 yHotspot LONG,
         2 hbmPointer HBITMAP,
         2 hbmColor HBITMAP,
         2 hbmMiniPointer HBITMAP,
         2 hbmMiniColor HBITMAP;
   %declare PPOINTERINFO char;
   %PPOINTERINFO='pointer';
   dcl WinCreatePointerIndirect entry (
          HWND,
          PPOINTERINFO)
          returns(optional byvalue HPOINTER)
          APIENTRY;
   dcl WinQueryPointerInfo entry (
          HPOINTER,
          PPOINTERINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinDrawPointer entry (
          HPS,
          LONG,
          LONG,
          HPOINTER,
          ULONG)
          returns(optional byvalue BOOL)
          APIENTRY;
   declare DP_NORMAL fixed bin(16) value('00_00'xn);
   declare DP_HALFTONED fixed bin(16) value('00_01'xn);
   declare DP_INVERTED fixed bin(16) value('00_02'xn);
   dcl WinGetSysBitmap entry (
          HWND,
          ULONG)
          returns(optional byvalue HBITMAP)
          APIENTRY;
   %declare SBMP_OLD_SYSMENU char;
   %SBMP_OLD_SYSMENU=1;
   %declare SBMP_OLD_SBUPARROW char;
   %SBMP_OLD_SBUPARROW=2;
   %declare SBMP_OLD_SBDNARROW char;
   %SBMP_OLD_SBDNARROW=3;
   %declare SBMP_OLD_SBRGARROW char;
   %SBMP_OLD_SBRGARROW=4;
   %declare SBMP_OLD_SBLFARROW char;
   %SBMP_OLD_SBLFARROW=5;
   %declare SBMP_MENUCHECK char;
   %SBMP_MENUCHECK=6;
   %declare SBMP_OLD_CHECKBOXES char;
   %SBMP_OLD_CHECKBOXES=7;
   %declare SBMP_BTNCORNERS char;
   %SBMP_BTNCORNERS=8;
   %declare SBMP_OLD_MINBUTTON char;
   %SBMP_OLD_MINBUTTON=9;
   %declare SBMP_OLD_MAXBUTTON char;
   %SBMP_OLD_MAXBUTTON=10;
   %declare SBMP_OLD_RESTOREBUTTON char;
   %SBMP_OLD_RESTOREBUTTON=11;
   %declare SBMP_OLD_CHILDSYSMENU char;
   %SBMP_OLD_CHILDSYSMENU=12;
   %declare SBMP_DRIVE char;
   %SBMP_DRIVE=15;
   %declare SBMP_FILE char;
   %SBMP_FILE=16;
   %declare SBMP_FOLDER char;
   %SBMP_FOLDER=17;
   %declare SBMP_TREEPLUS char;
   %SBMP_TREEPLUS=18;
   %declare SBMP_TREEMINUS char;
   %SBMP_TREEMINUS=19;
   %declare SBMP_PROGRAM char;
   %SBMP_PROGRAM=22;
   %declare SBMP_MENUATTACHED char;
   %SBMP_MENUATTACHED=23;
   %declare SBMP_SIZEBOX char;
   %SBMP_SIZEBOX=24;
   %declare SBMP_SYSMENU char;
   %SBMP_SYSMENU=25;
   %declare SBMP_MINBUTTON char;
   %SBMP_MINBUTTON=26;
   %declare SBMP_MAXBUTTON char;
   %SBMP_MAXBUTTON=27;
   %declare SBMP_RESTOREBUTTON char;
   %SBMP_RESTOREBUTTON=28;
   %declare SBMP_CHILDSYSMENU char;
   %SBMP_CHILDSYSMENU=29;
   %declare SBMP_SYSMENUDEP char;
   %SBMP_SYSMENUDEP=30;
   %declare SBMP_MINBUTTONDEP char;
   %SBMP_MINBUTTONDEP=31;
   %declare SBMP_MAXBUTTONDEP char;
   %SBMP_MAXBUTTONDEP=32;
   %declare SBMP_RESTOREBUTTONDEP char;
   %SBMP_RESTOREBUTTONDEP=33;
   %declare SBMP_CHILDSYSMENUDEP char;
   %SBMP_CHILDSYSMENUDEP=34;
   %declare SBMP_SBUPARROW char;
   %SBMP_SBUPARROW=35;
   %declare SBMP_SBDNARROW char;
   %SBMP_SBDNARROW=36;
   %declare SBMP_SBLFARROW char;
   %SBMP_SBLFARROW=37;
   %declare SBMP_SBRGARROW char;
   %SBMP_SBRGARROW=38;
   %declare SBMP_SBUPARROWDEP char;
   %SBMP_SBUPARROWDEP=39;
   %declare SBMP_SBDNARROWDEP char;
   %SBMP_SBDNARROWDEP=40;
   %declare SBMP_SBLFARROWDEP char;
   %SBMP_SBLFARROWDEP=41;
   %declare SBMP_SBRGARROWDEP char;
   %SBMP_SBRGARROWDEP=42;
   %declare SBMP_SBUPARROWDIS char;
   %SBMP_SBUPARROWDIS=43;
   %declare SBMP_SBDNARROWDIS char;
   %SBMP_SBDNARROWDIS=44;
   %declare SBMP_SBLFARROWDIS char;
   %SBMP_SBLFARROWDIS=45;
   %declare SBMP_SBRGARROWDIS char;
   %SBMP_SBRGARROWDIS=46;
   %declare SBMP_COMBODOWN char;
   %SBMP_COMBODOWN=47;
   %declare SBMP_CHECKBOXES char;
   %SBMP_CHECKBOXES=48;
 %end;
 %if INCL_WINHOOKS='Y' %then %do;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinSetHook entry (
            HAB,
            HMQ,
            LONG,
            PFN,
            HMODULE)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinReleaseHook entry (
            HAB,
            HMQ,
            LONG,
            PFN,
            HMODULE)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinCallMsgFilter entry (
            HAB,
            PQMSG,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     %declare HK_SENDMSG char;
     %HK_SENDMSG=0;
     %declare HK_INPUT char;
     %HK_INPUT=1;
     %declare HK_MSGFILTER char;
     %HK_MSGFILTER=2;
     %declare HK_JOURNALRECORD char;
     %HK_JOURNALRECORD=3;
     %declare HK_JOURNALPLAYBACK char;
     %HK_JOURNALPLAYBACK=4;
     %declare HK_HELP char;
     %HK_HELP=5;
     %declare HK_LOADER char;
     %HK_LOADER=6;
     %declare HK_REGISTERUSERMSG char;
     %HK_REGISTERUSERMSG=7;
     %declare HK_MSGCONTROL char;
     %HK_MSGCONTROL=8;
     %declare HK_PLIST_ENTRY char;
     %HK_PLIST_ENTRY=9;
     %declare HK_PLIST_EXIT char;
     %HK_PLIST_EXIT=10;
     %declare HK_FINDWORD char;
     %HK_FINDWORD=11;
     %declare HK_CODEPAGECHANGED char;
     %HK_CODEPAGECHANGED=12;
     %declare HK_WINDOWDC char;
     %HK_WINDOWDC=15;
     %declare HK_DESTROYWINDOW char;
     %HK_DESTROYWINDOW=16;
     %declare HK_CHECKMSGFILTER char;
     %HK_CHECKMSGFILTER=20;
     %declare HK_MSGINPUT char;
     %HK_MSGINPUT=21;
     %declare HK_LOCKUP char;
     %HK_LOCKUP=23;
     %declare HK_FLUSHBUF char;
     %HK_FLUSHBUF=24;
     %declare HMQ_CURRENT char;
     %HMQ_CURRENT=HMQ;
     %declare MSGF_DIALOGBOX char;
     %MSGF_DIALOGBOX=1;
     %declare MSGF_MESSAGEBOX char;
     %MSGF_MESSAGEBOX=2;
     %declare MSGF_TRACK char;
     %MSGF_TRACK=8;
     %declare MSGF_DDEPOSTMSG char;
     %MSGF_DDEPOSTMSG=3;
     %declare HLPM_FRAME char;
     %HLPM_FRAME=-1;
     %declare HLPM_WINDOW char;
     %HLPM_WINDOW=-2;
     %declare HLPM_MENU char;
     %HLPM_MENU=-3;
     %declare PM_MODEL_1X char;
     %PM_MODEL_1X=0;
     %declare PM_MODEL_2X char;
     %PM_MODEL_2X=1;
     %declare SMHSTRUCT char;
     %SMHSTRUCT='char(stg(#SMHSTRUCT))';
     dcl 1 #SMHSTRUCT based(null()) unaligned,
           2 mp2 MPARAM,
           2 mp1 MPARAM,
           2 msg ULONG,
           2 SHMSTRUCT_hwnd HWND,
           2 model ULONG;
     %declare PSMHSTRUCT char;
     %PSMHSTRUCT='pointer';
     %declare LHK_DELETEPROC char;
     %LHK_DELETEPROC=1;
     %declare LHK_DELETELIB char;
     %LHK_DELETELIB=2;
     %declare LHK_LOADPROC char;
     %LHK_LOADPROC=3;
     %declare LHK_LOADLIB char;
     %LHK_LOADLIB=4;
     %declare MCHK_MSGINTEREST char;
     %MCHK_MSGINTEREST=1;
     %declare MCHK_CLASSMSGINTEREST char;
     %MCHK_CLASSMSGINTEREST=2;
     %declare MCHK_SYNCHRONISATION char;
     %MCHK_SYNCHRONISATION=3;
     %declare MCHK_MSGMODE char;
     %MCHK_MSGMODE=4;
     %declare RUMHK_DATATYPE char;
     %RUMHK_DATATYPE=1;
     %declare RUMHK_MSG char;
     %RUMHK_MSG=2;
   %end;
 %end;
 %if INCL_WINTHUNKAPI='Y' %then %do;
   dcl WinSetClassThunkProc entry (
          PSZ,
          PFN)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryClassThunkProc entry (
          PSZ)
          returns(optional byvalue PFN)
          APIENTRY;
   dcl WinSetWindowThunkProc entry (
          HWND,
          PFN)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinQueryWindowThunkProc entry (
          HWND)
          returns(optional byvalue PFN)
          APIENTRY;
   dcl WinQueryWindowModel entry (
          HWND)
          returns(optional byvalue LONG)
          APIENTRY;
 %end;
 %if INCL_SAADEFS='Y' %then %do;
   %include pmshl;
 %end;
 %if INCL_WINCOUNTRY='Y' %then %do;
   dcl WinQueryCp entry (
          HMQ)
          returns(optional byvalue ULONG)
          APIENTRY;
   %if INCL_SAADEFS='Y' %then %do;
     dcl WinSetCp entry (
            HMQ,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinQueryCpList entry (
            HAB,
            ULONG,
            PULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinCpTranslateString entry (
            HAB,
            ULONG,
            PSZ,
            ULONG,
            ULONG,
            PSZ)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinCpTranslateChar entry (
            HAB,
            ULONG,
            UCHAR,
            ULONG)
            returns(optional byvalue UCHAR)
            APIENTRY;
     dcl WinUpper entry (
            HAB,
            ULONG,
            ULONG,
            PSZ)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinUpperChar entry (
            HAB,
            ULONG,
            ULONG,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinNextChar entry (
            HAB,
            ULONG,
            ULONG,
            PSZ)
            returns(optional byvalue PSZ)
            APIENTRY;
     dcl WinPrevChar entry (
            HAB,
            ULONG,
            ULONG,
            PSZ,
            PSZ)
            returns(optional byvalue PSZ)
            APIENTRY;
     dcl WinCompareStrings entry (
            HAB,
            ULONG,
            ULONG,
            PSZ,
            PSZ,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
     %declare WCS_ERROR char;
     %WCS_ERROR=0;
     %declare WCS_EQ char;
     %WCS_EQ=1;
     %declare WCS_LT char;
     %WCS_LT=2;
     %declare WCS_GT char;
     %WCS_GT=3;
   %end;
 %end;
 %if INCL_WINHEAP='Y' %then %do;
 %end;
 %if INCL_WINATOM='Y' %then %do;
   %if INCL_SAADEFS='Y' %then %do;
     %declare HATOMTBL char;
     %HATOMTBL=LHANDLE;
     %declare ATOM char;
     %ATOM=ULONG;
     dcl WinQuerySystemAtomTable entry
            returns(optional byvalue HATOMTBL)
            APIENTRY;
     dcl WinCreateAtomTable entry (
            ULONG,
            ULONG)
            returns(optional byvalue HATOMTBL)
            APIENTRY;
     dcl WinDestroyAtomTable entry (
            HATOMTBL)
            returns(optional byvalue HATOMTBL)
            APIENTRY;
     dcl WinAddAtom entry (
            HATOMTBL,
            PSZ)
            returns(optional byvalue ATOM)
            APIENTRY;
     dcl WinFindAtom entry (
            HATOMTBL,
            PSZ)
            returns(optional byvalue ATOM)
            APIENTRY;
     dcl WinDeleteAtom entry (
            HATOMTBL,
            ATOM)
            returns(optional byvalue ATOM)
            APIENTRY;
     dcl WinQueryAtomUsage entry (
            HATOMTBL,
            ATOM)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinQueryAtomLength entry (
            HATOMTBL,
            ATOM)
            returns(optional byvalue ULONG)
            APIENTRY;
     dcl WinQueryAtomName entry (
            HATOMTBL,
            ATOM,
            PSZ,
            ULONG)
            returns(optional byvalue ULONG)
            APIENTRY;
   %end;
 %end;
 %if INCL_WINERRORS='Y' %then %do;
   %include pmerr;
   declare WINDBG_HWND_NOT_DESTROYED fixed bin(16) value('10_22'xn);
   declare WINDBG_HPTR_NOT_DESTROYED fixed bin(16) value('10_23'xn);
   declare WINDBG_HACCEL_NOT_DESTROYED fixed bin(16) value('10_24'xn);
   declare WINDBG_HENUM_NOT_DESTROYED fixed bin(16) value('10_25'xn);
   declare WINDBG_VISRGN_SEM_BUSY fixed bin(16) value('10_26'xn);
   declare WINDBG_USER_SEM_BUSY fixed bin(16) value('10_27'xn);
   declare WINDBG_DC_CACHE_BUSY fixed bin(16) value('10_28'xn);
   declare WINDBG_HOOK_STILL_INSTALLED fixed bin(16) value('10_29'xn);
   declare WINDBG_WINDOW_STILL_LOCKED fixed bin(16) value('10_2A'xn);
   declare WINDBG_UPDATEPS_ASSERTION_FAIL fixed bin(16)
                                          value('10_2B'xn);
   declare WINDBG_SENDMSG_WITHIN_USER_SEM fixed bin(16)
                                          value('10_2C'xn);
   declare WINDBG_USER_SEM_NOT_ENTERED fixed bin(16) value('10_2D'xn);
   declare WINDBG_PROC_NOT_EXPORTED fixed bin(16) value('10_2E'xn);
   declare WINDBG_BAD_SENDMSG_HWND fixed bin(16) value('10_2F'xn);
   declare WINDBG_ABNORMAL_EXIT fixed bin(16) value('10_30'xn);
   declare WINDBG_INTERNAL_REVISION fixed bin(16) value('10_31'xn);
   declare WINDBG_INITSYSTEM_FAILED fixed bin(16) value('10_32'xn);
   declare WINDBG_HATOMTBL_NOT_DESTROYED fixed bin(16) value('10_33'xn);
   declare WINDBG_WINDOW_UNLOCK_WAIT fixed bin(16) value('10_35'xn);
   %declare ERRINFO char;
   %ERRINFO='char(stg(#ERRINFO))';
   dcl 1 #ERRINFO based(null()) unaligned,
         2 cbFixedErrInfo ULONG,
         2 idError ERRORID,
         2 cDetailLevel ULONG,
         2 offaoffszMsg ULONG,
         2 offBinaryData ULONG;
   %declare PERRINFO char;
   %PERRINFO='pointer';
   dcl WinGetLastError entry (
          HAB)
          returns(optional byvalue ERRORID)
          APIENTRY;
   dcl WinGetErrorInfo entry (
          HAB)
          returns(optional byvalue PERRINFO)
          APIENTRY;
   dcl WinFreeErrorInfo entry (
          PERRINFO)
          returns(optional byvalue BOOL)
          APIENTRY;
 %end;
 %if INCL_SAADEFS='Y' %then %do;
   %if INCL_WINSEI='Y' %then %do;
     %if SEI_PMWINP='Y' %then %do;
       %SEI_PMWIN='Y';
       %include pmsei;
     %end;
   %end;
 %end;
 %if INCL_SAADEFS='Y' %then %do;
   %if INCL_WINDDE='Y' %then %do;
     %declare SZDDESYS_TOPIC char;
     %SZDDESYS_TOPIC='''System''';
     %declare SZDDESYS_ITEM_TOPICS char;
     %SZDDESYS_ITEM_TOPICS='''Topics''';
     %declare SZDDESYS_ITEM_SYSITEMS char;
     %SZDDESYS_ITEM_SYSITEMS='''SysItems''';
     %declare SZDDESYS_ITEM_RTNMSG char;
     %SZDDESYS_ITEM_RTNMSG='''ReturnMessage''';
     %declare SZDDESYS_ITEM_STATUS char;
     %SZDDESYS_ITEM_STATUS='''Status''';
     %declare SZDDESYS_ITEM_FORMATS char;
     %SZDDESYS_ITEM_FORMATS='''Formats''';
     %declare SZDDESYS_ITEM_SECURITY char;
     %SZDDESYS_ITEM_SECURITY='''Security''';
     %declare SZDDESYS_ITEM_ITEMFORMATS char;
     %SZDDESYS_ITEM_ITEMFORMATS='''ItemFormats''';
     %declare SZDDESYS_ITEM_HELP char;
     %SZDDESYS_ITEM_HELP='''Help''';
     %declare SZDDESYS_ITEM_PROTOCOLS char;
     %SZDDESYS_ITEM_PROTOCOLS='''Protocols''';
     %declare SZDDESYS_ITEM_RESTART char;
     %SZDDESYS_ITEM_RESTART='''Restart''';
     %declare CONVCONTEXT char;
     %CONVCONTEXT='char(stg(#CONVCONTEXT))';
     dcl 1 #CONVCONTEXT based(null()) unaligned,
           2 cb ULONG,
           2 fsContext ULONG,
           2 idCountry ULONG,
           2 usCodepage ULONG,
           2 usLangID ULONG,
           2 usSubLangID ULONG;
     %declare PCONVCONTEXT char;
     %PCONVCONTEXT='pointer';
     %declare DDECTXT_CASESENSITIVE char;
     %DDECTXT_CASESENSITIVE=1;
     %declare DDEINIT char;
     %DDEINIT='char(stg(#DDEINIT))';
     dcl 1 #DDEINIT based(null()) unaligned,
           2 cb ULONG,
           2 pszAppName PSZ,
           2 pszTopic PSZ,
           2 offConvContext ULONG;
     %declare PDDEINIT char;
     %PDDEINIT='pointer';
     %declare DDESTRUCT char;
     %DDESTRUCT='char(stg(#DDESTRUCT))';
     dcl 1 #DDESTRUCT based(null()) unaligned,
           2 cbData ULONG,
           2 fsStatus USHORT,
           2 usFormat USHORT,
           2 offszItemName USHORT,
           2 offabData USHORT;
     %declare PDDESTRUCT char;
     %PDDESTRUCT='pointer';
     declare DDE_FACK fixed bin(16) value('00_01'xn);
     declare DDE_FBUSY fixed bin(16) value('00_02'xn);
     declare DDE_FNODATA fixed bin(16) value('00_04'xn);
     declare DDE_FACKREQ fixed bin(16) value('00_08'xn);
     declare DDE_FRESPONSE fixed bin(16) value('00_10'xn);
     declare DDE_NOTPROCESSED fixed bin(16) value('00_20'xn);
     declare DDE_FRESERVED fixed bin(16) value('00_C0'xn);
     declare DDE_FAPPSTATUS fixed bin(16) value('FF_FF'xn);
     declare DDEFMT_TEXT fixed bin(16) value('00_01'xn);
     dcl WinDdeInitiate entry (
            HWND,
            PSZ,
            PSZ,
            PCONVCONTEXT)
            returns(optional byvalue BOOL)
            APIENTRY;
     dcl WinDdeRespond entry (
            HWND,
            HWND,
            PSZ,
            PSZ,
            PCONVCONTEXT)
            returns(optional byvalue MRESULT)
            APIENTRY;
     dcl WinDdePostMsg entry (
            HWND,
            HWND,
            ULONG,
            PDDESTRUCT,
            ULONG)
            returns(optional byvalue BOOL)
            APIENTRY;
     declare DDEPM_RETRY fixed bin(31) value('00_00_00_01'xn);
     declare DDEPM_NOFREE fixed bin(31) value('00_00_00_02'xn);
     declare WM_DDE_FIRST fixed bin(16) value('00_A0'xn);
     declare WM_DDE_INITIATE fixed bin(16) value('00_A0'xn);
     declare WM_DDE_REQUEST fixed bin(16) value('00_A1'xn);
     declare WM_DDE_ACK fixed bin(16) value('00_A2'xn);
     declare WM_DDE_DATA fixed bin(16) value('00_A3'xn);
     declare WM_DDE_ADVISE fixed bin(16) value('00_A4'xn);
     declare WM_DDE_UNADVISE fixed bin(16) value('00_A5'xn);
     declare WM_DDE_POKE fixed bin(16) value('00_A6'xn);
     declare WM_DDE_EXECUTE fixed bin(16) value('00_A7'xn);
     declare WM_DDE_TERMINATE fixed bin(16) value('00_A8'xn);
     declare WM_DDE_INITIATEACK fixed bin(16) value('00_A9'xn);
     declare WM_DDE_LAST fixed bin(16) value('00_AF'xn);

             /*DDE helper macros */
     %dcl DDES_PSZITEMNAME entry;
     %DDES_PSZITEMNAME:PROC (pddes);
      dcl (pddes, outstr) char;
      outstr = '('||pddes||') + ('||pddes||'->offszItemName)';
      ans (outstr);
     %end;
     %dcl DDES_PABDATA entry;
     %DDES_PABDATA:PROC (pddes);
      dcl (pddes, outstr) char;
      outstr = '('||pddes||') + ('||pddes||'->offabData)';
      ans (outstr);
     %end;
     %dcl DDEI_PCONVCONTEXT entry;
     %DDEI_PCONVCONTEXT:PROC (pddei);
      dcl (pddei, outstr) char;
      outstr = '('||pddei||') + ('||pddei||'->offConvContext)';
      ans (outstr);
     %end;

   %end;
 %end;
 %if INCL_WINWINDOWMGR='Y' %then %do;
   declare WM_QUERYCONVERTPOS fixed bin(16) value('00_B0'xn);
   declare QCP_CONVERT fixed bin(16) value('00_01'xn);
   declare QCP_NOCONVERT fixed bin(16) value('00_00'xn);
 %end;
 %if INCL_WINHELP='Y' %then %do;
   %include pmhelp;
 %end;
 %declare HLIB char;
 %HLIB=HMODULE;
 %declare PHLIB char;
 %PHLIB=PHMODULE;
 %if INCL_WINLOAD='Y' %then %do;
   dcl WinDeleteProcedure entry (
          HAB,
          PFNWP)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinDeleteLibrary entry (
          HAB,
          HLIB)
          returns(optional byvalue BOOL)
          APIENTRY;
   dcl WinLoadProcedure entry (
          HAB,
          HLIB,
          PSZ)
          returns(optional byvalue PFNWP)
          APIENTRY;
   dcl WinLoadLibrary entry (
          HAB,
          PSZ)
          returns(optional byvalue HLIB)
          APIENTRY;
 %end;
 %if INCL_SAADEFS='Y' %then %do;
   %if INCL_WINDESKTOP='Y' %then %do;
     %declare DESKTOP char;
     %DESKTOP='char(stg(#DESKTOP))';
     dcl 1 #DESKTOP based(null()) unaligned,
           2 cbSize ULONG,
           2 hbm HBITMAP,
           2 x LONG,
           2 y LONG,
           2 fl ULONG,
           2 lTileCount LONG,
           2 szFile char(260-1) varz;
     %declare PDESKTOP char;
     %PDESKTOP='pointer';
     dcl WinSetDesktopBkgnd entry (
            HWND,
            PDESKTOP)
            returns(optional byvalue HBITMAP)
            APIENTRY;
     dcl WinQueryDesktopBkgnd entry (
            HWND,
            PDESKTOP)
            returns(optional byvalue BOOL)
            APIENTRY;
     declare SDT_DESTROY fixed bin(31) value('00_00_00_01'xn);
     declare SDT_NOBKGND fixed bin(31) value('00_00_00_02'xn);
     declare SDT_TILE fixed bin(31) value('00_00_00_04'xn);
     declare SDT_SCALE fixed bin(31) value('00_00_00_08'xn);
     declare SDT_PATTERN fixed bin(31) value('00_00_00_10'xn);
     declare SDT_CENTER fixed bin(31) value('00_00_00_20'xn);
     declare SDT_RETAIN fixed bin(31) value('00_00_00_40'xn);
     declare SDT_LOADFILE fixed bin(31) value('00_00_00_80'xn);
   %end;
 %end;
 %if INCL_SAADEFS='Y' %then %do;
   %if INCL_WINPALETTE='Y' %then %do;
     dcl WinRealizePalette entry (
            HWND,
            HPS,
            PULONG)
            returns(optional byvalue LONG)
            APIENTRY;
   %end;
 %end;
 %if INCL_REMAPDLL='Y' %then %do;
   %declare STR_DLLNAME char;
   %STR_DLLNAME='''keyremap''';
 %end;
 %if INCL_NLS='Y' %then %do;
   declare WM_DBCSFIRST fixed bin(16) value('00_B0'xn);
   declare WM_DBCSLAST fixed bin(16) value('00_CF'xn);
   %include os2nls;
 %end;
 %if IBMC__='Y' %then %do;
   %if CHKHDR__='Y' %then %do;
   %end;
 %end;


 MpFromP:
   proc( p )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl p pointer;
   return( p );
 end;

 MpFromHwnd:
   proc( h )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl h pointer;
   return( h );
 end;

 MpFromChar:
   proc( c )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl c unsigned fixed bin(8);
   dcl ptrvalue builtin;
   return( ptrvalue(c) );
 end;

 MpFromShort:
   proc( s )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl s fixed bin(15);
   dcl ptrvalue builtin;
   return( ptrvalue(s) );
 end;

 MpFrom2Short:
   proc( s1, s2 )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl s1 unsigned fixed bin(16);
   dcl s2 unsigned fixed bin(16);
   dcl ptrvalue builtin;
   return( ptrvalue(makeLong(s1,s2)) );
 end;


 Ulong_Cast:
   proc( s1 )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(31) );
   dcl s1 signed fixed bin(31);
   dcl s2 unsigned fixed bin(31) based( addr(s1) );
   return( s2 );
 end;


 Ushort_Cast:
   proc( s1 )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl s1 signed fixed bin(15);
   dcl s2 unsigned fixed bin(16) based( addr(s1) );
   return( s2 );
 end;


 MpFrom2Sh2Ch:
   proc( s, uch1, uch2 )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl s unsigned fixed bin(16);
   dcl uch1 unsigned fixed bin(8);
   dcl uch2 unsigned fixed bin(8);
   dcl ptrvalue builtin;
   return( ptrvalue(makeLong(s,makeshort(uch1,uch2))) );
 end;

 MpFromLong:
   proc( l )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl l fixed bin(31);
   dcl ptrvalue builtin;
   return( ptrvalue(l) );
 end;

 PvoidFromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl mp pointer;
   return( mp );
 end;

 HwndFromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl mp pointer;
   return( mp );
 end;

 (nosize):
 Char1FromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(8) );
   dcl mp pointer;
   dcl binvalue builtin;
   return( binvalue(mp) );
 end;

 (nosize):
 Char2FromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(8) );
   dcl mp pointer;
   dcl binvalue builtin;
   dcl isrl     builtin;
   return( isrl(binvalue(mp),8) );
 end;

 (nosize):
 Char3FromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(8) );
   dcl mp pointer;
   dcl binvalue builtin;
   dcl isrl     builtin;
   return( isrl(binvalue(mp),16) );
 end;

 (nosize):
 Char4FromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(8) );
   dcl mp pointer;
   dcl binvalue builtin;
   dcl isrl     builtin;
   return( isrl(binvalue(mp),24) );
 end;

 (nosize):
 Short1FromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl mp pointer;
   dcl binvalue builtin;
   return( binvalue(mp) );
 end;

 (nosize):
 Short2FromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl mp pointer;
   dcl binvalue builtin;
   dcl isrl     builtin;
   return( isrl(binvalue(mp),16) );
 end;

 LongFromMp:
   proc( mp )
   options( byvalue inline )
   returns( byvalue fixed bin(31) );
   dcl mp pointer;
   dcl binvalue builtin;
   return( binvalue(mp) );
 end;

 MrFromP:
   proc( p )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl p pointer;
   return( p );
 end;

 MrFromShort:
   proc( s )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl s unsigned fixed bin(16);
   dcl ptrvalue builtin;
   return( ptrvalue(s) );
 end;

 MrFrom2Short:
   proc( s1, s2 )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl s1 unsigned fixed bin(16);
   dcl s2 unsigned fixed bin(16);
   dcl ptrvalue builtin;
   return( ptrvalue(makelong(s1,s2)) );
 end;

 MrFromLong:
   proc( l )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl l fixed bin(31);
   dcl ptrvalue builtin;
   return( ptrvalue(l) );
 end;

 PvoidFromMr:
   proc( mr )
   options( byvalue inline )
   returns( byvalue pointer );
   dcl mr pointer;
   return( mr );
 end;

 (nosize):
 Short1FromMr:
   proc( mr )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl mr pointer;
   dcl binvalue builtin;
   return( binvalue(mr) );
 end;

 (nosize):
 Short2FromMr:
   proc( mr )
   options( byvalue inline )
   returns( byvalue unsigned fixed bin(16) );
   dcl mr pointer;
   dcl isrl     builtin;
   dcl binvalue builtin;
   return( isrl(binvalue(mr),16) );
 end;

 LongFromMr:
   proc( mr )
   options( byvalue inline )
   returns( byvalue fixed bin(31) );
   dcl mr pointer;
   dcl binvalue builtin;
   return( binvalue(mr) );
 end;


 %if INCL_WINMENUS = 'Y' %then %do;
 WinCheckMenuItem:
   proc(hwndMenu, id, fcheck)
   returns( BOOL )
   options( inline byvalue ) internal;

   dcl hwndMenu fixed bin(31) unsigned;
   dcl id fixed bin(16) unsigned;
   dcl fcheck fixed bin(16) unsigned;
   dcl checkval fixed bin(16) unsigned;

   if fcheck = 0 then
     checkval = 0;
   else
     checkval = MIA_CHECKED;

   return( WinSendMsg( hwndMenu,
                       MM_SETITEMATTR,
                       MPFROM2SHORT(id, TRUE),
                       MPFROM2SHORT( MIA_CHECKED,
                                     checkval    ) ) );
 end;


 WinIsMenuItemChecked:
   proc(hwndMenu, id)
   returns( BOOL )
   options( inline byvalue ) internal;

   dcl hwndMenu fixed bin(31) unsigned;
   dcl id fixed bin(16) unsigned;

   return( WinSendMsg( hwndMenu,
                       MM_QueryItemAttr,
                       MPFROM2SHORT(id, TRUE),
                       MPFROMLONG(MIA_CHECKED) ) );
 end;


 WinEnableMenuItem:
   proc(hwndMenu, id, fenable)
   returns( BOOL )
   options( inline byvalue ) internal;

   dcl hwndMenu fixed bin(31) unsigned;
   dcl id fixed bin(16) unsigned;
   dcl fenable fixed bin(16) unsigned;
   dcl checkval fixed bin(16) unsigned;

   if fenable = 0 then
     checkval = MIA_Disabled;
   else
     checkval = 0;

   return( WinSendMsg( hwndMenu,
                       MM_SETITEMATTR,
                       MPFROM2SHORT(id, TRUE),
                       MPFROM2SHORT( MIA_DISABLED,
                                     checkval    ) ) );
 end;


 WinIsMenuItemEnabled:
   proc(hwndMenu, id)
   returns( BOOL )
   options( inline byvalue ) internal;

   dcl hwndMenu fixed bin(31) unsigned;
   dcl id fixed bin(16) unsigned;

   return( WinSendMsg( hwndMenu,
                       MM_QueryItemAttr,
                       MPFROM2SHORT(id, TRUE),
                       MPFROMLONG(MIA_DISABLED) ) );
 end;


 WinSetMenuItemText:
   proc(hwndMenu, id, psz)
   returns( BOOL )
   options( inline byvalue ) internal;

   dcl hwndMenu fixed bin(31) unsigned;
   dcl id fixed bin(16) unsigned;
   dcl psz pointer;

   return( WinSendMsg( hwndMenu,
                       MM_SetItemText,
                       MPFROMLONG(id),
                       MPFROMP(psz) ) );
 end;


 WinIsMenuItemValid:
   proc(hwndMenu, id)
   returns( BOOL )
   options( inline byvalue ) internal;

   dcl hwndMenu fixed bin(31) unsigned;
   dcl id fixed bin(16) unsigned;

   return( WinSendMsg( hwndMenu,
                       MM_IsItemValid,
                       MPFROM2SHORT(id, TRUE),
                       MPFROMLONG(FALSE) ) );
 end;


 %end;
