 /*********************************************************/
 /*  CREATED BY C2PLI CONVERSION UTILITY                  */
 /*********************************************************/
 /********************************************************************/
 /*                                                                  */
 /*  PL/I Include file: SQLUTIL.CPY                                  */
 /*                                                                  */
 /*    This file is installed in the \IBMPLI\INCLUDE\ directory.     */
 /*                                                                  */
 /*                                                                  */
 /*  NAME - SQLUTIL.CPY                                              */
 /*                                                                  */
 /*  DESCRIPTION                                                     */
 /*                                                                  */
 /*    This include file is translated into a PL/I include file,     */
 /*    from the C header files supplied with the                     */
 /*    IBM DATABASE 2 SOFTWARE DEVELOPERS KIT/2  product.            */
 /*    This include file is intended for use with the                */
 /*    IBM DATABASE 2 SOFTWARE DEVELOPERS KIT/2 product.             */
 /*                                                                  */
 /*                                                                  */
 /*    (C) Copyright IBM Corp. 1994, 1996. All Rights Reserved.      */
 /*    US Government Users Restricted Rights-- Use, duplication or   */
 /*    disclosure restricted by GSA ADP Schedule Contract with       */
 /*    IBM Corp.                                                     */
 /*    Licensed Materials - Property of IBM                          */
 /*                                                                  */
 /*  Function =                                                      */
 /*        Include File defining:                                    */
 /*          Utility / Configuration Commands - Constants            */
 /*          Utility / Configuration Commands - Data Structures      */
 /*          Utility / Configuration Commands - Function Prototypes  */
 /*          Utility / Configuration Commands - Labels for SQLCODES  */
 /*                                                                  */
 /*                                                                  */
 /*  Operating System = OS/2                                         */
 /*                                                                  */
 /*                                                                  */
 /*  DISCLAIMER OF WARRANTIES                                        */
 /*    The following enclosed code is sample code created by IBM   */
 /*    Corporation. This sample code is not part of any standard     */
 /*    IBM product and is provided to you solely for the purpose of  */
 /*    assisting you in the development of your applications.  The   */
 /*    code is provided "AS IS", without warranty of any kind.       */
 /*    IBM shall not be liable for any damages arising out of your   */
 /*    use of the sample code, even if IBM has been advised of the   */
 /*    possibility of such damages.                                  */
 /*                                                                  */
 /********************************************************************/
 %dcl SQL_H_SQLUTIL char ext;
 %if SQL_H_SQLUTIL = '' %then
  %do;
    %dcl SQL_H_SQLUTIL char ext;
    %SQL_H_SQLUTIL = 'Y';



 /* Includes sqlca.h & sqlsystm.h */
 /* %include sql;  */


 /* Interface Parameters/Structures/Return Codes */

 /* Parameters for Rollforward caller action */
                              /* Roll forward to requested point     */
    dcl SQLUM_ROLLFWD fixed bin(31) value(1);
                              /* End roll-forward recovery           */
    dcl SQLUM_STOP fixed bin(31) value(2);
                              /* Roll forward to requested point     */
                              /* and end roll-forward recovery       */
    dcl SQLUM_ROLLFWD_STOP fixed bin(31) value(3);
                              /* Query nextArcFile, firstDeleteArc,  */
                              /* lastDeleteArc, lastCommitTime       */
    dcl SQLUM_QUERY fixed bin(31) value(4);
                              /* Parameter check                     */
    dcl SQLUM_PARM_CHECK fixed bin(31) value(10);
                              /* Continue load recovery.             */
    dcl SQLUM_LOADREC_CONTINUE fixed bin(31) value(11);
                              /* Terminate load recovery.            */
    dcl SQLUM_LOADREC_TERMINATE fixed bin(31) value(12);
  /* Terminate device.Caller action   */
                              /* codes 31 - 35 reserved for          */
                              /* internal use.                       */
    dcl SQLUM_LOADREC_DEVICE_TERMINATE fixed bin(31) value(13);

 /* Constants used for Rollforward */
    %dcl SQLUM_INFINITY_TIMESTAMP char ext;
                                                     /* Roll         */
                              /* forward until STOP specified        */
    %SQLUM_INFINITY_TIMESTAMP = '"9999-12-31-23.59.59.999999"';
                              /* Length of Archive File name         */
    dcl SQLUM_ARCHIVE_FILE_LEN fixed bin(31) value(12);
                              /* Length of ISO format Timestamp      */
    dcl SQLUM_TIMESTAMP_LEN fixed bin(31) value(26);

 /* Rollforward connect mode       */
                              /* Offline rollforward mode            */
    dcl SQLUM_OFFLINE fixed bin(15) value('0'xn);
                              /* Online rollforward mode             */
    dcl SQLUM_ONLINE fixed bin(15) value('1'xn);

 /* Backup backup mode        */
                              /* Offline backup mode                 */
    dcl SQLUB_OFFLINE fixed bin(15) value('0'xn);
                              /* Online backup mode                  */
    dcl SQLUB_ONLINE fixed bin(15) value('1'xn);

 /* Backup type               */
    dcl SQLUB_FULL fixed bin(31) value(0);
    dcl SQLUB_TABLESPACE fixed bin(31) value(3);

 /* Backup calling action values  */
                              /* initial call                        */
    dcl SQLUB_BACKUP fixed bin(31) value(0);
                              /* Subsequent call                     */
    dcl SQLUB_CONTINUE fixed bin(31) value(1);
                              /* Terminating call                    */
    dcl SQLUB_TERMINATE fixed bin(31) value(2);
                              /* Initial call to run without         */
                              /* prompting                           */
    dcl SQLUB_NOINTERRUPT fixed bin(31) value(3);
                              /* End media device.                   */
    dcl SQLUB_DEVICE_TERMINATE fixed bin(31) value(9);
                              /* for parameter check only.           */
    dcl SQLUB_PARM_CHECK fixed bin(31) value(10);

 /* Restore mode                  */
    dcl SQLUD_ROLLFWD fixed bin(15) value('0'xn);
    dcl SQLUD_NOROLLFWD fixed bin(15) value('1'xn);

 /* Restore calling action values */
                              /* initial call                        */
    dcl SQLUD_RESTORE fixed bin(31) value(0);
                              /* Subsequent call                     */
    dcl SQLUD_CONTINUE fixed bin(31) value(1);
                              /* Terminating call                    */
    dcl SQLUD_TERMINATE fixed bin(31) value(2);
                              /* Initial call to run without         */
                              /* prompting                           */
    dcl SQLUD_NOINTERRUPT fixed bin(31) value(3);
                              /* End media device.                   */
    dcl SQLUD_DEVICE_TERMINATE fixed bin(31) value(9);
                              /* for parameter check only.           */
    dcl SQLUD_PARM_CHECK fixed bin(31) value(10);
                              /* initial call, tablespace container  */
                              /* redefinition requested              */
    dcl SQLUD_RESTORE_STORDEF fixed bin(31) value(100);
                              /* initial call, tablespace container  */
                              /* redefinition requested without      */
                              /* prompting                           */
    dcl SQLUD_STORDEF_NOINTERRUPT fixed bin(31) value(101);

 /* Restore type */
    dcl SQLUD_FULL fixed bin(31) value(0);
    dcl SQLUD_ONLINE_TABLESPACE fixed bin(31) value(3);
    dcl SQLUD_HISTORY fixed bin(31) value(5);
 /* The following are not supported in V2.1.0 */
    dcl SQLUD_TABLESPACE_TBL fixed bin(31) value(6);
    dcl SQLUD_HIST_TBLSPACE_TBL fixed bin(31) value(7);

 /* Backup/Restore Definitions                */
                              /* length of database alias name       */
    dcl SQLU_ALIAS_SZ fixed bin(31) value(8);
                              /* length of userid                    */
    dcl SQLU_USERID_LEN fixed bin(31) value(8);
                              /* length of password                  */
    dcl SQLU_PWD_LEN fixed bin(31) value(8);
                              /* length of the backup timestamp in   */
                              /* yyyymmddhhmmss format               */
    dcl SQLU_TIME_STAMP_LEN fixed bin(31) value(14);

 /* length of filename of backup image:   */
 /* dbalias.type.db2instance.node.timestamp.seq */
 %dcl SQLU_BACKUP_NAME_SZ char ext;
 %SQLU_BACKUP_NAME_SZ = 'SQLU_ALIAS_SZ+5+SQLU_USERID_LEN+5+SQLU_TIME_ST
 AMP_LEN+4';

 /* length of directory where backup file will  */
 /* reside:dir - '/' - filename     */
 %dcl SQLU_BACKUP_DIR_SZ char ext;
 %SQLU_BACKUP_DIR_SZ = '1023-1-SQLU_BACKUP_NAME_SZ';

 /* Parameters for Backup/Restore old api's  */
                              /* User exit used, not SD interface    */
    dcl SQLU_NSD_ID char value('0');

 /* Media type for old api's                 */
    dcl SQLUB_MEDIA_TARGET fixed bin(15) value('0'xn);
    dcl SQLUB_ADSM fixed bin(15) value('1'xn);
    dcl SQLUB_OTHER fixed bin(15) value('2'xn);

 /* Old OS/2 Backup/restore media type values  */
    dcl SQLUD_MEDIA_SRC fixed bin(15) value('0'xn);
    dcl SQLUD_ADSM fixed bin(15) value('1'xn);
    dcl SQLUD_OTHER fixed bin(15) value('2'xn);

 /* Parameters for SQLUHPRN force option       */
    dcl SQLUH_NO_FORCE fixed bin(31) value(0);
    dcl SQLUH_FORCE fixed bin(31) value(1);

 /* Parameters for SQLUHOPS caller action      */
    dcl SQLUH_LIST_BACKUP fixed bin(31) value(0);
    dcl SQLUH_LIST_HISTORY fixed bin(31) value(1);

 /* History File structure sizes               */
    dcl SQLUH_OP_SZ fixed bin(31) value(1);
    dcl SQLUH_OBJ_SZ fixed bin(31) value(1);
    dcl SQLUH_OBJPART_SZ fixed bin(31) value(17);
    dcl SQLUH_OPTYPE_SZ fixed bin(31) value(1);
    dcl SQLUH_DEVTYPE_SZ fixed bin(31) value(1);
    dcl SQLUH_FIRSTLOG_SZ fixed bin(31) value(12);
    dcl SQLUH_LASTLOG_SZ fixed bin(31) value(12);
    dcl SQLUH_BACKID_SZ fixed bin(31) value(14);
    dcl SQLUH_TCREATE_SZ fixed bin(31) value(8);
    dcl SQLUH_TNAME_SZ fixed bin(31) value(18);
    dcl SQLUH_NUMTABLESPACE_SZ fixed bin(31) value(5);
    dcl SQLUH_LOC_SZ fixed bin(31) value(255);
    dcl SQLUH_COMMENT_SZ fixed bin(31) value(30);
    dcl SQLUH_TABLESPACENAME_SZ fixed bin(31) value(18);

 /* Parameters for RUNSTATS                    */
                              /* TABLEOPT = Table w/o Indexes        */
    dcl SQL_STATS_TABLE char value('T');
                              /* TABLEOPT = Table and Indexes        */
    dcl SQL_STATS_BOTH char value('B');
                              /* TABLEOPT = Indexes w/o Table        */
    dcl SQL_STATS_INDEX char value('I');
                              /* TABLEOPT = Table and dist stats     */
    dcl SQL_STATS_EXTTABLE_ONLY char value('D');
                              /* TABLEOPT = Table and dist stats     */
                              /* and basic indexes                   */
    dcl SQL_STATS_EXTTABLE_INDEX char value('E');
                              /* TABLEOPT = Ext stats for indexes    */
                              /* only                                */
    dcl SQL_STATS_EXTINDEX_ONLY char value('X');
                              /* TABLEOPT = Ext stats for indexes    */
                              /* and basic table stats               */
    dcl SQL_STATS_EXTINDEX_TABLE char value('Y');
                              /* TABLEOPT = Ext stats for indexes    */
                              /* and table with dist stats           */
    dcl SQL_STATS_ALL char value('A');
                              /* SHAREOPT = Reference                */
    dcl SQL_STATS_REF char value('R');
                              /* SHAREOPT = Change                   */
    dcl SQL_STATS_CHG char value('C');

                              /* TABLEOPT - no statistics are to be  */
                              /* gathered - Load only                */
    dcl SQLU_STATS_NONE char value(' ');

 /* Parameters for selection method in sqldcol  */
                              /* Names                               */
    dcl SQL_METH_N fixed bin(31) value(78);
                              /* Positional                          */
    dcl SQL_METH_P fixed bin(31) value(80);
                              /* Default                             */
    dcl SQL_METH_D fixed bin(31) value(68);
                              /* Locations                           */
    dcl SQL_METH_L fixed bin(31) value(76);

                      /* File Types for Import/Export                */
                              /* load/unload                         */
    dcl SQL_IXF char value("IXF");
    dcl SQL_WSF char value("WSF");
    dcl SQL_DEL char value("DEL");
    dcl SQL_ASC char value("ASC");
    dcl SQL_DB2CS char value("DB2CS");

 /* Client Communication Protocols              */
    dcl SQLF_PROTOCOL_TCPIP char value("TCPIP");
    dcl SQLF_PROTOCOL_APPC char value("APPC");

 /* Import/Export/Load/Unload calling action values  */
                              /* Initial call                        */
    dcl SQLU_INITIAL fixed bin(15) value('0'xn);
                              /* Subsequent call                     */
    dcl SQLU_CONTINUE fixed bin(15) value('1'xn);
                              /* Terminating call                    */
    dcl SQLU_TERMINATE fixed bin(15) value('2'xn);
                              /* Initial call - Load/Unload only     */
    dcl SQLU_NOINTERRUPT fixed bin(15) value('3'xn);
                              /* Abort call - Load only              */
    dcl SQLU_ABORT fixed bin(15) value('4'xn);
                              /* Restart call - Load only            */
    dcl SQLU_RESTART fixed bin(15) value('5'xn);
                              /* Subsequent call - Load/Unload only  */
    dcl SQLU_DEVICE_TERMINATE fixed bin(15) value('9'xn);

 /* Actions for quiesce tablespaces for table        */
    dcl SQLU_QUIESCEMODE_SHARE fixed bin(31) value(0);
    dcl SQLU_QUIESCEMODE_INTENT_UPDATE fixed bin(31) value(1);
    dcl SQLU_QUIESCEMODE_EXCLUSIVE fixed bin(31) value(2);
    dcl SQLU_QUIESCEMODE_RESET fixed bin(31) value(9);
    dcl SQLU_QUIESCEMODE_RESET_OWNED fixed bin(31) value(10);

 /* Equates for Configuration Utilities  */

 /* Token equates for SQLFupd structure for Kernel config file*/
    dcl SQLF_KTN_RQRIOBLK fixed bin(31) value(1);
    dcl SQLF_KTN_NUMDB fixed bin(31) value(6);
    dcl SQLF_KTN_NNAME fixed bin(31) value(7);
    dcl SQLF_KTN_MAXAGENTS fixed bin(31) value(12);
    dcl SQLF_KTN_MAXCAGENTS fixed bin(31) value(13);
    dcl SQLF_KTN_ASLHEAPSZ fixed bin(31) value(15);
    dcl SQLF_KTN_SQLSTMTSZ fixed bin(31) value(17);
    dcl SQLF_KTN_BACKBUFSZ fixed bin(31) value(18);
    dcl SQLF_KTN_RESTBUFSZ fixed bin(31) value(19);
    dcl SQLF_KTN_INDEXREC fixed bin(31) value(20);
    dcl SQLF_KTN_SHEAPTHRES fixed bin(31) value(21);
    dcl SQLF_KTN_MAXDARI fixed bin(31) value(80);
    dcl SQLF_KTN_KEEPDARI fixed bin(31) value(81);
    dcl SQLF_KTN_SVCENAME fixed bin(31) value(24);
    dcl SQLF_KTN_TPNAME fixed bin(31) value(25);
    dcl SQLF_KTN_AGENTPRI fixed bin(31) value(26);
    dcl SQLF_KTN_DFTDBPATH fixed bin(31) value(27);

 /* tokens for new Version 2.1 parameters                     */
    dcl SQLF_KTN_DFT_ACCOUNT_STR fixed bin(31) value(28);

 /* You may manipulate the bits of SQLF_KTN_DFT_MONSWITCHES or */
 /* you can enable disable, or query the current setting through*/
 /* the individual tokens         */
    dcl SQLF_KTN_DFT_MONSWITCHES fixed bin(31) value(29);
                              /* Bit 1 of SQLF_KTN_DFT_MONSWITCHES   */
    dcl SQLF_KTN_DFT_MON_UOW fixed bin(31) value(30);
                              /* Bit 2 of SQLF_KTN_DFT_MONSWITCHES   */
    dcl SQLF_KTN_DFT_MON_STMT fixed bin(31) value(31);
                              /* Bit 3 of SQLF_KTN_DFT_MONSWITCHES   */
    dcl SQLF_KTN_DFT_MON_TABLE fixed bin(31) value(32);
                              /* Bit 4 of SQLF_KTN_DFT_MONSWITCHES   */
    dcl SQLF_KTN_DFT_MON_BUFPOOL fixed bin(31) value(33);
                              /* Bit 5 of SQLF_KTN_DFT_MONSWITCHES   */
    dcl SQLF_KTN_DFT_MON_LOCK fixed bin(31) value(34);
                              /* Bit 6 of SQLF_KTN_DFT_MONSWITCHES   */
    dcl SQLF_KTN_DFT_MON_SORT fixed bin(31) value(35);

    dcl SQLF_KTN_SYSADM_GROUP fixed bin(31) value(39);
    dcl SQLF_KTN_DIR_CACHE fixed bin(31) value(40);
    dcl SQLF_KTN_DRDA_HEAP_SZ fixed bin(31) value(41);
    dcl SQLF_KTN_CPUSPEED fixed bin(31) value(42);
    dcl SQLF_KTN_MIN_PRIV_MEM fixed bin(31) value(43);
    dcl SQLF_KTN_PRIV_MEM_THRESH fixed bin(31) value(44);
    dcl SQLF_KTN_MAXTOTFILOP fixed bin(31) value(45);
    dcl SQLF_KTN_FILESERVER fixed bin(31) value(47);
    dcl SQLF_KTN_OBJECTNAME fixed bin(31) value(48);
    dcl SQLF_KTN_QUERY_HEAP_SZ fixed bin(31) value(49);

    dcl SQLF_KTN_MAX_IDLEAGENTS fixed bin(31) value(60);
    dcl SQLF_KTN_AGENT_STACK_SZ fixed bin(31) value(61);
    dcl SQLF_KTN_SYSMAINT_GROUP fixed bin(31) value(62);
    dcl SQLF_KTN_SYSCTRL_GROUP fixed bin(31) value(63);

    dcl SQLF_KTN_DIAGLEVEL fixed bin(31) value(64);
    dcl SQLF_KTN_DIAGPATH fixed bin(31) value(65);

    dcl SQLF_KTN_TP_MON_NAME fixed bin(31) value(66);
    dcl SQLF_KTN_TM_DATABASE fixed bin(31) value(67);
    dcl SQLF_KTN_RESYNC_INTERVAL fixed bin(31) value(68);
    dcl SQLF_KTN_UDF_MEM_SZ fixed bin(31) value(69);

    dcl SQLF_KTN_IPX_SOCKET fixed bin(31) value(71);
    dcl SQLF_KTN_DOS_RQRIOBLK fixed bin(31) value(72);

                              /* token for directory services        */
    dcl SQLF_KTN_DIR_TYPE fixed bin(31) value(73);
                              /* token for directory services        */
    dcl SQLF_KTN_DIR_PATH_NAME fixed bin(31) value(74);
                              /* token for directory services        */
    dcl SQLF_KTN_DIR_OBJ_NAME fixed bin(31) value(75);
                              /* token for directory services        */
    dcl SQLF_KTN_ROUTE_OBJ_NAME fixed bin(31) value(76);
                              /* token for directory services        */
    dcl SQLF_KTN_DFT_CLIENT_COMM fixed bin(31) value(77);
    dcl SQLF_KTN_AUTHENTICATION fixed bin(31) value(78);
    dcl SQLF_KTN_MON_HEAP_SZ fixed bin(31) value(79);

 /* tokens for syncpoint manager */
    dcl SQLF_KTN_SPM_LOG_FILE_SZ fixed bin(31) value(90);
    dcl SQLF_KTN_SPM_MAX_RESYNC fixed bin(31) value(91);
    dcl SQLF_KTN_SPM_NAME fixed bin(31) value(92);

 /* tokens for adsm              */
    dcl SQLF_KTN_ADSM_PASSWORD fixed bin(31) value(93);
    dcl SQLF_KTN_ADSM_NODENAME fixed bin(31) value(94);
    dcl SQLF_KTN_ADSM_OWNER fixed bin(31) value(95);

 /* equates for diretory type    */
    dcl SQLF_DIRTYPE_NONE fixed bin(31) value(0);
    dcl SQLF_DIRTYPE_DCE fixed bin(31) value(1);

 /* tokens for internal parameters  */
    dcl SQLF_KTN_NODETYPE fixed bin(31) value(100);
    dcl SQLF_KTN_RELEASE fixed bin(31) value(101);
    dcl SQLF_KTN_NOTOKEN fixed bin(31) value(200);

 /* Nodetype equates                */
    dcl SQLF_NT_STANDALONE fixed bin(31) value(0);
    dcl SQLF_NT_SERVER fixed bin(31) value(1);
    dcl SQLF_NT_REQUESTOR fixed bin(31) value(2);
    dcl SQLF_NT_STAND_REQ fixed bin(31) value(3);

 /*******************************************************************/
 /** Defines for Database Monitor Switches- SQLF_KTN_DFT_MONSWITCHES*/
 /**                                                                */
 /** The following meanings apply when the bits are set on.         */
 /**                                                                */
 /** SQLF_ENABLE_MON_UOW     -                                      */
 /** SQLF_ENABLE_MON_STMT    -                                      */
 /** SQLF_ENABLE_MON_TABLE   -                                      */
 /** SQLF_ENABLE_MON_BUFPOOL -                                      */
 /** SQLF_ENABLE_MON_LOCK    -                                      */
 /** SQLF_ENABLE_MON_SORT    -                                      */
 /*******************************************************************/

                              /* xxxx xxxx xxxx xxx1                 */
    dcl SQLF_ENABLE_MON_UOW fixed bin(15) value('1'xn);
                              /* xxxx xxxx xxxx xx1x                 */
    dcl SQLF_ENABLE_MON_STMT fixed bin(15) value('2'xn);
                              /* xxxx xxxx xxxx x1xx                 */
    dcl SQLF_ENABLE_MON_TABLE fixed bin(15) value('4'xn);
                              /* xxxx xxxx xxxx 1xxx                 */
    dcl SQLF_ENABLE_MON_BUFPOOL fixed bin(15) value('8'xn);
                              /* xxxx xxxx xxx1 xxxx                 */
    dcl SQLF_ENABLE_MON_LOCK fixed bin(15) value('10'xn);
                              /* xxxx xxxx xx1x xxxx                 */
    dcl SQLF_ENABLE_MON_SORT fixed bin(15) value('20'xn);

 /* Token equates for SQLFupd structure for DB config file */
    dcl SQLF_DBTN_LOCKLIST fixed bin(31) value(1);
    dcl SQLF_DBTN_BUFF_PAGE fixed bin(31) value(90);
    dcl SQLF_DBTN_MAXFILOP fixed bin(31) value(3);
    dcl SQLF_DBTN_SOFTMAX fixed bin(31) value(5);
    dcl SQLF_DBTN_MAXAPPLS fixed bin(31) value(6);
    dcl SQLF_DBTN_APPLHEAPSZ fixed bin(31) value(51);
    dcl SQLF_DBTN_DBHEAP fixed bin(31) value(50);
    dcl SQLF_DBTN_DLCHKTIME fixed bin(31) value(9);
    dcl SQLF_DBTN_SORT_HEAP fixed bin(31) value(52);
    dcl SQLF_DBTN_MAXLOCKS fixed bin(31) value(15);
    dcl SQLF_DBTN_LOGPRIMARY fixed bin(31) value(16);
    dcl SQLF_DBTN_LOGSECOND fixed bin(31) value(17);
    dcl SQLF_DBTN_LOGFILSIZ fixed bin(31) value(18);
    dcl SQLF_DBTN_STMTHEAP fixed bin(31) value(53);
    dcl SQLF_DBTN_NEWLOGPATH fixed bin(31) value(20);
    dcl SQLF_DBTN_DETS fixed bin(31) value(21);
    dcl SQLF_DBTN_COPY_PROTECT fixed bin(31) value(22);
    dcl SQLF_DBTN_LOG_RETAIN fixed bin(31) value(23);
    dcl SQLF_DBTN_USER_EXIT fixed bin(31) value(24);
    dcl SQLF_DBTN_AUTO_RESTART fixed bin(31) value(25);
    dcl SQLF_DBTN_INDEXREC fixed bin(31) value(30);
    dcl SQLF_DBTN_PCKCACHESZ fixed bin(31) value(31);
    dcl SQLF_DBTN_MINCOMMIT fixed bin(31) value(32);
    dcl SQLF_DBTN_LOGBUFSZ fixed bin(31) value(33);

 /* tokens for new Version 2.1 parameters                  */
    dcl SQLF_DBTN_LOCKTIMEOUT fixed bin(31) value(34);
    dcl SQLF_DBTN_INDEXSORT fixed bin(31) value(35);
    dcl SQLF_DBTN_NUM_FREQVALUES fixed bin(31) value(36);
    dcl SQLF_DBTN_NUM_IOCLEANERS fixed bin(31) value(37);
    dcl SQLF_DBTN_CHNGPGS_THRESH fixed bin(31) value(38);
    dcl SQLF_DBTN_NUM_IOSERVERS fixed bin(31) value(39);
    dcl SQLF_DBTN_DFT_PREFETCH_SZ fixed bin(31) value(40);
    dcl SQLF_DBTN_SEQDETECT fixed bin(31) value(41);
    dcl SQLF_DBTN_DFT_LOADREC_SES fixed bin(31) value(42);
    dcl SQLF_DBTN_REC_HIS_RETENTN fixed bin(31) value(43);
    dcl SQLF_DBTN_COLLATE_INFO fixed bin(31) value(44);
    dcl SQLF_DBTN_STAT_HEAP_SZ fixed bin(31) value(45);
                              /* token for directory services        */
    dcl SQLF_DBTN_DIR_OBJ_NAME fixed bin(31) value(46);
    dcl SQLF_DBTN_AVG_APPLS fixed bin(31) value(47);
    dcl SQLF_DBTN_NUM_QUANTILES fixed bin(31) value(48);
    dcl SQLF_DBTN_DFT_EXTENT_SZ fixed bin(31) value(54);
    dcl SQLF_DBTN_UTIL_HEAP_SZ fixed bin(31) value(55);
    dcl SQLF_DBTN_CATALOGCACHE_SZ fixed bin(31) value(56);
    dcl SQLF_DBTN_DFT_QUERYOPT fixed bin(31) value(57);

 /* tokens for internal parameters                         */
    dcl SQLF_DBTN_COUNTRY fixed bin(31) value(100);
    dcl SQLF_DBTN_CODEPAGE fixed bin(31) value(101);
    dcl SQLF_DBTN_RELEASE fixed bin(31) value(102);
    dcl SQLF_DBTN_LOGPATH fixed bin(31) value(103);
    dcl SQLF_DBTN_INTFLAGS fixed bin(31) value(104);
    dcl SQLF_DBTN_LOGHEAD fixed bin(31) value(105);
    dcl SQLF_DBTN_NEXTACTIVE fixed bin(31) value(107);
    dcl SQLF_DBTN_CONSISTENT fixed bin(31) value(111);
    dcl SQLF_DBTN_BACKUP_PENDING fixed bin(31) value(112);
    dcl SQLF_DBTN_ROLLFWD_PENDING fixed bin(31) value(113);
    dcl SQLF_DBTN_LOG_RETAIN_STATUS fixed bin(31) value(114);
    dcl SQLF_DBTN_USER_EXIT_STATUS fixed bin(31) value(115);
    dcl SQLF_DBTN_CODESET fixed bin(31) value(120);
    dcl SQLF_DBTN_TERRITORY fixed bin(31) value(121);
    dcl SQLF_DBTN_NUMSEGS fixed bin(31) value(122);
    dcl SQLF_DBTN_DATABASE_LEVEL fixed bin(31) value(124);
    dcl SQLF_DBTN_NOTOKEN fixed bin(31) value(200);

 /* Index recreate type                                    */
    dcl SQLF_INX_REC_SYSTEM fixed bin(31) value(0);
    dcl SQLF_INX_REC_REFERENCE fixed bin(31) value(1);
    dcl SQLF_INX_REC_RESTART fixed bin(31) value(2);

 /* Special values for configuration defaults              */
                              /* Default maxcagents                  */
    %dcl SQLFDMCA char ext;
    %SQLFDMCA = '-1';
                              /* Default maxdari                     */
    %dcl SQLFDMXD char ext;
    %SQLFDMXD = '-1';
                              /* Default agentpri                    */
    %dcl SQLFDAPR char ext;
    %SQLFDAPR = '-1';
                              /* keepdari - no                       */
    dcl SQLFMKPD fixed bin(31) value(0);
                              /* keepdari - yes                      */
    dcl SQLFXKPD fixed bin(31) value(1);

 /********************************************************************/
 /* You may manipulate the bits of SQLF_DBTN_DETS and                */
 /* SQLF_DBTN_INTFLAGS                                               */
 /* or you can enable, disable, or query the current setting through */
 /* the individual tokens.                                           */
 /*                                                                  */
 /* Defines for: SQLF_DBTN_COPY_PROTECT    , SQLF_DBTN_LOG_RETAIN    */
 /*              SQLF_DBTN_USER_EXIT       , SQLF_DBTN_AUTO_RESTART  */
 /*              SQLF_DBTN_CONSISTENT      , SQLF_DBTN_BACKUP_PENDING*/
 /*           SQLF_DBTN_ROLLFWD_PENDING , SQLF_DBTN_LOG_RETAIN_STATUS*/
 /*               SQLF_DBTN_USER_EXIT_STATUS                         */
 /********************************************************************/

    dcl SQLF_DISABLE fixed bin(31) value(0);
    dcl SQLF_ENABLE fixed bin(31) value(1);
    dcl SQLF_ROLLFWD_TABLESPACE fixed bin(31) value(2);

 /********************************************************************/
 /* Defines for Database Details - SQLF_DBTN_DETS                    */
 /*                                                                  */
 /* The following meanings apply when the bits are set on.           */
 /*                                                                  */
 /* SQLF_COPY_PROTECT       - Database is copy protected.            */
 /* SQLF_ENABLE_LOG_RETAIN  - Next time database is started in normal*/
 /*                         conditions, the log files will be retaine*/
 /*                         for the purpose of roll-forward recovery.*/
 /* SQLF_ENABLE_USER_EXIT   - Next time database is started in normal*/
 /*                     conditions, the user log exit will be enabled*/
 /*                          for the purpose of roll-forward recovery*/
 /* SQLF_ENABLE_AUTO_RESTART- The RESTART DATABASE function will be  */
 /*                           invoked when needed.                   */
 /********************************************************************/

                              /* xxxx xxxx xxxx xxx0                 */
    dcl SQLF_COPY_NOPROT fixed bin(15) value('0'xn);
                              /* xxxx xxxx xxxx xxx1                 */
    dcl SQLF_COPY_PROTECT fixed bin(15) value('1'xn);
                              /* xxxx xxxx xxxx xx1x                 */
    dcl SQLF_ENABLE_LOG_RETAIN fixed bin(15) value('2'xn);
                              /* xxxx xxxx xxxx x1xx                 */
    dcl SQLF_ENABLE_USER_EXIT fixed bin(15) value('4'xn);
                              /* xxxx xxxx xxxx 1xxx                 */
    dcl SQLF_ENABLE_AUTO_RESTART fixed bin(15) value('8'xn);

 /*********************************************************************/
 /* Defines for Logging Flags    - SQLF_DBTN_INTFLAGS                 */
 /*                                                                   */
 /*The following meanings apply when the bits are set on.             */
 /*                                                                   */
 /* SQLF_CONSISTENT      - Database is in a consistent state.         */
 /* SQLF_BACKUP_PENDING  - User is required to take a backup of the   */
 /*                        database before the system will allow the  */
 /*                        database to be opened for normal processing*/
 /* SQLF_ROLLFWD_PENDING - User is reqd to roll forward the database  */
 /*                       before the system will allow the database to*/
 /*                        be opened for normal processing.           */
 /* SQLF_LOG_RETAIN      - Log files are retained so that a database  */
 /*                        can be rolled                              */
 /*                        forward after it has been restored from    */
 /*                        a backup copy.                             */
 /* SQLF_USER_EXIT  - User exit is taken when log files are filled and*/
 /*                        when log files are needed and not found.   */
 /* SQLF_TBS_ROLLFWD - If the SQLF_ROLLFWD_PENDING bit is off,and this*/
 /*                        bit is on, then the tablespace needs to be */
 /*                        rolled forward.                            */
 /*                                                                   */
 /*********************************************************************/

                              /* xxxx xxxx xxxx xxx1                 */
    dcl SQLF_CONSISTENT fixed bin(15) value('1'xn);
                              /* xxxx xxxx xxxx x1xx                 */
    dcl SQLF_BACKUP_PENDING fixed bin(15) value('4'xn);
                              /* xxxx xxxx xxxx 1xxx                 */
    dcl SQLF_ROLLFWD_PENDING fixed bin(15) value('8'xn);
                              /* xxxx xxxx xxx1 xxxx                 */
    dcl SQLF_LOG_RETAIN fixed bin(15) value('10'xn);
                              /* xxxx xxxx xx1x xxxx                 */
    dcl SQLF_USER_EXIT fixed bin(15) value('20'xn);
                              /* xxxx xxxx x1xx xxxx                 */
    dcl SQLF_TBS_ROLLFWD fixed bin(15) value('40'xn);

                              /* length of tpname config parm        */
    dcl SQL_TPNAME_SZ fixed bin(31) value(64);

                              /* length of syncpoint manager name    */
    dcl SQL_SPM_NAME_SZ fixed bin(31) value(8);

                              /* max length of log parms             */
    dcl SQL_LOGPATH_SZ fixed bin(31) value(242);
                              /* max length of log file name         */
    dcl SQL_LOGFILE_NAME_SZ fixed bin(31) value(12);
                              /* max length of db path parm          */
    dcl SQL_DBPATH_SZ fixed bin(31) value(215);
                              /* max length of diagpath parm         */
    dcl SQL_FFDCPATH_SZ fixed bin(31) value(215);

 /* LOAD and UNLOAD defines */
                              /* restart at load phase               */
    dcl SQLU_LOAD_PHASE char value('L');
                              /* restart at build phase              */
    dcl SQLU_BUILD_PHASE char value('B');
                              /* restart at delete phase             */
    dcl SQLU_DELETE_PHASE char value('D');

 define structure
   1 sqldcoln,
       2 dcolnlen fixed bin(15),
       2 dcolnptr pointer;


 define structure
   1 sqldcol,
       2 dcolmeth fixed bin(15),
       2 dcolnum fixed bin(15),
                                      /* actual size must be dcolnum */
       2 dcolname dim(0:1-1) type sqldcoln;


 /* Structure for Pairs of Locations for ASC files */
 define structure
   1 sqllocpair,
       2 begin_loc fixed bin(15),
       2 end_loc fixed bin(15);


 define structure
   1 sqlloctab,
                                      /* actual size must be dcolnum */
       2 locpair dim(0:1-1) type sqllocpair;


 /* Structures for Input and Output Data for Import and Export */

 define structure
   1 sqluimpt_in,
       2 sizeOfStruct unsigned fixed bin(31) ,
       2 commitcnt unsigned fixed bin(31) ,
       2 restartcnt unsigned fixed bin(31) ;


 define structure
   1 sqluimpt_out,
       2 sizeOfStruct unsigned fixed bin(31) ,
       2 rowsRead unsigned fixed bin(31) ,
       2 rowsSkipped unsigned fixed bin(31) ,
       2 rowsInserted unsigned fixed bin(31) ,
       2 rowsUpdated unsigned fixed bin(31) ,
       2 rowsRejected unsigned fixed bin(31) ,
       2 rowsCommitted unsigned fixed bin(31) ;


 define structure
   1 sqluexpt_out,
       2 sizeOfStruct unsigned fixed bin(31) ,
       2 rowsExported unsigned fixed bin(31) ;


 %dcl SQLUIMPT_IN_SIZE char ext;
 %SQLUIMPT_IN_SIZE='struct sqluimpt_in';
    %dcl @SQLUIMPT_IN_SIZE char ext;
    %@SQLUIMPT_IN_SIZE='@struct sqluimpt_in';
 %dcl SQLUIMPT_OUT_SIZE char ext;
 %SQLUIMPT_OUT_SIZE='struct sqluimpt_out';
    %dcl @SQLUIMPT_OUT_SIZE char ext;
    %@SQLUIMPT_OUT_SIZE='@struct sqluimpt_out';
 %dcl SQLUEXPT_OUT_SIZE char ext;
 %SQLUEXPT_OUT_SIZE='struct sqluexpt_out';
    %dcl @SQLUEXPT_OUT_SIZE char ext;
    %@SQLUEXPT_OUT_SIZE='@struct sqluexpt_out';

 /* Structures for Input and Output Data for Load and Unload   */

 define structure
   1 sqluload_in,
       2 sizeOfStruct unsigned fixed bin(31) ,
       2 savecnt unsigned fixed bin(31) ,
       2 restartcnt unsigned fixed bin(31) ,
       2 rowcnt unsigned fixed bin(31) ,
       2 warningcnt unsigned fixed bin(31) ,
       2 data_buffer_size unsigned fixed bin(31) ,
       2 sort_buffer_size unsigned fixed bin(31) ,
       2 hold_quiesce unsigned fixed bin(16) ,
       2 restartphase char,
       2 statsopt char;


 define structure
   1 sqluload_out,
       2 sizeOfStruct unsigned fixed bin(31) ,
       2 rowsRead unsigned fixed bin(31) ,
       2 rowsSkipped unsigned fixed bin(31) ,
       2 rowsLoaded unsigned fixed bin(31) ,
       2 rowsRejected unsigned fixed bin(31) ,
       2 rowsDeleted unsigned fixed bin(31) ,
       2 rowsCommitted unsigned fixed bin(31) ;


 define structure
   1 sqluunld_in,
       2 sizeOfStruct unsigned fixed bin(31) ,
       2 data_buffer_size unsigned fixed bin(31) ,
       2 sort_buffer_size unsigned fixed bin(31) ,
       2 hold_quiesce unsigned fixed bin(16) ,
       2 intent_update unsigned fixed bin(16) ,
       2 serial_write unsigned fixed bin(16) ,
       2 num_buffers unsigned fixed bin(16) ,
       2 reorg_lobs unsigned fixed bin(16) ,
       2 filler unsigned fixed bin(16) ;


 define structure
   1 sqluunld_out,
       2 sizeOfStruct unsigned fixed bin(31) ,
       2 rowsUnloaded unsigned fixed bin(31) ;


 %dcl SQLULOAD_IN_SIZE char ext;
 %SQLULOAD_IN_SIZE='struct sqluload_in';
    %dcl @SQLULOAD_IN_SIZE char ext;
    %@SQLULOAD_IN_SIZE='@struct sqluload_in';
 %dcl SQLULOAD_OUT_SIZE char ext;
 %SQLULOAD_OUT_SIZE='struct sqluload_out';
    %dcl @SQLULOAD_OUT_SIZE char ext;
    %@SQLULOAD_OUT_SIZE='@struct sqluload_out';
 %dcl SQLUUNLD_IN_SIZE char ext;
 %SQLUUNLD_IN_SIZE='struct sqluunld_in';
    %dcl @SQLUUNLD_IN_SIZE char ext;
    %@SQLUUNLD_IN_SIZE='@struct sqluunld_in';
 %dcl SQLUUNLD_OUT_SIZE char ext;
 %SQLUUNLD_OUT_SIZE='struct sqluunld_out';
    %dcl @SQLUUNLD_OUT_SIZE char ext;
    %@SQLUUNLD_OUT_SIZE='@struct sqluunld_out';

 /* Constants and Structures for the Asynchronous Read Log API */

                              /* read the database log               */
    dcl SQLU_RLOG_READ fixed bin(31) value(1);
                              /* read a single log record            */
    dcl SQLU_RLOG_READ_SINGLE fixed bin(31) value(2);
                              /* query the database log              */
    dcl SQLU_RLOG_QUERY fixed bin(31) value(3);

 define structure
 1 SQLU_LSN union,
                                   /* 6 byte character representation*/
       2 lsnChar char(6) ,
                                      /* 6 byte short representation */
       2 lsnWord dim(0:3-1) unsigned fixed bin(31);

    define alias @SQLU_LSN handle SQLU_LSN;

 define structure
   1 SQLU_RLOG_INFO,
        2 initialLSN type SQLU_LSN,  /* initial lsn at first connect */
        2 firstReadLSN type SQLU_LSN,      /* first lsn read on call */
        2 lastReadLSN type SQLU_LSN,        /* last lsn read on call */
        2 curActiveLSN type SQLU_LSN,          /* current active lsn */
                                   /* number of log records returned */
       2 logRecsWritten unsigned fixed bin(31) ,
                                      /* number of log bytesreturned */
       2 logBytesWritten unsigned fixed bin(31) ;

    define alias @SQLU_RLOG_INFO handle SQLU_RLOG_INFO;

 /* Structures for Configuration Utility APIs. */

 define structure
   1 sqlfupd,
       2 token unsigned fixed bin(16) ,
       2 ptrvalue pointer;


 /* Constants and structure used by sqlgadau and sqluadau. */
    dcl SQL_USER_AUTHORIZED fixed bin(31) value(1);
    dcl SQL_USER_UNAUTHORIZED fixed bin(31) value(0);
    dcl SQL_AUTHORIZATION_SIZE_OLD fixed bin(31) value(22);
    dcl SQL_AUTHORIZATION_SIZE fixed bin(31) value(34);

 define structure
   1 sql_authorizations,
       2 sql_authorizations_len fixed bin(15),
       2 sql_sysadm_auth fixed bin(15),
       2 sql_dbadm_auth fixed bin(15),
       2 sql_createtab_auth fixed bin(15),
       2 sql_bindadd_auth fixed bin(15),
       2 sql_connect_auth fixed bin(15),
       2 sql_sysadm_grp_auth fixed bin(15),
       2 sql_dbadm_grp_auth fixed bin(15),
       2 sql_createtab_grp_auth fixed bin(15),
       2 sql_bindadd_grp_auth fixed bin(15),
       2 sql_connect_grp_auth fixed bin(15),
       2 sql_sysctrl_auth fixed bin(15),
       2 sql_sysctrl_grp_auth fixed bin(15),
       2 sql_sysmaint_auth fixed bin(15),
       2 sql_sysmaint_grp_auth fixed bin(15),
       2 sql_create_not_fenc_auth fixed bin(15),
       2 sql_create_not_fenc_grp_auth fixed bin(15);


 /* Constants and structure used for backup and restore    */
    dcl SQLU_MAX_TBS_NAME_LEN fixed bin(31) value(18);
    dcl SQLU_DB_DIR_LEN fixed bin(31) value(215);
    dcl SQLU_SHR_LIB_LEN fixed bin(31) value(255);
    dcl SQLU_MEDIA_LOCATION_LEN fixed bin(31) value(255);
    dcl SQLU_APPLID_LEN fixed bin(31) value(32);
    dcl SQLU_MAX_SESSIONS fixed bin(31) value(999);

 define structure
   1 sqlu_tablespace_entry,
       2 reserve_len unsigned fixed bin(31) ,
       2 tablespace_entry char(SQLU_MAX_TBS_NAME_LEN+1) ,
       2 filler char(1) ;

    define alias @sqlu_tablespace_entry handle sqlu_tablespace_entry;

 define structure
   1 sqlu_tablespace_bkrst_list,
       2 num_entry fixed bin(31),
       2 tablespace handle sqlu_tablespace_entry;

    define alias @sqlu_tablespace_bkrst_list handle
    sqlu_tablespace_bkrst_list;

 define structure
   1 sqlu_media_entry,
       2 reserve_len unsigned fixed bin(31) ,
       2 media_entry char(SQLU_DB_DIR_LEN+1) ;

    define alias @sqlu_media_entry handle sqlu_media_entry;

 define structure
   1 sqlu_vendor,
       2 reserve_len1 unsigned fixed bin(31) ,
       2 shr_lib char(SQLU_SHR_LIB_LEN+1) ,
       2 reserve_len2 unsigned fixed bin(31) ,
       2 filename char(SQLU_SHR_LIB_LEN+1) ;

    define alias @sqlu_vendor handle sqlu_vendor;

 define structure
   1 sqlu_location_entry,
       2 reserve_len unsigned fixed bin(31) ,
       2 location_entry char(SQLU_MEDIA_LOCATION_LEN+1) ;

    define alias @sqlu_location_entry handle sqlu_location_entry;

                              /* path/device                         */
    dcl SQLU_LOCAL_MEDIA char value('L');
                              /* remote file/device/named pipe       */
    dcl SQLU_SERVER_LOCATION char value('S');
                              /* local file/device/named pipe        */
    dcl SQLU_CLIENT_LOCATION char value('C');
                              /* ADSM                                */
    dcl SQLU_ADSM_MEDIA char value('A');
                              /* vendor library                      */
    dcl SQLU_OTHER_MEDIA char value('O');
                              /* user exit                           */
    dcl SQLU_USER_EXIT char value('U');
                              /* Generated only by vendors           */
    dcl SQLU_DISK_MEDIA char value('D');
                              /* Generated only by vendors           */
    dcl SQLU_DISKETTE_MEDIA char value('K');
                              /* Generated only by vendors           */
    dcl SQLU_TAPE_MEDIA char value('T');
                              /* Generated only by vendors           */
    dcl SQLU_PIPE_MEDIA char value('P');

 define structure
 1 sqlu_media_list_targets union,
        2 media handle sqlu_media_entry,   /* For media_type L - for */
                                         /* BACKUP, RESTORE and LOAD */
                                       /* copytarget, workdirectory, */
                                             /* lobpaths, IMPORT and */
                                                  /* EXPORT lobpaths */
        2 vendor handle sqlu_vendor,             /* For media_type O */
                                            /* For media_type S - for*/
       2 location handle sqlu_location_entry;
                                           /* LOAD and LOAD recovery */
                                           /* For media type C - for */
                                                   /* EXPORT lobfile */


 define structure
   1 sqlu_media_list,
       2 media_type char,
       2 filler char(3) ,
       2 sessions fixed bin(31),
       2 target type sqlu_media_list_targets;

    define alias @sqlu_media_list handle sqlu_media_list;

 define structure
   1 sqluhtsp,
                                                   /*tablespace name */
       2 tablespace_name char(SQLUH_TABLESPACENAME_SZ+1) ,
       2 filler char;


 define structure
   1 sqluhinfo,
        2 sqluhinfoid char(8) ,        /* Eye catcher = 'SQLUHINF' */
        2 sqluhinfobc fixed bin(31),       /* SQLUHINFO in bytes=( ) */
        2 sqln fixed bin(15),                /* Number of tablespace */
                                                         /* elements */
        2 sqld fixed bin(15),                /* # of used tablespace */
                                                         /* elements */
        2 operation char(SQLUH_OP_SZ+1) ,             /* operation */
        2 object char(SQLUH_OBJ_SZ+1) ,                  /* object */
                                                       /* object part*/
       2 object_part char(SQLUH_OBJPART_SZ+1) ,
        2 optype char(SQLUH_OPTYPE_SZ+1) ,               /* optype */
                                                       /* device type*/
       2 device_type char(SQLUH_DEVTYPE_SZ+1) ,
       2 first_log char(SQLUH_FIRSTLOG_SZ+1) ,        /* first log */
        2 last_log char(SQLUH_LASTLOG_SZ+1) ,          /* last log */
        2 backup_id char(SQLUH_BACKID_SZ+1) ,         /* backup id */
                                                    /* table creator */
       2 table_creator char(SQLUH_TCREATE_SZ+1) ,
        2 table_name char(SQLUH_TNAME_SZ+1) ,        /* table name */
       2 num_of_tablespaces char(SQLUH_NUMTABLESPACE_SZ+1) ,
                                                             /* # of */
                                                      /* tablespaces */
        2 location char(SQLUH_LOC_SZ+1) ,              /* location */
        2 comment char(SQLUH_COMMENT_SZ+1) ,            /* comment */
       2 tablespace dim(0:1-1) type sqluhtsp;




 /* Definitions needed for the sqlb api calls */
 /*                                           */
 /* nb: 'tbs' is an abbreviaton for 'TABLESPACE'*/

                              /* maximum length of a table space     */
                              /* name                                */
    dcl SQLB_MAX_TBS_NAME_SZ fixed bin(31) value(128);
 /* NB: this constant is set to the maximum size that is likely to  */
 /* be needed in future.  Don't confuse this with  */
 /* SQLU_MAX_TBS_NAME_LEN which is set to the current maximum */
 /*  size (18).*/

 /* Externally visibile flags of a table space */
 /* storage manager class                      */
                              /* System   Managed Space              */
    dcl SQLB_TBS_SMS fixed bin(15) value('1'xn);
                              /* Database Managed Space              */
    dcl SQLB_TBS_DMS fixed bin(15) value('2'xn);
 /* table space contents                       */
                              /* regular contents                    */
    dcl SQLB_TBS_ANY fixed bin(15) value('0'xn);
                              /* long field data                     */
    dcl SQLB_TBS_LONG fixed bin(15) value('20'xn);
                              /* temp data                           */
    dcl SQLB_TBS_TMP fixed bin(15) value('10'xn);
 /* other flags values                         */
                              /* temp table space is reserved for    */
                              /* completion of reorg recovery        */
    dcl SQLB_TBS_TMP_RECOVERY fixed bin(31) value('20000'xn);

 /* The externally visible state of a table space is composed of the */
 /* hexadecimal sum of various of the following state values.  For  */
 /*example if the state is 'quiesced exclusive' and 'load pending',  */
 /* the value would be  0x0004 + 0x0008 which is 0x000c.         */
 /*                                                              */
 /* You may use the tool db2tbst to do the reverse calculation */
 /* (from 0x000c    */
 /* to 'load pending' and 'quiesced exclusive', for example) */
 /* which is more complex. In our example, execute:             */
 /*                                                             */
 /*  db2tbst 0x000c                                             */
 /*                                                             */
 /* which yields:                                               */
 /*                                                             */
 /* State = Quiesced Exclusive                                  */
 /*       + Load Pending                                        */
                                   /* Normal                         */
    dcl SQLB_NORMAL fixed bin(15) value('0'xn);
                                   /* Quiesced: SHARE                */
    dcl SQLB_QUIESCED_SHARE fixed bin(15) value('1'xn);
                                   /* Quiesced: UPDATE               */
    dcl SQLB_QUIESCED_UPDATE fixed bin(15) value('2'xn);
                                   /* Quiesced: EXCLUSIVE            */
    dcl SQLB_QUIESCED_EXCLUSIVE fixed bin(15) value('4'xn);
                                   /* Load pending                   */
    dcl SQLB_LOAD_PENDING fixed bin(15) value('8'xn);
                                   /* Delete pending                 */
    dcl SQLB_DELETE_PENDING fixed bin(15) value('10'xn);
                                   /* Backup pending                 */
    dcl SQLB_BACKUP_PENDING fixed bin(15) value('20'xn);
                                   /* Roll forward in progress       */
    dcl SQLB_ROLLFORWARD_IN_PROGRESS fixed bin(15) value('40'xn);
                                   /* Roll forward pending           */
    dcl SQLB_ROLLFORWARD_PENDING fixed bin(15) value('80'xn);
                                   /* Restore pending                */
    dcl SQLB_RESTORE_PENDING fixed bin(15) value('100'xn);
                                   /* Recovery pending (use SQLB     */
                                   /* RESTORE_PENDING)               */
    dcl SQLB_RECOVERY_PENDING fixed bin(15) value('100'xn);
                                   /* Disable pending                */
    dcl SQLB_DISABLE_PENDING fixed bin(15) value('200'xn);
                                   /* Reorg in progress              */
    dcl SQLB_REORG_IN_PROGRESS fixed bin(15) value('400'xn);
                                   /* Backup in progress             */
    dcl SQLB_BACKUP_IN_PROGRESS fixed bin(15) value('800'xn);
                                   /* storage must be defined        */
    dcl SQLB_STORDEF_PENDING fixed bin(15) value('1000'xn);
                                   /* Restore in progress            */
    dcl SQLB_RESTORE_IN_PROGRESS fixed bin(15) value('2000'xn);
                                      /* storage may be defined      */
    dcl SQLB_STORDEF_ALLOWED fixed bin(31) value('2000000'xn);
                                      /* storDef is in 'final'       */
                                   /* state                          */
    dcl SQLB_STORDEF_FINAL_VERSION fixed bin(31) value('4000000'xn);
                                      /* storDef was changed prior   */
                                   /* to rollforward                 */
    dcl SQLB_STORDEF_CHANGED fixed bin(31) value('8000000'xn);
                                       /* dms rebalancer is active   */
    dcl SQLB_REBAL_IN_PROGRESS fixed bin(31) value('10000000'xn);
                                       /* TBS deletion in progress   */
    dcl SQLB_PSTAT_DELETION fixed bin(31) value('20000000'xn);
                                       /* TBS creation in progress   */
    dcl SQLB_PSTAT_CREATION fixed bin(31) value('40000000'xn);

 /* Provide info about a tableSpace in a database */
 define structure
   1 SQLB_TBSQRY_DATA,
        2 id unsigned fixed bin(31) ,    /* internal id for the pool */
                                  /* length of the name (for cobol & */
       2 nameLen unsigned fixed bin(31) ,
                                                /* other nonC lang.) */
                                              /* NUL terminated name */
       2 name char(SQLB_MAX_TBS_NAME_SZ) ,
                                   /* DMS : Pages specified byCREATE */
       2 totalPages unsigned fixed bin(31) ,
                                                      /* TABLESPACE. */
                                                        /* SMS : N/A */
                                      /* DMS : totalPages - overhead */
       2 useablePages unsigned fixed bin(31) ,
                                                        /* SMS : N/A */
                                   /* bit attributes for the pool -- */
       2 flags unsigned fixed bin(31) ,
                                /* includes 'class' & other stuff to */
                                                       /* be defined */
                                        /* pagesize of tablespace (in*/
       2 pageSize unsigned fixed bin(31) ,
                                    /* bytes)..currently fixed at 4K */
        2 extSize unsigned fixed bin(31) , /* extent size (in pages) */
        2 prefetchSize unsigned fixed bin(31) ,     /* prefetch size */
       2 nContainers unsigned fixed bin(31) ,/* number of containers */
                                  /* SQLB_NORMAL, SQLB_LOAD_PENDING, */
       2 tbsState unsigned fixed bin(31) ,
                                                             /* etc. */
                               /* 'timestamp' identifying the origin */
       2 lifeLSN char(6) ,
                                                       /* of the tbs */
        2 pad char(2) ;                           /* for alignment */


 /* container type                        */
                              /* SMS: directory path specs           */
    dcl SQLB_CONT_PATH fixed bin(31) value(0);
                              /* DMS: a 'raw' or 'device' spec       */
    dcl SQLB_CONT_DISK fixed bin(31) value(1);
                              /* DMS: a 'cooked file' -> file spec   */
    dcl SQLB_CONT_FILE fixed bin(31) value(2);

 /* provide info about the containers on which tablespaces are based */
 define structure
   1 SQLB_TBSCONTQRY_DATA,
        2 id unsigned fixed bin(31) ,                /* container id */
                                     /* num table spaces sharing this*/
       2 nTbs unsigned fixed bin(31) ,
                                   /* container (is always 1 for DMS */
                                                     /* tablespaces) */
                                   /* tableSpace id, when 'nTbs' is1 */
       2 tbsID unsigned fixed bin(31) ,
                                 /* length of name (for non-C lang.) */
       2 nameLen unsigned fixed bin(31) ,
                                                  /* null term. name */
       2 name char(SQLB_MAX_CONTAIN_NAME_SZ) ,
                                    /* 1 if container is underthe DB */
       2 underDBDir unsigned fixed bin(31) ,
                                              /* directory, 0 if not */
                                          /* SQLB_CONT_PATH/DISK/FILE*/
       2 contType unsigned fixed bin(31) ,
                                   /* DMS : Pages specified byCREATE */
       2 totalPages unsigned fixed bin(31) ,
                                            /* TABLESPACE. SMS : N/A */
                                /* DMS : totalPages - overhead SMS : */
       2 useablePages unsigned fixed bin(31) ,
                                                              /* N/A */
                                /* 1 if container is accessible, 0if */
       2 ok unsigned fixed bin(31) ;
                                               /* there is a problem */


 /* provide statistics on a tablespace   */
 /* BETA NOTE: currently, we only provide stats on DMS tablespaces*/
 /* SRSFIX: determine what SMS support to ship with V2            */
 define structure
   1 SQLB_TBS_STATS,
                                   /* DMS : Pages specified byCREATE */
       2 totalPages unsigned fixed bin(31) ,          /* TABLESPACE. */
                                  /* SMS : Pages of all files in the */
                                                     /* directories. */
                                      /* DMS : totalPages - overhead */
       2 useablePages unsigned fixed bin(31) ,
                                         /* SMS : same as totalPages */
                                 /* DMS : used and allocatedpages in */
       2 usedPages unsigned fixed bin(31) ,              /* the pool */
                                         /* SMS : same as totalPages */
                                   /* DMS : useablePages - usedPages */
       2 freePages unsigned fixed bin(31) ,             /* SMS : N/A */
                                /* DMS : high water markof used page */
       2 highWaterMark unsigned fixed bin(31) ;            /* number */
                                                        /* SMS : N/A */


 /********************************************************************/
 /** Function proto-types: 'sqlb' prefix for internal use.           */
 /** All functions require a database connection, and return         */
 /** info about that database.                                       */
 /********************************************************************/

 /* stsq - Single TableSpace Query                               */
                                        /* Single Tablespace Query   */
    dcl   sqlbstsq  entry (
           pointer,                     /* SQLCA                     */
           unsigned fixed bin(31),      /* in: tableSpace id         */
            handle SQLB_TBSQRY_DATA)    /* out: tableSpace data      */
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* otsq - Open TableSpace Query -> use for retrieving a full list */
                                        /* all tablespaces in        */
                                        /* database                  */
    dcl SQLB_OPEN_TBS_ALL fixed bin(15) value('0'xn);
                                        /* all tablespaces my agent  */
                                        /* is restoring              */
    dcl SQLB_OPEN_TBS_RESTORE fixed bin(15) value('1'xn);
                                        /* all tablespaces where     */
                                        /* storage definition is     */
                                        /* allowed                   */
    dcl SQLB_OPEN_TBS_STORDEF fixed bin(15) value('2'xn);
                                        /* Open Tablespace Query     */
    dcl   sqlbotsq  entry (
           pointer,                     /* SQLCA                     */
           unsigned fixed bin(31),      /* in: processing options:   */
            pointer)                    /* SQLB_TBS_OPEN_xxx         */
                                        /* out: # tablespaces        */
                                        /* defined in db             */
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* ftsq - Fetch TableSpace Query -> fetch the next block of tbs data*/
                                        /* Fetch Tablespace Query    */
    dcl   sqlbftsq  entry (
           pointer,                     /* SQLCA                     */
           unsigned fixed bin(31),      /* max num of tbs the        */
                                        /* output area can hold      */
           handle SQLB_TBSQRY_DATA,     /* out: array of length      */
                                        /* maxTbs                    */
            pointer)                    /* out: #data entries        */
                                        /* returned                  */
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /*ctsq - Close TableSpace Query -> term the query opened by sqlbotsq*/
                                        /* Close Tablespace Query    */
    dcl   sqlbctsq  entry (
           pointer )                    /* SQLCA                     */
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* tsq - TableSpace Query -> uses the above primitives to return the*/
 /* FULL list of tablespaces in an array allocated and returned to   */
 /* the application.  The application should free this memory with   */
 /* the sqle api when it is finished with it. Even if this api fails */
 /* with an 'insufficient memory' error, 'nTbs' is set to the number */
 /* of tablespaces in the database. 'nTbs' is set to zero if we fail */
 /* to sucessfully open a query. 'tbsData' is returned as NULL       */
 /* (0;no mem alloc) if we fail for any reason.                     */
                                        /* Tablespace Query          */
    dcl   sqlbtsq  entry (
           pointer,                     /* SQLCA                     */
           pointer,                     /* out: total number of      */
                                        /* table spaces              */
            handle SQLB_TBSQRY_DATA)    /* out: mem returned to      */
                                        /* application               */
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* container level queries.They all accept either a tableSpace id   */
 /* (as tbs) ora special id (SQLB_ALL_TABLESPACES) which triggers the*/
 /* fetch of a list of containers for the entire database.*/
 /* constant used in place of tablespace id to indicate all table  */
 /* spaces in  db*/
    dcl SQLB_ALL_TABLESPACES fixed bin(31) value('fffe'xn);

 /* otcq - Open Tablespace Container Query -- prepares for fetching */
 /* a list of container data */
                                        /* Open Tablespace           */
                                        /* Container Query           */
    dcl   sqlbotcq  entry (
           pointer,                     /* SQLCA                     */
           unsigned fixed bin(31),      /* in: id tbs or SQLB_ALL    */
                                        /* TABLESPACES               */
                                        /* out:  output...the        */
                                        /* number of containers for  */
                                        /* the table space           */
           pointer)
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* ftcq - Fetch Tablespace Container Query. Fetch the next block of*/
 /* container info.                                                 */
                                        /* Fetch Tablespace          */
                                        /* Container Query           */
    dcl   sqlbftcq  entry (
           pointer,                     /* SQLCA                     */
           unsigned fixed bin(31),      /* in:  max # entries to     */
                                        /* return in 'data'          */
           handle SQLB_TBSCONTQRY_DATA, /* out: array of 'maxCont'   */
                                        /* entries                   */
                                        /* out: # data entries       */
                                        /* returned on this query    */
           pointer)
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* ctcq - Close Tablespace Container Query. Terminate processing for*/
 /*  this  query */
                                        /* Close Tablespace          */
                                        /* Container Query           */
    dcl   sqlbctcq  entry (
           pointer )
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* tcq - Tablespace Container Query               */
 /* Like 'sqlbtsq', this api generates a complete list, allocating   */
 /* sufficient memory.  The application is responsible for freeing   */
 /* the memory when  it is  */
 /* finished with it: call sqlefmem(ca,ptr). */
 dcl  sqlbtcq entry (
          pointer,    /* SQLCA */
          unsigned fixed bin(31), /* in: id a tbs or SQLB_ALL TABSPCS*/
          pointer,                /* out: # of entries returned      */
          byaddr handle SQLB_TBSCONTQRY_DATA)
             returns( byvalue optional SQL_API_RC )
              SQL_API_FN external;


 /* stsc - Set TableSpace Containers         */
 /* This api is to be used when the tablespace is in a 'storage */
 /* definition     */
 /* pending' or 'storage definition allowed' state.  These states are*/
 /* possible during a restore operation, immediately prior to the */
 /* restoration  */
 /* of database pages.  This API is intended to assist in the */
 /* provision  of a   */
 /* 'redirected' restore, where the user is restoring a database and */
 /* a different set of OS storage containers is desired/required. */
 /* As input the application provides a list of storage definitions */
 /* in the     */
 /* SQLB_TBSCONTQRY_DATA structure (also used for query purposes). */
 /* For this    */
 /* api only the following fields are examined:*/
 /*                                                                  */
 /* unsigned long   nameLen;    length of name (for non-C lang.)     */
 /* char            name[SQLB_MAX_CONTAIN_NAME_SZ];  null term. name */
 /* unsigned long   contType;    SQLB_CONT_PATH/DISK/FILE            */
 /* unsigned long   totalPages;  DMS only                            */
 /*                                                                  */
 /* processing options...pass 0 for 'nothing-special', OR in the spec*/
 /* bits.                                                            */
 /*                                                                  */
 /* when setting containers prior to a restore/rollforward, the user */
 /* may want  */
 /* to IGNORE any 'add containers' in the logs.  He may simply be    */
 /* providing a  */
 /* different 'final' state for the tablespace configuration.  The */
 /*  default     */
 /* behavior is to redo 'alter' logrecords after a new container */
 /* list has      */
 /* been set.*/

    dcl SQLB_SET_CONT_INIT_STATE fixed bin(31) value(0);
    dcl SQLB_SET_CONT_FINAL_STATE fixed bin(31) value(1);

                                        /* Set Tablespace            */
                                        /* Containers                */
    dcl   sqlbstsc  entry (
           pointer,                     /* SQLCA                     */
           unsigned fixed bin(31),      /* in: processing options:   */
                                        /* SQLB_SET_CONT_xxx         */
           unsigned fixed bin(31),      /* in: table space which is  */
                                        /* to be changed             */
           unsigned fixed bin(31),      /* in:#containers in the     */
                                        /* list                      */
            handle SQLB_TBSCONTQRY_DATA) /* container                */
                                        /* specifications            */
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* gtss - Get TableSpace Statistics */
 /* Provide some basic info about the utilization of a tablespace.   */
                                        /* Get Tablespace            */
                                        /* Statistics                */
    dcl   sqlbgtss  entry (
           pointer,                     /* SQLCA                     */
           unsigned fixed bin(31),
           handle SQLB_TBS_STATS)
             returns( byvalue optional  SQL_API_RC )
              SQL_API_FN external;

 /* END OF TABLESPACE RELATED API'S  */

 /* Database Utility Commands -- Function Prototypes  */

    %dcl SQLZ_STACK char ext;
    %if SQLZ_STACK = '' %then
     %do;

       %dcl SQL_REL_10 char ext;
       %if SQL_REL_10 ^= '' %then
        %do;

        %end;
     %else
        %do;

  %end;

  %end;

 /* General Utility Commands */

                                   /* Open Recovery History File     */
                                   /* Scan                           */
 dcl   sqluhops  entry (
        pointer,                   /* database alias to open the     */
                                   /* scan for                       */
        pointer,                   /* complete/partial timestamp     */
        pointer,                   /* table name or tablespace name  */
        pointer,                   /* rows that match parameters     */
        pointer,                   /* handle used for gne/cls        */
        unsigned fixed bin(16),    /* list: 0-backup; 1-history      */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Next Recovery History      */
                                   /* File Entry                     */
 dcl   sqluhgne  entry (
        unsigned fixed bin(16),    /* handle returned from open      */
        pointer,                   /* reserved for future use        */
        handle sqluhinfo,          /* pointer to entry               */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Close Recovery History File    */
                                   /* Scan                           */
 dcl   sqluhcls  entry (
        unsigned fixed bin(16),    /* handle returned from open      */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Prune Recovery History File    */
 dcl   sqluhprn  entry (
        pointer,                   /* timestamp (or partial one)     */
        unsigned fixed bin(16),    /* 0 for DON'T FORCE              */
                                   /*  1 for FORCE                   */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Update Recovery History File   */
 dcl   sqluhupd  entry (
        pointer,                   /* timestamp||(001 -> 999)        */
        pointer,                   /* the new location               */
        pointer,                   /* the new device type            */
        pointer,                   /* new comment                    */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Quiesce Tablespaces for Table  */
 dcl   sqluvqdp  entry (
        pointer,                   /* fully qualified table name     */
        fixed bin(31),             /* 0 for share                    */
                                   /* 1 for intent to update         */
                                   /* 2 for exclusive                */
                                   /* 9 to reset                     */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Authorizations             */
 dcl   sqluadau  entry (
        handle sql_authorizations,
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Authorizations             */
 dcl   sqluauth_api  entry (
         pointer )                 /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Backup Database                */
 dcl   sqlubkup  entry (
        pointer,                   /* database alias                 */
        unsigned fixed bin(31),    /* backup buffer size             */
        unsigned fixed bin(31),    /* online or offline              */
        unsigned fixed bin(31),    /* backup type.                   */
        unsigned fixed bin(31),    /* caller action                  */
        pointer,                   /* application ID.                */
        pointer,                   /* timestamp returned             */
        unsigned fixed bin(31),    /* num of buffers                 */
        handle sqlu_tablespace_bkrst_list,     /* list of            */
                                   /* tablespace                     */
        handle sqlu_media_list,    /* list of media targ           */
        pointer,                   /* user name                      */
        pointer,                   /* password                       */
        pointer,                   /* reserved for future            */
        unsigned fixed bin(31),    /* size of options                */
        pointer,                   /* reserved for vendor            */
        pointer,                   /* reserved for future            */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Restore Database               */
 dcl   sqlursto  entry (
        pointer,                   /* source alias name              */
        pointer,                   /* target dbalias                 */
        unsigned fixed bin(31),    /* restore buffer size            */
        unsigned fixed bin(31),    /* 0 - roll forward               */
                                   /* 1 - do not roll fwd            */
        unsigned fixed bin(31),    /* 0 - normal restore             */
                                   /* 3 - online restore for         */
                                   /* tablespace only                */
        unsigned fixed bin(31),    /* caller action                  */
        pointer,                   /* application ID.                */
        pointer,                   /* timestamp for backup image     */
        pointer,                   /* target path for new database   */
        unsigned fixed bin(31),    /* num of buffers                 */
        handle sqlu_tablespace_bkrst_list,     /* reserved for       */
                                   /* future use.                    */
        handle sqlu_media_list,    /* list of media controllers    */
                                   /* to use.                        */
        pointer,                   /* userid                         */
        pointer,                   /* password                       */
        pointer,                   /* reserved for future use        */
        unsigned fixed bin(31),    /* size of options field          */
        pointer,                   /* reserved for vendor use        */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Rollforward Database           */
 dcl   sqlurllf_api  entry (
        pointer,                   /* database alias                 */
        unsigned fixed bin(16),    /* action                         */
        pointer,                   /* application id                 */
        pointer,                   /* stop time                      */
        pointer,                   /* next archive file needed       */
        pointer,                   /* first archive file to be       */
                                   /* deleted                        */
        pointer,                   /* last archive file to be        */
                                   /* deleted                        */
        pointer,                   /* last commit time               */
        pointer,                   /* user name                      */
        pointer,                   /* password                       */
        pointer,                   /* overflow log path              */
        unsigned fixed bin(16),    /* connect mode                   */
        pointer,                   /* reserved                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Old backup                     */
 dcl   sqlubckp  entry (
        pointer,                   /* alias name                     */
        unsigned fixed bin(31),    /* backup buffer size             */
        unsigned fixed bin(16),    /* online or offline              */
        unsigned fixed bin(16),    /* reserved                       */
        unsigned fixed bin(16),    /* ADSM or otherwise              */
        pointer,                   /* dir or device name             */
        unsigned fixed bin(16),    /* caller action                  */
        pointer,                   /* timestamp returned             */
        pointer,                   /* userid                         */
        pointer,                   /* password                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Old Restore                    */
 dcl   sqludrst  entry (
        pointer,                   /* source database alias          */
        pointer,                   /* target database alias          */
        unsigned fixed bin(31),    /* restore buffer size            */
        unsigned fixed bin(16),    /* media type: ADSM or otherwise  */
        pointer,                   /* dir or device name             */
        pointer,                   /* timestamp of backup            */
        unsigned fixed bin(16),    /* roll forward flag              */
        unsigned fixed bin(16),    /* caller action                  */
        pointer,                   /* target: new dbase              */
        pointer,                   /* userid                         */
        pointer,                   /* password                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Old Rollforward Database       */
 dcl   sqlurfwd_api  entry (
        pointer,                   /* database name                  */
        unsigned fixed bin(16),    /* action                         */
        pointer,                   /* Stop Timestamp                 */
        pointer,                   /* Next Archive File needed       */
        pointer,                   /* First Archive File to be       */
                                   /* deleted                        */
        pointer,                   /* Last Archive File to be        */
                                   /* deleted                        */
        pointer,                   /* Returned Timestamp             */
        pointer,                   /* userid                         */
        pointer,                   /* password                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Export                         */
 dcl   sqluexpr_api  entry (
        pointer,                   /* data file                      */
        type @sqlu_media_list,     /* lob paths                      */
        type @sqlu_media_list,     /* lob files                      */
        handle sqldcol,            /* dcoldata                       */
        handle sqlchar,            /* tcolstrg                       */
        pointer,                   /* file type                      */
        handle sqlchar,            /* file type mod                  */
        pointer,                   /* msg file                       */
        fixed bin(15),             /* caller action                  */
        handle sqluexpt_out,       /* rows exported                  */
        pointer,                   /* reserved                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Export                         */
 dcl   sqluexpt_api  entry (
        pointer,                   /* datafile                       */
        handle sqldcol,            /* dcoldata                       */
        handle sqlchar,            /* tcolstrg                       */
        pointer,                   /* filetype                       */
        handle sqlchar,            /* filetmod                       */
        pointer,                   /* msgfile                        */
        fixed bin(15),             /* caller action                  */
        handle sqluexpt_out,       /* rows exported                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Import                         */
 dcl   sqluimpt_api  entry (
        pointer,                   /* datafile                       */
        handle sqldcol,            /* dcoldata                       */
        handle sqlchar,            /* tcolstrg                       */
        pointer,                   /* filetype                       */
        handle sqlchar,            /* filetmod                       */
        pointer,                   /* msgfile                        */
        fixed bin(15),             /* caller action                  */
        handle sqluimpt_in,        /* input parms                    */
        handle sqluimpt_out,       /* output parms                   */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Import                         */
 dcl   sqluimpr_api  entry (
        pointer,                   /* datafile                       */
        type @sqlu_media_list,     /* lobpath                        */
        handle sqldcol,            /* dcoldata                       */
        handle sqlchar,            /* tcolstrg                       */
        pointer,                   /* filetype                       */
        handle sqlchar,            /* filetmod                       */
        pointer,                   /* msgfile                        */
        fixed bin(15),             /* caller action                  */
        handle sqluimpt_in,        /* input parms                    */
        handle sqluimpt_out,       /* output parms                   */
        pointer,                   /* nullind                        */
        pointer,                   /* reserved                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Load                           */
 dcl   sqluload_api  entry (
        type @sqlu_media_list,     /* input data files               */
        type @sqlu_media_list,     /* input lob paths                */
        handle sqldcol,            /* dcoldata - describes input     */
                                   /* data                           */
        handle sqlchar,            /* tcolstrg - describes the       */
                                   /* columns of the table to load   */
        pointer,                   /* file type                      */
        handle sqlchar,            /* filetmod                       */
        pointer,                   /* message file name              */
        pointer,                   /* remote file name               */
        fixed bin(15),             /* caller action                  */
        handle sqluload_in,        /* input                          */
        handle sqluload_out,       /* output                         */
        type @sqlu_media_list,     /* work dirs                      */
        type @sqlu_media_list,     /* copy targets                   */
        pointer,                   /* null ind                       */
        pointer,                   /* reserved                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Query                          */
 dcl   sqluqry_api  entry (
        pointer,                   /* local msg file                 */
        pointer,                   /* remote msg file                */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Asynchronous Read Log          */
 dcl   sqlurlog_api  entry (
        unsigned fixed bin(31),    /* caller action                  */
        type @SQLU_LSN,            /* read start log sequence        */
                                   /* number                         */
        type @SQLU_LSN,            /* read end log sequence number   */
        pointer,                   /* user buffer                    */
        unsigned fixed bin(31),    /* size of user buffer            */
        type @SQLU_RLOG_INFO,      /* read log information           */
                                   /* structure                      */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Reorganize Table               */
 dcl   sqlureot_api  entry (
        pointer,                   /* table name                     */
        pointer,                   /* fully-qualified index name     */
        pointer,                   /* tablespace                     */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Run Statistics                 */
 dcl   sqlustat_api  entry (
        pointer,                   /* table name                     */
        unsigned fixed bin(16),    /* number of indexes              */
        pointer,                   /* indexlist                      */
        char,                      /* statsopt                       */
        char,                      /* sharelvl                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Table Authorizations       */
 dcl   sqlutbau  entry (
        pointer,                   /* fully-qualified table name     */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

 /* Generic APIs                   */

                                   /* Get Authorizations             */
 dcl   sqlgadau  entry (
        handle sql_authorizations, /* SQLCA                          */
        pointer)
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Default Database           */
                                   /* Configuration                  */
 dcl   sqlgddb  entry (
        unsigned fixed bin(16),    /* database alias length          */
        unsigned fixed bin(16),    /* count of requested no of       */
                                   /* items                          */
        handle sqlfupd,            /* list of items returned         */
        pointer,                   /* SQLCA                          */
         pointer)                  /* database  alias                */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Reset Database Configuration   */
 dcl   sqlgrdb  entry (
        unsigned fixed bin(16),    /* database alias length          */
        pointer,                   /* SQLCA                          */
         pointer)                  /* database alias                 */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Update Database Configuration  */
 dcl   sqlgudb  entry (
        unsigned fixed bin(16),    /* database alias length          */
        unsigned fixed bin(16),    /* count                          */
        pointer,                   /* List of item lengths           */
        handle sqlfupd,            /* list of items                  */
        pointer,                   /* SQLCA                          */
         pointer)                  /* database                       */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Database Configuration     */
 dcl   sqlgxdb  entry (
        unsigned fixed bin(16),    /* database alias length          */
        unsigned fixed bin(16),    /* count of items being returned  */
        handle sqlfupd,            /* list of items                  */
        pointer,                   /* SQLCA                          */
         pointer)                  /* database alias                 */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Database Manager           */
                                   /* Configuration Defaults         */
 dcl   sqlgdsys  entry (
        unsigned fixed bin(16),    /* count of items being returned  */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Backup Database                */
 dcl   sqlgbkup  entry (
        unsigned fixed bin(16),    /* database alias length          */
        unsigned fixed bin(16),    /* user name length               */
        unsigned fixed bin(16),    /* password length                */
        pointer,                   /* reserved for future use        */
        pointer,                   /* database alias                 */
        unsigned fixed bin(31),    /* buffer size in 4K units        */
        unsigned fixed bin(31),    /* online or offline              */
        unsigned fixed bin(31),    /* 0 - full dB; 3 - tablespace    */
        unsigned fixed bin(31),    /* caller action                  */
        pointer,                   /* application ID.                */
        pointer,                   /* timestamp returned             */
        unsigned fixed bin(31),    /* number of buffers to use       */
        handle sqlu_tablespace_bkrst_list,     /* list of            */
                                   /* tablespace names               */
        handle sqlu_media_list,    /* list of media targets        */
        pointer,                   /* user name                      */
        pointer,                   /* password                       */
        pointer,                   /* reserved for future use        */
        unsigned fixed bin(31),    /* size of options field          */
        pointer,                   /* reserved for vendor use        */
        pointer,                   /* reserved for future use        */
         pointer)                  /* sqlca structure                */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Close Recovery History File    */
                                   /* Scan                           */
 dcl   sqlghcls  entry (
        unsigned fixed bin(16),    /* handle returned from open      */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Next Recovery History      */
                                   /* File Entry                     */
 dcl   sqlghgne  entry (
        unsigned fixed bin(16),    /* handle returned from open      */
        pointer,                   /* reserved for future use        */
        handle sqluhinfo,          /* pointer to the address of the  */
                                   /* history file entry info        */
                                   /* buffer                         */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Open Recovery History File     */
                                   /* Scan                           */
 dcl   sqlghops  entry (
        unsigned fixed bin(16),    /* database alias length          */
        unsigned fixed bin(16),    /* timestamp length               */
        unsigned fixed bin(16),    /* object name length             */
        pointer,                   /* database alias                 */
        pointer,                   /* timestamp used to select       */
                                   /* records                        */
        pointer,                   /* object name used to select     */
                                   /* records                        */
        pointer,                   /* return no. of matching         */
                                   /* history file entries           */
        pointer,                   /* return handle used for future  */
                                   /* access                         */
        unsigned fixed bin(16),    /* '0' for backup                 */
                                   /* '1' for history                */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Prune Recovery History File    */
 dcl   sqlghprn  entry (
        unsigned fixed bin(16),    /* timestamp id length            */
        pointer,                   /* timestamp (whole or part)      */
        unsigned fixed bin(16),    /* force option                   */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Update Recovery History File   */
 dcl   sqlghupd  entry (
        unsigned fixed bin(16),    /* object_part length             */
        unsigned fixed bin(16),    /* new_location length            */
        unsigned fixed bin(16),    /* new_device_type length         */
        unsigned fixed bin(16),    /* new_comment length             */
        pointer,                   /* timestamp||(001 -> 999)        */
        pointer,                   /* the new location               */
        pointer,                   /* the new device type            */
        pointer,                   /* new comment                    */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Rollforward Database           */
 dcl   sqlgrllf  entry (
        unsigned fixed bin(16),    /* database alias length          */
        unsigned fixed bin(16),    /* stop time length               */
        unsigned fixed bin(16),    /* user name length               */
        unsigned fixed bin(16),    /* password length                */
        unsigned fixed bin(16),    /* overflow log path length       */
        pointer,                   /* database alias                 */
        unsigned fixed bin(16),    /* caller action                  */
        pointer,                   /* application id returned        */
        pointer,                   /* stop time                      */
        pointer,                   /* next archive file              */
        pointer,                   /* first del archive file         */
        pointer,                   /* last del archive file          */
        pointer,                   /* last commit time               */
        pointer,                   /* user name                      */
        pointer,                   /* password                       */
        pointer,                   /* overflow log path name         */
        unsigned fixed bin(16),    /* connect mode                   */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Restore Database               */
 dcl   sqlgrsto  entry (
        unsigned fixed bin(16),    /* source database alias length   */
        unsigned fixed bin(16),    /* target database alias length   */
        unsigned fixed bin(16),    /* timestamp length               */
        unsigned fixed bin(16),    /* target path length             */
        unsigned fixed bin(16),    /* user name length               */
        unsigned fixed bin(16),    /* password  length               */
        pointer,                   /* nodename length                */
        pointer,                   /* source database alias          */
        pointer,                   /* target database alias          */
        unsigned fixed bin(31),    /* buffer size in 4K units        */
        unsigned fixed bin(31),    /* 0 - roll forward               */
                                   /* 1 - do not roll forward        */
        unsigned fixed bin(31),    /* 0 - normal restore             */
                                   /* 3 - online restore             */
                                   /*     for tablespace only        */
        unsigned fixed bin(31),    /* caller action                  */
        pointer,                   /* application id returned        */
        pointer,                   /* timestamp of backup            */
        pointer,                   /* target: new path               */
        unsigned fixed bin(31),    /* number of buffers to use       */
        handle sqlu_tablespace_bkrst_list,     /* reserved for       */
                                   /* future use                     */
        handle sqlu_media_list,    /* list of media sources        */
        pointer,                   /* user name                      */
        pointer,                   /* password                       */
        pointer,                   /* reserved for future use        */
        unsigned fixed bin(31),    /* size of options field          */
        pointer,                   /* reserved for vendor use        */
        pointer,                   /* reserved for future use        */
        pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Quiesce Tablespaces for Table  */
 dcl   sqlgvqdp  entry (
        unsigned fixed bin(16),    /* length of table_name           */
        pointer,                   /* table name                     */
        fixed bin(31),             /* 0 for share                    */
                                   /* 1 for intent to update         */
                                   /* 2 for exclusive                */
                                   /* 9 to reset                     */
        pointer,                   /* reserved for future use        */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Old Backup                     */
 dcl   sqlgbckp  entry (
        unsigned fixed bin(16),    /* password length                */
        unsigned fixed bin(16),    /* userid length                  */
        unsigned fixed bin(16),    /* media target length            */
        unsigned fixed bin(16),    /* database name length           */
        pointer,                   /* ptr to sqlca                   */
        pointer,                   /* ptr to password                */
        pointer,                   /* ptr to userid                  */
        pointer,                   /* ptr to timestamp               */
        unsigned fixed bin(16),    /* caller action                  */
        pointer,                   /* ptr to media target            */
        unsigned fixed bin(16),    /* media type                     */
        unsigned fixed bin(16),    /* reserved                       */
        unsigned fixed bin(16),    /* backup mode                    */
        unsigned fixed bin(31),    /* buffer size                    */
         pointer)                  /* ptr to database name           */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Restore                        */
 dcl   sqlgdrst  entry (
        unsigned fixed bin(16),    /* password length                */
        unsigned fixed bin(16),    /* userid length                  */
        unsigned fixed bin(16),    /* target length                  */
        unsigned fixed bin(16),    /* timestamp length               */
        unsigned fixed bin(16),    /* media source length            */
        unsigned fixed bin(16),    /* target database length         */
        unsigned fixed bin(16),    /* source database length         */
        pointer,                   /* ptr to sqlca                   */
        pointer,                   /* ptr to password                */
        pointer,                   /* ptr to userid                  */
        pointer,                   /* ptr to target                  */
        unsigned fixed bin(16),    /* caller action                  */
        unsigned fixed bin(16),    /* restore mode                   */
        pointer,                   /* ptr to timestamp               */
        pointer,                   /* ptr to media source            */
        unsigned fixed bin(16),    /* media type                     */
        unsigned fixed bin(31),    /* buffer size                    */
        pointer,                   /* ptr to target database         */
         pointer)                  /* ptr to source database         */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* E)PORT FROM                    */
 dcl   sqlgexpr  entry (
        unsigned fixed bin(16),    /* data file name length          */
        unsigned fixed bin(16),    /* file type length               */
        unsigned fixed bin(16),    /* msg file name length           */
        pointer,                   /* data file                      */
        type @sqlu_media_list,     /* lob paths                      */
        type @sqlu_media_list,     /* lob file names                 */
        handle sqldcol,            /* dcoldata                       */
        handle sqlchar,            /* tcolstrg                       */
        pointer,                   /* file type                      */
        handle sqlchar,            /* file type mod                  */
        pointer,                   /* msg file name                  */
        fixed bin(15),             /* caller action                  */
        handle sqluexpt_out,       /* rows exported                  */
        pointer,                   /* reserved                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Export                         */
 dcl   sqlgexpt  entry (
        unsigned fixed bin(16),    /* message file name length       */
        unsigned fixed bin(16),    /* file type length               */
        unsigned fixed bin(16),    /* data file name length          */
        pointer,                   /* SQLCA                          */
        handle sqluexpt_out,       /* ptr to rows exported           */
        fixed bin(15),             /* caller action                  */
        pointer,                   /* message file name              */
        handle sqlchar,            /* ptr to file type mod           */
        pointer,                   /* ptr to filetype                */
        handle sqlchar,            /* ptr to tcolstrg                */
        handle sqldcol,            /* ptr to dcoldata                */
         pointer)                  /* data file name                 */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Import                         */
 dcl   sqlgimpr  entry (
        unsigned fixed bin(16),    /* datafile length                */
        unsigned fixed bin(16),    /* file type length               */
        unsigned fixed bin(16),    /* msgfile length                 */
        pointer,                   /* data file name                 */
        type @sqlu_media_list,     /* lobpaths                       */
        handle sqldcol,            /* dcoldata                       */
        handle sqlchar,            /* tcolstrg                       */
        pointer,                   /* filetype                       */
        handle sqlchar,            /* filetmod                       */
        pointer,                   /* message file name              */
        fixed bin(15),             /* caller action                  */
        handle sqluimpt_in,        /* input parms                    */
        handle sqluimpt_out,       /* output parms                   */
        pointer,                   /* nullind                        */
        pointer,                   /* reserved                       */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Import                         */
 dcl   sqlgimpt  entry (
        unsigned fixed bin(16),    /* message file name length       */
        unsigned fixed bin(16),    /* file type length               */
        unsigned fixed bin(16),    /* data file name length          */
        pointer,                   /* SQLCA                          */
        handle sqluimpt_out,       /* ptr to output parms            */
        handle sqluimpt_in,        /* ptr to input parms             */
        fixed bin(15),             /* caller action                  */
        pointer,                   /* message file name              */
        handle sqlchar,            /* file mode description          */
        pointer,                   /* file type                      */
        handle sqlchar,            /* ptr to table/column            */
        handle sqldcol,            /* ptr to column data             */
         pointer)                  /* data file name                 */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Load                           */
 dcl   sqlgload  entry (
        unsigned fixed bin(16),    /* file type length               */
        unsigned fixed bin(16),    /* message file length            */
        unsigned fixed bin(16),    /* remote file length             */
        type @sqlu_media_list,     /* data file name                 */
        type @sqlu_media_list,     /* lobpaths                       */
        handle sqldcol,            /* dcoldata                       */
        handle sqlchar,            /* tcolstrg                       */
        pointer,                   /* file type                      */
        handle sqlchar,            /* filetmod                       */
        pointer,                   /* message file name              */
        pointer,                   /* remote file name               */
        fixed bin(15),             /* caller action                  */
        handle sqluload_in,        /* input                          */
        handle sqluload_out,       /* output                         */
        type @sqlu_media_list,     /* work directory                 */
        type @sqlu_media_list,     /* copy target                    */
        pointer,                   /* null ind                       */
        pointer,                   /* reserved                       */
        pointer)                   /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Query                          */
 dcl   sqlgqry  entry (
        unsigned fixed bin(16),    /* lf_length                      */
        unsigned fixed bin(16),    /* rf_length                      */
        pointer,                   /* local file                     */
        pointer,                   /* remote file                    */
        pointer)               /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Reorganize Table               */
 dcl   sqlgreot  entry (
        unsigned fixed bin(16),    /* tablespace length              */
        unsigned fixed bin(16),    /* index name length              */
        unsigned fixed bin(16),    /* table name length              */
        pointer,                   /* SQLCA                          */
        pointer,                   /* tablespace                     */
        pointer,                   /* index name                     */
         pointer)                  /* table name                     */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Rollforward                    */
 dcl   sqlgrfwd  entry (
        unsigned fixed bin(16),    /* password length                */
        unsigned fixed bin(16),    /* userid length                  */
        unsigned fixed bin(16),    /* point in time length           */
        unsigned fixed bin(16),    /* database name length           */
        pointer,                   /* SQLCA                          */
        pointer,                   /* password                       */
        pointer,                   /* userid                         */
        pointer,                   /* last commit time               */
        pointer,                   /* last archive del               */
        pointer,                   /* first archive del              */
        pointer,                   /* next archive need              */
        pointer,                   /* point in time                  */
        unsigned fixed bin(16),    /* action                         */
         pointer)                  /* database name                  */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Run Statistics                 */
 dcl   sqlgstat  entry (
        unsigned fixed bin(16),    /* table name length              */
        unsigned fixed bin(16),    /* number of indices              */
        char,                      /* stats option                   */
        char,                      /* share level                    */
        pointer,                   /* index lengths                  */
        pointer,                   /* SQLCA                          */
        pointer,                   /* index list                     */
         pointer)                  /* table name                     */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Dereference Address            */
 dcl   sqlgdref  entry (
        unsigned fixed bin(31),    /* number of bytes to transfer    */
        pointer,                   /* target area for transfer       */
         pointer)                  /* source area for transfer       */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Copy Memory                    */
 dcl   sqlgmcpy  entry (
        pointer,                   /* area into which to move the    */
                                   /* data                           */
        pointer,                   /* area from which to move the    */
                                   /* data                           */
         unsigned fixed bin(31))   /* number of bytes to move        */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Return address                 */
 dcl   sqlgaddr  entry (
        pointer,                   /* variable                       */
         pointer)                  /* ptr to an area containing the  */
                                   /* address                        */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

 /* Configuration Utility Commands */

                                   /* Reset Database Manager         */
                                   /* Configuration                  */
 dcl   sqlfrsys  entry (
        pointer )                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Reset Database Configuration   */
 dcl   sqlfrdb  entry (
        pointer,                   /* database alias                 */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Update Database Manager        */
                                   /* Configuration                  */
 dcl   sqlfusys  entry (
        unsigned fixed bin(16),    /* count of entries being         */
                                   /* modified                       */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Update Database Configuration  */
 dcl   sqlfudb  entry (
        pointer,                   /* database alias                 */
        unsigned fixed bin(16),    /* count of entries being         */
                                   /* modified                       */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Database Manager           */
                                   /* Configuration                  */
 dcl   sqlfxsys  entry (
        unsigned fixed bin(16),    /* count of entries being         */
                                   /* returned                       */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Database Configuration     */
 dcl   sqlfxdb  entry (
        pointer,                   /* database alias                 */
        unsigned fixed bin(16),    /* count of entries being         */
                                   /* returned                       */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Database Manager           */
                                   /* Configuration Defaults         */
 dcl   sqlfdsys  entry (
        unsigned fixed bin(16),    /* count of items being returned  */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Database Configuration     */
                                   /* Defaults                       */
 dcl   sqlfddb  entry (
        pointer,                   /* database alias                 */
        unsigned fixed bin(16),    /* count of entries to return     */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Reset Database Manager         */
                                   /* Configuration                  */
 dcl   sqlgrsys  entry (
         pointer )                 /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Update Database Manager        */
                                   /* Configuration                  */
 dcl   sqlgusys  entry (
        unsigned fixed bin(16),    /* count of entries being         */
                                   /* modified                       */
        pointer,                   /* list of item lengths           */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Get Database Manager           */
                                   /* Configuration                  */
 dcl   sqlgxsys  entry (
        unsigned fixed bin(16),    /* count of entries being         */
                                   /* returned                       */
        handle sqlfupd,            /* list of items                  */
         pointer)                  /* SQLCA                          */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Single TableSpace Query   */
 dcl   sqlgstsq  entry (
        pointer,
        unsigned fixed bin(31),         /* in: tableSpace id         */
         handle SQLB_TBSQRY_DATA)       /* out: tableSpace data      */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Open TableSpace Query     */
 dcl   sqlgotsq  entry (
        pointer,
        unsigned fixed bin(31),         /* in: processing options:   */
                                        /* SQLB_TBS_OPEN_xxx         */
         pointer)                       /* out: # tablespaces        */
                                        /* defined in db             */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Fetch TableSpace Query    */
 dcl   sqlgftsq  entry (
        pointer,
        unsigned fixed bin(31),         /* size of output area       */
        handle SQLB_TBSQRY_DATA,        /* out: array of length      */
                                        /* maxTbs                    */
                                        /* out: #data entries        */
        pointer)                        /* returned                  */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Close TableSpace Query    */
 dcl   sqlgctsq  entry (
        pointer )
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* TableSpace Query          */
 dcl   sqlgtsq  entry (
        pointer,
        pointer,                        /* out: total number of      */
                                        /* table spaces              */
         handle SQLB_TBSQRY_DATA)       /* out: mem returned to      */
                                        /* application               */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Open Tablespace           */
                                        /* Container Query           */
 dcl   sqlgotcq  entry (
        pointer,
        unsigned fixed bin(31),         /* in: id tbs or SQLB_ALL    */
                                        /* TABLESPACES               */
         pointer)                       /* out:  output...the        */
                                        /* number of containers for  */
                                        /* the table space           */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Fetch Tablespace          */
                                        /* Container Query           */
 dcl   sqlgftcq  entry (
        pointer,
        unsigned fixed bin(31),         /* in:  max # entries to     */
                                        /* return in 'data'          */
        handle SQLB_TBSCONTQRY_DATA,    /* out: array of 'maxCont'   */
                                        /* entries                   */
         pointer)                       /* out: # data entries       */
                                        /* returned on this query    */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Close Tablespace          */
                                        /* Container Query           */
 dcl   sqlgctcq  entry (
        pointer )
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Tablespace Container      */
                                        /* Query                     */
 dcl   sqlgtcq  entry (
        pointer,
        unsigned fixed bin(31),         /* in: id a tbs or SQLB_ALL  */
                                        /* TABLESPACES               */
        pointer,                        /* out: # entries returned   */
        handle SQLB_TBSCONTQRY_DATA)
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Set TableSpace            */
                                        /* Containers                */
 dcl   sqlgstsc  entry (
        pointer,
        unsigned fixed bin(31),         /* in: processing options:   */
                                        /* SQLB_SET_CONT_xxx         */
        unsigned fixed bin(31),         /* in: table space which is  */
                                        /* to be changed             */
        unsigned fixed bin(31),         /* in:#containers in the     */
                                        /* list                      */
        handle SQLB_TBSCONTQRY_DATA)    /* container                */
                                        /* specifications            */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Get TableSpace            */
                                        /* Statistics                */
 dcl   sqlggtss  entry (
        pointer,
        unsigned fixed bin(31),
        handle SQLB_TBS_STATS)
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Get Authorizations        */
 dcl   sqlgauth  entry (
         pointer )                      /* SQLCA                     */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                        /* Get table authorizations  */
 dcl   sqlgtbau  entry (
        unsigned fixed bin(16),         /* table name length         */
        pointer,                        /* fully-qualified table     */
                                        /* name                      */
                  pointer)              /* SQLCA                     */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

 /* SQL Return Codes in SQLCODE for UTILITY/CONFIGURATION Commands */

 %dcl SQL_RC_OK char ext;
 %if SQL_RC_OK = '' %then
  %do;
 /* everything is ok                */
    %SQL_RC_OK = '0';
  %end;
 %dcl SQL_RC_INVALID_SQLCA char ext;
 %if SQL_RC_INVALID_SQLCA = '' %then
  %do;
                                  /* invalid sqlca                   */
 %dcl SQL_RC_INVALID_SQLCA char ext;
 %SQL_RC_INVALID_SQLCA = '-1';
  %end;

 /* ROLL FORWARD Return Codes - more in the 4900's              */

                                      /* Log Control file not        */
                                      /* found.                      */
 %dcl SQLU_RC_NOLFH char ext;
 %SQLU_RC_NOLFH = '-1258';
                                      /* I/O Error accessing LFH.    */
 %dcl SQLU_RC_IOELFH char ext;
 %SQLU_RC_IOELFH = '-1259';
                                      /* DB not enabled for Roll     */
                                      /* Fwd                         */
 %dcl SQLU_RC_RFNOTEN char ext;
 %SQLU_RC_RFNOTEN = '-1260';
                                      /* Roll Forward is not         */
                                      /* Pending                     */
 %dcl SQLU_RC_RFNOTP char ext;
 %SQLU_RC_RFNOTP = '-1261';
                                      /* Bad Point in Time           */
                                      /* specified                   */
 %dcl SQLU_RC_BADPIT char ext;
 %SQLU_RC_BADPIT = '-1262';
                                      /* Invalid Log Extent file     */
 %dcl SQLU_RC_INVEXT char ext;
 %SQLU_RC_INVEXT = '-1263';
                                      /* Log Extent file does not    */
                                      /* belong to DB                */
 %dcl SQLU_RC_NOTEXT char ext;
 %SQLU_RC_NOTEXT = '-1264';
                                      /* Log extent file is          */
                                      /* incorrect version           */
 %dcl SQLU_RC_IVREXT char ext;
 %SQLU_RC_IVREXT = '-1265';
                                      /* Time specified is before    */
                                      /* previous roll-forward time  */
 %dcl SQLU_RC_PRTIME char ext;
 %SQLU_RC_PRTIME = '-1266';
                                      /* User exit encountered an    */
                                      /* error (other than retry)    */
                                      /* while attempting to         */
                                      /* retrieve a log extent file  */
                                      /* for roll forward            */
 %dcl SQLU_RC_UEXIT_ERR char ext;
 %SQLU_RC_UEXIT_ERR = '-1268';
                                      /* Rollforward by tablespace   */
                                      /* in progress.                */
 %dcl SQLU_RC_RFINPRG char ext;
 %SQLU_RC_RFINPRG = '-1269';
                                      /* Roll forward complete but   */
                                      /* I/O errors encountered      */
 dcl SQLU_RC_RCVIOERR fixed bin(31) value(1271);
                                      /* Rollforward by tablespace   */
                                      /* has stopped.                */
 %dcl SQLU_RC_RFSTOP char ext;
 %SQLU_RC_RFSTOP = '-1272';
                                      /* Missing log extent file.    */
 %dcl SQLU_RC_MISSING_EXT char ext;
 %SQLU_RC_MISSING_EXT = '-1273';
                                      /* Invalid stop time for       */
                                      /* tablespace rollforward.     */
 %dcl SQLU_RC_INVTSP_STOPTIME char ext;
 %SQLU_RC_INVTSP_STOPTIME = '-1274';
                                      /* invalid stop time           */
                                      /* specified                   */
 %dcl SQLU_INVRFR_STOPTIME char ext;
 %SQLU_INVRFR_STOPTIME = '-1275';
                                      /* invalid time to issue a     */
 %dcl SQLU_INVRFR_STOP char ext;
                                      /* stop                        */
 %SQLU_INVRFR_STOP = '-1276';
                                      /* Restore found one or more   */
                                      /* containers are              */
                                      /* inaccessable                */
 dcl SQLUD_INACCESSABLE_CONTAINER fixed bin(31) value(1277);
                                      /* Restart complete but not    */
                                      /* all invalid  indexes were   */
                                      /* recreated                   */
 dcl SQL_RC_RECREATE_INDEXES fixed bin(31) value(1279);

                                      /* invalid client comm.        */
                                      /* protocols                   */
 %dcl SQLF_RC_INV_CLIENT_COMM char ext;
 %SQLF_RC_INV_CLIENT_COMM = '-1290';
                                      /* invalid directory services  */
                                      /* field                       */
 %dcl SQLF_RC_INV_DIR_FIELD char ext;
 %SQLF_RC_INV_DIR_FIELD = '-1296';

                                      /* hostname in node dir        */
                                      /* unknown                     */
 %dcl SQLCC_RC_UNKNOWN_HOST char ext;
 %SQLCC_RC_UNKNOWN_HOST = '-1336';
                                      /* service name in node        */
                                      /* directory is unknown        */
 %dcl SQLCC_RC_UNKNOWN_SERVICE char ext;
 %SQLCC_RC_UNKNOWN_SERVICE = '-1337';
                                      /* CPI-C symdestname is        */
                                      /* unknown                     */
 %dcl SQLCC_RC_UNKNOWN_SYM_DEST_NAME char ext;
 %SQLCC_RC_UNKNOWN_SYM_DEST_NAME = '-1338';
                                      /* wrkstn name (nname)         */
 %dcl SQLCC_RC_NNAME_NOTFOUND char ext;
 %SQLCC_RC_NNAME_NOTFOUND = '-1341';

 /* GENERAL UTILITY Return Codes */

                                      /* Invalid output drive        */
 %dcl SQLU_BAD_DRIVE char ext;
 %SQLU_BAD_DRIVE = '-2000';
                                      /* Backup terminated by user   */
 %dcl SQLU_USER_TERM char ext;
 %SQLU_USER_TERM = '-2001';
                                      /* database not local          */
 %dcl SQLU_NOT_LOCAL char ext;
 %SQLU_NOT_LOCAL = '-2002';
                                      /* base op system error        */
 %dcl SQLU_DOS_ERROR char ext;
 %SQLU_DOS_ERROR = '-2003';
                                      /* SQL error occurred          */
 %dcl SQLU_SQL_ERROR char ext;
 %SQLU_SQL_ERROR = '-2004';
                                      /* read wrong # of bytes       */
 %dcl SQLU_READ_ERROR char ext;
 %SQLU_READ_ERROR = '-2005';
                                      /* call out of sequence        */
 %dcl SQLU_INVALID_ACTION char ext;
 %SQLU_INVALID_ACTION = '-2008';
                                      /* insufficient memory         */
 %dcl SQLU_INSUFF_MEMORY char ext;
 %SQLU_INSUFF_MEMORY = '-2009';
                                      /* error in Start Using        */
 %dcl SQLU_STRD_ERROR char ext;
 %SQLU_STRD_ERROR = '-2010';
                                      /* error in Stop Using         */
 %dcl SQLU_STPD_ERROR char ext;
 %SQLU_STPD_ERROR = '-2011';
                                      /* directory Scan error        */
 %dcl SQLU_DIR_ERROR char ext;
 %SQLU_DIR_ERROR = '-2013';
                                      /* invalid database name       */
 %dcl SQLU_INVALID_DBNAME char ext;
 %SQLU_INVALID_DBNAME = '-2015';
                                      /* invalid path in             */
                                      /* environment                 */
 %dcl SQLU_INVALID_PATH char ext;
 %SQLU_INVALID_PATH = '-2016';
                                      /* Start Session failed        */
 %dcl SQLU_START_SESSION char ext;
 %SQLU_START_SESSION = '-2017';
                                      /* invalid authorizations      */
 %dcl SQLU_INVALID_AUTHS char ext;
 %SQLU_INVALID_AUTHS = '-2018';
                                      /* auto-binding failed         */
 %dcl SQLU_AUTOBIND char ext;
 %SQLU_AUTOBIND = '-2019';
                                      /* conflict after auto-bind    */
                                      /* control file                */
 %dcl SQLU_TIMESTAMP char ext;
 %SQLU_TIMESTAMP = '-2020';
                                      /* I/O error in accessing the  */
                                      /* log                         */
 %dcl SQLU_IO_ERROR_LFH char ext;
 %SQLU_IO_ERROR_LFH = '-2023';
                                      /* I/O error in accessing the  */
                                      /* Backup/Restore flag file    */
 %dcl SQLU_IO_ERROR_BRG char ext;
 %SQLU_IO_ERROR_BRG = '-2024';
                                      /* System I/O error occurred   */
 %dcl SQLU_IO_ERROR char ext;
 %SQLU_IO_ERROR = '-2025';
                                      /* error in PAUSE the started  */
                                      /* DB                          */
 %dcl SQLU_PAUSE_ERROR char ext;
 %SQLU_PAUSE_ERROR = '-2026';
                                      /* error in CONTINUE the       */
                                      /* stoped DB                   */
 %dcl SQLU_CONT_ERROR char ext;
 %SQLU_CONT_ERROR = '-2027';
                                      /* interruption installing     */
                                      /* error                       */
 %dcl SQLU_INT_INST_ERR char ext;
 %SQLU_INT_INST_ERR = '-2028';
                                      /* user exit returned non      */
                                      /* zero rc                     */
 %dcl SQLU_UEXIT_RC char ext;
 %SQLU_UEXIT_RC = '-2029';

                                      /* warning to mount tape       */
 dcl SQLU_FIRST_TAPE_WARNING fixed bin(31) value(2031);
                                      /* parameter to utility        */
                                      /* incorrect                   */
 %dcl SQLU_INVALID_PARM char ext;
 %SQLU_INVALID_PARM = '-2032';
                                      /* ADSM reported error         */
 %dcl SQLU_ADSM_ERROR char ext;
 %SQLU_ADSM_ERROR = '-2033';
                                      /* address of parameter        */
                                      /* incorrect                   */
 %dcl SQLU_INVALID_PARM_ADDRESS char ext;
 %SQLU_INVALID_PARM_ADDRESS = '-2034';
                                      /* error during nointerrupt    */
                                      /* action                      */
 %dcl SQLU_NOINT_ERROR char ext;
 %SQLU_NOINT_ERROR = '-2035';
                                      /* directory does not exist    */
 %dcl SQLU_PATH_ERROR char ext;
 %SQLU_PATH_ERROR = '-2036';
                                      /* unable to load ADSM         */
 %dcl SQLU_LOAD_ADSM_ERROR char ext;
 %SQLU_LOAD_ADSM_ERROR = '-2037';
                                      /* database system error       */
 %dcl SQLU_DBSYSTEM_ERROR char ext;
 %SQLU_DBSYSTEM_ERROR = '-2038';
                                      /* application terminated      */
 %dcl SQLU_NO_APP_ERROR char ext;
 %SQLU_NO_APP_ERROR = '-2039';
                                      /* alias parameter error       */
 %dcl SQLU_ALIAS_ERROR char ext;
 %SQLU_ALIAS_ERROR = '-2040';
                                      /* buff_size parameter error   */
 %dcl SQLU_BUFFSIZE_ERROR char ext;
 %SQLU_BUFFSIZE_ERROR = '-2041';
                                      /* I/O error during change     */
                                      /* tape                        */
 dcl SQLU_IO_WARNING fixed bin(31) value(2042);
                                      /* Spawn child process error   */
 %dcl SQLU_SPAWN_EDU_ERROR char ext;
 %SQLU_SPAWN_EDU_ERROR = '-2043';
                                      /* Message queue error         */
 %dcl SQLU_QUEUE_ERROR char ext;
 %SQLU_QUEUE_ERROR = '-2044';
                                      /* Object access error         */
 %dcl SQLU_OBJECT_ACCESS_ERROR char ext;
 %SQLU_OBJECT_ACCESS_ERROR = '-2048';
                                      /* Bad backup image            */
 %dcl SQLU_CORRUPT_IMAGE_ERROR char ext;
 %SQLU_CORRUPT_IMAGE_ERROR = '-2054';
                                      /* Unable to access memory     */
                                      /* set                         */
 %dcl SQLU_MEMORY_ACCESS_ERROR char ext;
 %SQLU_MEMORY_ACCESS_ERROR = '-2055';
                                      /* device path point to        */
                                      /* unknown device type         */
 %dcl SQLU_UNKNOWN_MEDIA_TYPE char ext;
 %SQLU_UNKNOWN_MEDIA_TYPE = '-2056';
                                      /* device or file already      */
                                      /* opened by other process     */
 %dcl SQLU_MEDIA_CANNOT_BE_SHARED char ext;
 %SQLU_MEDIA_CANNOT_BE_SHARED = '-2057';
                                      /* End of tape or file         */
                                      /* encountered during read     */
 dcl SQLU_END_OF_MEDIA_WARNING fixed bin(31) value(2058);
                                      /* Device is full during       */
                                      /* write                       */
 dcl SQLU_DEVICE_FULL_WARNING fixed bin(31) value(2059);
                                      /* Empty device or file not    */
                                      /* found during read           */
 dcl SQLU_MEDIA_EMPTY_WARNING fixed bin(31) value(2060);
                                      /* Access denied due to        */
                                      /* authority level             */
 %dcl SQLU_MEDIA_ACCESS_DENIED char ext;
 %SQLU_MEDIA_ACCESS_DENIED = '-2061';
                                      /* Access error                */
 %dcl SQLU_MEDIA_ACCESS_ERROR char ext;
 %SQLU_MEDIA_ACCESS_ERROR = '-2062';
                                      /* Terminate last Media IO.    */
 dcl SQLU_TERM_LAST_MEDIA_WARNING fixed bin(31) value(2065);
                                      /* Invalid tablespace name     */
 %dcl SQLU_BAD_TABLESPACE_NAME char ext;
 %SQLU_BAD_TABLESPACE_NAME = '-2066';
                                      /* Could not locate media      */
                                      /* header in backup or copy    */
                                      /* image                       */
 %dcl SQLU_NO_MEDIA_HEADER char ext;
 %SQLU_NO_MEDIA_HEADER = '-2068';
                                      /* Mismatch alias name from    */
                                      /* media                       */
 %dcl SQLU_INCORRECT_DBALIAS char ext;
 %SQLU_INCORRECT_DBALIAS = '-2069';
                                      /* Mismatch timestamp read     */
                                      /* from media                  */
 %dcl SQLU_INCORRECT_TIMESTAMP char ext;
 %SQLU_INCORRECT_TIMESTAMP = '-2070';

                                      /* Shared library access       */
                                      /* error                       */
 %dcl SQLU_SHR_LIB_ACCESS_ERROR char ext;
 %SQLU_SHR_LIB_ACCESS_ERROR = '-2071';
                                      /* Bind shared library error   */
 %dcl SQLU_BIND_SHR_LIB_ERROR char ext;
 %SQLU_BIND_SHR_LIB_ERROR = '-2072';

                                      /* Out of sequence tablespace  */
                                      /* restore                     */
 %dcl SQLUD_TSP_RESTORE_OUT_OF_SEQ char ext;
 %SQLUD_TSP_RESTORE_OUT_OF_SEQ = '-2154';

 /* HISTORY TABLE Return Codes */
                                      /* Changes were made to        */
                                      /* historyfile during update.  */
 dcl SQLUH_SCAN_UPDATED_WARNING fixed bin(31) value(2155);
                                      /* MAX # open scans exceeded   */
 %dcl SQLUH_MAX_SCANS_EXCEEDED char ext;
                                      /* History file fixed          */
 %SQLUH_MAX_SCANS_EXCEEDED = '-2157';
 dcl SQLUH_FILE_REPLACED_WARNING fixed bin(31) value(2160);
                                      /* History file is unfixable   */
 %dcl SQLUH_DAMAGED_FILE char ext;
                                      /* number of tablespaces       */
                                      /* changed                     */
 %SQLUH_DAMAGED_FILE = '-2161';
 dcl SQLUH_SQLUHINFO_VARS_WARNING fixed bin(31) value(2165);
                                      /* Entry not found on update   */
 %dcl SQLUH_ENTRY_NOT_FOUND char ext;
 %SQLUH_ENTRY_NOT_FOUND = '-2171';

 /* REORGANIZE TABLE Return Codes */
                                      /* invalid authid on index     */
                                      /* name                        */
 %dcl SQLUR_INVALID_AUTHID char ext;
 %SQLUR_INVALID_AUTHID = '-2200';
                                      /* invalid tablename syntax    */
 %dcl SQLUR_INVALID_TABLENAME char ext;
 %SQLUR_INVALID_TABLENAME = '-2203';
                                      /* invalid tablename syntax    */
 %dcl SQLUR_INVALID_INDEXNAME char ext;
 %SQLUR_INVALID_INDEXNAME = '-2204';
                                      /* index doesn't exist         */
 %dcl SQLUR_INDEX_NOT_FOUND char ext;
 %SQLUR_INDEX_NOT_FOUND = '-2205';
                                      /* invalid filepath pointer    */
 %dcl SQLUR_INVALID_FILEPATH char ext;
 %SQLUR_INVALID_FILEPATH = '-2207';
                                      /* invalid tablespace pointer  */
 %dcl SQLUR_INVALID_TABLESPACE char ext;
 %SQLUR_INVALID_TABLESPACE = '-2208';
                                      /* table does not exist        */
 %dcl SQLUR_TABLE_NOT_FOUND char ext;
 %SQLUR_TABLE_NOT_FOUND = '-2211';
                                      /* cannot reorg a view         */
 %dcl SQLUR_VIEW_ERROR char ext;
 %SQLUR_VIEW_ERROR = '-2212';
                                      /* Incorrect tablespace type   */
 %dcl SQLUR_INCORRECT_TABLESPACE char ext;
 %SQLUR_INCORRECT_TABLESPACE = '-2213';
                                      /* insuffic authority          */
 %dcl SQLUR_INSAUTH char ext;
 %SQLUR_INSAUTH = '-2214';
                                      /* SQL error commiting prev    */
                                      /* work                        */
 %dcl SQLUR_SQLERR_COMPREV char ext;
 %SQLUR_SQLERR_COMPREV = '-2215';
                                      /* SQL error during            */
                                      /* reorganization              */
 %dcl SQLUR_SQLERR_REORG char ext;
 %SQLUR_SQLERR_REORG = '-2216';

 /* RUN STATISTICS Return Codes */
                                      /* invalid authid              */
 %dcl SQLUS_INVALID_AUTHID char ext;
 %SQLUS_INVALID_AUTHID = '-2300';
                                      /* invalid table name          */
 %dcl SQLUS_INVALID_TABLE_NAME char ext;
 %SQLUS_INVALID_TABLE_NAME = '-2301';
                                      /* invalid index pointer       */
 %dcl SQLUS_INVALID_INDEX_LIST char ext;
 %SQLUS_INVALID_INDEX_LIST = '-2302';
                                      /* statsopt parameter invalid  */
 %dcl SQLUS_INVALID_STATS_OPT char ext;
 %SQLUS_INVALID_STATS_OPT = '-2303';
                                      /* sharelev parameter invalid  */
 %dcl SQLUS_INVALID_SHARE_LEV char ext;
 %SQLUS_INVALID_SHARE_LEV = '-2304';
                                      /* table specified is a view   */
 %dcl SQLUS_VIEWS_NOT_ALLOWED char ext;
 %SQLUS_VIEWS_NOT_ALLOWED = '-2305';
                                      /* object doesn't exist        */
 %dcl SQLUS_OBJ_DOES_NOT_EXIST char ext;
 %SQLUS_OBJ_DOES_NOT_EXIST = '-2306';
                                      /* system table not allowed    */
 %dcl SQLUS_SYS_TABLE_NOT_ALLOWED char ext;
 %SQLUS_SYS_TABLE_NOT_ALLOWED = '-2307';
                                      /* index authid invalid        */
 %dcl SQLUS_INVALID_INDEX_AUTHID char ext;
 %SQLUS_INVALID_INDEX_AUTHID = '-2308';
                                      /* index name invalid          */
 %dcl SQLUS_INVALID_INDEX_NAME char ext;
 %SQLUS_INVALID_INDEX_NAME = '-2309';
                                      /* error running statistics    */
 %dcl SQLUS_ERROR_STAT char ext;
 %SQLUS_ERROR_STAT = '-2310';
                                      /* insuffic authority for      */
                                      /* runstats                    */
 %dcl SQLUS_INSAUTH char ext;
 %SQLUS_INSAUTH = '-2311';
                                      /* statistics heap is too      */
                                      /* small                       */
 %dcl SQLUS_STATS_HEAP_TOO_SMALL char ext;
 %SQLUS_STATS_HEAP_TOO_SMALL = '-2312';
                                      /* incomplete statistics       */
                                      /* collected                   */
 dcl SQLUS_PARTIAL_SUCCESS fixed bin(31) value(2313);

                                      /* Rst DB turn off roll fwd    */
                                      /* pend, old OS/2 API only     */
 dcl SQLUD_RST_NOROLLFWD fixed bin(31) value(3);
 /* Old OS/2 Backup calling action values */
                                      /* backup entire database      */
 dcl SQLU_BACK_ALL fixed bin(15) value('0'xn);
                                      /* backup changes only         */
 dcl SQLU_BACK_CHANGES fixed bin(15) value('1'xn);
                                      /* quiesce during backup       */
 dcl SQLU_BACK_QUIESCE fixed bin(15) value('800'xn);
                                      /* New UOW return error immed  */
 dcl SQLU_NEW_UOW_RETURN_ERROR fixed bin(15) value('400'xn);

                                      /* pause or Continue or        */
                                      /* migration error             */
 %dcl SQLU_DBM_ERROR char ext;
 %SQLU_DBM_ERROR = '-2014';
                                      /* Wrong diskette inserted     */
 %dcl SQLU_WRONG_DISKETTE char ext;
 %SQLU_WRONG_DISKETTE = '-2021';
                                      /* a specific fixed disk is    */
                                      /* full                        */
 %dcl SQLU_DISK_FULL char ext;
 %SQLU_DISK_FULL = '-2030';
                                      /* invalid type                */

 %dcl SQLUB_BAD_TYPE char ext;
 %SQLUB_BAD_TYPE = '-2400';
                                      /* type must be database       */
 %dcl SQLUB_TYPE_MUSTBE_DB char ext;
 %SQLUB_TYPE_MUSTBE_DB = '-2401';
                                      /* insufficient auth for       */
                                      /* backup                      */
 %dcl SQLUB_USER_NOT_AUTH char ext;
 %SQLUB_USER_NOT_AUTH = '-2403';
                                      /* The target disk/diskette    */
                                      /* is full                     */
 %dcl SQLUB_MEDIA_FULL char ext;
 %SQLUB_MEDIA_FULL = '-2404';
                                      /* The Backup can't run        */
                                      /* because B/R flag file       */
                                      /* existed and read I/O error  */
                                      /* occurred                    */
 %dcl SQLUB_BR_INPROG char ext;
 %SQLUB_BR_INPROG = '-2407';
                                      /* Backup process is           */
                                      /* successful, but unable to   */
                                      /* delete BRG file             */
 dcl SQLUB_DEL_BRG_ERR fixed bin(31) value(2408);
                                      /* 'change-only' is only       */
                                      /* applied to the most recent  */
                                      /* base image                  */
 %dcl SQLUB_WRONG_BASE_IMAGE char ext;
 %SQLUB_WRONG_BASE_IMAGE = '-2409';
                                      /* change only, backup not     */
                                      /* allowed to user exit        */
 %dcl SQLUB_NO_CHG_NSD char ext;
 %SQLUB_NO_CHG_NSD = '-2410';
                                      /* I/O error during backup     */
 %dcl SQLUB_IO_ERROR char ext;
 %SQLUB_IO_ERROR = '-2411';
                                      /* Restore utility not bound   */
 dcl SQLUD_BIND_WARNING fixed bin(31) value(2507);
                                      /* error dropping database     */
 %dcl SQLUD_DROP_ERROR char ext;
 %SQLUD_DROP_ERROR = '-2511';

 /* BACKUP Return Codes */
                                      /* The backup can't run        */
                                      /* because the Restore is in   */
                                      /* progress                    */
 %dcl SQLUB_RST_IN_PROG char ext;
 %SQLUB_RST_IN_PROG = '-2405';
                                      /* The Backup can't run        */
                                      /* because roll forward is     */
                                      /* pending                     */
 %dcl SQLUB_ROLLFWD_PENDING char ext;
 %SQLUB_ROLLFWD_PENDING = '-2406';
                                      /* data page encountered       */
                                      /* during backup is corrupted  */
 %dcl SQLUB_CORRUPT_PAGE char ext;
 %SQLUB_CORRUPT_PAGE = '-2412';
                                      /* retain req'd for online     */
                                      /* backup                      */
 %dcl SQLUB_LOGRETAIN_ONLINE_ERROR char ext;
 %SQLUB_LOGRETAIN_ONLINE_ERROR = '-2413';
                                      /* no space for control info   */
 dcl SQLUB_INSUF_SPACE_WARNING fixed bin(31) value(2414);
                                      /* tape full, mount another    */
 dcl SQLUB_NEXT_TAPE_WARNING fixed bin(31) value(2416);
                                      /* database does not exist     */
 %dcl SQLUB_DBASE_DOES_NOT_EXIST char ext;
 %SQLUB_DBASE_DOES_NOT_EXIST = '-2418';
                                      /* disk full during backup     */
 %dcl SQLUB_DISK_FULL_ERROR char ext;
 %SQLUB_DISK_FULL_ERROR = '-2419';

                                      /* first tape cannot hold      */
                                      /* header                      */
 %dcl SQLUB_FIRST_TAPE_ERROR char ext;
 %SQLUB_FIRST_TAPE_ERROR = '-2420';
                                      /* retain req'd for tbs        */
                                      /* backup                      */
 %dcl SQLUB_LOGRETAIN_TBS_ERROR char ext;
 %SQLUB_LOGRETAIN_TBS_ERROR = '-2421';
                                      /* the backup API used does    */
                                      /* not support this format of  */
                                      /* database                    */
 %dcl SQLUB_DB_UNSUPPORTED_BY_API char ext;
 %SQLUB_DB_UNSUPPORTED_BY_API = '-2422';
                                      /* A required index is         */
                                      /* missing during an offline   */
                                      /* backup                      */
 %dcl SQLUB_MISSING_INDEX char ext;
 %SQLUB_MISSING_INDEX = '-2423';

 /* RESTORE Return Codes */
                                      /* can't read restored         */
                                      /* database                    */
 %dcl SQLUD_CANNOT_RESTORE char ext;
 %SQLUD_CANNOT_RESTORE = '-2501';
                                      /* error reading backup        */
                                      /* diskette                    */
 %dcl SQLUD_DISKETTE_ERROR char ext;
 %SQLUD_DISKETTE_ERROR = '-2502';
                                      /* wrong backup diskette       */
 %dcl SQLUD_WRONG_DATABASE char ext;
 %SQLUD_WRONG_DATABASE = '-2503';
                                      /* prompt for backup diskette  */
 dcl SQLUD_DISKETTE_PROMPT fixed bin(31) value(2504);
                                      /* warn that drop will be      */
                                      /* done                        */
 dcl SQLUD_DROP_WARNING fixed bin(31) value(2505);
                                      /* Restore worked, but not     */
                                      /* cleanup                     */
 dcl SQLUD_DATABASE_WARNING fixed bin(31) value(2506);
                                      /* timestamp incorrectly       */
                                      /* specified                   */
 %dcl SQLUD_INVALID_TIMESTAMP char ext;
 %SQLUD_INVALID_TIMESTAMP = '-2508';
                                      /* invalid database drive      */
 %dcl SQLUD_INVALID_DBDRV char ext;
 %SQLUD_INVALID_DBDRV = '-2509';
                                      /* semaphore error             */
 %dcl SQLUD_SEM_ERROR char ext;
 %SQLUD_SEM_ERROR = '-2510';
                                      /* error creating database     */
 %dcl SQLUD_CREATE_ERROR char ext;
 %SQLUD_CREATE_ERROR = '-2512';
                                      /* error renaming database     */
 %dcl SQLUD_REN_ERROR char ext;
 %SQLUD_REN_ERROR = '-2513';
                                      /* restored database wrong     */
                                      /* version                     */
 %dcl SQLUD_BAD_VERSION char ext;
 %SQLUD_BAD_VERSION = '-2514';
                                      /* insuffic authority to       */
                                      /* restore                     */
 %dcl SQLUD_INSAUTH char ext;
 %SQLUD_INSAUTH = '-2515';
                                      /* a database active           */
 %dcl SQLUD_DBACT char ext;
                                      /* database migrated           */
 %SQLUD_DBACT = '-2516';
 dcl SQLUD_MIGRATED fixed bin(31) value(2517);
                                      /* error in restoring DB       */
                                      /* config.                     */
 %dcl SQLUD_RST_DBCONG_ERR char ext;
 %SQLUD_RST_DBCONG_ERR = '-2518';
                                      /* error in migrating the      */
                                      /* database                    */
 %dcl SQLUD_MIGRATE_ERROR char ext;
 %SQLUD_MIGRATE_ERROR = '-2519';
                                      /* DBCON file is restored      */
                                      /* using the backup version    */
 dcl SQLUD_DBCON_WARN fixed bin(31) value(2520);
                                      /* Restore process is          */
                                      /* successful, but unable to   */
                                      /* delete BRG file             */
 dcl SQLUD_DEL_BRG_ERR fixed bin(31) value(2521);
 %dcl SQLUD_TOO_MANY_BACKUP_FILES char ext;
                                      /* more than one file match    */
 %SQLUD_TOO_MANY_BACKUP_FILES = '-2522';
 %dcl SQLUD_MEDIA_CORRUPT char ext;
                                      /* corrupted backup image      */
 %SQLUD_MEDIA_CORRUPT = '-2530';
 %dcl SQLUD_WRGIMAGE_ERROR char ext;
                                      /* image of wrong database     */
 %SQLUD_WRGIMAGE_ERROR = '-2532';
                                      /* image of wrong database     */
 dcl SQLUD_WRGIMAGE_WARNING fixed bin(31) value(2533);
                                      /* seq number of backup        */
                                      /* incorrect                   */
 dcl SQLUD_WRONGSEQ_WARNING fixed bin(31) value(2536);
 %dcl SQLUD_MUST_ROLLFWD char ext;
                                      /* roll forward required       */
 %SQLUD_MUST_ROLLFWD = '-2537';
                                      /* end of file reached         */
                                      /* unexpectedly                */
 %dcl SQLUD_UNEXPECT_EOF_ERROR char ext;
 %SQLUD_UNEXPECT_EOF_ERROR = '-2538';
                                      /* noint type restore had      */
                                      /* warning                     */
 dcl SQLUD_NOINT_WARNING fixed bin(31) value(2540);
                                      /* unable to close backup      */
                                      /* file                        */
 dcl SQLUD_CLOSE_MEDIA_WARNING fixed bin(31) value(2541);
                                      /* no backup file match found  */
 %dcl SQLUD_NO_BACKUP_FILE_MATCH char ext;
 %SQLUD_NO_BACKUP_FILE_MATCH = '-2542';
                                      /* invalid directory for new   */
                                      /* dbase                       */
 %dcl SQLUD_DB_DIR_ERROR char ext;
 %SQLUD_DB_DIR_ERROR = '-2543';
                                      /* disk full during restore    */
 %dcl SQLUD_DISK_FULL_ERROR char ext;
 %SQLUD_DISK_FULL_ERROR = '-2544';
                                      /* restore requires first      */
                                      /* image first                 */
 %dcl SQLUD_NOT_FIRST_IMAGE char ext;
 %SQLUD_NOT_FIRST_IMAGE = '-2546';
                                      /* cannot restore online       */
                                      /* backup from a previous      */
                                      /* release                     */
 %dcl SQLUD_OLD_ONLINE_IMAGE_ERROR char ext;
 %SQLUD_OLD_ONLINE_IMAGE_ERROR = '-2547';
                                      /* backup has diff codepage    */
                                      /* from disk DB                */
 %dcl SQLUD_IMAGE_DB_CP_MISMATCH char ext;
 %SQLUD_IMAGE_DB_CP_MISMATCH = '-2548';

 /********************************************************************/
 /**  the meaning of the following 8 warnings :                      */
 /**        A -> database alias                                      */
 /**        N -> database name                                       */
 /**        S -> database seed                                       */
 /**        0 -> target db value DOES NOT matches backup image value */
 /**        1 -> target db value matches backup image value          */
 /**                                                                 */
 /********************************************************************/
 dcl SQLUD_A0N0S0_WARNING fixed bin(31) value(2529);
 dcl SQLUD_A0N0S1_WARNING fixed bin(31) value(2528);
 dcl SQLUD_A0N1S0_WARNING fixed bin(31) value(2525);
 dcl SQLUD_A0N1S1_WARNING fixed bin(31) value(2524);
 dcl SQLUD_A1N0S0_WARNING fixed bin(31) value(2527);
 dcl SQLUD_A1N0S1_WARNING fixed bin(31) value(2526);
 dcl SQLUD_A1N1S0_WARNING fixed bin(31) value(2523);
 dcl SQLUD_A1N1S1_WARNING fixed bin(31) value(2539);
                                      /* restore tablespace to a     */
                                      /* non original database.      */
 %dcl SQLUD_TBLSP_TO_OTHER_DB char ext;
 %SQLUD_TBLSP_TO_OTHER_DB = '-2560';
                                      /* restore tablespace to a     */
                                      /* new data base.              */
 dcl SQLUD_TBLSP_TO_NEW_DB fixed bin(31) value(2561);
                                      /* restore tablespace from     */
                                      /* full backup image.          */
 %dcl SQLUD_TBLSP_FR_FULL_BKUP char ext;
 %SQLUD_TBLSP_FR_FULL_BKUP = '-2562';
                                      /* Not all tablespases were    */
                                      /* restored                    */
 dcl SQLUD_NOTALL_TBS_RESTORED fixed bin(31) value(2563);
                                      /* Mismatch between restore    */
                                      /* image and database          */
                                      /* restored to                 */
 dcl SQLUD_DB_MISMATCH fixed bin(31) value(2565);
                                      /* Problem on first media      */
                                      /* write                       */
 dcl SQLU_HEADER_WRITE_ERR fixed bin(31) value(2045);

 /* sqlgadau and sqluadau Return codes */
                                      /* sql_authorizations parm is  */
                                      /* bad                         */
 %dcl SQLUA_BAD_INPUT_PARAMETER char ext;
 %SQLUA_BAD_INPUT_PARAMETER = '-2600';

 /* Asynchronous Read Log SQLCODES */
                                      /* invalid parameter(s)        */
                                      /* detected                    */
 %dcl SQLU_RLOG_INVALID_PARM char ext;
 %SQLU_RLOG_INVALID_PARM = '-2650';
                                      /* database has circular logs  */
 %dcl SQLU_RLOG_DB_NOT_READABLE char ext;
 %SQLU_RLOG_DB_NOT_READABLE = '-2651';
                                      /* insufficient memory for     */
                                      /* internal buffer             */
 %dcl SQLU_RLOG_INSUFF_MEMORY char ext;
 %SQLU_RLOG_INSUFF_MEMORY = '-2652';
                                      /* log sequence numbers        */
                                      /* reused                      */
 dcl SQLU_RLOG_LSNS_REUSED fixed bin(31) value(2653);
                                      /* read to end of database     */
                                      /* log                         */
 dcl SQLU_RLOG_READ_TO_CURRENT fixed bin(31) value(2654);
                                      /* log extent not for this     */
                                      /* database                    */
 %dcl SQLU_RLOG_EXTDB_INCORRECT char ext;
 %SQLU_RLOG_EXTDB_INCORRECT = '-2655';
                                      /* invalid extent encountered  */
 %dcl SQLU_RLOG_INVALID_EXTENT char ext;
 %SQLU_RLOG_INVALID_EXTENT = '-2656';
                                      /* log reader requires an      */
                                      /* extent not in the log path  */
 %dcl SQLU_RLOG_EXTENT_REQUIRED char ext;
 %SQLU_RLOG_EXTENT_REQUIRED = '-2657';

 /* IMPORT/EXPORT Return codes */
                                      /* error opening output file   */
 %dcl SQLUE_DFO char ext;
 %SQLUE_DFO = '-3001';
                                      /* i/o error writing output    */
                                      /* file                        */
 %dcl SQLUE_IOE char ext;
 %SQLUE_IOE = '-3002';
                                      /* i/o error closing output    */
                                      /* file                        */
 %dcl SQLUE_CLS char ext;
 %SQLUE_CLS = '-3003';
                                      /* invalid filetype parameter  */
 %dcl SQLUE_IFT char ext;
 %SQLUE_IFT = '-3004';
                                      /* function interrupted        */
 %dcl SQLUE_CBI char ext;
 %SQLUE_CBI = '-3005';
                                      /* i/o error opening message   */
                                      /* file                        */
 %dcl SQLUE_MFO char ext;
 %SQLUE_MFO = '-3006';
                                      /* i/o error writing message   */
                                      /* file                        */
 %dcl SQLUE_MFW char ext;
 %SQLUE_MFW = '-3007';
                                      /* start using database        */
                                      /* failed                      */
 %dcl SQLUE_STA char ext;
 %SQLUE_STA = '-3008';
                                      /* invalid tcolstrg            */
 %dcl SQLUE_STR char ext;
 %SQLUE_STR = '-3009';
                                      /* invalid dcoldata            */
 %dcl SQLUE_COL char ext;
 %SQLUE_COL = '-3010';

                                      /* memory allocation error     */
 %dcl SQLUE_MEM char ext;
 %SQLUE_MEM = '-3011';
                                      /* system error                */
 %dcl SQLUE_SYSERR char ext;
 %SQLUE_SYSERR = '-3012';
                                      /* invalid filetmod            */
 %dcl SQLUE_FTMOD char ext;
 %SQLUE_FTMOD = '-3013';
                                      /* failure on closing message  */
                                      /* file                        */
 %dcl SQLUE_MFC char ext;
 %SQLUE_MFC = '-3014';
                                      /* SQL error occurred          */
 %dcl SQLUE_SQLERR char ext;
 %SQLUE_SQLERR = '-3015';
                                      /* no keywords found           */
 %dcl SQLUE_FMODNK char ext;
 %SQLUE_FMODNK = '-3016';
                                      /* invalid delimiter or        */
                                      /* duplicate                   */
 %dcl SQLUE_FMODID char ext;
 %SQLUE_FMODID = '-3017';
                                      /* decimal used for char       */
                                      /* delimiter                   */
 %dcl SQLUE_FMODDEC char ext;
 %SQLUE_FMODDEC = '-3018';
                                      /* no tcolstrg                 */
 %dcl SQLUE_NTS char ext;
 %SQLUE_NTS = '-3019';
                                      /* insufficient authority for  */
                                      /* exp.                        */
 %dcl SQLUE_RC_INSAUTH char ext;
 %SQLUE_RC_INSAUTH = '-3020';

                                      /* insufficient authority for  */
                                      /* imp.                        */
 %dcl SQLUI_RC_INSAUTH char ext;
 %SQLUI_RC_INSAUTH = '-3021';
                                      /* SQL error on input string   */
 %dcl SQLUE_SQL_PREP_ERR char ext;
 %SQLUE_SQL_PREP_ERR = '-3022';
                                      /* invalid database name       */
 %dcl SQLUE_DATABASE char ext;
 %SQLUE_DATABASE = '-3023';
                                      /* invalid datafile            */
 %dcl SQLUE_DATAFILE char ext;
 %SQLUE_DATAFILE = '-3025';
                                      /* invalid msgfile             */
 %dcl SQLUE_MSGFILE char ext;
 %SQLUE_MSGFILE = '-3026';
                                      /* Export method indicator     */
                                      /* not n/d                     */
 %dcl SQLUE_DCOLMETH char ext;
 %SQLUE_DCOLMETH = '-3028';
                                      /* filetype is null            */
 %dcl SQLUE_NUL_FTYPE char ext;
 %SQLUE_NUL_FTYPE = '-3029';

                                      /* error opening input data    */
                                      /* file                        */
 %dcl SQLUI_DFO char ext;
 %SQLUI_DFO = '-3030';
                                      /* i/o error reading input     */
                                      /* file                        */
 %dcl SQLUI_IOE char ext;
 %SQLUI_IOE = '-3031';
                                      /* Import method not n/d/p     */
 %dcl SQLUI_DCOLMETH char ext;
 %SQLUI_DCOLMETH = '-3032';
                                      /* invalid insert in tcolstrg  */
 %dcl SQLUI_TINSERT char ext;
 %SQLUI_TINSERT = '-3033';
                                      /* invalid into in tcolstrg    */
 %dcl SQLUI_TINTO char ext;
 %SQLUI_TINTO = '-3034';
                                      /* invalid tablename in        */
                                      /* tcolstrg                    */
 %dcl SQLUI_TABLENAME char ext;
 %SQLUI_TABLENAME = '-3035';
                                      /* close paren not in          */
                                      /* tcolstrg                    */
 %dcl SQLUI_CPAREN char ext;
 %SQLUI_CPAREN = '-3036';
                                      /* SQL error on insert string  */
 %dcl SQLUE_SQL_PREP_INSERT char ext;
 %SQLUE_SQL_PREP_INSERT = '-3037';
                                      /* tcolstrg invalid            */
 %dcl SQLUI_TCOLJUNK char ext;
 %SQLUI_TCOLJUNK = '-3038';
                                      /* lob file error              */
 %dcl SQLUE_LOBFILE_ERROR char ext;
 %SQLUE_LOBFILE_ERROR = '-3040';

                                      /* invalid dcol position for   */
                                      /* CSV                         */
 %dcl SQLUIC_BAD_DCOL_POS char ext;
 %SQLUIC_BAD_DCOL_POS = '-3045';
                                      /* non-default dcol and no     */
                                      /* cols                        */
 %dcl SQLUI_NONDEF_DCOL_NOCOLS char ext;
 %SQLUI_NONDEF_DCOL_NOCOLS = '-3046';
                                      /* dcolinfo has invalid        */
                                      /* method                      */
 %dcl SQLUI_BAD_DCOL_METH char ext;
 %SQLUI_BAD_DCOL_METH = '-3047';
                                      /* non nullable column         */
 %dcl SQLUI_NODCOL_FOR_NONNULL_DBCOL char ext;
 %SQLUI_NODCOL_FOR_NONNULL_DBCOL = '-3048';
                                      /* unsupported column type     */
 %dcl SQLUIC_UNSUPTYP_NONULLS char ext;
 %SQLUIC_UNSUPTYP_NONULLS = '-3049';

                                      /* conversion for cdpg         */
 dcl SQLUII_CONVERSION fixed bin(31) value(3050);
                                      /* too many rows for WSF       */
                                      /* export                      */
 %dcl SQLUE_ROWCT_TOOBIG char ext;
 %SQLUE_ROWCT_TOOBIG = '-3053';
                                      /* eof reading first rec in    */
                                      /* IXF                         */
 %dcl SQLUII_HEOF char ext;
 %SQLUII_HEOF = '-3054';
                                      /* length of 'H' rec not       */
                                      /* numeric                     */
 %dcl SQLUII_HLEN_CONV char ext;
 %SQLUII_HLEN_CONV = '-3055';
                                      /* first record too short      */
 %dcl SQLUII_HLEN_SHORT char ext;
 %SQLUII_HLEN_SHORT = '-3056';
                                      /* first IXF rec is not 'H'    */
 %dcl SQLUII_HTYP char ext;
 %SQLUII_HTYP = '-3057';
                                      /* no IXF identifier in 'H'    */
 %dcl SQLUII_HID char ext;
 %SQLUII_HID = '-3058';
                                      /* invalid version field in    */
                                      /* 'H'                         */
 %dcl SQLUII_HVERS char ext;
 %SQLUII_HVERS = '-3059';

                                      /* HCNT in 'H' not numeric     */
 %dcl SQLUII_HCNT char ext;
 %SQLUII_HCNT = '-3060';
                                      /* SBCP in 'H' not numeric     */
 %dcl SQLUII_HSBCP_BAD char ext;
 %SQLUII_HSBCP_BAD = '-3061';
                                      /* DBCP in 'H' not numeric     */
 %dcl SQLUII_HDBCP_BAD char ext;
 %SQLUII_HDBCP_BAD = '-3062';
                                      /* 'H' SBCP not compat w/data  */
                                      /* SBCP                        */
 %dcl SQLUII_HSBCP_CMP char ext;
 %SQLUII_HSBCP_CMP = '-3063';
                                      /* 'H' DBCP not compat w/data  */
                                      /* DBCP                        */
 %dcl SQLUII_HDBCP_CMP char ext;
 %SQLUII_HDBCP_CMP = '-3064';
                                      /* can't get codepages         */
 %dcl SQLUII_DB_CODEPG char ext;
 %SQLUII_DB_CODEPG = '-3065';
                                      /* eof reading/looking for     */
                                      /* 'T' rec                     */
 %dcl SQLUII_TEOF char ext;
 %SQLUII_TEOF = '-3066';
                                      /* length of 'T' rec not       */
                                      /* numeric                     */
 %dcl SQLUII_TLEN_CONV char ext;
 %SQLUII_TLEN_CONV = '-3067';
                                      /* 'T' record is too short     */
 %dcl SQLUII_TLEN_SHORT char ext;
 %SQLUII_TLEN_SHORT = '-3068';
                                      /* first non-'A' rec not 'T'   */
                                      /* rec                         */
 %dcl SQLUII_TTYP char ext;
 %SQLUII_TTYP = '-3069';

                                      /* invalid rec length of 'A'   */
                                      /* rec                         */
 %dcl SQLUII_ALEN_BAD char ext;
 %SQLUII_ALEN_BAD = '-3070';
                                      /* invalid data convention in  */
                                      /* 'T'                         */
 %dcl SQLUII_TCONV char ext;
 %SQLUII_TCONV = '-3071';
                                      /* invalid data format in 'T'  */
 %dcl SQLUII_TFORM char ext;
 %SQLUII_TFORM = '-3072';
                                      /* invalid machine form in     */
                                      /* 'T'                         */
 %dcl SQLUII_TMFRM char ext;
 %SQLUII_TMFRM = '-3073';
                                      /* invalid data location in    */
                                      /* 'T'                         */
 %dcl SQLUII_TLOC char ext;
 %SQLUII_TLOC = '-3074';
                                      /* 'C' rec cnt in 'T' not      */
                                      /* numeric                     */
 %dcl SQLUII_TCCNT char ext;
 %SQLUII_TCCNT = '-3075';
                                      /* name len fld in 'T' not     */
                                      /* numeric                     */
 %dcl SQLUII_TNAML char ext;
 %SQLUII_TNAML = '-3076';
                                      /* too many 'C' records        */
 %dcl SQLUII_CCNT_HIGH char ext;
 %SQLUII_CCNT_HIGH = '-3077';
                                      /* length of 'A' rec not       */
                                      /* numeric                     */
 %dcl SQLUII_ALEN_CONV char ext;
 %SQLUII_ALEN_CONV = '-3078';
                                      /* length of 'C' rec not       */
                                      /* numeric                     */
 %dcl SQLUII_CLEN_CONV char ext;
 %SQLUII_CLEN_CONV = '-3079';

                                      /* 'C' record is too short     */
 %dcl SQLUII_CLEN_SHORT char ext;
 %SQLUII_CLEN_SHORT = '-3080';
                                      /* wrong rec type / 'C'        */
                                      /* expected                    */
 %dcl SQLUII_CTYP char ext;
 %SQLUII_CTYP = '-3081';
                                      /* EOF while processing 'C'    */
                                      /* recs                        */
 %dcl SQLUII_CEOF char ext;
 %SQLUII_CEOF = '-3082';
                                      /* 'D' rec id field not        */
                                      /* numeric                     */
 %dcl SQLUII_CDRID char ext;
 %SQLUII_CDRID = '-3083';
                                      /* 'D' rec posn field not      */
                                      /* numeric                     */
 %dcl SQLUII_CPOSN char ext;
 %SQLUII_CPOSN = '-3084';
                                      /* 'D' id/position not         */
                                      /* consistent                  */
 %dcl SQLUII_CIDPOS char ext;
 %SQLUII_CIDPOS = '-3085';
                                      /* IXF column does not exist   */
 %dcl SQLUII_NOCREC_FOR_NONNULL_DBCOL char ext;
 %SQLUII_NOCREC_FOR_NONNULL_DBCOL = '-3086';
                                      /* IXF column not valid        */
 %dcl SQLUII_INVCREC_NONNULL_DBCOL char ext;
 %SQLUII_INVCREC_NONNULL_DBCOL = '-3087';
                                      /* IXF column not compatible   */
 %dcl SQLUII_CRECCOMP_NONNULL_DBCOL char ext;
 %SQLUII_CRECCOMP_NONNULL_DBCOL = '-3088';
                                      /* wrong rec type / 'D'        */
                                      /* expected                    */
 %dcl SQLUII_DTYP char ext;
 %SQLUII_DTYP = '-3089';

                                      /* length of 'D' rec not       */
                                      /* numeric                     */
 %dcl SQLUII_DLEN_CONV char ext;
 %SQLUII_DLEN_CONV = '-3090';
                                      /* length of 'D' rec not       */
                                      /* valid                       */
 %dcl SQLUII_DLEN_RANGE char ext;
 %SQLUII_DLEN_RANGE = '-3091';
                                      /* invalid id field in 'D'     */
                                      /* rec                         */
 %dcl SQLUII_DID char ext;
 %SQLUII_DID = '-3092';
                                      /* import file not valid WSF   */
 %dcl SQLUIW_IFILE_INV char ext;
 %SQLUIW_IFILE_INV = '-3093';
                                      /* DOS non-nullable name not   */
                                      /* found                       */
 %dcl SQLUIW_NNCOL_LOST char ext;
 %SQLUIW_NNCOL_LOST = '-3094';
                                      /* col position out of range   */
 %dcl SQLUIW_PCOL_INV char ext;
 %SQLUIW_PCOL_INV = '-3095';
                                      /* unsup col type - not        */
                                      /* nullable                    */
 %dcl SQLUIW_UCOLTYP_NONUL char ext;
 %SQLUIW_UCOLTYP_NONUL = '-3096';
                                      /* record length invalid       */
 %dcl SQLUIW_RECLEN_INV char ext;
 %SQLUIW_RECLEN_INV = '-3097';
                                      /* row number out of range     */
 %dcl SQLUIW_INROW_INV char ext;
 %SQLUIW_INROW_INV = '-3098';
                                      /* col number out of range     */
 %dcl SQLUIW_INCOL_INV char ext;
 %SQLUIW_INCOL_INV = '-3099';

                                      /* column longer than 254      */
                                      /* chars                       */
 dcl SQLUE_COL_TOOBIG fixed bin(31) value(3100);
                                      /* column has char delimiter   */
 dcl SQLUE_DATA_CHARDEL fixed bin(31) value(3101);
                                      /* dcol column nbr > tcol      */
                                      /* number                      */
 dcl SQLUE_DCNUM_HIGH fixed bin(31) value(3102);
                                      /* dcol column nbr < tcol      */
                                      /* number                      */
 dcl SQLUE_DCNUM_LOW fixed bin(31) value(3103);
                                      /* warning message issued      */
 dcl SQLUE_WARNING fixed bin(31) value(3107);

                                      /* extra database cols         */
 dcl SQLUI_FEWER_DCOLS_DBCOLS_NULLED fixed bin(31) value(3112);
                                      /* column will be nulled       */
 dcl SQLUIC_UNSUPTYP_NULLABLE fixed bin(31) value(3113);
                                      /* character ignored           */
 dcl SQLUIC_IGNORED_CHAR fixed bin(31) value(3114);
                                      /* input CSV field too long    */
 dcl SQLUIC_FIELD_TOO_LONG fixed bin(31) value(3115);
                                      /* field value missing         */
 dcl SQLUIC_CF_REQFIELD_MISSING fixed bin(31) value(3116);
                                      /* smallint field nulled       */
 dcl SQLUIC_CFINT2_NULLED fixed bin(31) value(3117);
                                      /* smallint field error        */
 dcl SQLUIC_CFINT2_ROWREJ fixed bin(31) value(3118);
                                      /* int field nulled            */
 dcl SQLUIC_CFINT4_NULLED fixed bin(31) value(3119);

                                      /* int field error             */
 dcl SQLUIC_CFINT4_ROWREJ fixed bin(31) value(3120);
                                      /* float field nulled          */
 dcl SQLUIC_CFFLOAT_NULLED fixed bin(31) value(3121);
                                      /* float field error           */
 dcl SQLUIC_CFFLOAT_ROWREJ fixed bin(31) value(3122);
                                      /* decimal field nulled        */
 dcl SQLUIC_CFDEC_NULLED fixed bin(31) value(3123);
                                      /* decimal field error         */
 dcl SQLUIC_CFDEC_ROWREJ fixed bin(31) value(3124);
                                      /* char field truncated        */
 dcl SQLUIC_CFTRUNC fixed bin(31) value(3125);

                                      /* char field nulled           */
 dcl SQLUIC_CFCHAR_NULLED fixed bin(31) value(3126);
                                      /* char field error            */
 dcl SQLUIC_CFCHAR_ROWREJ fixed bin(31) value(3127);
                                      /* date field truncated        */
 dcl SQLUIC_CFDATETRUNC fixed bin(31) value(3128);
                                      /* date/time/stamp field       */
                                      /* padded                      */
 dcl SQLUIC_CFDTPAD fixed bin(31) value(3129);

                                      /* time field truncated        */
 dcl SQLUIC_CFTIMETRUNC fixed bin(31) value(3130);
                                      /* stamp field truncated       */
 dcl SQLUIC_CFSTAMPTRUNC fixed bin(31) value(3131);
                                      /* char field truncated        */
 dcl SQLUE_TRUNCATE fixed bin(31) value(3132);
                                      /* not enough columns          */
 dcl SQLUIC_ROWTOOSHORT fixed bin(31) value(3137);
                                      /* end of input data file      */
 dcl SQLUIC_EOF_IN_CHARDELS fixed bin(31) value(3138);
                                      /* stop using database failed  */
 dcl SQLUE_SQLSTPDB_ERR fixed bin(31) value(3139);

                                      /* WSF label too big           */
 dcl SQLUE_WSFLAB_LEN fixed bin(31) value(3142);
                                      /* WSF char type length too    */
                                      /* long                        */
 dcl SQLUE_CHAR_MTRUNC fixed bin(31) value(3143);
                                      /* WSF char type length too    */
                                      /* long                        */
 dcl SQLUE_CHAR_WTRUNC fixed bin(31) value(3144);
                                      /* WSF char truncated at 240   */
 dcl SQLUE_CHAR_ITRUNC fixed bin(31) value(3145);
                                      /* row count exceeds 2048      */
 dcl SQLUE_ROWCT_LARGE fixed bin(31) value(3147);
                                      /* row not inserted            */
 dcl SQLUE_3148 fixed bin(31) value(3148);

                                      /* 'H' hcnt not equal 'T' rec  */
                                      /* ccnt                        */
 dcl SQLUII_TCNTCMP fixed bin(31) value(3154);
                                      /* invalid name length in 'C'  */
                                      /* rec                         */
 dcl SQLUII_CNAML fixed bin(31) value(3155);
                                      /* invalid null field in 'C'   */
                                      /* rec                         */
 dcl SQLUII_CNULL fixed bin(31) value(3156);
                                      /* invalid type field in 'C'   */
                                      /* rec                         */
 dcl SQLUII_CTYPE fixed bin(31) value(3157);
                                      /* invalid SBCP field in 'C'   */
                                      /* rec                         */
 dcl SQLUII_CSBCP fixed bin(31) value(3158);
                                      /* invalid DBCP field in 'C'   */
                                      /* rec                         */
 dcl SQLUII_CDBCP fixed bin(31) value(3159);

                                      /* invalid col len fld in 'C'  */
                                      /* rec                         */
 dcl SQLUII_CLENG fixed bin(31) value(3160);
                                      /* invalid precision in 'C'    */
                                      /* rec                         */
 dcl SQLUII_CPREC fixed bin(31) value(3161);
                                      /* invalid scale field in 'C'  */
                                      /* rec                         */
 dcl SQLUII_CSCAL fixed bin(31) value(3162);
                                      /* use 00008 for float col     */
                                      /* length                      */
 dcl SQLUII_CFLOAT_BLANKLENG fixed bin(31) value(3163);
                                      /* invalid float col len in    */
                                      /* 'C'.                        */
 dcl SQLUII_CFLOAT_BADLENG fixed bin(31) value(3164);
                                      /* 'C' record has invalid      */
                                      /* type                        */
 dcl SQLUII_CUTYPE fixed bin(31) value(3165);
                                      /* IXF col does not exist      */
 dcl SQLUII_NOCREC_FOR_NULL_DBCOL fixed bin(31) value(3166);
                                      /* IXF col is invalid          */
 dcl SQLUII_INVCREC_FOR_NULL_DBCOL fixed bin(31) value(3167);
                                      /* IXF col not compatible      */
 dcl SQLUII_CRECCOMP_NULL_DBCOL fixed bin(31) value(3168);

                                      /* EOF found in row of data    */
 dcl SQLUII_DEOF_INROW fixed bin(31) value(3170);
                                      /* non-label cell in hdr row   */
 dcl SQLUIW_NONLAB_HDR fixed bin(31) value(3171);
                                      /* nullable colnam not found   */
 dcl SQLUIW_NCOL_LOST fixed bin(31) value(3172);
                                      /* unsup col type - nullable   */
 dcl SQLUIW_UCOLTYP_NULL fixed bin(31) value(3174);
                                      /* wrong rec type for db col   */
 dcl SQLUIW_INTYPE_INV fixed bin(31) value(3175);
                                      /* date value out of range     */
 dcl SQLUIW_DATE_INV fixed bin(31) value(3176);
                                      /* time value out of range     */
 dcl SQLUIW_TIME_INV fixed bin(31) value(3177);
                                      /* int rec for time invalid    */
 dcl SQLUIW_INTIME_INV fixed bin(31) value(3178);
                                      /* no data / non nullable col  */
 dcl SQLUIW_NODATA_NNULL fixed bin(31) value(3179);

                                      /* insert diskette request     */
 dcl SQLUE_INSERT_DISK fixed bin(31) value(3180);
                                      /* file ended before AE rec    */
 dcl SQLUII_AE_NOTFOUND fixed bin(31) value(3181);
                                      /* retry to insert diskette    */
 dcl SQLUII_INSERT_DISK_RETRY fixed bin(31) value(3182);
                                      /* mult del o'rides/no blanks  */
 dcl SQLUEC_NOBLANK_B4KW fixed bin(31) value(3183);
                                      /* row of previous warning     */
 dcl SQLUI_PREVMESG_ROWNO fixed bin(31) value(3185);
                                      /* log full inserting row      */
 dcl SQLUI_LOGFULL_INSWARN fixed bin(31) value(3186);
                                      /* error creating index        */
 dcl SQLUI_INDEX_WARN fixed bin(31) value(3187);
                                      /* error truncating table      */
 %dcl SQLUI_TRUNCATE_TABLE char ext;
 %SQLUI_TRUNCATE_TABLE = '-3188';

                                      /* invalid INDEXIXF option     */
 %dcl SQLUI_INDEXIXF char ext;
 %SQLUI_INDEXIXF = '-3190';
                                      /* cannot import to this view  */
 %dcl SQLUI_VIEW_ERROR char ext;
 %SQLUI_VIEW_ERROR = '-3193';
                                      /* cannot import system table  */
 %dcl SQLUI_SYSTBL_ERROR char ext;
                                      /* not enough space            */
 %SQLUI_SYSTBL_ERROR = '-3194';
 dcl SQLUE_RETRY_DISK fixed bin(31) value(3195);
                                      /* input file not found        */
 %dcl SQLUI_IN_NOTFD char ext;
 %SQLUI_IN_NOTFD = '-3196';
                                      /* import/export in use        */
 %dcl SQLUI_IMPBUSY char ext;
 %SQLUI_IMPBUSY = '-3197';

                                      /* cant replace parent table   */
 %dcl SQLUI_REPL_PAR char ext;
 %SQLUI_REPL_PAR = '-3201';
                                      /* cant update without PK's    */
 %dcl SQLUI_IUOPT_NOPK char ext;
 %SQLUI_IUOPT_NOPK = '-3203';
                                      /* cant update views           */
 %dcl SQLUI_IUOPT_NOVIEW char ext;
 %SQLUI_IUOPT_NOVIEW = '-3204';
                                      /* cant replace ref cons view  */
 %dcl SQLUI_VIEW_REF char ext;
 %SQLUI_VIEW_REF = '-3205';
                                      /* cant replace subquery view  */
 %dcl SQLUI_VIEW_SQUERY char ext;
 %SQLUI_VIEW_SQUERY = '-3206';

                                      /* AIX req next file           */
 dcl SQLUE_PROVIDE_FILE_PART fixed bin(31) value(3220);
                                      /* start commit                */
 dcl SQLUI_START_COMMIT fixed bin(31) value(3221);
                                      /* finish commit               */
 dcl SQLUI_FINISH_COMMIT fixed bin(31) value(3222);
                                      /* bad input parms             */
 %dcl SQLUI_BAD_STRUCT_PARM char ext;
 %SQLUI_BAD_STRUCT_PARM = '-3223';
                                      /* restartcnt too big          */
 %dcl SQLUI_SKIPPED_ALL_ROWS char ext;
 %SQLUI_SKIPPED_ALL_ROWS = '-3225';
                                      /* compound=x error            */
 %dcl SQLUI_COMPOUND_ERR char ext;
 %SQLUI_COMPOUND_ERR = '-3250';

                                      /* row/col sequence invalid    */
 %dcl SQLUIW_RCSEQ_INV char ext;
 %SQLUIW_RCSEQ_INV = '-3300';
                                      /* BOF in middle of WSF file   */
 %dcl SQLUIW_BOF_INV char ext;
 %SQLUIW_BOF_INV = '-3301';
                                      /* unexpected EOF              */
 %dcl SQLUIW_EARLY_EOF char ext;
 %SQLUIW_EARLY_EOF = '-3302';
                                      /* filetype not ixf            */
 %dcl SQLUI_IXFONLY char ext;
 %SQLUI_IXFONLY = '-3303';
                                      /* table does not exist        */
 %dcl SQLUI_DELTABLE char ext;
 %SQLUI_DELTABLE = '-3304';
                                      /* table already exists        */
 %dcl SQLUI_CREATE_ERR char ext;
 %SQLUI_CREATE_ERR = '-3305';
                                      /* SQL error during insert     */
 %dcl SQLUI_EXECUTE_ERR char ext;
 %SQLUI_EXECUTE_ERR = '-3306';
                                      /* incomplete col info         */
 %dcl SQLUI_INC_COL char ext;
 %SQLUI_INC_COL = '-3307';
                                      /* codepage mismatch           */
 %dcl SQLUI_CP_MISMATCH char ext;
 %SQLUI_CP_MISMATCH = '-3308';
                                      /* double byte data found      */
 %dcl SQLUI_DBLDATA char ext;
 %SQLUI_DBLDATA = '-3309';

                                      /* unrec col type              */
 %dcl SQLUI_UNREC_CTYPE char ext;
 %SQLUI_UNREC_CTYPE = '-3310';
                                      /* invalid IXF column          */
 %dcl SQLUI_INVCREC_FOR_CREATE char ext;
 %SQLUI_INVCREC_FOR_CREATE = '-3310';

                                      /* disk full - OS/2            */
 %dcl SQLUE_DISK_FULL_DB2OS2 char ext;
 %SQLUE_DISK_FULL_DB2OS2 = '-3313';
                                      /* disk full - Windows NT      */
 %dcl SQLUE_DISK_FULL_DB2NT char ext;
 %SQLUE_DISK_FULL_DB2NT = '-3313';
                                      /* disk full - DOS             */
 %dcl SQLUE_DISK_FULL_DB2DOS char ext;
 %SQLUE_DISK_FULL_DB2DOS = '-3313';
                                      /* disk full - Windows         */
 %dcl SQLUE_DISK_FULL_DB2WIN char ext;
 %SQLUE_DISK_FULL_DB2WIN = '-3313';
                                      /* disk full - AIX             */
 %dcl SQLUE_DISK_FULL_DB2AIX char ext;
 %SQLUE_DISK_FULL_DB2AIX = '-10018';
                                      /* disk full - MacOS           */
 %dcl SQLUE_DISK_FULL_DB2MAC char ext;
 %SQLUE_DISK_FULL_DB2MAC = '-3313';

 %dcl SQLUE_DISK_FULL char ext;
 %SQLUE_DISK_FULL='SQLUE_DISK_FULL_DB2OS2';
 %dcl @SQLUE_DISK_FULL char ext;
 %@SQLUE_DISK_FULL='@SQLUE_DISK_FULL_DB2OS2';

                                      /* 'A' data/ time not as 'H'.  */
 %dcl SQLUII_ASTAMP_NOMATCH char ext;
 %SQLUII_ASTAMP_NOMATCH = '-3314';
                                      /* invalid volume info         */
 %dcl SQLUII_ACREC_BADVOL char ext;
 %SQLUII_ACREC_BADVOL = '-3315';
                                      /* error closing IXF file      */
 %dcl SQLUII_CLOSE_NOTLAST char ext;
 %SQLUII_CLOSE_NOTLAST = '-3316';
                                      /* conflict in filetmod        */
 %dcl SQLUW_FTMOD_INV char ext;
 %SQLUW_FTMOD_INV = '-3317';
                                      /* keyword repeated/filetmod   */
 %dcl SQLUEC_DUP_KEYWORD char ext;
 %SQLUEC_DUP_KEYWORD = '-3318';
                                      /* error creating table        */
 %dcl SQLUI_ERR_CREATETAB char ext;
 %SQLUI_ERR_CREATETAB = '-3319';

                                      /* keyword at end of filetmod  */
 %dcl SQLUEC_NOROOM_AFTERKW char ext;
 %SQLUEC_NOROOM_AFTERKW = '-3320';
                                      /* circular log full           */
 %dcl SQLUI_LOGFULL_INSERR char ext;
 %SQLUI_LOGFULL_INSERR = '-3321';
                                      /* semaphore error             */
 %dcl SQLUE_SEM_ERROR char ext;
 %SQLUE_SEM_ERROR = '-3322';
                                      /* column type invalid         */
 %dcl SQLUE_INVCOLTYPE char ext;
                                      /* ignored WSF row             */
 %SQLUE_INVCOLTYPE = '-3324';
 dcl SQLUEW_IGNORED_ROW fixed bin(31) value(3325);
                                      /* column list invalid         */
 %dcl SQLUI_COL_LIST char ext;
 %SQLUI_COL_LIST = '-3326';
                                      /* system error                */
 %dcl SQLUEI_SYSERROR char ext;
 %SQLUEI_SYSERROR = '-3327';

                                      /* odd leng char -> graphic    */
 dcl SQLUII_ODD2GRAPH fixed bin(31) value(3330);
                                      /* permission denied           */
 %dcl SQLUE_OEACCESS char ext;
 %SQLUE_OEACCESS = '-3331';
                                      /* too many files open         */
 %dcl SQLUE_OEMFILE char ext;
 %SQLUE_OEMFILE = '-3332';
                                      /* no such file or directory   */
 %dcl SQLUE_OENOENT char ext;
 %SQLUE_OENOENT = '-3333';
                                      /* not enough memory           */
 %dcl SQLUE_OENOMEM char ext;
 %SQLUE_OENOMEM = '-3334';
                                      /* no space left               */
 %dcl SQLUE_OENOSPC char ext;
 %SQLUE_OENOSPC = '-3335';

                                      /* invalid method for ASC      */
 %dcl SQLUIA_BAD_DCOL_METH char ext;
 %SQLUIA_BAD_DCOL_METH = '-3400';
                                      /* invalid import method       */
 %dcl SQLUI_DCOLM_ALL char ext;
 %SQLUI_DCOLM_ALL = '-3401';
                                      /* zeroes as begin/end         */
 %dcl SQLUIA_NULLLOC char ext;
 %SQLUIA_NULLLOC = '-3402';
                                      /* invalid pair                */
 %dcl SQLUIA_LOCPAIR char ext;
 %SQLUIA_LOCPAIR = '-3403';
                                      /* invalid pair for number     */
 %dcl SQLUIA_LOCNUM char ext;
 %SQLUIA_LOCNUM = '-3404';
                                      /* invalid pair for date       */
 %dcl SQLUIA_LOCDATE char ext;
 %SQLUIA_LOCDATE = '-3405';
                                      /* invalid pair for time       */
 %dcl SQLUIA_LOCTIME char ext;
 %SQLUIA_LOCTIME = '-3406';
                                      /* invalid pair for timestamp  */
 %dcl SQLUIA_LOCSTAMP char ext;
 %SQLUIA_LOCSTAMP = '-3407';
                                      /* pair defines long field     */
 dcl SQLUIA_LOCLONG fixed bin(31) value(3408);
                                      /* pair defines short field    */
 dcl SQLUIA_LOCSHORT fixed bin(31) value(3409);
                                      /* invalid pair for graphic    */
 %dcl SQLUIA_LOCODD char ext;
 %SQLUIA_LOCODD = '-3410';
                                      /* value not graphic--null     */
 dcl SQLUIA_CFGRAPH_NULLED fixed bin(31) value(3411);
                                      /* value not graphic--not      */
                                      /* null                        */
 dcl SQLUIA_CFGRAPH_ROWREJ fixed bin(31) value(3412);
                                      /* field too short--nulled     */
 dcl SQLUIA_SHORTFLDNULLED fixed bin(31) value(3413);

                                      /* number of warnings hit      */
                                      /* threshold                   */
 dcl SQLU_TOO_MANY_WARNINGS fixed bin(31) value(3502);
                                      /* number of rows hit          */
                                      /* threshold                   */
 dcl SQLU_ROWCNT fixed bin(31) value(3503);
                                      /* reclen > 32767              */
 %dcl SQLULA_INVALID_RECLEN char ext;
                                      /* null ind value not Y or N   */
 %SQLULA_INVALID_RECLEN = '-3505';
 dcl SQLULA_NULLIND_IGNORED fixed bin(31) value(3506);
                                      /* nullind column is invalid   */
 %dcl SQLUI_NULLIND char ext;
 %SQLUI_NULLIND = '-3507';
                                      /* file access error during    */
                                      /* load                        */
 %dcl SQLUL_FILE_ERROR char ext;
 %SQLUL_FILE_ERROR = '-3508';
                                      /* num of row deleted after    */
                                      /* load                        */
 dcl SQLUL_NUM_ROW_DELETED fixed bin(31) value(3509);
                                      /* work directory is invalid   */
 %dcl SQLU_SORT_WORK_DIR_ERROR char ext;
 %SQLU_SORT_WORK_DIR_ERROR = '-3510';
                                      /* lobfile missing but         */
                                      /* nullable col                */
 dcl SQLU_NB_LOBFILE_MISSING fixed bin(31) value(3511);
                                      /* lobfile missing,            */
                                      /* nonnullable col             */
 dcl SQLU_NNB_LOBFILE_MISSING fixed bin(31) value(3512);
                                      /* codepage doesn't match db   */
 %dcl SQLUL_UNMATCHED_CODEPAGE char ext;
 %SQLUL_UNMATCHED_CODEPAGE = '-3513';
                                      /* system error with reason    */
                                      /* code                        */
 %dcl SQLUL_SYSERR_WITH_REASON char ext;
 %SQLUL_SYSERR_WITH_REASON = '-3514';
                                      /* unexpected rec in db2cs     */
 %dcl SQLUL_UNEXPECTED_RECORD char ext;
 %SQLUL_UNEXPECTED_RECORD = '-3517';
                                      /* coltype incompatible for    */
                                      /* db2cs                       */
 %dcl SQLUL_INCOMPATIBLE_TABLE char ext;
 %SQLUL_INCOMPATIBLE_TABLE = '-3518';
                                      /* missing file                */
 %dcl SQLUL_FILE_NOT_FOUND char ext;
 %SQLUL_FILE_NOT_FOUND = '-3521';
                                      /* copy spec, no logretain     */
                                      /* userexit                    */
 %dcl SQLUL_COPY_LOGRETAIN_OFF char ext;
 %SQLUL_COPY_LOGRETAIN_OFF = '-3522';
                                      /* no messages to be           */
                                      /* retrieved                   */
 dcl SQLUL_NO_MESSAGES fixed bin(31) value(3523);
                                      /* freespace option invalid    */
 %dcl SQLUL_FREESPACE_OPT char ext;
 %SQLUL_FREESPACE_OPT = '-3524';
                                      /* incompatible options        */
 %dcl SQLU_INCOMPAT_OPT char ext;
 %SQLU_INCOMPAT_OPT = '-3525';
                                      /* mount new tape              */
 dcl SQLU_NEXT_TAPE_WARNING fixed bin(31) value(3700);
                                      /* no lobs/longs but lobpath   */
                                      /* nonull                      */
 dcl SQLU_LOBPATHS_IGNORED fixed bin(31) value(3701);
                                      /* device error but ignored    */
 dcl SQLU_DEVICE_IGNORED fixed bin(31) value(3702);
                                      /* invalid number of buffers   */
 %dcl SQLU_NUM_BUFFERS char ext;
 %SQLU_NUM_BUFFERS = '-3704';
                                      /* invalid load/unload buffer  */
                                      /* size                        */
 %dcl SQLU_BUFFER_SIZE_ERROR char ext;
 %SQLU_BUFFER_SIZE_ERROR = '-3705';
                                      /* copy target full            */
 %dcl SQLUL_DISK_FULL char ext;
 %SQLUL_DISK_FULL = '-3706';
                                      /* invalid sort buffer size    */
 %dcl SQLU_SORT_BUFFSIZE_ERROR char ext;
 %SQLU_SORT_BUFFSIZE_ERROR = '-3707';

 /* Load / unload / load recovery SQLCODES */
 %dcl SQLU_OPEN_COPY_LOC_FILE_ERROR char ext;
 %SQLU_OPEN_COPY_LOC_FILE_ERROR = '-3783';
 %dcl SQLU_INV_COPY_LOC_FILE_INPUT char ext;
 %SQLU_INV_COPY_LOC_FILE_INPUT = '-3784';
 %dcl SQLU_LOAD_RECOVERY_FAILED char ext;
 %SQLU_LOAD_RECOVERY_FAILED = '-3785';
 dcl SQLU_INVALID_PARM_WARNING fixed bin(31) value(3798);
 dcl SQLU_LOAD_RECOVERY_PENDING fixed bin(31) value(3799);

 /* load recovery - copy location input error type */
 dcl SQLU_KEYWORD_CODE fixed bin(31) value(1);
 dcl SQLU_OVERRIDE_CODE fixed bin(31) value(2);
 dcl SQLU_UNEXPECTED_EOF_CODE fixed bin(31) value(3);
 dcl SQLU_IOERROR_CODE fixed bin(31) value(4);

 /* Loadapi SQLCODES                               */
 %dcl SQLU_INVALID_QUIESCEMODE char ext;
 %SQLU_INVALID_QUIESCEMODE = '-3802';
 %dcl SQLU_INVALID_INDEX char ext;
 %SQLU_INVALID_INDEX = '-3804';
 %dcl SQLU_INVALID_LOADAPI_ACTION char ext;
 %SQLU_INVALID_LOADAPI_ACTION = '-3805';
 %dcl SQLU_CONSTRAINTS_NOT_OFF char ext;
 %SQLU_CONSTRAINTS_NOT_OFF = '-3806';
 %dcl SQLU_NO_LIFEBOAT char ext;
 %SQLU_NO_LIFEBOAT = '-3414';

 /* Export SQLCODES                                */
                                      /* Export message              */
 %dcl SQLUE_MSG char ext;
 %SQLUE_MSG = '-3999';

 /* Roll-Forward Recovery SQLCODES */
 %dcl SQLU_INVALID_PARAM char ext;
                                      /* invalid parameter           */
 %SQLU_INVALID_PARAM = '-4904';
 %dcl SQLU_INVALID_RANGE char ext;
                                      /* invalid parameter range     */
 %SQLU_INVALID_RANGE = '-4905';

 /* Configuration SQLCODES         */
                                      /* only SYSADM_GROUP can       */
                                      /* change db2 configuration    */
                                      /* file                        */
 %dcl SQLF_RC_SYSAUTH char ext;
 %SQLF_RC_SYSAUTH = '-5001';
                                      /* system error                */
 %dcl SQLF_RC_SYSERR char ext;
 %SQLF_RC_SYSERR = '-5005';
                                      /* path name error             */
 %dcl SQLF_RC_PATHNAME char ext;
 %SQLF_RC_PATHNAME = '-5010';
                                      /* invalid node name           */
 %dcl SQLF_RC_INVNODENAME char ext;
 %SQLF_RC_INVNODENAME = '-5020';
                                      /* invalid system flag         */
 %dcl SQLF_RC_INVSYSIDX char ext;
 %SQLF_RC_INVSYSIDX = '-5021';
                                      /* invalid database flag       */
 %dcl SQLF_RC_INVDBIDX char ext;
 %SQLF_RC_INVDBIDX = '-5022';
                                      /* not current db2             */
                                      /* configuration               */
 %dcl SQLF_RC_KCON char ext;
 %SQLF_RC_KCON = '-5025';
                                      /* invalid sysadm_group        */
 %dcl SQLF_RC_INVSYSADM char ext;
 %SQLF_RC_INVSYSADM = '-5028';
                                      /* invalid release number      */
 %dcl SQLF_RC_REL char ext;
 %SQLF_RC_REL = '-5030';
                                      /* database needs migration;   */
                                      /* release number is back      */
                                      /* level                       */
 %dcl SQLF_RC_NEEDMIG char ext;
 %SQLF_RC_NEEDMIG = '-5035';

                                      /* insufficient memory to      */
                                      /* support stack switching     */
 %dcl SQLF_RC_INSMEM char ext;
 %SQLF_RC_INSMEM = '-5047';
                                      /* invalid db2 configuration   */
                                      /* file                        */
 %dcl SQLF_RC_SYSCSUM char ext;
 %SQLF_RC_SYSCSUM = '-5050';
                                      /* invalid db configuration    */
                                      /* file                        */
 %dcl SQLF_RC_DBCSUM char ext;
 %SQLF_RC_DBCSUM = '-5055';
                                      /* invalid token parameter     */
 %dcl SQLF_RC_INVTKN char ext;
 %SQLF_RC_INVTKN = '-5060';
                                      /* invalid ptr to sqlfupd      */
 %dcl SQLF_RC_INVTKN_STRUCT char ext;
 %SQLF_RC_INVTKN_STRUCT = '-5061';
                                      /* invalid token ptr value     */
 %dcl SQLF_RC_INVTKN_PTR char ext;
 %SQLF_RC_INVTKN_PTR = '-5062';
                                      /* invalid node type           */
 %dcl SQLF_RC_INVNT char ext;
 %SQLF_RC_INVNT = '-5065';
                                      /* invalid count parameter     */
 %dcl SQLF_RC_CNTINV char ext;
 %SQLF_RC_CNTINV = '-5070';
                                      /* interrupt received          */
 %dcl SQLF_RC_CNTBRK char ext;
 %SQLF_RC_CNTBRK = '-5075';
                                      /* invalid initial log size    */
 %dcl SQLF_RC_INVILF char ext;
 %SQLF_RC_INVILF = '-5083';

                                      /* invalid logfile extention   */
 %dcl SQLF_RC_INVLFE char ext;
 %SQLF_RC_INVLFE = '-5091';
                                      /* invalid # of log extention  */
 %dcl SQLF_RC_INVNLE char ext;
 %SQLF_RC_INVNLE = '-5092';
                                      /* invalid new log path        */
 %dcl SQLF_RC_INVNEWLOGP char ext;
 %SQLF_RC_INVNEWLOGP = '-5099';

                                      /* incompatible logfile        */
                                      /* parameter                   */
 %dcl SQLF_RC_INVDB1 char ext;
 %SQLF_RC_INVDB1 = '-5101';
                                      /* invalid bit value - must    */
                                      /* be 0 or 1                   */
 %dcl SQLF_RC_INV_BIT_VALUE char ext;
 %SQLF_RC_INV_BIT_VALUE = '-5112';

                                      /* both R1 & R3 Log            */
                                      /* parameters may not be       */
                                      /* modified                    */
 %dcl SQLF_RC_LF_1_3 char ext;
 %SQLF_RC_LF_1_3 = '-5120';
                                      /* invalid DB configuration    */
                                      /* details                     */
 %dcl SQLF_RC_INVDETS char ext;
 %SQLF_RC_INVDETS = '-5121';
                                      /* database is copy protected  */
 %dcl SQLF_RC_PROTECT char ext;
 %SQLF_RC_PROTECT = '-5122';
                                      /* I/O Error with log header   */
 %dcl SQLF_RC_LOGIO char ext;
 %SQLF_RC_LOGIO = '-5123';
                                      /* invalid db2 config file     */
                                      /* entry                       */
 %dcl SQLF_RC_INV_DBMENT char ext;
 %SQLF_RC_INV_DBMENT = '-5126';
                                      /* integer out of range        */
 %dcl SQLF_RC_INV_RANGE char ext;
 %SQLF_RC_INV_RANGE = '-5130';
                                      /* integer out of range (-1)   */
 %dcl SQLF_RC_INV_RANGE_2 char ext;
 %SQLF_RC_INV_RANGE_2 = '-5131';
                                      /* string null or too long     */
 %dcl SQLF_RC_INV_STRING char ext;
 %SQLF_RC_INV_STRING = '-5132';
                                      /* char/int not in set         */
 %dcl SQLF_RC_INV_SET char ext;
 %SQLF_RC_INV_SET = '-5133';
                                      /* tpname not valid            */
 %dcl SQLF_RC_INVTPNAME char ext;
 %SQLF_RC_INVTPNAME = '-5134';
                                      /* maxappls*maxlocks too low   */
 %dcl SQLF_RC_LOW_APPLS_AND_LOCKS char ext;
 %SQLF_RC_LOW_APPLS_AND_LOCKS = '-5135';
                                      /* dftdbpath not valid         */
 %dcl SQLF_RC_INV_DBPATH char ext;
 %SQLF_RC_INV_DBPATH = '-5136';
                                      /* diagpath not valid          */
 %dcl SQLF_RC_INV_DIAGPATH char ext;
 %SQLF_RC_INV_DIAGPATH = '-5137';
                                      /* To many items on update or  */
                                      /* get                         */
 %dcl SQLF_RC_MAX_ITEMS_EXCEEDED char ext;
 %SQLF_RC_MAX_ITEMS_EXCEEDED = '-5139';
                                      /* invalid authentication      */
 %dcl SQLF_RC_INV_AUTHENTICATION char ext;
 %SQLF_RC_INV_AUTHENTICATION = '-5140';
                                      /* invalid AVG_APPLS           */
 %dcl SQLF_RC_INV_AVG_APPLS char ext;
 %SQLF_RC_INV_AVG_APPLS = '-5141';
                                      /* invalid agent priority      */
 %dcl SQLF_RC_INV_AGENTPRI char ext;
 %SQLF_RC_INV_AGENTPRI = '-5131';
                                      /* out of range - maximum      */
                                      /* limited by an expression    */
 %dcl SQLF_RC_INV_RANGE_MAX_EXPR char ext;
 %SQLF_RC_INV_RANGE_MAX_EXPR = '-5144';
                                      /* out of range - maximum      */
                                      /* limited by an expression    */
                                      /* (range includes -1)         */
 %dcl SQLF_RC_INV_RANGE_MAX_EXPR_2 char ext;
 %SQLF_RC_INV_RANGE_MAX_EXPR_2 = '-5145';
                                      /* out of range - minimum      */
                                      /* limited by an expression    */
 %dcl SQLF_RC_INV_RANGE_MIN_EXPR char ext;
 %SQLF_RC_INV_RANGE_MIN_EXPR = '-5146';
                                      /* out of range - minimum      */
                                      /* limited by an expression    */
                                      /* (range includes -1)         */
 %dcl SQLF_RC_INV_RANGE_MIN_EXPR_2 char ext;
 %SQLF_RC_INV_RANGE_MIN_EXPR_2 = '-5147';

 /* Repository for obsolete Return Codes */

                                      /* wrote wrong # of bytes      */
 %dcl SQLU_WRITE_ERROR char ext;
 %SQLU_WRITE_ERROR = '-2006';
                                      /* error in Start Using        */
 %dcl SQLU_CONNECT_ERROR char ext;
 %SQLU_CONNECT_ERROR = '-2010';
                                      /* error in ints               */
 %dcl SQLU_INT_ERROR char ext;
 %SQLU_INT_ERROR = '-2012';
                                      /* media header not present    */
 %dcl SQLUD_NO_MHEADER_ERROR char ext;
 %SQLUD_NO_MHEADER_ERROR = '-2531';
                                      /* media header missing        */
 dcl SQLUD_NO_MHEADER_WARNING fixed bin(31) value(2534);
                                      /* another tape mount          */
                                      /* required                    */
 dcl SQLUD_NEXT_TAPE_WARNING fixed bin(31) value(2535);
                                      /* waiting for ADSM server to  */
                                      /* access data on removable    */
                                      /* media                       */
 dcl SQLUD_ADSM_MOUNT_WAIT fixed bin(31) value(2545);

 /********************************************************************/
 /* Configuration parameter obsolete return codes defines -          */
 /* Some configuration parameters had specific out of range return   */
 /* codes; these have been replaced by generic out of range messages */
 /* In these cases the old token names for the specific return codes */
 /* are given, but the values are replaced by the new values returned*/
 /* when out of range.                                               */
 /********************************************************************/

                                      /* only SYSADM can             */
                                      /* changedatabase              */
                                      /* configuration file          */
 %dcl SQLF_RC_DBAUTH char ext;
 %SQLF_RC_DBAUTH = '-5002';
                                      /* invalid # of concurrent db  */
 %dcl SQLF_RC_INVNDB char ext;
 %SQLF_RC_INVNDB = '-5130';
                                      /* invalid req I/O blk size    */
 %dcl SQLF_RC_INVRIO char ext;
 %SQLF_RC_INVRIO = '-5130';
                                      /* invalid serv I/O blk size   */
 %dcl SQLF_RC_INVSIO char ext;
 %SQLF_RC_INVSIO = '-5015';
                                      /* invalid communications      */
                                      /* heap                        */
 %dcl SQLF_RC_INVCHEAP char ext;
 %SQLF_RC_INVCHEAP = '-5016';
                                      /* invalid remote services     */
                                      /* heap                        */
 %dcl SQLF_RC_INVRSHEAP char ext;
 %SQLF_RC_INVRSHEAP = '-5017';
                                      /* invalid sort heap           */
                                      /* threshold                   */
 %dcl SQLF_RC_INVSHPTHR char ext;
 %SQLF_RC_INVSHPTHR = '-5130';
                                      /* invalid DB2COMM value       */
 %dcl SQLCC_RC_BAD_DB2COMM char ext;
 %SQLCC_RC_BAD_DB2COMM = '-5036';
                                      /* service name not definein   */
                                      /* db2 config file             */
 %dcl SQLCC_RC_NO_SERV_IN_DBMCFG char ext;
 %SQLCC_RC_NO_SERV_IN_DBMCFG = '-5037';
                                      /* service name not found in   */
                                      /* etc/services file           */
 %dcl SQLCC_RC_SERV_NOT_FOUND char ext;
 %SQLCC_RC_SERV_NOT_FOUND = '-5038';
                                      /* interrupt port not found    */
                                      /* in/etc/services file        */
 %dcl SQLCC_RC_INT_PORT_NOT_FOUND char ext;
 %SQLCC_RC_INT_PORT_NOT_FOUND = '-5039';
                                      /* socket address in use       */
 %dcl SQLCC_RC_SOCKADDR_IN_USE char ext;
 %SQLCC_RC_SOCKADDR_IN_USE = '-5040';
                                      /* trans program name not      */
                                      /* definedin db2               */
                                      /* configuration file          */
 %dcl SQLCC_RC_NO_TPN_IN_DBMCFG char ext;
 %SQLCC_RC_NO_TPN_IN_DBMCFG = '-5041';
                                      /* general failure in          */
                                      /* servercommunications        */
                                      /* support                     */
 %dcl SQLCC_RC_COMM_SUPPORT_FAILED char ext;
 %SQLCC_RC_COMM_SUPPORT_FAILED = '-5042';
                                      /* invalid # of locklist       */
 %dcl SQLF_RC_INVNLL char ext;
 %SQLF_RC_INVNLL = '-5130';
                                      /* invalid # bufr pool pages   */
 %dcl SQLF_RC_INVNBP char ext;
 %SQLF_RC_INVNBP = '-5130';
                                      /* invalid # of DB files open  */
 %dcl SQLF_RC_INVNDBF char ext;
 %SQLF_RC_INVNDBF = '-5130';
                                      /* invalid soft check point    */
                                      /* value                       */
 %dcl SQLF_RC_INVSCP_DB2OS2 char ext;
 %SQLF_RC_INVSCP_DB2OS2 = '-5130';
                                      /* invalid soft check point    */
                                      /* value                       */
 %dcl SQLF_RC_INVSCP_DB2AIX char ext;
 %SQLF_RC_INVSCP_DB2AIX = '-5130';
                                      /* invalid soft check point    */
                                      /* value                       */
 %dcl SQLF_RC_INVSCP char ext;
 %SQLF_RC_INVSCP = '-5130';
                                      /* invalid # of active appls   */
 %dcl SQLF_RC_INVNAP char ext;
 %SQLF_RC_INVNAP = '-5130';
                                      /* invalid application heapsz  */
 %dcl SQLF_RC_INVAHP char ext;
 %SQLF_RC_INVAHP = '-5130';
                                      /* invalid database heap size  */
 %dcl SQLF_RC_INVDHP char ext;
 %SQLF_RC_INVDHP = '-5130';
                                      /* invalid deadlock detection  */
 %dcl SQLF_RC_INVDLT char ext;
 %SQLF_RC_INVDLT = '-5130';
                                      /* invalid # of total files    */
                                      /* openper application         */
 %dcl SQLF_RC_INVTAF char ext;
 %SQLF_RC_INVTAF = '-5130';
                                      /* invalid sortlist heap       */
 %dcl SQLF_RC_INVSHP char ext;
 %SQLF_RC_INVSHP = '-5130';
                                      /* invalid maxlocks per        */
                                      /* application                 */
 %dcl SQLF_RC_INVMAL char ext;
 %SQLF_RC_INVMAL = '-5130';
                                      /* invalid statement heap      */
 %dcl SQLF_RC_INVSTMHP char ext;
 %SQLF_RC_INVSTMHP = '-5130';
                                      /* invalid number primary log  */
                                      /* files                       */
 %dcl SQLF_RC_INVLOGPRIM char ext;
 %SQLF_RC_INVLOGPRIM = '-5130';
                                      /* invalid number of           */
                                      /* secondary log files         */
 %dcl SQLF_RC_INVLOG2ND char ext;
 %SQLF_RC_INVLOG2ND = '-5130';
                                      /* invalid log file size       */
 %dcl SQLF_RC_INVLOGFSZ char ext;
 %SQLF_RC_INVLOGFSZ = '-5130';
                                      /* incompatible file open      */
                                      /* parmeter                    */
 %dcl SQLF_RC_INVDB2 char ext;
 %SQLF_RC_INVDB2 = '-5102';
                                      /* no DB's / requestor only    */
 %dcl SQLF_RC_INVK2 char ext;
 %SQLF_RC_INVK2 = '-5104';
                                      /* standalone nodetype does    */
                                      /* notsupport nodename         */
 %dcl SQLF_RC_INVK3 char ext;
 %SQLF_RC_INVK3 = '-5126';
                                      /* remote workstation has      */
                                      /* alreadybeen configured      */
 %dcl SQLF_RC_RWS_EXIST char ext;
 %SQLF_RC_RWS_EXIST = '-5106';
                                      /* <authid> does not           */
                                      /* haveauthority to add or     */
                                      /* drop a remote workstation   */
 %dcl SQLF_RC_RWS_SYSADM char ext;
 %SQLF_RC_RWS_SYSADM = '-5107';
                                      /* remote workstation has      */
                                      /* notbeen previously setup    */
                                      /* using sqlarws               */
 %dcl SQLF_RC_RWS_NOT_EXIST char ext;
 %SQLF_RC_RWS_NOT_EXIST = '-5108';
                                      /* machine name is missing     */
                                      /* ors too long.               */
 %dcl SQLF_RC_RWS_MACHINENAME char ext;
 %SQLF_RC_RWS_MACHINENAME = '-5109';
                                      /* configuration option is     */
                                      /* invalid                     */
 %dcl SQLF_RC_RWS_INV_OPT char ext;
 %SQLF_RC_RWS_INV_OPT = '-5110';
                                      /* environment                 */
                                      /* variableDB2WKSTPROF is not  */
                                      /* defined                     */
 %dcl SQLF_RC_ENV_VAR_NOTDEF char ext;
 %SQLF_RC_ENV_VAR_NOTDEF = '-5111';
                                      /* incompatible buffer pool    */
                                      /* and maximum # of            */
                                      /* applications                */
 %dcl SQLF_RC_INVDB3 char ext;
 %SQLF_RC_INVDB3 = '-5146';
                                      /* invalid QUERY_HEAP_SZ       */
 %dcl SQLF_RC_INV_QUERY_HEAP_SZ char ext;
 %SQLF_RC_INV_QUERY_HEAP_SZ = '-5143';
                                      /* out of range - limited by   */
                                      /* a parm                      */
 %dcl SQLF_RC_INV_RANGE_3 char ext;
 %SQLF_RC_INV_RANGE_3 = '-5144';

 /* obsolete database manager configuration parameter tokens */
 dcl SQLF_KTN_SVRIOBLK fixed bin(31) value(3);
 dcl SQLF_KTN_SQLENSEG fixed bin(31) value(5);
 dcl SQLF_KTN_COMHEAPSZ fixed bin(31) value(8);
 dcl SQLF_KTN_RSHEAPSZ fixed bin(31) value(9);
 dcl SQLF_KTN_NUMRC fixed bin(31) value(10);
 dcl SQLF_KTN_CUINTERVAL fixed bin(31) value(14);
 dcl SQLF_KTN_COMHEAPSZ_P fixed bin(31) value(50);
 dcl SQLF_KTN_RSHEAPSZ_P fixed bin(31) value(51);
 %dcl SQLF_KTN_IPX_FILESERVER char ext;
 %SQLF_KTN_IPX_FILESERVER='SQLF_KTN_FILESERVER';
 %dcl @SQLF_KTN_IPX_FILESERVER char ext;
 %@SQLF_KTN_IPX_FILESERVER='@SQLF_KTN_FILESERVER';
 %dcl SQLF_KTN_IPX_OBJECTNAME char ext;
 %SQLF_KTN_IPX_OBJECTNAME='SQLF_KTN_OBJECTNAME';
 %dcl @SQLF_KTN_IPX_OBJECTNAME char ext;
 %@SQLF_KTN_IPX_OBJECTNAME='@SQLF_KTN_OBJECTNAME';

 /* obsolete database configuration parameter tokens         */
 dcl SQLF_DBTN_LOGFILE fixed bin(31) value(4);
 dcl SQLF_DBTN_MAXTOTFILOP fixed bin(31) value(10);
 dcl SQLF_DBTN_LOGEXT fixed bin(31) value(12);
 dcl SQLF_DBTN_LOGMAXEXT fixed bin(31) value(13);
 dcl SQLF_DBTN_AGENTHEAP fixed bin(31) value(14);
 dcl SQLF_DBTN_SEGPAGES fixed bin(31) value(123);
 dcl SQLF_DBTN_BUFFPAGE fixed bin(31) value(2);
 dcl SQLF_DBTN_SORTHEAP fixed bin(31) value(91);
 %dcl SQLF_DBTN_SORTHEAPSZ_P char ext;
 %SQLF_DBTN_SORTHEAPSZ_P='SQLF_DBTN_SORT_HEAP';
 %dcl @SQLF_DBTN_SORTHEAPSZ_P char ext;
 %@SQLF_DBTN_SORTHEAPSZ_P='@SQLF_DBTN_SORT_HEAP';
 %dcl SQLF_DBTN_DBHEAP_P char ext;
 %SQLF_DBTN_DBHEAP_P='SQLF_DBTN_DBHEAP';
 %dcl @SQLF_DBTN_DBHEAP_P char ext;
 %@SQLF_DBTN_DBHEAP_P='@SQLF_DBTN_DBHEAP';
 %dcl SQLF_DBTN_APPLHEAPSZ_P char ext;
 %SQLF_DBTN_APPLHEAPSZ_P='SQLF_DBTN_APPLHEAPSZ';
 %dcl @SQLF_DBTN_APPLHEAPSZ_P char ext;
 %@SQLF_DBTN_APPLHEAPSZ_P='@SQLF_DBTN_APPLHEAPSZ';
 %dcl SQLF_DBTN_STMTHEAPSZ_P char ext;
 %SQLF_DBTN_STMTHEAPSZ_P='SQLF_DBTN_STMTHEAP';
 %dcl @SQLF_DBTN_STMTHEAPSZ_P char ext;
 %@SQLF_DBTN_STMTHEAPSZ_P='@SQLF_DBTN_STMTHEAP';


 /* Repository for obsolete prototypes                       */

    dcl   sqlfeudb  entry (
           pointer,
           pointer,
           unsigned fixed bin(16),
           handle sqlfupd,
           pointer)
             returns( byvalue optional SQL_API_RC )
              SQL_API_FN external;



                                   /* Update Database Configuration  */
 dcl   sqlgeudb  entry (
        unsigned fixed bin(16),    /* reserved                       */
        unsigned fixed bin(16),    /* database alias length          */
        unsigned fixed bin(16),    /* number of entries being        */
                                   /* modified                       */
        pointer,                   /* list of item lengths           */
        handle sqlfupd,            /* list of items                  */
        pointer,                   /* SQLCA                          */
        pointer,                   /* reserved                       */
         pointer)                  /* database alias                 */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Reset Database Configuration   */
 dcl   sqlgrdbc  entry (
        unsigned fixed bin(16),    /* Spare1                         */
        unsigned fixed bin(16),    /* Database name length           */
        pointer,                   /* SQLCA                          */
        pointer,                   /* Spare2                         */
         pointer)                  /* database                       */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

                                   /* Return Database Configuration  */
 dcl   sqlgxdbc  entry (
        unsigned fixed bin(16),    /* Spare1                         */
        unsigned fixed bin(16),    /* Database name length           */
        unsigned fixed bin(16),    /* count                          */
        handle sqlfupd,            /* list of items                  */
        pointer,                   /* SQLCA                          */
        pointer,                   /* Spare2                         */
         pointer)                  /* Database                       */
          returns( byvalue optional  SQL_API_RC )
           SQL_API_FN external;

 /********************************************************************/
 /*                                                                  */
 /* The following functions and symbols are obsolete and may not be  */
 /* supported                                                        */
 /* in future releases. The obsolete functions are provided for      */
 /* backward compatibility                                           */
 /* and exported from DB2API.LIB. All applications should be migrated*/
 /* to use new APIs.                                                 */
 /* Note: Some of the function parameters may be NO-OP.              */
 /*                                                                  */
 /********************************************************************/
    dcl   sqlfrdbc  entry (
           pointer,
           pointer,
           pointer)
             returns( byvalue optional SQL_API_RC )
              SQL_API_FN external;



    dcl   sqlfxdbc  entry (
           pointer,
           pointer,
           unsigned fixed bin(16),
           pointer,
           pointer)
             returns( byvalue optional SQL_API_RC )
              SQL_API_FN external;



                                      /* OS/2 Backup                 */
 dcl   sqluback_api  entry (
        pointer,                      /* alias name                  */
        pointer,                      /* password                    */
        fixed bin(15),                /* type                        */
        char,                         /* drive                       */
         pointer)                     /* SQLCA                       */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* OS/2 Restore                */
 dcl   sqludres_api  entry (
        pointer,                      /* alias name                  */
        char,                         /* database drive              */
        pointer,                      /* password                    */
        char,                         /* drive                       */
        fixed bin(15),                /* callerac                    */
         pointer)                     /* SQLCA                       */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* EXPORT                      */
 dcl   sqluexp_api  entry (
        pointer,                      /* database                    */
        pointer,                      /* password (no-op)            */
        pointer,                      /* datafile                    */
        handle sqldcol,               /* dcoldata                    */
        handle sqlchar,               /* tcolstrg                    */
        pointer,                      /* filetype                    */
        handle sqlchar,               /* filetmod                    */
        pointer,                      /* msgfile                     */
        fixed bin(15),                /* caller action               */
         pointer)                     /* SQLCA                       */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* IMPORT                      */
 dcl   sqluimp_api  entry (
        pointer,                      /* database                    */
        pointer,                      /* password (no-op)            */
        pointer,                      /* datafile                    */
        handle sqldcol,               /* dcoldata                    */
        handle sqlchar,               /* tcolstrg                    */
        pointer,                      /* filetype                    */
        handle sqlchar,               /* filetmod                    */
        pointer,                      /* msgfile                     */
        fixed bin(15),                /* caller action               */
         pointer)                     /* SQLCA                       */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* ROLL FORWARD                */
 dcl   sqlufrol_api  entry (
        pointer,                      /* database name               */
        unsigned fixed bin(16),       /* action                      */
        pointer,                      /* Stop Timestamp              */
        pointer,                      /* Next Archive File needed    */
        pointer,                      /* First Archive File needed   */
        pointer,                      /* Last Archive File needed    */
        pointer,                      /* Returned Timestamp          */
         pointer)                     /* SQLCA                       */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* REORG                       */
 dcl   sqlureor_api  entry (
        pointer,                      /* database                    */
        pointer,                      /* password (no-op)            */
        pointer,                      /* table name                  */
        pointer,                      /* iname                       */
        pointer,                      /* file path                   */
        fixed bin(15),                /* spare (no-op)               */
         pointer)                     /* SQLCA                       */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* OS/2 Backup                 */
 dcl   SQLGBACK  entry (
        unsigned fixed bin(16),       /* password length (no-op)     */
        unsigned fixed bin(16),       /* database length             */
        fixed bin(15),                /* type                        */
        char,                         /* drive                       */
        pointer,                      /* SQLCA                       */
        pointer,                      /* password (no-op)            */
         pointer)                     /* database name               */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* OS/2 Restore                */
 dcl   SQLGDRES  entry (
        unsigned fixed bin(16),       /* password length (no-op)     */
        unsigned fixed bin(16),       /* database length             */
        fixed bin(15),                /* caller action               */
        char,                         /* drive                       */
        char,                         /* database drive              */
        pointer,                      /* SQLCA                       */
        pointer,                      /* password                    */
         pointer)                     /* database name               */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* EXPORT                      */
 dcl   SQLGEXP  entry (
        unsigned fixed bin(16),       /* Message filename length     */
        unsigned fixed bin(16),       /* File type length            */
        unsigned fixed bin(16),       /* Data file name length       */
        unsigned fixed bin(16),       /* Password length (no-op)     */
        unsigned fixed bin(16),       /* Database name length (no    */
                                      /* op)                         */
        fixed bin(15),                /* caller action               */
        pointer,                      /* SQLCA                       */
        pointer,                      /* msgfile                     */
        handle sqlchar,               /* filetmod                    */
        pointer,                      /* filetype                    */
        handle sqlchar,               /* tcolstrg                    */
        handle sqldcol,               /* dcoldata                    */
        pointer,                      /* datafile                    */
        pointer,                      /* password (no-op)            */
         pointer)                     /* database                    */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* IMPORT                      */
 dcl   SQLGIMP  entry (
        unsigned fixed bin(16),       /* Message filename length     */
        unsigned fixed bin(16),       /* File type length            */
        unsigned fixed bin(16),       /* Data file name length       */
        unsigned fixed bin(16),       /* Password length (no-op)     */
        unsigned fixed bin(16),       /* Database name length (no    */
                                      /* op)                         */
        fixed bin(15),                /* caller action               */
        pointer,                      /* SQLCA                       */
        pointer,                      /* msgfile                     */
        handle sqlchar,               /* filetmod                    */
        pointer,                      /* filetype                    */
        handle sqlchar,               /* tcolstrg                    */
        handle sqldcol,               /* dcoldata                    */
        pointer,                      /* datafile                    */
        pointer,                      /* password (no-op)            */
         pointer)                     /* database                    */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* REORG                       */
 dcl   SQLGREOR  entry (
        unsigned fixed bin(16),       /* File name length            */
        unsigned fixed bin(16),       /* Table name length           */
        unsigned fixed bin(16),       /* inname length               */
        unsigned fixed bin(16),       /* password length (no-op)     */
        unsigned fixed bin(16),       /* database name length        */
        fixed bin(15),                /* spare (no-op)               */
        pointer,                      /* SQLCA                       */
        pointer,                      /* file path                   */
        pointer,                      /* table name                  */
        pointer,                      /* iname                       */
        pointer,                      /* password (no-op)            */
         pointer)                     /* database                    */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;

                                      /* ROLL FORWARD                */
 dcl   SQLGFROL  entry (
        unsigned fixed bin(16),       /* database name length        */
        unsigned fixed bin(31),       /* Point in time length        */
        unsigned fixed bin(16),       /* action                      */
        pointer,                      /* SQLCA                       */
        pointer,                      /* DB name                     */
        pointer,                      /* Point in time               */
        pointer,                      /* Next Archive File length    */
        pointer,                      /* Next Archive File needed    */
        pointer,                      /* First deleted archive File  */
                                      /* length                      */
        pointer,                      /* First deleted archive File  */
                                      /* needed                      */
        pointer,                      /* Last deleted Archive File   */
                                      /* length                      */
        pointer,                      /* Last deleted Archive File   */
                                      /* needed                      */
        pointer,                      /* Last commit time length     */
         pointer)                     /* Last commit Time            */
          returns( byvalue optional SQL_API_RC )
           SQL_API_FN external;


                                          /* invalid into in         */
                                      /* tcolstrg                    */
 %dcl SLQUI_TINTO char ext;
 %SLQUI_TINTO='SQLUI_TINTO';
 %dcl @SLQUI_TINTO char ext;
 %@SLQUI_TINTO='@SQLUI_TINTO';
 /********************************************************************/
 /**                                                                 */
 /** End of obsolete functions and symbols                           */
 /**                                                                 */
 /********************************************************************/


  %end;
 /* SQL_H_SQLUTIL */
