/*--------------------------------------------------------------------------*/
/*                                                                          */
/* PROGRAM NAME: FHBWLINK.C                                                 */
/* -------------                                                            */
/*                                                                          */
/*  A TeamConnection Build Script for the Microsoft Visual C++ linker       */
/*                                                                          */
/*                 IBM TeamConnection                                       */
/*                 Version 1 Release 1                                      */
/*                    5622-717                                              */
/*                                                                          */
/* COPYRIGHT:                                                               */
/* ----------                                                               */
/*        (C) Copyright, IBM Corp., 1996. All Rights Reserved.              */
/*                  Licensed Materials - Property of IBM                    */
/*                 US Government Users Restricted Rights                    */
/*           - Use, duplication or disclosure restricted by                 */
/*              GSA ADP Schedule Contract with IBM Corp.                    */
/*                                                                          */
/*                  IBM is a registered trademark of                        */
/*             International Business Machines Corporation                  */
/*                                                                          */
/* DISCLAIMER OF WARRANTIES:                                                */
/* -------------------------                                                */
/* The following [enclosed] code is sample code created by IBM              */
/* Corporation.  This sample code is not part of any standard IBM product   */
/* and is provided to you solely for the purpose of assisting you in the    */
/* development of your applications.  The code is provided "AS IS",         */
/* without warranty of any kind.  IBM shall not be liable for any damages   */
/* arising out of your use of the sample code, even if they have been       */
/* advised of the possibility of such damages.                              */
/*                                                                          */
/*  WHAT THIS PROGRAM DOES:                                                 */
/*  -----------------------                                                 */
/*  This program is a build script that invokes the Microsoft Visual C++.   */
/*  Linker.                                                                 */
/*                                                                          */
/*--------------------------------------------------------------------------*/
/*                                                                          */
/* Inputs from the environment                                              */
/*      TC_INPUT                                                            */
/*      TC_OUTPUT                                                           */
/*                                                                          */
/* Inputs from the argument list                                            */
/*      PARMS                                                               */
/*                                                                          */
/*  TC_INPUT contains inputs stored in the library that are input to the    */
/*   translator build step.                                                 */
/*  TC_OUTPUT contains outputs that are to be built by translator and that  */
/*   will be stored in the library.                                         */
/*  PARMS are translator options that are specified on the TeamConnection   */
/*   builder definition.                                                    */
/*                                                                          */
/* Outputs:                                                                 */
/*  files generated by the translator                                       */
/*                                                                          */
/* Returns:                                                                 */
/*  return code from the translator execution                               */
/*                                                                          */
/*+------------------------------------------------------------------------+*/

#include <string.h>
#include <stdio.h>
#include <stdlib.h>

char *parseFiles(char *string);

/* Modify the next line to change the translator to invoke */
#define TRANSLATOR      "link"

/* Modify the next line to change default parameters that should all be used */
/* /c specified to do only a compile                                         */
#define DEF_PARMS       ""

/* The following file extensions are searched for in parseFiles() */
#define OBJ             ".OBJ"
#define PDB             ".PDB"
#define EXE             ".EXE"
#define MAP             ".MAP"
#define DEF             ".DEF"

int main (int argc, char *argv[])
{

int count,rc=0;
char *tc_input, *tc_output;
char parms[1025];
char *cmd=NULL;
char *inputs, *outputs;

parms[0]='\0';

/* get the TeamConnection parameters from the environment       */
tc_input  = getenv("TC_INPUT");
if (!tc_input)
    {
       printf("ERROR - TC_INPUT has no value");
       return 20;
    }
tc_output = getenv("TC_OUTPUT");
if (!tc_output)
    {
       printf("ERROR - TC_OUTPUT has no value");
       return 20;
    }

/* collect the builder parameters passed in when    */
/* the build script is executed                     */
for (count = 1; count < argc; count++)
{
   strcat(parms,argv[count]);
   strcat(parms," ");
}

/* parse the inputs and outputs to find special files */
inputs  = parseFiles(tc_input);
outputs = parseFiles(tc_output);

/* build the command to be executed */
cmd  = (char *) malloc((strlen(TRANSLATOR)+strlen(DEF_PARMS)+strlen(parms)+strlen(outputs)+strlen(inputs)+100) *sizeof(char));
sprintf(cmd,"%s %s %s %s %s",TRANSLATOR,DEF_PARMS,parms,inputs,outputs);
printf("Cmd = %s\n",cmd);
fflush(stdout);

/* execute the command */
rc = system(cmd);

free(cmd);

/* return the rc from the command invocation */
return rc;
}

/*************************************************************************/
/* Check each token in the string for a particular file extension and    */
/* return a pointer to the string formatted for the command              */
/*************************************************************************/
char *parseFiles(char *inString)
{
    char *buffer=NULL;
    char *leftovers=NULL;
    char *string;
    int j=0,k=0;

    char drive[_MAX_DRIVE];
    char dir[_MAX_DIR];
    char fname[_MAX_FNAME];
    char ext[_MAX_EXT];
    char *fileName;

    /* make a copy of the string being parsed */
    string = strdup(inString);

    /* allocate a buffer to hold the reformatted string */
    buffer     = (char *) malloc(strlen(inString)+100);
    memset(buffer,0,strlen(inString)+100);

    /* start processing each token of the string */
    fileName = strtok(string, " ");
    do {

       /* get the file extension so that we can check for */
       /* the different types                             */
       _splitpath(fileName, drive, dir, fname, ext);

       /* check if the file is an MAP.  If so prefix the  */
       /* filename with /MAP:                             */
       if (!stricmp(ext,MAP))
       {
         j += sprintf(buffer+j, "/MAP:%s ", fileName);
         continue;
       }

       /* check if the file is an EXE.  If so prefix the  */
       /* filename with /OUT:                             */
       if (!stricmp(ext,EXE))
       {
         j = sprintf(buffer+j, "/OUT:%s ", fileName);
         continue;
       }

       /* check if the file is an DEF.  If so prefix the  */
       /* filename with /DEF:                             */
       if (!stricmp(ext,DEF))
       {
         j += sprintf(buffer+j, "/DEF:%s ", fileName);
         continue;
       }

       /* Collect all the files that did not match any   */
       /* of the extensions searched for above.          */
       if (!leftovers)
       {
          leftovers  = (char *) malloc(strlen(inString)+2);
          memset(leftovers,0,strlen(inString)+2);
       }
       k += sprintf(leftovers+k, "%s ", fileName);

    }  while (fileName = strtok(NULL, " "));

    /* if any leftovers were collected then concatenate  */
    /* them on the buffer to be returned                 */
    if (leftovers)
    {
       strcat(buffer,leftovers);
       free(leftovers);
    }

    return buffer;
}
