/*
 * Decompiled with CFR 0.152.
 */
package javax.swing.plaf.basic;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.CellRendererPane;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.KeyStroke;
import javax.swing.RepaintManager;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.event.MouseInputListener;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.TreeUI;
import javax.swing.plaf.UIResource;
import javax.swing.tree.AbstractLayoutCache;
import javax.swing.tree.DefaultTreeCellEditor;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.FixedHeightLayoutCache;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreeCellRenderer;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;
import javax.swing.tree.TreeSelectionModel;
import javax.swing.tree.VariableHeightLayoutCache;

public class BasicTreeUI
extends TreeUI {
    private static final Insets EMPTY_INSETS = new Insets(0, 0, 0, 0);
    protected transient Icon collapsedIcon;
    protected transient Icon expandedIcon;
    private Color hashColor;
    protected int leftChildIndent;
    protected int rightChildIndent;
    protected int totalChildIndent;
    protected Dimension preferredMinSize;
    protected int lastSelectedRow;
    protected JTree tree;
    protected transient TreeCellRenderer currentCellRenderer;
    protected boolean createdRenderer;
    protected transient TreeCellEditor cellEditor;
    protected boolean createdCellEditor;
    protected boolean stopEditingInCompleteEditing;
    protected CellRendererPane rendererPane;
    protected Dimension preferredSize;
    protected boolean validCachedPreferredSize;
    protected AbstractLayoutCache treeState;
    protected Hashtable drawingCache;
    protected boolean largeModel;
    protected AbstractLayoutCache.NodeDimensions nodeDimensions;
    protected TreeModel treeModel;
    protected TreeSelectionModel treeSelectionModel;
    protected int depthOffset;
    protected Component editingComponent;
    protected TreePath editingPath;
    protected int editingRow;
    protected boolean editorHasDifferentSize;
    private TreePath anchorPath;
    private TreePath leadPath;
    private int leadRow;
    private boolean changeSelectionWithFocus;
    private Vector keyActions;
    private PropertyChangeListener propertyChangeListener;
    private PropertyChangeListener selectionModelPropertyChangeListener;
    private MouseListener mouseListener;
    private FocusListener focusListener;
    private KeyListener keyListener;
    private ComponentListener componentListener;
    private CellEditorListener cellEditorListener;
    private TreeSelectionListener treeSelectionListener;
    private TreeModelListener treeModelListener;
    private TreeExpansionListener treeExpansionListener;

    public void cancelEditing(JTree jTree) {
        if (this.editingComponent != null) {
            this.completeEditing(false, true, false);
        }
    }

    private boolean changeSelectionWithFocus() {
        return this.changeSelectionWithFocus;
    }

    protected void checkForClickInExpandControl(TreePath treePath, int n, int n2) {
        if (this.isLocationInExpandControl(treePath, n, n2)) {
            this.handleExpandControlClick(treePath, n, n2);
        }
    }

    protected void completeEditing() {
        if (this.tree.getInvokesStopCellEditing() && this.stopEditingInCompleteEditing && this.editingComponent != null) {
            this.cellEditor.stopCellEditing();
        }
        this.completeEditing(false, true, false);
    }

    protected void completeEditing(boolean bl, boolean bl2, boolean bl3) {
        if (this.stopEditingInCompleteEditing && this.editingComponent != null) {
            Component component = this.editingComponent;
            TreePath treePath = this.editingPath;
            TreeCellEditor treeCellEditor = this.cellEditor;
            Object object = treeCellEditor.getCellEditorValue();
            Rectangle rectangle = this.getPathBounds(this.tree, this.editingPath);
            boolean bl4 = this.tree != null && (this.tree.hasFocus() || SwingUtilities.findFocusOwner(this.editingComponent) != null);
            this.editingComponent = null;
            this.editingPath = null;
            if (bl) {
                treeCellEditor.stopCellEditing();
            } else if (bl2) {
                treeCellEditor.cancelCellEditing();
            }
            this.tree.remove(component);
            if (this.editorHasDifferentSize) {
                this.treeState.invalidatePathBounds(treePath);
                this.updateSize();
            } else {
                rectangle.x = 0;
                rectangle.width = this.tree.getSize().width;
                this.tree.repaint(rectangle);
            }
            if (bl4) {
                this.tree.requestFocus();
            }
            if (bl3) {
                this.treeModel.valueForPathChanged(treePath, object);
            }
        }
    }

    protected void completeUIInstall() {
        this.setShowsRootHandles(this.tree.getShowsRootHandles());
        this.updateRenderer();
        this.updateDepthOffset();
        this.setSelectionModel(this.tree.getSelectionModel());
        this.treeState = this.createLayoutCache();
        this.configureLayoutCache();
        this.updateSize();
    }

    protected void completeUIUninstall() {
        if (this.createdRenderer) {
            this.tree.setCellRenderer(null);
        }
        if (this.createdCellEditor) {
            this.tree.setCellEditor(null);
        }
        this.cellEditor = null;
        this.currentCellRenderer = null;
        this.rendererPane = null;
        this.componentListener = null;
        this.propertyChangeListener = null;
        this.mouseListener = null;
        this.focusListener = null;
        this.keyListener = null;
        this.treeState = null;
        this.setSelectionModel(null);
        this.drawingCache = null;
        this.selectionModelPropertyChangeListener = null;
        this.tree = null;
        this.treeModel = null;
        this.treeSelectionModel = null;
        this.treeSelectionListener = null;
        this.treeExpansionListener = null;
    }

    protected void configureLayoutCache() {
        if (this.treeState != null && this.tree != null) {
            if (this.nodeDimensions == null) {
                this.nodeDimensions = this.createNodeDimensions();
            }
            this.treeState.setNodeDimensions(this.nodeDimensions);
            this.treeState.setRootVisible(this.tree.isRootVisible());
            this.treeState.setRowHeight(this.tree.getRowHeight());
            this.treeState.setSelectionModel(this.getSelectionModel());
            if (this.treeState.getModel() != this.tree.getModel()) {
                this.treeState.setModel(this.tree.getModel());
            }
            this.updateLayoutCacheExpandedNodes();
            if (this.isLargeModel()) {
                if (this.componentListener == null) {
                    this.componentListener = this.createComponentListener();
                    if (this.componentListener != null) {
                        this.tree.addComponentListener(this.componentListener);
                    }
                }
            } else if (this.componentListener != null) {
                this.tree.removeComponentListener(this.componentListener);
                this.componentListener = null;
            }
        } else if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
            this.componentListener = null;
        }
    }

    protected CellEditorListener createCellEditorListener() {
        return new CellEditorHandler();
    }

    protected CellRendererPane createCellRendererPane() {
        return new CellRendererPane();
    }

    protected ComponentListener createComponentListener() {
        return new ComponentHandler();
    }

    protected TreeCellEditor createDefaultCellEditor() {
        if (this.currentCellRenderer != null && this.currentCellRenderer instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellEditor defaultTreeCellEditor = new DefaultTreeCellEditor(this.tree, (DefaultTreeCellRenderer)this.currentCellRenderer);
            return defaultTreeCellEditor;
        }
        return new DefaultTreeCellEditor(this.tree, null);
    }

    protected TreeCellRenderer createDefaultCellRenderer() {
        return new DefaultTreeCellRenderer();
    }

    protected FocusListener createFocusListener() {
        return new FocusHandler();
    }

    protected KeyListener createKeyListener() {
        return new KeyHandler();
    }

    protected AbstractLayoutCache createLayoutCache() {
        if (this.isLargeModel() && this.getRowHeight() > 0) {
            return new FixedHeightLayoutCache();
        }
        return new VariableHeightLayoutCache();
    }

    protected MouseListener createMouseListener() {
        return new MouseHandler();
    }

    protected AbstractLayoutCache.NodeDimensions createNodeDimensions() {
        return new NodeDimensionsHandler();
    }

    protected PropertyChangeListener createPropertyChangeListener() {
        return new PropertyChangeHandler();
    }

    protected PropertyChangeListener createSelectionModelPropertyChangeListener() {
        return new SelectionModelPropertyChangeHandler();
    }

    protected TreeExpansionListener createTreeExpansionListener() {
        return new TreeExpansionHandler();
    }

    protected TreeModelListener createTreeModelListener() {
        return new TreeModelHandler();
    }

    protected TreeSelectionListener createTreeSelectionListener() {
        return new TreeSelectionHandler();
    }

    public static ComponentUI createUI(JComponent jComponent) {
        return new BasicTreeUI();
    }

    protected void drawCentered(Component component, Graphics graphics, Icon icon, int n, int n2) {
        icon.paintIcon(component, graphics, n - icon.getIconWidth() / 2, n2 - icon.getIconHeight() / 2);
    }

    protected void drawDashedHorizontalLine(Graphics graphics, int n, int n2, int n3) {
        n2 += n2 % 2;
        int n4 = n2;
        while (n4 <= n3) {
            graphics.drawLine(n4, n, n4, n);
            n4 += 2;
        }
    }

    protected void drawDashedVerticalLine(Graphics graphics, int n, int n2, int n3) {
        n2 += n2 % 2;
        int n4 = n2;
        while (n4 <= n3) {
            graphics.drawLine(n, n4, n, n4);
            n4 += 2;
        }
    }

    protected void ensureRowsAreVisible(int n, int n2) {
        if (this.tree != null && n >= 0 && n2 < this.getRowCount(this.tree)) {
            if (n == n2) {
                Rectangle rectangle = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                if (rectangle != null) {
                    rectangle.width += rectangle.x;
                    rectangle.x = 0;
                    this.tree.scrollRectToVisible(rectangle);
                }
            } else {
                Rectangle rectangle = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n));
                Rectangle rectangle2 = this.tree.getVisibleRect();
                Rectangle rectangle3 = rectangle;
                int n3 = rectangle.y;
                int n4 = n3 + rectangle2.height;
                int n5 = n + 1;
                while (n5 <= n2) {
                    rectangle3 = this.getPathBounds(this.tree, this.getPathForRow(this.tree, n5));
                    if (rectangle3.y + rectangle3.height > n4) {
                        n5 = n2;
                    }
                    ++n5;
                }
                RepaintManager repaintManager = RepaintManager.currentManager(this.tree);
                if (repaintManager != null) {
                    repaintManager.validateInvalidComponents();
                }
                this.tree.scrollRectToVisible(new Rectangle(rectangle2.x, n3, 1, rectangle3.y + rectangle3.height - n3));
            }
        }
    }

    private void extendSelection(TreePath treePath) {
        TreePath treePath2 = this.getAnchorPath();
        int n = treePath2 == null ? -1 : this.getRowForPath(this.tree, treePath2);
        int n2 = this.getRowForPath(this.tree, treePath);
        if (n == -1) {
            this.tree.setSelectionRow(n2);
        } else {
            if (n < n2) {
                this.tree.setSelectionInterval(n, n2);
            } else {
                this.tree.setSelectionInterval(n2, n);
            }
            this.setAnchorPath(treePath2);
            this.setLeadPath(treePath);
        }
    }

    private TreePath getAnchorPath() {
        return this.anchorPath;
    }

    protected TreeCellEditor getCellEditor() {
        return this.tree != null ? this.tree.getCellEditor() : null;
    }

    protected TreeCellRenderer getCellRenderer() {
        return this.currentCellRenderer;
    }

    public TreePath getClosestPathForLocation(JTree jTree, int n, int n2) {
        if (jTree != null && this.treeState != null) {
            Insets insets = jTree.getInsets();
            if (insets == null) {
                insets = EMPTY_INSETS;
            }
            return this.treeState.getPathClosestTo(n - insets.left, n2 - insets.top);
        }
        return null;
    }

    public Icon getCollapsedIcon() {
        return this.collapsedIcon;
    }

    public TreePath getEditingPath(JTree jTree) {
        return this.editingPath;
    }

    public Icon getExpandedIcon() {
        return this.expandedIcon;
    }

    protected Color getHashColor() {
        return this.hashColor;
    }

    protected int getHorizontalLegBuffer() {
        return 0;
    }

    protected TreePath getLastChildPath(TreePath treePath) {
        int n;
        if (this.treeModel != null && (n = this.treeModel.getChildCount(treePath.getLastPathComponent())) > 0) {
            return treePath.pathByAddingChild(this.treeModel.getChild(treePath.getLastPathComponent(), n - 1));
        }
        return null;
    }

    private TreePath getLeadPath() {
        return this.leadPath;
    }

    private int getLeadRow() {
        return this.leadRow;
    }

    public int getLeftChildIndent() {
        return this.leftChildIndent;
    }

    public Dimension getMaximumSize(JComponent jComponent) {
        if (this.tree != null) {
            return this.getPreferredSize(this.tree);
        }
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    public Dimension getMinimumSize(JComponent jComponent) {
        if (this.getPreferredMinSize() != null) {
            return this.getPreferredMinSize();
        }
        return new Dimension(0, 0);
    }

    protected TreeModel getModel() {
        return this.treeModel;
    }

    public Rectangle getPathBounds(JTree jTree, TreePath treePath) {
        if (jTree != null && this.treeState != null) {
            Insets insets = jTree.getInsets();
            Rectangle rectangle = this.treeState.getBounds(treePath, null);
            if (rectangle != null && insets != null) {
                rectangle.x += insets.left;
                rectangle.y += insets.top;
            }
            return rectangle;
        }
        return null;
    }

    public TreePath getPathForRow(JTree jTree, int n) {
        return this.treeState != null ? this.treeState.getPathForRow(n) : null;
    }

    public Dimension getPreferredMinSize() {
        if (this.preferredMinSize == null) {
            return null;
        }
        return new Dimension(this.preferredMinSize);
    }

    public Dimension getPreferredSize(JComponent jComponent) {
        return this.getPreferredSize(jComponent, true);
    }

    public Dimension getPreferredSize(JComponent jComponent, boolean bl) {
        Dimension dimension = this.getPreferredMinSize();
        if (!this.validCachedPreferredSize) {
            this.updateCachedPreferredSize();
        }
        if (this.tree != null) {
            if (dimension != null) {
                return new Dimension(Math.max(dimension.width, this.preferredSize.width), Math.max(dimension.height, this.preferredSize.height));
            }
            return new Dimension(this.preferredSize.width, this.preferredSize.height);
        }
        if (dimension != null) {
            return dimension;
        }
        return new Dimension(0, 0);
    }

    public int getRightChildIndent() {
        return this.rightChildIndent;
    }

    public int getRowCount(JTree jTree) {
        return this.treeState != null ? this.treeState.getRowCount() : 0;
    }

    public int getRowForPath(JTree jTree, TreePath treePath) {
        return this.treeState != null ? this.treeState.getRowForPath(treePath) : -1;
    }

    protected int getRowHeight() {
        return this.tree == null ? -1 : this.tree.getRowHeight();
    }

    protected TreeSelectionModel getSelectionModel() {
        return this.treeSelectionModel;
    }

    protected boolean getShowsRootHandles() {
        return this.tree != null ? this.tree.getShowsRootHandles() : false;
    }

    protected int getVerticalLegBuffer() {
        return 0;
    }

    protected void handleExpandControlClick(TreePath treePath, int n, int n2) {
        this.toggleExpandState(treePath);
    }

    protected void installComponents() {
        this.rendererPane = this.createCellRendererPane();
        if (this.rendererPane != null) {
            this.tree.add(this.rendererPane);
        }
    }

    protected void installDefaults() {
        if (this.tree.getBackground() == null || this.tree.getBackground() instanceof UIResource) {
            this.tree.setBackground(UIManager.getColor("Tree.background"));
        }
        if (this.getHashColor() == null || this.getHashColor() instanceof UIResource) {
            this.setHashColor(UIManager.getColor("Tree.hash"));
        }
        if (this.tree.getFont() == null || this.tree.getFont() instanceof UIResource) {
            this.tree.setFont(UIManager.getFont("Tree.font"));
        }
        this.setExpandedIcon((Icon)UIManager.get("Tree.expandedIcon"));
        this.setCollapsedIcon((Icon)UIManager.get("Tree.collapsedIcon"));
        this.setLeftChildIndent((Integer)UIManager.get("Tree.leftChildIndent"));
        this.setRightChildIndent((Integer)UIManager.get("Tree.rightChildIndent"));
        this.changeSelectionWithFocus = (Boolean)UIManager.get("Tree.changeSelectionWithFocus");
    }

    protected void installKeyboardActions() {
        boolean bl = this.changeSelectionWithFocus();
        this.keyActions = new Vector(33);
        class Javax_swing_plaf_basic_BasicTreeUI$1 {
            /* synthetic */ Javax_swing_plaf_basic_BasicTreeUI$1() {
            }
        }
        this.registerKeyAction(new TreeIncrementAction(null, -1, "UP", false, bl), KeyStroke.getKeyStroke(38, 0));
        this.registerKeyAction(new TreeIncrementAction(null, -1, "SELECT_UP", true, true), KeyStroke.getKeyStroke(38, 1));
        this.registerKeyAction(new TreeIncrementAction(null, 1, "DOWN", false, bl), KeyStroke.getKeyStroke(40, 0));
        this.registerKeyAction(new TreeIncrementAction(null, 1, "SELECT_DOWN", true, true), KeyStroke.getKeyStroke(40, 1));
        this.registerKeyAction(new TreeTraverseAction(null, 1, "RIGHT", bl), KeyStroke.getKeyStroke(39, 0));
        this.registerKeyAction(new TreeTraverseAction(null, -1, "LEFT", bl), KeyStroke.getKeyStroke(37, 0));
        this.registerKeyAction(new TreePageAction(null, -1, "P_UP", false, bl), KeyStroke.getKeyStroke(33, 0));
        this.registerKeyAction(new TreePageAction(null, -1, "SELECT_P_UP", true, true), KeyStroke.getKeyStroke(33, 1));
        this.registerKeyAction(new TreePageAction(null, 1, "P_DOWN", false, bl), KeyStroke.getKeyStroke(34, 0));
        this.registerKeyAction(new TreePageAction(null, 1, "SELECT_P_DOWN", true, true), KeyStroke.getKeyStroke(34, 1));
        this.registerKeyAction(new TreeHomeAction(null, -1, "HOME", false, bl), KeyStroke.getKeyStroke(36, 0));
        this.registerKeyAction(new TreeHomeAction(null, -1, "SELECT_HOME", true, true), KeyStroke.getKeyStroke(36, 1));
        this.registerKeyAction(new TreeHomeAction(null, 1, "END", false, bl), KeyStroke.getKeyStroke(35, 0));
        this.registerKeyAction(new TreeHomeAction(null, 1, "SELECT_END", true, true), KeyStroke.getKeyStroke(35, 1));
        this.registerKeyAction(new TreeToggleAction("TOGGLE"), KeyStroke.getKeyStroke(10, 0));
        KeyStroke keyStroke = KeyStroke.getKeyStroke(27, 0);
        this.tree.registerKeyboardAction(new TreeCancelEditingAction("ESCAPE"), keyStroke, 1);
        this.keyActions.addElement(keyStroke);
        this.registerKeyAction(new TreeEditAction("EDIT_NODE"), KeyStroke.getKeyStroke(113, 0));
        TreeSelectAllAction treeSelectAllAction = new TreeSelectAllAction("SELECT_ALL", true);
        this.registerKeyAction(treeSelectAllAction, KeyStroke.getKeyStroke(65, 2));
        this.registerKeyAction(treeSelectAllAction, KeyStroke.getKeyStroke(47, 2));
        this.registerKeyAction(new TreeSelectAllAction("UNSELECT_ALL", false), KeyStroke.getKeyStroke(92, 2));
        this.registerKeyAction(new TreeAddSelectionAction("SELECT_NODE", false), KeyStroke.getKeyStroke(32, 2));
        this.registerKeyAction(new TreeExtendSelectionAction("EXTEND_SELECTION"), KeyStroke.getKeyStroke(32, 1));
        if (bl) {
            this.registerKeyAction(new TreeHomeAction(null, -1, "HOME", false, false), KeyStroke.getKeyStroke(36, 2));
            this.registerKeyAction(new TreeHomeAction(null, 1, "END", false, false), KeyStroke.getKeyStroke(35, 2));
            this.registerKeyAction(new TreeIncrementAction(null, -1, "UP", false, false), KeyStroke.getKeyStroke(38, 2));
            this.registerKeyAction(new TreeIncrementAction(null, 1, "DOWN", false, false), KeyStroke.getKeyStroke(40, 2));
            this.registerKeyAction(new TreePageAction(null, 1, "LEAD_P_DOWN", false, false), KeyStroke.getKeyStroke(34, 2));
            this.registerKeyAction(new TreePageAction(null, 1, "SELECT_P_DOWN", true, true), KeyStroke.getKeyStroke(34, 3));
            this.registerKeyAction(new TreePageAction(null, -1, "LEAD_P_UP", false, false), KeyStroke.getKeyStroke(33, 2));
            this.registerKeyAction(new TreePageAction(null, -1, "SELECT_P_UP", true, true), KeyStroke.getKeyStroke(33, 3));
            this.registerKeyAction(new ScrollAction(this.tree, 0, -10), KeyStroke.getKeyStroke(37, 2));
            this.registerKeyAction(new ScrollAction(this.tree, 0, 10), KeyStroke.getKeyStroke(39, 2));
            this.registerKeyAction(new TreeAddSelectionAction("SELECT_NODE", false), KeyStroke.getKeyStroke(32, 0));
        } else {
            this.registerKeyAction(new TreeScrollLRAction(1, "CTRL_P_DOWN", false), KeyStroke.getKeyStroke(34, 2));
            this.registerKeyAction(new TreeScrollLRAction(-1, "CTRL_P_UP", false), KeyStroke.getKeyStroke(33, 2));
            this.registerKeyAction(new TreeScrollLRAction(-1, "SELECT_CTRL_P_UP", true), KeyStroke.getKeyStroke(33, 3));
            this.registerKeyAction(new TreeScrollLRAction(1, "SELECT_CTRL_P_DOWN", true), KeyStroke.getKeyStroke(34, 3));
            this.registerKeyAction(new TreeAddSelectionAction("SELECT_NODE", true), KeyStroke.getKeyStroke(32, 0));
        }
    }

    protected void installListeners() {
        this.propertyChangeListener = this.createPropertyChangeListener();
        if (this.propertyChangeListener != null) {
            this.tree.addPropertyChangeListener(this.propertyChangeListener);
        }
        if ((this.mouseListener = this.createMouseListener()) != null) {
            this.tree.addMouseListener(this.mouseListener);
        }
        if ((this.focusListener = this.createFocusListener()) != null) {
            this.tree.addFocusListener(this.focusListener);
        }
        if ((this.keyListener = this.createKeyListener()) != null) {
            this.tree.addKeyListener(this.keyListener);
        }
        if ((this.treeExpansionListener = this.createTreeExpansionListener()) != null) {
            this.tree.addTreeExpansionListener(this.treeExpansionListener);
        }
        if ((this.treeModelListener = this.createTreeModelListener()) != null && this.treeModel != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if ((this.selectionModelPropertyChangeListener = this.createSelectionModelPropertyChangeListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if ((this.treeSelectionListener = this.createTreeSelectionListener()) != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
        }
    }

    public void installUI(JComponent jComponent) {
        if (jComponent == null) {
            throw new NullPointerException("null component passed to BasicTreeUI.installUI()");
        }
        this.tree = (JTree)jComponent;
        this.prepareForUIInstall();
        this.installDefaults();
        this.installListeners();
        this.installKeyboardActions();
        this.installComponents();
        this.completeUIInstall();
    }

    protected boolean isEditable() {
        return this.tree != null ? this.tree.isEditable() : false;
    }

    public boolean isEditing(JTree jTree) {
        return this.editingComponent != null;
    }

    protected boolean isLargeModel() {
        return this.largeModel;
    }

    protected boolean isLeaf(int n) {
        TreePath treePath = this.getPathForRow(this.tree, n);
        if (treePath != null) {
            return this.treeModel.isLeaf(treePath.getLastPathComponent());
        }
        return true;
    }

    protected boolean isLocationInExpandControl(TreePath treePath, int n, int n2) {
        if (treePath != null && !this.treeModel.isLeaf(treePath.getLastPathComponent())) {
            Insets insets = this.tree.getInsets();
            int n3 = this.getExpandedIcon() != null ? this.getExpandedIcon().getIconWidth() : 8;
            int n4 = insets != null ? insets.left : 0;
            int n5 = (n4 += (treePath.getPathCount() + this.depthOffset - 2) * this.totalChildIndent + this.getLeftChildIndent() - n3 / 2) + n3;
            return n >= n4 && n <= n5;
        }
        return false;
    }

    protected boolean isMultiSelectEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isShiftDown();
    }

    protected boolean isRootVisible() {
        return this.tree != null ? this.tree.isRootVisible() : false;
    }

    protected boolean isToggleEvent(MouseEvent mouseEvent) {
        if (!SwingUtilities.isLeftMouseButton(mouseEvent)) {
            return false;
        }
        int n = 2;
        if (n <= 0) {
            return false;
        }
        return mouseEvent.getClickCount() == n;
    }

    protected boolean isToggleSelectionEvent(MouseEvent mouseEvent) {
        return SwingUtilities.isLeftMouseButton(mouseEvent) && mouseEvent.isControlDown();
    }

    public void paint(Graphics graphics, JComponent jComponent) {
        if (this.tree != jComponent) {
            throw new InternalError("incorrect component");
        }
        if (this.treeState == null) {
            return;
        }
        Rectangle rectangle = graphics.getClipBounds();
        Insets insets = this.tree.getInsets();
        if (insets == null) {
            insets = EMPTY_INSETS;
        }
        TreePath treePath = this.getClosestPathForLocation(this.tree, 0, rectangle.y);
        Enumeration enumeration = this.treeState.getVisiblePathsFrom(treePath);
        int n = this.treeState.getRowForPath(treePath);
        int n2 = rectangle.y + rectangle.height;
        this.drawingCache.clear();
        if (treePath != null && enumeration != null) {
            TreePath treePath2 = treePath;
            treePath2 = treePath2.getParentPath();
            while (treePath2 != null) {
                this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                this.drawingCache.put(treePath2, Boolean.TRUE);
                treePath2 = treePath2.getParentPath();
            }
            boolean bl = false;
            Rectangle rectangle2 = new Rectangle();
            boolean bl2 = this.isRootVisible();
            while (!bl && enumeration.hasMoreElements()) {
                TreePath treePath3 = (TreePath)enumeration.nextElement();
                if (treePath3 != null) {
                    boolean bl3;
                    boolean bl4;
                    boolean bl5 = this.treeModel.isLeaf(treePath3.getLastPathComponent());
                    if (bl5) {
                        bl4 = false;
                        bl3 = false;
                    } else {
                        bl3 = this.treeState.getExpandedState(treePath3);
                        bl4 = this.tree.hasBeenExpanded(treePath3);
                    }
                    Rectangle rectangle3 = this.treeState.getBounds(treePath3, rectangle2);
                    if (rectangle3 == null) {
                        return;
                    }
                    rectangle3.x += insets.left;
                    rectangle3.y += insets.top;
                    treePath2 = treePath3.getParentPath();
                    if (treePath2 != null) {
                        if (this.drawingCache.get(treePath2) == null) {
                            this.paintVerticalPartOfLeg(graphics, rectangle, insets, treePath2);
                            this.drawingCache.put(treePath2, Boolean.TRUE);
                        }
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle3, treePath3, n, bl3, bl4, bl5);
                    } else if (bl2 && n == 0) {
                        this.paintHorizontalPartOfLeg(graphics, rectangle, insets, rectangle3, treePath3, n, bl3, bl4, bl5);
                    }
                    if (this.shouldPaintExpandControl(treePath3, n, bl3, bl4, bl5)) {
                        this.paintExpandControl(graphics, rectangle, insets, rectangle3, treePath3, n, bl3, bl4, bl5);
                    }
                    this.paintRow(graphics, rectangle, insets, rectangle3, treePath3, n, bl3, bl4, bl5);
                    if (rectangle3.y + rectangle3.height >= n2) {
                        bl = true;
                    }
                } else {
                    bl = true;
                }
                ++n;
            }
        }
    }

    protected void paintExpandControl(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        Object object = treePath.getLastPathComponent();
        if (!(bl3 || bl2 && this.treeModel.getChildCount(object) <= 0)) {
            int n2 = rectangle2.x - (this.getRightChildIndent() - 1);
            int n3 = rectangle2.y + rectangle2.height / 2;
            if (bl) {
                Icon icon = this.getExpandedIcon();
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n2, n3);
                }
            } else {
                Icon icon = this.getCollapsedIcon();
                if (icon != null) {
                    this.drawCentered(this.tree, graphics, icon, n2, n3);
                }
            }
        }
    }

    protected void paintHorizontalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.drawLine(n2, n, n3, n);
    }

    protected void paintHorizontalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        int n2 = rectangle.x;
        int n3 = rectangle.x + (rectangle.width - 1);
        int n4 = rectangle.y;
        int n5 = rectangle.y + (rectangle.height - 1);
        int n6 = rectangle2.y + rectangle2.height / 2;
        int n7 = rectangle2.x - this.totalChildIndent + 8;
        int n8 = rectangle2.x - this.getHorizontalLegBuffer();
        if (n6 > n4 && n6 < n5 && n8 > n2 && n7 < n3) {
            n7 = Math.max(n7, n2);
            n8 = Math.min(n8, n3);
            graphics.setColor(this.getHashColor());
            this.paintHorizontalLine(graphics, this.tree, n6, n7, n8);
        }
    }

    protected void paintRow(Graphics graphics, Rectangle rectangle, Insets insets, Rectangle rectangle2, TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (this.editingComponent != null && this.editingRow == n) {
            return;
        }
        int n2 = this.tree.hasFocus() ? this.getLeadRow() : -1;
        Component component = this.currentCellRenderer.getTreeCellRendererComponent(this.tree, treePath.getLastPathComponent(), this.tree.isRowSelected(n), bl, bl3, n, n2 == n);
        this.rendererPane.paintComponent(graphics, component, this.tree, rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height, true);
    }

    protected void paintVerticalLine(Graphics graphics, JComponent jComponent, int n, int n2, int n3) {
        graphics.drawLine(n, n2, n, n3);
    }

    protected void paintVerticalPartOfLeg(Graphics graphics, Rectangle rectangle, Insets insets, TreePath treePath) {
        int n = (treePath.getPathCount() - 1 + this.depthOffset) * this.totalChildIndent + 8 + insets.left;
        int n2 = rectangle.x;
        int n3 = rectangle.x + (rectangle.width - 1);
        if (n > n2 && n < n3) {
            Object object;
            TreeModel treeModel;
            int n4 = rectangle.y;
            int n5 = rectangle.y + rectangle.height;
            Rectangle rectangle2 = this.getPathBounds(this.tree, treePath);
            Rectangle rectangle3 = this.getPathBounds(this.tree, this.getLastChildPath(treePath));
            if (rectangle3 == null) {
                return;
            }
            int n6 = rectangle2 == null ? Math.max(insets.top + this.getVerticalLegBuffer(), n4) : Math.max(rectangle2.y + rectangle2.height + this.getVerticalLegBuffer(), n4);
            if (treePath.getPathCount() == 1 && !this.isRootVisible() && (treeModel = this.getModel()) != null && treeModel.getChildCount(object = treeModel.getRoot()) > 0 && (rectangle2 = this.getPathBounds(this.tree, treePath.pathByAddingChild(treeModel.getChild(object, 0)))) != null) {
                n6 = Math.max(insets.top + this.getVerticalLegBuffer(), rectangle2.y + rectangle2.height / 2);
            }
            int n7 = Math.min(rectangle3.y + rectangle3.height / 2, n5);
            graphics.setColor(this.getHashColor());
            this.paintVerticalLine(graphics, this.tree, n, n6, n7);
        }
    }

    protected void pathWasCollapsed(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeCollapsed(treePath);
        }
    }

    protected void pathWasExpanded(TreePath treePath) {
        if (this.tree != null) {
            this.tree.fireTreeExpanded(treePath);
        }
    }

    protected void prepareForUIInstall() {
        this.drawingCache = new Hashtable(7);
        this.stopEditingInCompleteEditing = true;
        this.lastSelectedRow = -1;
        this.anchorPath = null;
        this.leadPath = null;
        this.leadRow = -1;
        this.preferredSize = new Dimension();
        this.tree.setRowHeight(UIManager.getInt("Tree.rowHeight"));
        Object object = UIManager.get("Tree.scrollsOnExpand");
        if (object != null) {
            this.tree.setScrollsOnExpand((Boolean)object);
        }
        this.largeModel = this.tree.isLargeModel();
        if (this.getRowHeight() <= 0) {
            this.largeModel = false;
        }
        this.setModel(this.tree.getModel());
    }

    protected void prepareForUIUninstall() {
    }

    private void registerKeyAction(Action action, KeyStroke keyStroke) {
        this.keyActions.addElement(keyStroke);
        this.tree.registerKeyboardAction(action, keyStroke, 0);
    }

    protected void selectPathForEvent(TreePath treePath, MouseEvent mouseEvent) {
        if (this.isToggleSelectionEvent(mouseEvent)) {
            if (this.tree.isPathSelected(treePath)) {
                this.tree.removeSelectionPath(treePath);
            } else {
                this.tree.addSelectionPath(treePath);
            }
            this.lastSelectedRow = this.getRowForPath(this.tree, treePath);
            this.setAnchorPath(treePath);
            this.setLeadPath(treePath);
        } else if (this.isMultiSelectEvent(mouseEvent)) {
            int n;
            TreePath treePath2 = this.getAnchorPath();
            int n2 = n = treePath2 == null ? -1 : this.getRowForPath(this.tree, treePath2);
            if (n == -1) {
                this.tree.setSelectionPath(treePath);
            } else {
                int n3 = this.getRowForPath(this.tree, treePath);
                TreePath treePath3 = treePath2;
                if (n3 < n) {
                    this.tree.setSelectionInterval(n3, n);
                } else {
                    this.tree.setSelectionInterval(n, n3);
                }
                this.lastSelectedRow = n3;
                this.setAnchorPath(treePath3);
            }
        } else if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
            this.tree.setSelectionPath(treePath);
            if (this.isToggleEvent(mouseEvent)) {
                this.toggleExpandState(treePath);
            }
        }
    }

    private void setAnchorPath(TreePath treePath) {
        this.anchorPath = treePath;
    }

    protected void setCellEditor(TreeCellEditor treeCellEditor) {
        this.updateCellEditor();
    }

    protected void setCellRenderer(TreeCellRenderer treeCellRenderer) {
        this.completeEditing();
        this.updateRenderer();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    public void setCollapsedIcon(Icon icon) {
        this.collapsedIcon = icon;
    }

    protected void setEditable(boolean bl) {
        this.updateCellEditor();
    }

    public void setExpandedIcon(Icon icon) {
        this.expandedIcon = icon;
    }

    protected void setHashColor(Color color) {
        this.hashColor = color;
    }

    protected void setLargeModel(boolean bl) {
        if (this.getRowHeight() < 1) {
            bl = false;
        }
        if (this.largeModel != bl) {
            this.completeEditing();
            this.largeModel = bl;
            this.treeState = this.createLayoutCache();
            this.configureLayoutCache();
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    private void setLeadPath(TreePath treePath) {
        this.setLeadPath(treePath, false);
    }

    private void setLeadPath(TreePath treePath, boolean bl) {
        Rectangle rectangle = bl ? this.getPathBounds(this.tree, this.leadPath) : null;
        this.leadPath = treePath;
        this.leadRow = this.getRowForPath(this.tree, this.leadPath);
        if (bl) {
            if (rectangle != null) {
                this.tree.repaint(rectangle);
            }
            if ((rectangle = this.getPathBounds(this.tree, this.leadPath)) != null) {
                this.tree.repaint(rectangle);
            }
        }
    }

    public void setLeftChildIndent(int n) {
        this.leftChildIndent = n;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    protected void setModel(TreeModel treeModel) {
        this.completeEditing();
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        this.treeModel = treeModel;
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.addTreeModelListener(this.treeModelListener);
        }
        if (this.treeState != null) {
            this.treeState.setModel(treeModel);
            this.updateLayoutCacheExpandedNodes();
            this.updateSize();
        }
    }

    public void setPreferredMinSize(Dimension dimension) {
        this.preferredMinSize = dimension;
    }

    public void setRightChildIndent(int n) {
        this.rightChildIndent = n;
        this.totalChildIndent = this.leftChildIndent + this.rightChildIndent;
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
        }
        this.updateSize();
    }

    protected void setRootVisible(boolean bl) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.setRootVisible(bl);
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected void setRowHeight(int n) {
        this.completeEditing();
        if (this.treeState != null) {
            this.setLargeModel(this.tree.isLargeModel());
            this.treeState.setRowHeight(n);
            this.updateSize();
        }
    }

    protected void setSelectionModel(TreeSelectionModel treeSelectionModel) {
        this.completeEditing();
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
        this.treeSelectionModel = treeSelectionModel;
        if (this.treeSelectionModel != null) {
            if (this.selectionModelPropertyChangeListener != null) {
                this.treeSelectionModel.addPropertyChangeListener(this.selectionModelPropertyChangeListener);
            }
            if (this.treeSelectionListener != null) {
                this.treeSelectionModel.addTreeSelectionListener(this.treeSelectionListener);
            }
            if (this.treeState != null) {
                this.treeState.setSelectionModel(this.treeSelectionModel);
            }
        } else if (this.treeState != null) {
            this.treeState.setSelectionModel(null);
        }
        if (this.tree != null) {
            this.tree.repaint();
        }
    }

    protected void setShowsRootHandles(boolean bl) {
        this.completeEditing();
        this.updateDepthOffset();
        if (this.treeState != null) {
            this.treeState.invalidateSizes();
            this.updateSize();
        }
    }

    protected boolean shouldPaintExpandControl(TreePath treePath, int n, boolean bl, boolean bl2, boolean bl3) {
        if (bl) {
            return true;
        }
        if (bl3) {
            return false;
        }
        int n2 = treePath.getPathCount() - 1;
        return this.getShowsRootHandles() || n2 != 0 && (n2 != 1 || this.isRootVisible());
    }

    protected boolean startEditing(TreePath treePath, MouseEvent mouseEvent) {
        this.completeEditing();
        if (this.cellEditor != null && this.tree.isPathEditable(treePath)) {
            int n = this.getRowForPath(this.tree, treePath);
            this.editingComponent = this.cellEditor.getTreeCellEditorComponent(this.tree, treePath.getLastPathComponent(), this.tree.isPathSelected(treePath), this.tree.isExpanded(treePath), this.treeModel.isLeaf(treePath.getLastPathComponent()), n);
            if (this.cellEditor.isCellEditable(mouseEvent)) {
                Rectangle rectangle = this.getPathBounds(this.tree, treePath);
                this.editingRow = n;
                Dimension dimension = this.editingComponent.getPreferredSize();
                if (dimension.height != rectangle.height && this.getRowHeight() > 0) {
                    dimension.height = this.getRowHeight();
                }
                if (dimension.width != rectangle.width || dimension.height != rectangle.height) {
                    this.editorHasDifferentSize = true;
                    this.treeState.invalidatePathBounds(treePath);
                    this.updateSize();
                } else {
                    this.editorHasDifferentSize = false;
                }
                this.tree.add(this.editingComponent);
                this.editingComponent.setBounds(rectangle.x, rectangle.y, dimension.width, dimension.height);
                this.editingPath = treePath;
                this.editingComponent.validate();
                Rectangle rectangle2 = this.tree.getVisibleRect();
                this.tree.paintImmediately(rectangle.x, rectangle.y, rectangle2.width + rectangle2.x - rectangle.x, dimension.height);
                if (this.cellEditor.shouldSelectCell(mouseEvent)) {
                    this.stopEditingInCompleteEditing = false;
                    try {
                        this.tree.setSelectionRow(n);
                    }
                    catch (Exception exception) {
                        System.err.println("Editing exception: " + exception);
                    }
                    this.stopEditingInCompleteEditing = true;
                }
                if (mouseEvent != null && mouseEvent instanceof MouseEvent) {
                    Point point = SwingUtilities.convertPoint(this.tree, new Point(mouseEvent.getX(), mouseEvent.getY()), this.editingComponent);
                    new MouseInputHandler(this.tree, SwingUtilities.getDeepestComponentAt(this.editingComponent, point.x, point.y), mouseEvent);
                }
                return true;
            }
            this.editingComponent = null;
        }
        return false;
    }

    public void startEditingAtPath(JTree jTree, TreePath treePath) {
        jTree.scrollPathToVisible(treePath);
        if (treePath != null && jTree.isVisible(treePath)) {
            this.startEditing(treePath, null);
        }
    }

    public boolean stopEditing(JTree jTree) {
        if (this.editingComponent != null && this.cellEditor.stopCellEditing()) {
            this.completeEditing(false, false, true);
            return true;
        }
        return false;
    }

    protected void toggleExpandState(TreePath treePath) {
        if (!this.tree.isExpanded(treePath)) {
            int n = this.getRowForPath(this.tree, treePath);
            this.tree.expandPath(treePath);
            this.updateSize();
            if (n != -1) {
                if (this.tree.getScrollsOnExpand()) {
                    this.ensureRowsAreVisible(n, n + this.treeState.getVisibleChildCount(treePath));
                } else {
                    this.ensureRowsAreVisible(n, n);
                }
            }
        } else {
            this.tree.collapsePath(treePath);
            this.updateSize();
        }
    }

    protected void uninstallComponents() {
        if (this.rendererPane != null) {
            this.tree.remove(this.rendererPane);
        }
    }

    protected void uninstallDefaults() {
    }

    protected void uninstallKeyboardActions() {
        int n = this.keyActions.size() - 1;
        while (n >= 0) {
            this.tree.unregisterKeyboardAction((KeyStroke)this.keyActions.elementAt(n));
            --n;
        }
        this.keyActions = null;
    }

    protected void uninstallListeners() {
        if (this.componentListener != null) {
            this.tree.removeComponentListener(this.componentListener);
        }
        if (this.propertyChangeListener != null) {
            this.tree.removePropertyChangeListener(this.propertyChangeListener);
        }
        if (this.mouseListener != null) {
            this.tree.removeMouseListener(this.mouseListener);
        }
        if (this.focusListener != null) {
            this.tree.removeFocusListener(this.focusListener);
        }
        if (this.keyListener != null) {
            this.tree.removeKeyListener(this.keyListener);
        }
        if (this.treeExpansionListener != null) {
            this.tree.addTreeExpansionListener(this.treeExpansionListener);
        }
        if (this.treeModel != null && this.treeModelListener != null) {
            this.treeModel.removeTreeModelListener(this.treeModelListener);
        }
        if (this.selectionModelPropertyChangeListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removePropertyChangeListener(this.selectionModelPropertyChangeListener);
        }
        if (this.treeSelectionListener != null && this.treeSelectionModel != null) {
            this.treeSelectionModel.removeTreeSelectionListener(this.treeSelectionListener);
        }
    }

    public void uninstallUI(JComponent jComponent) {
        this.completeEditing();
        this.prepareForUIUninstall();
        this.uninstallDefaults();
        this.uninstallListeners();
        this.uninstallKeyboardActions();
        this.uninstallComponents();
        this.completeUIUninstall();
    }

    protected void updateCachedPreferredSize() {
        if (this.treeState != null) {
            Insets insets = this.tree.getInsets();
            if (this.isLargeModel()) {
                Rectangle rectangle = this.tree.getVisibleRect();
                if (insets != null) {
                    rectangle.x -= insets.left;
                    rectangle.y -= insets.top;
                }
                this.preferredSize.width = this.treeState.getPreferredWidth(rectangle);
            } else {
                this.preferredSize.width = this.treeState.getPreferredWidth(null);
            }
            this.preferredSize.height = this.treeState.getPreferredHeight();
            if (insets != null) {
                this.preferredSize.width += insets.left + insets.right;
                this.preferredSize.height += insets.top + insets.bottom;
            }
        }
        this.validCachedPreferredSize = true;
    }

    protected void updateCellEditor() {
        TreeCellEditor treeCellEditor;
        this.completeEditing();
        if (this.tree == null) {
            treeCellEditor = null;
        } else if (this.tree.isEditable()) {
            treeCellEditor = this.tree.getCellEditor();
            if (treeCellEditor == null && (treeCellEditor = this.createDefaultCellEditor()) != null) {
                this.tree.setCellEditor(treeCellEditor);
                this.createdCellEditor = true;
            }
        } else {
            treeCellEditor = null;
        }
        if (treeCellEditor != this.cellEditor) {
            if (this.cellEditor != null && this.cellEditorListener != null) {
                this.cellEditor.removeCellEditorListener(this.cellEditorListener);
            }
            this.cellEditor = treeCellEditor;
            if (this.cellEditorListener == null) {
                this.cellEditorListener = this.createCellEditorListener();
            }
            if (treeCellEditor != null && this.cellEditorListener != null) {
                treeCellEditor.addCellEditorListener(this.cellEditorListener);
            }
            this.createdCellEditor = false;
        }
    }

    protected void updateDepthOffset() {
        this.depthOffset = this.isRootVisible() ? (this.getShowsRootHandles() ? 1 : 0) : (!this.getShowsRootHandles() ? -1 : 0);
    }

    protected void updateExpandedDescendants(TreePath treePath) {
        this.completeEditing();
        if (this.treeState != null) {
            this.treeState.setExpandedState(treePath, true);
            Enumeration enumeration = this.tree.getExpandedDescendants(treePath);
            if (enumeration != null) {
                while (enumeration.hasMoreElements()) {
                    treePath = (TreePath)enumeration.nextElement();
                    this.treeState.setExpandedState(treePath, true);
                }
            }
            this.updateLeadRow();
            this.updateSize();
        }
    }

    protected void updateLayoutCacheExpandedNodes() {
        if (this.treeModel != null) {
            this.updateExpandedDescendants(new TreePath(this.treeModel.getRoot()));
        }
    }

    private void updateLeadRow() {
        this.leadRow = this.getRowForPath(this.tree, this.leadPath);
    }

    protected void updateRenderer() {
        if (this.tree != null) {
            TreeCellRenderer treeCellRenderer = this.tree.getCellRenderer();
            if (treeCellRenderer == null) {
                this.tree.setCellRenderer(this.createDefaultCellRenderer());
                this.createdRenderer = true;
            } else {
                this.createdRenderer = false;
                this.currentCellRenderer = treeCellRenderer;
                if (this.createdCellEditor) {
                    this.tree.setCellEditor(null);
                }
            }
        } else {
            this.createdRenderer = false;
            this.currentCellRenderer = null;
        }
        this.updateCellEditor();
    }

    protected void updateSize() {
        this.validCachedPreferredSize = false;
        this.tree.treeDidChange();
    }

    public class TreeExpansionHandler
    implements TreeExpansionListener {
        public void treeCollapsed(TreeExpansionEvent treeExpansionEvent) {
            if (treeExpansionEvent != null && BasicTreeUI.this.tree != null) {
                TreePath treePath = treeExpansionEvent.getPath();
                BasicTreeUI.this.completeEditing();
                if (treePath != null && BasicTreeUI.this.tree.isVisible(treePath)) {
                    BasicTreeUI.this.treeState.setExpandedState(treePath, false);
                    BasicTreeUI.this.updateLeadRow();
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        public void treeExpanded(TreeExpansionEvent treeExpansionEvent) {
            if (treeExpansionEvent != null && BasicTreeUI.this.tree != null) {
                TreePath treePath = treeExpansionEvent.getPath();
                BasicTreeUI.this.updateExpandedDescendants(treePath);
            }
        }
    }

    public class ComponentHandler
    extends ComponentAdapter
    implements ActionListener {
        protected Timer timer;
        protected JScrollBar scrollBar;

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                if (this.timer != null) {
                    this.timer.stop();
                }
                BasicTreeUI.this.updateSize();
                this.timer = null;
                this.scrollBar = null;
            }
        }

        public void componentMoved(ComponentEvent componentEvent) {
            if (this.timer == null) {
                JScrollPane jScrollPane = this.getScrollPane();
                if (jScrollPane == null) {
                    BasicTreeUI.this.updateSize();
                } else {
                    this.scrollBar = jScrollPane.getVerticalScrollBar();
                    if (this.scrollBar == null || !this.scrollBar.getValueIsAdjusting()) {
                        this.scrollBar = jScrollPane.getHorizontalScrollBar();
                        if (this.scrollBar != null && this.scrollBar.getValueIsAdjusting()) {
                            this.startTimer();
                        } else {
                            BasicTreeUI.this.updateSize();
                        }
                    } else {
                        this.startTimer();
                    }
                }
            }
        }

        protected JScrollPane getScrollPane() {
            Container container = BasicTreeUI.this.tree.getParent();
            while (container != null && !(container instanceof JScrollPane)) {
                container = container.getParent();
            }
            if (container instanceof JScrollPane) {
                return (JScrollPane)container;
            }
            return null;
        }

        protected void startTimer() {
            if (this.timer == null) {
                this.timer = new Timer(200, this);
                this.timer.setRepeats(true);
            }
            this.timer.start();
        }
    }

    public class TreeModelHandler
    implements TreeModelListener {
        public void treeNodesChanged(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesChanged(treeModelEvent);
                TreePath treePath = treeModelEvent.getTreePath().getParentPath();
                if (treePath == null || BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        public void treeNodesInserted(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesInserted(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                } else {
                    int[] nArray = treeModelEvent.getChildIndices();
                    int n = BasicTreeUI.this.treeModel.getChildCount(treePath.getLastPathComponent());
                    if (nArray != null && n - nArray.length == 0) {
                        BasicTreeUI.this.updateSize();
                    }
                }
            }
        }

        public void treeNodesRemoved(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeNodesRemoved(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath();
                if (BasicTreeUI.this.treeState.isExpanded(treePath) || BasicTreeUI.this.treeModel.getChildCount(treePath.getLastPathComponent()) == 0) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }

        public void treeStructureChanged(TreeModelEvent treeModelEvent) {
            if (BasicTreeUI.this.treeState != null && treeModelEvent != null) {
                BasicTreeUI.this.treeState.treeStructureChanged(treeModelEvent);
                BasicTreeUI.this.updateLeadRow();
                TreePath treePath = treeModelEvent.getTreePath().getParentPath();
                if (treePath == null || BasicTreeUI.this.treeState.isExpanded(treePath)) {
                    BasicTreeUI.this.updateSize();
                }
            }
        }
    }

    public class TreeSelectionHandler
    implements TreeSelectionListener {
        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            Rectangle rectangle;
            TreePath[] treePathArray;
            BasicTreeUI.this.completeEditing();
            if (BasicTreeUI.this.treeSelectionModel != null && (treePathArray = BasicTreeUI.this.treeSelectionModel.getSelectionPaths()) != null) {
                int n = treePathArray.length - 1;
                while (n >= 0) {
                    BasicTreeUI.this.tree.makeVisible(treePathArray[n]);
                    --n;
                }
            }
            treePathArray = BasicTreeUI.this.leadPath;
            BasicTreeUI.this.lastSelectedRow = BasicTreeUI.this.tree.getMinSelectionRow();
            TreePath treePath = BasicTreeUI.this.tree.getLeadSelectionPath();
            BasicTreeUI.this.setAnchorPath(treePath);
            BasicTreeUI.this.setLeadPath(treePath);
            TreePath[] treePathArray2 = treeSelectionEvent.getPaths();
            Rectangle rectangle2 = BasicTreeUI.this.tree.getVisibleRect();
            boolean bl = true;
            int n = BasicTreeUI.this.tree.getSize().width;
            if (treePathArray2 != null) {
                int n2 = treePathArray2.length;
                if (n2 > 4) {
                    BasicTreeUI.this.tree.repaint();
                    bl = false;
                } else {
                    int n3 = 0;
                    while (n3 < n2) {
                        rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePathArray2[n3]);
                        if (rectangle != null && rectangle2.intersects(rectangle)) {
                            BasicTreeUI.this.tree.repaint(0, rectangle.y, n, rectangle.height);
                        }
                        ++n3;
                    }
                }
            }
            if (bl) {
                rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treeSelectionEvent.getOldLeadSelectionPath());
                if (rectangle != null && rectangle2.intersects(rectangle)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle.y, n, rectangle.height);
                }
                if ((rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treeSelectionEvent.getNewLeadSelectionPath())) != null && rectangle2.intersects(rectangle)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle.y, n, rectangle.height);
                }
                if ((rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, (TreePath)treePathArray)) != null && rectangle2.intersects(rectangle)) {
                    BasicTreeUI.this.tree.repaint(0, rectangle.y, n, rectangle.height);
                }
            }
        }
    }

    public class CellEditorHandler
    implements CellEditorListener {
        public void editingCanceled(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, false);
        }

        public void editingStopped(ChangeEvent changeEvent) {
            BasicTreeUI.this.completeEditing(false, false, true);
        }
    }

    public class KeyHandler
    extends KeyAdapter {
        protected Action repeatKeyAction;
        protected boolean isKeyDown;

        public void keyPressed(KeyEvent keyEvent) {
            if (BasicTreeUI.this.tree.hasFocus() && BasicTreeUI.this.tree.isEnabled()) {
                ActionListener actionListener;
                KeyStroke keyStroke = KeyStroke.getKeyStroke(keyEvent.getKeyCode(), keyEvent.getModifiers());
                this.repeatKeyAction = BasicTreeUI.this.tree.getConditionForKeyStroke(keyStroke) == 0 ? ((actionListener = BasicTreeUI.this.tree.getActionForKeyStroke(keyStroke)) instanceof Action ? (Action)actionListener : null) : null;
                if (this.isKeyDown && this.repeatKeyAction != null) {
                    this.repeatKeyAction.actionPerformed(null);
                    keyEvent.consume();
                } else {
                    this.isKeyDown = true;
                }
            }
        }

        public void keyReleased(KeyEvent keyEvent) {
            this.isKeyDown = false;
        }
    }

    public class FocusHandler
    implements FocusListener {
        public void focusGained(FocusEvent focusEvent) {
            if (BasicTreeUI.this.tree != null) {
                TreePath treePath = BasicTreeUI.this.tree.getLeadSelectionPath();
                if (treePath != null) {
                    BasicTreeUI.this.tree.repaint(BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath));
                }
                if ((treePath = BasicTreeUI.this.getLeadPath()) != null) {
                    BasicTreeUI.this.tree.repaint(BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath));
                }
            }
        }

        public void focusLost(FocusEvent focusEvent) {
            this.focusGained(focusEvent);
        }
    }

    public class NodeDimensionsHandler
    extends AbstractLayoutCache.NodeDimensions {
        public Rectangle getNodeDimensions(Object object, int n, int n2, boolean bl, Rectangle rectangle) {
            if (BasicTreeUI.this.editingComponent != null && BasicTreeUI.this.editingRow == n) {
                Dimension dimension = BasicTreeUI.this.editingComponent.getPreferredSize();
                int n3 = BasicTreeUI.this.getRowHeight();
                if (n3 > 0 && n3 != dimension.height) {
                    dimension.height = n3;
                }
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n, n2);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n, n2), 0, dimension.width, dimension.height);
                }
                return rectangle;
            }
            if (BasicTreeUI.this.currentCellRenderer != null) {
                Component component = BasicTreeUI.this.currentCellRenderer.getTreeCellRendererComponent(BasicTreeUI.this.tree, object, BasicTreeUI.this.tree.isRowSelected(n), bl, BasicTreeUI.this.treeModel.isLeaf(object), n, false);
                if (BasicTreeUI.this.tree != null) {
                    BasicTreeUI.this.rendererPane.add(component);
                    component.validate();
                }
                Dimension dimension = component.getPreferredSize();
                if (rectangle != null) {
                    rectangle.x = this.getRowX(n, n2);
                    rectangle.width = dimension.width;
                    rectangle.height = dimension.height;
                } else {
                    rectangle = new Rectangle(this.getRowX(n, n2), 0, dimension.width, dimension.height);
                }
                return rectangle;
            }
            return null;
        }

        protected int getRowX(int n, int n2) {
            return BasicTreeUI.this.totalChildIndent * (n2 + BasicTreeUI.this.depthOffset);
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        public void mousePressed(MouseEvent mouseEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled()) {
                BasicTreeUI.this.tree.requestFocus();
                TreePath treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, mouseEvent.getX(), mouseEvent.getY());
                if (treePath != null) {
                    int n;
                    Rectangle rectangle = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath);
                    if (mouseEvent.getY() > rectangle.y + rectangle.height) {
                        return;
                    }
                    if (SwingUtilities.isLeftMouseButton(mouseEvent)) {
                        BasicTreeUI.this.checkForClickInExpandControl(treePath, mouseEvent.getX(), mouseEvent.getY());
                    }
                    if ((n = mouseEvent.getX()) > rectangle.x && n <= rectangle.x + rectangle.width && !BasicTreeUI.this.startEditing(treePath, mouseEvent)) {
                        BasicTreeUI.this.selectPathForEvent(treePath, mouseEvent);
                    }
                }
            }
        }
    }

    public class PropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicTreeUI.this.tree) {
                String string = propertyChangeEvent.getPropertyName();
                BasicTreeUI.this.completeEditing();
                if (string.equals("cellRenderer")) {
                    BasicTreeUI.this.setCellRenderer((TreeCellRenderer)propertyChangeEvent.getNewValue());
                } else if (string.equals("treeModel")) {
                    BasicTreeUI.this.setModel((TreeModel)propertyChangeEvent.getNewValue());
                } else if (string.equals("rootVisible")) {
                    BasicTreeUI.this.setRootVisible((Boolean)propertyChangeEvent.getNewValue());
                } else if (string.equals("showsRootHandles")) {
                    BasicTreeUI.this.setShowsRootHandles((Boolean)propertyChangeEvent.getNewValue());
                } else if (string.equals("rowHeight")) {
                    BasicTreeUI.this.setRowHeight((Integer)propertyChangeEvent.getNewValue());
                } else if (string.equals("cellEditor")) {
                    BasicTreeUI.this.setCellEditor((TreeCellEditor)propertyChangeEvent.getNewValue());
                } else if (string.equals("editable")) {
                    BasicTreeUI.this.setEditable((Boolean)propertyChangeEvent.getNewValue());
                } else if (string.equals("largeModel")) {
                    BasicTreeUI.this.setLargeModel(BasicTreeUI.this.tree.isLargeModel());
                } else if (string.equals("selectionModel")) {
                    BasicTreeUI.this.setSelectionModel(BasicTreeUI.this.tree.getSelectionModel());
                }
            }
        }
    }

    public class SelectionModelPropertyChangeHandler
    implements PropertyChangeListener {
        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            if (propertyChangeEvent.getSource() == BasicTreeUI.this.treeSelectionModel) {
                BasicTreeUI.this.treeSelectionModel.resetRowSelection();
            }
        }
    }

    public class TreeTraverseAction
    extends AbstractAction {
        protected int direction;
        private boolean changeSelection;

        public TreeTraverseAction(int n, String string) {
            this(n, string, true);
        }

        private TreeTraverseAction(int n, String string, boolean bl) {
            super(string);
            this.direction = n;
            this.changeSelection = bl;
        }

        /* synthetic */ TreeTraverseAction(1 var2_2, int n, String string, boolean bl) {
            this(n, string, bl);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0) {
                int n2;
                int n3 = BasicTreeUI.this.getLeadRow();
                if (n3 == -1) {
                    n2 = 0;
                } else if (this.direction == 1) {
                    if (!BasicTreeUI.this.isLeaf(n3) && !BasicTreeUI.this.tree.isExpanded(n3)) {
                        BasicTreeUI.this.toggleExpandState(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3));
                        n2 = -1;
                    } else {
                        n2 = Math.min(n3 + 1, n - 1);
                    }
                } else if (!BasicTreeUI.this.isLeaf(n3) && BasicTreeUI.this.tree.isExpanded(n3)) {
                    BasicTreeUI.this.toggleExpandState(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3));
                    n2 = -1;
                } else {
                    TreePath treePath = BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3);
                    n2 = treePath != null && treePath.getPathCount() > 1 ? BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath.getParentPath()) : -1;
                }
                if (n2 != -1) {
                    if (this.changeSelection) {
                        BasicTreeUI.this.tree.setSelectionInterval(n2, n2);
                    } else {
                        BasicTreeUI.this.setLeadPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n2), true);
                    }
                    BasicTreeUI.this.ensureRowsAreVisible(n2, n2);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreePageAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreePageAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreePageAction(int n, String string, boolean bl, boolean bl2) {
            super(string);
            this.direction = n;
            this.addToSelection = bl;
            this.changeSelection = bl2;
        }

        /* synthetic */ TreePageAction(1 var2_2, int n, String string, boolean bl, boolean bl2) {
            this(n, string, bl, bl2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0 && BasicTreeUI.this.treeSelectionModel != null) {
                TreePath treePath;
                Dimension dimension = BasicTreeUI.this.tree.getSize();
                TreePath treePath2 = BasicTreeUI.this.getLeadPath();
                Rectangle rectangle = BasicTreeUI.this.tree.getVisibleRect();
                if (this.direction == -1) {
                    treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y);
                    if (treePath.equals(treePath2)) {
                        rectangle.y = Math.max(0, rectangle.y - rectangle.height);
                        treePath = BasicTreeUI.this.tree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    }
                } else {
                    rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                    treePath = BasicTreeUI.this.tree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    if (treePath.equals(treePath2)) {
                        rectangle.y = Math.min(dimension.height, rectangle.y + rectangle.height - 1);
                        treePath = BasicTreeUI.this.tree.getClosestPathForLocation(rectangle.x, rectangle.y);
                    }
                }
                Rectangle rectangle2 = BasicTreeUI.this.getPathBounds(BasicTreeUI.this.tree, treePath);
                rectangle2.x = rectangle.x;
                rectangle2.width = rectangle.width;
                if (this.direction == -1) {
                    rectangle2.height = rectangle.height;
                } else {
                    rectangle2.y -= rectangle.height - rectangle2.height;
                    rectangle2.height = rectangle.height;
                }
                if (this.addToSelection) {
                    BasicTreeUI.this.extendSelection(treePath);
                } else if (this.changeSelection) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                } else {
                    BasicTreeUI.this.setLeadPath(treePath, true);
                }
                BasicTreeUI.this.tree.scrollRectToVisible(rectangle2);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeScrollLRAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;

        public TreeScrollLRAction(int n, String string, boolean bl) {
            super(string);
            this.direction = n;
            this.addToSelection = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0 && BasicTreeUI.this.treeSelectionModel != null) {
                TreePath treePath;
                Rectangle rectangle = BasicTreeUI.this.tree.getVisibleRect();
                if (this.direction == -1) {
                    treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y);
                    rectangle.x = Math.max(0, rectangle.x - rectangle.width);
                } else {
                    rectangle.x = Math.min(Math.max(0, BasicTreeUI.this.tree.getWidth() - rectangle.width), rectangle.x + rectangle.width);
                    treePath = BasicTreeUI.this.getClosestPathForLocation(BasicTreeUI.this.tree, rectangle.x, rectangle.y + rectangle.height);
                }
                BasicTreeUI.this.tree.scrollRectToVisible(rectangle);
                if (this.addToSelection) {
                    BasicTreeUI.this.extendSelection(treePath);
                } else if (BasicTreeUI.this.changeSelectionWithFocus()) {
                    BasicTreeUI.this.tree.setSelectionPath(treePath);
                } else {
                    BasicTreeUI.this.setLeadPath(treePath, true);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeIncrementAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeIncrementAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreeIncrementAction(int n, String string, boolean bl, boolean bl2) {
            super(string);
            this.direction = n;
            this.addToSelection = bl;
            this.changeSelection = bl2;
        }

        /* synthetic */ TreeIncrementAction(1 var2_2, int n, String string, boolean bl, boolean bl2) {
            this(n, string, bl, bl2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.treeSelectionModel != null && (n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree)) > 0) {
                int n2 = BasicTreeUI.this.getLeadRow();
                int n3 = n2 == -1 ? (this.direction == 1 ? 0 : n - 1) : Math.min(n - 1, Math.max(0, n2 + this.direction));
                if (this.addToSelection) {
                    BasicTreeUI.this.extendSelection(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3));
                } else if (this.changeSelection) {
                    BasicTreeUI.this.tree.setSelectionInterval(n3, n3);
                } else {
                    BasicTreeUI.this.setLeadPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n3), true);
                }
                BasicTreeUI.this.ensureRowsAreVisible(n3, n3);
                BasicTreeUI.this.lastSelectedRow = n3;
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeHomeAction
    extends AbstractAction {
        protected int direction;
        private boolean addToSelection;
        private boolean changeSelection;

        public TreeHomeAction(int n, String string) {
            this(n, string, false, true);
        }

        private TreeHomeAction(int n, String string, boolean bl, boolean bl2) {
            super(string);
            this.direction = n;
            this.changeSelection = bl2;
            this.addToSelection = bl;
        }

        /* synthetic */ TreeHomeAction(1 var2_2, int n, String string, boolean bl, boolean bl2) {
            this(n, string, bl, bl2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree);
            if (BasicTreeUI.this.tree != null && n > 0) {
                if (this.direction == -1) {
                    BasicTreeUI.this.ensureRowsAreVisible(0, 0);
                    if (this.addToSelection) {
                        int n2;
                        TreePath treePath = BasicTreeUI.this.getAnchorPath();
                        int n3 = n2 = treePath == null ? -1 : BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                        if (n2 == -1) {
                            BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                        } else {
                            BasicTreeUI.this.tree.setSelectionInterval(0, n2);
                            BasicTreeUI.this.setAnchorPath(treePath);
                            BasicTreeUI.this.setLeadPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, 0));
                        }
                    } else if (this.changeSelection) {
                        BasicTreeUI.this.tree.setSelectionInterval(0, 0);
                    } else {
                        BasicTreeUI.this.setLeadPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, 0), true);
                    }
                } else {
                    BasicTreeUI.this.ensureRowsAreVisible(n - 1, n - 1);
                    if (this.addToSelection) {
                        int n4;
                        TreePath treePath = BasicTreeUI.this.getAnchorPath();
                        int n5 = n4 = treePath == null ? -1 : BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath);
                        if (n4 == -1) {
                            BasicTreeUI.this.tree.setSelectionInterval(n - 1, n - 1);
                        } else {
                            BasicTreeUI.this.tree.setSelectionInterval(n4, n - 1);
                            BasicTreeUI.this.setAnchorPath(treePath);
                            BasicTreeUI.this.setLeadPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n - 1));
                        }
                    } else if (this.changeSelection) {
                        BasicTreeUI.this.tree.setSelectionInterval(n - 1, n - 1);
                    } else {
                        BasicTreeUI.this.setLeadPath(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n - 1), true);
                    }
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class TreeToggleAction
    extends AbstractAction {
        public TreeToggleAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && (n = BasicTreeUI.this.getLeadRow()) != -1 && !BasicTreeUI.this.isLeaf(n)) {
                TreePath treePath = BasicTreeUI.this.getAnchorPath();
                TreePath treePath2 = BasicTreeUI.this.getLeadPath();
                BasicTreeUI.this.toggleExpandState(BasicTreeUI.this.getPathForRow(BasicTreeUI.this.tree, n));
                BasicTreeUI.this.setAnchorPath(treePath);
                BasicTreeUI.this.setLeadPath(treePath2);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private static class ScrollAction
    extends AbstractAction {
        private JComponent component;
        private int direction;
        private int amount;

        public ScrollAction(JComponent jComponent, int n, int n2) {
            this.component = jComponent;
            this.direction = n;
            this.amount = n2;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            Rectangle rectangle = this.component.getVisibleRect();
            Dimension dimension = this.component.getSize();
            if (this.direction == 0) {
                rectangle.x += this.amount;
                rectangle.x = Math.max(0, rectangle.x);
                rectangle.x = Math.min(Math.max(0, dimension.width - rectangle.width), rectangle.x);
            } else {
                rectangle.y += this.amount;
                rectangle.y = Math.max(0, rectangle.y);
                rectangle.y = Math.min(Math.max(0, dimension.width - rectangle.height), rectangle.y);
            }
            this.component.scrollRectToVisible(rectangle);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    public class TreeCancelEditingAction
    extends AbstractAction {
        public TreeCancelEditingAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null) {
                BasicTreeUI.this.tree.cancelEditing();
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeEditAction
    extends AbstractAction {
        public TreeEditAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled()) {
                int n;
                TreePath treePath = BasicTreeUI.this.getLeadPath();
                int n2 = n = treePath != null ? BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath) : -1;
                if (n != -1) {
                    BasicTreeUI.this.tree.startEditingAtPath(treePath);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeSelectAllAction
    extends AbstractAction {
        private boolean selectAll;

        public TreeSelectAllAction(String string, boolean bl) {
            super(string);
            this.selectAll = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree);
            if (BasicTreeUI.this.tree != null && n > 0) {
                if (this.selectAll) {
                    TreePath treePath = BasicTreeUI.this.getLeadPath();
                    TreePath treePath2 = BasicTreeUI.this.getAnchorPath();
                    if (treePath != null && !BasicTreeUI.this.tree.isVisible(treePath)) {
                        treePath = null;
                    }
                    BasicTreeUI.this.tree.setSelectionInterval(0, n - 1);
                    if (treePath != null) {
                        BasicTreeUI.this.setLeadPath(treePath);
                    }
                    if (treePath2 != null && BasicTreeUI.this.tree.isVisible(treePath2)) {
                        BasicTreeUI.this.setAnchorPath(treePath2);
                    } else if (treePath != null) {
                        BasicTreeUI.this.setAnchorPath(treePath);
                    }
                } else {
                    TreePath treePath = BasicTreeUI.this.getLeadPath();
                    TreePath treePath3 = BasicTreeUI.this.getAnchorPath();
                    BasicTreeUI.this.tree.clearSelection();
                    BasicTreeUI.this.setAnchorPath(treePath3);
                    BasicTreeUI.this.setLeadPath(treePath);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeAddSelectionAction
    extends AbstractAction {
        private boolean changeAnchor;

        public TreeAddSelectionAction(String string, boolean bl) {
            super(string);
            this.changeAnchor = bl;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n = BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree);
            if (BasicTreeUI.this.tree != null && n > 0) {
                int n2 = BasicTreeUI.this.getLeadRow();
                TreePath treePath = BasicTreeUI.this.getAnchorPath();
                TreePath treePath2 = BasicTreeUI.this.getLeadPath();
                if (n2 == -1) {
                    n2 = 0;
                }
                if (!this.changeAnchor) {
                    if (BasicTreeUI.this.tree.isRowSelected(n2)) {
                        BasicTreeUI.this.tree.removeSelectionRow(n2);
                        BasicTreeUI.this.setLeadPath(treePath2);
                    } else {
                        BasicTreeUI.this.tree.addSelectionRow(n2);
                    }
                    BasicTreeUI.this.setAnchorPath(treePath);
                } else {
                    BasicTreeUI.this.tree.setSelectionRow(n2);
                }
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    private class TreeExtendSelectionAction
    extends AbstractAction {
        public TreeExtendSelectionAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            int n;
            if (BasicTreeUI.this.tree != null && BasicTreeUI.this.getRowCount(BasicTreeUI.this.tree) > 0 && (n = BasicTreeUI.this.getLeadRow()) != -1) {
                TreePath treePath = BasicTreeUI.this.getLeadPath();
                TreePath treePath2 = BasicTreeUI.this.getAnchorPath();
                int n2 = BasicTreeUI.this.getRowForPath(BasicTreeUI.this.tree, treePath2);
                if (n2 == -1) {
                    n2 = 0;
                }
                BasicTreeUI.this.tree.setSelectionInterval(n2, n);
                BasicTreeUI.this.setLeadPath(treePath);
                BasicTreeUI.this.setAnchorPath(treePath2);
            }
        }

        public boolean isEnabled() {
            return BasicTreeUI.this.tree != null && BasicTreeUI.this.tree.isEnabled();
        }
    }

    public class MouseInputHandler
    implements MouseInputListener {
        protected Component source;
        protected Component destination;

        public MouseInputHandler(Component component, Component component2, MouseEvent mouseEvent) {
            this.source = component;
            this.destination = component2;
            this.source.addMouseListener(this);
            this.source.addMouseMotionListener(this);
            component2.dispatchEvent(SwingUtilities.convertMouseEvent(component, mouseEvent, component2));
        }

        public void mouseClicked(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
        }

        public void mouseDragged(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        public void mouseEntered(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        public void mouseExited(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        public void mouseMoved(MouseEvent mouseEvent) {
            this.removeFromSource();
        }

        public void mousePressed(MouseEvent mouseEvent) {
        }

        public void mouseReleased(MouseEvent mouseEvent) {
            if (this.destination != null) {
                this.destination.dispatchEvent(SwingUtilities.convertMouseEvent(this.source, mouseEvent, this.destination));
            }
            this.removeFromSource();
        }

        protected void removeFromSource() {
            if (this.source != null) {
                this.source.removeMouseListener(this);
                this.source.removeMouseMotionListener(this);
            }
            this.destination = null;
            this.source = null;
        }
    }
}

