/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.automerge;

import com.ibm.vatc.automerge.Summary;
import com.ibm.vatc.tcmerge.Chunk;
import com.ibm.vatc.tcmerge.DiffOutput;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Vector;

public class ResolveDiffs {
    private String input;
    private String output;
    private String resolution;
    private Summary report;
    private int newLines;
    private Vector removeList;
    private Vector outList;
    private Vector unList;

    public ResolveDiffs(String string, String string2) {
        this.input = string;
        this.output = string2;
        this.resolution = "manual";
        this.report = new Summary();
        this.newLines = 0;
        this.outList = new Vector(1, 10);
        this.removeList = new Vector(1, 5);
        this.unList = new Vector(1, 5);
    }

    public ResolveDiffs(String string, String string2, String string3, Summary summary) {
        this.resolution = string;
        this.input = string2;
        this.output = string3;
        this.report = summary;
        this.newLines = 0;
        this.removeList = new Vector(1, 5);
        this.outList = new Vector(1, 10);
        if (string.equals("manual") || string.equals("none")) {
            this.unList = new Vector(1, 5);
        }
    }

    public Summary returnSummary() {
        return this.report;
    }

    private void createUnList(int n, DiffOutput diffOutput) {
        if (diffOutput.getStart(n, 2) == diffOutput.getEnd(n, 2)) {
            this.unList.addElement(String.valueOf(Integer.toString(diffOutput.getStart(n, 2))) + " ");
            return;
        }
        this.unList.addElement(String.valueOf(Integer.toString(diffOutput.getStart(n, 2))) + "-" + Integer.toString(diffOutput.getEnd(n, 2)) + " ");
    }

    public Vector getUnList() {
        return this.unList;
    }

    private void printVector(int n, int n2, DiffOutput diffOutput) {
        if (diffOutput.getText(n, n2)) {
            Vector vector = diffOutput.getDiffText(n, n2);
            int n3 = 0;
            while (n3 < vector.size()) {
                this.outList.addElement(vector.elementAt(n3));
                ++n3;
            }
        }
    }

    private void copyVector() {
        String string = this.output.equals("") ? this.input : this.output;
        try {
            PrintWriter printWriter = new PrintWriter(new BufferedWriter(new FileWriter(string)));
            int n = 0;
            while (n < this.outList.size()) {
                printWriter.println((String)this.outList.elementAt(n));
                ++n;
            }
            printWriter.close();
            return;
        }
        catch (IOException iOException) {
            System.err.println(iOException);
            return;
        }
    }

    private String showAction(int n, DiffOutput diffOutput) {
        int n2 = diffOutput.getChangedFile(n);
        String string = n2 == 111 ? "conflict" : (++n2 == 2 ? "merge" : "none");
        return string;
    }

    private void removeDiff(int n, DiffOutput diffOutput, String string) {
        if (string.equals("merge")) {
            this.newLines = !diffOutput.getText(n, 2) ? this.newLines + (diffOutput.getEnd(n, 1) - diffOutput.getStart(n, 1)) + 1 : this.newLines - (diffOutput.getEnd(n, 2) - diffOutput.getStart(n, 2)) - 1;
        }
        this.removeList.addElement(new Integer(n));
    }

    private void alterDiff(int n, DiffOutput diffOutput) {
        int n2 = diffOutput.getChangedFile(n);
        Chunk chunk = diffOutput.getChunk(n, 2);
        chunk.setStart(diffOutput.getStart(n, 2) + this.newLines);
        chunk.setEnd(diffOutput.getEnd(n, 2) + this.newLines);
        diffOutput.addChunk(n, n2, 2, chunk);
    }

    private boolean applyAction(int n, DiffOutput diffOutput) {
        boolean bl = false;
        String string = this.showAction(n, diffOutput);
        if (string.equals("none")) {
            bl = false;
            if (this.resolution.equals("manual")) {
                this.removeDiff(n, diffOutput, string);
            }
        }
        if (string.equals("merge")) {
            this.printVector(n, 1, diffOutput);
            bl = true;
            if (this.resolution.equals("manual")) {
                this.removeDiff(n, diffOutput, string);
            }
        }
        if (string.equals("conflict")) {
            bl = this.applyConflict(n, diffOutput, this.resolution);
        }
        return bl;
    }

    private boolean applyConflict(int n, DiffOutput diffOutput, String string) {
        boolean bl = false;
        this.report.setConflicts(this.report.showConflicts() + 1);
        if (string.equals("maint")) {
            this.printVector(n, 1, diffOutput);
            this.report.setResolved(this.report.showResolved() + 1);
            bl = true;
        }
        if (string.equals("both")) {
            this.printVector(n, 1, diffOutput);
            this.printVector(n, 2, diffOutput);
            this.report.setResolved(this.report.showResolved() + 1);
            bl = true;
        }
        if (string.equals("target")) {
            bl = false;
            this.report.setResolved(this.report.showResolved() + 1);
        }
        if (string.equals("manual")) {
            this.createUnList(n, diffOutput);
            if (this.newLines != 0) {
                this.alterDiff(n, diffOutput);
            }
            this.report.setUnresolved(this.report.showUnresolved() + 1);
            bl = false;
        }
        if (string.equals("none")) {
            this.report.setUnresolved(this.report.showUnresolved() + 1);
            bl = false;
            this.createUnList(n, diffOutput);
        }
        return bl;
    }

    public void resolve(DiffOutput diffOutput) {
        int n = 1;
        int n2 = 0;
        int n3 = 0;
        int n4 = -1;
        if (diffOutput.getDiffOutputSize() > 0) {
            n4 = diffOutput.getStart(0, 2);
        }
        try {
            String string;
            BufferedReader bufferedReader = new BufferedReader(new FileReader(this.input));
            while ((string = bufferedReader.readLine()) != null) {
                if (n == n4) {
                    if (!diffOutput.getText(n2, 2)) {
                        this.outList.addElement(string);
                    }
                    boolean bl = this.applyAction(n2, diffOutput);
                    n3 = diffOutput.getEnd(n2, 2) - diffOutput.getStart(n2, 2);
                    if (!bl && diffOutput.getText(n2, 2)) {
                        this.outList.addElement(string);
                    }
                    int n5 = 0;
                    while (n5 < n3) {
                        string = bufferedReader.readLine();
                        ++n;
                        if (!bl) {
                            this.outList.addElement(string);
                        }
                        ++n5;
                    }
                    n4 = ++n2 == diffOutput.getDiffOutputSize() ? -1 : diffOutput.getStart(n2, 2);
                } else {
                    this.outList.addElement(string);
                }
                ++n;
            }
            diffOutput.removeDifferences(this.removeList);
            bufferedReader.close();
        }
        catch (IOException iOException) {
            System.err.println(iOException);
        }
        this.copyVector();
    }
}

