/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.reuse.awt;

import java.awt.Canvas;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;

public class ImageButton
extends Canvas
implements MouseListener {
    Image image;
    Image disabledImage;
    int imageHeight;
    int imageWidth;
    Graphics graphics;
    boolean depressed;
    boolean disabled;

    public ImageButton(Image image, Image image2) {
        this.image = image;
        this.disabledImage = image2;
        this.prepareImage(image, this);
        this.prepareImage(image2, this);
        this.addMouseListener(this);
    }

    public ImageButton(Image image) {
        this.image = image;
        this.prepareImage(image, this);
        this.addMouseListener(this);
    }

    public void addNotify() {
        super.addNotify();
        this.graphics = this.getGraphics();
        this.imageHeight = this.image.getHeight(null);
        this.imageWidth = this.image.getWidth(null);
        this.setSize(this.imageWidth + 8, this.imageHeight + 8);
    }

    public void setEnabled(boolean bl) {
        this.disabled = !bl;
        this.repaint();
    }

    public boolean isEnabled() {
        return !this.disabled;
    }

    public void paint(Graphics graphics) {
        if (this.disabled) {
            graphics.drawImage(this.disabledImage, 3, 3, this);
            graphics.drawRect(1, 1, this.imageWidth + 4, this.imageHeight + 4);
            graphics.drawRect(1, 1, this.imageWidth + 5, this.imageHeight + 5);
            graphics.drawRect(1, 1, this.imageWidth + 6, this.imageHeight + 6);
            return;
        }
        if (this.depressed) {
            graphics.drawImage(this.image, 5, 5, this);
            graphics.drawRect(3, 3, this.imageWidth + 6, this.imageHeight + 6);
            graphics.drawRect(2, 2, this.imageWidth + 6, this.imageHeight + 6);
            graphics.drawRect(1, 1, this.imageWidth + 6, this.imageHeight + 6);
            return;
        }
        graphics.drawImage(this.image, 3, 3, this);
        graphics.drawRect(1, 1, this.imageWidth + 4, this.imageHeight + 4);
        graphics.drawRect(1, 1, this.imageWidth + 5, this.imageHeight + 5);
        graphics.drawRect(1, 1, this.imageWidth + 6, this.imageHeight + 6);
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (!this.disabled) {
            this.depressed = true;
            this.repaint();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (!this.disabled) {
            this.depressed = false;
            this.repaint();
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }
}

