/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.vatc.automerge;

import com.ibm.sdwb.common.toolcount.ToolCount;
import com.ibm.vatc.automerge.ResolveDiffs;
import com.ibm.vatc.automerge.Summary;
import com.ibm.vatc.tcmerge.DiffOutput;
import com.ibm.vatc.tcmerge.DiffParse;
import com.ibm.vatc.tcmerge.FileFilter;
import com.ibm.vatc.tcmerge.Validate;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.Date;
import java.util.ListResourceBundle;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

public class Auto {
    private File master;
    private File maint;
    private File target;
    private File outFile;
    private Vector fileSpec = new Vector(1, 1);
    private String resolution = new String("target");
    private boolean masterIsDirectory;
    private boolean maintIsDirectory;
    private boolean targetIsDirectory;
    private boolean replace = false;
    private boolean log = false;
    private PrintWriter logStream;
    private PrintWriter manualStream;
    private boolean verbose = false;
    private boolean append = false;
    private boolean quiet = false;
    private String endCommand = new String();
    private int inputFileCount;
    private int colCount;
    private int fileSpecCount;
    private int code;
    private int dirFiles;
    private Process child_;
    public static ListResourceBundle locResource = null;

    public Auto(String[] stringArray) {
        locResource = (ListResourceBundle)ResourceBundle.getBundle("com.ibm.vatc.automerge.AutoResource", Locale.getDefault());
        this.dirFiles = 0;
        String string = new String();
        boolean bl = false;
        boolean bl2 = false;
        String string2 = new String();
        if (!this.inputFilesValid(stringArray)) {
            bl = true;
        }
        int n = this.inputFileCount;
        while (n < stringArray.length) {
            if ((string = stringArray[n++]).equalsIgnoreCase("-out") || string.equalsIgnoreCase("-output")) {
                bl2 = true;
                if (n < stringArray.length && stringArray[n].charAt(0) != '-') {
                    this.outFile = new File(stringArray[n++]);
                    continue;
                }
                bl = true;
                System.err.println(locResource.getString("MISSING_OUTPUT"));
                continue;
            }
            if (string.equalsIgnoreCase("-f") || string.equalsIgnoreCase("-files")) {
                if (!this.handleFiles(stringArray, n)) {
                    bl = true;
                }
                n += this.fileSpecCount;
                continue;
            }
            if (string.equalsIgnoreCase("-ignoreco") || string.equalsIgnoreCase("-ignorecolumns")) {
                if (!this.handleColumns(stringArray, n)) {
                    bl = true;
                }
                n += this.colCount;
                continue;
            }
            if (string.equalsIgnoreCase("-ignoreb") || string.equalsIgnoreCase("-ignoreblanks")) {
                if (n < stringArray.length && stringArray[n].charAt(0) != '-') {
                    if ((string = stringArray[n++]).equalsIgnoreCase("l")) {
                        this.endCommand = String.valueOf(this.endCommand) + " -l";
                        continue;
                    }
                    if (string.equalsIgnoreCase("t")) {
                        this.endCommand = String.valueOf(this.endCommand) + " -t";
                        continue;
                    }
                    if (string.equalsIgnoreCase("a")) {
                        this.endCommand = String.valueOf(this.endCommand) + " -w";
                        continue;
                    }
                    if (string.equalsIgnoreCase("lt") || string.equalsIgnoreCase("tl")) {
                        this.endCommand = String.valueOf(this.endCommand) + " -l -t";
                        continue;
                    }
                    bl = true;
                    System.err.println(locResource.getString("MISSING_IGNOREBLANKS"));
                    continue;
                }
                bl = true;
                System.err.println(locResource.getString("MISSING_IGNOREBLANKS"));
                continue;
            }
            if (string.equalsIgnoreCase("-r") || string.equalsIgnoreCase("-resolution")) {
                if (n < stringArray.length && stringArray[n].charAt(0) != '-') {
                    if ((string = stringArray[n++]).equalsIgnoreCase("maint") || string.equalsIgnoreCase("both") || string.equalsIgnoreCase("target") || string.equalsIgnoreCase("manual") || string.equalsIgnoreCase("none")) {
                        this.resolution = string;
                        continue;
                    }
                    bl = true;
                    System.err.println(locResource.getString("MISSING_RESOLUTION"));
                    continue;
                }
                bl = true;
                System.err.println(locResource.getString("MISSING_RESOLUTION"));
                continue;
            }
            if (string.equalsIgnoreCase("-re") || string.equalsIgnoreCase("-replace")) {
                this.replace = true;
                continue;
            }
            if (string.equalsIgnoreCase("-log") || string.equalsIgnoreCase("-logfile")) {
                if (n < stringArray.length && stringArray[n].charAt(0) != '-') {
                    string = stringArray[n++];
                    this.log = true;
                    string2 = string;
                    continue;
                }
                bl = true;
                System.err.println(locResource.getString("MISSING_LOGFILE"));
                continue;
            }
            if (string.equalsIgnoreCase("-v") || string.equalsIgnoreCase("-verbose")) {
                this.verbose = true;
                continue;
            }
            if (string.equalsIgnoreCase("-a") || string.equalsIgnoreCase("-append")) {
                this.append = true;
                continue;
            }
            if (string.equalsIgnoreCase("-q") || string.equalsIgnoreCase("-quiet")) {
                this.quiet = true;
                continue;
            }
            if (string.equalsIgnoreCase("-ignoreca") || string.equalsIgnoreCase("-ignorecase")) {
                this.endCommand = String.valueOf(this.endCommand) + " -i";
                continue;
            }
            if (string.equalsIgnoreCase("-h") || string.equalsIgnoreCase("-help")) {
                this.showUsage();
                System.exit(0);
                bl = true;
                continue;
            }
            bl = true;
            System.err.println(String.valueOf(string) + locResource.getString("INVALID_FLAG"));
        }
        if (this.outFile != null && !this.outputValid()) {
            bl = true;
        }
        if (!bl2 && this.replace) {
            bl = true;
            System.err.println(locResource.getString("NO_OUTPUT_W_REPLACE"));
        }
        if (!bl2 && this.target != null && !this.target.canWrite()) {
            System.err.println(String.valueOf(locResource.getString("CANT_WRITE")) + this.target + ".");
            bl = true;
        }
        if (!this.log && this.append) {
            System.err.println(locResource.getString("NO_LOGFILE_W_APPEND"));
            bl = true;
        }
        if (this.quiet && (this.append || this.log || this.verbose)) {
            System.err.println(locResource.getString("QUIET_OVERRIDE"));
            this.log = false;
            this.append = false;
            this.verbose = false;
        }
        if (!bl && this.log) {
            bl = this.handleLog(string2);
        }
        if (this.master != null && this.master.isDirectory() && this.fileSpec.size() == 0) {
            this.fileSpec.addElement("*");
        }
        if (bl) {
            System.exit(89);
        }
        if (this.resolution.equalsIgnoreCase("manual")) {
            this.quiet = true;
        }
        ToolCount.toolcount("SDWB", "automerge");
    }

    public int retrieveCode() {
        return this.code;
    }

    private boolean inputFilesValid(String[] stringArray) {
        String[] stringArray2 = new String[3];
        File[] fileArray = new File[3];
        boolean bl = true;
        while (this.inputFileCount < stringArray.length && this.inputFileCount < 3 && stringArray[this.inputFileCount].charAt(0) != '-') {
            stringArray2[this.inputFileCount] = stringArray[this.inputFileCount];
            ++this.inputFileCount;
        }
        if (this.inputFileCount == 3) {
            int n = 0;
            while (n < 3) {
                fileArray[n] = new File(stringArray2[n]);
                if (!fileArray[n].exists() || !fileArray[n].canRead()) {
                    System.err.println(String.valueOf(locResource.getString("CANT_ACCESS")) + fileArray[n] + ".");
                    bl = false;
                }
                ++n;
            }
            this.masterIsDirectory = fileArray[0].isDirectory();
            this.maintIsDirectory = fileArray[1].isDirectory();
            this.targetIsDirectory = fileArray[2].isDirectory();
            if (bl && (this.masterIsDirectory != this.maintIsDirectory || this.masterIsDirectory != this.targetIsDirectory)) {
                System.err.println(locResource.getString("DIFF_TYPES"));
                bl = false;
            }
            if (bl) {
                if (this.masterIsDirectory) {
                    String string = System.getProperty("file.separator");
                    n = 0;
                    while (n < 3) {
                        if (!stringArray2[n].endsWith(string)) {
                            int n2 = n;
                            stringArray2[n2] = String.valueOf(stringArray2[n2]) + string;
                        }
                        ++n;
                    }
                }
                this.master = new File(stringArray2[0]);
                this.maint = new File(stringArray2[1]);
                this.target = new File(stringArray2[2]);
            }
        } else {
            bl = false;
            if (this.inputFileCount != 0 || stringArray.length != 1 || !stringArray[0].equalsIgnoreCase("-h") && !stringArray[0].equalsIgnoreCase("-help")) {
                System.err.println(locResource.getString("THREE_NEEDED"));
                this.showUsage();
            }
        }
        return bl;
    }

    private boolean outputValid() {
        String string;
        boolean bl = true;
        File file = new File(new File(this.outFile.getAbsolutePath()).getParent());
        if (this.outFile.exists() && this.outFile.isDirectory()) {
            string = new String("dir");
        } else if (this.outFile.exists()) {
            string = new String("file");
        } else if (this.masterIsDirectory) {
            string = new String("dir");
            this.outFile.mkdir();
            this.replace = true;
        } else {
            string = new String("file");
        }
        if (string.equals("dir")) {
            if (this.master != null && !this.masterIsDirectory) {
                System.err.println(String.valueOf(this.outFile) + locResource.getString("FILE_NEEDED"));
                bl = false;
            }
        } else if (this.master != null && this.masterIsDirectory) {
            System.err.println(String.valueOf(this.outFile) + locResource.getString("DIR_NEEDED"));
            bl = false;
        }
        if (file.exists() && !file.canWrite() || this.outFile.exists() && !this.outFile.canWrite()) {
            System.err.println(String.valueOf(locResource.getString("CANT_WRITE")) + this.outFile + ".");
            bl = false;
        }
        if (bl) {
            if (!this.replace && string.equals("file") && this.outFile.exists()) {
                System.err.println(String.valueOf(this.outFile) + locResource.getString("NO_REPLACE_W_FILE"));
                bl = false;
            }
            if (!this.replace && string.equals("dir") && file.exists()) {
                System.err.println(String.valueOf(this.outFile) + locResource.getString("NO_REPLACE_W_DIR"));
                bl = false;
            }
        }
        return bl;
    }

    private boolean handleLog(String string) {
        boolean bl = true;
        Vector<String> vector = new Vector<String>(1, 5);
        File file = new File(string);
        File file2 = new File(new File(file.getAbsolutePath()).getParent());
        if (file.getName().equals("")) {
            System.err.println(locResource.getString("NO_LOGFILE"));
            bl = false;
        } else if (file2.exists() && !file.canWrite() && !file2.canWrite()) {
            System.err.println(String.valueOf(locResource.getString("CANT_WRITE")) + string);
            bl = false;
        } else {
            if (!file2.exists() && !file2.mkdir()) {
                System.err.println(locResource.getString("NO_LOGFILE_DIR"));
                bl = false;
            }
            if (bl) {
                if (this.append) {
                    try {
                        String string2;
                        BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
                        while ((string2 = bufferedReader.readLine()) != null) {
                            vector.addElement(string2);
                        }
                        bufferedReader.close();
                    }
                    catch (IOException iOException) {
                        System.err.println(iOException);
                    }
                }
                try {
                    this.logStream = new PrintWriter(new BufferedOutputStream(new FileOutputStream(string)));
                    int n = 0;
                    while (n < vector.size()) {
                        this.logStream.println((String)vector.elementAt(n));
                        ++n;
                    }
                }
                catch (IOException iOException) {
                    System.err.println(iOException);
                }
            }
        }
        return !bl;
    }

    private boolean handleColumns(String[] stringArray, int n) {
        boolean bl = true;
        this.endCommand = String.valueOf(this.endCommand) + " -c";
        while (n < stringArray.length && !stringArray[n].startsWith("-")) {
            String string = stringArray[n];
            if (Validate.rangesToIgnoreValid(string)) {
                this.endCommand = string.indexOf(",") == -1 ? String.valueOf(this.endCommand) + " " + string + "," + string : String.valueOf(this.endCommand) + " " + string;
            } else {
                bl = false;
                System.err.println(locResource.getString("BAD_COLUMNS"));
            }
            ++this.colCount;
            ++n;
        }
        if (this.colCount == 0) {
            System.err.println(locResource.getString("NO_COL_RANGE"));
            bl = false;
        }
        return bl;
    }

    private boolean handleFiles(String[] stringArray, int n) {
        boolean bl = true;
        while (n < stringArray.length && !stringArray[n].startsWith("-")) {
            this.fileSpec.addElement(stringArray[n]);
            ++this.fileSpecCount;
            ++n;
        }
        if (this.fileSpecCount == 0) {
            System.err.println(locResource.getString("NO_FILE_SPECS"));
            bl = false;
        }
        return bl;
    }

    private Vector retrieveFileList() {
        FileFilter fileFilter = new FileFilter(this.master);
        FileFilter fileFilter2 = new FileFilter(this.maint);
        FileFilter fileFilter3 = new FileFilter(this.target);
        Vector vector = fileFilter.filterReturn(this.fileSpec);
        vector = fileFilter.intersection(fileFilter2.filterReturn(this.fileSpec), fileFilter3.filterReturn(this.fileSpec));
        String string = System.getProperty("file.separator");
        int n = 0;
        while (n < vector.size()) {
            if (new File(String.valueOf(this.master) + string + vector.elementAt(n)).isDirectory()) {
                vector.removeElementAt(n);
                --n;
            } else if (new File(String.valueOf(this.maint) + string + vector.elementAt(n)).isDirectory()) {
                vector.removeElementAt(n);
                --n;
            } else if (new File(String.valueOf(this.target) + string + vector.elementAt(n)).isDirectory()) {
                vector.removeElementAt(n);
                --n;
            }
            ++n;
        }
        return vector;
    }

    private void executeCommand(String string, String string2, String string3, String string4) {
        int n;
        DiffOutput diffOutput = new DiffOutput();
        DiffParse diffParse = new DiffParse();
        Summary summary = new Summary(String.valueOf(this.master.getAbsolutePath()) + string4, String.valueOf(this.maint.getAbsolutePath()) + string4, String.valueOf(this.target.getAbsolutePath()) + string4);
        String string5 = System.getProperty("file.separator");
        String string6 = System.getProperty("os.name");
        String string7 = string6.equals("Windows 95") || string6.equals("Windows NT") ? new String("tcdiff -n \"" + string + "\" \"" + string2 + "\" \"" + string3 + "\" " + this.endCommand) : new String("tcdiff -n " + string + " " + string2 + " " + string3 + this.endCommand);
        String string8 = new String();
        new Vector(1, 5);
        if (this.outFile == null) {
            string8 = "";
        } else {
            summary.setOutFile(String.valueOf(this.outFile.toString()) + string5 + string4);
            string8 = String.valueOf(this.outFile.toString()) + string5 + string4;
        }
        if (string4.equals("")) {
            string4 = this.master.getName();
        }
        diffOutput.initializeDiffOutput();
        diffParse.initializeDiffParse();
        try {
            diffParse.runExecutable(string7);
            if (!diffParse.tcDiffRan) {
                System.out.println(locResource.getString("STR_NO_TCDIFF_ERROR"));
                System.exit(1);
            }
        }
        catch (Exception exception) {
            System.err.println(locResource.getString("DIFF_ENGINE_ERROR"));
            System.exit(89);
        }
        if ((n = diffParse.parseDiffOutput(3, diffOutput)) == 0) {
            summary.setDifferences(diffOutput.getDiffOutputSize());
            ResolveDiffs resolveDiffs = new ResolveDiffs(this.resolution, string3, string8, summary);
            resolveDiffs.resolve(diffOutput);
            if (this.resolution.equalsIgnoreCase("manual") && diffOutput.getDiffOutputSize() > 0) {
                this.manualStream.print(string);
                this.manualStream.print(" ");
                this.manualStream.print(string2);
                this.manualStream.print(" ");
                this.manualStream.print(string3);
                this.manualStream.print(" ");
                if (this.outFile == null) {
                    this.manualStream.println(string3);
                } else if (this.master.isDirectory()) {
                    this.manualStream.println(String.valueOf(this.outFile.toString()) + string5 + string4);
                } else {
                    this.manualStream.println(this.outFile.toString());
                }
            }
            if (this.resolution.equalsIgnoreCase("manual") || this.resolution.equalsIgnoreCase("none")) {
                summary.setUnList(resolveDiffs.getUnList());
            }
            this.status(summary, diffOutput, true);
        }
        if (n == -1) {
            this.print(locResource.getString("DIFF_PARSE_ERROR"));
            this.status(summary, diffOutput, false);
            this.code = 20;
        }
        if (n == -2) {
            summary.setDifferences(0);
            this.print(locResource.getString("NO_DIFFS_FOUND"));
            this.status(summary, diffOutput, false);
        }
        if (summary.showConflicts() != 0) {
            this.code = 3;
        }
    }

    public void run() {
        Vector vector = new Vector(1, 5);
        String string = new String();
        new String();
        if (this.resolution.equalsIgnoreCase("manual")) {
            try {
                this.manualStream = new PrintWriter(new BufferedOutputStream(new FileOutputStream("glarch.txt")));
            }
            catch (IOException iOException) {
                System.err.println(iOException);
            }
        }
        this.code = 0;
        if (this.master.isDirectory()) {
            vector = this.retrieveFileList();
            int n = 0;
            while (n < vector.size()) {
                string = (String)vector.elementAt(n);
                this.executeCommand(String.valueOf(this.master.toString()) + string, String.valueOf(this.maint.toString()) + string, String.valueOf(this.target.toString()) + string, string);
                ++n;
            }
        } else {
            this.executeCommand(this.master.toString(), this.maint.toString(), this.target.toString(), "");
        }
        if (this.resolution.equalsIgnoreCase("manual")) {
            this.manualStream.close();
        }
        if (this.log) {
            this.logStream.close();
        }
        if (this.masterIsDirectory) {
            if (!this.quiet) {
                this.print(String.valueOf(locResource.getString("FILES_MERGED")) + Integer.toString(this.dirFiles));
            }
            if (!this.resolution.equalsIgnoreCase("manual")) {
                System.exit(3);
            }
        }
        if (this.resolution.equalsIgnoreCase("manual") && this.code != 0) {
            System.out.println(locResource.getString("STARTING_TCMERGE"));
            System.exit(2);
        }
        System.exit(this.code);
    }

    private void print(String string) {
        if (!this.quiet) {
            if (this.log) {
                this.logStream.println(string);
                return;
            }
            System.err.println(string);
        }
    }

    private void status(Summary summary, DiffOutput diffOutput, boolean bl) {
        summary.setFinished(new Date().toString());
        ++this.dirFiles;
        if (this.log) {
            summary.printStatus(this.logStream);
            if (this.verbose && bl) {
                diffOutput.print(this.logStream);
            }
            this.logStream.println("*******************************************");
            return;
        }
        if (!this.quiet) {
            summary.printStatus();
            if (this.verbose && bl) {
                diffOutput.print();
            }
            System.err.println("*******************************************");
        }
    }

    public void showUsage() {
        System.err.println("");
        System.err.println(locResource.getString("FILE_MERGE_SYNTAX"));
        System.err.println(locResource.getString("FILE_MERGE_CMD"));
        System.err.println("");
        System.err.println(locResource.getString("DIR_MERGE_SYNTAX"));
        System.err.println(locResource.getString("DIR_MERGE_CMD"));
    }
}

