CREATE REGULAR TABLESPACE KERNEL
MANAGED BY SYSTEM USING ('KERNEL');

CREATE REGULAR TABLESPACE AUTH
MANAGED BY SYSTEM USING ('AUTH');

CREATE REGULAR TABLESPACE MODEL
MANAGED BY SYSTEM USING ('MODEL');

CREATE REGULAR TABLESPACE TOOLS
MANAGED BY SYSTEM USING ('TOOLS');

CREATE REGULAR TABLESPACE BULKDATA
MANAGED BY SYSTEM USING ('BULKDATA');

CREATE REGULAR TABLESPACE INDEXES
MANAGED BY SYSTEM USING ('INDEXES');


CREATE DISTINCT TYPE DBOID  AS CHARACTER(12) FOR BIT DATA WITH COMPARISONS;

CREATE DISTINCT TYPE DBOVER AS CHARACTER(4) FOR BIT DATA WITH COMPARISONS;

CREATE DISTINCT TYPE DBOIDC AS CHARACTER(16) FOR BIT DATA WITH COMPARISONS;

CREATE TABLE ADObject 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL ,
     GUID                      VarChar(40)   ,
     ClassName                 Varchar(70)   ,
     OIDString                 Varchar(40)   ,
     constraint PKADObject Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE ADLink 
   ( OID                       DBOID NOT NULL  ,
     OVer                      DBOVER NOT NULL  ,
     adSource                  DBOID   ,
     adTarget                  DBOID   ,
     constraint PKADLink Primary Key( OID, OVer ) )
     IN KERNEL ;

CREATE TABLE ADLink_Source 
   ( SourceOID                 DBOID NOT NULL  ,
     SourceOVer                DBOVER NOT NULL  ,
     RelOID                    DBOID NOT NULL  ,
     RelOVer                   DBOVER NOT NULL  ,
     ClassAttr                 Varchar(70)   ,
     NextOIDC                  DBOIDC   ,
     constraint PKADLink_Source Primary Key( SourceOID, SourceOVer, RelOID, RelOVer ) )
     IN KERNEL ;

CREATE TABLE ADLink_Target 
   ( RelOID                    DBOID NOT NULL  ,
     RelOVer                   DBOVER NOT NULL  ,
     TargetOID                 DBOID NOT NULL  ,
     TargetOVer                DBOVER NOT NULL  ,
     ClassAttr                 Varchar(70)   ,
     NextOIDC                  DBOIDC   ,
     constraint PKADLink_Target Primary Key( RelOID, RelOVer, TargetOID, TargetOVer ) )
     IN KERNEL ;

CREATE TABLE ADViewRoot_plasma
   ( VerOID                    DBOID NOT NULL  ,
     VerOVer                   DBOVER NOT NULL  ,
     PlasmaOID                 DBOID NOT NULL  ,
     PlasmaOver                DBOVER NOT NULL  ,
     constraint PKADViewRoot_plasm Primary Key( VerOID, VerOVer, PlasmaOID, PlasmaOver ) )
     IN KERNEL ;

CREATE TABLE ManyPtrTable
   ( SourceOID                 DBOID NOT NULL  ,
     SourceOVer                DBOVER NOT NULL  ,
     ClassAttrib               Varchar(70) NOT NULL  ,
     TargetOID                 DBOID NOT NULL  ,
     TargetOVer                DBOVER NOT NULL  ,
     NextOIDC                  DBOIDC   ,
     constraint PKManyPtrTable Primary Key( SourceOID, SourceOVer, ClassAttrib, TargetOID, TargetOVer ) )
     IN KERNEL ;

CREATE TABLE NuVersions 
   ( contextId                 DBOID NOT NULL  ,
     OID                       DBOID NOT NULL  ,
     OVer                      DBOVER   ,
     constraint PKNuVersions Primary Key( contextId, OID ) )
     IN KERNEL ;

DROP INDEX FHCFileNoDup ;
DROP INDEX FHCLevelCommitDate;
DROP INDEX FHCLevelName;
DROP INDEX FHCLevelOsrelUsrId;
DROP INDEX ManyPtrTable1;
DROP INDEX FHCWorkAreaname;
DROP INDEX FHCFILESRLTPVRSNID;

