/*
 * Decompiled with CFR 0.152.
 */
package com.example.mytoolbarbuttons.actions;

import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;

public class ExternalToolsUtility {
    private static final String LAUNCHEXTENSION = ".launch";

    public static boolean runExternalToolsAction(String name) {
        boolean runSuccess = false;
        String availableActions = "";
        try {
            ILaunchConfiguration[] externalToolsActions = DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurations(DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType("org.eclipse.ui.externaltools.ProgramLaunchConfigurationType"));
            int i = 0;
            while (externalToolsActions != null && i < externalToolsActions.length) {
                IPath location = externalToolsActions[i].getLocation();
                String fileName = location.lastSegment();
                if (fileName != null && fileName.endsWith(LAUNCHEXTENSION) && fileName.length() > LAUNCHEXTENSION.length()) {
                    String actionName = fileName.substring(0, fileName.length() - LAUNCHEXTENSION.length());
                    availableActions = String.valueOf(availableActions) + actionName + "\n";
                    if (actionName.equals(name)) {
                        System.out.println("Running action: " + actionName);
                        ILaunch result = externalToolsActions[i].launch("run", (IProgressMonitor)new NullProgressMonitor());
                        runSuccess = true;
                        break;
                    }
                }
                ++i;
            }
        }
        catch (CoreException e) {
            e.printStackTrace();
        }
        if (!runSuccess) {
            System.out.println("Action: " + name + " could not be found.  Available actions are: " + availableActions);
        }
        return runSuccess;
    }
}

