/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.tpf.installHandler;

import com.ibm.tpf.installHandler.ConfigFileEntry;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.xml.serialize.OutputFormat;
import org.apache.xml.serialize.XMLSerializer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class ConfigurationFileUtility {
    public static final String DEFAULT_CONFIG_FILE_NAME = "menumanagerconfig.xml";
    private static final boolean IS_FOLDER = true;
    private static final boolean MUST_EXIST = true;
    private static final boolean ALLOW_REMOVAL = true;
    private static final boolean IS_USER_DEFAULT_CONFIG = true;
    public static final String PROJECT_TAG = "project";
    public static final String FILE_TAG = "file";
    public static final String ROOT_TAG = "root";
    public static final int XML_FORMATTER_LINE_WIDTH = 1024;
    public static final int PROJECT = 1;
    public static final int FILE = 2;
    private static Element defaultUserConfigRoot = null;
    private static Element lastElement = null;

    private static ConfigFileEntry[] extractFileElements(Element rootElement) {
        ConfigFileEntry[] fileNames = null;
        NodeList list = rootElement.getChildNodes();
        int i = 0;
        while (i < list.getLength()) {
            String name = list.item(i).getFirstChild().getNodeValue();
            int type = 2;
            type = list.item(i).getNodeName().equals(PROJECT_TAG) ? 1 : 2;
            ConfigFileEntry nextEntry = new ConfigFileEntry(name, type);
            fileNames = ConfigurationFileUtility.addFileObject(nextEntry, fileNames);
            ++i;
        }
        return fileNames;
    }

    public static ConfigFileEntry[] addFileObject(ConfigFileEntry nextFile, ConfigFileEntry[] existingEntries) {
        ConfigFileEntry[] result = null;
        if (existingEntries == null) {
            result = new ConfigFileEntry[]{nextFile};
        } else {
            int existingEntryCount = existingEntries.length;
            result = new ConfigFileEntry[existingEntryCount + 1];
            boolean found = false;
            int i = 0;
            while (i < existingEntries.length) {
                if (existingEntries[i].equals(nextFile)) {
                    result = existingEntries;
                    found = true;
                    break;
                }
                result[i] = existingEntries[i];
                ++i;
            }
            if (!found) {
                result[existingEntryCount] = nextFile;
            }
        }
        return result;
    }

    public static ConfigFileEntry[] extractEntriesFromLocalFile(File file) {
        lastElement = null;
        ConfigFileEntry[] mentionedFiles = null;
        if (file != null && file.exists() && file.canRead()) {
            try {
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                dbf.setIgnoringElementContentWhitespace(true);
                dbf.setValidating(true);
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document xmlFile = db.parse(new FileInputStream(file));
                if (xmlFile != null) {
                    mentionedFiles = ConfigurationFileUtility.extractFileElements(xmlFile.getDocumentElement());
                    lastElement = xmlFile.getDocumentElement();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return mentionedFiles;
    }

    protected static boolean writeToConfigurationFile(File file, Element rootElement) {
        boolean success = false;
        if (file.exists() && file.canWrite() || !file.exists()) {
            try {
                FileWriter writer = new FileWriter(file);
                OutputFormat format = new OutputFormat();
                format.setLineWidth(1024);
                format.setIndenting(true);
                format.setDoctype(null, "config.dtd");
                writer.write(new XMLSerializer(format).writeToString((Node)rootElement));
                writer.close();
                success = true;
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    public static Element getLastParsedElement() {
        return lastElement;
    }

    public static boolean writeConfigurationLocalFile(File file, ConfigFileEntry[] fileObjects) {
        boolean success = false;
        if (file != null) {
            try {
                if (!file.exists()) {
                    file.createNewFile();
                }
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                DocumentBuilder db = dbf.newDocumentBuilder();
                Document xmlFile = db.newDocument();
                Element root = xmlFile.createElement(ROOT_TAG);
                xmlFile.appendChild(root);
                Document rootDoc = root.getOwnerDocument();
                int i = 0;
                while (fileObjects != null && i < fileObjects.length) {
                    ConfigurationFileUtility.addElementForFile(rootDoc, root, fileObjects[i]);
                    ++i;
                }
                success = ConfigurationFileUtility.writeToConfigurationFile(file, root);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return success;
    }

    public static void addElementForFile(Document rootDoc, Element root, ConfigFileEntry file) {
        Element child = null;
        child = file.type == 1 ? rootDoc.createElement(PROJECT_TAG) : rootDoc.createElement(FILE_TAG);
        Text text = rootDoc.createTextNode(file.fileName);
        child.appendChild(text);
        root.appendChild(child);
    }
}

