/*
 * (c) Copyright 1996, KL GROUP INC.
 * ALL RIGHTS RESERVED
 *
 * This file is provided for demonstration and educational uses only.
 * Permission to use, copy, modify and distribute this file for
 * any purpose and without fee is hereby granted, provided that the
 * above copyright notice and this permission notice appear in all
 * copies, and that the name of KL Group not be used in advertising
 * or publicity pertaining to this material without the specific,
 * prior written permission of an authorized representative of
 * KL Group.
 *
 * KL GROUP MAKES NO REPRESENTATIONS AND EXTENDS NO WARRANTIES, EX-
 * PRESS OR IMPLIED, WITH RESPECT TO THE SOFTWARE, INCLUDING, BUT
 * NOT LIMITED TO, THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
 * FITNESS FOR ANY PARTICULAR PURPOSE, AND THE WARRANTY AGAINST IN-
 * FRINGEMENT OF PATENTS OR OTHER INTELLECTUAL PROPERTY RIGHTS.  THE
 * SOFTWARE IS PROVIDED "AS IS", AND IN NO EVENT SHALL KL GROUP OR
 * ANY OF ITS AFFILIATES BE LIABLE FOR ANY DAMAGES, INCLUDING ANY
 * LOST PROFITS OR OTHER INCIDENTAL OR CONSEQUENTIAL DAMAGES
 * RELATING TO THE USE OF THIS SOFTWARE.
 */

//   RCSID -- $RCSfile: JCOutlinePanel.java $ $Revision: 2.0 $
//            $Date: 1997/06/09 18:22:11 $  $Locker: $  KL Group Inc.

package jclass.contrib;
import java.awt.*;

/**
 * JCOutlinePanel is a Panel that has a line drawn around its border.
 * This line is drawn by modifying the panel insets and overriding
 * the paint() member. <P>
 *
 * A JCOutlinePanel instance must be used exactly as one would use
 * a Panel instance.
 */
public class JCOutlinePanel extends Panel {

/**
 * The default constructor. It sets the default layout to null.
 */
public JCOutlinePanel() {
	setLayout(null);
}

Insets lin = null;

/**
 * Modifies the default insets to account for the line drawn
 * around the Panel. Most layout managers account for the
 * insets, so the line is not overdrawn.
 */
public Insets insets() {
	if (lin == null) {
		// Prevent infinite loop by creating new inset object
		lin = new Insets(1,1,1,1);
		lin.top += 1;
		lin.left += 1;
		lin.bottom += 1;
		lin.right += 1;
	}
	return lin;
}

/**
 * Draws the line.
 */
public void paint(Graphics g) {
	Dimension d = size();
	g.setColor(getForeground());
	g.drawRect(0, 0, d.width-1, d.height-1);
}

}


