/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.data;

import com.objectshare.base.util.OSIArray;
import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntDictionary;
import com.objectshare.base.util.OSIIntDictionaryListener;
import com.objectshare.base.util.OSIIntEnumeration;
import com.objectshare.base.util.OSIIntHashtable;
import com.objectshare.base.util.OSIIntVector;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKColumnAdapter;
import com.objectshare.grid.data.JKHierarchicalAdapter;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKRowAdapter;
import com.objectshare.grid.data.JKTableModelCAL;
import com.objectshare.grid.data.JKTableModelRAL;
import java.util.Hashtable;
import java.util.NoSuchElementException;
import java.util.Vector;

public class JKTableModel
extends JKModel {
    protected OSIIntDictionary columnAdapters;
    protected JKTableModelCAL columnAdapterListener;
    protected int numRows;
    protected OSIIntDictionary rowObjects;
    protected JKTableModelRAL rowAdapterListener;
    protected Object parent;
    protected JKRowAdapter parentAdapter;
    Hashtable rowAdapterClassMap;

    public JKTableModel() {
        this((OSIIntDictionary)new OSIIntHashtable());
    }

    public JKTableModel(int n, int n2) {
        this((OSIIntDictionary)new OSIIntHashtable());
        this.addRows(n);
        this.addColumns(n2);
    }

    public JKTableModel(OSIIntDictionary oSIIntDictionary) {
        this.rowObjects = oSIIntDictionary;
        this.columnAdapterListener = new JKTableModelCAL(this, "java.lang.Object");
        this.columnAdapters = this.columnAdapterListener.getColumnAdapters();
        this.connect();
    }

    public void connect() {
        super.connect();
        if (this.rowAdapterListener == null) {
            this.rowAdapterListener = new JKTableModelRAL(this);
            this.connectParent();
        }
    }

    public void release() {
        if (this.rowAdapterListener != null) {
            this.releaseParent();
            this.rowAdapterListener.release();
            this.rowAdapterListener = null;
        }
        super.release();
    }

    public int getNumberOfRows() {
        return this.numRows;
    }

    public int getNumberOfColumns() {
        return this.columnAdapters.size();
    }

    public Object get(int n, int n2) {
        Object object = this.getColumn(n2);
        if (object instanceof JKColumnAdapter) {
            return ((JKColumnAdapter)object).getCell(n, n2);
        }
        return null;
    }

    public void set(int n, int n2, Object object) {
        Object object2 = this.getColumn(n2);
        if (object2 == null) {
            object2 = new JKColumnAdapter(this, null, null);
            this.setColumn(n2, object2);
        }
        if (object2 instanceof JKColumnAdapter) {
            ((JKColumnAdapter)object2).setCell(n, n2, object);
        }
    }

    public boolean containsRow(int n) {
        return n >= 1 && n <= this.getNumberOfRows();
    }

    public boolean containsRow(Object object) {
        return this.rowObjects.contains(object);
    }

    public int getRowNumber(Object object) throws NoSuchElementException {
        return this.rowObjects.getKey(object);
    }

    public int getRowNumberOrZero(Object object) throws NoSuchElementException {
        try {
            return this.rowObjects.getKey(object);
        }
        catch (NoSuchElementException noSuchElementException) {
            if (this.parentAdapter.getRowObject() == object) {
                return 0;
            }
            throw (NoSuchElementException)noSuchElementException.fillInStackTrace();
        }
    }

    public OSIIntEnumeration getRowNumbers(Object object) {
        return this.rowObjects.getKeys(object);
    }

    public OSIIntEnumeration getRowNumbers(Object[] objectArray) throws NoSuchElementException {
        return this.rowObjects.getKeys(objectArray);
    }

    public Object getRow(int n) {
        return this.rowObjects.get(n);
    }

    public Object getRowAdapter(int n) {
        return this.rowAdapterListener.getRowAdapter(n);
    }

    public JKRowAdapter getParentAdapter() {
        return this.parentAdapter;
    }

    public OSIEnumeration getRows() {
        return this.rowObjects.elements();
    }

    public Object[] getRowArray() {
        return this.getRows().toArray();
    }

    public OSIEnumeration getRowAdapters() {
        return this.rowAdapterListener.getRowAdapters();
    }

    public Object[] getRowAdapterArray() {
        return this.getRowAdapters().toArray();
    }

    public OSIEnumeration getCachedRows() {
        return this.getRows();
    }

    public Object[] getCachedRowArray() {
        return this.getCachedRows().toArray();
    }

    public OSIEnumeration getCachedRowAdapters() {
        return this.rowAdapterListener.getCachedRowAdapters();
    }

    public Object[] getCachedRowAdapterArray() {
        return this.getCachedRowAdapters().toArray();
    }

    public Object[] getRowArray(int n, int n2) {
        return this.rowObjects.getArray(n, n2);
    }

    public Object[] getRowAdapterArray(int n, int n2) {
        return this.rowAdapterListener.getRowAdapterArray(n, n2);
    }

    public Object[] getCachedRowAdapterArray(int n, int n2) {
        return this.rowAdapterListener.getCachedRowAdapterArray(n, n2);
    }

    public void setRow(int n, Object object) {
        this.rowObjects.put(n, object);
    }

    public void setRows(int n, Object[] objectArray) {
        this.rowObjects.putAll(n, objectArray);
    }

    public void addRow(Object object) {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            this.insertRow(this.getNumberOfRows() + 1, object);
            return;
        }
    }

    public void addRows(Object[] objectArray) {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            this.insertRows(this.getNumberOfRows() + 1, objectArray);
            return;
        }
    }

    public void addRows(int n) {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            this.insertRows(this.getNumberOfRows() + 1, n);
            return;
        }
    }

    public void insertRow(int n, Object object) {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            int n2 = this.getNumberOfRows() + 1;
            if (n2 > n) {
                n2 = n;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            this.rowObjects.insert(n2, object);
            return;
        }
    }

    public void insertRows(int n, Object[] objectArray) {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            int n2 = this.getNumberOfRows() + 1;
            if (n2 > n) {
                n2 = n;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            this.rowObjects.insertAll(n2, objectArray);
            return;
        }
    }

    public void insertRows(int n, int n2) {
        if (n2 > 0) {
            Object[] objectArray = new Object[n2];
            int n3 = n2;
            while (--n3 >= 0) {
                objectArray[n3] = new OSIIntHashtable();
            }
            this.insertRows(n, objectArray);
        }
    }

    public void insertRowBefore(Object object, Object object2) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            this.insertRow(this.getRowNumber(object), object2);
            return;
        }
    }

    public void insertRowsBefore(Object object, Object[] objectArray) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            this.insertRows(this.getRowNumber(object), objectArray);
            return;
        }
    }

    public void insertRowAfter(Object object, Object object2) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            this.insertRow(this.getRowNumber(object) + 1, object2);
            return;
        }
    }

    public void insertRowsAfter(Object object, Object[] objectArray) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            this.insertRows(this.getRowNumber(object) + 1, objectArray);
            return;
        }
    }

    public void reorderRows(int n, Object[] objectArray) {
        this.rowObjects.reorder(n, objectArray);
    }

    public void reorderRows(int n, OSIIntVector oSIIntVector) {
        this.rowObjects.reorderKeys(n, oSIIntVector);
    }

    public void removeRow(Object object) {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            try {
                JKRowAdapter jKRowAdapter = this.rowAdapterListener.getRowAdapter(this.rowObjects.getKey(object));
                if (jKRowAdapter != null) {
                    this.rowObjects.removeAll(jKRowAdapter.visibleRowObjects());
                } else {
                    this.rowObjects.remove(object);
                }
            }
            catch (NoSuchElementException noSuchElementException) {}
            return;
        }
    }

    public void removeRows(Object[] objectArray) {
        if (objectArray == null || objectArray.length < 1) {
            return;
        }
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            OSIArray oSIArray = new OSIArray(objectArray.length);
            int n = 0;
            while (n < objectArray.length) {
                if (!oSIArray.contains(objectArray[n])) {
                    try {
                        JKRowAdapter jKRowAdapter = this.rowAdapterListener.getRowAdapter(this.rowObjects.getKey(objectArray[n]));
                        if (jKRowAdapter != null) {
                            oSIArray.addAllOnce(jKRowAdapter.visibleRowObjects());
                        } else {
                            oSIArray.addOnce(objectArray[n]);
                        }
                    }
                    catch (NoSuchElementException noSuchElementException) {}
                }
                ++n;
            }
            this.rowObjects.removeAll(oSIArray.toArray());
            return;
        }
    }

    public void removeRows(int n, int n2) {
        OSIIntDictionary oSIIntDictionary = this.rowObjects;
        synchronized (oSIIntDictionary) {
            OSIArray oSIArray = new OSIArray(n2);
            int n3 = 0;
            while (n3 < n2) {
                int n4 = n + n3;
                if (!oSIArray.contains(this.rowObjects.get(n4))) {
                    JKRowAdapter jKRowAdapter = this.rowAdapterListener.getRowAdapter(n4);
                    if (jKRowAdapter != null) {
                        oSIArray.addAllOnce(jKRowAdapter.visibleRowObjects());
                    } else {
                        oSIArray.addOnce(this.rowObjects.get(n4));
                    }
                }
                ++n3;
            }
            this.rowObjects.removeAll(oSIArray.toArray());
            return;
        }
    }

    public boolean containsColumn(int n) {
        return n >= 1 && n <= this.getNumberOfColumns();
    }

    public boolean containsColumn(Object object) {
        return this.columnAdapters.contains((Object)this.validColumnAdapterFor(object));
    }

    public int getColumnNumber(Object object) throws NoSuchElementException {
        if (object instanceof String) {
            JKColumnAdapter jKColumnAdapter = this.columnAdapterListener.getColumnNamed((String)object);
            if (jKColumnAdapter == null) {
                throw new NoSuchElementException();
            }
            return jKColumnAdapter.getColumnNumber();
        }
        return this.columnAdapters.getKey((Object)this.validColumnAdapterFor(object));
    }

    public OSIIntEnumeration getColumnNumbers(Object object) {
        return this.columnAdapters.getKeys((Object)this.validColumnAdapterFor(object));
    }

    public OSIIntEnumeration getColumnNumbers(Object[] objectArray) throws NoSuchElementException {
        return this.columnAdapters.getKeys(this.validColumnAdaptersFor(objectArray));
    }

    public Object getColumn(int n) {
        return this.columnAdapters.get(n);
    }

    public OSIEnumeration getColumns() {
        return this.columnAdapters.elements();
    }

    public Object[] getColumnArray() {
        return this.getColumns().toArray();
    }

    public Object[] getColumnArray(int n, int n2) {
        return this.columnAdapters.getArray(n, n2);
    }

    public Object getColumnHeaders() {
        return this.columnAdapters;
    }

    public String getColumnName(int n) {
        return this.getColumnName(this.columnAdapters.get(n));
    }

    public String getColumnName(Object object) {
        if (object instanceof JKColumnAdapter) {
            return ((JKColumnAdapter)object).getName();
        }
        return null;
    }

    public Object getColumnNamed(String string) {
        return this.columnAdapterListener.getColumnNamed(string);
    }

    public void setColumn(int n, Object object) {
        this.columnAdapters.put(n, (Object)this.validColumnAdapterFor(object));
    }

    public void setColumns(int n, Object[] objectArray) {
        this.columnAdapters.putAll(n, this.validColumnAdaptersFor(objectArray));
    }

    public void addColumn(Object object) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            this.insertColumn(this.getNumberOfColumns() + 1, object);
            return;
        }
    }

    public boolean addColumnOnce(Object object) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            boolean bl = this.insertColumnOnce(this.getNumberOfColumns() + 1, object);
            Object var4_4 = null;
            return bl;
        }
    }

    public void addColumns(Object[] objectArray) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            this.insertColumns(this.getNumberOfColumns() + 1, objectArray);
            return;
        }
    }

    public int addColumnsOnce(Object[] objectArray) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            int n = this.insertColumnsOnce(this.getNumberOfColumns() + 1, objectArray);
            Object var4_4 = null;
            return n;
        }
    }

    public void addColumns(int n) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            this.insertColumns(this.getNumberOfColumns() + 1, n);
            return;
        }
    }

    public void insertColumn(int n, Object object) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            int n2 = this.getNumberOfColumns() + 1;
            if (n2 > n) {
                n2 = n;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            this.columnAdapters.insert(n2, (Object)this.validColumnAdapterFor(object));
            return;
        }
    }

    public boolean insertColumnOnce(int n, Object object) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            JKColumnAdapter jKColumnAdapter = this.validColumnAdapterFor(object);
            if (this.columnAdapters.contains((Object)jKColumnAdapter)) {
                boolean bl = false;
                Object var5_7 = null;
                return bl;
            }
            this.insertColumn(n, jKColumnAdapter);
            boolean bl = true;
            Object var5_8 = null;
            return bl;
        }
    }

    public void insertColumns(int n, Object[] objectArray) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            int n2 = this.getNumberOfColumns() + 1;
            if (n2 > n) {
                n2 = n;
            }
            if (n2 < 1) {
                n2 = 1;
            }
            this.columnAdapters.insertAll(n2, this.validColumnAdaptersFor(objectArray));
            return;
        }
    }

    public int insertColumnsOnce(int n, Object[] objectArray) {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            Vector<JKColumnAdapter> vector = new Vector<JKColumnAdapter>(objectArray.length);
            int n2 = 0;
            while (n2 < objectArray.length) {
                JKColumnAdapter jKColumnAdapter = this.validColumnAdapterFor(objectArray[n2]);
                if (!this.columnAdapters.contains((Object)jKColumnAdapter) && !vector.contains(jKColumnAdapter)) {
                    vector.addElement(jKColumnAdapter);
                }
                ++n2;
            }
            this.columnAdapters.insertAll(n, vector);
            int n3 = vector.size();
            Object var5_8 = null;
            return n3;
        }
    }

    public void insertColumns(int n, int n2) {
        if (n2 > 0) {
            this.insertColumns(n, new Object[n2]);
        }
    }

    public void insertColumnBefore(Object object, Object object2) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            this.insertColumn(this.getColumnNumber(object), object2);
            return;
        }
    }

    public void insertColumnsBefore(Object object, Object[] objectArray) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            this.insertColumns(this.getColumnNumber(object), objectArray);
            return;
        }
    }

    public void insertColumnAfter(Object object, Object object2) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            this.insertColumn(this.getColumnNumber(object) + 1, object2);
            return;
        }
    }

    public void insertColumnsAfter(Object object, Object[] objectArray) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            this.insertColumns(this.getColumnNumber(object) + 1, objectArray);
            return;
        }
    }

    public void reorderColumns(int n, Object[] objectArray) {
        this.columnAdapters.reorder(n, this.validColumnAdaptersFor(objectArray));
    }

    public void reorderColumns(int n, OSIIntVector oSIIntVector) {
        this.columnAdapters.reorderKeys(n, oSIIntVector);
    }

    public void removeColumn(Object object) {
        this.columnAdapters.remove((Object)this.validColumnAdapterFor(object));
    }

    public void removeColumns(Object[] objectArray) {
        this.columnAdapters.removeAll(this.validColumnAdaptersFor(objectArray));
    }

    public void removeColumns(int n, int n2) {
        this.columnAdapters.removeKeys(n, n2);
    }

    public Object getParent() {
        return this.parent;
    }

    public void setParent(Object object) {
        if (this.parent != object) {
            if (this.rowAdapterListener != null) {
                this.releaseParent();
                this.parent = object;
                this.connectParent();
                return;
            }
            this.parent = object;
        }
    }

    public void connectParent() {
        if (this.parentAdapter == null && this.parent != null) {
            this.parentAdapter = JKRowAdapter.newFor(this, 0, this.parent);
            this.parentAdapter.connect();
            this.parentAdapter.expand();
        }
    }

    public void releaseParent() {
        if (this.parentAdapter != null) {
            this.parentAdapter.collapse();
            this.parentAdapter.release();
            this.parentAdapter = null;
        }
    }

    public void expandRow(Object object) {
        JKRowAdapter jKRowAdapter = this.rowAdapterListener.getRowAdapter(object);
        if (jKRowAdapter != null) {
            jKRowAdapter.expand();
        }
    }

    public void expandRow(int n) {
        JKRowAdapter jKRowAdapter = this.rowAdapterListener.getRowAdapter(n);
        if (jKRowAdapter != null) {
            jKRowAdapter.expand();
        }
    }

    public void collapseRow(Object object) {
        JKRowAdapter jKRowAdapter = this.rowAdapterListener.getRowAdapter(object);
        if (jKRowAdapter != null) {
            jKRowAdapter.collapse();
        }
    }

    public void collapseRow(int n) {
        JKRowAdapter jKRowAdapter = this.rowAdapterListener.getRowAdapter(n);
        if (jKRowAdapter != null) {
            jKRowAdapter.collapse();
        }
    }

    public Object getParentRow(Object object) throws NoSuchElementException {
        return this.getParentRow(this.getRowNumber(object));
    }

    public Object getParentRow(int n) {
        JKRowAdapter jKRowAdapter = this.getParentRowAdapter(n);
        if (jKRowAdapter != null) {
            return jKRowAdapter.getRowObject();
        }
        return null;
    }

    public int getParentRowNumber(Object object) throws NoSuchElementException {
        return this.getParentRowNumber(this.getRowNumber(object));
    }

    public int getParentRowNumber(int n) throws NoSuchElementException {
        JKRowAdapter jKRowAdapter = this.getParentRowAdapter(n);
        if (jKRowAdapter != null) {
            return jKRowAdapter.getRowNumber();
        }
        throw new NoSuchElementException("No parent for row " + n);
    }

    final JKRowAdapter getParentRowAdapter(int n) {
        JKRowAdapter jKRowAdapter = this.rowAdapterListener.getRowAdapter(n);
        if (jKRowAdapter != null) {
            return (JKRowAdapter)jKRowAdapter.getParentAdapter();
        }
        return null;
    }

    public void triggerChanged(JKRowAdapter jKRowAdapter) {
        try {
            this.triggerChanged(jKRowAdapter.getRowNumber());
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void triggerChanged(JKRowAdapter jKRowAdapter, int n) {
        try {
            this.triggerChanged(jKRowAdapter.getRowNumber(), n);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void triggerChanged(JKRowAdapter jKRowAdapter, int n, int n2) {
        try {
            this.triggerChanged(jKRowAdapter.getRowNumber(), n, n2);
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void triggerChanged(JKRowAdapter jKRowAdapter, String string) {
        JKColumnAdapter jKColumnAdapter = this.columnAdapterListener.getColumnNamed(string);
        if (jKColumnAdapter instanceof JKColumnAdapter) {
            try {
                this.triggerChanged(jKRowAdapter, jKColumnAdapter.getColumnNumber());
                return;
            }
            catch (NoSuchElementException noSuchElementException) {
                return;
            }
        }
    }

    public void triggerChanged(JKColumnAdapter jKColumnAdapter) {
        try {
            this.triggerChanged(JKTableArea.newForColumn(jKColumnAdapter.getColumnNumber()));
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public void triggerChanged(int n, JKColumnAdapter jKColumnAdapter) {
        try {
            this.triggerChanged(n, jKColumnAdapter.getColumnNumber());
            return;
        }
        catch (NoSuchElementException noSuchElementException) {
            return;
        }
    }

    public Object getRowAdapterOrNullFor(Class clazz) {
        return JKRowAdapter.getRowAdapterOrNullFor(clazz, this.rowAdapterClassMap);
    }

    public void addRowType(String string, String string2) {
        this.addRowAdapterAssociation(string, string2);
    }

    public void addRowAdapterAssociation(Object object, Object object2) {
        if (this.rowAdapterClassMap == null) {
            this.rowAdapterClassMap = new Hashtable();
        }
        JKRowAdapter.addRowAdapterAssociation(object, object2, this.rowAdapterClassMap);
    }

    public void removeRowType(String string) {
        this.removeRowAdapterAssociation(string);
    }

    public void removeRowAdapterAssociation(String string) {
        if (this.rowAdapterClassMap != null) {
            this.rowAdapterClassMap.remove(string);
            if (this.rowAdapterClassMap.isEmpty()) {
                this.rowAdapterClassMap = null;
            }
        }
    }

    protected void addColumnAdapterListener(OSIIntDictionaryListener oSIIntDictionaryListener) {
        this.columnAdapters.addDictionaryListener(oSIIntDictionaryListener);
    }

    protected void removeColumnAdapterListener(OSIIntDictionaryListener oSIIntDictionaryListener) {
        this.columnAdapters.removeDictionaryListener(oSIIntDictionaryListener);
    }

    protected JKColumnAdapter validColumnAdapterFor(Object object) {
        if (object instanceof JKColumnAdapter) {
            return ((JKColumnAdapter)object).cloneFor(this);
        }
        if (object == null) {
            return new JKColumnAdapter(this, null, null);
        }
        return new JKColumnAdapter(this, object.toString(), object);
    }

    protected Object[] validColumnAdaptersFor(Object[] objectArray) {
        Object[] objectArray2 = new JKColumnAdapter[objectArray.length];
        int n = 0;
        while (n < objectArray2.length) {
            objectArray2[n] = this.validColumnAdapterFor(objectArray[n]);
            ++n;
        }
        return objectArray2;
    }

    public int getColumnNumberForAdapter(Object object, int n) throws NoSuchElementException {
        OSIIntDictionary oSIIntDictionary = this.columnAdapters;
        synchronized (oSIIntDictionary) {
            if (this.columnAdapters.get(n) == object) {
                int n2 = n;
                Object var5_6 = null;
                return n2;
            }
            int n3 = this.columnAdapters.getKey(object);
            Object var5_7 = null;
            return n3;
        }
    }

    public String existingOrInheritedRowType(Class clazz) {
        return "java.lang.Object";
    }

    public OSIIntDictionary existingColumnAdapters(String string) {
        return this.columnAdapters;
    }

    public int getRowNumberForAdapter(Object object, int n) throws NoSuchElementException {
        return this.rowAdapterListener.getRowNumberForAdapter(object, n);
    }

    public int getHierarchicalIndentForRowAdapter(JKRowAdapter jKRowAdapter) {
        int n = 0;
        if (jKRowAdapter != null) {
            if (jKRowAdapter.getParentAdapter() != null) {
                JKHierarchicalAdapter jKHierarchicalAdapter = jKRowAdapter;
                while (jKHierarchicalAdapter != null && jKHierarchicalAdapter != this.parentAdapter) {
                    ++n;
                    jKHierarchicalAdapter = jKHierarchicalAdapter.getParentAdapter();
                }
            } else if (jKRowAdapter.canHaveChildren()) {
                return 1;
            }
        }
        return n;
    }

    protected JKRowAdapter newRowAdapterFor(JKRowAdapter jKRowAdapter, Object object) {
        JKRowAdapter jKRowAdapter2 = JKRowAdapter.newFor(this, 0, object);
        jKRowAdapter2.setParentAdapter(jKRowAdapter);
        jKRowAdapter2.connect();
        return jKRowAdapter2;
    }
}

