/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.draw;

import com.objectshare.base.util.OSIHashtable;
import com.objectshare.grid.draw.JKAbstractDrawingContext;
import com.objectshare.grid.draw.JKButtonDrawingPolicy;
import com.objectshare.grid.draw.JKCheckboxDrawingContext;
import com.objectshare.grid.draw.JKDrawingPolicy;
import com.objectshare.grid.draw.JKRevColorDrawingPolicy;
import com.objectshare.grid.draw.JKTranslateDrawingPolicy;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.util.Hashtable;

public class JKDrawingContext
extends JKAbstractDrawingContext {
    public Color foreColor;
    public Color backColor;
    public Font font;
    protected int scale = 0;
    public int horizontalJustification;
    public int verticalJustification;
    public Color borderColor;
    public Insets borderInsets;
    public Insets contentInsets;
    protected JKDrawingPolicy drawingPolicy;
    protected JKDrawingPolicy selectionDrawingPolicy;
    protected Object editingPolicy;
    protected Object tool;
    static Hashtable templates = new Hashtable();

    public JKDrawingContext() {
    }

    protected JKDrawingContext(JKDrawingContext jKDrawingContext) {
        super(jKDrawingContext);
    }

    public JKDrawingContext newChild() {
        return new JKDrawingContext(this);
    }

    public void reset() {
        this.foreColor = null;
        this.backColor = null;
        this.borderColor = null;
        this.font = null;
        this.horizontalJustification = 0;
        this.verticalJustification = 0;
        this.borderInsets = null;
        this.contentInsets = null;
        this.drawingPolicy = null;
        this.selectionDrawingPolicy = null;
        this.tool = null;
        this.scale = 0;
    }

    public Color getForeColorAttribute() {
        return this.foreColor;
    }

    public Color getForeColor() {
        if (this.foreColor != null) {
            return this.foreColor;
        }
        return super.getForeColor();
    }

    public void setForeColor(Color color) {
        this.foreColor = color;
    }

    public Color getBackColorAttribute() {
        return this.backColor;
    }

    public Color getBackColor() {
        if (this.backColor != null) {
            return this.backColor;
        }
        return super.getBackColor();
    }

    public void setBackColor(Color color) {
        this.backColor = color;
    }

    public Font getFontAttribute() {
        return this.font;
    }

    public Font getFont() {
        if (this.font != null) {
            return this.font;
        }
        return super.getFont();
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public int getScaleAttribute() {
        return this.scale;
    }

    public int getScale() {
        if (this.scale != 0) {
            return this.scale;
        }
        return super.getScale();
    }

    public void setScale(int n) {
        this.scale = n;
    }

    public int getHorizontalJustificationAttribute() {
        return this.horizontalJustification;
    }

    public int getHorizontalJustification() {
        if (this.horizontalJustification != 0) {
            return this.horizontalJustification;
        }
        return super.getHorizontalJustification();
    }

    public void setHorizontalJustification(int n) {
        this.horizontalJustification = n;
    }

    public int getVerticalJustificationAttribute() {
        return this.verticalJustification;
    }

    public int getVerticalJustification() {
        if (this.verticalJustification != 0) {
            return this.verticalJustification;
        }
        return super.getVerticalJustification();
    }

    public void setVerticalJustification(int n) {
        this.verticalJustification = n;
    }

    public Color getBorderColorAttribute() {
        return this.borderColor;
    }

    public Color getBorderColor() {
        if (this.borderColor != null) {
            return this.borderColor;
        }
        return super.getBorderColor();
    }

    public void setBorderColor(Color color) {
        this.borderColor = color;
    }

    public Insets getBorderInsetsAttribute() {
        return this.borderInsets;
    }

    public Insets getBorderInsets() {
        if (this.borderInsets != null) {
            return this.borderInsets;
        }
        return super.getBorderInsets();
    }

    public void setBorderInsets(Insets insets) {
        this.borderInsets = insets;
    }

    public Insets getContentInsetsAttribute() {
        return this.contentInsets;
    }

    public Insets getContentInsets() {
        if (this.contentInsets != null) {
            return this.contentInsets;
        }
        return super.getContentInsets();
    }

    public void setContentInsets(Insets insets) {
        this.contentInsets = insets;
    }

    public JKDrawingPolicy getDrawingPolicyAttribute() {
        return this.drawingPolicy;
    }

    public JKDrawingPolicy getDrawingPolicy() {
        if (this.drawingPolicy != null) {
            return this.drawingPolicy;
        }
        return super.getDrawingPolicy();
    }

    public void setDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        this.drawingPolicy = jKDrawingPolicy;
    }

    public JKDrawingPolicy getSelectionDrawingPolicyAttribute() {
        return this.selectionDrawingPolicy;
    }

    public JKDrawingPolicy getSelectionDrawingPolicy() {
        if (this.selectionDrawingPolicy != null) {
            return this.selectionDrawingPolicy;
        }
        return super.getSelectionDrawingPolicy();
    }

    public void setSelectionDrawingPolicy(JKDrawingPolicy jKDrawingPolicy) {
        this.selectionDrawingPolicy = jKDrawingPolicy;
    }

    public Object getEditingPolicyAttribute() {
        return this.editingPolicy;
    }

    public Object getEditingPolicy() {
        if (this.editingPolicy != null) {
            return this.editingPolicy;
        }
        return super.getEditingPolicy();
    }

    public void setEditingPolicy(Object object) {
        this.editingPolicy = object;
    }

    public Object getToolAttribute() {
        return this.tool;
    }

    public Object getTool() {
        if (this.tool != null) {
            return this.tool;
        }
        return super.getTool();
    }

    public void setTool(Object object) {
        this.tool = object;
    }

    public void initButtonDrawingAttributes() {
        this.setDrawingPolicy(JKAbstractDrawingContext.defaultButtonDrawingPolicy);
        this.setSelectionDrawingPolicy(JKAbstractDrawingContext.defaultButtonSelectionDrawingPolicy);
        this.setBackColor(JKAbstractDrawingContext.defaultButtonColor);
        this.setBorderColor(JKAbstractDrawingContext.defaultButtonBorderColor);
        this.setHorizontalJustification(JKAbstractDrawingContext.defaultButtonHorizontalJustification);
        this.setVerticalJustification(JKAbstractDrawingContext.defaultButtonVerticalJustification);
    }

    public void initHeaderDrawingAttributes() {
        this.setBackColor(JKAbstractDrawingContext.defaultButtonColor);
        this.setBorderColor(JKAbstractDrawingContext.defaultButtonBorderColor);
    }

    public void applyTo(JKDrawingContext jKDrawingContext) {
        if (this.foreColor != null) {
            jKDrawingContext.setForeColor(this.foreColor);
        }
        if (this.backColor != null) {
            jKDrawingContext.setBackColor(this.backColor);
        }
        if (this.borderColor != null) {
            jKDrawingContext.setBorderColor(this.borderColor);
        }
        if (this.font != null) {
            jKDrawingContext.setFont(this.font);
        }
        if (this.horizontalJustification != 0) {
            jKDrawingContext.setHorizontalJustification(this.horizontalJustification);
        }
        if (this.verticalJustification != 0) {
            jKDrawingContext.setVerticalJustification(this.verticalJustification);
        }
        if (this.borderInsets != null) {
            jKDrawingContext.setBorderInsets(this.borderInsets);
        }
        if (this.contentInsets != null) {
            jKDrawingContext.setContentInsets(this.contentInsets);
        }
        if (this.drawingPolicy != null) {
            jKDrawingContext.setDrawingPolicy(this.drawingPolicy);
        }
        if (this.selectionDrawingPolicy != null) {
            jKDrawingContext.setSelectionDrawingPolicy(this.selectionDrawingPolicy);
        }
        if (this.scale != 0) {
            jKDrawingContext.setScale(this.scale);
        }
        if (this.tool != null) {
            jKDrawingContext.setTool(this.tool);
        }
        if (this.editingPolicy != null) {
            jKDrawingContext.setEditingPolicy(this.editingPolicy);
        }
    }

    public static void addTemplate(String string, JKDrawingContext jKDrawingContext) {
        templates.put(string, jKDrawingContext);
    }

    public static void removeTemplate(String string) {
        templates.remove(string);
    }

    public static JKDrawingContext getTemplate(String string) {
        return (JKDrawingContext)templates.get(string);
    }

    static {
        JKDrawingContext jKDrawingContext = new JKDrawingContext();
        jKDrawingContext.setDrawingPolicy(new JKButtonDrawingPolicy(false));
        jKDrawingContext.setSelectionDrawingPolicy(new JKButtonDrawingPolicy(true));
        jKDrawingContext.setBackColor(Color.lightGray);
        jKDrawingContext.setBorderColor(Color.black);
        jKDrawingContext.setHorizontalJustification(2);
        jKDrawingContext.setVerticalJustification(2);
        JKDrawingContext.addTemplate("button", jKDrawingContext);
        jKDrawingContext = new JKDrawingContext();
        JKDrawingContext.getTemplate("button").applyTo(jKDrawingContext);
        JKDrawingContext.addTemplate("rowHeader", jKDrawingContext);
        jKDrawingContext = new JKDrawingContext();
        JKDrawingContext.getTemplate("button").applyTo(jKDrawingContext);
        JKDrawingContext.addTemplate("columnHeader", jKDrawingContext);
        jKDrawingContext = new JKDrawingContext();
        JKDrawingContext.getTemplate("columnHeader").applyTo(jKDrawingContext);
        JKDrawingContext.addTemplate("inlineColumnHeader", jKDrawingContext);
        jKDrawingContext = new JKDrawingContext();
        jKDrawingContext.setBackColor(Color.lightGray);
        jKDrawingContext.setBorderColor(Color.black);
        JKDrawingContext.addTemplate("topLeftHeader", jKDrawingContext);
        jKDrawingContext = new JKDrawingContext();
        OSIHashtable oSIHashtable = new OSIHashtable();
        oSIHashtable.put((Object)Boolean.FALSE, (Object)JKCheckboxDrawingContext.drawnCheckbox);
        oSIHashtable.put((Object)Boolean.TRUE, (Object)JKCheckboxDrawingContext.drawnCheckboxChecked);
        oSIHashtable.setDefaultValue((Object)JKCheckboxDrawingContext.drawnCheckboxGray);
        JKTranslateDrawingPolicy jKTranslateDrawingPolicy = new JKTranslateDrawingPolicy(oSIHashtable);
        jKDrawingContext.setDrawingPolicy(jKTranslateDrawingPolicy);
        jKDrawingContext.setSelectionDrawingPolicy(new JKRevColorDrawingPolicy(jKTranslateDrawingPolicy));
        jKDrawingContext.setHorizontalJustification(2);
        jKDrawingContext.setVerticalJustification(2);
        JKDrawingContext.addTemplate("checkbox", jKDrawingContext);
        jKDrawingContext = new JKDrawingContext(jKDrawingContext);
        JKDrawingContext.addTemplate("triStateCheckbox", jKDrawingContext);
    }
}

