/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.edit;

import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.draw.JKDrawingContext;
import com.objectshare.grid.draw.JKDrawnObject;
import com.objectshare.grid.draw.JKDrawnString;
import com.objectshare.grid.draw.JKHierDrawnObject;
import com.objectshare.grid.edit.JKEditEvent;
import com.objectshare.grid.edit.JKEditedObject;
import com.objectshare.grid.edit.JKEditingPolicy;
import com.objectshare.grid.edit.JKTableEdit;
import com.objectshare.grid.edit.JKVetoEditException;
import com.objectshare.grid.list.JKDrawListEvent;
import com.objectshare.grid.list.JKFocusEvent;
import com.objectshare.grid.list.JKItemEvent;
import com.objectshare.grid.list.JKKeyEvent;
import com.objectshare.grid.list.JKMouseEvent;
import com.objectshare.grid.view.JKTableViewAdapter;
import com.objectshare.java.osi.OSIEventTable;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;

public class JKEditAction
extends JKDrawListEvent
implements MouseListener,
MouseMotionListener,
KeyListener,
FocusListener,
ItemListener {
    public Object editor;
    public Object originalValue;
    public Object currentValue;
    public boolean isValid;
    protected JKTableEdit tableEdit;
    public JKEditingPolicy editPolicy;
    protected JKEditEvent editEvent;

    public JKEditAction(JKDrawingContext jKDrawingContext, JKTableViewAdapter jKTableViewAdapter, Graphics graphics, JKTableArea jKTableArea, JKTableArea jKTableArea2) {
        super(jKDrawingContext, jKTableViewAdapter, graphics, jKTableArea, jKTableArea2);
        if (JKEditingPolicy.isValid(this.getEditingPolicy())) {
            this.editPolicy = (JKEditingPolicy)this.getEditingPolicy();
        }
        this.editEvent = new JKEditEvent(this);
        this.tableEdit = (JKTableEdit)this.getSource();
    }

    public boolean edit(int n, int n2) {
        if (this.editPolicy == null) {
            return false;
        }
        this.dataX = n;
        this.dataY = n2;
        this.currentValue = this.originalValue = this.owner.getModel().get(this.dataY, this.dataX);
        JKDrawnObject jKDrawnObject = this.editEvent.getOldDrawnValue();
        this.editor = jKDrawnObject instanceof JKEditedObject ? ((JKEditedObject)((Object)jKDrawnObject)).jkEdit(this, this.originalValue) : this.jkEdit(this.originalValue);
        try {
            this.tableEdit.triggerAboutToEdit(this);
        }
        catch (JKVetoEditException jKVetoEditException) {
            this.currentValue = null;
            this.originalValue = null;
            return false;
        }
        this.editPolicy.openEditor(this.editEvent);
        return true;
    }

    public Object jkEdit(Object object) {
        this.originalValue = this.currentValue = object;
        this.editor = this.editPolicy.getEditor(this.editEvent);
        this.editPolicy.initEditor(this.editEvent);
        this.editPolicy.setEditorValue(this.editEvent);
        return this.editor;
    }

    public void setupEdit(Component component) {
        this.editPolicy.setupEdit(this, component);
    }

    public void cacheEditor(Component component) {
        this.tableEdit.cacheEditor(component);
    }

    public Component getEditor(String string) {
        return this.tableEdit.getEditor(string);
    }

    public boolean validate() {
        try {
            if (this.editPolicy.validateEditorValue(this.editEvent)) {
                this.currentValue = this.editPolicy.getEditorValue(this.editEvent);
                if (!this.editPolicy.equalValues(this.editEvent)) {
                    this.tableEdit.triggerValidateEdit(this);
                    this.owner.getModel().set(this.dataY, this.dataX, this.currentValue);
                    this.tableEdit.triggerEdited(this);
                    this.originalValue = this.currentValue;
                }
            }
            return true;
        }
        catch (JKVetoEditException jKVetoEditException) {
            return false;
        }
    }

    public void closeEditor() {
        this.editPolicy.closeEditor(this.editEvent);
    }

    public void moveEditor(int n, int n2, boolean bl) {
        if (!bl) {
            this.editPolicy.hideEditor(this.editEvent);
        }
        this.editPolicy.moveEditor(this.editEvent, n, n2);
        if (bl) {
            this.editPolicy.showEditor(this.editEvent);
        }
    }

    public void hideEditor() {
        this.editPolicy.hideEditor(this.editEvent);
        this.editPolicy.reshapeEditor(this.editEvent, new Rectangle(10000, 10000, 10, 10));
    }

    public void showEditor() {
        if (!(this.editor instanceof Component)) {
            return;
        }
        Component cfr_ignored_0 = (Component)this.editor;
        JKDrawnObject jKDrawnObject = JKDrawnString.newFor(this.owner, this.owner.getModel().get(this.dataY, this.dataX));
        if (this.dataX == 1 && this.dataY > 0) {
            jKDrawnObject = JKHierDrawnObject.newFor(this.owner.getModel().getRowAdapter(this.dataY), jKDrawnObject);
        }
        Rectangle rectangle = this.adapter.getScreenBounds();
        this.cellBox = this.adapter.getCellScreenBounds(this.dataY, this.dataX);
        Rectangle rectangle2 = this.cellBox.intersection(rectangle);
        if (!rectangle2.equals(this.cellBox)) {
            this.hideEditor();
            return;
        }
        rectangle2 = this.editFrame(jKDrawnObject, this.cellBox).intersection(rectangle);
        this.editPolicy.reshapeEditor(this.editEvent, rectangle2);
        this.editPolicy.showEditor(this.editEvent);
        this.editPolicy.requestEditorFocus(this.editEvent);
    }

    public void requestEditorFocus() {
        if (this.editPolicy != null) {
            this.editPolicy.requestEditorFocus(this.editEvent);
        }
    }

    public Rectangle editFrame(Object object, Rectangle rectangle) {
        Rectangle rectangle2 = this.backgroundFrame(rectangle);
        if (object instanceof JKEditedObject) {
            rectangle2 = ((JKEditedObject)object).jkEditFrame(this, rectangle2);
        }
        return rectangle2;
    }

    public JKTableEdit getTableEdit() {
        return this.tableEdit;
    }

    public JKEditEvent getEditEvent() {
        return this.editEvent;
    }

    public void addItemListener() {
        if (this.editor instanceof Choice) {
            OSIEventTable.addItemListener((Choice)((Choice)this.editor), (ItemListener)this);
        }
    }

    public void removeItemListener() {
        if (this.editor instanceof Choice) {
            OSIEventTable.removeItemListener((Choice)((Choice)this.editor), (ItemListener)this);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.editPolicy.itemStateChanged(this.editEvent, new JKItemEvent(itemEvent));
    }

    public void addMouseListener() {
        if (this.editor instanceof Component) {
            OSIEventTable.addMouseListener((Component)((Component)this.editor), (MouseListener)this);
        }
    }

    public void removeMouseListener() {
        if (this.editor instanceof Component) {
            OSIEventTable.removeMouseListener((Component)((Component)this.editor), (MouseListener)this);
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
        this.editPolicy.mouseClicked(this.editEvent, new JKMouseEvent(mouseEvent));
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.editPolicy.mousePressed(this.editEvent, new JKMouseEvent(mouseEvent));
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.editPolicy.mouseReleased(this.editEvent, new JKMouseEvent(mouseEvent));
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        this.editPolicy.mouseEntered(this.editEvent, new JKMouseEvent(mouseEvent));
    }

    public void mouseExited(MouseEvent mouseEvent) {
        this.editPolicy.mouseExited(this.editEvent, new JKMouseEvent(mouseEvent));
    }

    public void addMouseMotionListener() {
        if (this.editor instanceof Component) {
            OSIEventTable.addMouseMotionListener((Component)((Component)this.editor), (MouseMotionListener)this);
        }
    }

    public void removeMouseMotionListener() {
        if (this.editor instanceof Component) {
            OSIEventTable.removeMouseMotionListener((Component)((Component)this.editor), (MouseMotionListener)this);
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.editPolicy.mouseDragged(this.editEvent, new JKMouseEvent(mouseEvent));
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.editPolicy.mouseMoved(this.editEvent, new JKMouseEvent(mouseEvent));
    }

    public void addKeyListener() {
        if (this.editor instanceof Component) {
            OSIEventTable.addKeyListener((Component)((Component)this.editor), (KeyListener)this);
        }
    }

    public void removeKeyListener() {
        if (this.editor instanceof Component) {
            OSIEventTable.removeKeyListener((Component)((Component)this.editor), (KeyListener)this);
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.editPolicy.keyTyped(this.editEvent, new JKKeyEvent(keyEvent));
    }

    public void keyPressed(KeyEvent keyEvent) {
        this.editPolicy.keyPressed(this.editEvent, new JKKeyEvent(keyEvent));
    }

    public void keyReleased(KeyEvent keyEvent) {
        this.editPolicy.keyReleased(this.editEvent, new JKKeyEvent(keyEvent));
    }

    public void addFocusListener() {
        if (this.editor instanceof Component) {
            OSIEventTable.addFocusListener((Component)((Component)this.editor), (FocusListener)this);
        }
    }

    public void removeFocusListener() {
        if (this.editor instanceof Component) {
            OSIEventTable.removeFocusListener((Component)((Component)this.editor), (FocusListener)this);
        }
    }

    public void focusGained(FocusEvent focusEvent) {
        this.editPolicy.focusGained(this.editEvent, new JKFocusEvent(focusEvent));
    }

    public void focusLost(FocusEvent focusEvent) {
        this.editPolicy.focusLost(this.editEvent, new JKFocusEvent(focusEvent));
    }
}

