/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.edit;

import com.objectshare.base.util.OSIEnumeration;
import com.objectshare.base.util.OSIIntToIntHashtable;
import com.objectshare.grid.area.JKRectangularArea;
import com.objectshare.grid.area.JKTableArea;
import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.data.JKTableModel;
import com.objectshare.grid.draw.JKAbstractDrawingContext;
import com.objectshare.grid.draw.JKDrawingContext;
import com.objectshare.grid.edit.JKCheckboxEditingPolicy;
import com.objectshare.grid.edit.JKEditAction;
import com.objectshare.grid.edit.JKEditEvent;
import com.objectshare.grid.edit.JKEditListener;
import com.objectshare.grid.edit.JKEditMulticaster;
import com.objectshare.grid.edit.JKEditingPolicy;
import com.objectshare.grid.edit.JKTextFieldEditingContext;
import com.objectshare.grid.edit.JKVetoEditException;
import com.objectshare.grid.list.JKTableList;
import com.objectshare.grid.tool.JKCellEditTool;
import com.objectshare.grid.view.JKTableViewAdapter;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;
import java.awt.TextField;
import java.util.Hashtable;

public class JKTableEdit
extends JKTableList
implements Runnable {
    static final long serialVersionUID = -2950785502390014131L;
    public transient JKEditAction editAction;
    protected Hashtable editors = new Hashtable();
    protected transient long showEditorTimeMillis;
    protected transient Thread showEditorThread;
    protected JKEditListener editListener;

    public JKTableEdit() {
        this(new JKTableModel());
    }

    public JKTableEdit(int n, int n2) {
        this(new JKTableModel(n2, n));
    }

    public JKTableEdit(JKModel jKModel) {
        super(jKModel);
        this.cacheEditor(new TextField());
        this.cacheEditor(new Choice());
    }

    protected void initHelpers() {
        super.initHelpers();
        this.displayPolicy.cellAreaDC = new JKTextFieldEditingContext(this.displayPolicy.tableDC);
        this.setCellAreaTool(new JKCellEditTool(this, this.cellAdapter));
    }

    public JKEditEvent getEditEvent() {
        if (this.editAction == null) {
            return null;
        }
        return this.editAction.getEditEvent();
    }

    public void setModel(JKModel jKModel) {
        this.closeEditor();
        super.setModel(jKModel);
    }

    public void cacheEditor(Component component) {
        Object v = this.editors.get(component.getClass().getName());
        if (v != null) {
            ((Container)((Object)this)).remove((Component)v);
        }
        component.hide();
        ((Container)((Object)this)).add(component);
        component.reshape(10000, 10000, 50, 50);
        this.editors.put(component.getClass().getName(), component);
    }

    public Component getCachedEditor(String string) {
        Object v = this.editors.get(string);
        if (v == null) {
            return null;
        }
        return (Component)v;
    }

    public Component getEditor(String string) {
        Component component = this.getCachedEditor(string);
        if (component == null) {
            try {
                component = (Component)Class.forName(string).newInstance();
            }
            catch (Exception exception) {
                component = null;
            }
            if (component != null) {
                this.cacheEditor(component);
            }
        }
        return component;
    }

    public synchronized boolean openEditor(int n, int n2) {
        if (!this.closeEditor()) {
            return false;
        }
        JKTableViewAdapter jKTableViewAdapter = this.coordinator.getAdapterForCell(n2, n);
        if (jKTableViewAdapter == null) {
            return false;
        }
        this.editAction = new JKEditAction(this.displayPolicy.existingCellDrawingContext(n2, n), jKTableViewAdapter, null, JKTableArea.empty, JKTableArea.empty);
        if (this.editAction.edit(n, n2)) {
            this.showEditor();
            return true;
        }
        this.editAction = null;
        return false;
    }

    public void requestEditorFocus() {
        if (this.editAction != null) {
            this.editAction.requestEditorFocus();
        }
    }

    public boolean validateEditor() {
        if (this.editAction != null) {
            return this.editAction.validate();
        }
        return true;
    }

    public synchronized boolean closeEditor() {
        if (this.validateEditor()) {
            this.basicCloseEditor();
            return true;
        }
        return false;
    }

    public synchronized void basicCloseEditor() {
        if (this.editAction != null) {
            this.editAction.closeEditor();
            this.hideEditor();
            this.editAction = null;
        }
    }

    public synchronized void hideEditor() {
        if (this.editAction != null) {
            this.editAction.hideEditor();
        }
        this.stopShowEditorThread();
    }

    public synchronized void hideEditor(long l) {
        this.hideEditor();
        this.startShowEditorThread(l);
    }

    public synchronized void showEditor() {
        this.startShowEditorThread(150L);
    }

    protected synchronized void showEditorNow() {
        if (this.editAction != null) {
            this.editAction.showEditor();
        }
        this.stopShowEditorThread();
    }

    public boolean gotFocus(Event event, Object object) {
        this.requestEditorFocus();
        return super.gotFocus(event, object);
    }

    protected synchronized void startShowEditorThread(long l) {
        this.stopShowEditorThread();
        this.showEditorTimeMillis = System.currentTimeMillis() + l;
        this.showEditorThread = new Thread(this);
        this.showEditorThread.start();
    }

    protected synchronized void stopShowEditorThread() {
        if (this.showEditorThread == null) {
            return;
        }
        Thread thread = this.showEditorThread;
        this.showEditorThread = null;
        thread.stop();
    }

    public void run() {
        while (true) {
            long l;
            if ((l = this.showEditorTimeMillis - System.currentTimeMillis()) <= 0L) {
                this.showEditorNow();
                return;
            }
            try {
                Thread.sleep(l);
                continue;
            }
            catch (InterruptedException interruptedException) {
                continue;
            }
            break;
        }
    }

    public void setEditingPolicy(JKTableArea jKTableArea, JKEditingPolicy jKEditingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getDrawingContexts(jKTableArea);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setEditingPolicy(jKEditingPolicy);
        }
    }

    public JKEditingPolicy getEditingPolicy() {
        return (JKEditingPolicy)this.displayPolicy.tableDC.getEditingPolicy();
    }

    public void setEditingPolicy(JKEditingPolicy jKEditingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setEditingPolicy(jKEditingPolicy);
        }
    }

    public void setReadOnly() {
        this.setEditingPolicy(JKEditingPolicy.READ_ONLY);
    }

    public void setEditingPolicyDefault(JKEditingPolicy jKEditingPolicy) {
        this.displayPolicy.tableDC.setEditingPolicy(jKEditingPolicy);
    }

    public void setReadOnlyDefault() {
        this.setEditingPolicyDefault(JKEditingPolicy.READ_ONLY);
    }

    public JKEditingPolicy getHeaderEditingPolicy() {
        return (JKEditingPolicy)this.displayPolicy.topLeftHdrDC.getEditingPolicy();
    }

    public void setHeaderEditingPolicy(JKEditingPolicy jKEditingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setEditingPolicy(jKEditingPolicy);
        }
    }

    public void setHeaderReadOnly() {
        this.setHeaderEditingPolicy(JKEditingPolicy.READ_ONLY);
    }

    public void setHeaderEditingPolicyDefault(JKEditingPolicy jKEditingPolicy) {
        this.displayPolicy.topLeftHdrDC.setEditingPolicy(jKEditingPolicy);
        this.displayPolicy.columnHdrDC.setEditingPolicy(jKEditingPolicy);
        this.displayPolicy.rowHdrDC.setEditingPolicy(jKEditingPolicy);
    }

    public void setHeaderReadOnlyDefault() {
        this.setHeaderEditingPolicyDefault(JKEditingPolicy.READ_ONLY);
    }

    public JKEditingPolicy getRowEditingPolicy(int n) {
        return (JKEditingPolicy)this.displayPolicy.existingRowDrawingContext(n).getEditingPolicy();
    }

    public void setRowEditingPolicy(int n, JKEditingPolicy jKEditingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getRowAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setEditingPolicy(jKEditingPolicy);
        }
    }

    public void setRowReadOnly(int n) {
        this.setRowEditingPolicy(n, JKEditingPolicy.READ_ONLY);
    }

    public JKEditingPolicy getRowHeaderEditingPolicy() {
        return (JKEditingPolicy)this.displayPolicy.rowHdrDC.getEditingPolicy();
    }

    public void setRowHeaderEditingPolicy(JKEditingPolicy jKEditingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingRowHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setEditingPolicy(jKEditingPolicy);
        }
    }

    public void setRowHeaderReadOnly() {
        this.setRowHeaderEditingPolicy(JKEditingPolicy.READ_ONLY);
    }

    public void setRowHeaderEditingPolicyDefault(JKEditingPolicy jKEditingPolicy) {
        this.displayPolicy.rowHdrDC.setEditingPolicy(jKEditingPolicy);
    }

    public void setRowHeaderReadOnlyDefault() {
        this.setRowHeaderEditingPolicyDefault(JKEditingPolicy.READ_ONLY);
    }

    public JKEditingPolicy getColumnEditingPolicy(int n) {
        return (JKEditingPolicy)this.displayPolicy.existingColumnDrawingContext(n).getEditingPolicy();
    }

    public void setColumnEditingPolicy(int n, JKEditingPolicy jKEditingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.getColumnAndCellDrawingContexts(n);
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setEditingPolicy(jKEditingPolicy);
        }
    }

    public void setColumnReadOnly(int n) {
        this.setColumnEditingPolicy(n, JKEditingPolicy.READ_ONLY);
    }

    public JKEditingPolicy getColumnHeaderEditingPolicy() {
        return (JKEditingPolicy)this.displayPolicy.columnHdrDC.getEditingPolicy();
    }

    public void setColumnHeaderEditingPolicy(JKEditingPolicy jKEditingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingColumnHeaderDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setEditingPolicy(jKEditingPolicy);
        }
    }

    public void setColumnHeaderReadOnly() {
        this.setColumnHeaderEditingPolicy(JKEditingPolicy.READ_ONLY);
    }

    public void setColumnHeaderEditingPolicyDefault(JKEditingPolicy jKEditingPolicy) {
        this.displayPolicy.columnHdrDC.setEditingPolicy(jKEditingPolicy);
    }

    public void setColumnHeaderReadOnlyDefault() {
        this.setColumnHeaderEditingPolicyDefault(JKEditingPolicy.READ_ONLY);
    }

    public JKEditingPolicy getCellAreaEditingPolicy() {
        return (JKEditingPolicy)this.displayPolicy.cellAreaDC.getEditingPolicy();
    }

    public void setCellAreaEditingPolicy(JKEditingPolicy jKEditingPolicy) {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingCellAreaDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            ((JKDrawingContext)oSIEnumeration.nextElement()).setEditingPolicy(jKEditingPolicy);
        }
    }

    public void setCellAreaReadOnly() {
        this.setCellAreaEditingPolicy(JKEditingPolicy.READ_ONLY);
    }

    public void setCellAreaEditingPolicyDefault(JKEditingPolicy jKEditingPolicy) {
        this.displayPolicy.cellAreaDC.setEditingPolicy(jKEditingPolicy);
    }

    public void setCellAreaReadOnlyDefault() {
        this.setCellAreaEditingPolicyDefault(JKEditingPolicy.READ_ONLY);
    }

    public JKEditingPolicy getCellEditingPolicy(int n, int n2) {
        return (JKEditingPolicy)this.displayPolicy.existingCellDrawingContext(n, n2).getEditingPolicy();
    }

    public void setCellEditingPolicy(int n, int n2, JKEditingPolicy jKEditingPolicy) {
        this.displayPolicy.getCellDrawingContext(n, n2).setEditingPolicy(jKEditingPolicy);
    }

    public void setCellReadOnly(int n, int n2) {
        this.setCellEditingPolicy(n, n2, JKEditingPolicy.READ_ONLY);
    }

    public void aboutToScroll(int n, int n2, int n3, int n4) {
    }

    public void scrolled(int n, int n2, int n3, int n4) {
        if (this.editAction != null && this.editAction.editor instanceof Component) {
            this.editAction.moveEditor(n3, n4, this.isCellVisible(this.editAction.dataY, this.editAction.dataX));
        }
    }

    public void rowHeightChanged(int n, int n2, int n3) {
        this.hideEditor(150L);
        super.rowHeightChanged(n, n2, n3);
    }

    public void rowHeightsChanged(OSIIntToIntHashtable oSIIntToIntHashtable, OSIIntToIntHashtable oSIIntToIntHashtable2) {
        this.hideEditor(150L);
        super.rowHeightsChanged(oSIIntToIntHashtable, oSIIntToIntHashtable2);
    }

    public void columnWidthChanged(String string, int n, int n2, int n3) {
        this.hideEditor(150L);
        super.columnWidthChanged(string, n, n2, n3);
    }

    public void columnWidthsChanged(String string, OSIIntToIntHashtable oSIIntToIntHashtable, OSIIntToIntHashtable oSIIntToIntHashtable2) {
        this.hideEditor(150L);
        super.columnWidthsChanged(string, oSIIntToIntHashtable, oSIIntToIntHashtable2);
    }

    public void modelChanged(JKModelChangedEvent jKModelChangedEvent) {
        super.modelChanged(jKModelChangedEvent);
    }

    public void modelRowsChanged(JKModelRowsChangedEvent jKModelRowsChangedEvent) {
        super.modelRowsChanged(jKModelRowsChangedEvent);
    }

    public void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
        this.setEditorArea(this.getEditorArea().insertRows(jKModelRowsAddedEvent.getFirst(), jKModelRowsAddedEvent.getSize()));
        super.modelRowsAdded(jKModelRowsAddedEvent);
    }

    public void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
        this.setEditorArea(this.getEditorArea().removeRows(jKModelRowsRemovedEvent.getFirst(), jKModelRowsRemovedEvent.getSize()));
        super.modelRowsRemoved(jKModelRowsRemovedEvent);
    }

    public void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
        this.setEditorArea(this.getEditorArea().reorderRows(jKModelRowsReorderEvent.getFirst(), jKModelRowsReorderEvent.getReorderMap()));
        super.modelRowsReordered(jKModelRowsReorderEvent);
    }

    public void modelColumnsChanged(JKModelColsChangedEvent jKModelColsChangedEvent) {
        super.modelColumnsChanged(jKModelColsChangedEvent);
    }

    public void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
        this.setEditorArea(this.getEditorArea().insertColumns(jKModelColsAddedEvent.getFirst(), jKModelColsAddedEvent.getSize()));
        super.modelColumnsAdded(jKModelColsAddedEvent);
    }

    public void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
        this.setEditorArea(this.getEditorArea().removeColumns(jKModelColsRemovedEvent.getFirst(), jKModelColsRemovedEvent.getSize()));
        super.modelColumnsRemoved(jKModelColsRemovedEvent);
    }

    public void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
        this.setEditorArea(this.getEditorArea().reorderColumns(jKModelColsReorderEvent.getFirst(), jKModelColsReorderEvent.getReorderMap()));
        super.modelColumnsReordered(jKModelColsReorderEvent);
    }

    protected JKTableArea editorArea() {
        return this.getEditorArea();
    }

    protected JKTableArea getEditorArea() {
        if (this.editAction == null) {
            return JKTableArea.empty;
        }
        return JKTableArea.newForCell(this.editAction.dataX, this.editAction.dataY);
    }

    protected void updateEditor(JKTableArea jKTableArea) {
        this.setEditorArea(jKTableArea);
    }

    protected void setEditorArea(JKTableArea jKTableArea) {
        if (this.editAction == null) {
            return;
        }
        if (jKTableArea instanceof JKRectangularArea) {
            this.hideEditor(150L);
            this.editAction.dataX = ((JKRectangularArea)jKTableArea).x;
            this.editAction.dataY = ((JKRectangularArea)jKTableArea).y;
            return;
        }
        this.basicCloseEditor();
    }

    public void addNotify() {
        OSIEnumeration oSIEnumeration = this.displayPolicy.existingDrawingContexts();
        while (oSIEnumeration.hasMoreElements()) {
            JKDrawingContext jKDrawingContext = (JKDrawingContext)oSIEnumeration.nextElement();
            JKEditingPolicy jKEditingPolicy = (JKEditingPolicy)jKDrawingContext.getEditingPolicy();
            if (jKEditingPolicy == null) continue;
            jKEditingPolicy.cacheEditor(this);
        }
        super.addNotify();
    }

    public synchronized void reshape(int n, int n2, int n3, int n4) {
        this.hideEditor(150L);
        super.reshape(n, n2, n3, n4);
    }

    public void addEditListener(JKEditListener jKEditListener) {
        this.editListener = JKEditMulticaster.add(this.editListener, jKEditListener);
    }

    public void removeEditListener(JKEditListener jKEditListener) {
        this.editListener = JKEditMulticaster.remove(this.editListener, jKEditListener);
    }

    public void addJKEditListener(JKEditListener jKEditListener) {
        this.editListener = JKEditMulticaster.add(this.editListener, jKEditListener);
    }

    public void removeJKEditListener(JKEditListener jKEditListener) {
        this.editListener = JKEditMulticaster.remove(this.editListener, jKEditListener);
    }

    public void triggerAboutToEdit(JKEditAction jKEditAction) throws JKVetoEditException {
        if (this.editListener != null) {
            this.editListener.jkAboutToEdit(new JKEditEvent(this, jKEditAction));
        }
        if (jKEditAction.editor == null) {
            throw new JKVetoEditException();
        }
    }

    public void triggerEditing(JKEditAction jKEditAction) {
        if (this.editListener != null) {
            this.editListener.jkEditing(new JKEditEvent(this, jKEditAction));
        }
    }

    public void triggerValidateEdit(JKEditAction jKEditAction) throws JKVetoEditException {
        if (this.editListener != null) {
            this.editListener.jkValidateEdit(new JKEditEvent(this, jKEditAction));
        }
    }

    public void triggerEdited(JKEditAction jKEditAction) {
        if (this.editListener != null) {
            this.editListener.jkEdited(new JKEditEvent(this, jKEditAction));
        }
    }

    static {
        JKAbstractDrawingContext.defaultEditingPolicy = JKEditingPolicy.READ_ONLY;
        Object[] objectArray = new Object[]{Boolean.TRUE, Boolean.FALSE};
        JKCheckboxEditingPolicy jKCheckboxEditingPolicy = new JKCheckboxEditingPolicy(objectArray);
        jKCheckboxEditingPolicy.showEditorOnMouseDown = true;
        JKDrawingContext.getTemplate("checkbox").setEditingPolicy(jKCheckboxEditingPolicy);
        objectArray = new Object[]{Boolean.TRUE, Boolean.FALSE, null};
        jKCheckboxEditingPolicy = new JKCheckboxEditingPolicy(objectArray);
        jKCheckboxEditingPolicy.showEditorOnMouseDown = true;
        JKDrawingContext.getTemplate("triStateCheckbox").setEditingPolicy(jKCheckboxEditingPolicy);
    }
}

