/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.example.howto.choice;

import com.objectshare.grid.edit.JKChoiceEditingPolicy;
import com.objectshare.grid.edit.JKEditEvent;
import com.objectshare.grid.edit.JKEditListener;
import com.objectshare.grid.edit.JKEditingPolicy;
import com.objectshare.grid.edit.JKTableEdit;
import com.objectshare.grid.edit.JKVetoEditException;
import com.objectshare.grid.example.JKExampleFrame;
import com.objectshare.grid.example.howto.JKTableEditHowTo;
import java.awt.Button;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Event;

public class DynamicChoice
extends JKTableEditHowTo
implements JKEditListener {
    public static String[] flowerChoices = new String[]{"Lady's Slipper", "Wine Cup", "Scarlet Sage"};
    public static String[] desserts = new String[]{"ice cream", "cake", "cookies"};
    public static String[] iceCreamTypes = new String[]{"strawberry", "vanilla", "chocolate"};
    public static String[] cakeTypes = new String[]{"angel food", "chocolate", "white"};
    public static String[] cookieTypes = new String[]{"butterscotch", "chocolate", "chocolate chip"};
    public boolean displayDesserts = true;
    Checkbox yellowChoiceCheckBox = new Checkbox("Edit Yellow as Choice");

    public static void main(String[] stringArray) {
        DynamicChoice dynamicChoice = new DynamicChoice();
        new JKExampleFrame(dynamicChoice, "Dynamic Choice", 560, 350);
    }

    protected void initTable() {
        this.table = new JKTableEdit(4, 8);
        this.table.addJKEditListener(this);
        ((Container)((Object)this)).add("Center", (Component)((Object)this.table));
        this.initTableData(this.table);
        int n = 3;
        while (n <= this.table.getModel().getNumberOfRows()) {
            this.table.setRowBackColor(n, Color.yellow);
            ++n;
        }
    }

    protected void setChoice(int n, int n2, String[] stringArray) {
        this.table.setCellEditingPolicy(n2, n, new JKChoiceEditingPolicy(stringArray));
        this.table.data.set(n2, n, stringArray[0]);
    }

    protected void initControls() {
        this.controls.add(new Button("Update 1@1 Choice"));
        this.controls.add(this.yellowChoiceCheckBox);
        super.initControls();
    }

    public boolean action(Event event, Object object) {
        Button button;
        if (event.target instanceof Button && (button = (Button)event.target).getLabel().equals("Update 1@1 Choice")) {
            System.out.println("updating cell 1@1");
            this.table.closeEditor();
            if (this.displayDesserts) {
                this.setChoice(1, 1, desserts);
            } else {
                this.setChoice(1, 1, flowerChoices);
            }
            boolean bl = this.displayDesserts = !this.displayDesserts;
        }
        if (event.target == this.yellowChoiceCheckBox) {
            this.table.closeEditor();
        }
        return super.action(event, object);
    }

    public void jkAboutToEdit(JKEditEvent jKEditEvent) throws JKVetoEditException {
        System.out.println("about to edit");
        if (this.yellowChoiceCheckBox.getState() && jKEditEvent.getRowNumber() >= 3) {
            Object[] objectArray = new String[]{"c1", "c2", "c3"};
            JKEditingPolicy jKEditingPolicy = (JKEditingPolicy)jKEditEvent.getEditAction().getEditingPolicy();
            if (!(jKEditingPolicy instanceof JKChoiceEditingPolicy)) {
                jKEditEvent.getEditAction().setEditingPolicy(new JKChoiceEditingPolicy(objectArray));
            }
            Choice choice = new Choice();
            int n = 0;
            while (n < objectArray.length) {
                choice.addItem((String)objectArray[n]);
                ++n;
            }
            jKEditEvent.getEditAction().editor = choice;
            jKEditEvent.getEditAction().cacheEditor(choice);
        }
    }

    public void jkEditing(JKEditEvent jKEditEvent) {
        System.out.println("editing");
    }

    public void jkValidateEdit(JKEditEvent jKEditEvent) throws JKVetoEditException {
        System.out.println("validating row=" + jKEditEvent.getRowNumber() + " column=" + jKEditEvent.getColumnNumber());
    }

    public void jkEdited(JKEditEvent jKEditEvent) {
        System.out.println("jkEdited event for row=" + jKEditEvent.getRowNumber() + " column=" + jKEditEvent.getColumnNumber());
        if (jKEditEvent.getRowNumber() == 1 && jKEditEvent.getColumnNumber() == 1) {
            String string = (String)jKEditEvent.getNewValue();
            if (string.equals("ice cream")) {
                this.setChoice(2, 1, iceCreamTypes);
                return;
            }
            if (string.equals("cake")) {
                this.setChoice(2, 1, cakeTypes);
                return;
            }
            if (string.equals("cookies")) {
                this.setChoice(2, 1, cookieTypes);
            }
        }
    }
}

