/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.grid.view;

import com.objectshare.grid.data.JKModel;
import com.objectshare.grid.data.JKModelChangedEvent;
import com.objectshare.grid.data.JKModelColsAddedEvent;
import com.objectshare.grid.data.JKModelColsChangedEvent;
import com.objectshare.grid.data.JKModelColsRemovedEvent;
import com.objectshare.grid.data.JKModelColsReorderEvent;
import com.objectshare.grid.data.JKModelRowsAddedEvent;
import com.objectshare.grid.data.JKModelRowsChangedEvent;
import com.objectshare.grid.data.JKModelRowsRemovedEvent;
import com.objectshare.grid.data.JKModelRowsReorderEvent;
import com.objectshare.grid.view.JKDimensionPolicy;
import com.objectshare.grid.view.JKDrawViewEvent;
import com.objectshare.grid.view.JKTableCoordinator;
import com.objectshare.grid.view.JKTableView;
import com.objectshare.grid.view.JKTableViewAdapter;
import com.objectshare.grid.view.OSIScrollbar;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.Enumeration;

public class JKAutoSizePolicy
implements Serializable {
    protected JKTableView owner;
    protected int maxRowsToAutoSize = 32;
    protected int lastRowsToAutoSize = 1;

    public JKAutoSizePolicy(JKTableView jKTableView) {
        this.owner = jKTableView;
    }

    public int getMaxRowsToAutoSize() {
        return this.maxRowsToAutoSize;
    }

    public void setMaxRowsToAutoSize(int n) {
        this.maxRowsToAutoSize = n;
    }

    public int getLastRowsToAutoSize() {
        return this.lastRowsToAutoSize;
    }

    public void setLastRowsToAutoSize(int n) {
        this.lastRowsToAutoSize = n;
    }

    public void autoSize() {
        if (this.maxRowsToAutoSize == 0) {
            return;
        }
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.autoSize(this.owner.getDimensions(), graphics);
            graphics.dispose();
        }
    }

    public void autoSizeRows() {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.autoSizeRows(this.owner.getDimensions(), graphics);
            graphics.dispose();
        }
    }

    public void autoSizeRows(int n, int n2) {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.autoSizeRows(this.owner.getDimensions(), graphics, n, n2);
            graphics.dispose();
        }
    }

    public void autoSizeColumnHeaderCell(int n, int n2) {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.autoSizeColumnHeaderCell(this.owner.getDimensions(), graphics, n, n2);
            graphics.dispose();
        }
    }

    public void autoSizeCell(int n, int n2) {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.autoSizeCell(this.owner.getDimensions(), graphics, n, n2);
            graphics.dispose();
        }
    }

    public void autoSizeLastRowHeaderCell() {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.autoSizeLastRowHeaderCell(this.owner.getDimensions(), graphics);
            graphics.dispose();
        }
    }

    public void flushColumnWidths() {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.flushColumnWidths(this.owner.getDimensions(), graphics, this.owner.getColumnsLockedToLeft(), this.owner.getColumnsLockedToRight());
            graphics.dispose();
        }
    }

    public void flushColumnWidths(String string) {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.flushColumnWidths(this.owner.getDimensions(), graphics, this.owner.getColumnsLockedToLeft(), this.owner.getColumnsLockedToRight(), string);
            graphics.dispose();
        }
    }

    public void flushRowHeaderColumnWidths() {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.flushRowHeaderColumnWidths(this.owner.getDimensions(), graphics);
            graphics.dispose();
        }
    }

    public void flushRowHeaderColumnWidth(int n) {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.flushRowHeaderColumnWidth(this.owner.getDimensions(), graphics, n);
            graphics.dispose();
        }
    }

    public void flushRowFooterColumnWidths() {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.flushRowFooterColumnWidths(this.owner.getDimensions(), graphics);
            graphics.dispose();
        }
    }

    public void flushRowFooterColumnWidth(int n) {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics != null) {
            this.flushRowFooterColumnWidth(this.owner.getDimensions(), graphics, n);
            graphics.dispose();
        }
    }

    public void autoSizeScreenBounds() {
        Rectangle rectangle = this.owner.screenBounds();
        JKTableCoordinator jKTableCoordinator = this.owner.getCoordinator();
        Insets insets = jKTableCoordinator.getBorderPolicy().insets();
        int n = 1;
        int n2 = 1;
        int n3 = rectangle.width - insets.left - insets.right;
        int n4 = rectangle.height - insets.top - insets.bottom;
        JKTableViewAdapter jKTableViewAdapter = jKTableCoordinator.getAdapter(n, n2);
        OSIScrollbar oSIScrollbar = jKTableCoordinator.getHorizontalScrollbar(n);
        OSIScrollbar oSIScrollbar2 = jKTableCoordinator.getVerticalScrollbar(n2);
        int n5 = jKTableViewAdapter.preferredSize().width;
        int n6 = jKTableViewAdapter.preferredSize().height;
        int n7 = oSIScrollbar2 != null ? oSIScrollbar2.preferredSize().width : 0;
        int n8 = oSIScrollbar != null ? oSIScrollbar.preferredSize().height : 0;
        int n9 = 0;
        while (n9 < jKTableCoordinator.getNumberOfAdapterColumns()) {
            if (n9 != n) {
                n3 -= jKTableCoordinator.getVirtualWidth(n9);
            }
            ++n9;
        }
        int n10 = 0;
        while (n10 < jKTableCoordinator.getNumberOfAdapterRows()) {
            if (n10 != n2) {
                n4 -= jKTableCoordinator.getVirtualHeight(n10);
            }
            ++n10;
        }
        if (n5 <= n3 && n6 <= n4) {
            if (oSIScrollbar != null) {
                oSIScrollbar.hide();
            }
            if (oSIScrollbar2 != null) {
                oSIScrollbar2.hide();
            }
        } else if (n5 <= n3 - n7) {
            if (oSIScrollbar != null) {
                oSIScrollbar.hide();
            }
            if (oSIScrollbar2 != null) {
                oSIScrollbar2.reshape(rectangle.x + rectangle.width - n7, rectangle.y, n7, rectangle.height);
                oSIScrollbar2.show();
            }
            n3 -= n7 - 1;
        } else if (n6 <= n4 - n8) {
            if (oSIScrollbar != null) {
                oSIScrollbar.reshape(rectangle.x, rectangle.y + rectangle.height - n8, rectangle.width, n8);
                oSIScrollbar.show();
            }
            if (oSIScrollbar2 != null) {
                oSIScrollbar2.hide();
            }
            n4 -= n8 - 1;
        } else {
            if (oSIScrollbar != null) {
                oSIScrollbar.reshape(rectangle.x, rectangle.y + rectangle.height - n8, rectangle.width - n7, n8);
                oSIScrollbar.show();
            }
            if (oSIScrollbar2 != null) {
                oSIScrollbar2.reshape(rectangle.x + rectangle.width - n7, rectangle.y, n7, rectangle.height - n8);
                oSIScrollbar2.show();
            }
            n3 -= n7 - 1;
            n4 -= n8 - 1;
        }
        jKTableCoordinator.setScreenX(rectangle.x + insets.left);
        jKTableCoordinator.setScreenY(rectangle.y + insets.top);
        int n11 = 0;
        while (n11 < jKTableCoordinator.getNumberOfAdapterColumns()) {
            jKTableCoordinator.setScreenWidth(n11, n11 == n ? n3 : jKTableCoordinator.getVirtualWidth(n11));
            ++n11;
        }
        int n12 = 0;
        while (n12 < jKTableCoordinator.getNumberOfAdapterRows()) {
            jKTableCoordinator.setScreenHeight(n12, n12 == n2 ? n4 : jKTableCoordinator.getVirtualHeight(n12));
            ++n12;
        }
    }

    public boolean checkScrollbarVisibility() {
        int n;
        JKTableCoordinator jKTableCoordinator = this.owner.getCoordinator();
        int n2 = 1;
        int n3 = 1;
        JKTableViewAdapter jKTableViewAdapter = jKTableCoordinator.getAdapter(n2, n3);
        OSIScrollbar oSIScrollbar = jKTableCoordinator.getHorizontalScrollbar(n2);
        OSIScrollbar oSIScrollbar2 = jKTableCoordinator.getVerticalScrollbar(n3);
        int n4 = jKTableViewAdapter.getScreenBounds().width;
        int n5 = jKTableViewAdapter.getScreenBounds().height;
        int n6 = jKTableViewAdapter.preferredSize().width;
        int n7 = jKTableViewAdapter.preferredSize().height;
        int n8 = oSIScrollbar2 != null ? oSIScrollbar2.preferredSize().width : 0;
        int n9 = n = oSIScrollbar != null ? oSIScrollbar.preferredSize().height : 0;
        if (n6 <= n4 && n7 <= n5) {
            if (oSIScrollbar != null && oSIScrollbar.isVisible()) {
                return true;
            }
            if (oSIScrollbar2 != null && oSIScrollbar2.isVisible()) {
                return true;
            }
        } else if (n6 <= n4 - n8) {
            if (oSIScrollbar != null && oSIScrollbar.isVisible()) {
                return true;
            }
            if (oSIScrollbar2 != null && !oSIScrollbar2.isVisible()) {
                return true;
            }
        } else if (n7 <= n5 - n) {
            if (oSIScrollbar != null && !oSIScrollbar.isVisible()) {
                return true;
            }
            if (oSIScrollbar2 != null && oSIScrollbar2.isVisible()) {
                return true;
            }
        } else {
            if (oSIScrollbar != null && !oSIScrollbar.isVisible()) {
                return true;
            }
            if (oSIScrollbar2 != null && !oSIScrollbar2.isVisible()) {
                return true;
            }
        }
        return false;
    }

    public Dimension getPreferredCellSize(int n, int n2) {
        Graphics graphics = ((Component)((Object)this.owner)).getGraphics();
        if (graphics == null) {
            throw new Error("getGraphics() returned null");
        }
        Dimension dimension = this.getPreferredCellSize(graphics, n, n2);
        graphics.dispose();
        return dimension;
    }

    public void autoSize(JKDimensionPolicy jKDimensionPolicy, Graphics graphics) {
        if (this.maxRowsToAutoSize == 0) {
            return;
        }
        int n = this.owner.getColumnsLockedToLeft();
        int n2 = this.owner.getColumnsLockedToRight();
        this.autoSizeRows(jKDimensionPolicy, graphics);
        this.flushRowHeaderColumnWidths(jKDimensionPolicy, graphics);
        this.flushRowFooterColumnWidths(jKDimensionPolicy, graphics);
        this.autoSizeScreenBounds();
        this.flushColumnWidths(jKDimensionPolicy, graphics, n, n2);
        graphics.dispose();
    }

    protected void autoSizeRows(JKDimensionPolicy jKDimensionPolicy, Graphics graphics) {
        int n;
        if (this.maxRowsToAutoSize == 0 && this.lastRowsToAutoSize == 0) {
            return;
        }
        JKDimensionPolicy jKDimensionPolicy2 = jKDimensionPolicy.copyForAutoSize();
        int n2 = this.owner.getCoordinator().getFirstRowNumber();
        int n3 = n2 + this.owner.getCoordinator().getNumberOfRows();
        int n4 = n3;
        if (n4 > this.maxRowsToAutoSize && this.maxRowsToAutoSize != -1) {
            n4 = this.maxRowsToAutoSize + 1;
        }
        if ((n = n3 - this.lastRowsToAutoSize) < n4) {
            n = n4;
        }
        this.autoSizeRows(jKDimensionPolicy2, graphics, n2, n4 - n2);
        this.autoSizeRows(jKDimensionPolicy2, graphics, n, n3 - n);
        if (n3 > 0) {
            this.autoSizeLastRowHeaderCell(jKDimensionPolicy2, graphics);
        }
        if (jKDimensionPolicy2.getDefaultHeight() == 0) {
            jKDimensionPolicy2.setDefaultHeight(16);
        }
        if (jKDimensionPolicy2.getHeight(0) == 0) {
            jKDimensionPolicy2.setHeightToDefault(16);
        }
        jKDimensionPolicy.copyFromAutoSize(jKDimensionPolicy2);
    }

    protected void autoSizeRows(JKDimensionPolicy jKDimensionPolicy, Graphics graphics, int n, int n2) {
        int n3 = n + n2;
        int n4 = n;
        while (n4 < n3) {
            int n5 = this.owner.getCoordinator().getFirstColumnNumber(n4);
            int n6 = n5 + this.owner.getCoordinator().getNumberOfColumns(n4);
            int n7 = n5;
            while (n7 <= n6) {
                if (n4 < 1) {
                    this.autoSizeColumnHeaderCell(jKDimensionPolicy, graphics, n4, n7);
                } else {
                    this.autoSizeCell(jKDimensionPolicy, graphics, n4, n7);
                }
                ++n7;
            }
            ++n4;
        }
    }

    protected void autoSizeColumnHeaderCell(JKDimensionPolicy jKDimensionPolicy, Graphics graphics, int n, int n2) {
        Dimension dimension = this.getPreferredCellSize(graphics, n, n2);
        if (jKDimensionPolicy.isRowAutoSizable(n) && jKDimensionPolicy.getHeight(n) < dimension.height) {
            jKDimensionPolicy.setHeight(n, dimension.height);
        }
        if (jKDimensionPolicy.isColumnAutoSizable(n, n2) && jKDimensionPolicy.getWidth(n, n2) < dimension.width) {
            jKDimensionPolicy.setWidth(n, n2, dimension.width);
        }
    }

    protected void autoSizeCell(JKDimensionPolicy jKDimensionPolicy, Graphics graphics, int n, int n2) {
        Dimension dimension = this.getPreferredCellSize(graphics, n, n2);
        if (jKDimensionPolicy.areRowsAutoSizableByDefault() && jKDimensionPolicy.getDefaultHeight() < dimension.height) {
            jKDimensionPolicy.setDefaultHeight(dimension.height);
        }
        if (jKDimensionPolicy.isColumnAutoSizable(n, n2) && jKDimensionPolicy.getWidth(n, n2) < dimension.width) {
            jKDimensionPolicy.setWidth(n, n2, dimension.width);
        }
    }

    protected void autoSizeLastRowHeaderCell(JKDimensionPolicy jKDimensionPolicy, Graphics graphics) {
        int n = this.owner.getModel().getNumberOfRows();
        int n2 = 0;
        Dimension dimension = this.getPreferredCellSize(graphics, n, n2, new Integer(n));
        if (jKDimensionPolicy.getDefaultHeight() < dimension.height) {
            jKDimensionPolicy.setDefaultHeight(dimension.height);
        }
        if (jKDimensionPolicy.getWidth(n, n2) < dimension.width) {
            jKDimensionPolicy.setWidth(n, n2, dimension.width);
        }
    }

    protected Dimension getPreferredCellSize(Graphics graphics, int n, int n2) {
        return new JKDrawViewEvent(this.owner, graphics, n, n2).preferredSize();
    }

    protected Dimension getPreferredCellSize(Graphics graphics, int n, int n2, Object object) {
        return new JKDrawViewEvent(this.owner, graphics, n, n2).preferredSize(object);
    }

    protected void flushColumnWidths(JKDimensionPolicy jKDimensionPolicy, Graphics graphics, int n, int n2) {
        Enumeration enumeration = this.owner.getModel().getRowTypes();
        while (enumeration.hasMoreElements()) {
            this.flushColumnWidths(jKDimensionPolicy, graphics, n, n2, (String)enumeration.nextElement());
        }
    }

    protected void flushColumnWidths(JKDimensionPolicy jKDimensionPolicy, Graphics graphics, int n, int n2, String string) {
        int n3;
        int n4;
        int n5;
        int n6;
        JKTableViewAdapter jKTableViewAdapter = this.owner.getCoordinator().getCellAdapter();
        int n7 = jKTableViewAdapter.getScreenContentBounds().width;
        if (n7 < 1) {
            return;
        }
        if (jKTableViewAdapter.getBorderPolicy().insets().right > 0) {
            ++n7;
        }
        if ((n6 = n7 - jKDimensionPolicy.getTotalWidth(string, n5 = 1 + n, n4 = (n3 = this.owner.getModel().getNumberOfColumns(string) - n2) - n5 + 1)) > 0) {
            int n8 = n5;
            while (n8 <= n3) {
                if (!jKDimensionPolicy.isColumnAutoSizable(string, n8)) {
                    --n4;
                }
                ++n8;
            }
            int n9 = n5;
            while (n9 <= n3) {
                if (jKDimensionPolicy.isColumnAutoSizable(string, n9)) {
                    jKDimensionPolicy.setWidth(string, n9, jKDimensionPolicy.getWidth(n9) + n6 / n4);
                    n6 -= n6 / n4;
                    --n4;
                }
                ++n9;
            }
        }
    }

    protected void flushRowHeaderColumnWidths(JKDimensionPolicy jKDimensionPolicy, Graphics graphics) {
        JKTableViewAdapter jKTableViewAdapter = this.owner.getCoordinator().getCellAdapter();
        int n = this.owner.getCoordinator().getFirstColumnNumber();
        int n2 = jKTableViewAdapter.getFirstColumnNumber();
        if (n > 0) {
            n = 0;
        }
        int n3 = n;
        while (n3 < n2) {
            this.flushRowHeaderColumnWidth(jKDimensionPolicy, graphics, n3);
            ++n3;
        }
    }

    protected void flushRowHeaderColumnWidth(JKDimensionPolicy jKDimensionPolicy, Graphics graphics, int n) {
        int n2 = 0;
        Enumeration enumeration = this.owner.getModel().getRowTypes();
        while (enumeration.hasMoreElements()) {
            int n3 = jKDimensionPolicy.getWidth((String)enumeration.nextElement(), n);
            if (n2 >= n3) continue;
            n2 = n3;
        }
        enumeration = this.owner.getModel().getRowTypes();
        while (enumeration.hasMoreElements()) {
            jKDimensionPolicy.setWidth((String)enumeration.nextElement(), n, n2);
        }
    }

    protected void flushRowFooterColumnWidths(JKDimensionPolicy jKDimensionPolicy, Graphics graphics) {
        if (this.owner.getCoordinator().getNumberOfAdapterColumns() < 3) {
            return;
        }
        JKTableViewAdapter jKTableViewAdapter = this.owner.getCoordinator().getAdapter(2, 1);
        int n = 1;
        int n2 = jKTableViewAdapter.getNumberOfColumns() + 1;
        int n3 = n;
        while (n3 < n2) {
            this.flushRowFooterColumnWidth(jKDimensionPolicy, graphics, n3);
            ++n3;
        }
    }

    protected void flushRowFooterColumnWidth(JKDimensionPolicy jKDimensionPolicy, Graphics graphics, int n) {
        int n2;
        String string;
        int n3 = 0;
        Enumeration enumeration = this.owner.getModel().getRowTypes();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            int n4 = jKDimensionPolicy.getWidth(string, n2 = this.owner.getModel().getNumberOfColumns(string) + n);
            if (n3 >= n4) continue;
            n3 = n4;
        }
        enumeration = this.owner.getModel().getRowTypes();
        while (enumeration.hasMoreElements()) {
            string = (String)enumeration.nextElement();
            n2 = this.owner.getModel().getNumberOfColumns(string) + n;
            jKDimensionPolicy.setWidth(string, n2, n3);
        }
    }

    public void updateModel(JKModel jKModel) {
        this.autoSize();
    }

    public void validated() {
        this.autoSize();
    }

    public void reshaped() {
        this.autoSize();
    }

    public void columnWidthChanged(int n, int n2, int n3) {
        this.columnWidthChanged("java.lang.Object", n, n2, n3);
    }

    public void columnWidthChanged(String string, int n, int n2, int n3) {
        this.autoSize();
        ((Component)((Object)this.owner)).repaint();
    }

    public void columnWidthChanged(int n, int n2, int n3, int n4) {
        this.columnWidthChanged(this.owner.getModel().getRowType(n), n2, n3, n4);
    }

    public void rowHeightChanged(int n, int n2, int n3) {
        this.autoSize();
        ((Component)((Object)this.owner)).repaint();
    }

    public void modelChanged(JKModelChangedEvent jKModelChangedEvent) {
    }

    public void modelRowsChanged(JKModelRowsChangedEvent jKModelRowsChangedEvent) {
    }

    public void modelRowsAdded(JKModelRowsAddedEvent jKModelRowsAddedEvent) {
        if (this.maxRowsToAutoSize == -1 || jKModelRowsAddedEvent.getFirst() <= this.maxRowsToAutoSize || this.checkScrollbarVisibility()) {
            this.autoSize();
        }
    }

    public void modelRowsRemoved(JKModelRowsRemovedEvent jKModelRowsRemovedEvent) {
        if (this.checkScrollbarVisibility()) {
            this.autoSize();
        }
    }

    public void modelRowsReordered(JKModelRowsReorderEvent jKModelRowsReorderEvent) {
    }

    public void modelColumnsChanged(JKModelColsChangedEvent jKModelColsChangedEvent) {
    }

    public void modelColumnsAdded(JKModelColsAddedEvent jKModelColsAddedEvent) {
        this.autoSize();
    }

    public void modelColumnsRemoved(JKModelColsRemovedEvent jKModelColsRemovedEvent) {
        this.autoSize();
    }

    public void modelColumnsReordered(JKModelColsReorderEvent jKModelColsReorderEvent) {
    }
}

