/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.base.event.OSIEventMulticaster;
import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGOContainer;
import com.objectshare.gf.base.GFGraphicObject;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.go.event.GF2DGOEvent;
import com.objectshare.gf.go.event.GF2DGOEventMulticaster;
import com.objectshare.gf.go.event.GF2DGOLocationListener;
import com.objectshare.gf.go.event.GF2DGOReshapingEvent;
import com.objectshare.gf.go.event.GF2DGORotatingEvent;
import com.objectshare.gf.go.event.GF2DGOTranslatingEvent;
import com.objectshare.gf.tool.GF2DReshapeHandle;
import com.objectshare.gf.tool.GF2DXlateHandle;
import com.objectshare.gf.tool.GFConnectionHandle;
import java.io.IOException;
import java.io.ObjectOutputStream;
import java.util.EventListener;

public abstract class GF2DGraphicObject
extends GFGraphicObject
implements GF2DGO {
    public GF2DGO nextGO;
    public GF2DGO prevGO;
    public float zOrderIndex;
    protected transient GF2DGOLocationListener locationListener;
    protected static final String locationListenerK = "locationL";

    public boolean isFirst() {
        GFGOContainer gFGOContainer = this.getContainer();
        if (gFGOContainer != null) {
            return gFGOContainer.firstGO() == this;
        }
        return true;
    }

    public boolean isLast() {
        GFGOContainer gFGOContainer = this.getContainer();
        if (gFGOContainer != null) {
            return gFGOContainer.lastGO() == this;
        }
        return true;
    }

    public void bringToFront() {
        GFGOContainer gFGOContainer = this.getContainer();
        if (gFGOContainer != null) {
            gFGOContainer.bringToFront(this);
        }
    }

    public void sendToBack() {
        GFGOContainer gFGOContainer = this.getContainer();
        if (gFGOContainer != null) {
            gFGOContainer.sendToBack(this);
        }
    }

    public GF2DGO getNextGO() {
        return this.nextGO;
    }

    public void basicSetNextGO(GF2DGO gF2DGO) {
        this.nextGO = gF2DGO;
    }

    public GF2DGO getPrevGO() {
        return this.prevGO;
    }

    public void basicSetPrevGO(GF2DGO gF2DGO) {
        this.prevGO = gF2DGO;
    }

    public float getZOrderIndex() {
        return this.zOrderIndex;
    }

    public void basicSetZOrderIndex(float f) {
        this.zOrderIndex = f;
    }

    public boolean basicReshape(float f, float f2, float f3, float f4) {
        return false;
    }

    public boolean basicTranslate(float f, float f2) {
        return false;
    }

    public boolean basicRotate(float f, GF2DPoint gF2DPoint) {
        return false;
    }

    public GF2DPoint creationOrigin() {
        return this.displayCenter();
    }

    public void reshape(float f, float f2, float f3, float f4) {
        GF2DRectangle gF2DRectangle = new GF2DRectangle(f, f2, f3, f4);
        GF2DGOReshapingEvent gF2DGOReshapingEvent = this.triggerAboutToReshapeEvent(gF2DRectangle);
        if (gF2DGOReshapingEvent.isVetoed()) {
            return;
        }
        gF2DRectangle = gF2DGOReshapingEvent.getBoundingBox();
        this.beginDamage();
        boolean bl = this.basicReshape(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
        this.endDamage();
        if (bl) {
            this.triggerReshapedEvent();
        }
    }

    public void reshape(GF2DRectangle gF2DRectangle) {
        this.reshape(gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height);
    }

    public void translate(float f, float f2) {
        GF2DGOTranslatingEvent gF2DGOTranslatingEvent = this.triggerAboutToTranslateEvent(f, f2);
        if (gF2DGOTranslatingEvent.isVetoed()) {
            return;
        }
        this.beginDamage();
        boolean bl = this.basicTranslate(gF2DGOTranslatingEvent.getXTranslation(), gF2DGOTranslatingEvent.getYTranslation());
        this.endDamage();
        if (bl) {
            this.triggerTranslatedEvent();
        }
    }

    public void translate(GF2DPoint gF2DPoint) {
        this.translate(gF2DPoint.x, gF2DPoint.y);
    }

    public void translateCenter(float f, float f2) {
        GF2DPoint gF2DPoint = this.displayCenter();
        this.translate(f - gF2DPoint.x, f2 - gF2DPoint.y);
    }

    public void translateCenter(GF2DPoint gF2DPoint) {
        this.translateCenter(gF2DPoint.x, gF2DPoint.y);
    }

    public void translateLeftBottom(float f, float f2) {
        GF2DPoint gF2DPoint = this.displayLeftBottom();
        this.translate(f - gF2DPoint.x, f2 - gF2DPoint.y);
    }

    public void translateLeftBottom(GF2DPoint gF2DPoint) {
        this.translateLeftBottom(gF2DPoint.x, gF2DPoint.y);
    }

    public void translateLeftTop(float f, float f2) {
        GF2DPoint gF2DPoint = this.displayLeftTop();
        this.translate(f - gF2DPoint.x, f2 - gF2DPoint.y);
    }

    public void translateLeftTop(GF2DPoint gF2DPoint) {
        this.translateLeftTop(gF2DPoint.x, gF2DPoint.y);
    }

    public void translateRightBottom(float f, float f2) {
        GF2DPoint gF2DPoint = this.displayRightBottom();
        this.translate(f - gF2DPoint.x, f2 - gF2DPoint.y);
    }

    public void translateRightBottom(GF2DPoint gF2DPoint) {
        this.translateRightBottom(gF2DPoint.x, gF2DPoint.y);
    }

    public void translateRightTop(float f, float f2) {
        GF2DPoint gF2DPoint = this.displayRightTop();
        this.translate(f - gF2DPoint.x, f2 - gF2DPoint.y);
    }

    public void translateRightTop(GF2DPoint gF2DPoint) {
        this.translateRightTop(gF2DPoint.x, gF2DPoint.y);
    }

    public GF2DPoint translationOrigin() {
        return this.displayLeftTop();
    }

    public void rotate(float f, GF2DPoint gF2DPoint) {
        GF2DGORotatingEvent gF2DGORotatingEvent = this.triggerAboutToRotateEvent(f, gF2DPoint);
        if (gF2DGORotatingEvent.isVetoed()) {
            return;
        }
        this.beginDamage();
        boolean bl = this.basicRotate(gF2DGORotatingEvent.getRotation(), gF2DGORotatingEvent.getRotationAxis());
        this.endDamage();
        if (bl) {
            this.triggerRotatedEvent();
        }
    }

    public void rotate(float f, float f2, float f3) {
        this.rotate(f, new GF2DPoint(f2, f3));
    }

    public void displayShapeCenteredAt(GFGraphics gFGraphics, GF2DPoint gF2DPoint) {
        GF2DPoint gF2DPoint2 = gF2DPoint.subtract(this.displayCenter());
        this.basicTranslate(gF2DPoint2.x, gF2DPoint2.y);
        this.displayShape(gFGraphics);
        this.basicTranslate(-gF2DPoint2.x, -gF2DPoint2.y);
    }

    public void displayCenteredAt(GFGraphics gFGraphics, GF2DPoint gF2DPoint) {
        GF2DPoint gF2DPoint2 = gF2DPoint.subtract(this.displayCenter());
        this.basicTranslate(gF2DPoint2.x, gF2DPoint2.y);
        this.display(gFGraphics);
        this.basicTranslate(-gF2DPoint2.x, -gF2DPoint2.y);
    }

    public GFGOArray defaultHandles() {
        return this.defaultReshapeHandles();
    }

    public GFGOArray defaultReshapeHandles() {
        return GF2DReshapeHandle.allCornersOf(this);
    }

    public GFHandle defaultPositionHandle() {
        return GF2DXlateHandle.centerOf(this);
    }

    public GFGOArray defaultConnectionHandles() {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray();
        gFUnsortedGOArray.add(GFConnectionHandle.centerOf(this));
        return gFUnsortedGOArray;
    }

    public void addLocationListener(GF2DGOLocationListener gF2DGOLocationListener) {
        this.locationListener = GF2DGOEventMulticaster.add(this.locationListener, gF2DGOLocationListener);
    }

    public void removeLocationListener(GF2DGOLocationListener gF2DGOLocationListener) {
        this.locationListener = GF2DGOEventMulticaster.remove(this.locationListener, gF2DGOLocationListener);
    }

    protected GF2DGOReshapingEvent triggerAboutToReshapeEvent(GF2DRectangle gF2DRectangle) {
        GF2DGOReshapingEvent gF2DGOReshapingEvent = new GF2DGOReshapingEvent(this, gF2DRectangle);
        GF2DGOLocationListener gF2DGOLocationListener = this.locationListener;
        if (gF2DGOLocationListener != null) {
            gF2DGOLocationListener.aboutToReshapeGO(gF2DGOReshapingEvent);
        }
        return gF2DGOReshapingEvent;
    }

    protected void triggerReshapedEvent() {
        GF2DGOLocationListener gF2DGOLocationListener = this.locationListener;
        if (gF2DGOLocationListener != null) {
            gF2DGOLocationListener.goReshaped(new GF2DGOEvent(this));
        }
    }

    protected GF2DGOTranslatingEvent triggerAboutToTranslateEvent(float f, float f2) {
        GF2DGOTranslatingEvent gF2DGOTranslatingEvent = new GF2DGOTranslatingEvent(this, f, f2);
        GF2DGOLocationListener gF2DGOLocationListener = this.locationListener;
        if (gF2DGOLocationListener != null) {
            gF2DGOLocationListener.aboutToTranslateGO(gF2DGOTranslatingEvent);
        }
        return gF2DGOTranslatingEvent;
    }

    protected void triggerTranslatedEvent() {
        GF2DGOLocationListener gF2DGOLocationListener = this.locationListener;
        if (gF2DGOLocationListener != null) {
            gF2DGOLocationListener.goTranslated(new GF2DGOEvent(this));
        }
    }

    protected GF2DGORotatingEvent triggerAboutToRotateEvent(float f, GF2DPoint gF2DPoint) {
        GF2DGORotatingEvent gF2DGORotatingEvent = new GF2DGORotatingEvent(this, f, gF2DPoint);
        GF2DGOLocationListener gF2DGOLocationListener = this.locationListener;
        if (gF2DGOLocationListener != null) {
            gF2DGOLocationListener.aboutToRotateGO(gF2DGORotatingEvent);
        }
        return gF2DGORotatingEvent;
    }

    protected void triggerRotatedEvent() {
        GF2DGOLocationListener gF2DGOLocationListener = this.locationListener;
        if (gF2DGOLocationListener != null) {
            gF2DGOLocationListener.goRotated(new GF2DGOEvent(this));
        }
    }

    protected void writeEventListeners(ObjectOutputStream objectOutputStream) throws IOException {
        super.writeEventListeners(objectOutputStream);
        OSIEventMulticaster.save((ObjectOutputStream)objectOutputStream, (String)locationListenerK, (EventListener)this.locationListener);
    }

    protected boolean registerEventListener(String string, Object object) throws IOException {
        if (super.registerEventListener(string, object)) {
            return true;
        }
        if (string == locationListenerK) {
            this.addLocationListener((GF2DGOLocationListener)object);
            return true;
        }
        return false;
    }
}

