/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.base;

import com.objectshare.base.draw.OSIGraphicsDisplaySystem;
import com.objectshare.gf.base.GF2DGO;
import com.objectshare.gf.base.GF2DWorldViewTransform;
import com.objectshare.gf.base.GFCompositeGO;
import com.objectshare.gf.base.GFDrawing;
import com.objectshare.gf.base.GFDrawingCanvas;
import com.objectshare.gf.base.GFDrawingLayer;
import com.objectshare.gf.base.GFEventModel;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGOArray;
import com.objectshare.gf.base.GFGOContainer;
import com.objectshare.gf.base.GFGOParent;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.GFHandleLayer;
import com.objectshare.gf.base.GFScaledWorldViewPolicy;
import com.objectshare.gf.base.GFSortedGOArray;
import com.objectshare.gf.base.GFUnsortedGOArray;
import com.objectshare.gf.base.GFWorldViewPortPolicy;
import com.objectshare.gf.base.event.GFDrawingEvent;
import com.objectshare.gf.base.event.GFDrawingEventMulticaster;
import com.objectshare.gf.base.event.GFDrawingKeyEvent;
import com.objectshare.gf.base.event.GFDrawingMouseEvent;
import com.objectshare.gf.base.event.GFDrawingXFormListener;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.tool.GFRubberSelectionTool;
import com.objectshare.gf.tool.GFSelectionTool;
import com.objectshare.gf.tool.GFTool;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;

public class GFDrawingManager
extends GFEventModel
implements GFGOContainer,
Serializable {
    protected GFDrawingLayer activeLayer;
    protected GFDrawingCanvas canvas;
    protected GFDrawing drawing;
    protected GFUnsortedGOArray selections;
    protected GFHandleLayer handles;
    public boolean debug = false;
    protected GF2DWorldViewTransform worldViewXform;
    protected GFWorldViewPortPolicy worldViewPortPolicy;
    protected GFTool activeTool;
    protected Cursor cursor = Cursor.getPredefinedCursor(0);
    protected transient GFDrawingXFormListener transformListener;

    protected static GFDrawing defaultDrawing() {
        return new GFDrawing();
    }

    public GFDrawingManager() {
        this(GFDrawingManager.defaultDrawing());
    }

    public GFDrawingManager(GFDrawing gFDrawing) {
        this.selections = new GFUnsortedGOArray();
        this.basicSetDrawing(gFDrawing);
        this.setTool(new GFSelectionTool().setSubTool(new GFRubberSelectionTool()));
        this.worldViewXform = new GF2DWorldViewTransform();
        this.setWorldViewPortPolicy(this.defaultWorldViewPortPolicy());
    }

    public GFDrawing getDrawing() {
        return this.drawing;
    }

    protected boolean basicSetDrawing(GFDrawing gFDrawing) {
        if (this.drawing == gFDrawing) {
            return false;
        }
        this.releaseDrawing();
        this.drawing = gFDrawing;
        this.drawing.basicSetParent(this);
        this.setActiveLayer(this.drawing.getPrimaryLayer());
        this.handles = gFDrawing.getHandleLayer();
        return true;
    }

    public void setDrawing(GFDrawing gFDrawing) {
        if (this.basicSetDrawing(gFDrawing)) {
            this.damageViewPort();
        }
    }

    public void releaseDrawing() {
        if (this.drawing == null) {
            return;
        }
        this.unselectAll();
        this.drawing.basicSetParent(null);
        this.setActiveLayer(null);
        this.drawing = null;
        this.handles = null;
    }

    public void basicSetManager(GFDrawingManager gFDrawingManager) {
    }

    public void basicSetAllManagerAttributes(GFDrawingManager gFDrawingManager) {
    }

    public GFDrawingManager getManager() {
        return this;
    }

    public GFDrawingLayer getActiveLayer() {
        return this.activeLayer;
    }

    public void setActiveLayer(GFDrawingLayer gFDrawingLayer) {
        this.activeLayer = gFDrawingLayer;
    }

    public GFGOArray getContents() {
        return this.getActiveLayer().getContents();
    }

    public Enumeration contentElements() {
        return this.getActiveLayer().contentElements();
    }

    public boolean includes(GFGO gFGO) {
        return gFGO.getManager() == this;
    }

    public boolean isContainerFor(GFGO gFGO) {
        return gFGO.getContainer() == this;
    }

    public GF2DGO firstGO() {
        return this.getActiveLayer().firstGO();
    }

    public GF2DGO lastGO() {
        return this.getActiveLayer().lastGO();
    }

    public void add(GFGO gFGO) {
        this.addLast(gFGO);
    }

    public void addAll(GFGOArray gFGOArray) {
        this.addAllLast(gFGOArray);
    }

    public void addAll(Vector vector) {
        this.addAllLast(vector);
    }

    public void addAll(Object[] objectArray) {
        this.addAllLast(objectArray);
    }

    public void addAll(Object[] objectArray, int n) {
        this.addAllLast(objectArray, n);
    }

    public void addFirst(GFGO gFGO) {
        gFGO.getLayerFor(this).addFirst(gFGO);
    }

    public void addAllFirst(GFGOArray gFGOArray) {
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n = gFGOArray.size() - 1;
        while (n >= 0) {
            this.addFirst(gFGOArray2[n]);
            --n;
        }
    }

    public void addAllFirst(Vector vector) {
        int n = vector.size() - 1;
        while (n >= 0) {
            Object e = vector.elementAt(n);
            if (e instanceof GFGO) {
                this.addFirst((GFGO)e);
            }
            --n;
        }
    }

    public void addAllFirst(Object[] objectArray) {
        this.addAllFirst(objectArray, objectArray.length);
    }

    public void addAllFirst(Object[] objectArray, int n) {
        int n2 = n - 1;
        while (n2 >= 0) {
            Object object = objectArray[n2];
            if (object instanceof GFGO) {
                this.addFirst((GFGO)object);
            }
            --n2;
        }
    }

    public void addLast(GFGO gFGO) {
        gFGO.getLayerFor(this).addLast(gFGO);
    }

    public void addAllLast(GFGOArray gFGOArray) {
        int n = gFGOArray.size();
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n2 = 0;
        while (n2 < n) {
            this.addLast(gFGOArray2[n2]);
            ++n2;
        }
    }

    public void addAllLast(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof GFGO) {
                this.addLast((GFGO)e);
            }
            ++n;
        }
    }

    public void addAllLast(Object[] objectArray) {
        this.addAllLast(objectArray, objectArray.length);
    }

    public void addAllLast(Object[] objectArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof GFGO) {
                this.addLast((GFGO)object);
            }
            ++n2;
        }
    }

    public void addBefore(GFGO gFGO, GFGO gFGO2) {
        gFGO.getLayerFor(this).addBefore(gFGO, gFGO2);
    }

    public void addAfter(GFGO gFGO, GFGO gFGO2) {
        gFGO.getLayerFor(this).addAfter(gFGO, gFGO2);
    }

    public boolean basicRemove(GFGO gFGO) {
        GFGOParent gFGOParent = gFGO.getParent();
        if (gFGOParent == null || gFGO.getManager() != this) {
            return false;
        }
        if (gFGOParent == this) {
            return false;
        }
        return gFGOParent.basicRemove(gFGO);
    }

    public boolean remove(GFGO gFGO) {
        GFGOContainer gFGOContainer = gFGO.getContainer();
        if (gFGOContainer == null || gFGO.getManager() != this) {
            return false;
        }
        if (gFGOContainer == this) {
            return false;
        }
        return gFGOContainer.remove(gFGO);
    }

    public void removeAll() {
        this.removeAll(this.getContents());
    }

    public void removeAll(GFGOArray gFGOArray) {
        int n = gFGOArray.size();
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n2 = 0;
        while (n2 < n) {
            this.remove(gFGOArray2[n2]);
            ++n2;
        }
    }

    public void removeAll(Vector vector) {
        int n = 0;
        while (n < vector.size()) {
            Object e = vector.elementAt(n);
            if (e instanceof GFGO) {
                this.remove((GFGO)e);
            }
            ++n;
        }
    }

    public void removeAll(Object[] objectArray) {
        this.removeAll(objectArray, objectArray.length);
    }

    public void removeAll(Object[] objectArray, int n) {
        int n2 = 0;
        while (n2 < n) {
            Object object = objectArray[n2];
            if (object instanceof GFGO) {
                this.remove((GFGO)object);
            }
            ++n2;
        }
    }

    public void bringToFront(GF2DGO gF2DGO) {
        gF2DGO.bringToFront();
    }

    public void sendToBack(GF2DGO gF2DGO) {
        gF2DGO.sendToBack();
    }

    public GFGO graphicObjectContaining(GF2DPoint gF2DPoint) {
        return this.getActiveLayer().graphicObjectContaining(gF2DPoint);
    }

    public GFGOArray graphicObjectsContaining(GF2DPoint gF2DPoint) {
        return this.getActiveLayer().graphicObjectsContaining(gF2DPoint);
    }

    public GFGOArray graphicObjectsIntersecting(GF2DRectangle gF2DRectangle) {
        return this.getActiveLayer().graphicObjectsIntersecting(gF2DRectangle);
    }

    public GFGOArray graphicObjectsContainedBy(GF2DRectangle gF2DRectangle) {
        return this.getActiveLayer().graphicObjectsContainedBy(gF2DRectangle);
    }

    public GFDrawingCanvas getCanvas() {
        return this.canvas;
    }

    public void setCanvas(GFDrawingCanvas gFDrawingCanvas) {
        if (this.canvas == gFDrawingCanvas) {
            return;
        }
        this.releaseCanvas();
        this.canvas = gFDrawingCanvas;
        this.canvas.basicSetManager(this);
        this.canvas.setCursor(this.cursor);
    }

    public void releaseCanvas() {
        if (this.canvas != null) {
            this.canvas.basicReleaseManager();
            this.canvas = null;
        }
    }

    public OSIGraphicsDisplaySystem getDisplaySystem() {
        GFDrawingCanvas gFDrawingCanvas = this.getCanvas();
        if (gFDrawingCanvas != null) {
            return gFDrawingCanvas.getDisplaySystem();
        }
        return null;
    }

    public void setDisplaySystem(OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem) {
        GFDrawingCanvas gFDrawingCanvas = this.getCanvas();
        if (gFDrawingCanvas != null) {
            gFDrawingCanvas.setDisplaySystem(oSIGraphicsDisplaySystem);
        }
    }

    public void releaseDisplaySystem() {
        GFDrawingCanvas gFDrawingCanvas = this.getCanvas();
        if (gFDrawingCanvas != null) {
            gFDrawingCanvas.releaseDisplaySystem();
        }
    }

    protected GFWorldViewPortPolicy defaultWorldViewPortPolicy() {
        return new GFScaledWorldViewPolicy();
    }

    public GFWorldViewPortPolicy getWorldViewPortPolicy() {
        return this.worldViewPortPolicy;
    }

    public void setWorldViewPortPolicy(GFWorldViewPortPolicy gFWorldViewPortPolicy) {
        if (this.worldViewPortPolicy != null) {
            this.worldViewPortPolicy.basicSetManager(null);
        }
        this.worldViewPortPolicy = gFWorldViewPortPolicy;
        this.worldViewPortPolicy.basicSetManager(this);
    }

    public GF2DWorldViewTransform getWorldViewTransform() {
        return this.worldViewXform;
    }

    protected void basicSetViewPort(Rectangle rectangle) {
        this.getWorldViewTransform().setViewPort(rectangle);
        this.triggerTransformChangedEvent();
    }

    public Rectangle getViewPort() {
        return this.getWorldViewTransform().getViewPort();
    }

    protected void basicSetWorldPort(GF2DRectangle gF2DRectangle) {
        this.getWorldViewTransform().setWorldPort(gF2DRectangle);
        this.triggerTransformChangedEvent();
    }

    protected void basicSetWorldPortOrigin(GF2DPoint gF2DPoint) {
        this.getWorldViewTransform().setWorldPortOrigin(gF2DPoint);
        this.triggerTransformChangedEvent();
    }

    protected void basicSetWorldPortCenter(GF2DPoint gF2DPoint) {
        this.getWorldViewTransform().setWorldPortCenter(gF2DPoint);
        this.triggerTransformChangedEvent();
    }

    public GF2DRectangle getWorldPort() {
        return this.getWorldViewTransform().getWorldPort();
    }

    public void setWorldPort(GF2DRectangle gF2DRectangle) {
        this.basicSetWorldPort(gF2DRectangle);
        this.getWorldViewPortPolicy().worldPortResized(gF2DRectangle);
        this.damageViewPort();
    }

    public void setWorldPort(float f, float f2, float f3, float f4) {
        this.setWorldPort(new GF2DRectangle(f, f2, f3, f4));
    }

    public void setWorldPortOrigin(GF2DPoint gF2DPoint) {
        this.basicSetWorldPortOrigin(gF2DPoint);
        this.damageViewPort();
    }

    public void setWorldPortOrigin(float f, float f2) {
        this.setWorldPortOrigin(new GF2DPoint(f, f2));
    }

    public void setWorldPortCenter(GF2DPoint gF2DPoint) {
        this.basicSetWorldPortCenter(gF2DPoint);
        this.damageViewPort();
    }

    public void setWorldPortCenter(float f, float f2) {
        this.setWorldPortCenter(new GF2DPoint(f, f2));
    }

    public float getWorld2ViewXScale() {
        return this.getWorldViewTransform().getWorld2ViewXScale();
    }

    public float getWorld2ViewYScale() {
        return this.getWorldViewTransform().getWorld2ViewYScale();
    }

    public void setWorld2ViewScale(GF2DPoint gF2DPoint, float f, float f2) {
        Rectangle rectangle = this.getViewPort();
        float f3 = f * (float)rectangle.width;
        float f4 = f2 * (float)rectangle.height;
        this.setWorldPort(gF2DPoint.x, gF2DPoint.y, f3, f4);
    }

    public void setWorld2ViewCentered(GF2DPoint gF2DPoint, float f, float f2) {
        Rectangle rectangle = this.getViewPort();
        float f3 = f * (float)rectangle.width;
        float f4 = f2 * (float)rectangle.height;
        this.setWorldPort(gF2DPoint.x - f3 / 2.0f, gF2DPoint.y - f4 / 2.0f, f3, f4);
    }

    public void displaySystemResized(Rectangle rectangle) {
        this.getWorldViewPortPolicy().displaySystemResized(rectangle);
    }

    public void scrollViewPort(int n, int n2) {
        GF2DDimension gF2DDimension = this.getWorldViewTransform().view2World(new Dimension(n, n2));
        GF2DRectangle gF2DRectangle = this.getWorldPort();
        this.setWorldPortOrigin(gF2DRectangle.x - gF2DDimension.width, gF2DRectangle.y - gF2DDimension.height);
    }

    protected void disableRepair() {
        OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem = this.getDisplaySystem();
        if (oSIGraphicsDisplaySystem != null) {
            oSIGraphicsDisplaySystem.disableRepair();
        }
    }

    protected void enableRepair() {
        OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem = this.getDisplaySystem();
        if (oSIGraphicsDisplaySystem != null) {
            oSIGraphicsDisplaySystem.enableRepair();
        }
    }

    protected void damageHandlesFor(GFGO gFGO) {
        this.handles.damageHandlesFor(gFGO);
    }

    public void damageRegion(GF2DRectangle gF2DRectangle) {
        OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem = this.getDisplaySystem();
        if (oSIGraphicsDisplaySystem != null) {
            GF2DRectangle gF2DRectangle2 = this.getWorldPort().intersection(gF2DRectangle);
            oSIGraphicsDisplaySystem.damageRegion(this.getWorldViewTransform().world2View(gF2DRectangle2));
        }
    }

    public void damageViewPort() {
        OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem = this.getDisplaySystem();
        if (oSIGraphicsDisplaySystem != null) {
            oSIGraphicsDisplaySystem.damageRegion(this.getViewPort());
        }
    }

    public void display(Graphics graphics) {
        GFGraphics gFGraphics = new GFGraphics(graphics, this.getWorldViewTransform());
        this.getDrawing().display(gFGraphics);
    }

    public void disableRedraw() {
        this.disableRepair();
    }

    public void enableRedraw() {
        this.enableRepair();
    }

    public void redraw() {
        OSIGraphicsDisplaySystem oSIGraphicsDisplaySystem = this.getDisplaySystem();
        if (oSIGraphicsDisplaySystem != null) {
            oSIGraphicsDisplaySystem.repairDamage();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        GFDrawingMouseEvent gFDrawingMouseEvent = new GFDrawingMouseEvent(this, mouseEvent);
        GFTool gFTool = this.getTool();
        if (gFTool != null) {
            switch (gFDrawingMouseEvent.getID()) {
                case 501: {
                    gFTool.processMouseDown(gFDrawingMouseEvent);
                    return;
                }
                case 500: {
                    gFTool.processMouseClick(gFDrawingMouseEvent);
                    return;
                }
                case 506: {
                    gFTool.processMouseDrag(gFDrawingMouseEvent);
                    return;
                }
                case 502: {
                    gFTool.processMouseUp(gFDrawingMouseEvent);
                    return;
                }
                case 503: {
                    gFTool.processMouseMove(gFDrawingMouseEvent);
                    return;
                }
                case 504: {
                    gFTool.processMouseEnter(gFDrawingMouseEvent);
                    return;
                }
                case 505: {
                    gFTool.processMouseExit(gFDrawingMouseEvent);
                    return;
                }
            }
        }
    }

    public void processKeyEvent(KeyEvent keyEvent) {
        GFDrawingKeyEvent gFDrawingKeyEvent = new GFDrawingKeyEvent(this, keyEvent);
        GFTool gFTool = this.getTool();
        if (gFTool != null) {
            switch (gFDrawingKeyEvent.getID()) {
                case 400: {
                    gFTool.processKeyTyped(gFDrawingKeyEvent);
                    return;
                }
                case 401: {
                    gFTool.processKeyDown(gFDrawingKeyEvent);
                    return;
                }
                case 402: {
                    gFTool.processKeyUp(gFDrawingKeyEvent);
                    return;
                }
            }
        }
    }

    protected GFDrawingMouseEvent snapToGridAndLimit(GFDrawingMouseEvent gFDrawingMouseEvent, boolean bl, boolean bl2) {
        return gFDrawingMouseEvent;
    }

    public GFGOArray getSelection() {
        return new GFSortedGOArray(this.selections);
    }

    public boolean isSelected(GFGO gFGO) {
        return this.selections.includes(gFGO);
    }

    protected void basicSelect(GFGO gFGO) {
        this.selections.add(gFGO);
        this.addAll(gFGO.getHandles());
    }

    public void select(GFGO gFGO) {
        gFGO.select();
    }

    public void selectAll(GFGOArray gFGOArray) {
        int n = gFGOArray.size();
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n2 = 0;
        while (n2 < n) {
            this.select(gFGOArray2[n2]);
            ++n2;
        }
    }

    protected void basicUnselect(GFGO gFGO) {
        this.selections.remove(gFGO);
        this.removeHandlesFor(gFGO);
    }

    public void unselect(GFGO gFGO) {
        gFGO.unselect();
    }

    public void unselectAll(GFGOArray gFGOArray) {
        int n = gFGOArray.size();
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n2 = 0;
        while (n2 < n) {
            this.unselect(gFGOArray2[n2]);
            ++n2;
        }
    }

    public void unselectAll() {
        GFUnsortedGOArray gFUnsortedGOArray = new GFUnsortedGOArray(this.selections);
        int n = gFUnsortedGOArray.size();
        GFGO[] gFGOArray = gFUnsortedGOArray.elements();
        int n2 = 0;
        while (n2 < n) {
            this.unselect(gFGOArray[n2]);
            ++n2;
        }
    }

    public static GFCompositeGO group(GFGOArray gFGOArray) {
        if (gFGOArray.size() <= 1) {
            return null;
        }
        GFCompositeGO gFCompositeGO = new GFCompositeGO(gFGOArray);
        gFCompositeGO.setGroupMode(true);
        return gFCompositeGO;
    }

    public GFCompositeGO groupSelection() {
        this.disableRedraw();
        GFCompositeGO gFCompositeGO = GFDrawingManager.group(this.getSelection());
        if (gFCompositeGO == null) {
            this.enableRedraw();
            return null;
        }
        this.add(gFCompositeGO);
        this.unselectAll();
        this.select(gFCompositeGO);
        this.enableRedraw();
        return gFCompositeGO;
    }

    public void ungroup(GFGO gFGO) {
        if (!(gFGO instanceof GFCompositeGO)) {
            return;
        }
        GFCompositeGO gFCompositeGO = (GFCompositeGO)gFGO;
        boolean bl = gFCompositeGO.isSelected();
        GFGOArray gFGOArray = gFCompositeGO.getContents();
        this.disableRedraw();
        gFCompositeGO.ungroup();
        if (bl) {
            this.selectAll(gFGOArray);
        }
        this.enableRedraw();
    }

    public void ungroupSelection() {
        GFGOArray gFGOArray = this.getSelection();
        int n = gFGOArray.size();
        GFGO[] gFGOArray2 = gFGOArray.elements();
        int n2 = 0;
        while (n2 < n) {
            this.ungroup(gFGOArray2[n2]);
            ++n2;
        }
    }

    public GFHandleLayer getHandleLayer() {
        return this.handles;
    }

    public void hideHandles() {
        this.getHandleLayer().hide();
    }

    public void showHandles() {
        this.getHandleLayer().show();
    }

    public GFHandle handleContaining(GF2DPoint gF2DPoint) {
        GFGO gFGO = this.getHandleLayer().graphicObjectContaining(gF2DPoint);
        return (GFHandle)gFGO;
    }

    public GFGOArray handlesContaining(GF2DPoint gF2DPoint) {
        return this.getHandleLayer().graphicObjectsContaining(gF2DPoint);
    }

    public GFHandle graphicObjectHandleContaining(GF2DPoint gF2DPoint) {
        GFGOArray gFGOArray = this.graphicObjectHandlesContaining(gF2DPoint);
        if (gFGOArray.size() == 0) {
            return null;
        }
        return (GFHandle)gFGOArray.elementAt(gFGOArray.size() - 1);
    }

    public GFGOArray graphicObjectHandlesContaining(GF2DPoint gF2DPoint) {
        GFGOArray gFGOArray = this.handlesContaining(gF2DPoint);
        GFSortedGOArray gFSortedGOArray = new GFSortedGOArray(gFGOArray.size());
        int n = 0;
        while (n < gFGOArray.size()) {
            GFHandle gFHandle = (GFHandle)gFGOArray.elementAt(n);
            if (gFHandle.getOwner() != null) {
                gFSortedGOArray.add(gFHandle);
            }
            ++n;
        }
        return gFSortedGOArray;
    }

    public void removeHandlesFor(GFGO gFGO) {
        this.getHandleLayer().removeAllFor(gFGO);
    }

    public void removeAllHandles() {
        this.getHandleLayer().removeAll();
    }

    public GFTool getTool() {
        return this.activeTool;
    }

    public void setTool(GFTool gFTool) {
        if (this.activeTool != gFTool) {
            if (this.activeTool != null) {
                this.activeTool.deactivated(this);
            }
            this.activeTool = gFTool;
            if (this.activeTool != null) {
                this.activeTool.activated(this);
            }
        }
    }

    public void releaseTool() {
        this.setTool(null);
    }

    public void setCursor(Cursor cursor) {
        this.cursor = cursor;
        GFDrawingCanvas gFDrawingCanvas = this.getCanvas();
        if (gFDrawingCanvas != null) {
            gFDrawingCanvas.setCursor(this.cursor);
        }
    }

    public Cursor getCursor() {
        return this.cursor;
    }

    public void addTransformListener(GFDrawingXFormListener gFDrawingXFormListener) {
        this.transformListener = GFDrawingEventMulticaster.add(this.transformListener, gFDrawingXFormListener);
    }

    public void removeTransformListener(GFDrawingXFormListener gFDrawingXFormListener) {
        this.transformListener = GFDrawingEventMulticaster.remove(this.transformListener, gFDrawingXFormListener);
    }

    protected void triggerTransformChangedEvent() {
        GFDrawingXFormListener gFDrawingXFormListener = this.transformListener;
        if (gFDrawingXFormListener != null) {
            gFDrawingXFormListener.drawingTransformChanged(new GFDrawingEvent(this));
        }
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        objectInputStream.defaultReadObject();
        GFDrawing gFDrawing = this.getDrawing();
        if (gFDrawing != null) {
            gFDrawing.basicSetAllManagerAttributes(this);
        }
    }
}

