/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.connect;

import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.connect.GF2DConnector;
import com.objectshare.gf.connect.GF2DPlug;
import com.objectshare.gf.connect.GFLocator;
import com.objectshare.gf.connect.GFPlug;
import com.objectshare.gf.connect.event.GFLocatorChangedListener;
import com.objectshare.gf.connect.event.GFLocatorEvent;
import com.objectshare.gf.go.event.GFGOHandleEvent;
import java.io.Serializable;
import java.util.Vector;

public abstract class GFConnector
implements GFLocatorChangedListener,
Serializable {
    protected boolean connected = false;

    public abstract GFLocator getLocator();

    public GFGO getSource() {
        return this.getLocator().getTarget();
    }

    public abstract GFPlug getPlug();

    public GFGO getTarget() {
        return this.getPlug().getTarget();
    }

    public GF2DPoint getLocation() {
        return this.getLocator().toPoint();
    }

    public Vector getColocatedSourceConnectors() {
        Vector vector = this.getSource().getConnectors(this.getLocator());
        vector.removeElement(this);
        return vector;
    }

    public Vector getColocatedTargetConnectors() {
        Vector vector = this.getTarget().getConnectors(this.getLocation());
        vector.removeElement(this);
        return vector;
    }

    public void connect() {
        if (this.connected) {
            return;
        }
        this.connected = true;
        this.getLocator().addChangedListener(this);
        this.getSource().basicAddConnector(this);
        this.getTarget().basicAddConnector(this);
        this.getLocator().triggerChangedEvent();
    }

    public void disconnect() {
        if (!this.connected) {
            return;
        }
        this.connected = false;
        this.getLocator().removeChangedListener(this);
        this.getSource().basicRemoveConnector(this);
        this.getTarget().basicRemoveConnector(this);
    }

    public abstract void locatorChanged(GFLocatorEvent var1);

    public void targetNeedsHandles(GFGOHandleEvent gFGOHandleEvent) {
        this.getPlug().targetNeedsHandles(gFGOHandleEvent);
    }

    public void targetNeedsPositionHandle(GFGOHandleEvent gFGOHandleEvent) {
        this.getPlug().targetNeedsPositionHandle(gFGOHandleEvent);
    }

    public static GFConnector newFor(GFLocator gFLocator, GFPlug gFPlug) {
        if (gFPlug instanceof GF2DPlug) {
            return GFConnector.newFor(gFLocator, (GF2DPlug)gFPlug);
        }
        return null;
    }

    public static GFConnector newFor(GFLocator gFLocator, GF2DPlug gF2DPlug) {
        return new GF2DConnector(gFLocator, gF2DPlug);
    }
}

