/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go;

import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.GFHandle;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.go.GFCachedGO;
import com.objectshare.gf.tool.GF2DXlateCreationHandle;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Date;

public class GFImageGO
extends GFCachedGO
implements ImageObserver {
    public static int updateThreshold = 3500;
    protected URL imageURL;
    protected GF2DDimension extent;
    protected long lastUpdate;

    public GFImageGO(URL uRL, String string) {
        this(uRL, string, 0.0f, 0.0f);
    }

    public GFImageGO(URL uRL, String string, float f, float f2) {
        this(uRL, string, new GF2DPoint(f, f2), null);
    }

    public GFImageGO(URL uRL, String string, float f, float f2, float f3, float f4) {
        this(uRL, string, new GF2DPoint(f, f2), new GF2DDimension(f3, f4));
    }

    public GFImageGO(URL uRL, String string, GF2DPoint gF2DPoint, GF2DDimension gF2DDimension) {
        try {
            this.imageURL = new URL(uRL, string);
        }
        catch (MalformedURLException malformedURLException) {
            this.imageURL = null;
        }
        this.origin = gF2DPoint;
        this.extent = gF2DDimension;
    }

    public GFImageGO(Image image) {
        this(image, 0.0f, 0.0f);
    }

    public GFImageGO(Image image, float f, float f2) {
        this(image, new GF2DPoint(f, f2), null);
    }

    public GFImageGO(Image image, float f, float f2, float f3, float f4) {
        this(image, new GF2DPoint(f, f2), new GF2DDimension(f3, f4));
    }

    public GFImageGO(Image image, GF2DPoint gF2DPoint, GF2DDimension gF2DDimension) {
        this.cache = image;
        this.origin = gF2DPoint;
        this.extent = gF2DDimension;
    }

    protected GFImageGO() {
    }

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new GFImageGO());
    }

    protected GFGO copyForCreationInto(GFGO gFGO) {
        super.copyForCreationInto(gFGO);
        GFImageGO gFImageGO = (GFImageGO)gFGO;
        gFImageGO.imageURL = this.imageURL;
        gFImageGO.extent = this.extent;
        return gFGO;
    }

    public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
        if ((n & 0x40) != 0) {
            System.out.println("error loading image");
            return false;
        }
        if (this.lastUpdate == 0L) {
            return false;
        }
        if ((n & 0x20) != 0 || (n & 8) != 0 && new Date().getTime() - this.lastUpdate > (long)updateThreshold) {
            this.damaged();
            this.redraw();
        }
        return n != 32;
    }

    public boolean basicReshape(float f, float f2, float f3, float f4) {
        this.origin = new GF2DPoint(f, f2);
        this.extent = new GF2DDimension(f3, f4);
        return true;
    }

    public GF2DDimension displayExtent() {
        if (this.extent == null) {
            this.extent = this.calcExtent();
            if (this.extent == null) {
                return new GF2DDimension(0.0f, 0.0f);
            }
        }
        return this.extent;
    }

    protected GF2DDimension calcExtent() {
        if (this.cache == null) {
            this.fillCache();
            if (this.cache == null) {
                return null;
            }
        }
        int n = this.cache.getWidth(null);
        int n2 = this.cache.getHeight(null);
        if (n <= 0 || n2 <= 0) {
            return null;
        }
        return new GF2DDimension(n, n2);
    }

    public void loadImage() {
        this.fillCache();
    }

    protected void fillCache() {
        if (this.cache == null && this.imageURL != null) {
            this.cache = Toolkit.getDefaultToolkit().getImage(this.imageURL);
        }
    }

    public void releaseResources() {
        super.releaseResources();
        this.lastUpdate = 0L;
    }

    public void basicDisplay(GFGraphics gFGraphics, float f, float f2, float f3, float f4) {
        if (this.cache == null) {
            this.fillCache();
        }
    }

    public void display(GFGraphics gFGraphics) {
        if (this.cache == null) {
            this.fillCache();
            if (this.cache == null) {
                return;
            }
        }
        this.lastUpdate = new Date().getTime();
        this.basicDisplay(gFGraphics);
    }

    public void basicDisplay(GFGraphics gFGraphics) {
        GF2DRectangle gF2DRectangle = this.displayBox();
        if (this.extent == null) {
            gF2DRectangle = new GF2DRectangle(gF2DRectangle.x, gF2DRectangle.y, -1.0f, -1.0f);
        }
        gFGraphics.drawImage(this.cache, gF2DRectangle.x, gF2DRectangle.y, gF2DRectangle.width, gF2DRectangle.height, (ImageObserver)this);
    }

    public GFHandle defaultCreationHandle() {
        return new GF2DXlateCreationHandle(this);
    }
}

