/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go;

import com.objectshare.gf.base.GF2DGraphicObject;
import com.objectshare.gf.base.GFGO;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.geometry.GF2DDimension;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Toolkit;

public class GFTextGO
extends GF2DGraphicObject {
    public static Color defaultColor = Color.black;
    public static Font defaultFont = new Font("Helvetica", 0, 12);
    protected GF2DPoint anchor;
    protected Color color;
    protected Font font;
    protected String text;
    protected GF2DDimension extent;
    protected FontMetrics fontMetrics;

    public GFTextGO(String string) {
        this(new GF2DPoint(0.0f, 0.0f), string);
    }

    public GFTextGO(GF2DPoint gF2DPoint, String string) {
        this(gF2DPoint, string, defaultFont, defaultColor);
    }

    public GFTextGO(float f, float f2, String string) {
        this(new GF2DPoint(f, f2), string);
    }

    public GFTextGO(GF2DPoint gF2DPoint, String string, Font font, Color color) {
        this.anchor = gF2DPoint;
        this.text = string;
        this.font = font;
        this.color = color;
    }

    public GFTextGO(float f, float f2, String string, Font font, Color color) {
        this(new GF2DPoint(f, f2), string, font, color);
    }

    public GFGO copyForCreation() {
        return this.copyForCreationInto(new GFTextGO(this.anchor, new String(this.text), this.font, this.color));
    }

    public boolean basicTranslate(float f, float f2) {
        this.anchor = this.anchor.translateBy(f, f2);
        return true;
    }

    public GF2DDimension displayExtent() {
        if (this.extent == null) {
            this.computeExtent();
        }
        return this.extent;
    }

    public GF2DRectangle displayBox() {
        GF2DDimension gF2DDimension = this.displayExtent();
        return new GF2DRectangle(this.anchor.x - gF2DDimension.width / 2.0f, this.anchor.y - gF2DDimension.height / 2.0f, gF2DDimension.width, gF2DDimension.height);
    }

    protected void computeExtent() {
        FontMetrics fontMetrics = this.getFontMetrics();
        this.extent = new GF2DDimension(fontMetrics.stringWidth(this.text), fontMetrics.getAscent() + fontMetrics.getDescent());
    }

    protected void invalidateExtent() {
        this.extent = null;
    }

    protected FontMetrics getFontMetrics() {
        if (this.fontMetrics == null) {
            this.fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(this.font);
        }
        return this.fontMetrics;
    }

    protected void invalidateFontMetrics() {
        this.fontMetrics = null;
        this.invalidateExtent();
    }

    public Color getColor() {
        return this.color;
    }

    public void setColor(Color color) {
        this.color = color;
        this.damaged();
    }

    public Font getFont() {
        return this.font;
    }

    public void setFont(Font font) {
        this.beginDamage();
        this.font = font;
        this.invalidateFontMetrics();
        this.endDamage();
        this.triggerReshapedEvent();
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.beginDamage();
        this.text = string;
        this.invalidateExtent();
        this.endDamage();
        this.triggerReshapedEvent();
    }

    protected void basicDisplay(GFGraphics gFGraphics) {
        FontMetrics fontMetrics = this.getFontMetrics();
        gFGraphics.setFont(this.font);
        GF2DPoint gF2DPoint = this.displayLeftTop();
        gFGraphics.drawString(this.text, gF2DPoint.x, gF2DPoint.y + (float)fontMetrics.getAscent());
    }

    public void display(GFGraphics gFGraphics) {
        gFGraphics.setColor(this.getColor());
        this.basicDisplay(gFGraphics);
    }

    public void displayShape(GFGraphics gFGraphics) {
        gFGraphics.setColor(Color.black);
        this.basicDisplay(gFGraphics);
    }
}

