/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.go.lineend;

import com.objectshare.gf.base.GFDrawingManager;
import com.objectshare.gf.base.GFGraphics;
import com.objectshare.gf.base.geometry.GF2DPoint;
import com.objectshare.gf.base.geometry.GF2DRectangle;
import com.objectshare.gf.go.GF2DIndexedPointGO;
import com.objectshare.gf.go.lineend.GFLineEnd;
import java.io.Serializable;

public abstract class GFAbstractLineEnd
implements GFLineEnd,
Serializable {
    protected GF2DIndexedPointGO line;
    protected int endPoint;

    public abstract GFLineEnd copyForLine();

    protected GFLineEnd copyForLineInto(GFLineEnd gFLineEnd) {
        return gFLineEnd;
    }

    public static int getEndPointForIndex(GF2DIndexedPointGO gF2DIndexedPointGO, int n) {
        if (n == 0 || n == 0) {
            return 0;
        }
        if (n == -1) {
            return -1;
        }
        int n2 = gF2DIndexedPointGO.getNumPoints();
        if (n2 > 0 && n == n2 - 1) {
            return -1;
        }
        throw new IllegalArgumentException("Invalid end point: " + n + " for line: " + gF2DIndexedPointGO);
    }

    public int getEndPointForIndex(int n) {
        return GFAbstractLineEnd.getEndPointForIndex(this.line, n);
    }

    public static int getIndexForEndPoint(GF2DIndexedPointGO gF2DIndexedPointGO, int n) {
        if (n == 0 || n == 0) {
            return 0;
        }
        int n2 = gF2DIndexedPointGO.getNumPoints() - 1;
        if (n == -1 || n == n2) {
            return n2;
        }
        throw new IllegalArgumentException("Invalid end point: " + n + " for line: " + gF2DIndexedPointGO);
    }

    public int getIndexForEndPoint(int n) {
        return GFAbstractLineEnd.getIndexForEndPoint(this.line, n);
    }

    public void basicSetManager(GFDrawingManager gFDrawingManager) {
    }

    public void basicSetAllManagerAttributes(GFDrawingManager gFDrawingManager) {
    }

    public void basicSetLine(GF2DIndexedPointGO gF2DIndexedPointGO, int n) {
        this.line = gF2DIndexedPointGO;
        if (gF2DIndexedPointGO != null) {
            this.endPoint = this.getEndPointForIndex(n);
        }
    }

    public GF2DIndexedPointGO getLine() {
        return this.line;
    }

    public int getPointIndex() {
        return this.getIndexForEndPoint(this.endPoint);
    }

    public int getEnd() {
        return this.endPoint;
    }

    public int getOppositeEnd() {
        if (this.getEnd() == 0) {
            return -1;
        }
        return 0;
    }

    public GF2DPoint getPoint() {
        return this.getLine().getPoint(this.getPointIndex());
    }

    public abstract void lineChanged();

    public abstract GF2DRectangle displayBox();

    public boolean containsPoint(GF2DPoint gF2DPoint) {
        return this.displayBox().inside(gF2DPoint);
    }

    public float getTangentialTheta() {
        return this.getLine().getTangentialTheta(this.getPointIndex(), this.getOppositeEnd());
    }

    protected void setLineEndAttachment(GF2DPoint gF2DPoint) {
        this.getLine().setLineEndAttachment(this.endPoint, gF2DPoint);
    }

    public abstract void display(GFGraphics var1);

    public abstract void displayShape(GFGraphics var1);
}

