/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.gf.tool;

import com.objectshare.gf.tool.GFTool;
import com.objectshare.gf.tool.GFToolPalette;
import com.objectshare.gf.tool.GFToolPaletteElement;
import java.util.Vector;

public class GFToolCategory
extends GFToolPaletteElement {
    public GFToolPalette palette;
    public GFTool defaultTool;
    public Vector tools = new Vector();

    public GFToolCategory(String string) {
        this.setImage(string);
    }

    public void setPalette(GFToolPalette gFToolPalette) {
        this.palette = gFToolPalette;
    }

    public void addTool(GFTool gFTool) {
        if (!this.includesTool(gFTool)) {
            this.tools.addElement(gFTool);
            if (this.palette != null) {
                this.palette.triggerToolAddedEvent(this, gFTool);
            }
        }
    }

    public boolean removeTool(GFTool gFTool) {
        if (this.includesTool(gFTool)) {
            if (this.defaultTool == gFTool) {
                this.defaultTool = null;
            }
            this.tools.removeElement(gFTool);
            if (this.palette != null) {
                if (this.palette.getCategory() == this && this.palette.getTool() == gFTool) {
                    this.palette.setTool(null);
                }
                this.palette.triggerToolRemovedEvent(this, gFTool);
            }
            return true;
        }
        return false;
    }

    public boolean includesTool(GFTool gFTool) {
        return this.tools.contains(gFTool);
    }

    public GFTool getDefaultTool() {
        if (this.defaultTool == null && this.tools.size() > 0) {
            this.defaultTool = (GFTool)this.tools.elementAt(0);
        }
        return this.defaultTool;
    }

    public void setDefaultTool(GFTool gFTool) {
        this.addTool(gFTool);
        this.defaultTool = gFTool;
    }

    public Vector getTools() {
        return this.tools;
    }
}

