/*
 * Decompiled with CFR 0.152.
 */
package com.objectshare.base.draw;

import com.objectshare.base.draw.OSIAbstractDisplaySystem;
import com.objectshare.base.draw.OSIDamageRepairer;
import com.objectshare.base.draw.OSIDamagedRegion;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Rectangle;

public class OSIGraphicsDisplaySystem
extends OSIAbstractDisplaySystem
implements OSIDamageRepairer {
    public transient boolean debugDamage = false;
    protected transient OSIDamagedRegion damagedRegion = new OSIDamagedRegion(this);
    public static boolean defaultSynchronousRepair = true;
    protected transient boolean synchronousRepair = defaultSynchronousRepair;

    public void setSynchronousRepair(boolean bl) {
        this.synchronousRepair = bl;
    }

    public boolean isSynchronousRepair() {
        return this.synchronousRepair;
    }

    public void damageAll() {
        this.damagedRegion.add(this.getContentBounds());
    }

    public void damageRegion(Rectangle rectangle) {
        this.damagedRegion.add(this.getContentBounds().intersection(rectangle));
    }

    public void disableRepair() {
        this.damagedRegion.disableRepair();
    }

    public void enableRepair() {
        this.damagedRegion.enableRepair();
    }

    public void repairDamage() {
        this.damagedRegion.repair();
    }

    public void repairDamage(Rectangle rectangle) {
        if (this.synchronousRepair) {
            Graphics graphics = this.getCanvas().getGraphics();
            if (graphics != null) {
                graphics.clipRect(rectangle.x - 1, rectangle.y - 1, rectangle.width + 2, rectangle.height + 2);
                this.display(graphics);
                return;
            }
        } else {
            this.getParent().repaint(rectangle.x, rectangle.y, rectangle.width + 2, rectangle.height + 2);
        }
    }

    public void paint(Graphics graphics) {
        if (this.synchronousRepair) {
            Rectangle rectangle = graphics.getClipRect();
            this.damageRegion(rectangle);
            this.repairDamage();
        } else {
            this.display(graphics);
        }
        this.displayBorder(graphics);
    }

    public void display(Graphics graphics) {
        Rectangle rectangle = this.getContentBounds();
        Rectangle rectangle2 = graphics.getClipRect();
        Graphics graphics2 = graphics.create(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics2.translate(-rectangle.x, -rectangle.y);
        graphics2.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        this.basicDisplay(graphics2);
        graphics2.dispose();
    }

    protected void basicDisplay(Graphics graphics) {
        Rectangle rectangle = graphics.getClipRect();
        Color color = this.getCanvas().getBackground();
        if (this.debugDamage) {
            graphics.setColor(color.darker().darker());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(color);
            graphics.fillRect(rectangle.x + 1, rectangle.y + 1, rectangle.width - 2, rectangle.height - 2);
        } else {
            graphics.setColor(color);
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
        this.getParent().paintCanvas(graphics);
    }
}

