/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.terminal;

import com.ibm.record.RecordConversionFailureException;
import java.math.BigDecimal;

class TerminalRecordConverterManager {
    static final String copyright = "Licensed Material - Property of IBM\nIBM(R) VisualAge(TM) for Java(TM) Version 2.0\n(C) Copyright IBM Corp. 1997, 1998 - All Rights Reserved.\nUS Government Users Restricted Rights - Use, duplication or disclosure\nrestricted by GSA ADP Schedule Contract with IBM Corp.";

    private TerminalRecordConverterManager() {
    }

    public static String convertBooleanToString(boolean value, String trueString, String falseString) {
        return value ? trueString : falseString;
    }

    public static String convertByteArrayToString(byte[] value, boolean doubleByteEncoded) throws RecordConversionFailureException {
        try {
            return new String(value);
        }
        catch (NullPointerException nullPointerException) {
            throw new RecordConversionFailureException();
        }
    }

    public static String convertByteToString(byte value) {
        return Byte.toString(value);
    }

    public static String convertCharToString(char value) {
        char[] valueArray = new char[]{value};
        return new String(valueArray);
    }

    public static String convertDoubleToString(double value, int mantissaLength) throws RecordConversionFailureException {
        if (mantissaLength >= 0) {
            try {
                BigDecimal decimal = new BigDecimal(value);
                int signum = decimal.signum();
                decimal = decimal.abs();
                decimal = decimal.movePointRight(mantissaLength);
                decimal = decimal.add(new BigDecimal(0.5));
                String digits = decimal.toBigInteger().toString();
                StringBuffer buffer = new StringBuffer();
                int dotPosition = digits.length() - mantissaLength;
                if (signum == -1) {
                    buffer.append('-');
                }
                if (dotPosition <= 0) {
                    buffer.append('0');
                } else {
                    buffer.append(digits.substring(0, dotPosition));
                }
                if (mantissaLength > 0) {
                    buffer.append('.');
                    while (dotPosition < 0) {
                        buffer.append('0');
                        ++dotPosition;
                    }
                    buffer.append(digits.substring(dotPosition, digits.length()));
                }
                return buffer.toString();
            }
            catch (NumberFormatException numberFormatException) {}
        }
        throw new RecordConversionFailureException();
    }

    public static String convertFloatToString(float value, int mantissaLength) throws RecordConversionFailureException {
        return TerminalRecordConverterManager.convertDoubleToString(value, mantissaLength);
    }

    public static String convertIntToString(int value) {
        return Integer.toString(value);
    }

    public static String convertLongToString(long value) {
        return Long.toString(value);
    }

    public static String convertShortToString(short value) {
        return Short.toString(value);
    }

    public static boolean convertStringToBoolean(String value, String trueString, String falseString) throws RecordConversionFailureException {
        try {
            if (value.equals(trueString)) {
                return true;
            }
            if (value.equals(falseString)) {
                return false;
            }
        }
        catch (NullPointerException nullPointerException) {}
        throw new RecordConversionFailureException();
    }

    public static byte convertStringToByte(String value) throws RecordConversionFailureException {
        try {
            return Byte.parseByte(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RecordConversionFailureException();
        }
    }

    public static byte[] convertStringToByteArray(String value, boolean doubleByteEncoded) throws RecordConversionFailureException {
        try {
            return value.getBytes();
        }
        catch (NullPointerException nullPointerException) {
            throw new RecordConversionFailureException();
        }
    }

    public static char convertStringToChar(String value) throws RecordConversionFailureException {
        try {
            if (value.length() == 1) {
                return value.charAt(0);
            }
        }
        catch (NullPointerException nullPointerException) {}
        throw new RecordConversionFailureException();
    }

    public static double convertStringToDouble(String value, int mantissaLength) throws RecordConversionFailureException {
        if (mantissaLength < 0) {
            throw new RecordConversionFailureException();
        }
        try {
            return new Double(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RecordConversionFailureException();
        }
    }

    public static float convertStringToFloat(String value, int mantissaLength) throws RecordConversionFailureException {
        if (mantissaLength < 0) {
            throw new RecordConversionFailureException();
        }
        try {
            return new Float(value).floatValue();
        }
        catch (NumberFormatException numberFormatException) {
            throw new RecordConversionFailureException();
        }
    }

    public static int convertStringToInt(String value) throws RecordConversionFailureException {
        try {
            return Integer.parseInt(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RecordConversionFailureException();
        }
    }

    public static long convertStringToLong(String value) throws RecordConversionFailureException {
        try {
            return Long.parseLong(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RecordConversionFailureException();
        }
    }

    public static short convertStringToShort(String value) throws RecordConversionFailureException {
        try {
            return Short.parseShort(value);
        }
        catch (NumberFormatException numberFormatException) {
            throw new RecordConversionFailureException();
        }
    }

    public static byte[] extractByteArray(byte[] bytes, int offset, int length, int paddingPolicy, byte paddingByte) throws RecordConversionFailureException {
        int[] pads = TerminalRecordConverterManager.numberOfPadsToBeRemoved(bytes, offset, length, paddingPolicy, paddingByte);
        byte[] result = new byte[length - pads[0] - pads[1]];
        System.arraycopy(bytes, offset + pads[0], result, 0, result.length);
        return result;
    }

    public static void fillBytes(byte fillByte, byte[] target, int offset, int length) throws ArrayIndexOutOfBoundsException {
        if (length > 0) {
            int span = 1;
            target[offset] = fillByte;
            while (span * 2 <= length) {
                System.arraycopy(target, offset, target, offset + span, span);
                span *= 2;
            }
            System.arraycopy(target, offset, target, offset + span, length - span);
        }
    }

    public static void injectByteArray(byte[] value, byte[] bytes, int offset, int length, int paddingPolicy, byte paddingByte) throws RecordConversionFailureException {
        int[] pads = TerminalRecordConverterManager.numberOfPadsToBeAdded(value, length, paddingPolicy, paddingByte);
        int leadingPadOffset = offset;
        int byteValueOffset = leadingPadOffset + pads[0];
        int trailingPadOffset = byteValueOffset + value.length;
        TerminalRecordConverterManager.fillBytes(paddingByte, bytes, leadingPadOffset, pads[0]);
        System.arraycopy(value, 0, bytes, byteValueOffset, value.length);
        TerminalRecordConverterManager.fillBytes(paddingByte, bytes, trailingPadOffset, pads[1]);
    }

    public static int[] numberOfPadsToBeAdded(byte[] value, int length, int paddingPolicy, byte paddingByte) throws RecordConversionFailureException {
        if (value == null) {
            throw new RecordConversionFailureException();
        }
        int[] result = new int[]{0, 0};
        int padLength = length - value.length;
        if (padLength < 0) {
            throw new RecordConversionFailureException();
        }
        switch (paddingPolicy) {
            case 1: {
                result[1] = padLength;
                break;
            }
            case 2: {
                result[0] = padLength;
                break;
            }
            case 3: {
                result[0] = padLength / 2;
                result[1] = padLength - result[0];
                break;
            }
        }
        return result;
    }

    public static int[] numberOfPadsToBeRemoved(byte[] bytes, int offset, int length, int paddingPolicy, byte paddingByte) throws RecordConversionFailureException {
        if (length < 0) {
            throw new RecordConversionFailureException();
        }
        int startOffset = offset;
        int stopOffset = offset + length - 1;
        try {
            if (paddingPolicy == 2 || paddingPolicy == 3) {
                while (startOffset <= stopOffset && bytes[startOffset] == paddingByte) {
                    ++startOffset;
                }
            }
            if (paddingPolicy == 1 || paddingPolicy == 3) {
                while (startOffset <= stopOffset && bytes[stopOffset] == paddingByte) {
                    --stopOffset;
                }
            }
        }
        catch (Exception exception) {
            throw new RecordConversionFailureException();
        }
        int[] result = new int[]{startOffset - offset, length + offset - stopOffset - 1};
        return result;
    }
}

