/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ivj.eab.record.cobol;

import com.ibm.ivj.eab.record.cobol.CobolIconvHost;
import com.ibm.ivj.eab.record.cobol.CobolRecordException;
import com.ibm.ivj.eab.record.cobol.CobolRecordResource;
import com.ibm.ivj.eab.record.cobol.CodePageConversionException;
import com.ibm.ivj.eab.record.cobol.DBCSConversionException;
import com.ibm.ivj.eab.record.cobol.DataAlignmentException;
import com.ibm.ivj.eab.record.cobol.NumericConversionException;
import com.ibm.ivj.eab.record.cobol.TypeConversionException;
import com.ibm.record.IRecordAttributes;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.math.BigDecimal;

public class CobolRecordAttributes
implements Serializable,
IRecordAttributes {
    private static String copyrights = "(c) Copyright IBM Corporation 1997, 1998.";
    public static final int BIGENDIAN = 0;
    public static final int LITTLEENDIAN = 1;
    public static final int IBMFLOATINGPOINTFORMAT = 0;
    public static final int IEEEFLOATINGPOINTFORMAT = 1;
    public static final int MVS = 0;
    public static final int OS2 = 1;
    public static final int NT = 2;
    public static final int AIX = 3;
    public static final int VACOBOL = 0;
    public static final int MFCOBOL = 1;
    public static final int VSCOBOL2 = 2;
    public static final int COMP = 0;
    public static final int COMP1 = 1;
    public static final int COMP2 = 2;
    public static final int COMP3 = 3;
    public static final int SIGN_LEADING = 4;
    public static final int SIGN_TRAILING = 5;
    public static final int SIGN_LEADING_SEPARATE = 6;
    public static final int SIGN_TRAILING_SEPARATE = 7;
    public static final int DISPLAY_NUMERIC = 8;
    public static final int DISPLAY_NONNUMERIC = 9;
    public static final int DISPLAY = 10;
    protected static final int JAVA_CHAR = 0;
    protected static final int JAVA_BOOLEAN = 1;
    protected static final int JAVA_BYTE = 2;
    protected static final int JAVA_SHORT = 3;
    protected static final int JAVA_INT = 4;
    protected static final int JAVA_LONG = 5;
    protected static final int JAVA_FLOAT = 6;
    protected static final int JAVA_DOUBLE = 7;
    protected static final int JAVA_STRING = 8;
    protected static final int JAVA_BIGDECIMAL = 9;
    private int remoteCobolEndian_;
    private int cobolMachine_;
    private int cobolCompiler_;
    private int remoteIntEndian_;
    private String codePage_;
    private int floatingPointFormat_;
    private byte POSOR;
    private byte NEGOR;
    private byte PLUS_SIGN;
    private byte NEGATIVE_SIGN;
    private byte PACKED_POSOR;
    private byte PACKED_NEGOR;
    private byte PACKED_NOSIGN;
    private byte ZERO_PAD;
    private byte ZERO_PAD_STR;
    private byte PLUS_SIGN_STR;
    private byte NEGATIVE_SIGN_STR;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG1 = false;
    private boolean insideDBCS = false;
    protected int fillerLength = 0;
    private int cobolDataType;
    private boolean sign;
    private boolean decimal;
    private boolean numeric;
    private int numberOfNines;
    private int decimalPosition;
    private int scale;
    private String expandedPicField;
    protected int picFieldLength;
    private StringBuffer comment;
    private boolean align;
    private CobolIconvHost charConverter;
    private static final int CVT_C_ROUND_TO_NEAREST = 1;
    private static final int CVT_C_TRUNCATE = 2;
    private static final int CVT_C_ROUND_TO_POS = 4;
    private static final int CVT_C_ROUND_TO_NEG = 8;
    private static final int CVT_C_BIG_ENDIAN = 16;
    private static final int CVT_C_ERR_UNDERFLOW = 32;
    private static final int[] ibm_short = new int[]{-16777216, 0, Integer.MIN_VALUE, Integer.MAX_VALUE, -1, Integer.MAX_VALUE, -1};
    private static final int IBM_S_INVALID = 0;
    private static final int IBM_S_POS_ZERO = 1;
    private static final int IBM_S_NEG_ZERO = 2;
    private static final int IBM_S_POS_HUGE = 3;
    private static final int IBM_S_NEG_HUGE = 4;
    private static final int IBM_S_POS_INFINITY = 5;
    private static final int IBM_S_NEG_INFINITY = 6;
    private static final long[] ibm_long = new long[]{-72057594037927936L, 0L, Long.MIN_VALUE, Long.MAX_VALUE, -1L, Long.MAX_VALUE, -1L};
    private static final int IBM_L_INVALID = 0;
    private static final int IBM_L_POS_ZERO = 1;
    private static final int IBM_L_NEG_ZERO = 2;
    private static final int IBM_L_POS_HUGE = 3;
    private static final int IBM_L_NEG_HUGE = 4;
    private static final int IBM_L_POS_INFINITY = 5;
    private static final int IBM_L_NEG_INFINITY = 6;
    private static final int[] ieee_single = new int[]{0x7FBFFFFF, -16513, 0, 0, Integer.MIN_VALUE, 128, 0x7F7FFFFF, -32897, -8388609, -32769, 2139095040, 32895, -8388608, 33023};
    private static final long[] ieee_double = new long[]{-2148007937L, -9345848836097L, 0L, 0L, 0x80000000L, 0x8000000000L, -2148532225L, -18141941858305L, -1048577L, -17592186044417L, 0x7FF00000L, 0xF07F00000000L, 0xFFF00000L, 0xF0FF00000000L};
    private static final int UR_EXP = 0;
    private static final int UR_FLAGS = 5;
    private static final int UR_NEGATIVE = 1;
    private static final int UR_ZERO = 2;
    private static final int UR_INFINITY = 4;
    private static final int UR_INVALID = 8;
    private static final int UR_UNUSUAL = 14;
    private static final long UR_BIAS = 0x80000000L;

    public CobolRecordAttributes() {
        this.scale = 0;
        this.numberOfNines = 0;
        this.numeric = true;
        this.decimal = false;
        this.decimalPosition = 0;
        this.expandedPicField = new String();
        this.picFieldLength = 0;
        this.comment = new StringBuffer();
        this.sign = false;
        this.remoteCobolEndian_ = 0;
        this.remoteIntEndian_ = 0;
        this.cobolMachine_ = 0;
        this.cobolCompiler_ = 2;
        if (this.cobolMachine_ == 0) {
            this.NEGOR = (byte)-48;
            this.POSOR = (byte)-64;
            this.PLUS_SIGN = (byte)78;
            this.NEGATIVE_SIGN = (byte)96;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)-16;
        }
        this.NEGATIVE_SIGN_STR = (byte)96;
        this.PLUS_SIGN_STR = (byte)78;
        this.ZERO_PAD_STR = (byte)-16;
        this.codePage_ = new String("037");
        this.charConverter = new CobolIconvHost(this.codePage_);
    }

    public CobolRecordAttributes(String aCodePage, int aRemoteIntEndian) {
        if (aRemoteIntEndian != 0 && aRemoteIntEndian != 1) {
            throw new IllegalArgumentException();
        }
        try {
            byte[] byteArray = new byte[]{12, 34};
            new String(byteArray, aCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(CobolRecordResource.instance().getString("IVJC0224E", aCodePage));
        }
        this.scale = 0;
        this.numberOfNines = 0;
        this.numeric = true;
        this.decimal = false;
        this.decimalPosition = 0;
        this.expandedPicField = new String();
        this.picFieldLength = 0;
        this.comment = new StringBuffer();
        this.sign = false;
        this.remoteCobolEndian_ = 0;
        this.remoteIntEndian_ = aRemoteIntEndian;
        this.cobolMachine_ = 0;
        this.cobolCompiler_ = 2;
        if (this.cobolMachine_ == 1) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else if (this.cobolMachine_ == 0) {
            this.NEGOR = (byte)-48;
            this.POSOR = (byte)-64;
            this.PLUS_SIGN = (byte)78;
            this.NEGATIVE_SIGN = (byte)96;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)-16;
        } else if (this.cobolMachine_ == 2) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        }
        this.codePage_ = aCodePage;
        this.charConverter = new CobolIconvHost(this.codePage_);
        try {
            String tmp = new String("-");
            this.NEGATIVE_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "+";
            this.PLUS_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "0";
            this.ZERO_PAD_STR = tmp.getBytes(this.codePage_)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
    }

    public CobolRecordAttributes(String aCodePage, int aRemoteIntEndian, int aEndian, int aFloatingPointFormat, int aMachine, int aCompiler) {
        if (aRemoteIntEndian != 0 && aRemoteIntEndian != 1) {
            throw new IllegalArgumentException();
        }
        if (aEndian != 0 && aEndian != 1) {
            throw new IllegalArgumentException();
        }
        if (aFloatingPointFormat != 0 && aFloatingPointFormat != 1) {
            throw new IllegalArgumentException();
        }
        if (aMachine != 0 && aMachine != 1 && aMachine != 2 && aMachine != 3) {
            throw new IllegalArgumentException();
        }
        try {
            byte[] byteArray = new byte[]{12, 34};
            new String(byteArray, aCodePage);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new IllegalArgumentException(CobolRecordResource.instance().getString("IVJC0224E", aCodePage));
        }
        this.scale = 0;
        this.numberOfNines = 0;
        this.numeric = true;
        this.decimal = false;
        this.decimalPosition = 0;
        this.expandedPicField = new String();
        this.picFieldLength = 0;
        this.comment = new StringBuffer();
        this.sign = false;
        this.remoteCobolEndian_ = aEndian;
        this.remoteIntEndian_ = aRemoteIntEndian;
        this.cobolMachine_ = aMachine;
        this.cobolCompiler_ = aCompiler;
        this.floatingPointFormat_ = aFloatingPointFormat;
        if (this.cobolMachine_ == 1) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else if (this.cobolMachine_ == 0) {
            this.NEGOR = (byte)-48;
            this.POSOR = (byte)-64;
            this.PLUS_SIGN = (byte)78;
            this.NEGATIVE_SIGN = (byte)96;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)-16;
        } else if (this.cobolMachine_ == 2) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        }
        this.codePage_ = aCodePage;
        this.charConverter = new CobolIconvHost(this.codePage_);
        try {
            String tmp = new String("-");
            this.NEGATIVE_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "+";
            this.PLUS_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "0";
            this.ZERO_PAD_STR = tmp.getBytes(this.codePage_)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
    }

    private int check_hyper(byte[] sb, int number_of_nines, boolean aSign) {
        char[] temp = new char[number_of_nines + 2];
        int rc = this.xtr_int_2c_to_int_nts(sb, temp);
        if (rc != 0 || !aSign && temp[0] == '-') {
            return -1;
        }
        return 0;
    }

    public Object clone() {
        try {
            CobolRecordAttributes newAttr = (CobolRecordAttributes)super.clone();
            newAttr.codePage_ = new String(this.codePage_);
            newAttr.expandedPicField = new String(this.expandedPicField);
            newAttr.comment = new StringBuffer(this.comment.toString());
            newAttr.charConverter = (CobolIconvHost)this.charConverter.clone();
            return newAttr;
        }
        catch (CloneNotSupportedException ex) {
            throw new InternalError(ex.getMessage());
        }
    }

    private void convertCobolDoubleToJavaDouble(byte[] cobolBuffer, byte[] javaBuffer) {
        if (this.floatingPointFormat_ == 0) {
            this.convertIBMLongToIEEEDouble(cobolBuffer, javaBuffer, 16);
        } else {
            this.xtr_real_fp_to_real_fp(cobolBuffer, javaBuffer);
            this.endianswap(javaBuffer);
        }
    }

    private void convertCobolSingleToJavaFloat(byte[] cobolBuffer, byte[] javaBuffer) {
        if (this.floatingPointFormat_ == 0) {
            this.convertIBMShortToIEEEFloat(cobolBuffer, javaBuffer, 16);
        } else {
            this.xtr_real_fp_to_real_fp(cobolBuffer, javaBuffer);
            this.endianswap(javaBuffer);
        }
    }

    protected byte[] convertCobolToJava(int javaType, byte[] info) {
        int cobolSize = this.sizeOfCobol();
        byte[] cobolBuffer = new byte[cobolSize];
        System.arraycopy(info, 0, cobolBuffer, 0, cobolSize);
        int javaSize = this.sizeOfJava(javaType, cobolSize);
        byte[] javaBuffer = new byte[javaSize];
        switch (this.cobolDataType) {
            case 0: {
                if (!this.decimal) {
                    if (this.remoteCobolEndian_ == 1 || this.remoteIntEndian_ == 1 && this.numberOfNines < 10) {
                        this.endianSwapForce(cobolBuffer);
                    }
                    this.xtr_int_2c_to_int_2c(cobolBuffer, javaBuffer);
                    break;
                }
                if (this.remoteCobolEndian_ == 1 || this.remoteIntEndian_ == 1 && this.numberOfNines < 10) {
                    this.endianswap(cobolBuffer);
                }
                double doubleVar = this.xtr_int_2c_to_real_double(cobolBuffer);
                byte[] doubleByte = this.convertToByte(doubleVar *= Math.pow(10.0, this.scale + this.decimalPosition));
                javaBuffer = doubleByte;
                break;
            }
            case 1: {
                javaSize = this.sizeOfJava(6, cobolSize);
                javaBuffer = new byte[javaSize];
                this.convertCobolSingleToJavaFloat(cobolBuffer, javaBuffer);
                break;
            }
            case 2: {
                this.convertCobolDoubleToJavaDouble(cobolBuffer, javaBuffer);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                char[] temp = new char[this.numberOfNines + 1];
                switch (this.cobolDataType) {
                    case 4: {
                        this.signLeadingToIntNts(cobolBuffer, temp);
                        break;
                    }
                    case 6: {
                        this.signLeadingSeparateToIntNts(cobolBuffer, temp);
                        break;
                    }
                    case 7: {
                        this.signTrailingSeparateToIntNts(cobolBuffer, temp);
                        break;
                    }
                    case 5: 
                    case 8: {
                        this.signTrailingToIntNts(cobolBuffer, temp);
                    }
                }
                if (!this.decimal) {
                    this.xtr_int_nts_to_int_2c(temp, javaBuffer);
                    break;
                }
                double d = 0.0;
                d = this.xtr_int_nts_to_real_double(temp);
                javaBuffer = this.convertToByte(d *= Math.pow(10.0, this.scale + this.decimalPosition));
                break;
            }
            case 9: {
                if (this.insideDBCS) {
                    javaBuffer = this.convertHostToUnicode(this.fixInDBCS(cobolBuffer, cobolSize));
                    break;
                }
                javaBuffer = this.convertHostToUnicode(cobolBuffer);
                break;
            }
            default: {
                return null;
            }
        }
        return javaBuffer;
    }

    protected char convertFromByteToChar(byte[] sb) {
        return (char)this.convertFromByteToShort(sb);
    }

    protected double convertFromByteToDouble(byte[] sb) {
        long doubleLongBits = this.convertFromByteToLong(sb);
        return Double.longBitsToDouble(doubleLongBits);
    }

    protected double convertFromByteToDouble(int javaType, byte[] sb) {
        double d = 0.0;
        switch (javaType) {
            case 3: {
                d = this.convertFromByteToShort(sb);
                break;
            }
            case 4: {
                d = this.convertFromByteToInt(sb);
                break;
            }
            case 5: {
                d = this.convertFromByteToLong(sb);
                break;
            }
            case 6: {
                int floatIntBits = this.convertFromByteToInt(sb);
                d = Float.intBitsToFloat(floatIntBits);
                break;
            }
            case 7: {
                long doubleLongBits = this.convertFromByteToLong(sb);
                d = Double.longBitsToDouble(doubleLongBits);
            }
        }
        return d;
    }

    protected float convertFromByteToFloat(byte[] sb) {
        int floatIntBits = this.convertFromByteToInt(sb);
        return Float.intBitsToFloat(floatIntBits);
    }

    protected float convertFromByteToFloat(int javaType, byte[] sb) {
        float f = 0.0f;
        switch (javaType) {
            case 3: {
                f = this.convertFromByteToShort(sb);
                break;
            }
            case 4: {
                f = this.convertFromByteToInt(sb);
                break;
            }
            case 5: {
                f = this.convertFromByteToLong(sb);
                break;
            }
            case 6: {
                int floatIntBits = this.convertFromByteToInt(sb);
                f = Float.intBitsToFloat(floatIntBits);
            }
        }
        return f;
    }

    protected int convertFromByteToInt(byte[] sb) {
        int i = sb[0] << 24 >>> 0 | sb[1] << 24 >>> 8 | sb[2] << 24 >>> 16 | sb[3] << 24 >>> 24;
        return i;
    }

    protected long convertFromByteToLong(byte[] sb) {
        long l = (long)sb[0] << 56 & 0xFF00000000000000L | (long)sb[1] << 48 & 0xFF000000000000L | (long)sb[2] << 40 & 0xFF0000000000L | (long)sb[3] << 32 & 0xFF00000000L | (long)sb[4] << 24 & 0xFF000000L | (long)sb[5] << 16 & 0xFF0000L | (long)sb[6] << 8 & 0xFF00L | (long)sb[7] & 0xFFL;
        return l;
    }

    protected short convertFromByteToShort(byte[] sb) {
        int i = sb[0] << 24 >>> 16 | sb[1] << 24 >>> 24;
        return (short)i;
    }

    protected String convertFromByteToString(byte[] sb) {
        int j = 0;
        char[] charArray = new char[sb.length / this.stringSize(1)];
        if (this.insideDBCS) {
            int i = 0;
            while (i < sb.length) {
                charArray[j] = (char)((char)sb[i] << 8 & 0xFF00 | (char)sb[++i] & 0xFF);
                if (charArray[j] == '\u0000') break;
                ++j;
                ++i;
            }
            return new String(charArray, 0, j);
        }
        int i = 0;
        while (i < sb.length) {
            charArray[j] = (char)((char)sb[i] << 8 & 0xFF00 | (char)sb[++i] & 0xFF);
            ++j;
            ++i;
        }
        return new String(charArray);
    }

    protected BigDecimal convertFromCobol(byte[] value) {
        if (this.cobolDataType != 3) {
            throw new TypeConversionException(CobolRecordResource.instance().getString("IVJC0227E"));
        }
        char[] ctmp = new char[this.numberOfNines + 1];
        this.packedDecimalToIntNts(value, ctmp);
        String tmp = new String(ctmp);
        if (tmp.startsWith("+")) {
            tmp = tmp.substring(1);
        }
        BigDecimal bd = new BigDecimal(tmp);
        if (this.decimal) {
            bd = bd.movePointRight(this.scale + this.decimalPosition);
        }
        return bd;
    }

    private byte[] convertHostToUnicode(byte[] cobolBuffer) {
        byte[] javaBuffer = null;
        String javaString = this.charConverter.iconvFromHost(cobolBuffer);
        javaBuffer = this.convertToByte(javaString);
        return javaBuffer;
    }

    private void convertIBMLongToIEEEDouble(byte[] inputValue, byte[] outputValue, int n) {
        int options;
        switch (n & 0xFFFFFFCF) {
            case 0: {
                options = n | 1;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
        }
        long[] unpackedReal = new long[6];
        this.convertIBMLongToUnpackedReal(inputValue, unpackedReal, options);
        this.convertUnpackedRealToIEEEDouble(unpackedReal, outputValue, options);
    }

    private void convertIBMLongToUnpackedReal(byte[] inputValue, long[] unpackedReal, int options) {
        byte[] tempLong = new byte[8];
        int i = 0;
        while (i < 4) {
            tempLong[4 + i] = inputValue[i];
            ++i;
        }
        unpackedReal[1] = this.convertFromByteToLong(tempLong);
        i = 4;
        while (i < 8) {
            tempLong[i] = inputValue[i];
            ++i;
        }
        unpackedReal[2] = this.convertFromByteToLong(tempLong);
        if (!this.remoteRepBigEndian()) {
            unpackedReal[1] = this.shuffleBytes(unpackedReal[1]);
            unpackedReal[2] = this.shuffleBytes(unpackedReal[2]);
        }
        unpackedReal[5] = unpackedReal[1] >> 31;
        unpackedReal[1] = unpackedReal[1] & Integer.MAX_VALUE;
        if (unpackedReal[1] == 0L && unpackedReal[2] == 0L) {
            unpackedReal[5] = unpackedReal[5] | 2L;
        } else {
            unpackedReal[0] = 0x80000000L + ((unpackedReal[1] >> 24) - 64L) * 4L;
            i = 0;
            while ((unpackedReal[1] & 0x800000L) == 0L) {
                if (++i > 3) break;
                unpackedReal[1] = unpackedReal[1] << 1 & 0xFFFFFFFFL;
            }
            if (i > 3) {
                unpackedReal[5] = unpackedReal[5] | 8L;
            } else {
                unpackedReal[0] = unpackedReal[0] - (long)i;
                unpackedReal[1] = unpackedReal[1] << 8 & 0xFFFFFFFFL;
                unpackedReal[1] = unpackedReal[1] | unpackedReal[2] >> 32 - (i += 8);
                unpackedReal[2] = unpackedReal[2] << i & 0xFFFFFFFFL;
                unpackedReal[3] = 0L;
                unpackedReal[4] = 0L;
            }
        }
    }

    private void convertIBMShortToIEEEFloat(byte[] inputValue, byte[] outputValue, int n) {
        int options;
        switch (n & 0xFFFFFFCF) {
            case 0: {
                options = n | 1;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
        }
        long[] unpackedReal = new long[6];
        this.convertIBMShortToUnpackedReal(inputValue, unpackedReal, options);
        this.convertUnpackedRealToIEEEFloat(unpackedReal, outputValue, options);
    }

    private void convertIBMShortToUnpackedReal(byte[] inputValue, long[] unpackedReal, int options) {
        int i;
        byte[] temp;
        if (this.remoteRepBigEndian()) {
            temp = new byte[8];
            i = 4;
            while (i > 0) {
                temp[8 - i] = inputValue[4 - i];
                --i;
            }
            unpackedReal[1] = this.convertFromByteToLong(temp);
        } else {
            temp = new byte[8];
            i = 4;
            while (i > 0) {
                temp[8 - i] = inputValue[4 - i];
                --i;
            }
            if ((options & 0x10) != 0) {
                unpackedReal[0] = this.convertFromByteToLong(temp);
                unpackedReal[1] = this.shuffleBytes(unpackedReal[0]);
            } else {
                unpackedReal[1] = this.convertFromByteToLong(temp);
            }
        }
        unpackedReal[5] = unpackedReal[1] >> 31;
        unpackedReal[1] = unpackedReal[1] & Integer.MAX_VALUE;
        if (unpackedReal[1] == 0L) {
            unpackedReal[5] = unpackedReal[5] | 2L;
        } else {
            unpackedReal[0] = 0x80000000L + ((unpackedReal[1] >> 24) - 64L) * 4L;
            int i2 = 0;
            while ((unpackedReal[1] & 0x800000L) == 0L) {
                if (++i2 > 3) break;
                unpackedReal[1] = unpackedReal[1] << 1 & 0xFFFFFFFFL;
            }
            if (i2 > 3) {
                unpackedReal[5] = unpackedReal[5] | 8L;
            } else {
                unpackedReal[0] = unpackedReal[0] - (long)i2;
                unpackedReal[1] = unpackedReal[1] << 8 & 0xFFFFFFFFL;
                unpackedReal[2] = 0L;
                unpackedReal[3] = 0L;
                unpackedReal[4] = 0L;
            }
        }
    }

    private void convertIEEEDoubleToIBMLong(byte[] inputValue, byte[] outputValue, int n) {
        int options;
        switch (n & 0xFFFFFFCF) {
            case 0: {
                options = n | 1;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
        }
        long[] unpackedReal = new long[6];
        this.convertIEEEDoubleToUnpackedReal(inputValue, unpackedReal, options);
        this.convertUnpackedRealToIBMLong(unpackedReal, outputValue, options);
    }

    private void convertIEEEDoubleToUnpackedReal(byte[] inputValue, long[] unpackedReal, int options) {
        byte[] tempLong = new byte[8];
        int i = 0;
        while (i < 4) {
            tempLong[4 + i] = inputValue[i];
            ++i;
        }
        unpackedReal[1] = this.convertFromByteToLong(tempLong);
        i = 4;
        while (i < 8) {
            tempLong[i] = inputValue[i];
            ++i;
        }
        unpackedReal[2] = this.convertFromByteToLong(tempLong);
        if (!this.localRepBigEndian()) {
            if ((options & 0x10) != 0) {
                unpackedReal[1] = this.shuffleBytes(unpackedReal[1]);
                unpackedReal[2] = this.shuffleBytes(unpackedReal[2]);
            } else {
                long temp = unpackedReal[2];
                unpackedReal[2] = unpackedReal[1];
                unpackedReal[1] = temp;
            }
        }
        unpackedReal[5] = unpackedReal[1] >> 31;
        unpackedReal[0] = unpackedReal[1] >> 20 & 0x7FFL;
        if (unpackedReal[0] == 0L) {
            unpackedReal[1] = unpackedReal[1] & Integer.MAX_VALUE;
            if (unpackedReal[1] != 0L) {
                i = 0;
                while ((unpackedReal[1] & 0x80000L) == 0L) {
                    ++i;
                    unpackedReal[1] = unpackedReal[1] << 1 & 0xFFFFFFFFL;
                }
                unpackedReal[0] = 2147482626L - (long)i;
                unpackedReal[1] = unpackedReal[1] << 12 & 0xFFFFFFFFL;
                unpackedReal[1] = unpackedReal[1] | unpackedReal[2] >> 32 - (i += 12);
                unpackedReal[2] = unpackedReal[2] << i & 0xFFFFFFFFL;
                unpackedReal[3] = 0L;
                unpackedReal[4] = 0L;
            } else if (unpackedReal[2] != 0L) {
                unpackedReal[1] = unpackedReal[2];
                i = 20;
                while ((unpackedReal[1] & 0x80000000L) == 0L) {
                    unpackedReal[1] = unpackedReal[1] << 1 & 0xFFFFFFFFL;
                    ++i;
                }
                unpackedReal[0] = 2147482626L - (long)i;
                unpackedReal[2] = 0L;
                unpackedReal[3] = 0L;
                unpackedReal[4] = 0L;
            } else {
                unpackedReal[5] = unpackedReal[5] | 2L;
            }
        } else if (unpackedReal[0] == 2047L) {
            unpackedReal[1] = unpackedReal[1] & 0xFFFFFL;
            unpackedReal[5] = (unpackedReal[1] | unpackedReal[2]) != 0L ? unpackedReal[5] | 8L : unpackedReal[5] | 4L;
        } else {
            unpackedReal[0] = unpackedReal[0] + 2147482626L;
            unpackedReal[1] = unpackedReal[1] | 0x100000L;
            unpackedReal[1] = unpackedReal[1] << 11 & 0xFFFFFFFFL;
            unpackedReal[1] = unpackedReal[1] | unpackedReal[2] >> 21;
            unpackedReal[2] = unpackedReal[2] << 11 & 0xFFFFFFFFL;
            unpackedReal[3] = 0L;
            unpackedReal[4] = 0L;
        }
    }

    private void convertIEEEFloatToIBMShort(byte[] inputValue, byte[] outputValue, int n) {
        int options;
        switch (n & 0xFFFFFFCF) {
            case 0: {
                options = n | 1;
            }
            case 1: 
            case 2: 
            case 4: 
            case 8: {
                break;
            }
        }
        long[] r = new long[6];
        this.convertIEEEFloatToUnpackedReal(inputValue, r, options);
        int i = 0;
        while (i < 6) {
            ++i;
        }
        this.convertUnpackedRealToIBMShort(r, outputValue, options);
    }

    private void convertIEEEFloatToUnpackedReal(byte[] inputValue, long[] unpackedReal, int options) {
        int i;
        byte[] temp;
        if (this.localRepBigEndian()) {
            temp = new byte[8];
            i = 4;
            while (i > 0) {
                temp[8 - i] = inputValue[4 - i];
                --i;
            }
            unpackedReal[1] = this.convertFromByteToLong(temp);
        } else {
            temp = new byte[8];
            i = 4;
            while (i > 0) {
                temp[8 - i] = inputValue[4 - i];
                --i;
            }
            if ((options & 0x10) != 0) {
                unpackedReal[0] = this.convertFromByteToLong(temp);
                unpackedReal[1] = this.shuffleBytes(unpackedReal[0]);
            } else {
                unpackedReal[1] = this.convertFromByteToLong(temp);
            }
        }
        unpackedReal[5] = unpackedReal[1] >> 31;
        unpackedReal[0] = unpackedReal[1] >> 23 & 0xFFL;
        if (unpackedReal[0] == 0L) {
            unpackedReal[1] = unpackedReal[1] & Integer.MAX_VALUE;
            if (unpackedReal[1] != 0L) {
                int i2 = 0;
                while ((unpackedReal[1] & 0x400000L) == 0L) {
                    unpackedReal[1] = unpackedReal[1] << 1 & 0xFFFFFFFFL;
                    ++i2;
                }
                unpackedReal[0] = 2147483522L - (long)i2;
                unpackedReal[1] = unpackedReal[1] << 9 & 0xFFFFFFFFL;
                unpackedReal[2] = 0L;
                unpackedReal[3] = 0L;
                unpackedReal[4] = 0L;
            } else {
                unpackedReal[5] = unpackedReal[5] | 2L;
            }
        } else if (unpackedReal[0] == 255L) {
            unpackedReal[1] = unpackedReal[1] & 0x7FFFFFL;
            unpackedReal[5] = unpackedReal[1] != 0L ? unpackedReal[5] | 8L : unpackedReal[5] | 4L;
        } else {
            unpackedReal[0] = unpackedReal[0] + 2147483522L;
            unpackedReal[1] = unpackedReal[1] | 0x800000L;
            unpackedReal[1] = unpackedReal[1] << 8 & 0xFFFFFFFFL;
            unpackedReal[2] = 0L;
            unpackedReal[3] = 0L;
            unpackedReal[4] = 0L;
        }
    }

    private void convertJavaDoubleToCobolDouble(byte[] javaBuffer, byte[] cobolBuffer) {
        if (this.floatingPointFormat_ == 0) {
            this.convertIEEEDoubleToIBMLong(javaBuffer, cobolBuffer, 0);
        } else {
            this.xtr_real_fp_to_real_fp(javaBuffer, cobolBuffer);
            this.endianswap(cobolBuffer);
        }
    }

    private void convertJavaFloatToCobolSingle(byte[] javaBuffer, byte[] cobolBuffer) {
        if (this.floatingPointFormat_ == 0) {
            this.convertIEEEFloatToIBMShort(javaBuffer, cobolBuffer, 0);
        } else {
            this.xtr_real_fp_to_real_fp(javaBuffer, cobolBuffer);
            this.endianswap(cobolBuffer);
        }
    }

    protected byte[] convertJavaToCobol(int javaType, byte[] javaBuffer) {
        int cobolSize = this.sizeOfCobol();
        byte[] cobolBuffer = new byte[cobolSize];
        int javaSize = this.sizeOfJava(javaType, this.picFieldLength);
        switch (this.cobolDataType) {
            case 0: {
                if (!this.decimal) {
                    byte[] temp = new byte[javaSize];
                    int i = 0;
                    while (i < javaSize) {
                        temp[i] = javaBuffer[i];
                        ++i;
                    }
                    if (this.check_hyper(temp, this.numberOfNines, this.sign) != 0) {
                        throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                    }
                    this.xtr_int_2c_to_int_2c(temp, cobolBuffer);
                    if (this.remoteCobolEndian_ != 1 && (this.remoteIntEndian_ != 1 || this.numberOfNines >= 10)) break;
                    this.endianSwapForce(cobolBuffer);
                    break;
                }
                double doubleVar = 0.0;
                byte[] doubleByte = new byte[8];
                this.xtr_real_fp_to_real_fp(javaBuffer, doubleByte);
                doubleVar = this.convertFromByteToDouble(doubleByte);
                doubleByte = this.convertToByte(doubleVar /= Math.pow(10.0, this.scale + this.decimalPosition));
                int rc = this.xtr_real_fp_to_int_2c(doubleByte, cobolBuffer);
                if (rc != 0) {
                    throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                }
                rc = this.check_hyper(cobolBuffer, this.numberOfNines, this.sign);
                if (rc != 0) {
                    throw new DataAlignmentException(CobolRecordResource.instance().getString("IVJC0200E"));
                }
                if (this.remoteCobolEndian_ != 1 && (this.remoteIntEndian_ != 1 || this.numberOfNines >= 10)) break;
                this.endianswap(cobolBuffer);
                break;
            }
            case 1: {
                this.convertJavaFloatToCobolSingle(javaBuffer, cobolBuffer);
                break;
            }
            case 2: {
                this.convertJavaDoubleToCobolDouble(javaBuffer, cobolBuffer);
                break;
            }
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: {
                char[] charBuf = new char[this.numberOfNines + 1];
                if (!this.decimal) {
                    byte[] temp = new byte[javaSize];
                    int i = 0;
                    while (i < javaSize) {
                        temp[i] = javaBuffer[i];
                        ++i;
                    }
                    int rc = this.xtr_int_2c_to_int_nts(temp, charBuf);
                    if (rc != 0) {
                        String error = temp.length == 2 ? CobolRecordResource.instance().getString("IVJC0213E", Short.toString(this.convertFromByteToShort(temp))) : (temp.length == 4 ? CobolRecordResource.instance().getString("IVJC0213E", Integer.toString(this.convertFromByteToInt(temp))) : CobolRecordResource.instance().getString("IVJC0213E", Long.toString(this.convertFromByteToLong(temp))));
                        throw new NumericConversionException(error);
                    }
                } else {
                    double doubleVar = 0.0;
                    byte[] doubleByte = new byte[8];
                    this.xtr_real_fp_to_real_fp(javaBuffer, doubleByte);
                    doubleVar = this.convertFromByteToDouble(doubleByte);
                    int rc = this.xtr_real_fp_to_int_nts(doubleVar /= Math.pow(10.0, this.scale + this.decimalPosition), charBuf);
                    if (rc != 0) {
                        throw new NumericConversionException(CobolRecordResource.instance().getString("IVJC0214E", Double.toString(doubleVar)));
                    }
                }
                if (charBuf[0] == '-' && !this.sign) {
                    throw new NumericConversionException(CobolRecordResource.instance().getString("IVJC0215E"));
                }
                switch (this.cobolDataType) {
                    case 4: {
                        this.intNtsToSignLeading(charBuf, cobolBuffer, this.sign);
                        break;
                    }
                    case 5: 
                    case 8: {
                        this.intNtsToSignTrailing(charBuf, cobolBuffer, this.sign);
                        break;
                    }
                    case 6: {
                        this.intNtsToSignLeadingSeparate(charBuf, cobolBuffer);
                        break;
                    }
                    case 7: {
                        this.intNtsToSignTrailingSeparate(charBuf, cobolBuffer);
                    }
                }
                break;
            }
            case 9: {
                cobolBuffer = this.convertUnicodeToHost(javaBuffer);
                if (!this.insideDBCS) {
                    int truncationRequired = cobolBuffer.length - this.picFieldLength;
                    if (truncationRequired > 0 && truncationRequired <= this.fillerLength) {
                        byte[] tmpArray = new byte[this.picFieldLength];
                        int j = 0;
                        while (j < this.picFieldLength) {
                            tmpArray[j] = cobolBuffer[j];
                            ++j;
                        }
                        cobolBuffer = tmpArray;
                    }
                    if (cobolBuffer.length > this.picFieldLength && !this.insideDBCS) {
                        throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0216E", this.convertFromByteToString(javaBuffer), this.expandedPicField));
                    }
                }
                this.fillerLength = 0;
            }
        }
        if (this.insideDBCS && (cobolBuffer = this.fixOutDBCS(cobolBuffer, cobolSize)).length > this.picFieldLength) {
            throw new CobolRecordException(CobolRecordResource.instance().getString("IVJC0216E", this.convertFromByteToString(javaBuffer), this.expandedPicField));
        }
        return cobolBuffer;
    }

    protected byte[] convertToByte(char sb) {
        byte[] tb = new byte[]{(byte)(((short)sb & 0xFF00) >>> 8), (byte)((short)sb & 0xFF)};
        return tb;
    }

    protected byte[] convertToByte(double sb) {
        new Double(sb);
        long doubleLongBits = Double.doubleToLongBits(sb);
        byte[] tb = this.convertToByte(doubleLongBits);
        return tb;
    }

    protected byte[] convertToByte(float sb) {
        new Float(sb);
        int floatIntBits = Float.floatToIntBits(sb);
        byte[] tb = this.convertToByte(floatIntBits);
        return tb;
    }

    protected byte[] convertToByte(int sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF000000) >>> 24), (byte)((sb & 0xFF0000) >>> 16), (byte)((sb & 0xFF00) >>> 8), (byte)(sb & 0xFF)};
        return tb;
    }

    protected byte[] convertToByte(long sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF00000000000000L) >>> 56), (byte)((sb & 0xFF000000000000L) >>> 48), (byte)((sb & 0xFF0000000000L) >>> 40), (byte)((sb & 0xFF00000000L) >>> 32), (byte)((sb & 0xFF000000L) >>> 24), (byte)((sb & 0xFF0000L) >>> 16), (byte)((sb & 0xFF00L) >>> 8), (byte)(sb & 0xFFL)};
        return tb;
    }

    protected byte[] convertToByte(String sb) {
        char[] charArray = sb.toCharArray();
        byte[] tb = new byte[this.stringSize(sb.length())];
        int j = 0;
        int i = 0;
        while (i < charArray.length) {
            tb[j] = (byte)(((short)sb.charAt(i) & 0xFF00) >>> 8);
            tb[++j] = (byte)((short)sb.charAt(i) & 0xFF);
            ++j;
            ++i;
        }
        return tb;
    }

    protected byte[] convertToByte(short sb) {
        byte[] tb = new byte[]{(byte)((sb & 0xFF00) >>> 8), (byte)(sb & 0xFF)};
        return tb;
    }

    protected byte[] convertToCobol(BigDecimal bigDecimal) {
        BigDecimal value;
        if (this.cobolDataType != 3) {
            throw new TypeConversionException(CobolRecordResource.instance().getString("IVJC0225E"));
        }
        if (this.decimal && new BigDecimal("10").compareTo((value = bigDecimal.movePointLeft(this.scale + this.decimalPosition)).movePointLeft(this.numberOfNines - 1).abs()) != 1) {
            throw new TypeConversionException(CobolRecordResource.instance().getString("IVJC0226E", value.toString()));
        }
        String tmp = (value = value.divide(new BigDecimal("1"), 0, 4)).toString();
        if (!tmp.startsWith("+") && !tmp.startsWith("-")) {
            StringBuffer sbuf = new StringBuffer(tmp);
            sbuf.insert(0, "+");
            tmp = sbuf.toString();
        }
        if (tmp.charAt(0) == '-' && !this.sign) {
            throw new NumericConversionException(CobolRecordResource.instance().getString("IVJC0215E"));
        }
        int pos = tmp.length();
        int index = tmp.indexOf(".");
        if (index != -1) {
            pos = index;
        }
        if (this.numberOfNines + 1 >= pos) {
            tmp = tmp.substring(0, pos);
            StringBuffer buf = new StringBuffer(tmp);
            int i = 0;
            while (i < this.numberOfNines - pos + 1) {
                buf.insert(1, "0");
                ++i;
            }
            tmp = buf.toString();
        } else {
            tmp = String.valueOf(tmp.substring(0, 1)) + tmp.substring(pos - this.numberOfNines, pos);
        }
        byte[] cobolBuffer = new byte[this.sizeOfCobol()];
        this.intNtsToPackedDecimal(tmp.toCharArray(), cobolBuffer, this.sign);
        return cobolBuffer;
    }

    private byte[] convertUnicodeToHost(byte[] javaBuffer) {
        byte[] cobolBuffer = null;
        String javaString = this.convertFromByteToString(javaBuffer);
        cobolBuffer = this.charConverter.iconvToHost(javaString);
        return cobolBuffer;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertUnpackedRealToIBMLong(long[] unpackedReal, byte[] byArray, int options) {
        byte[] outputValue;
        if ((unpackedReal[5] & 0xEL) != 0L) {
            if ((unpackedReal[5] & 2L) != 0L) {
                outputValue = (unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_long[2]) : this.convertToByte(ibm_long[1]);
                return;
            } else if ((unpackedReal[5] & 4L) != 0L) {
                outputValue = (unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_long[6]) : this.convertToByte(ibm_long[5]);
                return;
            } else {
                if ((unpackedReal[5] & 8L) == 0L) return;
                outputValue = this.convertToByte(ibm_long[0]);
            }
            return;
        } else {
            int roundBitPos = 0;
            int i = (int)(unpackedReal[0] & 3L);
            roundBitPos = i != 0 ? i + 52 : 56;
            this.round(unpackedReal, roundBitPos, options);
            if (unpackedReal[0] < 2147483393L) {
                outputValue = (unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_long[2]) : this.convertToByte(ibm_long[1]);
                if ((options & 0x20) == 0) return;
            }
            if (unpackedReal[0] > 2147483900L) {
                outputValue = (options & 2) != 0 ? ((unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_long[4]) : this.convertToByte(ibm_long[3])) : ((options & 4) != 0 && (unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_long[4]) : ((options & 8) != 0 && (unpackedReal[5] & 1L) == 0L ? this.convertToByte(ibm_long[3]) : ((unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_long[6]) : this.convertToByte(ibm_long[5]))));
                return;
            } else {
                i = (int)(unpackedReal[0] & 3L);
                int j = (int)(unpackedReal[0] - 0x80000000L) / 4 + 64;
                if (i != 0) {
                    if (unpackedReal[0] > 0x80000000L) {
                        ++j;
                    }
                    i = 12 - i;
                } else {
                    i = 8;
                }
                unpackedReal[2] = unpackedReal[2] >> i;
                unpackedReal[2] = unpackedReal[2] | unpackedReal[1] << 32 - i & 0xFFFFFFFFL;
                unpackedReal[1] = unpackedReal[1] >> i;
                unpackedReal[1] = (unpackedReal[1] | (long)(j << 24)) & 0xFFFFFFFFL;
                unpackedReal[1] = (unpackedReal[1] | unpackedReal[5] << 31) & 0xFFFFFFFFL;
                if (!this.remoteRepBigEndian()) {
                    unpackedReal[1] = this.shuffleBytes(unpackedReal[1]);
                    unpackedReal[2] = this.shuffleBytes(unpackedReal[2]);
                }
                byte[] tempBytes = this.convertToByte(unpackedReal[1]);
                i = 0;
                while (i < 4) {
                    outputValue[i] = tempBytes[4 + i];
                    ++i;
                }
                tempBytes = this.convertToByte(unpackedReal[2]);
                i = 4;
                while (i < 8) {
                    outputValue[i] = tempBytes[i];
                    ++i;
                }
            }
        }
    }

    private void convertUnpackedRealToIBMShort(long[] unpackedReal, byte[] byArray, int options) {
        block13: {
            byte[] outputValue;
            block11: {
                block14: {
                    block12: {
                        if ((unpackedReal[5] & 0xEL) == 0L) break block11;
                        if ((unpackedReal[5] & 2L) == 0L) break block12;
                        outputValue = (unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_short[2]) : this.convertToByte(ibm_short[1]);
                        break block13;
                    }
                    if ((unpackedReal[5] & 4L) == 0L) break block14;
                    outputValue = (unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_short[6]) : this.convertToByte(ibm_short[5]);
                    break block13;
                }
                if ((unpackedReal[5] & 8L) == 0L) break block13;
                outputValue = this.convertToByte(ibm_short[0]);
                break block13;
            }
            int i = (int)(unpackedReal[0] & 3L);
            int roundBitPos = 24;
            if (i != 0) {
                roundBitPos = i + 20;
            }
            this.round(unpackedReal, roundBitPos, options);
            if (unpackedReal[0] < 2147483393L) {
                outputValue = (unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_short[2]) : this.convertToByte(ibm_short[1]);
            } else if (unpackedReal[0] > 2147483900L) {
                outputValue = (options & 2) != 0 ? ((unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_short[4]) : this.convertToByte(ibm_short[3])) : ((options & 4) != 0 && (unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_short[4]) : ((options & 8) != 0 && (unpackedReal[5] & 1L) == 0L ? this.convertToByte(ibm_short[3]) : ((unpackedReal[5] & 1L) != 0L ? this.convertToByte(ibm_short[6]) : this.convertToByte(ibm_short[5]))));
            } else {
                i = (int)(unpackedReal[0] & 3L);
                long j = (unpackedReal[0] - 0x80000000L) / 4L + 64L;
                if (i != 0) {
                    if (unpackedReal[0] > 0x80000000L) {
                        ++j;
                    }
                    i = 12 - i;
                } else {
                    i = 8;
                }
                unpackedReal[1] = unpackedReal[1] >> i;
                unpackedReal[1] = unpackedReal[1] | j << 24 & 0xFFFFFFFFL;
                unpackedReal[1] = unpackedReal[1] | unpackedReal[5] << 31 & 0xFFFFFFFFL;
                byte[] tempOutput = new byte[8];
                tempOutput = this.convertToByte(unpackedReal[1]);
                int z = 0;
                while (z < 4) {
                    outputValue[z] = tempOutput[4 + z];
                    ++z;
                }
                if (!this.remoteRepBigEndian()) {
                    int leftSide = 0;
                    int rightSide = outputValue.length - 1;
                    while (leftSide < rightSide) {
                        byte b = outputValue[leftSide];
                        outputValue[leftSide] = outputValue[rightSide];
                        outputValue[rightSide] = b;
                        ++leftSide;
                        --rightSide;
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertUnpackedRealToIEEEDouble(long[] unpackedReal, byte[] byArray, int options) {
        byte[] outputValue;
        if ((unpackedReal[5] & 0xEL) != 0L) {
            if ((unpackedReal[5] & 2L) != 0L) {
                outputValue = (unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_double[5]) : this.convertToByte(ieee_double[4])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_double[3]) : this.convertToByte(ieee_double[2]));
                return;
            } else if ((unpackedReal[5] & 4L) != 0L) {
                outputValue = (unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_double[13]) : this.convertToByte(ieee_double[12])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_double[11]) : this.convertToByte(ieee_double[10]));
                return;
            } else {
                if ((unpackedReal[5] & 8L) == 0L) return;
                outputValue = (options & 0x10) != 0 ? this.convertToByte(ieee_double[1]) : this.convertToByte(ieee_double[0]);
            }
            return;
        } else {
            int roundBitPos = (int)(unpackedReal[0] - 2147482574L);
            if (roundBitPos < 0) {
                roundBitPos = 0;
            } else if (roundBitPos > 53) {
                roundBitPos = 53;
            }
            this.round(unpackedReal, roundBitPos, options);
            if (unpackedReal[0] < 2147482627L) {
                if (unpackedReal[0] < 2147482575L) {
                    outputValue = (unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_double[5]) : this.convertToByte(ieee_double[4])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_double[3]) : this.convertToByte(ieee_double[2]));
                    if ((options & 0x20) == 0) return;
                }
                int i = (int)(64L - (unpackedReal[0] - 2147482574L));
                if (i > 31) {
                    unpackedReal[2] = unpackedReal[1] >> (i -= 32);
                    unpackedReal[1] = 0L;
                } else {
                    unpackedReal[2] = unpackedReal[2] >> i;
                    unpackedReal[2] = unpackedReal[2] | unpackedReal[1] << 32 - i;
                    unpackedReal[2] = unpackedReal[2] & 0xFFFFFFFFL;
                    unpackedReal[1] = unpackedReal[1] >> i;
                }
                unpackedReal[1] = (unpackedReal[1] | unpackedReal[5] << 31) & 0xFFFFFFFFL;
                if (this.localRepBigEndian()) {
                    if ((options & 0x10) != 0) {
                        unpackedReal[0] = unpackedReal[1];
                        unpackedReal[1] = unpackedReal[2];
                    } else {
                        unpackedReal[0] = unpackedReal[2];
                    }
                } else if ((options & 0x10) != 0) {
                    unpackedReal[0] = this.shuffleBytes(unpackedReal[1]);
                    unpackedReal[1] = this.shuffleBytes(unpackedReal[2]);
                } else {
                    unpackedReal[0] = unpackedReal[2];
                }
                byte[] tempBytes = this.convertToByte(unpackedReal[0]);
                i = 0;
                while (i < 4) {
                    ++i;
                }
                outputValue[i] = tempBytes[4 + i];
                tempBytes = this.convertToByte(unpackedReal[1]);
                i = 4;
                while (i < 8) {
                    ++i;
                }
                outputValue[i] = tempBytes[i];
                return;
            } else if (unpackedReal[0] > 0x80000400L) {
                outputValue = (options & 2) != 0 ? ((unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_double[9]) : this.convertToByte(ieee_double[8])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_double[7]) : this.convertToByte(ieee_double[6]))) : ((options & 4) != 0 && (unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_double[9]) : this.convertToByte(ieee_double[8])) : ((options & 8) != 0 && (unpackedReal[5] & 1L) == 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_double[7]) : this.convertToByte(ieee_double[6])) : ((unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_double[13]) : this.convertToByte(ieee_double[12])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_double[11]) : this.convertToByte(ieee_double[10])))));
                return;
            } else {
                unpackedReal[0] = unpackedReal[0] - 2147482626L;
                unpackedReal[2] = unpackedReal[2] >> 11;
                unpackedReal[2] = (unpackedReal[2] | unpackedReal[1] << 21) & 0xFFFFFFFFL;
                unpackedReal[1] = unpackedReal[1] >> 11;
                unpackedReal[1] = unpackedReal[1] & 0xFFFFFL;
                unpackedReal[1] = unpackedReal[1] | unpackedReal[0] << 20;
                unpackedReal[1] = unpackedReal[1] | unpackedReal[5] << 31;
                unpackedReal[1] = unpackedReal[1] & 0xFFFFFFFFL;
                if (this.localRepBigEndian()) {
                    if ((options & 0x10) != 0) {
                        unpackedReal[0] = unpackedReal[1];
                        unpackedReal[1] = unpackedReal[2];
                    } else {
                        unpackedReal[0] = unpackedReal[2];
                    }
                } else if ((options & 0x10) != 0) {
                    unpackedReal[0] = this.shuffleBytes(unpackedReal[1]);
                    unpackedReal[1] = this.shuffleBytes(unpackedReal[2]);
                } else {
                    unpackedReal[0] = unpackedReal[2];
                }
                byte[] tempBytes = this.convertToByte(unpackedReal[0]);
                int i = 0;
                while (i < 4) {
                    outputValue[i] = tempBytes[4 + i];
                    ++i;
                }
                tempBytes = this.convertToByte(unpackedReal[1]);
                i = 4;
                while (i < 8) {
                    outputValue[i] = tempBytes[i];
                    ++i;
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void convertUnpackedRealToIEEEFloat(long[] unpackedReal, byte[] byArray, int options) {
        byte[] outputValue;
        if ((unpackedReal[5] & 0xEL) != 0L) {
            if ((unpackedReal[5] & 2L) != 0L) {
                outputValue = (unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_single[5]) : this.convertToByte(ieee_single[4])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_single[3]) : this.convertToByte(ieee_single[2]));
                return;
            } else if ((unpackedReal[5] & 4L) != 0L) {
                outputValue = (unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_single[13]) : this.convertToByte(ieee_single[12])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_single[11]) : this.convertToByte(ieee_single[10]));
                return;
            } else {
                if ((unpackedReal[5] & 8L) == 0L) return;
                outputValue = (options & 0x10) != 0 ? this.convertToByte(ieee_single[1]) : this.convertToByte(ieee_single[0]);
            }
            return;
        } else {
            int roundBitPos = (int)(unpackedReal[0] - 2147483499L);
            if (roundBitPos < 0) {
                roundBitPos = 0;
            } else if (roundBitPos > 24) {
                roundBitPos = 24;
            }
            this.round(unpackedReal, roundBitPos, options);
            if (unpackedReal[0] < 2147483523L) {
                if (unpackedReal[0] < 2147483500L) {
                    outputValue = (unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_single[5]) : this.convertToByte(ieee_single[4])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_single[3]) : this.convertToByte(ieee_single[2]));
                    if ((options & 0x20) == 0) return;
                }
                int i = (int)(32L - unpackedReal[0] - 2147483499L);
                unpackedReal[1] = unpackedReal[1] >> i;
                unpackedReal[1] = unpackedReal[1] | unpackedReal[5] << 31 & 0xFFFFFFFFL;
                if ((options & 0x10) != 0) {
                    unpackedReal[0] = this.shuffleBytes(unpackedReal[1]);
                    byte[] tempBytes = this.convertToByte(unpackedReal[0]);
                    i = 0;
                    while (i < 4) {
                        outputValue[i] = tempBytes[4 + i];
                        ++i;
                    }
                    return;
                } else {
                    byte[] tempBytes = this.convertToByte(unpackedReal[1]);
                    i = 0;
                    while (i < 4) {
                        outputValue[i] = tempBytes[4 + i];
                        ++i;
                    }
                }
                return;
            } else if (unpackedReal[0] > 0x80000080L) {
                outputValue = (options & 2) != 0 ? ((unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_single[9]) : this.convertToByte(ieee_single[8])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_single[7]) : this.convertToByte(ieee_single[6]))) : ((options & 4) != 0 && (unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_single[9]) : this.convertToByte(ieee_single[8])) : ((options & 8) != 0 && (unpackedReal[5] & 1L) == 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_single[7]) : this.convertToByte(ieee_single[6])) : ((unpackedReal[5] & 1L) != 0L ? ((options & 0x10) != 0 ? this.convertToByte(ieee_single[13]) : this.convertToByte(ieee_single[12])) : ((options & 0x10) != 0 ? this.convertToByte(ieee_single[11]) : this.convertToByte(ieee_single[10])))));
                return;
            } else {
                unpackedReal[0] = unpackedReal[0] - 2147483522L;
                unpackedReal[1] = unpackedReal[1] >> 8;
                unpackedReal[1] = unpackedReal[1] & 0x7FFFFFL;
                unpackedReal[1] = unpackedReal[1] | unpackedReal[0] << 23 & 0xFFFFFFFFL;
                unpackedReal[1] = unpackedReal[1] | unpackedReal[5] << 31 & 0xFFFFFFFFL;
                if (this.localRepBigEndian()) {
                    byte[] tempBytes = this.convertToByte(unpackedReal[1]);
                    int i = 0;
                    while (i < 4) {
                        outputValue[i] = tempBytes[4 + i];
                        ++i;
                    }
                    return;
                } else if ((options & 0x10) != 0) {
                    unpackedReal[0] = this.shuffleBytes(unpackedReal[1]);
                    byte[] tempBytes = this.convertToByte(unpackedReal[0]);
                    int i = 0;
                    while (i < 4) {
                        outputValue[i] = tempBytes[5];
                        ++i;
                    }
                    return;
                } else {
                    byte[] tempBytes = this.convertToByte(unpackedReal[1]);
                    int i = 0;
                    while (i < 4) {
                        outputValue[i] = tempBytes[5];
                        ++i;
                    }
                }
            }
        }
        return;
    }

    private void endianswap(byte[] buffer) {
        if (this.remoteCobolEndian_ == 1) {
            int leftSide = 0;
            int rightSide = buffer.length - 1;
            while (leftSide < rightSide) {
                byte b = buffer[leftSide];
                buffer[leftSide] = buffer[rightSide];
                buffer[rightSide] = b;
                ++leftSide;
                --rightSide;
            }
        }
    }

    private void endianSwapForce(byte[] buffer) {
        int leftSide = 0;
        int rightSide = buffer.length - 1;
        while (leftSide < rightSide) {
            byte b = buffer[leftSide];
            buffer[leftSide] = buffer[rightSide];
            buffer[rightSide] = b;
            ++leftSide;
            --rightSide;
        }
    }

    private byte[] fixInDBCS(byte[] cobolBuffer, int cobolSize) {
        byte[] tmpCobol = new byte[cobolSize * 3];
        byte[] spaceBuffer = this.charConverter.iconvToHost(new String(" "));
        byte spaceChar = spaceBuffer[0];
        boolean firstChar = true;
        boolean outputDBCS = true;
        int k = 0;
        int j = 0;
        while (k < cobolSize) {
            block24: {
                block20: {
                    block21: {
                        block23: {
                            block22: {
                                if (!outputDBCS) break block20;
                                if (cobolBuffer[k] != spaceChar) break block21;
                                if (cobolBuffer[k + 1] != spaceChar) break block22;
                                if (!firstChar && spaceChar == 64) {
                                    tmpCobol[j++] = 15;
                                }
                                tmpCobol[j] = spaceChar;
                                if (spaceChar == 64) {
                                    outputDBCS = false;
                                }
                                ++k;
                                break block23;
                            }
                            if (firstChar && spaceChar == 64) {
                                tmpCobol[j++] = 14;
                            }
                            tmpCobol[j++] = cobolBuffer[k++];
                            if (k == cobolSize) break block24;
                            tmpCobol[j] = cobolBuffer[k];
                        }
                        firstChar = false;
                        break block24;
                    }
                    if (cobolBuffer[k] == 14) {
                        throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0248E"));
                    }
                    if (cobolBuffer[k] == 15) {
                        throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0248E"));
                    }
                    if (firstChar && spaceChar == 64) {
                        tmpCobol[j++] = 14;
                    }
                    firstChar = false;
                    tmpCobol[j++] = cobolBuffer[k++];
                    tmpCobol[j] = cobolBuffer[k];
                    break block24;
                }
                if (cobolBuffer[k] == spaceChar) {
                    if (cobolBuffer[k + 1] == spaceChar) {
                        tmpCobol[j] = spaceChar;
                        ++k;
                    } else {
                        if (spaceChar == 64) {
                            tmpCobol[j++] = 14;
                        }
                        tmpCobol[j++] = cobolBuffer[k++];
                        if (k != cobolSize) {
                            tmpCobol[j] = cobolBuffer[k];
                            outputDBCS = true;
                        }
                    }
                } else {
                    if (cobolBuffer[k] == 15) {
                        throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0248E"));
                    }
                    if (spaceChar == 64) {
                        tmpCobol[j++] = 14;
                    }
                    tmpCobol[j++] = cobolBuffer[k++];
                    if (k != cobolSize) {
                        tmpCobol[j] = cobolBuffer[k];
                        outputDBCS = true;
                    }
                }
            }
            ++k;
            ++j;
        }
        if (outputDBCS && spaceChar == 64) {
            tmpCobol[j++] = 15;
        }
        byte[] returnCobol = new byte[j];
        int i = 0;
        while (i < j) {
            returnCobol[i] = tmpCobol[i];
            ++i;
        }
        return returnCobol;
    }

    private byte[] fixOutDBCS(byte[] cobolBuffer, int properCobolSize) {
        boolean inputInDBCS = false;
        byte[] newCobolBuffer = new byte[properCobolSize];
        byte[] spaceBuffer = this.charConverter.iconvToHost(new String(" "));
        byte spaceChar = spaceBuffer[0];
        int inputCobolSize = cobolBuffer.length;
        int i = 0;
        int j = 0;
        while (i < inputCobolSize && j < newCobolBuffer.length) {
            if (inputInDBCS) {
                if (cobolBuffer[i] == 14) {
                    --j;
                } else if (cobolBuffer[i] == 15) {
                    if (i + 1 < inputCobolSize) {
                        if (cobolBuffer[i + 1] != spaceChar) {
                            throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0219E"));
                        }
                        if (j + 1 >= newCobolBuffer.length) {
                            throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
                        }
                        newCobolBuffer[j++] = spaceChar;
                        newCobolBuffer[j] = cobolBuffer[++i];
                        inputInDBCS = false;
                    }
                } else if (cobolBuffer[i] == spaceChar) {
                    inputInDBCS = false;
                    if (j + 1 >= newCobolBuffer.length) {
                        throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
                    }
                    newCobolBuffer[j++] = spaceChar;
                    newCobolBuffer[j] = cobolBuffer[i];
                } else {
                    if (j + 1 >= newCobolBuffer.length) {
                        throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
                    }
                    newCobolBuffer[j++] = cobolBuffer[i++];
                    newCobolBuffer[j] = cobolBuffer[i];
                }
            } else if (cobolBuffer[i] == 14) {
                --j;
                inputInDBCS = true;
            } else if (cobolBuffer[i] == spaceChar) {
                if (j + 1 >= newCobolBuffer.length) {
                    throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
                }
                newCobolBuffer[j++] = spaceChar;
                newCobolBuffer[j] = cobolBuffer[i];
            } else if (spaceChar == 32) {
                if (j + 1 >= newCobolBuffer.length) {
                    throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0218E"));
                }
                newCobolBuffer[j++] = cobolBuffer[i++];
                newCobolBuffer[j] = cobolBuffer[i];
            } else {
                throw new DBCSConversionException(CobolRecordResource.instance().getString("IVJC0219E"));
            }
            ++i;
            ++j;
        }
        return newCobolBuffer;
    }

    public String getCodePage() {
        return this.codePage_;
    }

    public int getCompiler() {
        return this.cobolCompiler_;
    }

    public int getEndian() {
        return this.remoteCobolEndian_;
    }

    public int getFloatingPointFormat() {
        return this.floatingPointFormat_;
    }

    public int getMachine() {
        return this.cobolMachine_;
    }

    public int getRemoteIntEndian() {
        return this.remoteIntEndian_;
    }

    private void intNtsToPackedDecimal(char[] sb, byte[] tb, boolean aSign) {
        int si = sb.length - 1;
        tb[tb.length - 1] = (byte)(Character.digit(sb[si], 16) << 4);
        tb[tb.length - 1] = aSign ? (sb[0] == '-' ? (byte)(tb[tb.length - 1] | this.PACKED_NEGOR) : (byte)(tb[tb.length - 1] | this.PACKED_POSOR)) : (byte)(tb[tb.length - 1] | this.PACKED_NOSIGN);
        --si;
        int i = tb.length - 2;
        while (i >= 0) {
            tb[i] = (byte)Character.digit(sb[si], 16);
            if (sb[--si] != '-' && sb[si] != '+') {
                tb[i] = (byte)(tb[i] | Character.digit(sb[si], 16) << 4);
                --si;
            }
            --i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void intNtsToSignLeading(char[] sb, byte[] tb, boolean hasSign) {
        block2: {
            tb[0] = sb[0] == '-' ? (byte)(this.NEGOR | (byte)Character.digit(sb[1], 16)) : (byte)(this.POSOR | (byte)Character.digit(sb[1], 16));
            si = sb.length - 1;
            ti = tb.length - 1;
            if (!hasSign) ** GOTO lbl14
            while (si > 1 && ti > 0) {
                tb[ti] = (byte)(this.ZERO_PAD | (byte)Character.digit(sb[si], 16));
                --si;
                --ti;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                tb[ti] = (byte)(this.ZERO_PAD_STR | (byte)Character.digit(sb[si], 16));
                --si;
                --ti;
lbl14:
                // 2 sources

                ** while (si > 1 && ti > 0)
            }
        }
    }

    private void intNtsToSignLeadingSeparate(char[] sb, byte[] tb) {
        tb[0] = sb[0] == '+' ? this.PLUS_SIGN_STR : this.NEGATIVE_SIGN_STR;
        int si = sb.length - 1;
        int ti = tb.length - 1;
        while (ti > 0 && si > 0) {
            tb[ti] = (byte)(Character.digit(sb[si], 16) | this.ZERO_PAD_STR);
            --si;
            --ti;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void intNtsToSignTrailing(char[] sb, byte[] tb, boolean hasSign) {
        block2: {
            ti = tb.length - 1;
            si = sb.length - 1;
            tb[ti] = hasSign ? (sb[0] == '+' ? this.POSOR : this.NEGOR) : this.ZERO_PAD_STR;
            tb[ti] = (byte)(tb[ti] + Character.digit(sb[si], 16));
            --si;
            --ti;
            if (!hasSign) ** GOTO lbl17
            while (ti >= 0) {
                tb[ti] = (byte)(Character.digit(sb[si], 16) | this.ZERO_PAD);
                --ti;
                --si;
            }
            break block2;
lbl-1000:
            // 1 sources

            {
                tb[ti] = (byte)(Character.digit(sb[si], 16) | this.ZERO_PAD_STR);
                --ti;
                --si;
lbl17:
                // 2 sources

                ** while (ti >= 0)
            }
        }
    }

    private void intNtsToSignTrailingSeparate(char[] sb, byte[] tb) {
        tb[tb.length - 1] = sb[0] == '+' ? this.PLUS_SIGN_STR : this.NEGATIVE_SIGN_STR;
        int si = sb.length - 1;
        int ti = tb.length - 2;
        while (ti >= 0) {
            tb[ti] = (byte)(Character.digit(sb[si], 16) | this.ZERO_PAD_STR);
            --si;
            --ti;
        }
        while (ti >= 0) {
            tb[ti] = this.ZERO_PAD_STR;
            --ti;
        }
    }

    private boolean localRepBigEndian() {
        return true;
    }

    private void packedDecimalToIntNts(byte[] sb, char[] tb) {
        int ti = tb.length - 1;
        int si = sb.length - 1;
        tb[ti] = Character.forDigit(sb[si] >> 4 & 0xF, 16);
        --ti;
        --si;
        while (si >= 0) {
            tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            tb[--ti] = Character.forDigit(sb[si] >> 4 & 0xF, 16);
            --ti;
            --si;
        }
        tb[0] = (sb[sb.length - 1] & 0xF) == this.PACKED_NEGOR ? 45 : 43;
        while (ti > 0) {
            tb[ti] = Character.forDigit(0, 16);
            --ti;
        }
    }

    private void printBuffer(byte[] buffer) {
        int i = 0;
        while (i < buffer.length) {
            int j = (buffer[i] & 0xF0) >> 4;
            int k = buffer[i] & 0xF;
            System.out.print(Integer.toString(j, 16));
            System.out.print(Integer.toString(k, 16));
            System.out.print(" ");
            ++i;
        }
        System.out.println();
    }

    private void printByte(byte b) {
        int j = (b & 0xF0) >> 4;
        int k = b & 0xF;
        System.out.print(Integer.toString(j, 16));
        System.out.print(Integer.toString(k, 16));
    }

    private void printDebug(String s) {
        System.out.println(s);
    }

    private void printDescriptor() {
        System.out.println("cobolDataType :" + this.cobolDataType);
        System.out.println("sign :" + this.sign);
        System.out.println("decimal :" + this.decimal);
        System.out.println("numeric :" + this.numeric);
        System.out.println("numof9s :" + this.numberOfNines);
        System.out.println("decimalPos:" + this.decimalPosition);
        System.out.println("scale:" + this.scale);
        System.out.println("expandedPicField:" + this.expandedPicField);
        System.out.println("picFieldLength:" + this.picFieldLength);
        System.out.println("comment:" + this.comment);
        System.out.println("align:" + this.align);
    }

    private boolean remoteRepBigEndian() {
        return this.remoteCobolEndian_ == 0;
    }

    private void round(long[] unpackedReal, int roundBitPos, int options) {
        if ((options & 2) == 0) {
            int i = (roundBitPos >> 5) + 1;
            int bitMask = 1 << 31 - (roundBitPos & 0x1F);
            long roundup = 0L;
            byte[] tempIntByte = new byte[4];
            byte[] unpackedRealBytes = this.convertToByte(unpackedReal[i]);
            int j = 0;
            while (j < 4) {
                tempIntByte[j] = unpackedRealBytes[4 + j];
                ++j;
            }
            int tempInt = this.convertFromByteToInt(tempIntByte);
            switch (tempInt & bitMask) {
                case 0: {
                    if ((options & 1) != 0) break;
                }
                default: {
                    long moreBits = unpackedReal[i] & (long)(bitMask - 1);
                    if (moreBits == 0L) {
                        switch (i) {
                            case 1: {
                                moreBits = unpackedReal[2];
                            }
                            case 2: {
                                moreBits |= unpackedReal[3];
                            }
                            case 3: {
                                moreBits |= unpackedReal[4];
                            }
                        }
                    }
                    if ((options & 1) != 0) {
                        roundup = moreBits;
                        if (roundup != 0L) break;
                        if (bitMask << 1 != 0) {
                            roundup = unpackedReal[i] & (long)(bitMask << 1);
                            break;
                        }
                        if (i == 1) break;
                        roundup = unpackedReal[i - 1] & 1L;
                        break;
                    }
                    if ((options & 4) != 0) {
                        if ((unpackedReal[5] & 1L) != 0L) break;
                        roundup = unpackedReal[i] & (long)bitMask | moreBits;
                        break;
                    }
                    if ((unpackedReal[5] & 1L) == 0L) break;
                    roundup = unpackedReal[i] & (long)bitMask | moreBits;
                }
            }
            if (roundup != 0L) {
                unpackedReal[i] = (unpackedReal[i] & (long)(~((bitMask <<= 1) - 1))) + (long)bitMask;
                while (unpackedReal[i] == 0L) {
                    int n = --i;
                    unpackedReal[n] = unpackedReal[n] + 1L;
                }
                if (i == 0) {
                    unpackedReal[1] = 0x80000000L;
                }
            }
        }
    }

    private int rpc_hyper_2c_to_int_nts(byte[] sb, char[] tb) {
        byte[] temp = new byte[8];
        int i = 0;
        i = sb.length - 1;
        while (i >= 0) {
            temp[8 - (sb.length - i)] = sb[i];
            --i;
        }
        if ((sb[0] & 0xFFFFFF80) != 0) {
            i = 0;
            while (i < 8 - sb.length) {
                temp[i] = -1;
                ++i;
            }
            this.rpc_hyper_negate8(temp);
        }
        i = tb.length - 1;
        while (i > 0) {
            tb[i] = Character.forDigit(this.rpc_hyper_mod10(temp), 16);
            this.rpc_hyper_div10(temp);
            --i;
        }
        i = 0;
        while (i < 8) {
            if (temp[i] != 0) {
                return -1;
            }
            ++i;
        }
        tb[0] = (sb[0] & 0x80) != 0 ? 45 : 43;
        return 0;
    }

    private void rpc_hyper_add(byte[] buffer, char value) {
        byte[] temp = new byte[8];
        temp[7] = (byte)(Character.digit(value, 16) & 0xFF);
        this.rpc_hyper_add8(buffer, temp);
    }

    private void rpc_hyper_add8(byte[] tb, byte[] sb) {
        int carry = 0;
        int i = 7;
        while (i >= 0) {
            int temp = (tb[i] & 0xFF) + (sb[i] & 0xFF) + carry;
            tb[i] = (byte)(temp % 256 & 0xFF);
            carry = temp / 256;
            --i;
        }
    }

    private void rpc_hyper_div10(byte[] buffer) {
        this.rpc_hyper_div8(buffer, buffer, 10);
    }

    private void rpc_hyper_div8(byte[] tb, byte[] sb, int value) {
        int oldCarry = 0;
        int newCarry = 0;
        int i = 0;
        while (i < 8) {
            newCarry = ((sb[i] & 0xFF) + oldCarry) % value * 256;
            tb[i] = (byte)(((sb[i] & 0xFF) + oldCarry) / value);
            oldCarry = newCarry;
            byte cfr_ignored_0 = (byte)((newCarry & 0xFF00) >> 8);
            byte cfr_ignored_1 = (byte)(newCarry & 0xFF);
            ++i;
        }
    }

    private int rpc_hyper_mod10(byte[] buffer) {
        byte[] temp = new byte[8];
        this.rpc_hyper_div8(temp, buffer, 10);
        this.rpc_hyper_mult10(temp);
        this.rpc_hyper_negate8(temp);
        this.rpc_hyper_add8(temp, buffer);
        return temp[7];
    }

    private void rpc_hyper_mult10(byte[] buffer) {
        byte[] temp = new byte[8];
        this.rpc_hyper_shl8(temp, buffer, 1);
        this.rpc_hyper_shl8(buffer, buffer, 3);
        this.rpc_hyper_add8(buffer, temp);
    }

    private void rpc_hyper_negate8(byte[] buffer) {
        int i = 0;
        while (i < 8) {
            buffer[i] = (byte)(255 - buffer[i]);
            ++i;
        }
        this.rpc_hyper_add(buffer, Character.forDigit(1, 16));
    }

    private void rpc_hyper_shl8(byte[] tb, byte[] sb, int value) {
        int oldCarry = 0;
        int newCarry = 0;
        int i = 7;
        while (i >= 0) {
            newCarry = (sb[i] & 0xFF) >> 8 - value;
            int temp = ((sb[i] & 0xFF) << value) + oldCarry;
            byte[] tempByte = this.convertToByte(temp);
            tb[i] = tempByte[3];
            oldCarry = newCarry;
            --i;
        }
    }

    private int rpc_int_nts_to_hyper_2c(char[] sb, byte[] tb) {
        int i = 0;
        byte[] temp = new byte[8];
        if (sb[0] == '-' || sb[0] == '+') {
            ++i;
        }
        this.rpc_hyper_add(temp, sb[i]);
        ++i;
        while (i < sb.length) {
            this.rpc_hyper_mult10(temp);
            this.rpc_hyper_add(temp, sb[i]);
            ++i;
        }
        if (sb[0] == '-') {
            this.rpc_hyper_negate8(temp);
        }
        i = tb.length - 1;
        while (i >= 0) {
            tb[i] = temp[8 - (tb.length - i)];
            --i;
        }
        i = 0;
        while (i < 8 - tb.length) {
            if (sb[0] == '-' ? temp[i] != -1 : temp[i] != 0) {
                return -1;
            }
            ++i;
        }
        return 0;
    }

    public void setCodePage(String aCodePage) {
        this.codePage_ = aCodePage;
        this.charConverter = new CobolIconvHost(aCodePage);
        try {
            String tmp = new String("-");
            this.NEGATIVE_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "+";
            this.PLUS_SIGN_STR = tmp.getBytes(this.codePage_)[0];
            tmp = "0";
            this.ZERO_PAD_STR = tmp.getBytes(this.codePage_)[0];
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            throw new CodePageConversionException(CobolRecordResource.instance().getString("IVJC0217E", this.codePage_));
        }
    }

    public void setCompiler(int aCompiler) {
        this.cobolCompiler_ = aCompiler;
    }

    public void setEndian(int aEndian) {
        this.remoteCobolEndian_ = aEndian;
    }

    public void setFloatingPointFormat(int aFpRep) {
        this.floatingPointFormat_ = aFpRep;
    }

    public void setMachine(int aMachine) {
        this.cobolMachine_ = aMachine;
        if (this.cobolMachine_ == 1) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else if (this.cobolMachine_ == 0) {
            this.NEGOR = (byte)-48;
            this.POSOR = (byte)-64;
            this.PLUS_SIGN = (byte)78;
            this.NEGATIVE_SIGN = (byte)96;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)-16;
        } else if (this.cobolMachine_ == 2) {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        } else {
            this.NEGOR = (byte)112;
            this.POSOR = (byte)48;
            this.PLUS_SIGN = (byte)43;
            this.NEGATIVE_SIGN = (byte)45;
            this.PACKED_NEGOR = (byte)13;
            this.PACKED_POSOR = (byte)12;
            this.PACKED_NOSIGN = (byte)15;
            this.ZERO_PAD = (byte)48;
        }
    }

    public void setRemoteIntEndian(int aRemoteIntEndian) {
        this.remoteIntEndian_ = aRemoteIntEndian;
    }

    private long shuffleBytes(long l) {
        long temp = l << 24 & 0xFFFFFFFFL;
        temp |= l >> 24;
        temp |= l << 8 & 0xFF0000L;
        return temp |= l >> 8 & 0xFF00L;
    }

    private void signLeadingSeparateToIntNts(byte[] sb, char[] tb) {
        tb[0] = sb[0] == this.PLUS_SIGN_STR ? 43 : 45;
        int ti = tb.length - 1;
        int si = sb.length - 1;
        while (si > 0 && ti > 0) {
            tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            --si;
            --ti;
        }
        while (ti > 0) {
            tb[ti] = 48;
            --ti;
        }
    }

    private void signLeadingToIntNts(byte[] sb, char[] tb) {
        tb[0] = (byte)(sb[0] & 0xF0) == this.NEGOR ? 45 : 43;
        int ti = tb.length - 1;
        int si = sb.length - 1;
        while (si >= 0) {
            tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            --ti;
            --si;
        }
        while (ti > 0) {
            tb[ti] = Character.forDigit(0, 16);
            --ti;
        }
    }

    private void signTrailingSeparateToIntNts(byte[] sb, char[] tb) {
        int si = sb.length - 1;
        int ti = tb.length - 1;
        tb[0] = sb[si] == this.PLUS_SIGN_STR ? 43 : 45;
        --si;
        while (ti > 0 && si >= 0) {
            tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            --si;
            --ti;
        }
        while (ti > 0) {
            tb[ti] = 48;
            --ti;
        }
    }

    private void signTrailingToIntNts(byte[] sb, char[] tb) {
        tb[0] = (byte)(sb[sb.length - 1] & 0xF0) == this.NEGOR ? 45 : 43;
        int si = sb.length - 1;
        int ti = tb.length - 1;
        while (si >= 0) {
            tb[ti] = Character.forDigit(sb[si] & 0xF, 16);
            --ti;
            --si;
        }
        while (ti > 0) {
            tb[ti] = 48;
            --ti;
        }
    }

    protected int sizeOfCobol() {
        int length;
        switch (this.cobolDataType) {
            case 4: 
            case 5: 
            case 8: {
                length = this.numberOfNines;
                break;
            }
            case 6: 
            case 7: {
                if (this.sign) {
                    length = this.numberOfNines + 1;
                    break;
                }
                length = this.numberOfNines;
                break;
            }
            case 0: {
                if (this.numberOfNines > 9) {
                    length = 8;
                    break;
                }
                if (this.numberOfNines > 4) {
                    length = 4;
                    break;
                }
                length = 2;
                break;
            }
            case 1: {
                length = 4;
                break;
            }
            case 2: {
                length = 8;
                break;
            }
            case 3: {
                length = this.numberOfNines / 2 + 1;
                break;
            }
            case 9: {
                length = this.picFieldLength;
                break;
            }
            default: {
                length = -1;
            }
        }
        return length;
    }

    protected int sizeOfJava(int javaType, int cobolLength) {
        int size;
        switch (javaType) {
            case 0: 
            case 3: {
                size = 2;
                break;
            }
            case 2: {
                size = 1;
                break;
            }
            case 4: {
                size = 4;
                break;
            }
            case 5: {
                size = 8;
                break;
            }
            case 6: {
                size = 4;
                break;
            }
            case 7: {
                size = 8;
                break;
            }
            case 8: {
                if (this.insideDBCS) {
                    size = cobolLength;
                    break;
                }
                size = this.stringSize(cobolLength);
                break;
            }
            default: {
                size = 0;
            }
        }
        return size;
    }

    private int stringSize(int stringLength) {
        return 2 * stringLength;
    }

    protected void updateCicsDataDescriptor(int aCobolDataType, int aNumberNines, int aPicFieldLength, boolean aSign, boolean aDecimal, boolean aNumeric, int aDecPos, int aScale, String aExpandedPicField, boolean aInsideDBCS) {
        this.cobolDataType = aCobolDataType;
        this.numberOfNines = aNumberNines;
        this.picFieldLength = aPicFieldLength;
        this.sign = aSign;
        this.decimal = aDecimal;
        this.numeric = aNumeric;
        this.decimalPosition = aDecPos;
        this.scale = aScale;
        this.expandedPicField = aExpandedPicField;
        this.comment = new StringBuffer();
        this.insideDBCS = aInsideDBCS;
    }

    private int xtr_char_fla_to_char_fla(byte[] sb, byte[] tb) {
        int i = 0;
        while (i < sb.length) {
            tb[i] = sb[i];
            ++i;
        }
        return 0;
    }

    private void xtr_int_2c_to_int_2c(byte[] sb, byte[] tb) {
        int filler = 0;
        int i = tb.length - 1;
        while (i >= 0 && sb.length - (tb.length - i) >= 0) {
            tb[i] = sb[sb.length - (tb.length - i)];
            --i;
        }
        if (i >= 0) {
            if ((sb[0] & 0x80) != 0) {
                filler = -1;
            }
            while (i >= 0) {
                tb[i--] = filler;
            }
        }
    }

    private int xtr_int_2c_to_int_nts(byte[] sb, char[] tb) {
        return this.rpc_hyper_2c_to_int_nts(sb, tb);
    }

    private double xtr_int_2c_to_real_double(byte[] sb) {
        double temp = 0.0;
        byte[] tmp = new byte[2];
        tmp[0] = 0;
        int i = 0;
        while (i < sb.length) {
            tmp[1] = sb[i];
            short tmp2 = this.convertFromByteToShort(tmp);
            temp = (byte)(sb[0] & 0x80) != 0 ? temp * 256.0 + (double)(255 - tmp2) : temp * 256.0 + (double)tmp2;
            ++i;
        }
        if ((byte)(sb[0] & 0x80) != 0) {
            temp = (temp + 1.0) * -1.0;
        }
        return temp;
    }

    private float xtr_int_2c_to_real_fp(byte[] sb) {
        float temp = 0.0f;
        int i = 0;
        while (i < sb.length) {
            temp = (sb[0] & 0x80) != 0 ? temp * 256.0f + (float)(255 - sb[i]) : temp * 256.0f + (float)sb[i];
            ++i;
        }
        if ((sb[0] & 0x80) != 0) {
            temp = (temp + 1.0f) * -1.0f;
        }
        return temp;
    }

    private int xtr_int_nts_to_int_2c(char[] sb, byte[] tb) {
        return this.rpc_int_nts_to_hyper_2c(sb, tb);
    }

    private double xtr_int_nts_to_real_double(char[] sb) {
        int i = 0;
        double tdouble = 0.0;
        if (sb[0] == '+' || sb[0] == '-') {
            ++i;
        }
        while (i < sb.length) {
            tdouble = tdouble * 10.0 + (double)Character.digit(sb[i], 16);
            ++i;
        }
        if (sb[0] == '-') {
            tdouble *= -1.0;
        }
        return tdouble;
    }

    private float xtr_int_nts_to_real_fp(char[] sb) {
        int i = 0;
        float tfloat = 0.0f;
        if (sb[0] == '+' || sb[0] == '-') {
            ++i;
        }
        while (i < sb.length) {
            tfloat = tfloat * 10.0f + (float)Character.digit(sb[i], 16);
            ++i;
        }
        if (sb[0] == '-') {
            tfloat *= -1.0f;
        }
        return tfloat;
    }

    private int xtr_real_fp_to_int_2c(byte[] sb, byte[] tb) {
        char[] temp = new char[20];
        double f = this.convertFromByteToDouble(sb);
        int rc = this.xtr_real_fp_to_int_nts(f, temp);
        if (rc != 0) {
            return rc;
        }
        rc = this.xtr_int_nts_to_int_2c(temp, tb);
        return rc;
    }

    private int xtr_real_fp_to_int_nts(double d, char[] tb) {
        double sdouble;
        if (d < 0.0) {
            tb[0] = 45;
            sdouble = d * -1.0;
        } else {
            tb[0] = 43;
        }
        sdouble += 0.5;
        int i = 1;
        while (i < tb.length) {
            int t = (int)(sdouble / Math.pow(10.0, tb.length - i - 1));
            if (t > 9) {
                return -1;
            }
            tb[i] = Character.forDigit(t, 16);
            sdouble -= (double)t * Math.pow(10.0, tb.length - i - 1);
            ++i;
        }
        return 0;
    }

    private int xtr_real_fp_to_int_nts(float f, char[] tb) {
        float sfloat;
        if ((double)f < 0.0) {
            tb[0] = 45;
            sfloat = f * -1.0f;
        } else {
            tb[0] = 43;
        }
        sfloat += 0.5f;
        int i = 1;
        while (i < tb.length) {
            int t = (int)((double)sfloat / Math.pow(10.0, tb.length - i - 1));
            if (t > 9) {
                return -1;
            }
            tb[i] = Character.forDigit(t, 16);
            sfloat = (float)((double)sfloat - (double)t * Math.pow(10.0, tb.length - i - 1));
            ++i;
        }
        return 0;
    }

    private void xtr_real_fp_to_real_fp(byte[] sb, byte[] tb) {
        if (tb.length != sb.length) {
            return;
        }
        int i = 0;
        while (i < sb.length) {
            tb[i] = sb[i];
            ++i;
        }
    }
}

