VERSION 5.00
Begin VB.Form vbVideo 
   BackColor       =   &H00C0C0FF&
   Caption         =   "Sample Media Screen"
   ClientHeight    =   4215
   ClientLeft      =   60
   ClientTop       =   345
   ClientWidth     =   3720
   Icon            =   "vbVideo.frx":0000
   LinkTopic       =   "Form2"
   ScaleHeight     =   4215
   ScaleWidth      =   3720
   StartUpPosition =   3  'Windows Default
   Begin VB.Timer Timer1 
      Interval        =   500
      Left            =   885
      Top             =   3630
   End
   Begin VB.Frame Frame1 
      BackColor       =   &H00C0C0FF&
      Height          =   2655
      Left            =   120
      TabIndex        =   3
      ToolTipText     =   "Video/audio clip"
      Top             =   615
      Width           =   3390
   End
   Begin VB.CommandButton cmdClose 
      Cancel          =   -1  'True
      Caption         =   "Close"
      Height          =   450
      Left            =   2640
      TabIndex        =   2
      ToolTipText     =   "Close window"
      Top             =   120
      Width           =   855
   End
   Begin VB.CommandButton cmdStop 
      Caption         =   "Stop"
      Height          =   435
      Left            =   960
      TabIndex        =   1
      ToolTipText     =   "Stop and rewind"
      Top             =   120
      Width           =   855
   End
   Begin VB.CommandButton cmdPlay 
      Caption         =   "Play"
      Height          =   435
      Left            =   120
      TabIndex        =   0
      ToolTipText     =   "Toggle Play and Pause"
      Top             =   120
      Width           =   855
   End
   Begin VB.Label lblCurrent 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0:0:0"
      ForeColor       =   &H0000FF00&
      Height          =   225
      Left            =   1785
      TabIndex        =   5
      ToolTipText     =   "Duration in seconds"
      Top             =   120
      Width           =   855
   End
   Begin VB.Label lblDuration 
      Alignment       =   2  'Center
      BackColor       =   &H00000000&
      BorderStyle     =   1  'Fixed Single
      Caption         =   "0:0:0"
      ForeColor       =   &H0000FF00&
      Height          =   225
      Left            =   1785
      TabIndex        =   4
      ToolTipText     =   "Duration in seconds"
      Top             =   345
      Width           =   855
   End
End
Attribute VB_Name = "vbVideo"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = False
Attribute VB_PredeclaredId = True
Attribute VB_Exposed = False
'======================================'====================================
'  THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY OF ANY
'  KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE
'  IMPLIED WARRANTIES OF MERCHANTABILITY AND/OR FITNESS FOR A PARTICULAR
'  PURPOSE.
'  Copyright (c) 1999  IBM Corporation.  All Rights Reserved.
'======================================'====================================
Option Explicit
'Reference the ISCMPlayer component object
Dim player As MPLAYERLib.ISCMPlayer
'Define minimum window dimensions
Const MinWidth As Integer = 3400
Const MinHeight As Integer = 2660
Dim localFile As Boolean
'
'InitWindow calculates the window size from the video size
'
Private Sub InitWindow()
    Dim w As Integer
    Dim h As Integer
    Dim duration As Double
    'Get the video dimensions and convert to twips
    'Allow a minimum dimension
    Call player.GetVideoSize(w, h)
    Frame1.Width = w * 16
    If (Frame1.Width < MinWidth) Then
        Frame1.Width = MinWidth
    End If
    Frame1.Height = (h * 16) + 20
    If (Frame1.Height < MinHeight) Then
        Frame1.Height = MinHeight
    End If
    'This is an audio file if video size is 0
    If (w = 0) And (h = 0) Then
        Frame1.Caption = Frame1.Caption + " Audio Clip"
    Else
        Frame1.Caption = Frame1.Caption + " Video Clip"
    End If
    vbVideo.Width = Frame1.Width + 300
    vbVideo.Height = Frame1.Height + (3 * cmdPlay.Height)
    'Tell the player where to play the video
    Call player.SetWindowPos(Me.hWnd, (Frame1.Left / 16) + 10, (Frame1.Top / 16) + 17, w, h)
    'Get the play time in seconds
    Call player.GetPlayDuration(duration)
    lblDuration.Caption = duration
    cmdPlay.Caption = "Play"
End Sub
'
'InitVideo initializes the player object with the video file
'
Public Sub InitVideo(VideoName As String)
    Dim playType As Integer

    Set player = New MPLAYERLib.ISCMPlayer
    Call player.SetMetaData(VideoName, playType)
    If playType = 0 Then 'ivs file
       Call player.Initialize(Me.hWnd, 0, 6)
       Frame1.Caption = "Streamed"
   '    Call player.Initialize(Me.hWnd, 0, 6)
    ElseIf playType = 1 Then 'local file
        Call player.Initialize(Me.hWnd, 0, 4)
        Frame1.Caption = "Local"
    End If
End Sub

Private Sub cmdClose_Click()
    Unload Me
    vbMain.Show
End Sub
'
'Toggle the Play and Pause controls
'
Private Sub cmdPlay_Click()
    If cmdPlay.Caption = "Play" Then
        Call player.Play
        cmdPlay.Caption = "Pause"
        cmdStop.Enabled = True
    Else
        Call player.Pause
        cmdPlay.Caption = "Play"
        cmdStop.Enabled = True
    End If
End Sub
'
'Stop the video. cmdPlay will rewind before playing again
'
Private Sub cmdStop_Click()
    Call player.Stop
    cmdPlay.Caption = "Play"
    cmdStop.Enabled = False
End Sub

Private Sub Form_Activate()
    'Set the window title with video file name
    vbVideo.Caption = vbMain.VideoDisplayName
    'Set ISCMPlayer reference
    InitVideo (vbMain.VideoName)
    'Set video screen size
    InitWindow
    cmdPlay.Value = True
End Sub

Private Sub Form_Load()
    'Set the video screen to the left of the screen
    vbVideo.Left = 0
    'Align the top with the main form
    vbVideo.Top = vbMain.Top
End Sub

Private Sub Form_Unload(Cancel As Integer)
    'Always clean up the player object
    Call player.Cleanup
End Sub
'
'Timer event Called every half second to update
'the playing states. Use the information to
'update our video clock and VCR toggle.
'
Private Sub Timer1_Timer()
    Dim nPlayingState As Integer
    Dim pos As Double

    Call player.UpdatePlayEvent
    Call player.GetPlayingState(nPlayingState)
    If nPlayingState <> 1 Then 'not playing
        cmdPlay.Caption = "Play"
        lblCurrent.Caption = ""
    Else
        Call player.GetCurrentPlayPosition(pos)
        lblCurrent.Caption = pos
    End If
End Sub
