package rbi.rmi.samples.atm;

import java.rmi.*;
/**
 * This type was created in VisualAge.
 */
public class BankAccountProxy {
	protected transient java.beans.PropertyChangeSupport propertyChange;
	private String fieldAccountNumber = new String();
	private String fieldAccountType = new String();
	private String fieldBalance = new String();
	private BankAccountIf bankAccount = null;
	public ATMServerProxy atmServer = null;
	private String fieldLastError = new String();
	private String fieldCustomerId = new String();
/**
 * BankAccountProxy constructor comment.
 */
public BankAccountProxy() {
	super();
}
/**
 * The addPropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void addPropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().addPropertyChangeListener(listener);
}
/**
 * The firePropertyChange method was generated to support the propertyChange field.
 */
public void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
	getPropertyChange().firePropertyChange(propertyName, oldValue, newValue);
}
/**
 * Gets the accountNumber property (java.lang.String) value.
 * @return The accountNumber property value.
 * @see #setAccountNumber
 */
public String getAccountNumber() {
	return fieldAccountNumber;
}
/**
 * Gets the accountType property (java.lang.String) value.
 * @return The accountType property value.
 * @see #setAccountType
 */
public String getAccountType() {
	try {
		return(getBankAccount().getAccountType());
	} catch (RemoteException e) {
		setLastError("ATM Error Encountered " + e);
	}
	return null;
}
/**
 * This method was created in VisualAge.
 * @return rbi.rmi.samples.atm.ATMServerProxy
 */
public ATMServerProxy getAtmServer() {
	return atmServer;
}
/**
 * Gets the balance property (java.math.BigDecimal) value.
 * @return The balance property value.
 * @see #setBalance
 */
public String getBalance() {
	try {
		return(getBankAccount().getBalance());
	} catch (RemoteException e) {
		setLastError("ATM Error Encountered " + e);
	}
	return null;
}
/**
 * This method was created in VisualAge.
 * @return rbi.rmi.samples.atm.BankAccountIf
 */
public BankAccountIf getBankAccount() {
	if (bankAccount == null) {
		try {
			setBankAccount((BankAccountIf) Naming.lookup(getAtmServer().getUrl() + "/" + getAccountNumber()));
		} catch (Exception e) {
			setLastError("ATM Error Encountered " + e);
		}
	}
	return bankAccount;
}
/**
 * Gets the customerId property (java.lang.String) value.
 * @return The customerId property value.
 * @see #setCustomerId
 */
public String getCustomerId() {
	return fieldCustomerId;
}
/**
 * Gets the lastError property (java.lang.String) value.
 * @return The lastError property value.
 * @see #setLastError
 */
public String getLastError() {
	return fieldLastError;
}
/**
 * Accessor for the propertyChange field.
 */
protected java.beans.PropertyChangeSupport getPropertyChange() {
	if (propertyChange == null) {
		propertyChange = new java.beans.PropertyChangeSupport(this);
	};
	return propertyChange;
}
/**
 * The removePropertyChangeListener method was generated to support the propertyChange field.
 */
public synchronized void removePropertyChangeListener(java.beans.PropertyChangeListener listener) {
	getPropertyChange().removePropertyChangeListener(listener);
}
/**
 * Sets the accountNumber property (java.lang.String) value.
 * @param accountNumber The new value for the property.
 * @see #getAccountNumber
 */
public void setAccountNumber(String accountNumber) {
	String oldValue = fieldAccountNumber;
	fieldAccountNumber = accountNumber;
	firePropertyChange("accountNumber", oldValue, accountNumber);
}
/**
 * Sets the accountType property (java.lang.String) value.
 * @param accountType The new value for the property.
 * @see #getAccountType
 */
public void setAccountType(String accountType) {
	String oldValue = fieldAccountType;
	fieldAccountType = accountType;
	firePropertyChange("accountType", oldValue, accountType);
}
/**
 * This method was created in VisualAge.
 * @param anAtmServer rbi.rmi.samples.atm.ATMServerProxy
 */
public void setAtmServer(ATMServerProxy anATMServer) {
	atmServer = anATMServer;
}
/**
 * Sets the balance property (java.math.BigDecimal) value.
 * @param balance The new value for the property.
 * @see #getBalance
 */
public void setBalance(String balance) {
	String oldValue = fieldBalance;
	fieldBalance = balance;
	firePropertyChange("balance", oldValue, balance);
}
/**
 * This method was created in VisualAge.
 * @param aBankAccount rbi.rmi.samples.atm.BankAccountIf
 */
public void setBankAccount(BankAccountIf aBankAccount) {
	bankAccount = aBankAccount;
}
/**
 * Sets the customerId property (java.lang.String) value.
 * @param customerId The new value for the property.
 * @see #getCustomerId
 */
public void setCustomerId(String customerId) {
	String oldValue = fieldCustomerId;
	fieldCustomerId = customerId;
	firePropertyChange("customerId", oldValue, customerId);
}
/**
 * Sets the lastError property (java.lang.String) value.
 * @param lastError The new value for the property.
 * @see #getLastError
 */
public void setLastError(String lastError) {
	String oldValue = fieldLastError;
	fieldLastError = lastError;
	firePropertyChange("lastError", oldValue, lastError);
}
/**
 * This method was created in VisualAge.
 * @param withdrawAmount java.lang.String
 */
public void withdraw(String withdrawAmount) {
	try {
		getBankAccount().withdraw(withdrawAmount);
	} catch (AccountOverdrawnException e) {
		setLastError(e.getMessage());
	} catch (RemoteException e) {
		setLastError("ATM error encountered " + e);
	}
	return;
}
}