1ER70JN: EW:ALL - FIX (ES 4.0) - EwIconArea dropped items not placed properly

Platform: ALL
Version: R4.0 MD3

Triggers:	<1EPBT6G>: EW:ALL - EwDragAndDrop - EwIconArea, Icons are not placed properly on drop
				
Prereqs: <None>

Description:
	As the button is released during a drop operation to place the item, the item is not
	dropped where the pointer is.  Instead it is dropped off to the right.

Temporary Fix: 
	File in the following code:

EwDragAndDrop becomeDefault !

!EwIconAreaTargetAdapter privateMethods !

configureForDefaultDragAndDrop
	"Set up simple handlers for the callbacks such that items can
	be moved around within this widget."

	self
		addCallback: XmNdragOverCallback
			receiver: [:targetAdapter :clientData :callData |
				callData vote: (callData sourceWidget == self widget
					ifTrue: [Array with: XmMOVE]
					ifFalse: [#()])]
			selector: #value:value:value:
			clientData: nil;
		addCallback: XmNdropCallback
			receiver: [:targetAdapter :clientData :callData |
				| delta |
				delta := callData event xRoot @ callData event yRoot
					- (targetAdapter widget translateCoords: 0@0) + targetAdapter widget visibleOrigin.
				callData sourceItems 
					with: callData offsets 					
					do: [:item :offset | 
						"The move is going to set the location of the item's icon box. 
						For label orientation of XmBOTTOM we need to take into account
						differences between the iconBox and the labelBox." 
						targetAdapter widget labelsAreToTheBottom	
							ifTrue: [
								| node offsetPt |
								node := targetAdapter widget nodeForItem: item.
								offsetPt := ((node iconBox origin x - node left) max: 0) @ 0.
								targetAdapter widget moveItem: item to: offset + delta - offsetPt]
							ifFalse:[
								targetAdapter widget moveItem: item to: offset + delta]]]
			selector: #value:value:value:
			clientData: nil! !
=======================================
