
#include <windows.h>
#include "esrc.h"
#include "esuser.h"

U_32 WindowsVersion;
static	HWND	hwndDlgBox;
static	HINSTANCE	hInstanceCur;
static	char *ES_cmdLineParams[128];
WNDPROC StaticProc;

typedef struct ENVSTRUCT {
	int		argc;
	char	**argv;
	char	**envp;
	EsGlobalInfo *info;
	HWND	hwndDlg;
	I_32	rc;
} ENVSTRUCT;

extern EsPrimitiveTable filePrimitiveTable;
extern EsPrimitiveTable WindowProcPrimitiveTable;

EsDefinePrimitiveTable(EsExePrimitiveTable)
	EsSubTable(WindowProcPrimitiveTable)
	EsSubTable(filePrimitiveTable)
EsEndPrimitiveTable

/* function prototypes */
BOOLEAN EsFindImageFileName(int argc, char *argv[], char *envp[], EsGlobalInfo * info);
BOOLEAN EsParseCommandLineOptions(int argc, char *argv[], char *envp[], EsGlobalInfo * info);
void EsSetGlobalHInstance(ESGlobalInfo *ginfo, HINSTANCE hInst);

#define QUOTE_CHAR '"'
/*
 *	Takes the command line (1 string) and breaks it into an
 *	argv[] style list.
 *	Understands Win95 LFNs and strips quotes off the exe name.
 */

parseWords(char *buffer, char *words[])
{
	int count;

	count = 0;
 
	if(QUOTE_CHAR == *buffer) {	/* we have a quoted name. */
		words[count++] = ++buffer;	/* move past the quote */
		while(QUOTE_CHAR != *buffer) buffer++;
		if (*buffer) *buffer++ = '\0';	/* slam the close quote and advance */
	}

	while (*buffer == ' ' || *buffer == '\t' || *buffer == '\r')
		buffer++;
	while (*buffer) {
		words[count++] = buffer;
		while (*buffer && *buffer != ' ' && *buffer != '\t' && *buffer != '\r') {
			buffer++;
		}
		if (*buffer) *buffer++ = '\0';
		while (*buffer == ' ' || *buffer == '\t' || *buffer == '\r')
			buffer++;
	}
	return count;
}
LRESULT CALLBACK DrawBitmapProc (HWND hwnd, UINT msg, WPARAM wParam, LPARAM lParam)
{				  
	PAINTSTRUCT ps;
	RECT rect;
	HDC hDC, hDCBitmap;
	HBITMAP hBitmap, hBitmapOld;
	BITMAP bitmap;

	switch(msg) {
		case WM_PAINT: {
			hBitmap = LoadBitmap( hInstanceCur, "APP_SPLASHBITMAP_NAME" );
			if (hBitmap) {
				hDC = BeginPaint (hwnd, &ps);
				hDCBitmap = CreateCompatibleDC (hDC);
				hBitmapOld = SelectObject( hDCBitmap, hBitmap);
				GetObject (hBitmap, sizeof(BITMAP), &bitmap);
				GetClientRect (hwnd, &rect );
				StretchBlt( hDC, 0, 0, rect.right - rect.left, rect.bottom - rect.top, hDCBitmap,
					0, 0, bitmap.bmWidth, bitmap.bmHeight, SRCCOPY );
				SelectObject( hDCBitmap, hBitmapOld );
				DeleteDC( hDCBitmap );
				DeleteObject( hBitmap );
				EndPaint (hwnd, &ps);
				return (LRESULT) 0;
			}
		}
	}
	return (LRESULT) CallWindowProc (StaticProc, hwnd, msg, wParam, lParam);
}
BOOL CALLBACK DlgProc(hwndDlg, uMsg, wParam, lParam)
	HWND hwndDlg;
	UINT uMsg;
	WPARAM wParam;
	LPARAM lParam;
{
	int displayHeight, displayWidth, width, height, x, y;
	RECT rect;

	switch(uMsg) {
		case WM_INITDIALOG: {
			displayHeight = GetSystemMetrics( SM_CYSCREEN );
			displayWidth = GetSystemMetrics( SM_CXSCREEN );

			GetWindowRect( hwndDlg, &rect );
			x = max( (displayWidth
					  - (width = rect.right - rect.left)) / 2, 0 );
			y = max( (displayHeight
					  - (height = rect.bottom - rect.top)) / 2, 0 );
			MoveWindow( hwndDlg, x, y, width, height, TRUE );
			return TRUE;
		}
	}
	return FALSE;
}
static void threadReadImageFile(ENVSTRUCT *envStruct)
{
	envStruct->rc = 
		EsLoadFileImage(
			envStruct->argc, 
			envStruct->argv,
			envStruct->envp, 
			envStruct->info);
	PostMessage( envStruct->hwndDlg, WM_QUIT, 0, 0 );
}

U_32 GetPlatform(void)
{
	OSVERSIONINFO osVerInfo;

	osVerInfo.dwOSVersionInfoSize=sizeof(OSVERSIONINFO);

	if(!GetVersionEx(&osVerInfo)) {
		return VER_PLATFORM_WIN32s;
	}
	return osVerInfo.dwPlatformId;
}
main(int argc, char ** argv, char ** envp)
{
	I_32 rc;
	EsGlobalInfo *globalInfo;
	MSG msg;
	ENVSTRUCT envStruct;
	DWORD dwTid;
	HANDLE hThread;

	WindowsVersion = GetPlatform();
	globalInfo = EsInitializeImage();
	if (globalInfo == NULL) {
		EsReportError(EsPrimErrNotEnoughMemory, globalInfo);
		if (hwndDlgBox)	DestroyWindow( hwndDlgBox );
		return EsPrimErrNotEnoughMemory;
	}
	globalInfo->imagePrimitives = (U_32) EsExePrimitiveTable;

	/* Initialize handles to the splash screen */
	globalInfo->splashDialogHandle = hwndDlgBox;
	globalInfo->splashStatusLineHandle = GetDlgItem (hwndDlgBox , IDS_STATUS);

	/* Set the desired level of messaging */
	globalInfo->messageLevel = ESVM_MSG_LEVEL_NONE; 


	EsSetGlobalHInstance(globalInfo, hInstanceCur);
	if ((rc = EsInitializeTargetInterface(argc, argv, envp, globalInfo)) != EsPrimErrNoError) { 
		EsReportError(rc, globalInfo);
		EsShutdownImage(globalInfo);
		if (hwndDlgBox)	DestroyWindow( hwndDlgBox );
		return rc;
	}

	/* Print VM timestamp on the splash screen */
	EsSplashPrintf (globalInfo, ESVM_MSG_LEVEL_NONE,"VM Timestamp: %s", EsVMVersionString(), 0,0,0,0,0,0,0,0,0);

	EsPrintf ("\nENVY/Smalltalk, Version %s", EsVMVersionString(),
				0,0,0,0,0,0,0,0,0);
	EsPrintf ("\nCopyright (C) 1992-1996 Object Technology International Inc.\n",  
				0,0,0,0,0,0,0,0,0,0);

	if(!EsParseCommandLineOptions(argc, argv, envp, globalInfo)) {
		EsReportError(EsPrimErrImageFileOpenError, globalInfo);
		EsShutdownImage(globalInfo);
		if (hwndDlgBox)	DestroyWindow( hwndDlgBox );
		return EsPrimErrImageFileOpenError;
	}

	if (hwndDlgBox) {
		if (WindowsVersion == VER_PLATFORM_WIN32s) {
			rc = EsLoadFileImage(argc, argv, envp, globalInfo);
		} else {
			envStruct.argv = argv;
			envStruct.argc = argc;
			envStruct.envp = envp;
			envStruct.info = globalInfo;
			envStruct.hwndDlg = hwndDlgBox;
			hThread = CreateThread(
				NULL,
				0,
				(LPTHREAD_START_ROUTINE) threadReadImageFile,
				&envStruct,
				0,
				&dwTid);
			if (hThread == NULL) {
				rc = EsLoadFileImage(argc, argv, envp, globalInfo);
			} else {
				while (GetMessage( &msg, hwndDlgBox, 0L, 0L )) {
					DispatchMessage( &msg );
				}
				rc = envStruct.rc;
				CloseHandle(hThread);
			}
		}
	} else {
		rc = EsLoadFileImage(argc, argv, envp, globalInfo);
	}

	if (hwndDlgBox)
		DestroyWindow( hwndDlgBox );

	if (rc == EsPrimErrNoError)
		rc = EsExecuteImage(globalInfo);

	if (rc != EsPrimErrNoError)
		EsReportError (rc, globalInfo);

	EsShutDownTargetInterface (globalInfo);
	EsShutdownImage(globalInfo);
	return rc;
}


WINAPI WinMain(
	HINSTANCE hInstCurrent, 
	HINSTANCE hInstPrevious,
	LPSTR lpszCmdLine,
	int nCmdShow)
{
	int nArgs;
	HWND hwndStatic;
	void EsSetHInstance(HINSTANCE);

	hInstanceCur = hInstCurrent;
	EsSetHInstance(hInstCurrent);
	nArgs = parseWords(GetCommandLine(), &ES_cmdLineParams[0]);

	hwndDlgBox = CreateDialog( hInstCurrent, "IDD_SPLASHDIALOG", NULL, DlgProc );
	hwndStatic = GetDlgItem (hwndDlgBox, IDBM_SPLASHBITMAP);
	StaticProc = (WNDPROC) GetWindowLong (hwndStatic, GWL_WNDPROC);
	SetWindowLong (hwndStatic, GWL_WNDPROC, (LONG) DrawBitmapProc);
	ShowWindow( hwndDlgBox, SW_SHOW );
	UpdateWindow( hwndDlgBox );

	return main(nArgs, ES_cmdLineParams, NULL);
}


