package com.ibm.abt.web.servlet;

/**
 * This type was created in VisualAge.
 */

import java.io.* ;
import java.lang.* ;
import java.util.* ;
import java.net.* ;
import javax.servlet.http.* ;
public class RouterConfigurationInfoServlet extends javax.servlet.http.HttpServlet {
/**
 * This method was created in VisualAge.
 * @exception javax.servlet.ServletException The exception description.
 * @exception java.io.IOException The exception description.
 */
public void doGet(HttpServletRequest req, HttpServletResponse res) throws javax.servlet.ServletException, IOException {

		PrintWriter html ;
		Vector items ;
		RouterConfiguration config ;
		RouterConfiguration.reset() ;
		config = RouterConfiguration.getCurrent();
		res.setContentType("text/html");
		html = res.getWriter() ;
		html.println ("<HTML>") ;
		html.println("<HEAD><TITLE>VisualAge for Smalltalk router servlet configuration</TITLE></HEAD>");

		// Display the basic properties from the configuration file
		html.println("<table border cellpadding=5>") ;	
		html.println("<font size=+2>Basic properties</font>") ;
		html.println("<TH>Property</TH>") ;
		html.println("<TH>Value</TH>") ;	
		html.println("<TR><TD>") ;
		html.println("Default directory (abtwsi.pro)") ;
		html.println("</TD><TD>") ;
		html.println(config.getDefaultDirectory()) ;
		html.println("</TD></TR>") ;

		html.println("<TR><TD>") ;
		html.println("SOCKET_TIMEOUT") ;
		html.println("</TD><TD>") ;
		html.println(new Integer(config.getSoTimeout()).toString()) ;
		html.println("</TD></TR>") ;

		html.println("<TR><TD>") ;
		html.println("ABTWSI_BASENAME") ;
		html.println("</TD><TD>") ;
		html.println(config.getAbtWsiBaseName()) ;
		html.println("</TD></TR>") ;

		html.println("<TR><TD>") ;
		html.println("Configuration file name") ;
		html.println("</TD><TD>") ;
		html.println(config.getConfigurationFileName()) ;
		html.println("</TD></TR>") ;

		html.println("<TR><TD>") ;
		html.println("Log file name") ;
		html.println("</TD><TD>") ;
		html.println(config.getLogFileName()) ;
		html.println("</TD></TR>") ;

		html.println("<TR><TD>") ;
		html.println("Error format file") ;
		html.println("</TD><TD>") ;
		html.println(config.getErrorFileName()) ;
		html.println("</TD></TR>") ;


		html.println("<TR><TD>") ;
		html.println("Codepage") ;
		html.println("</TD><TD>") ;
		html.println(config.getCodePage()) ;
		html.println("</TD></TR>") ;
		
		html.println("<TR><TD>") ;
		html.println("Log") ;
		html.println("</TD><TD>") ;
		html.println(config.getLog() ? "true" : "false") ;
		html.println("</TD></TR>") ;

		html.println("<TR><TD>") ;
		html.println("Debug") ;
		html.println("</TD><TD>") ;
		html.println(config.getDebug() ? "true" : "false") ;
		html.println("</TD></TR>") ;

		html.println("<TR><TD>") ;
		html.println("Verbose") ;
		html.println("</TD><TD>") ;
		html.println( config.getVerbose() ? "true" : "false" ) ;
		html.println("</TD></TR>") ;		
	
		html.println("</TABLE>") ;
		html.println("<BR><BR>" ) ;

		// Display the WsiTransport entries from the configuration file
		html.println("<table border cellpadding=5>") ;		
		html.println("<font size=+2>Transport entries</font>" );
		html.println("<TR>") ;
		html.println("<TH>Transport Name</TH>") ;
		html.println("<TH>Library</TH>") ;
		html.println("<TH>Host name</TH>") ;
		html.println("<TH>Port</TH>") ;
		html.println("</TR>") ;		
		
		items = config.getTransports() ;
		for (int i = 0 ; i < items.size() ; i++ ) {
			WsiTransport transport = (WsiTransport) items.elementAt(i) ;
			html.println("<TR>") ;
			html.println("<TD>" + transport.getTransportName() + "</TD>") ;
			html.println("<TD>" + transport.getLibraryName() + "</TD>") ;
			html.println("<TD>" + transport.getHostName() + "</TD>") ;
			html.println("<TD>" + String.valueOf(transport.getPortNumber()) + "</TD>") ;
			html.println("</TR>") ;	}
		html.println("</TABLE>" );

		// Display the LINK entries from configuration file
		html.println("<BR><BR>" ) ;
		html.println("<table border cellpadding=5>") ;		
		html.println("<font size=+2>Link entries</font>" );
		html.println("<TR>") ;
		html.println("<TH>Transport Name</TH>") ;
		html.println("<TH>Path Info</TH>") ;
		html.println("</TR>") ;		
		
		items = config.getLinks() ;
		for (int i = 0 ; i < items.size() ; i++ ) {
			WsiLink link = (WsiLink) items.elementAt(i) ;
			html.println("<TR>") ;
			html.println("<TD>" + link.getTransportName() + "</TD>") ;
			html.println("<TD>" + link.getPathInfo() + "</TD>") ;
			html.println("</TR>") ;	}
		html.println("</TABLE>" );
			

		html.println("</HTML>") ;
		html.close() ;
		
		}
/** Return a description of this servlet */
public String getServletInfo() {

	return "Servlet to display configuration information for the VisualAge for Smalltalk RouterServlet" ; }
}
