package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import com.ibm.ulc.util.UlcObject;
/**
 * Implement the <code>ITreeListener</code> interface with stub implementations.
 * Default behavior is to do nothing. Subclasses can override individual actions.
 */

public class DefaultTreeListener extends UlcObject implements ITreeListener {
/**
 * Notification of the default action (i.e. doubleclicking) performed on a node in a ULCTree.
 * 
 * @param e ULCTreeEvent 
 */
public void treeActionPerformed(ULCTreeEvent e) {
}
/**
 * Notification of the collapsed event (clicking on the '-') performed on a node in a ULCTree.
 * 
 * @param e ULCTreeEvent 
 */
public void treeCollapsed(ULCTreeEvent e) {
}
/**
 * Notification of the expanded event (clicking on the '+') performed on a node in a ULCTree.
 * 
 * @param e ULCTreeEvent 
 */
public void treeExpanded(ULCTreeEvent e) {
}
/**
 * Noticication that a node has been selected in the ULCTree.
 * 
 * @param e ULCTreeEvent  
 */
public void treeSelected(ULCTreeEvent e) {
}
}
