package com.ibm.ulc.application;

/*
 * Copyright (c) 1999 Object Technology International Inc.
 */

/**
 * IGraphicsProducer tags objects which can be used in conjunction with a UlcGraphicsPane.
 *
 * @see ULCGraphicsPane
 * @see ULCGraphics
 */
public interface IGraphicsProducer {

/**
 * The UI widget has requested a paint operation with the specified width and height.
 * Use the supplied Graphics object to draw into the UI widget.
 *
 * @param graphics The initialized Graphics object to be used for drawing.
 * @param width	   The width of the UI widget.
 * @param height   The height of the UI widget.
 *
 * @see ULCGraphicsPane
 * @see ULCGraphics
 */
public void paint(java.awt.Graphics graphics, int width, int height);
}
