package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
 
 import com.ibm.ulc.util.Anything;

/**
 * IProxy defines the minimal API for making objects downloadable
 * to the UI server. The corresponding interface in the UI is the ICallable.
 *
 */
public interface IProxy {
/**
 * Returns the unique (within ULC) id for this object and registers
 * it in the registry.
 *
 * @return the <code>int</code> value that uniquely identifies this widget.
 */
public int getId();
/**
 * Creates an Anything that can be used inside the UIEngine to find
 * or construct the UI half object.
 * If the object implementing this interface has already been uploaded the anything
 * just contains the registry id. Otherwise the (deep) state of the object is 
 * marshalled into an Anything which can be used to construct the 
 * corresponding UIEngine object and all its referenced objects.
 *
 * @param context ULCContext
 *										
 */
public Anything getRef(ULCContext context);
/**
 * Upload this object to the UI Engine.
 *
 * @param context ULCContext
 */
public void upload(ULCContext context);
}
