package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

/** 
 * This interface is implemented by widgets listening for events
 * triggered by ULC window widgets.
 * 
 * @see 	ULCShell#addWindowClosingListener(IWindowListener)
 * @see		ULCWindowEvent 	
 */
public interface IWindowListener extends IListener {
/**
 * Notification of a Window brought to top in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowActivatedListener
 */
public void windowActivated(ULCWindowEvent windowEvent);
/**
 * Notification of a window being closed in the UI. 
 * This event will be received only if a listener has been 
 * registered for this event or if the window is modal.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowClosedListener
 */
void windowClosed(ULCWindowEvent windowEvent);
/**
 * Notification of a Window about to be closed in the UI.
 * This event will be received only if the veto flag is enabled for the window. 
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowClosingListener
 */
void windowClosing(ULCWindowEvent windowEvent);
/**
 * Notification of a Window loosing focus in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowDeactivatedListener
 */
public void windowDeactivated(ULCWindowEvent windowEvent);
/**
 * Notification of a Window being hidden in the UI.
 * This event will be received only if the window is modal or
 * if a listener has been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowHiddenListener
 */
void windowHidden(ULCWindowEvent windowEvent);
/**
 * Notification of a Window being moved in the UI.
 * This event is a piggybacked event and will be received only
 * along with the next non-piggybacked event and only 
 * if a listener has been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowMovedListener
 */
void windowMoved(ULCWindowEvent windowEvent);
/**
 * Notification of a Window being resized in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowResizedListener
 */
void windowResized(ULCWindowEvent windowEvent);
/**
 * Notification of a Window being shown in the UI.
 * This event  will be received only if a listener has 
 * been registered for this event.
 *
 * @param	windowEvent	ULCWindowEvent
 * @see 	ULCShell#addWindowShownListener
 */
void windowShown(ULCWindowEvent windowEvent);
}
