package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;

/**
 * This class is used for showing alerts, i.e. warnings,
 * re-confirmations etc. to the user. 
 *
 * @see ULCAlert#ask()
 */
public class ULCAlert extends ULCComponent {
	/**
	 * The shell to which I am modal
 	 * @serial
	 */
	protected ULCShell fParent = null;
	/**
	 * The <code>ULCIcon</code> to be displayed
 	 * @serial
	 */
	protected ULCIcon fIcon = null;
	/**
	 * The message string to be displayed
 	 * @serial
	 */
	protected String fMsg;
	/**
	 * The strings to be used for my buttons. 
	 * If any of these strings are null the associated button is not displayed.
 	 * @serial
	 */
	protected String fButton1, fButton2, fButton3;
	/**
	 * The result string that identifies which button was selected in the UI.
 	 * @serial
	 */
	protected String fResult;
/**
 * Construct an alert 
 */
public ULCAlert() {
	fIcon= ULCAlert.getDefaultIcon();
	fVisible= false;
}
/**
 * Construct an alert with three Buttons for an unknown parent shell.
 * In some cases it is necessary to open a Alert where the parent shell is unknown.
 * Use this method ONLY in those cases.
 * The default behaviour is to look for the first available active shell in the context
 * and to open modal ontop of it. If there are no active shells then a Shell is created 
 * (but not shown) in the UI and this Alert is opened modal to it.
 *
 * @param context	Context to be used for upload.
 * @param label		Use this string as the window title.
 * @param msg 		This alert's message.
 * @param b1		Label of first button.
 * @param b2		Label of second button.
 * @param b3 		Label of third button.
 */
public ULCAlert(ULCContext context, String label, String msg, String b1, String b2, String b3) {
	this(context, label, msg, b1, b2, b3, ULCAlert.getDefaultIcon());
}
/**
 * Construct an alert with three Buttons for an unknown parent shell.
 * In some cases it is necessary to open a Alert where the parent shell is unknown.
 * Use this method ONLY in those cases.
 * The default behaviour is to look for the first available active shell in the context
 * and to open modal ontop of it. If there are no active shells then a Shell is created 
 * (but not shown) in the UI and this Alert is opened modal to it.
 *
 * @param context	Context to be used for upload.
 * @param label		Use this string as the window title.
 * @param msg 		This alert's message.
 * @param b1		Label of first button.
 * @param b2		Label of second button.
 * @param b3 		Label of third button.
 * @param icon 		ULCIcon to be displayed.
 */
public ULCAlert(ULCContext context, String label, String msg, String b1, String b2, String b3, ULCIcon icon) {
	super(label);
	fIcon = icon;
	fParent = null;
	fMsg = msg;
	fButton1 = b1;
	fButton2 = b2;
	fButton3 = b3;
	fContext = context;
	fVisible = false;
}
/**
 * Construct an alert with a single Button.
 *
 * @param parent	Position alert on top of this shell.
 * @param label		Use this string as the window title.
 * @param msg 		This alert's message.
 * @param b1		Label of first button.
 */
public ULCAlert(ULCShell parent, String label, String msg, String b1) {
	this(parent, label, msg, b1, null, null);
}
/**
 * Construct an alert with two Buttons.
 *
 * @param parent	Position alert on top of this shell.
 * @param label		Use this string as the window title.
 * @param msg 		This alert's message.
 * @param b1		Label of first button.
 * @param b2		Label of second button.
 */
public ULCAlert(ULCShell parent, String label, String msg, String b1, String b2) {
	this(parent, label, msg, b1, b2, null);
}
/**
 * Construct an alert with three Buttons.
 *
 * @param parent	Position alert on top of this shell.
 * @param label		Use this string as the window title.
 * @param msg 		This alert's message.
 * @param b1		Label of first button.
 * @param b2		Label of second button.
 * @param b3 		Label of third button.
 */
public ULCAlert(ULCShell parent, String label, String msg, String b1, String b2, String b3) {
	this(parent, label, msg, b1, b2, b3, ULCAlert.getDefaultIcon());
}
/**
 * Construct an alert with three Buttons.
 *
 * @param parent	Position alert on top of this shell.
 * @param label		Use this string as the window title.
 * @param msg 		This alert's message.
 * @param b1		Label of first button.
 * @param b2		Label of second button.
 * @param b3 		Label of third button.
 * @param icon 		ULCIcon to be displayed.
 */
public ULCAlert(ULCShell parent, String label, String msg, String b1, String b2, String b3, ULCIcon icon) {
	super(label);
	fIcon = icon;
	fParent = parent;
	fMsg = msg;
	fButton1 = b1;
	fButton2 = b2;
	fButton3 = b3;
	fVisible = false;
}
/**
 * Display the alert on the UI Engine and wait for the user-
 * input.
 *
 * @return	The (String) value obtained from the pressed button or
 *  		or windowClosing if the Alert was dismissed without a selection or
 *          null if the connection failed during the wait.
 */
public String ask() {
	if (fParent != null)
		fParent.setModalComponent(this);
	if ((fContext == null) && (fParent != null) && (fParent.fContext != null))
		fContext = fParent.fContext;
	upload(fContext);
	fVisible = true;
	sendUI("setVisible", new Anything(fVisible));
	fResult = null;
	while ((fResult == null) && !fContext.processNextRequest(0)) {
		try {
			Thread.sleep(100);
		} catch (Exception e) {
		}
	};
	if (fParent != null)
		fParent.clearModalComponent(this);
	fVisible = false;
	return fResult;
}
static public ULCIcon getDefaultIcon() {
	java.net.URL iconURL = ULCAlert.class.getResource("alert.gif");
	if (iconURL != null)
		return new ULCIcon(iconURL);
	else
		return null;
}
/**
 * Return the label of the first button
 */
public String getFirstButtonLabel() {
	return fButton1;
}
/**
 * Return the icon of this alert
 */
public ULCIcon getIcon() {
	return fIcon;
}
/**
 * Return the label of this alert
 */
public String getLabel() {
	return fLabel;
}
/**
 * Return the message text of this alert
 */
public String getMessage() {
	return fMsg;
}
/**
 * Return the parent of this alert
 */
public ULCShell getParent() {
	return fParent;
}
/**
 * Return the label of the second button
 */
public String getSecondButtonLabel() {
	return fButton2;
}
/**
 * Return the label of the third button
 */
public String getThirdButtonLabel() {
	return fButton3;
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn	ORBConnection	The connection on which the reply should be sent.
 * @param args	Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("event")) {
		String type = args.get("type", "???");
		if (type.equals("dismiss")) {
			fResult = args.get("cmd", "???");
			return;
		}
	}
	super.handleRequest(conn, request, args);
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	super.saveState(a);
	if (fParent != null)
		a.put("parent", fParent.getRef(getContext()));
	if (fIcon != null) {
		boolean temp = fIcon.isCachedOnUI();
		fIcon.setCachedOnUI(false);
		a.put("icon", fIcon.getRef(getContext()));
		fIcon.setCachedOnUI(temp);
	}
	if (fMsg != null)
		a.put("msg", fMsg);
	if (fButton1 != null)
		a.put("button1", fButton1);
	if (fButton2 != null)
		a.put("button2", fButton2);
	if (fButton3 != null)
		a.put("button3", fButton3);
}
/**
 * Set the label of the first button
 */
public void setFirstButtonLabel(String label) {
	fButton1= label;
}
/**
 * Set the icon of this alert
 */
public void setIcon(ULCIcon icon) {
	icon.setCachedOnUI(false);
	fIcon = icon;
}
/**
 * Set the label of this alert
 */
public void setLabel(String label) {
	fLabel = label;
}
/**
 * Set the message text of this alert
 */
public void setMessage(String message) {
	fMsg = message;
}
/**
 * Set the parent of this alert
 */
public void setParent(ULCShell parent) {
	fParent = parent;
}
/**
 * Set the label of the second button
 */
public void setSecondButtonLabel(String label) {
	fButton2 = label;
}
/**
 * Set the label of the third button
 */
public void setThirdButtonLabel(String label) {
	fButton3 = label;
}
}
