package com.ibm.ulc.application;

/*
 * Copyright (c) 2000 Object Technology International Inc.
 */

/**
 * This is the event that gets triggered when a value has changed,
 * say in a field (ULCField), slider (ULCSlider) etc.
 * Use this event if you are not interested in the value itself but
 * only in the fact that it changed.
 * The passed parameter will be true or false.
 *
 * @since	R3.1
 */
public class ULCHasChangedEvent extends ULCEvent {
	/**
	 * The new value that caused this event
	 * true/false
	 * @serial
	 */
	protected Object fValue= null;
/**
 * Construct a ULCHasChangedEvent from a given source and new value.
 *
 * @param source 	The source.
 * @param value 	The new value.
 */
public ULCHasChangedEvent(Object source, Object value) {
	super(source);
	fValue= value;
}
/**
 * Dispatch this event to the specified object if it implements the IHasChangedListener interface.
 *
 * @param listener	The listener interested in the event
 */
public void dispatch(IListener listener) {
	if (listener instanceof IHasChangedListener) {
		IHasChangedListener vl = (IHasChangedListener) listener;
		vl.hasChanged(this);
	}
}
/**
 * Returns the object (value) associated with this event.
 *
 * @return <code>Object</code> value or null if none.
 */
public Object getValue() {
	return fValue;
}
}
