package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */

import com.ibm.ulc.util.Anything;
import com.ibm.ulc.comm.ORBConnection;

/**
 * Class representing a page in a ULCNotebook or ULCPagebook.
 */
public class ULCPage extends ULCComponent {
	/**
	 * @serial	 	 
	 */
	private ULCComponent fContents;
	/**
	 * @serial	 	 
	 */
	private String fAlign = null;
	/**
	 * @serial	 	 
	 */
	private int fMargin = 10;
	/**
	 * @serial	 	 
	 */
	private boolean fPreload = false;
	/**
	 * The optional ULCIcon to be displayed
	 * @serial	 
	 */
	protected ULCIcon fIcon = null;
/**
 * Construct a <code>ULCPage</code> 
 */
public ULCPage() {
	super();
}
/**
 * Construct a <code>ULCPage</code> with the specified title and containing the specified <code>ULCComponent</code>
 *
 * @param label	The <code>String</code> label for this pages Tab.
 * @param c		The <code>ULCComponent</code> to be displayed as this pages's contents.
 */
public ULCPage(String label, ULCComponent c) {
	super(label);
	setComponent(c);
}
/**
 * Construct a <code>ULCPage</code> with the specified margin and preload flag.
 *
 * @param title		The <code>String</code> label for this pages Tab.
 * @param margin	The margin between the <code>ULCPage</code> and its contents.
 * @param preload	If true the contents of this page is uploaded to the UI when 
 *					the page is uploaded. Normally the contents are uploaded on demand.
 */
public ULCPage(String label, ULCComponent c, int margin, boolean preload) {
	super(label);
	setComponent(c);
	fMargin = margin;
	fPreload = preload;
}
/**
 * This widget is being destroyed perform any cleanUp necessary.
 */
public void free() {
	super.free();
	if (fContents != null)
		fContents.free();
	fContents = null;
	fIcon = null;
}
/**
 * Answer the receiver's component
 *
 * @return The <code>ULCComponent</code> contained in the receiver
 */
public ULCComponent getComponent() {
	return fContents;
}
/**
 * Return the icon of this page.
 *
 * @return The ULCIcon to be displayed.
 */
public ULCIcon getIcon() {
	return fIcon;
}
/**
 * Gets the page's label.
 *
 * @return The current label string 
 */
public String getLabel() {
	return fLabel;
}
/**
 * Gets the page's margin.
 *
 * @return The current margin 
 */
public int getMargin() {
	return fMargin;
}
/**
 * Return the preload flag for this page.
 *
 * @return preload	If true the contents of this page is uploaded to the UI when 
 *					the page is uploaded. Normally the contents are uploaded on demand.
 */
public boolean getPreload() {
	return fPreload;
}
/**
 * The UI has sent a request to this object. Do all processing necessary.
 * If this object does not handle this request call super.handleRequest.
 *
 * @param conn		ORBConnection	The connection on which the reply should be sent.
 * @param request 	String			The string that identifies this request.
 * @param args		Anything		The arguments associated with this request.
 */
public void handleRequest(ORBConnection conn, String request, Anything args) {
	if (request.equals("getContents")) {
		if (getComponent() != null)
			sendUI("setContents", getComponent());
		else
			sendUI("setContents", new Anything());
		return;
	}
	super.handleRequest(conn, request, args);
}
/**
 * Save the state of this object on the supplied Anything.
 * Every ULCProxy object that needs to send state to the UI must 
 * override this method to save its state in the Anything and then
 * call the super class implementation.
 *
 * @param a	Anything	The object into which my state should be saved.
 */
protected void saveState(Anything a) {
	if (fMargin != 10)
		a.put("m", fMargin);
	if (fAlign != null)
		a.put("a", fAlign);
	if (fPreload && getComponent() != null)
		a.put("content", getComponent().getRef(fContext));
	if (fIcon != null)
		a.put("icon", fIcon.getRef(fContext));
	super.saveState(a);
}
/**
 * Set the receiver's component
 *
 * @param component The <code>ULCComponent</code> contained in the receiver
 */
public void setComponent(ULCComponent component) {
	fContents = component;
}
/**
 * Set the icon of the button.
 *
 * @param icon The ULCIcon to be displayed.
 */
public void setIcon(ULCIcon icon) {
	if (icon != fIcon) {
		fIcon = icon;
		sendUI("setIcon", fIcon);
	}
}
/**
 * Sets the widgets's <code>String</code> label.
 *
 * @param label the label <code>String</code> of the widget.
 */
public void setLabel(String label) {
	internalSetLabel(label);
}
/**
 * Sets the widgets's margin.
 *
 * @param margin the margin of the widget.
 */
public void setMargin(int margin) {
	fMargin = margin;
}
/**
 * Set the preload flag for this page.
 *
 * @param preload	If true the contents of this page is uploaded to the UI when 
 *					the page is uploaded. Normally the contents are uploaded on demand.
 */
public void setPreload(boolean preload) {
	fPreload = preload;
}
}
