package com.ibm.ulc.application;

import java.awt.*;
import com.ibm.ulc.application.*;
import com.ibm.ulc.comm.Request;
import java.util.*;
/**
 * Implement an Abstract ULCContext that is used by the ULC Java builder
 */
abstract public class ULCVajContext extends ULCContext implements IUsesVajContext {
/**
 * ULCVajContext constructor comment.
 */
public ULCVajContext() {
	super();
}
public static boolean checkAndWarnIfUINotRunning() {
	boolean b = ULC.isUIEngineActive();
	if (!b)
		warnUINotRunning();
	return b;
}
/**
 * Return the application used within this context.
 *
 * @return com.ibm.ulc.application.ULCApplication
 */
public ULCApplication getApplication() {
	return getDefaultApplication();
}
/**
 * Gets the resource bundle for the filename passed in, using the current locale.
 * The locale used will be by default the locale of the UI Engine.
 * If subclasses want to override the locale used they can implement 
 * the method <code>getResourceLocale</code>
 *
 * @param bundle <code>String</code> bundle filename.
 * @return <code>ResourceBundle</code>
 * @see #getResourceLocale
 */
public ResourceBundle getResourceBundle(String bundleFilename) {
	ResourceBundle resourceBundle = null;
	try {
		 resourceBundle = ResourceBundle.getBundle(bundleFilename, getResourceLocale());
	}
	catch (MissingResourceException e) {
	}
	return resourceBundle;
}
/**
 * Insert the method's description here.
 * Creation date: (06-17-99 1:39:46 PM)
 * @return com.ibm.ulc.varun.ULCVajContext
 */
public ULCVajContext getVajContext() {
	return this;
}
/**
 * @deprecated This new method is now a private method generated when needed.
 */
protected void initializeNls() {
}
/**
 * main entrypoint - starts the part when it is run as an application
 * @param args java.lang.String[]
 */
public static void main(java.lang.String[] args) {
	try {
		// This is non-nls'ed because this method should never be called.
		final java.awt.Frame f = new java.awt.Frame();
		f.setTitle("Error: Not an application");
		java.awt.Panel p = new java.awt.Panel();
		f.add(p);
		p.add(new java.awt.Label("This class has not been set up to run as an application."));
		p.add(new java.awt.Label("The main() method is not implimented."));
		java.awt.Button b = new java.awt.Button("OK");
		p.add(b);
		b.addActionListener(new java.awt.event.ActionListener() {
			public void actionPerformed(java.awt.event.ActionEvent e) {
				f.dispose();
				System.exit(0);
			}
		});
		f.addWindowListener(new java.awt.event.WindowAdapter() {
			public void windowClosing(java.awt.event.WindowEvent e) {
				f.dispose();
				System.exit(0);
			}
		});
		
		f.setSize(500, 100);
		Dimension screenSize = f.getToolkit().getScreenSize();
		Dimension size = f.getSize();
		screenSize.height = screenSize.height / 2;
		screenSize.width = screenSize.width / 2;
		size.height = size.height / 2;
		size.width = size.width / 2;
		int y = screenSize.height - size.height;
		int x = screenSize.width - size.width;
		f.setLocation(x, y);
		f.show();
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of ULCVajContext");
		exception.printStackTrace(System.out);
	}
}
/**
 * Convenience method, for initializing ULC, registering the class which implements
 * the <code>main</code> method, and depending on ULC mode starting up the server
 * ('server' mode) or connecting to the UI Engine ('client' mode).
 *
 * @param	args[] 		
 *			The arguments passed in for starting a ULC application.
 * @param	contextClass	
 *			This is the 'main' class in the ULC application,
 *			typically inheriting from ULCContext.
 * @return The ULCContext that has been created or null if an error occurred or is running InServerMode
 * @see ULCContext#start()
 */
public static ULCContext run(String args[], Class contextClass) {
	return ULC.run(args, contextClass);
}
/*
 * Called when this context is run.
 * Clients have to implement this method with their 'main' code.
 */
public void start() {
}
/**
 * This method is used to test a ULCComponent subclass.
 * Called by the main() of the class. Used only within the VAJava test environment.
 */
public static synchronized void testULCClass(String[] args, Class ulcComponentClass) {
	if (!ULCComponent.class.isAssignableFrom(ulcComponentClass))
		return; // Not called with a subclass of ULCComponent.

	try {
		try {
			// So that we don't bring in stuff that's not needed at runtime
			// we use the dynamic access methods instead of letting the
			// compiler do it.
			Class testContextCls = Class.forName("com.ibm.ulc.vaedit.ULCTestContext");

			// Now we can build the test.
			java.lang.reflect.Method mainTestConstructionMthd = null;
			try {
				mainTestConstructionMthd = ulcComponentClass.getMethod("mainTestConstruction", new Class[] {ULCVajContext.class});
			} catch (NoSuchMethodException ex) {
				// The method can't be found. Just return.
				return;
			}
			final ULCVajContext context = (ULCVajContext) ULC.run(args, testContextCls);
			try {
				Thread.sleep(1000);
			} catch (Exception e) {
			}
			if (context != null) {
				java.util.ResourceBundle resvaedit = context.getResourceBundle("ulcvaedit"); // Resource in UIEngine's locale

				ULCComponent aComponent = (ULCComponent) mainTestConstructionMthd.invoke(null, new Object[] {context});
				if (aComponent != null) {
					ULCShell theShell = null;
					if (!(aComponent instanceof ULCShell)) {
						// We need to wrap it in a shell
						theShell = new ULCShell(java.text.MessageFormat.format(resvaedit.getString("vajcontext.test.title"), new Object[] {ulcComponentClass.getName()}));
						theShell.add(aComponent);
					} else {
						// It is a shell, see if it has a title, and if not, add ours.
						theShell = (ULCShell) aComponent;
						if (theShell.getLabel() == null)
							theShell.setLabel(java.text.MessageFormat.format(resvaedit.getString("vajcontext.test.title"), new Object[] {ulcComponentClass.getName()}));
					}
					final ULCShell shell = theShell;
					Request r = new Request() {
						public void dispatch() {
							context.getApplication().add(shell);
							shell.setVisible(true);
						}
					};
					context.postRequest(r);
				} else {
					context.terminate();	// No component, so nothing to show, so terminate the context.
				}
			}
		} catch (ClassNotFoundException exception) {
			/* ULCTestContext is not found, so this is runtime. Just continue. */ }
	} catch (Throwable exception) {
		System.err.println("Exception occurred in main() of " + ulcComponentClass.getName());
		exception.printStackTrace(System.out);
	}
}
public static void  warnUINotRunning() {
	java.util.ResourceBundle resvaedit = null;
	try {
		resvaedit = java.util.ResourceBundle.getBundle("ulcvaedit");
	} catch (MissingResourceException ex) {
		return;				// Bundle not found, so not in VAJava test environment, so continue
	};
	
 	final java.awt.Frame f = new java.awt.Frame();
	f.setTitle(resvaedit.getString("vajcontext.nouititle"));
	java.awt.Panel p= new java.awt.Panel();
	f.add(p);
	p.add(new java.awt.Label(resvaedit.getString("vajcontext.nouilabel")));
	java.awt.Button b = new java.awt.Button(resvaedit.getString("vajcontext.nouibutton"));
	p.add(b);
	b.addActionListener(new java.awt.event.ActionListener() {
		public void actionPerformed(java.awt.event.ActionEvent e) {
			f.dispose();
			System.exit(0);
		}
	});
	f.addWindowListener(new java.awt.event.WindowAdapter() {
		public void windowClosing(java.awt.event.WindowEvent e) {
			f.dispose();
			System.exit(0);
		}
	});
	f.setSize(400,65);
	Dimension screenSize = f.getToolkit().getScreenSize();
	Dimension size = f.getSize();
	screenSize.height = screenSize.height / 2;
	screenSize.width = screenSize.width / 2;
	size.height = size.height / 2;
	size.width = size.width / 2;
	int y = screenSize.height - size.height;
	int x = screenSize.width - size.width;
	f.setLocation(x, y);
	f.show();
}
}
