package com.ibm.ulc.application;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
/**
 * All events received by a ULCShell are implemented by this class.
 */
public class ULCWindowEvent extends ULCActionEvent {
/**
 * Construct a ULCWindowEvent with the specified source and command.
 *
 * @param source <code>Object</code>
 * @param cmd <code>String</code>
 */
public ULCWindowEvent(Object source, String cmd) {
	super(source, cmd);
}
/**
 * Dispatch this event to the specified object if it implements 
 * the IWindowListener interface.
 *
 * @param listener The object that is interested in this event.
 */
public void dispatch(IListener listener) {
	if (listener instanceof IWindowListener) {
		IWindowListener wl = (IWindowListener) listener;
		if (fCmd.equals("moved")) {
			wl.windowMoved(this);
			return;
		}
		if (fCmd.equals("resized")) {
			wl.windowResized(this);
			return;
		}
		if (fCmd.equals("windowClosing")) {
			wl.windowClosing(this);
			return;
		}
		if (fCmd.equals("windowClosed")) {
			wl.windowClosed(this);
			return;
		}
		if (fCmd.equals("windowShown")) {
			wl.windowShown(this);
			return;
		}
		if (fCmd.equals("windowHidden")) {
			wl.windowHidden(this);
			return;
		}
		if (fCmd.equals("windowActivated")) {
			wl.windowActivated(this);
			return;
		}
		if (fCmd.equals("windowDeactivated")) {
			wl.windowDeactivated(this);
			return;
		}
	} else {
		super.dispatch(listener); //for compatibility with previous releases of ULC
	}
}
}
