package com.ibm.ulc.examples.CustomerInformation;

/*
 * Copyright (c) 1997,1998 Object Technology International Inc.
 */
import java.lang.Math;

/**
 * This is the business-specific application class, which interacts
 * with ULC only via a separate adapter class.
 */
public class Address {
	private String fStreet;
	private String fCity;
	private String fZipCode;
	private String fCountry;
public Address (String street, String city, String zipCode, String country) {
	setStreet(street);
	setCity(city);
	setZipCode(zipCode);
	setCountry(country);
}
/**
 * Create some test-instances which can be used for testing
 * out the application.
 */
 
public static Address createTestAddress() {
	return getRandomTestAddress();
}
/**
 * Create some test-instances which can be used for testing
 * out the application.
 */
 
public static Address[] createTestAddresses() {
	Address[] addresses= {
		new Address("Ruetihofstr.31","Zurich", "8049", "Switzerland"),
		new Address("Wibichstr. 27","Zurich", "8037", "Switzerland"),
		new Address("Oberdorfstr. 8","Zurich", "8001", "Switzerland"),
		new Address("Hoeschgasse 45","Zurich", "8008", "Switzerland"),
		new Address("Hochstr. 16","Basel", "4002", "Switzerland")
	};
	return addresses;
}
/**
 * Create some test-instances which can be used for testing
 * out the application.
 */
 
public static Address getRandomTestAddress ( ) {
	Address[] addresses= createTestAddresses();
	int addrPosition= (int) (Math.random() * addresses.length);
	return addresses[addrPosition];
}
/**
 * Answer the value for the attribute corresponding
 * to the given column-Id. Note: This can also be
 * done using the reflection API.
 */
public Object getValueForAttributeName(String colId) {
	if (colId.equals("Street")) return fStreet;
	else
		if (colId.equals("City")) return fCity;
		else
			if (colId.equals("ZipCode")) return fZipCode;
			else
				if (colId.equals("Country")) return fCountry;				
				else return null;
}
public void setCity(String city) {
	fCity= city;
}
public void setCountry(String country) {
	fCountry= country;
}
public void setStreet(String street) {
	fStreet= street;
}
public void setZipCode(String zipCode) {
	fZipCode= zipCode;
}
}
