package com.ibm.ulc.examples.ManagementStructure;

import java.util.*;
import com.ibm.ulc.application.*;
/**
 * This class is intended to adapt the employee to
 * the requirements of being placed on a ULC Form,
 * i.e. of adhering to the ULCFormModel interface.
 */

public class EmployeeAdapter extends ULCFormModel {
	protected Employee fEmployee;
/**
 * By default, create an adapter with a dummy
 * employee
 */
public EmployeeAdapter() {
	setDummyEmployee();
}
/**
 * Create an adapter for the given employee
 */
public EmployeeAdapter(Employee employee) {
	fEmployee= employee;
}
public Employee getEmployee() {
	return fEmployee;
}
/**
 * Answer the value for the attribute corresponding
 * to the given key. Note: This can also be
 * done using the reflection API.
 */
public Object getValueAt(String key) {
	if (fEmployee == null) 
		return "";
	// The above happens after fEmployee has been deleted,
	// or when all nodes are deselected.

	if (key.equals("Name")) return fEmployee.getName();
	if (key.equals("Title")) return fEmployee.getTitle();
	if (key.equals("Boss")) return fEmployee.getBossName();
	if (key.equals("NumDirectReports")) 
		return String.valueOf(fEmployee.getChildCount());
	return "";
}
/**
 * It is useful to have this method, so that
 * the FORM_MODEL_CHANGED variable can be accessed 
 * easily.
 */
public void notifyChange() {
	notify(FORM_MODEL_CHANGED, null);
}
/**
 * Set a dummy employee for the receiver. Inform the
 * UI of this fact as well.
 */
public void setDummyEmployee() {
	fEmployee= Employee.createDummyEmployee();
	notifyChange();
}
/**
 * The employee held by the receiver has changed.
 * This receiver keeps track of the currently-selected
 * employee, and issues the change-notification for the
 * actual UI update.
 *
 * Check required : That there is indeed a different employee selected. 
 * If not, we should not send any updates, events etc.
 */
public void setEmployee(Employee employee) {
	if (employee != fEmployee) {
		fEmployee= employee;
		notifyChange();
	}	
}
/**
 * Set the newValue at the respective key for the
 * receiver
 */
public void setValueAt(Object newValue, String key) {
	String stringValue = String.valueOf(newValue);
	if (key.equals("Name")) {
		fEmployee.setName(stringValue);
		return;
	}
	if (key.equals("Title")) {
		fEmployee.setTitle(stringValue);
		return;
	}
}
}
