package com.ibm.ulc.examples.carRental.model;

/**
 * Array utilities class 
 * (To make the package running under JDK 1.1).
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class ArrayExtensions {
/**
 * Arrays constructor comment.
 */
public ArrayExtensions() {
	super();
}
/**
 * Sort the elements between left and right in values (left<=right)
 * wrt. comparator .
 *
 * Creation date: (31.01.00 17:25:48)
 * @param objects java.lang.Object[]
 * @param left int
 * @param right int
 * @param comp Comparator
 */
protected static void quickSort(Object[] objects, int left, int right, Comparator comp) {
	int original_left= left;
	int original_right= right;
	
	Object mid= objects[(left + right) / 2]; 
	do { 
		while (comp.compare(objects[left], mid)<0) { 
			left++; 
		}
		// now: objects[left] ">=" mid
		while (comp.compare(mid, objects[right])<0) { 
			right--; 
		}
		// now: mid ">=" objects[right]
		if (left <= right) { 
			Object tmp= objects[left]; 
			objects[left]= objects[right]; 
			objects[right]= tmp;
			// now: objects[left] "<=" mid "<=" objects[right]
			
			left++; 
			right--; 
		} 
	} while (left <= right);
	// now: right < left
	
	if (original_left < right) {
		quickSort(objects, original_left, right, comp); 
	}	
	if (left < original_right) {
		 quickSort(objects, left, original_right, comp); 
	}
}
/**
 * Sorts the specified array of objects according to the order induced by
 * the specified comparator.
 *
 * Creation date: (31.01.00 17:22:54)
 * @param a java.lang.Object[]
 * @param c com.ibm.ulc.examples.carRental.model.Comparator
 */
public static void sort(Object[] a, Comparator c) {
	if (a.length>0) {
		quickSort(a, 0, a.length-1, c);
	}
}
}
