package com.ibm.ulc.examples.carRental.model;

import java.util.Vector;
/**
 * Abstract superclass for all persistent READONLY objects (not changed by application execution).
 *
 * @author: Markus Marzetta (CS-ZRH)
 */

abstract public class FinalPersistentObject extends PersistentObject {

	protected String fName = "";
/**
 * FinalPersistentObject constructor comment.
 */
public FinalPersistentObject() {
	super();
}
/**
 * FinalPersistentObject constructor comment.
 * @param id java.lang.String
 */
public FinalPersistentObject(String id) {
	super(id);
}
/**
 * FinalPersistentObject constructor comment.
 * @param id java.lang.String
 */
public FinalPersistentObject(String id, String name) {
	super(id);
	fName = name;
}
/**
 * Answer the name of the receiver.
 * @return java.lang.String
 */
public String getName() {
	return fName;
}
}
