package com.ibm.ulc.examples.carRental.views;

import java.util.Date;
import java.util.Calendar;
import java.util.GregorianCalendar;
import com.ibm.ulc.examples.carRental.model.Location;

/**
 * Adapters used to show locations in a tree widget.
 * 
 * @author: Markus Marzetta (CS-ZRH)
 */

public class LocationNode extends WrapperNode {
/**
 * LocationNode constructor comment.
 */
public LocationNode() {
	super();
}
/**
 * LocationNode constructor comment.
 * @param model com.ibm.ulc.examples.carRental.model.FinalPersistentObject
 */
public LocationNode(com.ibm.ulc.examples.carRental.model.FinalPersistentObject model) {
	super(model);
}
/**
 * LocationNode constructor comment.
 * @param model com.ibm.ulc.examples.carRental.model.FinalPersistentObject
 * @param parent com.ibm.ulc.examples.carRental.views.AbstractLocationNode
 */
public LocationNode(com.ibm.ulc.examples.carRental.model.FinalPersistentObject model, AbstractLocationNode parent) {
	super(model, parent);
}
/**
 * Answer an empty collection of location nodes (type choice arbitrary).
 */
protected WrapperNode[] computeChildren() {
	return new LocationNode[0];
}
/**
 * Answer the model casted to type Location.
 * 
 * Creation date: (30.12.99 16:11:08)
 * @return com.ibm.ulc.examples.carRental.model.Location
 */
protected Location getLocation() {
	return (Location) fModel;
}
/**
 * Perform the getMapUrl method.
 * @return java.lang.String
 */
public String getMapUrl() {
	/* Perform the getMapUrl method. */
	return getLocation().getMapUrl();
}
/**
 * Answer the type of the node.
 *
 * @return java.lang.String
 */
public String getNodeType() {
	/* Perform the getNodeType method. */
	return LOCATION_T;
}
/**
 * Answer whether the receiver is a location node or not.
 *
 * @return boolean
 */
public boolean isLocationNode() {
	/* Perform the isLocationNode method. */
	return true;
}
/**
 * Answer true, if the receiver is a location
 * that is open right now.
 *
 * @return boolean
 */
public boolean isOpen() {
	Calendar nowCal= new GregorianCalendar();
	long nowUTCMillis =nowCal.getTime().getTime()
			-nowCal.get(Calendar.ZONE_OFFSET)
			-nowCal.get(Calendar.DST_OFFSET);
	return getLocation().isOpenAt(new Date(nowUTCMillis));
}
}
