package com.ibm.ulc.examples.carRental.views;

import com.ibm.ulc.examples.carRental.model.DataAccessor;
import com.ibm.ulc.examples.carRental.model.Country;
import com.ibm.ulc.examples.carRental.model.Location;

/**
 * Root object for displaying AbstractLocationNodes in a tree widget.
 *
 * @author: Markus Marzetta (CS-ZRH)
 */
public class RootNode extends AbstractLocationNode {
/**
 * RootNode constructor comment.
 */
public RootNode() {
	super();
}
/**
 * Answer a cuntry node for each country
 * that has at least a location.
 */
protected WrapperNode[] computeChildren() {
	DataAccessor dAcc= dataAccessor();
	Country[] countries= dAcc.getLocationCountriesSortedByName();

	CountryNode[] cNodes= new CountryNode[countries.length];
	for (int i=0; i<cNodes.length; i++) {
		cNodes[i]= new CountryNode(countries[i],this);
	}
	return cNodes;
}
}
